/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.filial;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosUsuarios;
import jalis.comum.Variaveis;
import jalis.util.CheckItemFiltro;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.ManualFocusPolicy;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.CorTableCellRenderer;
import jalis.util.tabela.ModeloResultSet;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.TableModel;

public class DialogoFiltroFilialTriagem
extends JDialog
implements ActionListener {
    private static final String ULTIMO_FILTRO = "DialogoFiltroFilialTriagem.ultimoFiltro";
    private static final String SELECIONADO = "selecionado";
    private static final String CODIGO_REQUISICAO_PAI = "codigorequisicaopai";
    private JButton buttonConsultar = ComponenteFactory.novoJButton("Consultar", '\u0000', this);
    private JButton buttonDesmarcarTodos = ComponenteFactory.novoJButton("Desmarcar Todos", 'D', this);
    private JButton buttonMarcarTodos = ComponenteFactory.novoJButton("Selecionar Todos", 'S', this);
    private JButton buttonOK = ComponenteFactory.novoJButton("OK", 'O', this);
    private JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this);
    private JButton buttonDataIni = ComponenteFactory.novoJButton(this, null, new Dimension(20, 20), true);
    private JButton buttonDataFin = ComponenteFactory.novoJButton(this, null, new Dimension(20, 20), true);
    private TTextField textDataIni = new TTextField(10, 4);
    private TTextField textDataFim = new TTextField(10, 4);
    private TTextField textHoraIni = new TTextField(5, 6);
    private TTextField textHoraFin = new TTextField(5, 6);
    private JCheckBox checkboxIntervaloHora = new JCheckBox("Intervalo de hora");
    private JComboBox comboTipoData = new JComboBox<String>(new String[]{"Requisi\u00e7\u00e3o", "Coleta"});
    private JTable tableReq = new JTable();
    private ModeloResultSet modReq = new ModeloResultSet("Filial", "fil_codigo", "Requisi\u00e7\u00e3o", "req_codigo", "Paciente", "pac_nome", "Data", "req_data", "", "selecionado");
    private CheckItemFiltro itemColeta;
    private CheckItemFiltro itemDestino;
    private CheckItemFiltro itemConvenio;
    private CheckItemFiltro itemSetor;
    private CheckItemFiltro itemFilial;
    private boolean ok;
    private String requisicao;

    public static DialogoFiltroFilialTriagem novaInstancia(Object pai) {
        if (pai instanceof Frame) {
            return new DialogoFiltroFilialTriagem((Frame)pai);
        }
        if (pai instanceof Dialog) {
            return new DialogoFiltroFilialTriagem((Dialog)pai);
        }
        return null;
    }

    public DialogoFiltroFilialTriagem(Frame pai) {
        super(pai, "Filtros", true);
        this.iniciar();
    }

    public DialogoFiltroFilialTriagem(Dialog pai) {
        super(pai, "Filtros", true);
        this.iniciar();
    }

    public boolean getOk() {
        return this.ok;
    }

    public List<Registro> getRequisicoesSelecionados() {
        ArrayList<Registro> sel = new ArrayList<Registro>();
        for (Registro reg : this.modReq.getRegistros()) {
            if (!reg.getBoolean(SELECIONADO)) continue;
            sel.add(reg);
        }
        return sel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.buttonOK || o == this.buttonCancelar) {
            this.ok = o == this.buttonOK;
            this.dispose();
        } else if (o == this.buttonMarcarTodos || o == this.buttonDesmarcarTodos) {
            boolean marcar = o == this.buttonMarcarTodos;
            for (Registro reg : this.modReq.getRegistros()) {
                reg.setValor(SELECIONADO, marcar);
            }
            this.modReq.fireTableDataChanged();
        } else if (o == this.modReq) {
            boolean marcar = o == this.buttonMarcarTodos;
            for (Registro reg : this.modReq.getRegistros()) {
                reg.setValor(SELECIONADO, marcar);
            }
            this.modReq.fireTableDataChanged();
        } else if (o == this.buttonDataIni) {
            Funcoes.mostraData(this.textDataIni, this.buttonDataIni, (JPanel)this.buttonDataIni.getParent(), true);
        } else if (o == this.buttonDataFin) {
            Funcoes.mostraData(this.textDataFim, this.buttonDataFin, (JPanel)this.buttonDataFin.getParent(), true);
        } else if (o == this.buttonConsultar) {
            this.consultarRequisicoes();
            this.gravarParametros();
        }
    }

    private void consultarRequisicoes() {
        if (this.checkboxIntervaloHora.isSelected() && Funcoes.textoVazio(this.textHoraIni)) {
            Funcoes.mensagem(this, "Informe a hora inicial.", 2);
            ScreenUtil.requisitarFoco(this.textHoraIni);
            return;
        }
        Statement st = Conexao.getStatement();
        if (st != null) {
            try {
                this.modReq.limpar();
                ResultSet res = Conexao.executeQuery(st, this.getSelect());
                while (res.next()) {
                    Registro reg = new Registro(res);
                    reg.setValor("req_data", Funcoes.formataData("dd/MM/yyyy", res.getDate("req_data")));
                    this.modReq.addRegistro(reg);
                }
                this.modReq.fireTableDataChanged();
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
            }
        }
    }

    private String getSelect() {
        StringBuilder bui = new StringBuilder();
        String dataFiltro = new String("a.req_data");
        String horaFiltro = new String("a.req_hora");
        if (this.comboTipoData.getSelectedIndex() == 1) {
            dataFiltro = "cast(c.exr_datamaterial as date)";
            horaFiltro = "date_trunc('minute' ,cast(c.exr_datamaterial as time))";
        }
        try {
            boolean agruparMultiguias;
            bui.append("select distinct \n");
            boolean bl = agruparMultiguias = ParametrosGerais.isAgruparGuiasInterface() || DBUtil.requisicaoAgrupaMultiguiasLabExterno(Conexao.getStatement(), Variaveis.filialPadrao, this.requisicao);
            if (agruparMultiguias) {
                bui.append("     COALESCE(pegacodigomultiguiamae(a.fil_codigo, a.req_codigo), a.req_codigo) as ").append(CODIGO_REQUISICAO_PAI);
            } else {
                bui.append("     a.req_codigo as ").append(CODIGO_REQUISICAO_PAI);
            }
            bui.append("  ,a.fil_codigo, a.req_codigo, a.req_data, a.req_hora, a.req_dum, a.req_obs, \n");
            bui.append("  a.req_peso, a.req_altura, a.req_anomes, a.req_idade, a.req_urgente, \n");
            bui.append("  b.pac_codigo, b.pac_nome, b.pac_sexo, b.pac_datanasc, \n");
            bui.append("  false as ").append(SELECIONADO).append(", a.req_deveguia, a.req_totpago, a.req_total, \n");
            bui.append("  a.med_conselho, a.med_crm, a.med_uf, f.med_nome \n");
            bui.append("from requisicao a \n");
            bui.append("left join paciente b \n");
            bui.append("  on a.fil_codigo = b.fil_codigo and a.pac_codigo = b.pac_codigo \n");
            bui.append("left join examerequisicao c \n");
            bui.append("  on a.fil_codigo = c.fil_codigo and a.req_codigo = c.req_codigo \n");
            bui.append("left join examesetor d \n");
            bui.append("  on c.fil_codigo = d.fil_codigo and c.exa_codigo = d.exa_codigo \n");
            bui.append("left join medico f \n");
            bui.append("  on a.fil_codigo = f.fil_codigo and a.med_conselho = f.med_conselho and a.med_crm = f.med_crm and a.med_uf = f.med_uf \n");
            bui.append("where \n");
            this.geraFiltroSelecionado(bui, new String[]{Variaveis.filialPadrao}, "a.fil_codigo", false);
            this.geraFiltroSelecionado(bui, this.itemColeta.getSelecionados(), "a.col_codigo", true);
            this.geraFiltroSelecionado(bui, this.itemDestino.getSelecionados(), "a.des_codigo", true);
            this.geraFiltroSelecionado(bui, this.itemConvenio.getSelecionados(), "a.con_codigo", false);
            this.geraFiltroSelecionado(bui, this.itemSetor.getSelecionados(), "d.set_codigo", false);
            bui.append(" and a.req_excluida = false and c.exr_excluido = false ");
            bui.append(" and c.exr_datatransportesaida is null and (c.exr_situacao is null or c.exr_situacao = '')");
            if (this.checkboxIntervaloHora.isSelected()) {
                if (Funcoes.verificaData(this.textDataIni.getText()) && Funcoes.verificaHora(this.textHoraIni.getText())) {
                    bui.append(" and ((").append(dataFiltro).append(" + ").append(horaFiltro).append(") >= '");
                    bui.append(Funcoes.formataData("yyyy-MM-dd", this.textDataIni.getText())).append(" ").append(this.textHoraIni.getText());
                    bui.append("') ");
                }
                if (Funcoes.verificaData(this.textDataFim.getText()) && Funcoes.verificaHora(this.textHoraFin.getText())) {
                    bui.append(" and ((").append(dataFiltro).append(" + ").append(horaFiltro).append(") <= '");
                    bui.append(Funcoes.formataData("yyyy-MM-dd", this.textDataFim.getText())).append(" ").append(this.textHoraFin.getText());
                    bui.append("') ");
                }
            } else {
                if (Funcoes.verificaData(this.textDataIni.getText())) {
                    bui.append(" and ").append(dataFiltro).append(" >= '");
                    bui.append(Funcoes.formataData("MM/dd/yyyy", this.textDataIni.getText()));
                    bui.append("'");
                }
                if (Funcoes.verificaData(this.textDataFim.getText())) {
                    bui.append(" and ").append(dataFiltro).append(" <= '");
                    bui.append(Funcoes.formataData("MM/dd/yyyy", this.textDataFim.getText()));
                    bui.append("'");
                }
                if (Funcoes.verificaHora(this.textHoraIni.getText())) {
                    bui.append(" and ").append(horaFiltro).append(" >= '");
                    bui.append(this.textHoraIni.getText());
                    bui.append("'");
                }
                if (Funcoes.verificaHora(this.textHoraFin.getText())) {
                    bui.append(" and ").append(horaFiltro).append(" <= '");
                    bui.append(this.textHoraFin.getText());
                    bui.append("'");
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "DialogoFiltroFilial: 129");
        }
        return bui.toString();
    }

    public void geraFiltroSelecionado(StringBuilder bui, String[] valores, String campo, Boolean comAspas) {
        if (valores == null || Funcoes.textoVazio(valores[0])) {
            return;
        }
        String aux = bui.substring(bui.length() - 7, bui.length());
        if (!aux.trim().equalsIgnoreCase("where")) {
            bui.append(" and ");
        }
        bui.append(campo + " in (");
        for (int i = 0; i < valores.length; ++i) {
            bui.append(StringUtil.textoDBEscape(valores[i]));
            if (i >= valores.length - 1) continue;
            bui.append(", ");
        }
        bui.append(") ");
    }

    private void gravarParametros() {
        StringBuilder bui = new StringBuilder();
        bui.append(this.getAtributosFiltro(this.itemColeta, "coleta"));
        bui.append(this.getAtributosFiltro(this.itemDestino, "destino"));
        bui.append(this.getAtributosFiltro(this.itemConvenio, "convenio"));
        bui.append(this.getAtributosFiltro(this.itemSetor, "setor"));
        bui.append(StringUtil.getTag("dataInicial", this.textDataIni.getText()));
        bui.append(StringUtil.getTag("dataFinal", this.textDataFim.getText()));
        bui.append(StringUtil.getTag("horaInicial", this.textHoraIni.getText()));
        bui.append(StringUtil.getTag("horaFinal", this.textHoraFin.getText()));
        bui.append(StringUtil.getTag("intervaloHora", this.checkboxIntervaloHora.isSelected() ? "true" : "false"));
        bui.append(StringUtil.getTag("tipoData", this.comboTipoData.getSelectedItem().toString()));
        ParametrosUsuarios.setValor(ULTIMO_FILTRO, StringUtil.getTag("filtro", bui.toString()));
    }

    private void carregarParametros() {
        if (ParametrosUsuarios.contemParametro(ULTIMO_FILTRO)) {
            String str = StringUtil.getValor(ParametrosUsuarios.getValor(ULTIMO_FILTRO), "filtro");
            this.setAtributosFiltro(this.itemColeta, StringUtil.getValor(str, "coleta"));
            this.setAtributosFiltro(this.itemDestino, StringUtil.getValor(str, "destino"));
            this.setAtributosFiltro(this.itemConvenio, StringUtil.getValor(str, "convenio"));
            this.setAtributosFiltro(this.itemSetor, StringUtil.getValor(str, "setor"));
            this.textDataIni.setText(StringUtil.getValor(str, "dataInicial"));
            this.textDataFim.setText(StringUtil.getValor(str, "dataFinal"));
            this.textHoraIni.setText(StringUtil.getValor(str, "horaInicial"));
            this.textHoraFin.setText(StringUtil.getValor(str, "horaFinal"));
            this.comboTipoData.setSelectedItem(StringUtil.getValor(str, "tipoData"));
            this.checkboxIntervaloHora.setSelected(StringUtil.getValor(str, "intervaloHora").equals("true"));
        }
    }

    private String getAtributosFiltro(CheckItemFiltro item, String nome) {
        StringBuilder bui = new StringBuilder();
        bui.append(StringUtil.getTag("sel", String.valueOf(item.isSelected())));
        bui.append(StringUtil.getTag("item", item.getSelecionados(0)));
        return StringUtil.getTag(nome, bui.toString());
    }

    private void setAtributosFiltro(CheckItemFiltro item, String atributos) {
        if (StringUtil.getBoolean(atributos, "sel")) {
            item.setSelected(true);
            item.setSelecionados(StringUtil.getValores(atributos, "item"));
        }
    }

    private void iniciar() {
        this.getContentPane().setLayout(new BorderLayout());
        JPanel panelAux = new JPanel(new BorderLayout());
        this.getContentPane().add((Component)panelAux, "South");
        panelAux.add((Component)ComponenteFactory.novoJPanelFlowLayout(0, this.buttonMarcarTodos, this.buttonDesmarcarTodos), "West");
        panelAux.add((Component)ComponenteFactory.novoJPanelFlowLayout(2, this.buttonOK, this.buttonCancelar), "East");
        panelAux = ComponenteFactory.novoJPanel(new BorderLayout(), BorderFactory.createTitledBorder("Requisi\u00e7\u00f5es"));
        this.getContentPane().add((Component)panelAux, "Center");
        this.modReq.setColunaEditavel(SELECIONADO);
        this.tableReq = ComponenteFactory.novoJTable((TableModel)this.modReq, 30, 75, 0, 85, 25);
        this.modReq.setOrdenarColunas(true);
        this.tableReq.getTableHeader().addMouseListener(this.modReq);
        this.tableReq.setDefaultRenderer(String.class, CorTableCellRenderer.novaInstancia(4, 4, -1, 4));
        JScrollPane scroll = new JScrollPane(this.tableReq);
        scroll.setPreferredSize(new Dimension(scroll.getPreferredSize().width, 250));
        panelAux.add((Component)scroll, "Center");
        panelAux = ComponenteFactory.novoJPanel(new GridBagLayout(), BorderFactory.createTitledBorder("Filtros"));
        this.getContentPane().add((Component)panelAux, "North");
        GridBagConstraints cons = new GridBagConstraints();
        cons.fill = 1;
        cons.insets = new Insets(1, 1, 1, 1);
        cons.gridwidth = 1;
        cons.gridheight = 1;
        cons.weightx = 0.5;
        cons.weighty = 0.5;
        cons.gridx = 0;
        cons.gridy = 0;
        this.itemColeta = new CheckItemFiltro("Coleta", "Filtrar", "Filtrando coletas", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemColeta.setDados("coletas", new String[]{"col_codigo", "col_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemColeta.setColunaHint(1);
        panelAux.add((Component)this.itemColeta, cons);
        cons.gridx = 0;
        cons.gridy = 1;
        this.itemDestino = new CheckItemFiltro("Destino", "Filtrar", "Filtrando destinos", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemDestino.setDados("destino", new String[]{"des_codigo", "des_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemDestino.setColunaHint(1);
        panelAux.add((Component)this.itemDestino, cons);
        cons.gridx = 0;
        cons.gridy = 2;
        this.itemConvenio = new CheckItemFiltro("Conv\u00eanio", "Filtrar", "Filtrando conv\u00eanios", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemConvenio.setDados("convenios", new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Fantasia"}, new int[]{70, 0});
        this.itemConvenio.setColunaHint(1);
        panelAux.add((Component)this.itemConvenio, cons);
        cons.gridx = 0;
        cons.gridy = 3;
        this.itemSetor = new CheckItemFiltro("Setores", "Filtrar", "Filtrando setores", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemSetor.setDados("setores", new String[]{"set_codigo", "set_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemSetor.setColunaHint(1);
        panelAux.add((Component)this.itemSetor, cons);
        cons.gridx = 1;
        cons.gridy = 0;
        panelAux.add((Component)new JLabel("Data Inicial:"), cons);
        cons.gridx = 1;
        cons.gridy = 1;
        panelAux.add((Component)new JLabel("Data Final:"), cons);
        cons.gridx = 1;
        cons.gridy = 2;
        panelAux.add((Component)new JLabel("Hora Inicial:"), cons);
        cons.gridx = 1;
        cons.gridy = 3;
        panelAux.add((Component)new JLabel("Hora Final:"), cons);
        cons.gridx = 2;
        cons.gridy = 0;
        this.buttonDataIni.setFocusable(false);
        panelAux.add((Component)ComponenteFactory.novoJPanelBorderLayout(this.textDataIni, null, null, this.buttonDataIni, null), cons);
        cons.gridx = 2;
        cons.gridy = 1;
        this.buttonDataFin.setFocusable(false);
        panelAux.add((Component)ComponenteFactory.novoJPanelBorderLayout(this.textDataFim, null, null, this.buttonDataFin, null), cons);
        cons.gridx = 2;
        cons.gridy = 2;
        panelAux.add((Component)this.textHoraIni, cons);
        cons.gridx = 2;
        cons.gridy = 3;
        panelAux.add((Component)this.textHoraFin, cons);
        cons.gridx = 1;
        cons.gridy = 4;
        panelAux.add((Component)new JLabel("Filtrar por data:"), cons);
        cons.gridx = 2;
        cons.gridy = 4;
        panelAux.add((Component)this.comboTipoData, cons);
        cons.gridy = 4;
        cons.gridx = 0;
        cons.gridwidth = 1;
        panelAux.add((Component)this.checkboxIntervaloHora, cons);
        cons.gridx = 2;
        cons.gridy = 6;
        cons.gridwidth = 1;
        panelAux.add((Component)this.buttonConsultar, cons);
        Funcoes.montaEnter((JComponent)this.getContentPane());
        ScreenUtil.addActionMap((JComponent)this.getContentPane(), KeyStroke.getKeyStroke(113, 0, true), "F2", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DialogoFiltroFilialTriagem.this.textDataIni.hasFocus()) {
                    Funcoes.mostraData(DialogoFiltroFilialTriagem.this.textDataIni, DialogoFiltroFilialTriagem.this.buttonDataIni, (JPanel)DialogoFiltroFilialTriagem.this.buttonDataIni.getParent(), true);
                } else if (DialogoFiltroFilialTriagem.this.textDataFim.hasFocus()) {
                    Funcoes.mostraData(DialogoFiltroFilialTriagem.this.textDataFim, DialogoFiltroFilialTriagem.this.buttonDataFin, (JPanel)DialogoFiltroFilialTriagem.this.buttonDataFin.getParent(), true);
                }
            }
        });
        this.tableReq.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int row = DialogoFiltroFilialTriagem.this.tableReq.getSelectedRow();
                DialogoFiltroFilialTriagem.this.tableReq.setFocusable(true);
                if (row >= 0 && e.getKeyCode() == 32) {
                    DialogoFiltroFilialTriagem.this.modReq.getRegistro(row).setValor(DialogoFiltroFilialTriagem.SELECIONADO, !DialogoFiltroFilialTriagem.this.modReq.getRegistro(row).getBoolean(DialogoFiltroFilialTriagem.SELECIONADO));
                    DialogoFiltroFilialTriagem.this.modReq.fireTableRowsUpdated(row, row);
                }
            }
        });
        ManualFocusPolicy policy = new ManualFocusPolicy();
        policy.setFirstComponent(this, this.itemFilial);
        policy.setNextFocusableComponent(this.itemFilial, this.itemFilial);
        policy.setNextFocusableComponent(this.itemColeta, this.itemDestino);
        policy.setNextFocusableComponent(this.itemDestino, this.itemConvenio);
        policy.setNextFocusableComponent(this.itemConvenio, this.itemSetor);
        policy.setNextFocusableComponent(this.itemSetor, this.textDataIni);
        policy.setNextFocusableComponent(this.textDataIni, this.textDataFim);
        policy.setNextFocusableComponent(this.textDataFim, this.textHoraIni);
        policy.setNextFocusableComponent(this.textHoraIni, this.textHoraFin);
        policy.setNextFocusableComponent(this.textHoraFin, this.comboTipoData);
        policy.setNextFocusableComponent(this.comboTipoData, this.checkboxIntervaloHora);
        policy.setNextFocusableComponent(this.checkboxIntervaloHora, this.buttonConsultar);
        policy.setNextFocusableComponent(this.buttonConsultar, this.tableReq);
        this.setFocusTraversalPolicy(policy);
        this.carregarParametros();
        this.pack();
        this.setSize(this.getPreferredSize());
        this.setResizable(false);
        ScreenUtil.centralizar(this);
    }
}

