/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.filial;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Pesquisas;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.informacao.InfoRequisicao;
import jalis.laboratorio.GlassPaneMensagem;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.exportacao.integracao.IntegracaoUtil;
import jalis.laboratorio.relatorios.triagem.filial.RelatorioLoteEnviadoFilial;
import jalis.laboratorio.triagem.apoio.DescritorCodigoEtiqueta;
import jalis.laboratorio.triagem.filial.CorTableCellRendererExames;
import jalis.laboratorio.triagem.filial.CorTableCellRendererRequisicao;
import jalis.laboratorio.triagem.filial.DialogoFiltroFilialTriagem;
import jalis.laboratorio.triagem.soroteca.util.TuboDao;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.model.bean.triagem.LoteFilialBean;
import jalis.model.bean.triagem.LoteFilialExameRequisicaoBean;
import jalis.model.bean.triagem.LoteFilialRequisicaoBean;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.cadastro.auxiliares.EstacaoVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.recepcao.ExameRequisicaoVO;
import jalis.model.vo.recepcao.RequisicaoVO;
import jalis.relatorio.Gerador;
import jalis.service.recepcao.ExameRequisicaoService;
import jalis.service.recepcao.RequisicaoService;
import jalis.service.triagem.LoteFilialExameRequisicaoService;
import jalis.service.triagem.LoteFilialRequisicaoService;
import jalis.service.triagem.LoteFilialService;
import jalis.util.ArraysUtil;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.Legenda;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.SplashMensagem;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.TableUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.CorTableCellRenderer;
import jalis.util.tabela.ModeloResultSet;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;

public class CriarLoteFilial
extends JPanel
implements ActionListener,
KeyListener,
ListSelectionListener {
    private static final String EXA_EXPORTADO = "exa_exportado";
    private static final String EXA_SELECIONADO = "exa_transporte";
    private static final String BACKUP_LISTA_EXAMES = "backup_lista_exames";
    private static final String COLUNA_CHAVE = "chave";
    private static final String CAMPO_LISTA_EXAMES = "listaexames";
    private static final String CAMPO_MULTIGUIAS = "multiguias";
    private static final int COLUNA_REQUISICOES_FILIAL = 0;
    private static final int COLUNA_REQUISICOES_REQUISICAO = 1;
    private static final int COLUNA_REQUISICOES_PACIENTE = 2;
    private static final int COLUNA_REQUISICOES_DATA = 3;
    private static final int COLUNA_REQUISICOES_MULTIGUIAS = 4;
    private static final int COLUNA_EXAMES_CODIGO = 0;
    private static final int COLUNA_EXAMES_DESCRICAO = 1;
    private static final int COLUNA_EXAMES_MATERIAL = 2;
    private static final int COLUNA_EXAMES_SELECAO = 3;
    private static final int COLUNA_OUTROS_NAO_EXPORTAR = 6;
    private static final Color COR_TRANSPORTE = Tipos.COR_TRANSPORTE[0];
    private static final Color COR_FALTA_MATERIAL = Tipos.COR_FALTA_MATERIAL[0];
    private static final Color COR_RECOLETA = Tipos.COR_RECOLETA[0];
    private static final Color COR_REPETICAO = Tipos.COR_REPETICAO[0];
    private static final Color COR_A_COLETAR = Tipos.COR_A_COLETAR[0];
    private TTextField textRequisicao = new TTextField(ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo(), 1);
    private JButton buttonBuscaReq = ComponenteFactory.novoJButton(this, null, new Dimension(20, 20), true);
    private JButton buttonFiltrar = ComponenteFactory.novoJButton("Filtrar", 'i', this);
    private JButton buttonNovo = ComponenteFactory.novoJButton("Novo", 'N', this);
    private JButton buttonSalvar = ComponenteFactory.novoJButton("Salvar", 'S', this, null, null, false);
    private JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this);
    private JButton buttonFechar = ComponenteFactory.novoJButton("Fechar", 'F', this);
    private JTable tableReq;
    private JTable tableExa;
    private JTable tableOutrosExa;
    private ModeloGridTable modReq = new ModeloGridTable(new String[]{"Fil.", "Requisi\u00e7\u00e3o", "Paciente", "Data"});
    private ModeloResultSet modExa = new ModeloResultSet(new String[]{"C\u00f3digo", "exa_codigo", "Exame", "exa_descricao", "Mat.", "mco_abreviatura", "#", "etiquetadigitada"}){

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 3;
        }

        public Class getColumnClass(int c) {
            if (c == 3) {
                return Boolean.class;
            }
            return super.getColumnClass(c);
        }
    };
    private ModeloResultSet modOutrosExa = new ModeloResultSet("C\u00f3digo", "exa_codigo", "Exame", "exa_descricao", "Mat.", "mco_abreviatura", "Sit.", "exr_situacao");
    private CorTableCellRendererRequisicao rendererReq = CorTableCellRendererRequisicao.novaInstancia(4, 4, -1, 4);
    private CorTableCellRendererExames rendererExa = CorTableCellRendererExames.novaInstancia(0, -1, 0, 0);
    private CorTableCellRenderer rendererOutrosExa = CorTableCellRenderer.novaInstancia(0, -1, 0, 0);
    private LoteFilialBean loteAux = new LoteFilialBean();
    private boolean acessoAdicionarPorTubo = Acesso.getAcesso(CriarLoteFilial.getModuloAdicionarPorTubo());
    private boolean salvandoLote;
    private String filial;
    protected static final String[] campos = new String[]{"fil_codigo", "req_codigo", "pac_nome", "req_data", "multiguias", "listaexames", "listaexamesnaoexportar", "med_nome", "pac_datanasc", "req_idade", "req_peso", "req_totpago", "req_obs", "chave", "pac_codigo", "req_anomes", "med_conselho", "pac_sexo", "req_total", "req_dum", "med_uf", "req_hora", "req_deveguia", "med_crm", "req_altura", "req_dclinicos", "req_urgente"};
    static String SQL;

    public CriarLoteFilial() {
        this.iniciar();
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0301200100");
    }

    public static long getModuloAdicionarPorTubo() {
        return Long.parseLong("0301200101");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.buttonFechar) {
            if (this.getParent() != null) {
                this.getParent().removeAll();
            }
            this.setVisible(false);
        } else if (o == this.buttonBuscaReq) {
            this.pesquisarRequisicao();
        } else if (o == this.buttonFiltrar) {
            DialogoFiltroFilialTriagem dfe = DialogoFiltroFilialTriagem.novaInstancia(this.getTopLevelAncestor());
            if (dfe != null) {
                dfe.setVisible(true);
                if (dfe.getOk()) {
                    for (Registro reg : dfe.getRequisicoesSelecionados()) {
                        if (!Funcoes.processarFuncaoNumeroTubo(null, this.textRequisicao)) continue;
                        this.adicionarRequisicao(reg, "", reg.getInt("req_codigo"), true);
                    }
                    this.atualizarModeloRequisicoes();
                    TableUtil.selecionarLinha(this.tableReq, this.tableReq.getRowCount() - 1);
                }
            }
        } else if (o == this.buttonCancelar && Funcoes.mensagem(this, "Deseja cancelar a cria\u00e7\u00e3o de lote?", 4) == 0) {
            this.salvandoLote = false;
            this.limpar();
        } else if (o == this.buttonSalvar) {
            this.gravarLote();
        } else if (o == this.buttonNovo) {
            this.novoLote();
        }
        this.habilitarDesabilitarBotoes();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Registro reg;
        this.rendererExa.limpar();
        this.modExa.limpar();
        this.rendererOutrosExa.limpar();
        this.modOutrosExa.limpar();
        if (this.tableReq.getSelectedRowCount() == 1 && this.tableReq.getSelectedRow() > -1 && (reg = this.objectToReg(this.tableReq.getSelectedRow())) != null) {
            this.modExa.addRegistros((Collection)reg.getValor(CAMPO_LISTA_EXAMES));
            this.modOutrosExa.addRegistros((Collection)reg.getValor(campos[6]));
            this.renderizaTabela(this.modOutrosExa, this.rendererOutrosExa);
            this.modExa.fireTableDataChanged();
            this.modOutrosExa.fireTableDataChanged();
        }
    }

    private void renderizaTabela(ModeloResultSet modExa, CorTableCellRenderer renderer) {
        for (int i = 0; i < modExa.getRowCount(); ++i) {
            renderer.setHintLinha(i, Tipos.tipoSituacaoExame(modExa.getRegistro(i).getString("exr_situacao")));
            if (modExa.getRegistro(i).getString("exr_situacao").equals("N")) {
                renderer.setHintLinha(i, "Exame j\u00e1 est\u00e1 em Transporte");
                renderer.setCorLinha(COR_TRANSPORTE, i);
                continue;
            }
            if (modExa.getRegistro(i).getString("exr_situacao").equalsIgnoreCase("F")) {
                renderer.setCorLinha(COR_FALTA_MATERIAL, i);
                continue;
            }
            if (modExa.getRegistro(i).getString("exr_situacao").equalsIgnoreCase("R")) {
                renderer.setCorLinha(COR_RECOLETA, i);
                continue;
            }
            if (modExa.getRegistro(i).getString("exr_situacao").equalsIgnoreCase("O")) {
                renderer.setCorLinha(COR_REPETICAO, i);
                continue;
            }
            if (modExa.getRegistro(i).getString("exr_situacao").equalsIgnoreCase("T")) {
                renderer.setCorLinha(COR_A_COLETAR, i);
                continue;
            }
            if (!Funcoes.textoVazio(modExa.getRegistro(i).getString("exr_situacao"))) continue;
            renderer.setCorLinha(Color.white, i);
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        Object o = e.getSource();
        if (e.getSource() == this.tableReq && e.getKeyCode() == 127 && this.tableReq.getSelectedRowCount() > 0) {
            String msn;
            int[] indices = this.tableReq.getSelectedRows();
            String string = msn = indices.length == 1 ? "Deseja remover a requisi\u00e7\u00e3o selecionada?" : "Deseja remover as requisi\u00e7\u00f5es selecionadas?";
            if (Funcoes.mensagem(this, msn, 4) == 0) {
                for (int i = indices.length - 1; i > -1; --i) {
                    this.modReq.removeLine(indices[i]);
                }
                this.atualizarModeloRequisicoes();
                TableUtil.selecionarLinha(this.tableReq, Math.min(indices[0], this.tableReq.getRowCount() - 1));
            }
        } else if (e.getSource() == this.tableExa && this.tableExa.getSelectedRow() >= 0 && e.getKeyCode() == 127) {
            if (Funcoes.mensagem(this, "Deseja remover o exame selecionado?", 4) == 0) {
                int row = this.tableExa.getSelectedRow();
                int rowReq = this.tableReq.getSelectedRow();
                Registro req = this.objectToReg(rowReq);
                List exames = (List)req.getValor(CAMPO_LISTA_EXAMES);
                exames.remove(row);
                if (this.tableExa.getRowCount() == 1) {
                    this.modReq.removeLine(rowReq);
                    this.atualizarModeloRequisicoes();
                }
                req.setValor(CAMPO_LISTA_EXAMES, exames);
                this.valueChanged(null);
            }
        } else if (o == this.textRequisicao && e.getKeyCode() == 10 || e.getKeyChar() == '\t') {
            this.buscarRequisicaoAoPerdeFoco();
        } else if (o == this.textRequisicao && e.getKeyCode() == 113) {
            this.pesquisarRequisicao();
        } else if (!(!this.salvandoLote || o == this.textRequisicao || !Character.isDigit(e.getKeyChar()) || e.isAltDown() && e.isControlDown() && e.isShiftDown())) {
            this.textRequisicao.setText(String.valueOf(e.getKeyChar()));
            ScreenUtil.requisitarFoco(this.textRequisicao);
        }
        this.habilitarDesabilitarBotoes();
    }

    public void imprimirRelatorio() {
        Statement st = Conexao.getStatement();
        RelatorioLoteEnviadoFilial rel = new RelatorioLoteEnviadoFilial();
        ModeloGridTable modelo = null;
        String xml = "";
        try {
            xml = rel.getXMLRelatorio(st);
        }
        catch (Exception e2) {
            ErrorLogger.mostraMensagem(null, e2.getMessage(), e2.getStackTrace());
        }
        try {
            modelo = rel.getModeloDados(st, new String[]{String.valueOf(this.loteAux.getCodigo())});
        }
        catch (Exception e1) {
            ErrorLogger.mostraMensagem(null, e1.getMessage(), e1.getStackTrace());
        }
        if (modelo != null && modelo.getRowCount() > 0 && !Funcoes.textoVazio(xml)) {
            final JDialog dialogo = new JDialog((Frame)Laboratorio.getInstancia(), "Relat\u00f3rio de Lote Enviado");
            dialogo.setModal(true);
            dialogo.setSize(new Dimension(750, 600));
            dialogo.setLayout(new BorderLayout());
            Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
            gerador.setPai(dialogo.getContentPane());
            gerador.setPreVisualizar(true);
            gerador.setZoomPreVisualizar(0.5f);
            gerador.setAcaoFechar(new Runnable(){

                @Override
                public void run() {
                    dialogo.dispose();
                }
            });
            HashMap<String, Object> var = new HashMap<String, Object>();
            var.put("filtroLote", this.loteAux.getCodigo());
            try {
                gerador.executar(xml, (TableModel)modelo, var);
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            }
            ScreenUtil.centralizar(dialogo);
            dialogo.setVisible(true);
        } else {
            Funcoes.mensagem(this, "N\u00e3o h\u00e1 layout configurado para o relat\u00f3rio.", 2);
        }
    }

    private void voltarExamesQueNaoSeraoExportados() {
        for (int i = 0; i < this.modReq.getRowCount(); ++i) {
            Registro req = this.objectToReg(i);
            req.setValor(CAMPO_LISTA_EXAMES, req.getValor(BACKUP_LISTA_EXAMES));
        }
    }

    private void gravarLote() {
        if (this.qtdeExamesSelecionados() == 0) {
            Funcoes.mensagem(this, "Nenhum exame foi selecionado.", 2);
            ScreenUtil.requisitarFoco(this.textRequisicao);
            return;
        }
        SplashMensagem splash = new SplashMensagem();
        splash.mostrar("Salvando...");
        FilialVO filial = new FilialVO();
        filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
        UsuarioVO usuario = new UsuarioVO();
        usuario.setFilial(filial);
        usuario.setCodigo(Variaveis.login);
        EstacaoVO estacao = new EstacaoVO();
        estacao.setCodigo(Integer.parseInt(Variaveis.codigoEstacao));
        LoteFilialBean lote = new LoteFilialBean();
        lote.setFilial(filial);
        lote.setDataHora(new Date());
        lote.setUsuarioEnviou(usuario);
        lote.setEstacao(estacao);
        try {
            new LoteFilialService().gravaAutoCopiaSemCommit(lote, 0, Variaveis.filialPadrao, null);
        }
        catch (Exception e) {
            this.anularSQL();
            ErrorLogger.mostraMensagem(this.getTopLevelAncestor(), "N\u00e3o foi poss\u00edvel salvar lote.\n" + e.getMessage(), e.getStackTrace());
            splash.apagar();
            return;
        }
        ExameRequisicaoVO exameRequisicaoVO = null;
        ArrayList<LoteFilialRequisicaoBean> listaRequisicoesBean = new ArrayList<LoteFilialRequisicaoBean>();
        ArrayList<LoteFilialExameRequisicaoBean> listaExamesBean = new ArrayList<LoteFilialExameRequisicaoBean>();
        HashSet<String> reqAdicionadas = new HashSet<String>();
        for (int i = 0; i < this.modReq.getRowCount(); ++i) {
            String[] requisicoes;
            Registro req = this.objectToReg(i);
            List exames = (List)req.getValor(CAMPO_LISTA_EXAMES);
            ArrayList<Registro> listaExamesRegistro = new ArrayList<Registro>();
            for (Registro registro : exames) {
                if (!registro.getBoolean("etiquetadigitada")) continue;
                listaExamesRegistro.add(registro);
                for (String requisicaoKey : requisicoes = registro.getString("chaveexameagrupado").split("\\-")) {
                    if (reqAdicionadas.contains(requisicaoKey)) continue;
                    HashMap<String, Object> chaveReq = new HashMap<String, Object>();
                    chaveReq.put("fil_codigo", Variaveis.filialPadrao);
                    chaveReq.put("req_codigo", requisicaoKey);
                    RequisicaoVO requisicaoVO = null;
                    try {
                        requisicaoVO = (RequisicaoVO)new RequisicaoService().getVO(chaveReq);
                    }
                    catch (ThreadDaoException e) {
                        this.anularSQL();
                        ErrorLogger.mostraMensagem(this.getTopLevelAncestor(), "N\u00e3o foi poss\u00edvel carregar os requisi\u00e7\u00e3o.\n" + e.getMessage(), e.getStackTrace());
                        splash.apagar();
                        return;
                    }
                    LoteFilialRequisicaoBean requisicao = new LoteFilialRequisicaoBean();
                    requisicao.setFilial(filial);
                    requisicao.setCodigo(lote.getCodigo());
                    requisicao.setRequisicao(requisicaoVO);
                    if (listaExamesRegistro.size() > 0) {
                        listaRequisicoesBean.add(requisicao);
                    }
                    reqAdicionadas.add(requisicaoKey);
                }
            }
            if (listaExamesRegistro.size() > 0) {
                reqAdicionadas.clear();
                for (Registro exa : listaExamesRegistro) {
                    for (String requisicao : requisicoes = exa.getString("chaveexameagrupado").split("\\-")) {
                        if (reqAdicionadas.contains(requisicao)) continue;
                        HashMap<String, Object> chaveExa = new HashMap<String, Object>();
                        chaveExa.put("fil_codigo", Variaveis.filialPadrao);
                        chaveExa.put("req_codigo", requisicao);
                        chaveExa.put("exa_codigo", exa.getValor("exa_codigo"));
                        chaveExa.put("mco_codigo", exa.getValor("mco_codigo"));
                        try {
                            exameRequisicaoVO = (ExameRequisicaoVO)new ExameRequisicaoService().getVO(chaveExa);
                        }
                        catch (Exception e) {
                            this.anularSQL();
                            ErrorLogger.mostraMensagem(this.getTopLevelAncestor(), "N\u00e3o foi poss\u00edvel carregar os exames.\n" + e.getMessage(), e.getStackTrace());
                            splash.apagar();
                            return;
                        }
                        LoteFilialExameRequisicaoBean exame = new LoteFilialExameRequisicaoBean();
                        exame.setCodigo(lote.getCodigo());
                        exame.setExame(exameRequisicaoVO.getExame());
                        exame.setFilial(lote.getFilial());
                        exame.setMaterial(exameRequisicaoVO.getMaterial());
                        RequisicaoVO requisicaoVO = new RequisicaoVO();
                        requisicaoVO.setCodigo(Integer.parseInt(requisicao));
                        exame.setRequisicao(requisicaoVO);
                        listaExamesBean.add(exame);
                        reqAdicionadas.add(requisicao);
                    }
                    reqAdicionadas.clear();
                }
            }
            reqAdicionadas.clear();
        }
        for (LoteFilialRequisicaoBean requisicao : listaRequisicoesBean) {
            try {
                new LoteFilialRequisicaoService().insert(requisicao, 0, Variaveis.filialPadrao, null);
            }
            catch (Exception e) {
                this.anularSQL();
                ErrorLogger.mostraMensagem(this.getTopLevelAncestor(), "N\u00e3o foi poss\u00edvel salvar requisicao.\n" + e.getMessage(), e.getStackTrace());
                splash.apagar();
                return;
            }
        }
        for (LoteFilialExameRequisicaoBean exame : listaExamesBean) {
            try {
                new LoteFilialExameRequisicaoService().insert(exame, 0, Variaveis.filialPadrao, null);
            }
            catch (Exception e) {
                this.anularSQL();
                ErrorLogger.mostraMensagem(this.getTopLevelAncestor(), "N\u00e3o foi poss\u00edvel gravar exames.\n" + e.getMessage(), e.getStackTrace());
                splash.apagar();
                return;
            }
            this.atualizaExameRequisicao(exame);
        }
        this.arquivarSQL();
        this.loteAux = lote;
        splash.apagar();
        this.salvandoLote = false;
        Funcoes.mensagem(this, "Lote criado com c\u00f3digo: " + this.loteAux.getCodigo(), 2);
        this.habilitarDesabilitarBotoes();
        this.imprimirRelatorio();
        this.limpar();
    }

    public int qtdeExamesSelecionados() {
        int qtdeExamesSelecionados = 0;
        for (int i = 0; i < this.modReq.getRowCount(); ++i) {
            Registro req = this.objectToReg(i);
            List exa = (List)req.getValor(CAMPO_LISTA_EXAMES);
            for (Registro registro : exa) {
                if (!registro.getBoolean("etiquetadigitada")) continue;
                ++qtdeExamesSelecionados;
            }
        }
        return qtdeExamesSelecionados;
    }

    private void atualizaExameRequisicao(LoteFilialExameRequisicaoBean exameRequisicaoLote) {
        Statement st = Conexao.getStatement();
        if (st != null) {
            try {
                DBUtil.gravaLogSituacaoExameRequisicao(Conexao.getStatement(), exameRequisicaoLote.getFilial().getCodigo().toString(), exameRequisicaoLote.getRequisicao().getCodigo().toString(), exameRequisicaoLote.getExame().getCodigo().toString(), exameRequisicaoLote.getMaterial().getCodigo().toString(), "N", false);
                StringBuilder bui = new StringBuilder();
                bui.append("update examerequisicao ");
                bui.append("set exr_datatransportesaida = '").append(Funcoes.formataData("yyyy-MM-dd HH:mm:ss", new Date())).append("' ");
                bui.append("    ,usr_codtransportesaida = '").append(Variaveis.login).append("' ");
                bui.append("    ,exr_situacao = '").append("N").append("' ");
                bui.append("where ");
                bui.append("  fil_codigo = ").append(exameRequisicaoLote.getFilial().getCodigo());
                bui.append("  and req_codigo = ").append(exameRequisicaoLote.getRequisicao().getCodigo());
                bui.append("  and exa_codigo = '").append(exameRequisicaoLote.getExame().getCodigo().toString()).append("' ");
                bui.append("  and mco_codigo = ").append(exameRequisicaoLote.getMaterial().getCodigo());
                Conexao.execute(Variaveis.filialPadrao, st, bui.toString());
                if (IntegracaoUtil.isFilialParaIntegrar(st, exameRequisicaoLote.getFilial().getCodigo().toString())) {
                    IntegracaoUtil.insereComandoLog(st, Variaveis.filialPadrao, exameRequisicaoLote.getFilial().getCodigo().toString(), bui.toString());
                }
            }
            catch (SQLException e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(this.getTopLevelAncestor(), "N\u00e3o foi poss\u00edvel gravar exames.\n" + e.getMessage(), e.getStackTrace());
                return;
            }
        }
    }

    private void pesquisarRequisicao() {
        Hashtable hash = Pesquisas.requisicao(this.getTopLevelAncestor(), Variaveis.filialPadrao, false, false, false);
        if (hash != null) {
            this.adicionarRequisicao(hash.get("req_codigo").toString(), Variaveis.filialPadrao, "");
            this.atualizarModeloRequisicoes();
            TableUtil.selecionarLinha(this.tableReq, this.tableReq.getRowCount() - 1);
            ScreenUtil.requisitarFoco(this.textRequisicao);
        }
    }

    private String trocaCodigo(String codigoRequisicao, String codRecipiente) {
        if (codigoRequisicao.trim().length() == ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
            codRecipiente = codigoRequisicao.substring(ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao());
            codigoRequisicao = codigoRequisicao.substring(ParametrosGerais.getDigitosTuboFilial(), codigoRequisicao.length() - ParametrosGerais.getDigitosTuboTubo());
            return codigoRequisicao;
        }
        return codigoRequisicao;
    }

    private int adicionarRequisicao(String codigoRequisicao, String filial, String codRecipiente) {
        String codigoReq = this.trocaCodigo(codigoRequisicao, codRecipiente);
        SituacaoReq situacao = this.verificaSituacaoRequisicao(codigoReq, filial, codRecipiente);
        if (situacao != SituacaoReq.REQ_OK) {
            String msn;
            switch (situacao) {
                case REQ_JA_ADICIONADA: {
                    msn = "A requisi\u00e7\u00e3o \"" + codigoReq + "\" j\u00e1 foi adicionada";
                    break;
                }
                case NAO_CONTEM_EXAMES: {
                    msn = "A requisi\u00e7\u00e3o \"" + codigoReq + "\" n\u00e3o cont\u00e9m exames que satisfa\u00e7am a cria\u00e7\u00e3o do lote.";
                    break;
                }
                case EXAMES_JA_EXPORTADOS: {
                    msn = "Todos os exames j\u00e1 foram exportados para a requisi\u00e7\u00e3o \"" + codigoReq + "\"";
                    break;
                }
                default: {
                    msn = "A requisi\u00e7\u00e3o \"" + codigoReq + "\" n\u00e3o foi cadastrada";
                }
            }
            Funcoes.mensagem(this, msn, 2);
            return -1;
        }
        int retorno = -1;
        try {
            String mensagemGuia = RecepcaoUtil.mensagemMultiGuias(filial, codigoReq);
            if (!Funcoes.textoVazio(mensagemGuia)) {
                Funcoes.mensagem(this, mensagemGuia, 2);
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "CriaLoteFilial");
        }
        Statement st = Conexao.getStatement();
        if (st != null) {
            try {
                boolean agruparMultiguias;
                StringBuilder bui = new StringBuilder();
                bui.append(" select a.fil_codigo ");
                boolean bl = agruparMultiguias = ParametrosGerais.isAgruparGuiasInterface() || DBUtil.requisicaoAgrupaMultiguiasLabExterno(st, filial, codigoReq);
                if (agruparMultiguias) {
                    bui.append("       ,pegacodigomultiguiamae(a.fil_codigo, a.req_codigo) as req_codigo ");
                } else {
                    bui.append("       ,a.req_codigo ");
                }
                bui.append("       ,a.req_data ");
                bui.append("       ,a.req_hora ");
                bui.append("       ,a.req_dum ");
                bui.append("       ,a.req_obs ");
                bui.append("       ,a.req_peso ");
                bui.append("       ,a.req_altura ");
                bui.append("       ,a.req_anomes ");
                bui.append("       ,a.req_idade ");
                bui.append("       ,b.pac_codigo ");
                bui.append("       ,b.pac_nome ");
                bui.append("       ,b.pac_sexo ");
                bui.append("       ,b.pac_datanasc ");
                bui.append("       ,a.req_totpago ");
                bui.append("       ,a.req_total ");
                bui.append("       ,a.req_deveguia ");
                bui.append("       ,a.med_conselho ");
                bui.append("       ,a.med_crm ");
                bui.append("       ,a.med_uf ");
                bui.append("       ,c.med_nome ");
                bui.append("       ,a.req_dclinicos ");
                bui.append("\t\t\t ,coalesce(a.req_urgente, false) as req_urgente");
                bui.append("   from requisicao a ");
                bui.append("   left join paciente b on a.fil_codigo = b.fil_codigo and a.pac_codigo = b.pac_codigo ");
                bui.append("   left join medico c on a.fil_codigo = c.fil_codigo and a.med_conselho = c.med_conselho and a.med_crm = c.med_crm and a.med_uf = c.med_uf ");
                bui.append("  where a.fil_codigo = ").append(filial);
                bui.append("    and a.req_codigo = ").append(codigoReq);
                bui.append("    and a.req_excluida = false ");
                SQL = bui.toString();
                ResultSet res = Conexao.executeQuery(st, SQL);
                if (res.next()) {
                    Registro reg = new Registro(res);
                    reg.setValor("req_data", Funcoes.formataData("dd/MM/yyyy", res.getDate("req_data")));
                    retorno = this.adicionarRequisicao(reg, codRecipiente, Integer.parseInt(codigoReq), false);
                } else {
                    Funcoes.mensagem(this, "A requisi\u00e7\u00e3o \"" + codigoReq + "\" n\u00e3o est\u00e1 cadastrada", 1);
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, e.getMessage() + "\nSQL: " + SQL, e.getStackTrace());
            }
        }
        this.habilitarDesabilitarBotoes();
        return retorno;
    }

    private int adicionarRequisicao(Registro reg, String codRecipiente, int codigoRequisicao, boolean carregarMarcado) {
        Statement st = Conexao.getStatement();
        boolean isRequisicaoAdicionada = false;
        if (st != null) {
            try {
                boolean agruparMultiguias;
                Integer[] requisicoes = null;
                boolean bl = agruparMultiguias = ParametrosGerais.isAgruparGuiasInterface() || DBUtil.requisicaoAgrupaMultiguiasLabExterno(Conexao.getStatement(), reg.getString("fil_codigo"), reg.getString("req_codigo"));
                if (agruparMultiguias) {
                    requisicoes = RecepcaoUtil.verificaMultiGuias(reg.getString("fil_codigo"), reg.getString("req_codigo"), true);
                    reg.setValor(CAMPO_MULTIGUIAS, requisicoes);
                    block2: for (int i = 0; i < this.modReq.getRowCount(); ++i) {
                        Integer[] multiguiasAdicionadas = (Integer[])this.modReq.getValueAt(i, 4);
                        if (multiguiasAdicionadas == null) continue;
                        for (Integer aux : multiguiasAdicionadas) {
                            if (aux != codigoRequisicao) continue;
                            isRequisicaoAdicionada = true;
                            continue block2;
                        }
                    }
                } else {
                    requisicoes = new Integer[]{Integer.parseInt(reg.getString("req_codigo"))};
                }
                ArrayList<Registro> exames = new ArrayList<Registro>();
                ArrayList<String> examesInserido = new ArrayList<String>();
                ArrayList<Registro> examesNaoExp = new ArrayList<Registro>();
                for (Integer req : requisicoes) {
                    StringBuilder bui = new StringBuilder();
                    bui.append("  select a.exr_descricaomaterial ");
                    bui.append("        ,a.exr_datamaterial ");
                    bui.append("        ,a.exr_volumediurese ");
                    bui.append("        ,cast(a.exr_tempodiurese as varchar) as ext_tempodiurese ");
                    bui.append("        ,a.exr_situacao ");
                    bui.append("        ,a.exr_datatransportesaida is not null as ").append(EXA_EXPORTADO);
                    bui.append("        ,b.exa_codigo ");
                    bui.append("        ,b.exa_descricao ");
                    bui.append("        ,a.exr_urgente ");
                    bui.append("        ,a.exr_situacao ");
                    bui.append("        ,c.mco_codigo ");
                    bui.append("        ,c.mco_abreviatura ");
                    bui.append("        ,c.mco_solicitarmat ");
                    bui.append("        ,c.mco_descricao ");
                    bui.append("\t      ,e.req_codigo as chaveexameagrupado ");
                    bui.append("\t      ,e.req_codigo ");
                    bui.append("        ,coalesce(a.exr_urgente, false) as exr_urgente ");
                    bui.append("        ,coalesce(d.emc_materialcongelado, false) as emc_materialcongelado ");
                    if (!Funcoes.textoVazio(codRecipiente)) {
                        bui.append(" ,array_agg(distinct f.rec_codigo)::varchar[] as rec_codigo ");
                    }
                    if (!Funcoes.textoVazio(codRecipiente)) {
                        bui.append(" ,case when array_agg(distinct f.rec_codigo) @> ARRAY[").append(Integer.parseInt(codRecipiente)).append("] = false then array_agg(distinct f.rec_kodigo) @> ARRAY[").append(Integer.parseInt(codRecipiente)).append("]");
                        bui.append(" \t\telse array_agg(distinct f.rec_codigo) @> ARRAY[").append(Integer.parseInt(codRecipiente)).append("] end as etiquetaDigitada ");
                    }
                    bui.append("    from examerequisicao a ");
                    bui.append("    join exames b on a.fil_codigo = b.fil_codigo and a.exa_codigo = b.exa_codigo ");
                    bui.append("    join materialcoleta c   on a.fil_codigo = c.fil_codigo and a.mco_codigo = c.mco_codigo ");
                    bui.append("    join examematcoleta d on a.fil_codigo = d.fil_codigo and a.exa_codigo = d.exa_codigo and a.mco_codigo = d.mco_codigo ");
                    bui.append("    join requisicao e on a.fil_codigo = e.fil_codigo and a.req_codigo = e.req_codigo ");
                    if (!Funcoes.textoVazio(codRecipiente)) {
                        bui.append("left join examerequisicaorecipiente f on a.fil_codigo = f.fil_codigo and a.exa_codigo = f.exa_codigo and a.req_codigo = f.req_codigo and a.mco_codigo = f.mco_codigo and f.ere_tipo = '").append("C").append("' ");
                    }
                    bui.append(" where a.fil_codigo = ").append(reg.getString("fil_codigo"));
                    bui.append("   and a.req_codigo = ").append(req.toString());
                    bui.append("   and not a.exr_excluido ");
                    bui.append(" group by a.exr_codigoapoiado ");
                    bui.append(" ,a.exr_descricaomaterial ");
                    bui.append(" ,a.exr_datamaterial ");
                    bui.append(" ,a.exr_volumediurese ");
                    bui.append(" ,a.exr_situacao ");
                    bui.append(" ,b.exa_codigo ");
                    bui.append(" ,b.exa_descricao ");
                    bui.append(" ,a.exr_urgente ");
                    bui.append(" ,a.exr_situacao ");
                    bui.append(" ,c.mco_codigo ");
                    bui.append(" ,c.mco_abreviatura ");
                    bui.append(" ,c.mco_solicitarmat ");
                    bui.append(" ,c.mco_descricao ");
                    bui.append(" ,a.exr_datamaterial ");
                    bui.append(" ,a.exr_tempodiurese ");
                    bui.append(" ,a.exr_dataloteexterno ");
                    bui.append(" ,a.exr_datatransportesaida ");
                    bui.append(" ,e.req_codigo ");
                    bui.append(" ,a.exr_urgente ");
                    bui.append(" ,d.emc_materialcongelado ");
                    SQL = bui.toString();
                    ResultSet res = Conexao.executeQuery(st, SQL);
                    List<Registro> examesAnteriores = this.modExa.getRegistros();
                    if (res.next()) {
                        do {
                            Registro exa;
                            if ((exa = new Registro(res)).getValor("exr_situacao") == null) {
                                exa.setValor("exr_situacao", "");
                            }
                            if (!Funcoes.textoVazio(codRecipiente)) {
                                exa.substituirValor("etiquetadigitada", exa.getBoolean("etiquetadigitada"));
                            } else {
                                exa.setValor("etiquetadigitada", carregarMarcado);
                            }
                            String exameMatAtual = exa.getString("exa_codigo").concat(exa.getString("mco_codigo"));
                            for (Registro regAnterior : examesAnteriores) {
                                String exameMatAnterior = regAnterior.getString("exa_codigo").concat(regAnterior.getString("mco_codigo"));
                                if (exa.getInt("req_codigo") != regAnterior.getInt("req_codigo") || !exameMatAtual.trim().equals(exameMatAnterior.trim()) || !regAnterior.getBoolean("etiquetadigitada")) continue;
                                exa.substituirValor("etiquetadigitada", Boolean.TRUE);
                            }
                            if (!examesInserido.contains(exameMatAtual)) {
                                if (Funcoes.textoVazio(exa.getString("exr_situacao")) && !exa.getBoolean(EXA_EXPORTADO)) {
                                    exames.add(exa);
                                } else {
                                    examesNaoExp.add(exa);
                                }
                                examesInserido.add(exameMatAtual);
                                continue;
                            }
                            if (!agruparMultiguias) continue;
                            for (int i = 0; i < exames.size(); ++i) {
                                Registro registroExame = (Registro)exames.get(i);
                                String key = registroExame.getString("exa_codigo").concat(registroExame.getString("mco_codigo"));
                                if (!key.equalsIgnoreCase(exameMatAtual)) continue;
                                exames.remove(i);
                                registroExame.setValor("chaveexameagrupado", registroExame.getString("chaveexameagrupado") + "-" + req);
                                exames.add(i, registroExame);
                            }
                        } while (res.next());
                        continue;
                    }
                    if (exames == null || exames.size() != 0) continue;
                    Funcoes.mensagem(this, "Nenhum exame localizado.", 2);
                    return -1;
                }
                reg.setValor(CAMPO_LISTA_EXAMES, exames);
                reg.setValor(campos[6], examesNaoExp);
                reg.setValor(COLUNA_CHAVE, this.getChave(reg));
                int linha = this.pegaLinhaRequisicao(reg);
                if (linha == -1 && !isRequisicaoAdicionada) {
                    if (!Funcoes.textoVazio(reg.getString("codigorequisicaopai")) && agruparMultiguias && reg.getInt("codigorequisicaopai") != reg.getInt("req_codigo")) {
                        reg.setValor("req_codigo", reg.getInt("codigorequisicaopai"));
                    }
                    this.modReq.addLine(this.RegToObj(reg));
                    this.atualizarModeloRequisicoes();
                    linha = this.tableReq.getRowCount() - 1;
                    this.tableReq.setRowSelectionInterval(this.tableReq.getRowCount() - 1, this.tableReq.getRowCount() - 1);
                    this.tableReq.scrollRectToVisible(this.tableReq.getCellRect(this.modReq.getRowCount() - 1, 0, false));
                } else if (!Funcoes.textoVazio(codRecipiente)) {
                    TableUtil.selecionarLinha(this.tableReq, linha);
                    for (int i = 0; i < exames.size(); ++i) {
                        Registro regAux = (Registro)exames.get(i);
                        this.modExa.setValueAt(regAux.getBoolean("etiquetadigitada") ? Boolean.TRUE : Boolean.FALSE, i, 3);
                    }
                }
                if (linha > -1) {
                    this.tableReq.setRowSelectionInterval(linha, linha);
                    this.tableReq.scrollRectToVisible(this.tableReq.getCellRect(linha, 0, false));
                }
                return linha;
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, e.getMessage() + "\nSQL: " + SQL, e.getStackTrace());
            }
        }
        return -1;
    }

    public int pegaLinhaRequisicao(Registro reg) {
        if (reg == null) {
            return -1;
        }
        for (int i = 0; i < this.modReq.getRowCount(); ++i) {
            int req = (Integer)this.modReq.getValueAt(i, 1);
            if (req != reg.getInt("req_codigo")) continue;
            return i;
        }
        return -1;
    }

    public int pegaLinhaRequisicao(String requisicao) {
        if (Funcoes.textoVazio(requisicao)) {
            return -1;
        }
        for (int i = 0; i < this.modReq.getRowCount(); ++i) {
            Object req = this.modReq.getValueAt(i, 1);
            if (requisicao.length() > req.toString().length()) {
                req = Funcoes.preencheZero(req.toString(), ParametrosGerais.getDigitosTuboRequisicao());
            }
            if (!req.toString().trim().equals(requisicao.trim())) continue;
            return i;
        }
        return -1;
    }

    private SituacaoReq verificaSituacaoRequisicao(String codigoReq, String filial, String recipiente) {
        Statement st = Conexao.getStatement();
        if (st != null) {
            try {
                StringBuilder bui = new StringBuilder("select req_codigo \n");
                bui.append("from requisicao \n");
                bui.append("where fil_codigo = ").append(filial).append(" and req_codigo = ").append(codigoReq);
                SQL = bui.toString();
                boolean contemRequisicao = Conexao.executeQuery(st, SQL).next();
                SQL = bui.toString();
                if (!Conexao.executeQuery(st, SQL).next()) {
                    return SituacaoReq.REQ_NAO_CADASTRADA;
                }
                bui.setLength(0);
                bui.append("select a.exa_codigo \n");
                bui.append("from examerequisicao a \n");
                bui.append(" where \n");
                bui.append("  a.fil_codigo = ").append(filial).append(" and \n");
                bui.append("  a.req_codigo = ").append(codigoReq);
                bui.append(" and a.exr_excluido = false ");
                bui.append(" and a.exr_datatransportesaida is null and (a.exr_situacao is null or a.exr_situacao = '')");
                SQL = bui.toString();
                boolean contemExames = Conexao.executeQuery(st, SQL).next();
                SQL = bui.toString();
                if (!Conexao.executeQuery(st, SQL).next()) {
                    return contemExames ? SituacaoReq.EXAMES_JA_EXPORTADOS : SituacaoReq.NAO_CONTEM_EXAMES;
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, e.getMessage() + "\nSQL: " + SQL, e.getStackTrace());
            }
        }
        return SituacaoReq.REQ_OK;
    }

    private void limpar() {
        this.textRequisicao.setText("");
        this.modReq.clear();
        this.modExa.limpar();
        this.modOutrosExa.limpar();
        this.rendererExa.limpar();
        this.rendererReq.limpar();
        this.rendererOutrosExa.limpar();
        this.habilitarDesabilitarBotoes();
        this.loteAux = null;
    }

    private String getChave(Registro reg) {
        return Funcoes.preencheZero(reg.getInt("fil_codigo"), ParametrosGerais.getDigitosTuboFilial()).concat(Funcoes.preencheZero(reg.getInt("req_codigo"), ParametrosGerais.getDigitosTuboRequisicao()));
    }

    private String getChave(String filial, String requisicao) {
        return Funcoes.preencheZero(filial, ParametrosGerais.getDigitosTuboFilial()).concat(Funcoes.preencheZero(requisicao, ParametrosGerais.getDigitosTuboRequisicao()));
    }

    private void limparRequisicoesExportadas() {
        this.modExa.limpar();
        ArrayList<Registro> requisicoes_old = new ArrayList<Registro>();
        for (int i = 0; i < this.modReq.getRowCount(); ++i) {
            requisicoes_old.add(this.objectToReg(i));
        }
        ArrayList<Registro> requisicoes = new ArrayList<Registro>();
        block1: for (Registro r : requisicoes_old) {
            List exames = (List)r.getValor(CAMPO_LISTA_EXAMES);
            if (exames.size() == 0) {
                requisicoes.add(r);
                continue;
            }
            exames = (List)r.getValor(BACKUP_LISTA_EXAMES);
            for (Registro exa : exames) {
                if (exa.getBoolean(EXA_EXPORTADO) || Funcoes.textoVazio(exa.getString("exr_situacao")) || exa.getString("exr_situacao").equals("O")) continue;
                requisicoes.add(r);
                continue block1;
            }
        }
        this.modReq.clear();
        for (Registro registro : requisicoes) {
            this.modReq.addLine(this.RegToObj(registro));
        }
    }

    private void habilitarDesabilitarBotoes() {
        this.textRequisicao.setEnabled(this.salvandoLote);
        this.buttonBuscaReq.setEnabled(this.salvandoLote);
        this.buttonSalvar.setEnabled(this.salvandoLote && this.modReq.getRowCount() > 0);
        this.buttonFiltrar.setEnabled(this.salvandoLote);
        this.buttonCancelar.setEnabled(this.salvandoLote);
        this.buttonFechar.setEnabled(!this.salvandoLote);
        this.buttonNovo.setEnabled(!this.salvandoLote);
    }

    private void atualizarModeloRequisicoes() {
        this.modReq.fireTableDataChanged();
        this.buttonSalvar.setEnabled(this.modReq.getRowCount() > 0);
        this.buttonNovo.setEnabled(this.modReq.getRowCount() > 0);
    }

    private void anularSQL() {
        try {
            Conexao.anulaSQL();
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), null);
        }
    }

    private void arquivarSQL() {
        try {
            Conexao.arquivaSQL();
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), null);
        }
    }

    private JPanel montaPanelLegendaExame() {
        Legenda legenda = new Legenda(10);
        legenda.addItem(COR_TRANSPORTE, "Em transporte");
        legenda.addItem(COR_FALTA_MATERIAL, "Falta material");
        legenda.addItem(COR_RECOLETA, "Recoleta");
        legenda.addItem(COR_A_COLETAR, "A coletar");
        legenda.addItem(Color.RED, "Urgente");
        return legenda.getPanel();
    }

    private void iniciar() {
        JPanel panelLegendaExame = this.montaPanelLegendaExame();
        this.setLayout(new BorderLayout());
        Funcoes.criaBarraDescricao(this, "Criar lote", "Cria\u00e7\u00e3o de Lote de Exames para Filial", "triagem/criar_lote_filial.jpg");
        this.add((Component)ComponenteFactory.novoJPanelBorderLayout(null, null, null, ComponenteFactory.novoJPanelFlowLayout(2, this.buttonNovo, this.buttonSalvar, this.buttonCancelar, this.buttonFechar), ComponenteFactory.novoJPanelFlowLayout(0, this.buttonFiltrar)), "South");
        JPanel panelAux = new JPanel(new BorderLayout());
        this.add((Component)panelAux, "Center");
        this.tableReq = ComponenteFactory.novoJTable((TableModel)this.modReq, (ListSelectionListener)this, 25, 82, 0, 85);
        this.rendererReq.setPosicaoCampoUrgente(ArraysUtil.indice((Object[])campos, "req_urgente"));
        this.tableReq.setDefaultRenderer(Object.class, this.rendererReq);
        this.modReq.setColumnSize(new int[]{25, 82, 0, 85}, this.tableReq);
        this.tableExa = ComponenteFactory.novoJTable((TableModel)this.modExa, 48, 0, 46, 22);
        this.tableExa.setDefaultRenderer(String.class, this.rendererExa);
        this.modExa.setTamanhoColunas(this.tableExa, 48, 0, 46, 22);
        this.tableOutrosExa = ComponenteFactory.novoJTable((TableModel)this.modOutrosExa, 60, 0, 40, 40);
        this.tableOutrosExa.setDefaultRenderer(String.class, this.rendererOutrosExa);
        JSplitPane splitExames = new JSplitPane(0, ComponenteFactory.novoJPanelBorderLayout("Exames para enviar", (Component)new JScrollPane(this.tableExa), null, null, null, null), ComponenteFactory.novoJPanelBorderLayout("Outros Exames", (Component)new JScrollPane(this.tableOutrosExa), null, null, null, null));
        splitExames.setResizeWeight(0.5);
        splitExames.setDividerSize(3);
        splitExames.setBorder(null);
        JSplitPane split = new JSplitPane(1, ComponenteFactory.novoJPanelBorderLayout("Requisi\u00e7\u00f5es", (Component)new JScrollPane(this.tableReq), null, null, null, null), splitExames);
        split.setDividerLocation(350);
        split.setDividerSize(3);
        split.setBorder(null);
        panelAux.add((Component)split, "Center");
        panelAux.add((Component)panelLegendaExame, "South");
        JPanel jPanel = panelAux;
        panelAux = new JPanel(new GridBagLayout());
        jPanel.add((Component)panelAux, "North");
        panelAux.setBorder(BorderFactory.createEmptyBorder(3, 1, 1, 1));
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridx = 0;
        cons.gridy = 1;
        cons.insets = new Insets(1, 5, 1, 1);
        panelAux.add((Component)new JLabel("Tubo:"), cons);
        cons.gridx = 1;
        cons.insets = new Insets(1, 1, 1, 0);
        this.textRequisicao.setPreferredSize(new Dimension(150, 20));
        panelAux.add((Component)this.textRequisicao, cons);
        cons.gridx = 2;
        cons.insets.left = 0;
        this.buttonBuscaReq.setFocusable(false);
        panelAux.add((Component)this.buttonBuscaReq, cons);
        cons.gridx = 3;
        cons.gridwidth = 2;
        cons.weightx = 0.5;
        JPanel pen = new JPanel();
        panelAux.add((Component)pen, cons);
        this.tableReq.addKeyListener(this);
        this.tableExa.addKeyListener(this);
        this.textRequisicao.addKeyListener(this);
        this.buttonFiltrar.addKeyListener(this);
        this.buttonSalvar.addKeyListener(this);
        this.buttonCancelar.addKeyListener(this);
        this.buttonFechar.addKeyListener(this);
        this.buttonNovo.addKeyListener(this);
        this.salvandoLote = true;
        this.habilitarDesabilitarBotoes();
        ScreenUtil.requisitarFoco(this.textRequisicao);
        ScreenUtil.addActionMap(this, KeyStroke.getKeyStroke(73, 2, true), "INFOREQUISICAO", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Registro reg;
                GlassPaneMensagem glassPaneMensagem = (GlassPaneMensagem)CriarLoteFilial.this.getRootPane().getGlassPane();
                InfoRequisicao info = new InfoRequisicao((Frame)CriarLoteFilial.this.getTopLevelAncestor(), glassPaneMensagem);
                if (CriarLoteFilial.this.salvandoLote && CriarLoteFilial.this.tableReq.getSelectedRow() > -1 && (reg = CriarLoteFilial.this.objectToReg(CriarLoteFilial.this.tableReq.getSelectedRow())) != null) {
                    info.setRequisicao(reg.getString("fil_codigo"), reg.getInt("req_codigo"));
                }
                info.setVisible(true);
                CriarLoteFilial.this.getRootPane().setGlassPane(glassPaneMensagem);
            }
        });
    }

    private void buscarRequisicaoAoPerdeFoco() {
        this.filial = Variaveis.filialPadrao;
        String codigoRequisicao = this.textRequisicao.getText();
        String codRecipiente = "";
        if (this.textRequisicao.getText().matches("\\d+")) {
            if (codigoRequisicao.length() == ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
                codigoRequisicao = codigoRequisicao.substring(ParametrosGerais.getDigitosTuboFilial(), codigoRequisicao.length() - ParametrosGerais.getDigitosTuboTubo());
                this.filial = String.valueOf(Integer.parseInt(this.textRequisicao.getText().substring(0, ParametrosGerais.getDigitosTuboFilial())));
                codRecipiente = this.textRequisicao.getText().substring(ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao());
            }
            if (this.acessoAdicionarPorTubo && this.textRequisicao.getText().length() < ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
                this.textRequisicao.selectAll();
                this.textRequisicao.grabFocus();
                return;
            }
            if (this.textRequisicao.getText().matches("\\d+")) {
                String original = this.textRequisicao.getText();
                DescritorCodigoEtiqueta de = DescritorCodigoEtiqueta.getDescritor(original);
                TuboDao tuboDao = new TuboDao();
                if (de != null) {
                    if (!TuboDao.contemCadastro(de)) {
                        Funcoes.mensagem(this, "A etiqueta \"" + original + "\" n\u00e3o est\u00e1 cadastrada", 1);
                        this.textRequisicao.selectAll();
                        return;
                    }
                }
                int linha = -1;
                if (de != null) {
                    this.textRequisicao.setText(de.getRequisicao());
                    codigoRequisicao = this.textRequisicao.getText();
                    if (this.modReq.getRowCount() > 0) {
                        this.carregarRegistrosModelo(codigoRequisicao);
                    }
                    linha = this.adicionarRequisicao(de.getRequisicao(), de.getFilial(), de.getTubo());
                } else if (original.length() <= ParametrosGerais.getDigitosTuboRequisicao()) {
                    linha = this.adicionarRequisicao(this.textRequisicao.getText(), Variaveis.filialPadrao, "");
                } else {
                    Funcoes.mensagem(this, "A etiqueta informada n\u00e3o foi localizada ou \u00e9 inv\u00e1lida.", 2);
                }
                this.atualizarModeloRequisicoes();
                if (linha > -1) {
                    TableUtil.selecionarLinha(this.tableReq, linha);
                }
            }
            this.textRequisicao.setText("");
        }
    }

    public void carregarRegistrosModelo(String codigoRequisicao) {
        int linha = Funcoes.textoVazio(codigoRequisicao) ? this.tableReq.getSelectedRow() : this.pegaLinhaRequisicao(codigoRequisicao);
        if (linha != -1) {
            Registro reg = this.objectToReg(linha);
            this.modExa.limpar();
            this.modExa.addRegistros((Collection)reg.getValor(CAMPO_LISTA_EXAMES));
            this.modOutrosExa.limpar();
            this.modOutrosExa.addRegistros((Collection)reg.getValor(campos[6]));
            this.modExa.fireTableDataChanged();
            this.modOutrosExa.fireTableDataChanged();
        }
    }

    public void carregarRegistrosModelo(Registro reg) {
        if (reg == null) {
            return;
        }
        this.modExa.addRegistros((Collection)reg.getValor(CAMPO_LISTA_EXAMES));
        this.modOutrosExa.addRegistros((Collection)reg.getValor(campos[6]));
        this.modExa.fireTableDataChanged();
        this.modOutrosExa.fireTableDataChanged();
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    private void novoLote() {
        this.limpar();
        this.salvandoLote = true;
    }

    private Registro objectToReg(int line) {
        Registro reg = new Registro();
        for (int i = 0; i < campos.length; ++i) {
            reg.setValor(campos[i], this.modReq.getValueAt(line, i));
        }
        return reg;
    }

    private Object[] RegToObj(Registro reg) {
        ArrayList<Object> req = new ArrayList<Object>();
        for (String key : campos) {
            req.add(reg.getValor(key));
        }
        return req.toArray();
    }

    private void trataCampoObservacao(ArrayList<Registro> requisicoes) {
        for (Registro registro : requisicoes) {
            String observacao = registro.getValor("req_obs", String.class);
            if (!Funcoes.textoVazio(observacao)) {
                observacao = StringUtil.removerAcentos(observacao).replaceAll("[^a-zA-Z1-9: ]", "");
            }
            registro.setValor("req_obs", observacao);
        }
    }

    private static enum SituacaoReq {
        REQ_OK,
        REQ_JA_ADICIONADA,
        REQ_NAO_CADASTRADA,
        NAO_CONTEM_EXAMES,
        EXAMES_JA_EXPORTADOS;

    }
}

