/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.externo.exportadores.ws;

import jalis.apoio.servidorws.WSCliente;
import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.triagem.externo.exportadores.UtilExportadores;
import jalis.laboratorio.util.impressao.RetornoImpressaoEtiquetas;
import jalis.laboratorio.util.parsers.jalis.ConfiguradorProtocoloJalis;
import jalis.laboratorio.util.parsers.jalis.ws.ImportacaoJalis;
import jalis.relatorio.Gerador;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import javax.swing.JDialog;
import javax.swing.table.TableModel;

public class UtilJalis {
    public static void imprimirRelatorio(Statement st, String relatorio, String numeroLote, String codigoFilialSelecionada, String codigoConvenio, String codigoLabExterno) throws SQLException {
        String FILTRO_CODIGO_LABORATORIO = "codigoLaboratorio";
        String FILTRO_RAZAO_LABORATORIO = "razaoLaboratorio";
        String[] campos = new String[]{"codigoRequisicao", "nomePaciente", "dataNascimentoPaciente", "sexoPaciente", "idadePaciente", "anoMesPaciente", "horaRequisicao", "observacaoRequisicao", "codigoRequisicaoApoio", "codigoExame", "descricaoExame", "dataRequisicao", "codigoLote", "dataLote", "codigoLoteLabApoio", "codigoMaterialColetado", "descricaoMaterialColetado", "abreviaturaMaterialColetado", "codigoFilialRequisicao", "codigoExameLaboratorioApoio", "descricaoExameLaboratorioApoio", "codigoMatLaboratorioApoio", "descricaoMatLaboratorioApoio"};
        StringBuilder buf = new StringBuilder();
        buf.append("select a.fil_codigo as codigoFilialRequisicao, a.req_codigo as codigoRequisicao, e.rle_codigo as codigoRequisicaoApoio, ");
        buf.append("paciente.pac_nome as nomePaciente, a.req_idade as idadePaciente, a.req_anomes as anoMesPaciente, ");
        buf.append("c.exa_codigo as codigoExame, c.exa_descricao as descricaoExame,  ");
        buf.append("paciente.pac_datanasc as dataNascimentoPaciente, paciente.pac_sexo as sexoPaciente, ");
        buf.append("a.req_obs as observacaoRequisicao, a.req_hora as horaRequisicao, ");
        buf.append("coletado.mco_codigo as codigoMaterialColetado, coletado.mco_descricao as descricaoMaterialColetado, ");
        buf.append("coletado.mco_abreviatura as abreviaturaMaterialColetado, ");
        buf.append("l.lex_codigo as codigoLote, l.lex_datahora as dataLote, a.req_data as dataRequisicao, f.ele_xmllabexterno ");
        buf.append("from loteexternorequisicao lote ");
        buf.append("left join loteexterno l on lote.fil_codigo = l.fil_codigo and lote.lex_codigo = l.lex_codigo and lote.lae_codigo = l.lae_codigo ");
        buf.append("left join requisicao a on lote.fil_kodigo = a.fil_codigo and lote.req_codigo = a.req_codigo ");
        buf.append("join loteexternoexamerequisicao b on lote.fil_codigo = b.fil_codigo and lote.lex_codigo = b.lex_codigo and lote.req_codigo = b.req_codigo and lote.lae_codigo = b.lae_codigo and lote.fil_kodigo = b.fil_kodigo ");
        buf.append("join paciente on a.fil_codigo = paciente.fil_codigo and a.pac_codigo = paciente.pac_codigo ");
        buf.append("left join exames c on b.fil_codigo = c.fil_codigo and b.exa_codigo = c.exa_codigo ");
        buf.append("left join examematcoleta d on b.fil_codigo = d.fil_codigo and b.exa_codigo = d.exa_codigo and b.mco_codigo = d.mco_codigo ");
        buf.append("left join materialcoleta coletado on d.fil_codigo = coletado.fil_codigo and d.mco_codigo = coletado.mco_codigo ");
        buf.append("left join medico on a.fil_codigo = medico.fil_codigo and a.med_conselho = medico.med_conselho and a.med_crm = medico.med_crm and a.med_uf = medico.med_uf ");
        buf.append("left join labexterno on d.fil_codigo = labexterno.fil_codigo and b.lae_codigo = labexterno.lae_codigo ");
        buf.append("left join requisicaolabexterno e on a.fil_codigo = e.fil_codigo and a.req_codigo = e.req_codigo and labexterno.lae_codigo = e.lae_codigo ");
        buf.append("left join examematcoletalabexterno f on a.fil_codigo = f.fil_codigo and d.exa_codigo = f.exa_codigo and d.mco_codigo = f.mco_codigo and b.lae_codigo = f.lae_codigo ");
        buf.append("where lote.fil_codigo = ").append(Variaveis.filialPadrao);
        buf.append(" and lote.lex_codigo = ").append(numeroLote);
        buf.append(" and lote.lae_codigo = ").append(codigoLabExterno);
        buf.append(" and a.req_excluida = false ");
        buf.append(" and f.ele_xmllabexterno is not null and f.ele_xmllabexterno <> '' ");
        buf.append(" order by a.fil_codigo, a.req_codigo");
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        if (rs.next()) {
            ModeloGridTable modelo = new ModeloGridTable(campos);
            Statement st2 = Conexao.getStatement();
            do {
                Object[] o = new Object[campos.length];
                String xml = rs.getString("ele_xmllabexterno");
                String codigoExameApoio = StringUtil.getValor(xml, "codigoExame");
                String codigoMaterialApoio = StringUtil.getValor(xml, "codigoMaterial");
                String descMatApoio = "";
                String descExameApoio = "";
                buf.setLength(0);
                buf.append("select a.emc_descricaomaterial, b.exa_descricao from examematcoletajalis a");
                buf.append(" left join examesjalis b on a.fil_codigo = b.fil_codigo");
                buf.append(" and a.lae_codigo = b.lae_codigo and a.exa_codigo = b.exa_codigo");
                buf.append(" where a.fil_codigo = ").append(codigoFilialSelecionada);
                buf.append(" and a.lae_codigo = ").append(codigoLabExterno);
                buf.append(" and a.exa_codigo = '").append(codigoExameApoio).append("'");
                buf.append(" and a.mco_codigo = ").append(codigoMaterialApoio);
                ResultSet rs2 = st2.executeQuery(buf.toString());
                if (rs2.next()) {
                    descMatApoio = rs2.getString("emc_descricaomaterial");
                    descExameApoio = rs2.getString("exa_descricao");
                }
                for (int i = 0; i < campos.length; ++i) {
                    o[i] = campos[i].equalsIgnoreCase("codigoLoteLabApoio") ? Funcoes.preencheZero(codigoFilialSelecionada, 2) + Funcoes.preencheZero(codigoConvenio, 4) + Funcoes.preencheZero(numeroLote, 6) : (campos[i].equalsIgnoreCase("codigoExameLaboratorioApoio") ? codigoExameApoio : (campos[i].equalsIgnoreCase("descricaoExameLaboratorioApoio") ? descExameApoio : (campos[i].equalsIgnoreCase("codigoMatLaboratorioApoio") ? codigoMaterialApoio : (campos[i].equalsIgnoreCase("descricaoMatLaboratorioApoio") ? descMatApoio : (campos[i].equalsIgnoreCase("anoMesPaciente") ? Tipos.tipoIdade(rs.getString(campos[i])) : (campos[i].equalsIgnoreCase("sexoPaciente") ? Tipos.tipoSexo(rs.getString(campos[i])) : rs.getObject(campos[i])))))));
                }
                modelo.addLine(o);
            } while (rs.next());
            Conexao.fecharStatement(st2);
            final JDialog dialogo = new JDialog(Laboratorio.getInstancia());
            dialogo.setSize(new Dimension(750, 600));
            dialogo.getContentPane().setLayout(new BorderLayout());
            dialogo.setModal(true);
            Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
            gerador.setPreVisualizar(true);
            gerador.setPai(dialogo.getContentPane());
            gerador.setCopias(2);
            gerador.setAcaoFechar(new Runnable(){

                @Override
                public void run() {
                    dialogo.dispose();
                }
            });
            gerador.setZoomPreVisualizar(0.5f);
            HashMap<String, Object> var = new HashMap<String, Object>();
            var.put("codigoLaboratorio", codigoConvenio);
            var.put("razaoLaboratorio", "");
            gerador.executar(relatorio, (TableModel)modelo, var);
            ScreenUtil.centralizar(dialogo);
            dialogo.setVisible(true);
        }
    }

    public static WSCliente pegaServidor(Statement st, int laeCodigo, boolean isColetaWeb, RetornoImpressaoEtiquetas retorno) throws Exception {
        String xml = UtilExportadores.getXMLConfiguracaoProtocolo(st, laeCodigo);
        if (!Funcoes.textoVazio(xml)) {
            Registro registro = ConfiguradorProtocoloJalis.xmlToRegistro(xml);
            if (!Funcoes.testaConexaoWeb(registro.getString("servidorRMI"), Integer.parseInt(registro.getString("portaServidor")))) {
                String texto = "Conex\u00e3o com a web n\u00e3o encontrada";
                if (isColetaWeb) {
                    UtilExportadores.adicionarMensagemRetorno(texto, "Jalis", retorno);
                } else {
                    Funcoes.mensagem(Laboratorio.getInstancia(), texto, 1);
                }
                return null;
            }
            WSCliente ws = new WSCliente(registro.getString("servidorRMI"), Integer.parseInt(registro.getString("portaServidor")));
            if (!ws.isServidorOk()) {
                String texto = "O servidor remoto n\u00e3o est\u00e1 ativado, tente novamente mais tarde";
                if (isColetaWeb) {
                    UtilExportadores.adicionarMensagemRetorno(texto, "Jalis", retorno);
                } else {
                    Funcoes.mensagem(Laboratorio.getInstancia(), texto, 1);
                }
                return null;
            }
            if (!ImportacaoJalis.validaCliente(ws, registro.getString("filialSelecionada"), registro.getString("codigoCliente"))) {
                String texto = "O servidor remoto n\u00e3o autenticou sua conex\u00e3o.\nEntre em contato com o laborat\u00f3rio de apoio.";
                if (isColetaWeb) {
                    UtilExportadores.adicionarMensagemRetorno(texto, "Jalis", retorno);
                } else {
                    Funcoes.mensagem(Laboratorio.getInstancia(), texto, 1);
                }
                return null;
            }
            if (!ImportacaoJalis.validaConvenio(ws, registro.getString("filialSelecionada"), registro.getString("codigoConvenio"))) {
                String texto = "O conv\u00eanio informado n\u00e3o est\u00e1 autorizado a receber dados do servidor de apoio.\nEntre em contato com o laborat\u00f3rio de apoio.";
                if (isColetaWeb) {
                    UtilExportadores.adicionarMensagemRetorno(texto, "Jalis", retorno);
                } else {
                    Funcoes.mensagem(Laboratorio.getInstancia(), texto, 1);
                }
                return null;
            }
            return ws;
        }
        String texto = "Configura\u00e7\u00e3o do servidor n\u00e3o localizada";
        if (isColetaWeb) {
            UtilExportadores.adicionarMensagemRetorno(texto, "Jalis", retorno);
        } else {
            Funcoes.mensagem(Laboratorio.getInstancia(), texto, 1);
        }
        return null;
    }
}

