/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.externo.exportadores.ws;

import jalis.apoio.servidorws.Apoiado;
import jalis.apoio.servidorws.WSCliente;
import jalis.apoio.servidorws.parametroset.ParametroSet;
import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.triagem.externo.ReimpressaoRelatorioEtiqueta;
import jalis.laboratorio.triagem.externo.exportadores.UtilExportadores;
import jalis.laboratorio.triagem.externo.exportadores.ws.UtilJalis;
import jalis.laboratorio.util.impressao.RetornoImpressaoEtiquetas;
import jalis.laboratorio.util.impressao.labexterno.ImpressorasLabExterno;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.laboratorio.util.parsers.jalis.ConfiguradorProtocoloJalis;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.impressao.termica.ImpressaoTermica;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.math.RoundingMode;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;

public class ReimprimirRelatorioEtiquetaJalis
implements ReimpressaoRelatorioEtiqueta {
    @Override
    public RetornoImpressaoEtiquetas reimprimirEtiquetas(String codLabExterno, String numeroLote, String codigoConvenio, String configuracaoLabExterno, Statement st, int digitosTuboFilial, int digitosTuboRequisicao, boolean isColetaWeb, Callable<Boolean> arquivar, Callable<Boolean> anular, String impressoraEtqColeta) {
        RetornoImpressaoEtiquetas retorno = new RetornoImpressaoEtiquetas();
        try {
            WSCliente ws = UtilJalis.pegaServidor(st, Integer.parseInt(codLabExterno), isColetaWeb, retorno);
            if (!Funcoes.textoVazio(configuracaoLabExterno) && ws != null) {
                Registro registro = ConfiguradorProtocoloJalis.xmlToRegistro(configuracaoLabExterno);
                ParametroSet param = new ParametroSet();
                param.setString("chave", new Apoiado(Integer.parseInt(registro.getString("filialSelecionada")), Variaveis.tipoFilialPadrao, Integer.parseInt(registro.getString("codigoConvenio"))).getChave());
                param.setInt("lote", Integer.parseInt(numeroLote));
                ParametroSet paramRet = ws.executaAcao("getEtiquetas", param);
                StringBuilder etiquetas = new StringBuilder();
                if (paramRet.getList("etiquetas") != null) {
                    for (String et : paramRet.getList("etiquetas")) {
                        etiquetas.append(StringUtil.arrumaEtiqueta(et));
                    }
                }
                if (!Funcoes.textoVazio(etiquetas.toString())) {
                    ImpressaoTermica termica = new ImpressaoTermica(impressoraEtqColeta, isColetaWeb);
                    ArrayList<byte[]> etq = new ArrayList<byte[]>();
                    etq.add(termica.imprimirDireto(etiquetas.toString(), true, st, isColetaWeb, arquivar, anular));
                    HashMap<String, List<byte[]>> etiquetasLab = new HashMap<String, List<byte[]>>();
                    etiquetasLab.put("jalis", etq);
                    retorno.setEtiquetasLabExterno(etiquetasLab);
                    return retorno;
                }
                String texto = "N\u00e3o h\u00e1 etiquetas para impress\u00e3o.";
                if (isColetaWeb) {
                    UtilExportadores.adicionarMensagemRetorno(texto, "Jalis", retorno);
                } else {
                    Funcoes.mensagem(Laboratorio.getInstancia(), texto, 2);
                }
            }
        }
        catch (Exception ex) {
            if (isColetaWeb) {
                UtilExportadores.adicionarMensagemRetorno(ex.getMessage(), "Jalis", retorno);
            }
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), ex.getMessage(), ex.getStackTrace(), "ReimprimirRelatorioEtiquetaJalis");
        }
        return retorno;
    }

    private String getExamesLote(String codigoLote, String laboratorioExterno) {
        StringBuilder buf = new StringBuilder("select a.fil_kodigo, a.exa_codigo, a.mco_codigo, b.mco_abreviatura, c.exa_descricao ");
        buf.append("from loteexternoexamerequisicao a ");
        buf.append("left join examematcoleta d on a.fil_codigo = d.fil_codigo and a.exa_codigo = d.exa_codigo and a.mco_codigo = d.mco_codigo ");
        buf.append("left join exames c on a.fil_codigo = c.fil_codigo and a.exa_codigo = c.exa_codigo ");
        buf.append("left join materialcoleta b on a.fil_codigo = b.fil_codigo and a.mco_codigo = b.mco_codigo ");
        buf.append("where a.fil_codigo = ").append(Variaveis.filialPadrao);
        buf.append(" and d.lae_codigo = ").append(laboratorioExterno);
        buf.append(" and a.lex_codigo = ").append(codigoLote);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reimprimirRelatorio(String codLabExterno, String numeroLote, String codigoConvenio, String configuracaoLabExterno) {
        Statement st;
        block4: {
            st = Conexao.getStatement();
            try {
                WSCliente ws = UtilJalis.pegaServidor(st, Integer.parseInt(codLabExterno), false, null);
                String xml = UtilExportadores.getXMLConfiguracaoProtocolo(st, Integer.parseInt(codLabExterno));
                if (Funcoes.textoVazio(xml) || ws == null) break block4;
                Registro registro = ConfiguradorProtocoloJalis.xmlToRegistro(xml);
                ParametroSet paramRet = new ParametroSet();
                paramRet = ws.executaAcao("getModeloRelatorio");
                String modelo = paramRet.getString("relatorio");
                UtilJalis.imprimirRelatorio(st, StringUtil.xmlToTexto(modelo), numeroLote, registro.getString("filialSelecionada"), registro.getString("codigoConvenio"), codLabExterno);
            }
            catch (Exception ex) {
                try {
                    ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), ex.getMessage(), ex.getStackTrace(), "ReimprimirRelatorioEtiquetaJalis");
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
    }

    @Override
    public RetornoImpressaoEtiquetas reimprimirEtiquetas(String codLabExterno, String numeroLote, String codigoConvenio, String configuracaoLabExterno, String exames, String materiais, Statement st, int digitosTuboFilial, int digitosTuboRequisicao, boolean isColetaWeb, Callable<Boolean> arquivar, Callable<Boolean> anular, String impressoraEtqColeta) {
        RetornoImpressaoEtiquetas retorno = new RetornoImpressaoEtiquetas();
        try {
            WSCliente ws = UtilJalis.pegaServidor(st, Integer.parseInt(codLabExterno), isColetaWeb, retorno);
            if (!Funcoes.textoVazio(configuracaoLabExterno) && ws != null) {
                Registro registro = ConfiguradorProtocoloJalis.xmlToRegistro(configuracaoLabExterno);
                ParametroSet param = new ParametroSet();
                param.setString("chave", new Apoiado(Integer.parseInt(registro.getString("filialSelecionada")), Variaveis.tipoFilialPadrao, Integer.parseInt(registro.getString("codigoConvenio"))).getChave());
                param.setInt("lote", Integer.parseInt(numeroLote));
                param.setString("listaExames", exames);
                param.setString("listaMateriais", materiais);
                ParametroSet paramRet = ws.executaAcao("getEtiquetas", param);
                StringBuilder etiquetas = new StringBuilder();
                if (paramRet.getList("etiquetas") != null) {
                    for (String et : paramRet.getList("etiquetas")) {
                        etiquetas.append(StringUtil.arrumaEtiqueta(et));
                    }
                }
                if (!Funcoes.textoVazio(etiquetas.toString())) {
                    ImpressaoTermica termica = new ImpressaoTermica(ParametrosLocais.getParametro("impressoraEtqColeta"), isColetaWeb);
                    ArrayList<byte[]> etq = new ArrayList<byte[]>();
                    etq.add(termica.imprimirDireto(etiquetas.toString(), true, st, isColetaWeb, arquivar, anular));
                    HashMap<String, List<byte[]>> etiquetasLab = new HashMap<String, List<byte[]>>();
                    etiquetasLab.put("Jalis", etq);
                    retorno.setEtiquetasLabExterno(etiquetasLab);
                } else {
                    Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o h\u00e1 etiquetas para impress\u00e3o", 2);
                }
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), ex.getMessage(), ex.getStackTrace(), "ReimprimirRelatorioEtiquetaJalis");
        }
        return retorno;
    }

    @Override
    public RetornoImpressaoEtiquetas reimprimirEtiquetas(String codigoRequisicao, String codigoFilial, List<Registro> exames, Statement st, Statement st2, Statement st3, Statement st4, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, boolean isColetaWeb, Callable<Boolean> arquivar, Callable<Boolean> anular, String impressoraEtqColeta, int agruparInterface, boolean agruparGuiasInterface, String login, ImpressorasLabExterno impressoras, String imprimirEtqTriagemSemMaterial, boolean imprimirEtqColetaSemMaterial, boolean imprimirEtqColetaSelecionadaSemMaterial, boolean agruparEtqPorQtde, String tipoExportacaoInterface, int codigoLayout, String tamanhoNomeImpressoras, String[] impressorasLocais, String cabecalhoEtq, int exportacaoInterface, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario, String tipoIntegracao, String tipoEtqSoroteca, int casasPrecoExame, RoundingMode arredondamentoPrecoExame, Protocolo protocolo, String respostaColetaWeb) {
        return null;
    }
}

