/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.externo.exportadores.ws;

import jalis.apoio.servidor.IServidor;
import jalis.apoio.servidorws.Apoiado;
import jalis.apoio.servidorws.WSCliente;
import jalis.apoio.servidorws.parametroset.ParametroSet;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.triagem.externo.Exportador;
import jalis.laboratorio.triagem.externo.LaboratorioExterno;
import jalis.laboratorio.triagem.externo.exportadores.IntegracaoLabExterno;
import jalis.laboratorio.triagem.externo.exportadores.UtilExportadores;
import jalis.laboratorio.triagem.externo.exportadores.UtilJalis;
import jalis.laboratorio.triagem.externo.exportadores.ws.modelo.ExameRequisicao;
import jalis.laboratorio.triagem.externo.exportadores.ws.modelo.Lote;
import jalis.laboratorio.triagem.externo.exportadores.ws.modelo.MedicamentoRequisicao;
import jalis.laboratorio.triagem.externo.exportadores.ws.modelo.Medico;
import jalis.laboratorio.triagem.externo.exportadores.ws.modelo.Paciente;
import jalis.laboratorio.triagem.externo.exportadores.ws.modelo.Produto;
import jalis.laboratorio.triagem.externo.exportadores.ws.modelo.Requisicao;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.laboratorio.util.impressao.RetornoImpressaoEtiquetas;
import jalis.laboratorio.util.impressao.labexterno.ImpressorasLabExterno;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.laboratorio.util.parsers.jalis.ConfiguradorProtocoloJalis;
import jalis.laboratorio.util.parsers.jalis.ws.ImportacaoJalis;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.impressao.termica.ImpressaoTermica;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import jalis.util.xml.XMLUtil;
import java.rmi.RemoteException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;

public class ExportacaoParaJalis
extends IntegracaoLabExterno
implements Exportador {
    private boolean exr_codigoapoiado = false;
    private IServidor servidor;
    private Registro registro;
    private String etq;
    private WSCliente ws;
    private String codigoConvenio;

    @Override
    public String getTagCodigo() {
        return "codigoConvenio";
    }

    @Override
    public RetornoImpressaoEtiquetas exportarExames(String codigoLabExterno, String numeroLote, String configuracaoLabExterno, boolean reenvio, List<Registro> requisicoes, int colunaOrdenacao, boolean isColetaWeb, int agruparInterface, Statement st, Statement st2, Statement st3, String variaveisLogin, boolean agruparGuiasInterface, String imprimirEtiquetaTriagemSemMaterial, boolean imprimirEtiquetaColetaSemMaterial, boolean imprimirEtiquetaColetaSelecionadaSemMaterial, boolean agruparEtqPorQtde, String tipoExportacaoInterface, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario, String tipoIntegracao, String tamanhoNomeImpressora, String[] impressorasLocais, ImpressorasLabExterno impressoras, String tipoEtiquetaSoroteca, Callable<Boolean> arquivar, Callable<Boolean> anular, LaboratorioExterno labExterno, boolean agruparMultiguia) {
        RetornoImpressaoEtiquetas retorno = new RetornoImpressaoEtiquetas();
        try {
            this.registro = ConfiguradorProtocoloJalis.xmlToRegistro(configuracaoLabExterno);
            this.ws = new WSCliente(this.registro.getString("servidorRMI"), Integer.parseInt(this.registro.getString("portaServidor")));
            if (!ImportacaoJalis.validaCliente(this.ws, this.registro.getString("filialSelecionada"), this.registro.getString("codigoCliente"))) {
                if (isColetaWeb) {
                    UtilExportadores.adicionarMensagemRetorno("O servidor remoto n\u00e3o autenticou sua conex\u00e3o.<br>Entre em contato com o laborat\u00f3rio de apoio.", Protocolo.Jalis.getDescricao(), retorno);
                } else {
                    Funcoes.mensagem(Laboratorio.getInstancia(), "O servidor remoto n\u00e3o autenticou sua conex\u00e3o.\nEntre em contato com o laborat\u00f3rio de apoio.", 1);
                }
                retorno.setImprimiu(false);
                return retorno;
            }
            if (!ImportacaoJalis.validaConvenio(this.ws, this.registro.getString("filialSelecionada"), this.registro.getString("codigoConvenio"))) {
                if (isColetaWeb) {
                    UtilExportadores.adicionarMensagemRetorno("O conv\u00eanio informado n\u00e3o est\u00e1 autorizado a receber dados do servidor de apoio.<br>Entre em contato com o laborat\u00f3rio de apoio.", Protocolo.Jalis.getDescricao(), retorno);
                } else {
                    Funcoes.mensagem(Laboratorio.getInstancia(), "O conv\u00eanio informado n\u00e3o est\u00e1 autorizado a receber dados do servidor de apoio.\nEntre em contato com o laborat\u00f3rio de apoio.", 1);
                }
                retorno.setImprimiu(false);
                return retorno;
            }
            for (Registro requisicao : requisicoes) {
                this.enviarPaciente(isColetaWeb, st, this.ws, this.registro.getString("filialSelecionada"), this.registro.getString("codigoConvenio"), requisicao.getString("req_codigo"), codigoLabExterno, reenvio, requisicao.getString("fil_codigo"));
            }
            this.criarLote(this.ws, this.registro.getString("filialSelecionada"), this.registro.getString("codigoConvenio"), Integer.parseInt(numeroLote), reenvio, codigoLabExterno, this.registro.getBoolean("enviarEtiquetaApoio"), st, Variaveis.tipoFilialPadrao, isColetaWeb, arquivar);
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "ExportacaoParaJalis (118)");
            retorno.setImprimiu(false);
            return retorno;
        }
        retorno.setImprimiu(true);
        return retorno;
    }

    private void criarLote(WSCliente ws, String codigoFilialApoio, String codigoConvenio, Integer codigoLote, boolean reenvio, String codigoLabExterno, boolean isEnviarEtiquetaApoio, Statement st, String tipoFilialPadrao, boolean isColetaWeb, Callable<Boolean> arquivar) throws Exception {
        this.codigoConvenio = codigoConvenio;
        Apoiado apoiado = new Apoiado(Integer.parseInt(codigoFilialApoio), tipoFilialPadrao, Integer.parseInt(codigoConvenio));
        ParametroSet param = new ParametroSet();
        param.setString("chave", apoiado.getChave());
        this.exr_codigoapoiado = DBUtil.campoExiste(st, "examerequisicao", "exr_codigoapoiado");
        StringBuilder buf = new StringBuilder("select * from loteexterno where lex_codigo = ");
        buf.append(codigoLote).append(" and lae_codigo = ").append(codigoLabExterno).append(" and fil_codigo = ").append(Variaveis.filialPadrao);
        buf.append(" and lex_dataenvio is null ");
        ResultSet rs = st.executeQuery(buf.toString());
        if (rs.next()) {
            Lote lote = new Lote(rs.getInt("lex_codigo"), rs.getTimestamp("lex_datahora"));
            buf.setLength(0);
            buf.append("select a.req_codigo, a.exr_situacao,  ");
            buf.append("a.exr_dataentregaprev, ");
            buf.append("pegaResultadoExame(a.fil_codigo, a.req_codigo, a.exa_codigo, a.mco_codigo) as exr_resultado, a.exr_resposta, a.met_codigo, a.usr_codassina, ");
            buf.append("a.exa_codigo, a.mco_codigo, ");
            buf.append("a.exr_descricaomaterial, a.exr_volumediurese, ");
            buf.append("a.exr_obs, a.exr_datacortesia, a.usr_codcortesia, ");
            buf.append("a.exr_data, a.exr_intervalojejum, a.exr_tempodiurese, ");
            buf.append("a.exa_codigo as exr_codexameorigem, a.mco_codigo as exr_codmatorigem ");
            if (this.exr_codigoapoiado) {
                buf.append(" , a.exr_codigoapoiado ");
            }
            buf.append("from examerequisicao a ");
            buf.append("left join loteexternoexamerequisicao b on a.fil_codigo = b.fil_kodigo and a.req_codigo = b.req_codigo and a.exa_codigo = b.exa_codigo and a.mco_codigo = b.mco_codigo ");
            buf.append("left join loteexterno c on b.fil_codigo = c.fil_codigo and  b.lex_codigo = c.lex_codigo ");
            buf.append("where a.req_codigo = ? and c.fil_codigo = ?  and c.lae_codigo = ? and c.lex_codigo = ? ");
            buf.append("and lex_dataenvio is null ");
            PreparedStatement psRequisicaoExame = st.getConnection().prepareStatement(buf.toString(), 1004, 1007);
            buf.setLength(0);
            buf.append("select ele_xmllabexterno ");
            buf.append("from examematcoletalabexterno ");
            buf.append("where fil_codigo = ? and exa_codigo = ? and mco_codigo = ? and lae_codigo = ?");
            buf.append("  and ele_xmllabexterno is not null and ele_xmllabexterno <> '' ");
            PreparedStatement psRequisicaoExameRelacionada = st.getConnection().prepareStatement(buf.toString(), 1004, 1007);
            buf.setLength(0);
            buf.append("select a.*, b.ple_codigo, c.med_nome ");
            buf.append("from loteexternorequisicao lr ");
            buf.append("join loteexterno l on l.fil_codigo = lr.fil_codigo and l.lex_codigo = lr.lex_codigo and l.lae_codigo = lr.lae_codigo ");
            buf.append("left join requisicao a on a.req_codigo = lr.req_codigo and a.fil_codigo = lr.fil_kodigo ");
            buf.append("left join pacientelabexterno b on a.pac_codigo = b.pac_codigo and a.fil_codigo = b.fil_codigo and l.lae_codigo = b.lae_codigo ");
            buf.append("left join medico c on a.fil_codigo = c.fil_codigo and a.med_conselho = c.med_conselho and a.med_crm = c.med_crm and a.med_uf = c.med_uf ");
            buf.append("where l.lex_codigo = ?  and l.fil_codigo = ? and l.lae_codigo = ? ");
            buf.append("order by a.req_codigo");
            PreparedStatement psRequisicao = st.getConnection().prepareStatement(buf.toString(), 1004, 1007);
            psRequisicao.setInt(1, codigoLote);
            psRequisicao.setInt(2, Integer.parseInt(Variaveis.filialPadrao));
            psRequisicao.setInt(3, Integer.parseInt(codigoLabExterno));
            ResultSet rsRequisicao = psRequisicao.executeQuery();
            while (rsRequisicao.next()) {
                Requisicao req = new Requisicao(this.getCodigoEnvio(rsRequisicao));
                Object[] multiguias = RecepcaoUtil.verificaMultiGuias(st, rsRequisicao.getString("fil_codigo"), rsRequisicao.getString("req_codigo"), true);
                if (multiguias != null && multiguias.length > 0) {
                    Arrays.sort(multiguias);
                    req.setCodigoMaeMultiguia(String.valueOf(multiguias[0]));
                }
                req.setData(rsRequisicao.getDate("req_data"));
                req.setHora(Funcoes.formataData("HH:mm", new Date(rsRequisicao.getTime("req_hora").getTime())));
                req.setObservacao(StringUtil.tratarEntidadesHTML(rsRequisicao.getString("req_obs")));
                req.setIdade(rsRequisicao.getInt("req_idade"));
                req.setTipoIdade(rsRequisicao.getString("req_anomes"));
                req.setAltura(Float.valueOf(rsRequisicao.getFloat("req_altura")));
                req.setPeso(Float.valueOf(rsRequisicao.getFloat("req_peso")));
                req.setMedico(new Medico(rsRequisicao.getString("med_conselho"), rsRequisicao.getString("med_crm"), rsRequisicao.getString("med_uf"), rsRequisicao.getString("med_nome")));
                if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("C") || Variaveis.tipoFilialPadrao.equalsIgnoreCase("V")) {
                    Paciente pac = new Paciente(rsRequisicao.getLong("pac_codigo"), null);
                    pac.setCodigoServidor(rsRequisicao.getLong("ple_codigo"));
                    req.setPaciente(pac);
                    req.setTipoIdade(rsRequisicao.getString("req_anomes"));
                    req.setIdade(rsRequisicao.getInt("req_idade"));
                    req.setDadosClinicos(StringUtil.tratarEntidadesHTML(rsRequisicao.getString("req_dclinicos")));
                    req.setGestante(rsRequisicao.getBoolean("req_gestante"));
                    req.setDum(rsRequisicao.getDate("req_dum"));
                    req.setDumNaoInformado(rsRequisicao.getBoolean("req_dumnaoinformado"));
                    req.setNeoNatal(rsRequisicao.getBoolean("req_neonato"));
                    if (rsRequisicao.getObject("req_altura") != null) {
                        req.setAltura(Float.valueOf(rsRequisicao.getFloat("req_altura")));
                    }
                    if (rsRequisicao.getObject("req_peso") != null) {
                        req.setPeso(Float.valueOf(rsRequisicao.getFloat("req_peso")));
                    }
                    req.setCodigoConvenio(rsRequisicao.getInt("con_codigo"));
                } else if (tipoFilialPadrao.equalsIgnoreCase("A")) {
                    req.setCodigoResponsavel(rsRequisicao.getInt("ent_codigo"));
                    req.setCodigoColeta(rsRequisicao.getString("col_codigo"));
                    req.setCodigoDestino(rsRequisicao.getString("des_codigo"));
                    req.setUrgente(rsRequisicao.getBoolean("req_urgente"));
                    Produto prd = new Produto();
                    prd.setDescricao(rsRequisicao.getString("req_descricaoproduto"));
                    prd.setArea(rsRequisicao.getString("req_areaproduto"));
                    prd.setMarca(rsRequisicao.getString("req_marcaproduto"));
                    prd.setDataFabricacao(rsRequisicao.getString("req_datafabricacao"));
                    prd.setDataValidade(rsRequisicao.getString("req_datavalidade"));
                    prd.setLote(rsRequisicao.getString("req_numeroloteproduto"));
                    prd.setRegistro(rsRequisicao.getString("req_numeroregistroproduto"));
                    prd.setDocumento(rsRequisicao.getString("req_doctoreferenciaproduto"));
                    prd.setLacre(rsRequisicao.getString("req_lacreproduto"));
                    prd.setLacreContraprova(rsRequisicao.getString("req_lacreprodutocontra"));
                    prd.setLacreContraprovaEmpresa(rsRequisicao.getString("req_lacreprodutocontraempresa"));
                    prd.setSolicitacao(rsRequisicao.getString("req_nrsolicitacaoproduto"));
                    prd.setLocalColeta(rsRequisicao.getString("req_localcoletaproduto"));
                    prd.setDataColeta(rsRequisicao.getDate("req_datacoletaproduto"));
                    prd.setDataRecebimento(rsRequisicao.getDate("req_datarecebimentoproduto"));
                    prd.setHoraColeta(rsRequisicao.getString("req_horacoletaproduto"));
                    prd.setHoraRecebimento(rsRequisicao.getString("req_horarecebimentoproduto"));
                    prd.setTemperaturaColeta(rsRequisicao.getString("req_temperaturacoletaproduto"));
                    prd.setTemperaturaRecebimento(rsRequisicao.getString("req_temperaturarecebimento"));
                    prd.setPartida(rsRequisicao.getString("req_partidaproduto"));
                    prd.setCodigoEmbalagem(rsRequisicao.getInt("emb_codigo"));
                    prd.setQtAmostras(rsRequisicao.getInt("req_qtdeamostraproduto"));
                    prd.setQtUnidade(rsRequisicao.getDouble("req_qtdeunidadeproduto"));
                    prd.setCodigoUnidade(rsRequisicao.getString("unm_codigo"));
                    prd.setTipoRecebimento(rsRequisicao.getString("req_tiporecebimentoproduto"));
                    prd.setSanitarias(rsRequisicao.getString("req_sanitariasproduto"));
                    prd.setCondicoes(rsRequisicao.getString("req_condicoesambproduto"));
                    prd.setProcedimento(rsRequisicao.getString("req_procedimentocoletaproduto"));
                    prd.setAnoPRP(rsRequisicao.getInt("req_anoprpproduto"));
                    prd.setCicloPRP(rsRequisicao.getString("req_cicloprpproduto"));
                    prd.setAmostraPRP(rsRequisicao.getString("req_amostraprpproduto"));
                    prd.setAmostraSupervisaoPRP(rsRequisicao.getString("req_amostrasupprpproduto"));
                    prd.setHoraTurnoPRP(rsRequisicao.getString("req_horainicioturnoprpproduto"));
                    prd.setTurnoPRP(rsRequisicao.getString("req_turnoprpproduto"));
                    prd.setLinhaPRP(rsRequisicao.getString("req_linhaprpproduto"));
                    prd.setVolumeAbatePRP(rsRequisicao.getString("req_volumeabateprpproduto"));
                    req.setProduto(prd);
                }
                psRequisicaoExame.clearParameters();
                psRequisicaoExame.setLong(1, this.getCodigoLocal(req.getCodigo()));
                psRequisicaoExame.setInt(2, Integer.parseInt(Variaveis.filialPadrao));
                psRequisicaoExame.setInt(3, Integer.parseInt(codigoLabExterno));
                psRequisicaoExame.setInt(4, codigoLote);
                ResultSet rsExame = psRequisicaoExame.executeQuery();
                while (rsExame.next()) {
                    psRequisicaoExameRelacionada.clearParameters();
                    psRequisicaoExameRelacionada.setInt(1, Integer.parseInt(Variaveis.filialPadrao));
                    psRequisicaoExameRelacionada.setString(2, rsExame.getString("exa_codigo"));
                    psRequisicaoExameRelacionada.setInt(3, rsExame.getInt("mco_codigo"));
                    psRequisicaoExameRelacionada.setInt(4, Integer.parseInt(codigoLabExterno));
                    ResultSet rsRequisicaoExameRelacionada = psRequisicaoExameRelacionada.executeQuery();
                    if (!rsRequisicaoExameRelacionada.next() || Funcoes.textoVazio(rsRequisicaoExameRelacionada.getString("ele_xmllabexterno"))) continue;
                    String codigoExameExt = StringUtil.getValor(StringUtil.getValor(rsRequisicaoExameRelacionada.getString("ele_xmllabexterno"), "exame"), "codigoExame");
                    String codigoMaterialExt = StringUtil.getValor(StringUtil.getValor(rsRequisicaoExameRelacionada.getString("ele_xmllabexterno"), "exame"), "codigoMaterial");
                    ExameRequisicao ex = new ExameRequisicao(req.getCodigo(), codigoExameExt, Integer.parseInt(codigoMaterialExt));
                    String resposta = rsExame.getString("exr_resposta");
                    ex.setResposta(resposta);
                    ex.setMetodo(rsExame.getInt("met_codigo"));
                    if (rsExame.getObject("exr_volumediurese") != null) {
                        ex.setVolumeDiurese(Float.valueOf(rsExame.getFloat("exr_volumediurese")));
                    }
                    ex.setTempoDiurese(rsExame.getString("exr_tempodiurese"));
                    ex.setObservacao(rsExame.getString("exr_obs"));
                    ex.setData(rsExame.getDate("exr_data"));
                    ex.setTempoJejum(rsExame.getString("exr_intervalojejum"));
                    ex.setMaterialDescricao(rsExame.getString("exr_descricaomaterial"));
                    ex.setExameOrigem(rsExame.getString("exa_codigo"));
                    ex.setMaterialOrigem(rsExame.getInt("mco_codigo"));
                    ex.setMaterialOrigem(rsExame.getInt("mco_codigo"));
                    if (this.exr_codigoapoiado) {
                        ex.setCodigoApoiado(rsExame.getString("exr_codigoapoiado"));
                    }
                    req.addExame(ex);
                }
                lote.addRequisicao(req);
            }
            ExportacaoParaJalis.enviarLote(ws, apoiado.getChave(), lote, isEnviarEtiquetaApoio);
            StringBuilder etiquetas = new StringBuilder();
            for (Requisicao req : lote.getRequisicoes()) {
                if (!reenvio) {
                    buf.setLength(0);
                    String codigo = Funcoes.preencheZero(req.getCodigo(), ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao());
                    String filial = codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
                    String requisicao = codigo.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboFilial());
                    if (filial.equals(Funcoes.preencheZero(0, ParametrosGerais.getDigitosTuboFilial()))) {
                        filial = Variaveis.filialPadrao;
                    }
                    buf.append("select req_codigo from requisicaolabexterno where ");
                    buf.append("fil_codigo = ").append(filial);
                    buf.append(" and req_codigo = ").append(requisicao);
                    buf.append(" and lae_codigo = ").append(codigoLabExterno);
                    if (!st.executeQuery(buf.toString()).next()) {
                        buf.setLength(0);
                        buf.append("insert into requisicaolabexterno (fil_codigo, req_codigo, rle_codigo, lae_codigo) values (");
                        buf.append(filial).append(", ").append(requisicao);
                        buf.append(", '").append(req.getCodigoServidor()).append("', ").append(codigoLabExterno).append(")");
                        st.execute(buf.toString());
                    }
                }
                if (Funcoes.textoVazio(req.getEtiqueta())) continue;
                etiquetas.append(req.getEtiqueta());
            }
            this.ws = ws;
            this.etq = StringUtil.xmlToTexto(etiquetas.toString());
            buf.delete(0, buf.length());
            buf.append("update loteexterno set lex_dataenvio = current_timestamp, usr_codenvio = '");
            buf.append(Variaveis.login).append("' ");
            buf.append("where fil_codigo = ").append(Variaveis.filialPadrao);
            buf.append(" and lex_codigo = ").append(codigoLote);
            buf.append(" and lae_codigo = ").append(codigoLabExterno);
            if (isColetaWeb) {
                st.executeUpdate(buf.toString());
            } else {
                Conexao.execute(Variaveis.filialPadrao, st, buf);
            }
            arquivar.call();
        }
    }

    @Override
    public byte[] imprimeRelatorio(boolean isColetaWeb, String codLabExterno, String numeroLote, List<Registro> requisicoesListaOriginal, int colunaOrdenacao, Statement st, int filialPadrao, int digitosTuboRequisicao, int digitosTuboFilial, String impressoraRelatorio) throws Exception {
        String relatorio = this.getModeloRelatorio(this.ws);
        UtilJalis.imprimirRelatorio(st, StringUtil.xmlToTexto(relatorio), String.valueOf(numeroLote), Variaveis.filialPadrao, this.codigoConvenio, codLabExterno);
        if (!Funcoes.textoVazio(this.etq)) {
            ImpressaoTermica termica = new ImpressaoTermica(ParametrosLocais.getParametro("impressoraEtqColeta"), false);
            termica.imprimirDireto(this.etq);
        }
        return null;
    }

    private static void enviarLote(WSCliente ws, String chave, Lote lote, boolean isEnviarEtiquetaApoio) throws RemoteException {
        ParametroSet param = new ParametroSet();
        param.setString("chave", chave);
        param.setParametroSet("lote", ExportacaoParaJalis.loteToParam(lote));
        param.setBoolean("apoio", false);
        param.setBoolean("enviarEtiquetaApoio", isEnviarEtiquetaApoio);
        ParametroSet paramRetorno = ws.executaAcao("enviarLote", param);
        if (paramRetorno.getListParam("requisicoes") != null) {
            HashMap<Long, Requisicao> requisicoesPorCodigo = new HashMap<Long, Requisicao>();
            for (Requisicao req : lote.getRequisicoes()) {
                requisicoesPorCodigo.put(req.getCodigo(), req);
            }
            for (ParametroSet reqParam : paramRetorno.getListParam("requisicoes")) {
                Requisicao req = (Requisicao)requisicoesPorCodigo.get(reqParam.getLong("codigo"));
                req.setCodigoServidor(reqParam.getLong("codigoServidor"));
                if (reqParam.getString("etiqueta") == null) continue;
                req.setEtiqueta(StringUtil.arrumaEtiqueta(reqParam.getString("etiqueta")));
            }
        }
    }

    private static ParametroSet loteToParam(Lote lote) {
        ParametroSet paramLote = new ParametroSet();
        paramLote.setInt("codigo", lote.getCodigo());
        paramLote.setDate("data", lote.getData());
        paramLote.setString("caixa", lote.getCaixa());
        ArrayList<ParametroSet> paramRequisicoes = new ArrayList<ParametroSet>();
        for (Requisicao req : lote.getRequisicoes()) {
            ParametroSet paramReq = new ParametroSet();
            paramReq.setLong("codigoRequisicao", req.getCodigo());
            paramReq.setString("codigoMaeMultiguia", req.getCodigoMaeMultiguia());
            paramReq.setDate("data", req.getData());
            paramReq.setString("hora", req.getHora());
            paramReq.setInt("idade", req.getIdade());
            paramReq.setString("tipoidade", req.getTipoIdade());
            paramReq.setFloat("peso", req.getPeso());
            paramReq.setFloat("altura", req.getAltura());
            paramReq.setString("obs", req.getObservacao());
            if (req.getMedico() != null) {
                paramReq.setString("medicoConselho", req.getMedico().getConselho());
                paramReq.setString("medicoCrm", req.getMedico().getCrm());
                paramReq.setString("medicoUf", req.getMedico().getUf());
                paramReq.setString("medicoNome", req.getMedico().getNome());
            }
            if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("C") || Variaveis.tipoFilialPadrao.equalsIgnoreCase("V")) {
                paramReq.setLong("codigoPacienteServidor", req.getPaciente().getCodigoServidor());
                paramReq.setString("tipoIdade", req.getTipoIdade());
                paramReq.setInt("idade", req.getIdade());
                paramReq.setString("dadosClinicos", req.getDadosClinicos());
                paramReq.setBoolean("gestante", req.isGestante());
                paramReq.setDate("dum", req.getDum());
                paramReq.setBoolean("dumNaoInformado", req.isDumNaoInformado());
                paramReq.setBoolean("neonato", req.isNeoNatal());
                paramReq.setFloat("altura", req.getAltura());
                paramReq.setFloat("peso", req.getPeso());
                paramReq.setInt("convenioApoiado", req.getCodigoConvenio());
            } else if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("A")) {
                paramReq.setInt("codigoResponsavel", req.getCodigoResponsavel());
                paramReq.setString("codigoColeta", req.getCodigoColeta());
                paramReq.setString("codigoDestino", req.getCodigoDestino());
                paramReq.setBoolean("urgente", req.isUrgente());
                Produto prd = req.getProduto();
                ParametroSet paramPrd = new ParametroSet();
                paramPrd.setString("descricao", prd.getDescricao());
                paramPrd.setString("area", prd.getArea());
                paramPrd.setString("marca", prd.getMarca());
                paramPrd.setString("dataFabricacao", prd.getDataFabricacao());
                paramPrd.setString("dataValidade", prd.getDataValidade());
                paramPrd.setString("lote", prd.getLote());
                paramPrd.setString("registro", prd.getRegistro());
                paramPrd.setString("documento", prd.getDocumento());
                paramPrd.setString("lacre", prd.getLacre());
                paramPrd.setString("lacreContraprova", prd.getLacreContraprova());
                paramPrd.setString("lacreContraprovaEmpresa", prd.getLacreContraprovaEmpresa());
                paramPrd.setString("solicitacao", prd.getSolicitacao());
                paramPrd.setString("localColeta", prd.getLocalColeta());
                paramPrd.setDate("dataColeta", prd.getDataColeta());
                paramPrd.setDate("dataRecebimento", prd.getDataRecebimento());
                paramPrd.setString("horaColeta", prd.getHoraColeta());
                paramPrd.setString("horaRecebimento", prd.getHoraRecebimento());
                paramPrd.setString("temperaturaColeta", prd.getTemperaturaColeta());
                paramPrd.setString("temperaturaRecebimento", prd.getTemperaturaRecebimento());
                paramPrd.setString("partida", prd.getPartida());
                paramPrd.setInt("codigoEmbalagem", prd.getCodigoEmbalagem());
                paramPrd.setInt("qtAmostras", prd.getQtAmostras());
                paramPrd.setDouble("qtUnidade", prd.getQtUnidade());
                paramPrd.setString("codigoUnidade", prd.getCodigoUnidade());
                paramPrd.setString("tipoRecebimento", prd.getTipoRecebimento());
                paramPrd.setString("sanitarias", prd.getSanitarias());
                paramPrd.setString("condicoes", prd.getCondicoes());
                paramPrd.setString("procedimento", prd.getProcedimento());
                paramPrd.setInt("anoPRP", prd.getAnoPRP());
                paramPrd.setString("cicloPRP", prd.getCicloPRP());
                paramPrd.setString("amostraPRP", prd.getAmostraPRP());
                paramPrd.setString("amostraSupervisaoPRP", prd.getAmostraSupervisaoPRP());
                paramPrd.setString("horaTurnoPRP", prd.getHoraTurnoPRP());
                paramPrd.setString("turnoPRP", prd.getTurnoPRP());
                paramPrd.setString("linhaPRP", prd.getLinhaPRP());
                paramPrd.setString("volumeAbatePRP", prd.getVolumeAbatePRP());
                paramReq.setParametroSet("produto", paramPrd);
            }
            if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("C") || Variaveis.tipoFilialPadrao.equalsIgnoreCase("V")) {
                ArrayList<ParametroSet> paramMedicamentos = new ArrayList<ParametroSet>();
                for (MedicamentoRequisicao med : req.getMedicamentos()) {
                    ParametroSet paramMed = new ParametroSet();
                    paramMed.setInt("codigoMedicamento", med.getCodigoMedicamento());
                    paramMed.setString("dosagem", med.getDosagem());
                    paramMed.setString("horaDosagem", med.getHoraDosagem());
                    paramMed.setDate("dataDosagem", med.getDataDosagem());
                    paramMedicamentos.add(paramMed);
                }
                paramReq.setListParam("medicamentos", paramMedicamentos);
            }
            ArrayList<ParametroSet> paramExames = new ArrayList<ParametroSet>();
            for (ExameRequisicao ex : req.getExames()) {
                ParametroSet paramEx = new ParametroSet();
                paramEx.setString("codigoExame", ex.getId().getCodigoExame());
                paramEx.setInt("codigoMaterial", ex.getId().getCodigoMaterial());
                paramEx.setString("descricaoMaterial", ex.getMaterialDescricao());
                paramEx.setString("resposta", ex.getResposta());
                paramEx.setInt("metodo", ex.getMetodo());
                paramEx.setFloat("volumeDiurese", ex.getVolumeDiurese());
                paramEx.setString("tempoDiurese", ex.getTempoDiurese());
                paramEx.setString("obs", ex.getObservacao());
                paramEx.setDate("data", ex.getData());
                paramEx.setString("tempoJejum", ex.getTempoJejum());
                paramEx.setString("codexameorigem", ex.getExameOrigem());
                paramEx.setInt("codmatorigem", ex.getMaterialOrigem());
                paramEx.setString("codigoApoiado", ex.getCodigoApoiado());
                paramExames.add(paramEx);
            }
            paramReq.setListParam("exames", paramExames);
            paramRequisicoes.add(paramReq);
        }
        paramLote.setListParam("requisicoes", paramRequisicoes);
        return paramLote;
    }

    private void enviarPaciente(boolean isColetaWeb, Statement st, WSCliente ws, String filialApoio, String convenio, String requisicao, String codigoLabExterno, boolean reenvio, String filialRequisicao) throws Exception, SQLException {
        StringBuilder buf = new StringBuilder("select c.pac_codigo, c.pac_nome, c.pac_sexo, ");
        buf.append("c.pac_datanasc, c.pac_vip, c.pac_grpsangue, c.pac_fatorrh, c.pac_fatordu, ");
        buf.append("c.pac_cor, c.pac_observ, c.pac_dadoclinico, c.pac_peso, c.pac_altura, ");
        buf.append("c.pac_matricconv, c.pac_titularconv, c.pac_profissao, c.pac_fumante, ");
        buf.append("c.pac_diabetico, c.pac_rg, c.pac_cpf, c.pac_estcivil, c.pac_numfilho, ");
        buf.append("c.pac_datahora, c.pac_dum, c.pac_fax, c.pac_celular, ");
        buf.append("c.pac_fonecomercial, c.pac_fone, c.pac_cep, c.pac_complemento, ");
        buf.append("c.pac_endereco, c.pac_numeroendereco, c.pac_tipologradouroendereco, c.pac_email, c.pac_anomes, c.pac_idade, ");
        buf.append("c.pac_fonecontato, c.pac_nomecontato, ");
        buf.append("c.pac_mae, c.pac_pai, c.pac_maladireta, d.ple_codigo, ");
        buf.append("c.bai_codigo, c.cid_codigo, c.con_codigo, c.epc_codigo, c.fil_codigo, c.med_conselho, c.med_crm, ");
        buf.append("c.med_uf, c.pac_datahoraalteracao, c.pac_pelagem, c.pac_proprietario, ");
        buf.append("c.pac_senhaweb, c.rac_codigo, c.usr_codalteracao ");
        buf.append("from requisicao b ");
        buf.append("left join paciente c on b.fil_codigo = c.fil_codigo and b.pac_codigo = c.pac_codigo ");
        buf.append("left join pacientelabexterno d on b.fil_codigo = d.fil_codigo and b.pac_codigo = d.pac_codigo and d.lae_codigo = ").append(codigoLabExterno).append(" ");
        buf.append("where b.fil_codigo = ").append(filialRequisicao);
        buf.append(" and b.req_codigo = ").append(requisicao);
        buf.append(" and (d.ple_exportado is null or d.ple_exportado = false) ");
        ResultSet rs = st.executeQuery(buf.toString());
        if (rs.next()) {
            String codPaciente = rs.getString("pac_codigo");
            ParametroSet resultado = this.enviarPaciente(ws, filialApoio, convenio, rs);
            if (resultado.getLong("codigo") != null) {
                long novoCodigo = resultado.getLong("codigo");
                buf.setLength(0);
                buf.append("select ple_codigo ");
                buf.append("from pacientelabexterno ");
                buf.append("where fil_codigo = ").append(filialRequisicao).append(" and pac_codigo = ").append(codPaciente);
                buf.append(" and lae_codigo = ").append(codigoLabExterno);
                ResultSet rsPle = st.executeQuery(buf.toString());
                if (!reenvio && !rsPle.next()) {
                    buf.setLength(0);
                    buf.append("insert into pacientelabexterno (fil_codigo, pac_codigo, lae_codigo, ple_codigo, ple_exportado) values (");
                    buf.append(filialRequisicao).append(", ").append(codPaciente);
                    buf.append(", ").append(codigoLabExterno).append(", ").append(novoCodigo).append(", true)");
                    if (isColetaWeb) {
                        st.executeUpdate(buf.toString());
                    } else {
                        Conexao.execute(filialRequisicao, st, buf.toString());
                    }
                } else {
                    buf.setLength(0);
                    buf.append("update pacientelabexterno set ple_exportado = true ");
                    if (rsPle.getLong("ple_codigo") != novoCodigo) {
                        buf.append(", ple_codigo = ").append(novoCodigo);
                    }
                    buf.append(" where fil_codigo = ").append(filialRequisicao).append(" and pac_codigo = ").append(codPaciente);
                    buf.append(" and lae_codigo = ").append(codigoLabExterno);
                    if (isColetaWeb) {
                        st.executeUpdate(buf.toString());
                    } else {
                        Conexao.execute(filialRequisicao, st, buf.toString());
                    }
                }
            }
        }
    }

    private ParametroSet enviarPaciente(WSCliente ws, String filialApoio, String convenio, ResultSet rs) throws Exception {
        Apoiado apoiado = new Apoiado(Integer.parseInt(filialApoio), Variaveis.tipoFilialPadrao, Integer.parseInt(convenio));
        ParametroSet param = new ParametroSet();
        param.setString("chave", apoiado.getChave());
        ParametroSet pac = new ParametroSet();
        pac.setLong("codigo", rs.getLong("pac_codigo"));
        pac.setString("nome", rs.getString("pac_nome"));
        pac.setString("sexo", rs.getString("pac_sexo"));
        pac.setDate("nascimento", rs.getDate("pac_datanasc"));
        pac.setBoolean("vip", rs.getBoolean("pac_vip"));
        pac.setString("grupoSangue", rs.getString("pac_grpsangue"));
        pac.setString("fatorRH", rs.getString("pac_fatorrh"));
        pac.setString("fatorDU", rs.getString("pac_fatordu"));
        pac.setString("cor", rs.getString("pac_cor"));
        pac.setString("observacao", StringUtil.tratarEntidadesHTML(rs.getString("pac_observ")));
        pac.setString("dadosClinicos", StringUtil.tratarEntidadesHTML(rs.getString("pac_dadoclinico")));
        if (rs.getObject("pac_peso") != null) {
            pac.setFloat("peso", Float.valueOf(rs.getFloat("pac_peso")));
        }
        if (rs.getObject("pac_altura") != null) {
            pac.setFloat("altura", Float.valueOf(rs.getFloat("pac_altura")));
        }
        pac.setString("matriculaConvenio", rs.getString("pac_matricconv"));
        pac.setString("titularConvenio", rs.getString("pac_titularconv"));
        pac.setString("profissao", rs.getString("pac_profissao"));
        if (rs.getObject("pac_fumante") != null) {
            pac.setBoolean("fumante", rs.getBoolean("pac_fumante"));
        }
        if (rs.getObject("pac_diabetico") != null) {
            pac.setBoolean("diabetico", rs.getBoolean("pac_diabetico"));
        }
        pac.setString("rg", rs.getString("pac_rg"));
        pac.setString("cpf", rs.getString("pac_cpf"));
        pac.setString("estadoCivil", rs.getString("pac_estcivil"));
        pac.setInt("numeroFilhos", rs.getInt("pac_numfilho"));
        pac.setDate("dum", rs.getDate("pac_dum"));
        pac.setString("fax", rs.getString("pac_fax"));
        pac.setString("celular", rs.getString("pac_celular"));
        pac.setString("foneComercial", rs.getString("pac_fonecomercial"));
        pac.setString("fone", rs.getString("pac_fone"));
        pac.setString("cep", rs.getString("pac_cep"));
        pac.setString("complemento", rs.getString("pac_complemento"));
        pac.setString("endereco", rs.getString("pac_endereco"));
        pac.setString("numeroEndereco", rs.getString("pac_numeroendereco"));
        pac.setString("email", rs.getString("pac_email"));
        pac.setString("tipoIdade", rs.getString("pac_anomes"));
        pac.setInt("idade", rs.getInt("pac_idade"));
        pac.setString("foneContato", rs.getString("pac_fonecontato"));
        pac.setString("nomeContato", rs.getString("pac_nomecontato"));
        pac.setString("mae", rs.getString("pac_mae"));
        pac.setString("pai", rs.getString("pac_pai"));
        pac.setBoolean("malaDireta", rs.getBoolean("pac_maladireta"));
        if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("V")) {
            pac.setString("proprietario", rs.getString("pac_proprietario"));
            pac.setString("pelagem", rs.getString("pac_pelagem"));
            if (rs.getInt("epc_codigo") != 0) {
                pac.setInt("especie", rs.getInt("epc_codigo"));
                if (rs.getInt("rac_codigo") != 0) {
                    pac.setInt("raca", rs.getInt("rac_codigo"));
                }
            }
        }
        param.setParametroSet("paciente", pac);
        ParametroSet paramRetorno = ws.executaAcao("enviarPaciente", param);
        return paramRetorno;
    }

    private String getModeloRelatorio(WSCliente ws) throws Exception {
        ParametroSet paramRetorno = ws.executaAcao("getModeloRelatorio");
        return paramRetorno.getString("relatorio");
    }

    private Long getCodigoEnvio(ResultSet rs) throws Exception {
        StringBuilder codigoReq = new StringBuilder();
        codigoReq.append(Funcoes.preencheZero(rs.getString("fil_codigo"), ParametrosGerais.getDigitosTuboFilial()));
        codigoReq.append(Funcoes.preencheZero(rs.getString("req_codigo"), ParametrosGerais.getDigitosTuboRequisicao()));
        return Long.parseLong(codigoReq.toString());
    }

    private Long getCodigoLocal(Long codigo) {
        String retorno = Funcoes.preencheZero(codigo, ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao());
        return Long.parseLong(retorno.substring(ParametrosGerais.getDigitosTuboFilial()));
    }

    private String criaXMLRequisicao(Statement st, String codigoRequisicao, String exames, String codigoLabExterno) throws Exception {
        StringBuilder buf = new StringBuilder("select a.req_codigo,  ");
        buf.append("d.ple_codigo as pac_codigo, a.req_data, ");
        buf.append("a.req_dtfatura, a.req_urgente, a.req_dataentregaprev, a.req_dclinicos, a.req_obs, ");
        buf.append("a.req_totpago, a.req_total, a.req_horaentregaprev, a.req_horafatura, a.req_hora, ");
        buf.append("a.req_gestante, a.req_dum, a.req_anomes, a.req_idade, a.req_avisarpaciente, ");
        buf.append("a.req_titular, a.req_altura, a.req_peso, ");
        buf.append("a.req_datarequisicao, a.req_neonato, c.rle_codigo ");
        buf.append("from requisicao a ");
        buf.append("left join paciente b on a.fil_codigo = b.fil_codigo and a.pac_codigo = b.pac_codigo ");
        buf.append("left join requisicaolabexterno c on a.fil_codigo = c.fil_codigo and a.req_codigo = c.req_codigo and c.lae_codigo = ").append(codigoLabExterno).append(" ");
        buf.append("left join pacientelabexterno d on a.fil_codigo = d.fil_codigo and a.pac_codigo = d.pac_codigo and d.lae_codigo = ").append(codigoLabExterno).append(" ");
        buf.append("where a.fil_codigo = ").append(Variaveis.filialPadrao);
        buf.append(" and a.req_codigo = ").append(codigoRequisicao);
        buf.append("order by a.req_codigo");
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        StringBuilder requisicao = new StringBuilder();
        if (rs.next()) {
            requisicao.append(XMLUtil.criaXML(new Registro(rs), new String[]{"req_codigo"}));
            requisicao.append(StringUtil.getTag("exames", exames));
        }
        return StringUtil.getTag("requisicao", requisicao.toString());
    }

    private String criaXMLExame(Statement st, String requisicao, String exame, String material, String exameReal, String materialReal) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append("select req_codigo, exr_situacao,  ");
        buf.append("exr_dataentregaprev, ");
        buf.append("pegaResultadoExame(fil_codigo, req_codigo, exa_codigo, mco_codigo) as exr_resultado, exr_resposta, ");
        buf.append("exa_codigo as exr_codexameorigem, mco_codigo as exr_codmatorigem, ");
        buf.append("'").append(StringUtil.textoDB(exameReal)).append("' as exa_codigo, ");
        buf.append(!Funcoes.textoVazio(materialReal) ? StringUtil.textoDB(materialReal) : " 0 ").append(" as mco_codigo, ");
        buf.append("exr_descricaomaterial, exr_volumediurese, ");
        buf.append("exr_obs,  ");
        buf.append("exr_data, exr_intervalojejum, exr_tempodiurese ");
        buf.append("from examerequisicao ");
        buf.append("where fil_codigo = ").append(Variaveis.filialPadrao);
        buf.append(" and req_codigo = ").append(requisicao);
        buf.append(" and exa_codigo = '").append(StringUtil.textoDB(exame)).append("' ");
        buf.append(" and mco_codigo = ").append(material);
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        buf.delete(0, buf.length());
        if (rs.next()) {
            buf.append(XMLUtil.criaXML("examerequisicao", new Registro(rs), new String[]{"req_codigo", "exa_codigo", "mco_codigo"}));
        }
        return buf.toString();
    }

    @Override
    public int getMaiorCodigoLote(String numeroLote, String codigoConvenio, LaboratorioExterno configuracaoLabExterno, Statement st) {
        int retorno = Integer.parseInt(numeroLote);
        try {
            Registro registro = ConfiguradorProtocoloJalis.xmlToRegistro(configuracaoLabExterno.configuracao);
            if (!Funcoes.testaConexaoWeb(registro.getString("servidorRMI"), Integer.parseInt(registro.getString("portaServidor")))) {
                Funcoes.mensagem(Laboratorio.getInstancia(), "Conex\u00e3o com a web n\u00e3o encontrada", 1);
                return retorno;
            }
            WSCliente ws = new WSCliente(registro.getString("servidorRMI"), Integer.parseInt(registro.getString("portaServidor")));
            if (!ws.isServidorOk()) {
                Funcoes.mensagem(Laboratorio.getInstancia(), "O servidor remoto n\u00e3o est\u00e1 ativado, tente novamente mais tarde", 1);
                return retorno;
            }
            ParametroSet param = new ParametroSet();
            param.setString("codigoFilial", registro.getString("filialSelecionada"));
            param.setString("codigoConvenio", codigoConvenio);
            ParametroSet paramRet = ws.executaAcao("getMaiorCodigoLote", param);
            if (paramRet.getInt("maiorcodigo") > 0 && paramRet.getInt("maiorcodigo") > retorno) {
                retorno = paramRet.getInt("maiorcodigo") + 1;
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ExportacaoParaJalis");
        }
        return retorno;
    }
}

