/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.externo.exportadores.web;

import jalis.comum.Variaveis;
import jalis.laboratorio.triagem.externo.DadosAdicionaisWeb;
import jalis.laboratorio.triagem.externo.exportadores.InfoComplementar;
import jalis.util.Funcoes;
import jalis.util.tabela.Registro;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DadosAdicionaisWebSolucao
implements DadosAdicionaisWeb {
    @Override
    public boolean carregaAdicionaisWeb(String codLabExterno, Registro requisicao, Map<String, List<InfoComplementar>> mapInfoComplementar, Statement st) {
        ArrayList exames = (ArrayList)requisicao.getValor("listaexames");
        if (exames == null || exames.isEmpty()) {
            return true;
        }
        for (Registro r : exames) {
            ArrayList examesDesm = (ArrayList)r.getValor("listaexames");
            if (examesDesm != null && !examesDesm.isEmpty()) {
                for (Registro exaDesm : examesDesm) {
                    String exame = exaDesm.getString("exa_codigo");
                    String material = exaDesm.getString("mco_codigo");
                    List<InfoComplementar> infoComplementares = mapInfoComplementar.get(this.getChaveExame(exame, material));
                    if (this.carregaDadosAdicionais(exaDesm.getString("exa_codigo"), exaDesm.getString("mco_codigo"), codLabExterno, st, exaDesm, requisicao, infoComplementares)) continue;
                    return false;
                }
                continue;
            }
            String exame = r.getString("exa_codigo");
            String material = r.getString("mco_codigo");
            List<InfoComplementar> infoComplementares = mapInfoComplementar.get(this.getChaveExame(exame, material));
            if (this.carregaDadosAdicionais(r.getString("exa_codigo"), r.getString("mco_codigo"), codLabExterno, st, r, requisicao, infoComplementares)) continue;
            return false;
        }
        return true;
    }

    private String getChaveExame(String exame, String material) {
        return exame + "|" + material;
    }

    public boolean carregaDadosAdicionais(String exame, String material, String codLabExterno, Statement st, Registro exa, Registro requisicao, List<InfoComplementar> informacoesComplementares) {
        try {
            StringBuilder sql = new StringBuilder();
            sql.append("select ele_xmllabexterno from examematcoletalabexterno");
            sql.append(" where fil_codigo = ").append(Variaveis.filialPadrao).append(" and lae_codigo = ").append(codLabExterno);
            sql.append(" and exa_codigo = '").append(exame).append("'").append(" and mco_codigo = ").append(material);
            sql.append(" and ele_xmllabexterno is not null and ele_xmllabexterno <> '' ");
            ResultSet rs = st.executeQuery(sql.toString());
            if (!rs.next()) {
                return true;
            }
            String xml = rs.getString("ele_xmllabexterno");
            if (Funcoes.textoVazio(xml)) {
                return true;
            }
            HashMap<String, String> infoComp = new HashMap<String, String>();
            if (informacoesComplementares != null && !informacoesComplementares.isEmpty()) {
                for (InfoComplementar info : informacoesComplementares) {
                    if (info.getTag().equalsIgnoreCase("VolumeDiurese") && info.getValor() != null) {
                        exa.setValor("exr_volumediurese", info.getValor());
                        continue;
                    }
                    if (info.getValor() == null) continue;
                    infoComp.put(info.getTag(), String.valueOf(info.getValor()));
                    if (info.getTag().equalsIgnoreCase("Altura")) {
                        requisicao.setValor("req_altura", String.valueOf(info.getValor()));
                        continue;
                    }
                    if (!info.getTag().equalsIgnoreCase("Peso")) continue;
                    requisicao.setValor("req_peso", String.valueOf(info.getValor()));
                }
            }
            exa.setValor("infoComp", infoComp);
            return true;
        }
        catch (SQLException e) {
            return false;
        }
    }
}

