/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.externo.exportadores.solucaov2;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.triagem.externo.LaboratorioExterno;
import jalis.laboratorio.triagem.externo.exportadores.ExameMaterialAlvaro;
import jalis.laboratorio.triagem.externo.exportadores.ExportacaoParaAlvaro;
import jalis.laboratorio.triagem.externo.exportadores.UtilExportadores;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.laboratorio.util.parsers.alvaro.LinhaResultado;
import jalis.laboratorio.util.parsers.solucaov2.ExameSolucao;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.tabela.Registro;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class ExportacaoParaSolucao
extends ExportacaoParaAlvaro {
    public ExportacaoParaSolucao() {
        super("Arquivo de exporta\u00e7\u00e3o Solu\u00e7\u00e3o V2 (*.xml)");
    }

    @Override
    public String escreveTagAmostra(Registro r, boolean isNovaAmostra, Boolean enviarLoteWebService, Map<String, String> atributos, String material, Statement st, Map<String, String> identificacaoTemp, Registro e, boolean enviarExameUrgente, boolean isAgruparGuiasInterface, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo) throws SQLException {
        boolean agruparMultiguias;
        ExameSolucao exa = new ExameSolucao(e.getString("ele_xmllabexterno"));
        String regColeta = StringUtil.getValor(e.getString("ele_xmllabexterno"), "REGIOES_COLETA");
        if (!Funcoes.textoVazio(regColeta)) {
            String[] regioes;
            for (String regiao : regioes = StringUtil.getValores(regColeta, "REGIAO_COLETA")) {
                if (!StringUtil.getValor(regiao, "selecionado").equals("true")) continue;
                String regiaoColeta = StringUtil.getValor(regiao, "CD_REGIAO_COLETA");
                exa.setMaterial(regiaoColeta);
                e.setValor("material", regiaoColeta);
                break;
            }
        }
        boolean temTempo = false;
        boolean bl = agruparMultiguias = ParametrosGerais.isAgruparGuiasInterface() || DBUtil.requisicaoAgrupaMultiguiasLabExterno(Conexao.getStatement(), e.getString("fil_codigo"), e.getString("req_codigo"));
        if (exa.getLinhasResultado().size() > 0) {
            for (LinhaResultado l : exa.getLinhasResultado()) {
                if (l.getTempos().isEmpty()) continue;
                temTempo = true;
                for (String tempo : l.getTempos()) {
                    if (this.xml.ultimaTag().equalsIgnoreCase("amostra")) {
                        this.xml.fecharTag("amostra");
                    }
                    String descricao = tempo + "min.";
                    atributos.clear();
                    atributos.put("material", e.getString("material"));
                    atributos.put("descricao", descricao);
                    if (enviarLoteWebService.booleanValue()) {
                        atributos.put("identificacao", e.getString("exr_codigoapoiado"));
                        if (!agruparMultiguias) {
                            if (Funcoes.textoVazio(atributos.get("identificacao")) || Funcoes.textoVazio(atributos.get("descricao"))) {
                                LaboratorioExterno[] labs = LaboratorioExterno.getDescricoes(st, false);
                                block3: for (LaboratorioExterno laboratorioExterno : labs) {
                                    Integer[] mulIntegers;
                                    if (!laboratorioExterno.protocolo.equals((Object)Protocolo.Alvaro)) continue;
                                    for (Integer guia : mulIntegers = RecepcaoUtil.verificaMultiGuias(e.getString("fil_codigo"), e.getString("req_codigo"), true)) {
                                        ResultSet examesRegistros = UtilExportadores.selecionaExames(e.getString("fil_codigo"), guia.toString(), null, st, laboratorioExterno, true);
                                        while (examesRegistros.next()) {
                                            if (!examesRegistros.getString("exa_codigo").equalsIgnoreCase(e.getString("exa_codigo"))) continue;
                                            atributos.put("identificacao", examesRegistros.getString("exr_codigoapoiado"));
                                            atributos.put("descricao", examesRegistros.getString("rec_descricao"));
                                            break;
                                        }
                                        if (!Funcoes.textoVazio(atributos.get("identificacao"))) continue block3;
                                    }
                                }
                            }
                            if (Funcoes.textoVazio(atributos.get("identificacao"))) {
                                atributos.put("identificacao", this.getIdentificacao(r, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo));
                            }
                            if (Funcoes.textoVazio(atributos.get("descricao"))) {
                                atributos.put("descricao", "N\u00e3o Informado");
                            }
                            if (isNovaAmostra) {
                                atributos.put("novaAmostra", "true");
                            }
                        }
                        if (!Funcoes.textoVazio(descricao)) {
                            this.xml.abrirTag("amostra", atributos);
                        }
                    } else {
                        this.xml.abrirTag("amostra", atributos);
                    }
                    if (isNovaAmostra) {
                        this.escreverExameXMLInsercao(e);
                        continue;
                    }
                    this.escreverExameXML(e, enviarLoteWebService, false, st);
                }
            }
            if (temTempo) {
                return material;
            }
        }
        if (!e.getString("material").equalsIgnoreCase(material)) {
            if (this.xml.ultimaTag().equalsIgnoreCase("amostra")) {
                this.xml.fecharTag("amostra");
            }
            atributos.clear();
            atributos.put("material", e.getString("material"));
            if (!agruparMultiguias) {
                if (Funcoes.textoVazio(e.getString("identificacao")) || Funcoes.textoVazio(e.getString("descricao"))) {
                    LaboratorioExterno[] labs;
                    block6: for (LaboratorioExterno laboratorioExterno : labs = LaboratorioExterno.getDescricoes(Conexao.getStatement(), true)) {
                        if (!laboratorioExterno.protocolo.equals((Object)Protocolo.Alvaro)) continue;
                        Integer[] mulIntegers = RecepcaoUtil.verificaMultiGuias(e.getString("fil_codigo"), e.getString("req_codigo"), true);
                        for (Integer guia : mulIntegers) {
                            ResultSet examesRegistros = UtilExportadores.selecionaExames(e.getString("fil_codigo"), guia.toString(), null, st, laboratorioExterno, true);
                            while (examesRegistros.next()) {
                                if (!examesRegistros.getString("exa_codigo").equalsIgnoreCase(e.getString("exa_codigo"))) continue;
                                atributos.put("identificacao", examesRegistros.getString("exr_codigoapoiado"));
                                atributos.put("descricao", examesRegistros.getString("rec_descricao"));
                                if (Funcoes.textoVazio(atributos.get("identificacao"))) continue;
                            }
                            if (!Funcoes.textoVazio(atributos.get("identificacao"))) continue block6;
                        }
                    }
                }
                if (Funcoes.textoVazio(atributos.get("identificacao"))) {
                    atributos.put("identificacao", this.getIdentificacao(r, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo));
                }
                if (Funcoes.textoVazio(atributos.get("descricao"))) {
                    atributos.put("descricao", "N\u00e3o Informado");
                }
                if (isNovaAmostra && !atributos.containsKey("novaAmostra")) {
                    atributos.put("novaAmostra", "true");
                }
            }
            if (Funcoes.textoVazio(atributos.get("identificacao"))) {
                atributos.put("identificacao", this.getIdentificacao(e, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo));
            }
            atributos.put("descricao", Funcoes.textoVazio(e.getString("rec_descricao")) ? (Funcoes.textoVazio(identificacaoTemp.get(e.getString("material"))) ? "N\u00e3o informado" : identificacaoTemp.get(e.getString("material"))) : e.getString("rec_descricao"));
            if (isNovaAmostra && !atributos.containsKey("novaAmostra")) {
                atributos.put("novaAmostra", "true");
            }
            if (!Funcoes.textoVazio(atributos.get("descricao"))) {
                this.xml.abrirTag("amostra", atributos);
            }
        }
        if (isNovaAmostra) {
            this.escreverExameXMLInsercao(e);
        } else {
            this.escreverExameXML(e, enviarLoteWebService, false, st);
        }
        material = e.getString("material");
        identificacaoTemp.put(material, e.getString("exr_codigoapoiado"));
        return material;
    }

    @Override
    public void geraXmlLote(String codLabExterno, String configuracaoLabExterno, List<Registro> requisicoes, HashSet<String> pac, HashSet<String> medicos, String agente, String senha, Boolean enviarLoteWebService, String numeroLote, boolean isNovaAmostra, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, Statement st, boolean isColetaWeb, boolean agruparGuiasInterface) throws ParseException, SQLException {
        boolean enviarTuboLis = StringUtil.getValor(configuracaoLabExterno, "enviarTuboLis").trim().length() == 0 || StringUtil.getBoolean(configuracaoLabExterno, "enviarTuboLis");
        TreeMap<String, String> atributos = new TreeMap<String, String>();
        atributos.clear();
        if (!isNovaAmostra) {
            atributos.put("versao", "20090801");
        }
        if (enviarLoteWebService.booleanValue()) {
            String dataHora = Funcoes.formataData("yyyy-MM-dd", new Date());
            dataHora = dataHora + "T" + Funcoes.formataData("HH:mm:ss", new Date());
            atributos.put("datahora", dataHora);
        } else {
            atributos.put("datahora", Funcoes.formataData("dd/MM/yyyy HH:mm:ss", new Date()));
        }
        atributos.put("operador", Variaveis.login);
        atributos.put("lis", "Jalis");
        if (enviarLoteWebService.booleanValue()) {
            atributos.put("idagente", agente);
            atributos.put("senha", senha);
        }
        if (!isNovaAmostra) {
            this.xml.abrirTag("solicitacoes", atributos);
        } else {
            this.xml.abrirTag("inclusoes", atributos);
        }
        atributos.clear();
        atributos.put("codigo", StringUtil.getValor(configuracaoLabExterno, "codigoProtocolo"));
        if (!enviarLoteWebService.booleanValue()) {
            atributos.put("chave", StringUtil.getValor(configuracaoLabExterno, "chave"));
        }
        this.xml.abrirTag("entidade", atributos);
        if (!isNovaAmostra) {
            this.xml.abrirTag("pacientes");
            for (Registro r : requisicoes) {
                if (pac.contains(r.getString("pac_codigo"))) continue;
                pac.add(r.getString("pac_codigo"));
                this.escreverPaciente(r, enviarLoteWebService);
            }
            this.xml.fecharTag("pacientes");
        }
        if (!isNovaAmostra && (StringUtil.getValor(configuracaoLabExterno, "enviarMedico").trim().length() == 0 || StringUtil.getBoolean(configuracaoLabExterno, "enviarMedico"))) {
            this.xml.abrirTag("medicos");
            for (Registro r : requisicoes) {
                String crm = this.geraCrm(r, enviarLoteWebService);
                if (crm == null || medicos.contains(crm)) continue;
                medicos.add(crm);
                atributos.clear();
                atributos.put("crm", crm);
                atributos.put("nome", r.getString("med_nome"));
                this.xml.abrirTag("medico", atributos, true);
            }
            this.xml.fecharTag("medicos");
        }
        for (Registro r : requisicoes) {
            if (r.getValor("listaexames") == null || ((ArrayList)r.getValor("listaexames")).size() <= 0) continue;
            this.escreverSolicitacao(r, codLabExterno, configuracaoLabExterno, numeroLote, isNovaAmostra, null, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, st, isColetaWeb, agruparGuiasInterface);
        }
        this.xml.fecharTag("entidade");
        if (isNovaAmostra) {
            this.xml.fecharTag("inclusoes");
        } else {
            this.xml.fecharTag("solicitacoes");
        }
        this.xml.fecharArquivo();
    }

    @Override
    protected Map<ExameMaterialAlvaro, Integer> carregarExamesAlvaro(List<Registro> exames) {
        HashMap<ExameMaterialAlvaro, Integer> map = new HashMap<ExameMaterialAlvaro, Integer>();
        for (Registro exa : exames) {
            ExameSolucao alv = new ExameSolucao(exa.getString("ele_xmllabexterno"));
            if (alv != null) {
                exa.setValor("codigo", alv.getCodigo());
                exa.setValor("descricao", alv.getDescricao());
                exa.setValor("material", alv.getMaterial());
                exa.setValor("material_descricao", alv.getMaterialDescricao());
            }
            map.put(new ExameMaterialAlvaro(alv.getCodigo(), alv.getMaterial()), 0);
        }
        return map;
    }
}

