/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.externo.exportadores.solucaov2;

import jalis.laboratorio.triagem.externo.exportadores.DadosAdicionaisAlvaro;
import jalis.laboratorio.triagem.externo.exportadores.InfoComplementar;
import jalis.laboratorio.util.parsers.solucaov2.ExameSolucao;
import jalis.service.exportadores.DadosAdicionaisService;
import jalis.util.Funcoes;
import jalis.util.TTextField;
import jalis.util.tabela.Registro;
import java.awt.Component;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class DadosAdicionaisSolucao
extends DadosAdicionaisAlvaro {
    private DadosAdicionaisService service = new DadosAdicionaisService();
    boolean isConfirmarDados = false;

    @Override
    public boolean carregaDadosAdicionais(String codLabExterno, Registro exa, Registro req) {
        ArrayList<String> dadosComValores = new ArrayList<String>();
        String exame = exa.getString("exa_codigo");
        String paciente = req.getString("pac_codigo");
        String requisicao = req.getString("req_codigo");
        try {
            String xml = this.service.getXMLExame(exa, codLabExterno);
            if (Funcoes.textoVazio(xml)) {
                return true;
            }
            ExameSolucao exAlvaro = new ExameSolucao(xml);
            List<InfoComplementar> infoComplementares = this.service.carregaInfoComplementarSolucao(exAlvaro, exa, req);
            if (!this.service.contemValores(infoComplementares) || this.isConfirmarDados && !infoComplementares.isEmpty()) {
                this.configurarDadosAdicionais(infoComplementares, exame, requisicao, paciente);
                this.setVisible(true);
                for (Component c : this.panelDados.getComponents()) {
                    if (!(c instanceof TTextField)) continue;
                    TTextField textField = (TTextField)c;
                    if (Funcoes.textoVazio(textField)) {
                        Funcoes.mensagem(this, "Os dados adicionais do exame  " + exame + " n\u00e3o foram preenchidos!", 5);
                        return false;
                    }
                    String valor = ((TTextField)c).getText();
                    String nomeCampo = ((TTextField)c).getName();
                    DadosAdicionaisSolucao.atualizaValores(valor, nomeCampo, exa, req, dadosComValores);
                }
            } else {
                for (InfoComplementar info : infoComplementares) {
                    DadosAdicionaisSolucao.atualizaValores(info.getValor().toString(), info.getTag(), exa, req, dadosComValores);
                }
            }
            return true;
        }
        catch (SQLException e) {
            return false;
        }
    }
}

