/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.externo.exportadores.softlab;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import jalis.laboratorio.triagem.externo.exportadores.softlab.ClienteDTO;
import jalis.laboratorio.triagem.externo.exportadores.softlab.DetalhePedidoDTO;
import jalis.laboratorio.triagem.externo.exportadores.softlab.ExameDTO;
import jalis.util.Funcoes;
import jalis.util.tabela.Registro;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class PedidoSoftLabDTO {
    private String codigoLis;
    private ClienteDTO cliente;
    private DetalhePedidoDTO detalhePedido;
    private List<ExameDTO> exames;

    public String getCodigoLis() {
        return this.codigoLis;
    }

    public void setCodigoLis(String codigoLis) {
        this.codigoLis = codigoLis;
    }

    public ClienteDTO getCliente() {
        return this.cliente;
    }

    public void setCliente(ClienteDTO cliente) {
        this.cliente = cliente;
    }

    public void setCliente(Registro registro) {
        this.cliente = ClienteDTO.fromRegistro(registro);
    }

    public List<ExameDTO> getExames() {
        return this.exames;
    }

    public void setExames(List<ExameDTO> exames) {
        this.exames = exames;
    }

    public DetalhePedidoDTO getDetalhePedido() {
        return this.detalhePedido;
    }

    public void setDetalhePedido(DetalhePedidoDTO detalhePedido) {
        this.detalhePedido = detalhePedido;
    }

    public void setDetalhePedido(Registro registro) {
        this.detalhePedido = DetalhePedidoDTO.fromRegistro(registro);
    }

    public static PedidoSoftLabDTO fromRegistro(Registro registro, Integer sequencial, int digitosTuboFilial, int digitosTuboRequisicao) {
        PedidoSoftLabDTO pedido = new PedidoSoftLabDTO();
        if (registro != null) {
            String codigoLis = Funcoes.preencheZero(registro.getString("fil_codigo"), digitosTuboFilial) + Funcoes.preencheZero(registro.getString("req_codigo"), digitosTuboRequisicao);
            String seq = sequencial > 0 ? "." + sequencial : "";
            pedido.setCodigoLis(codigoLis + seq);
            pedido.setDetalhePedido(registro);
            pedido.setCliente(registro);
        }
        return pedido;
    }

    public String toJson() {
        String json = "";
        try {
            json = new ObjectMapper().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
        return json;
    }
}

