/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.externo.exportadores.softlab;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.triagem.externo.exportadores.InfoComplementar;
import jalis.laboratorio.util.parsers.softlab.dto.TipoDeExameDTO;
import jalis.service.exportadores.DadosAdicionaisService;
import jalis.util.Funcoes;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ExigeJejumSoftLab
extends JDialog
implements ActionListener {
    transient Registro requisicao;
    transient List<InfoComplementar> dados;
    protected JPanel panelExame = new JPanel(new GridBagLayout());
    protected JPanel panelDados = new JPanel(new GridBagLayout());
    private JPanel panelBotoes = new JPanel(new FlowLayout(2));
    private JButton botaoOk = ComponenteFactory.novoJButton("Ok", 'O', this);
    private JButton botaoCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this);
    private JLabel labelExame = new JLabel();
    private JLabel labelRequisicao = new JLabel();
    private transient DadosAdicionaisService service;
    private boolean isConfirmarDados = false;
    transient List<Registro> reqConfiguradoJejum = new ArrayList<Registro>();

    public ExigeJejumSoftLab(String codLabExterno, Registro requisicao) {
        super(Laboratorio.getInstancia());
        this.setModal(true);
        this.setLayout(new BorderLayout());
        this.add((Component)this.panelDados, "Center");
        this.panelBotoes.add(this.botaoOk);
        this.panelBotoes.add(this.botaoCancelar);
        this.add((Component)this.panelBotoes, "South");
        this.add((Component)this.panelExame, "North");
        this.setTitle("Exame exige jejum");
        Funcoes.montaEnter((JComponent)this.panelDados);
        Funcoes.montaEnter((JComponent)this.panelBotoes);
        this.service = new DadosAdicionaisService();
        this.carregaTempo(codLabExterno, requisicao);
    }

    public void configurarJejum(List<InfoComplementar> dados, String requisicao, String exame, Registro reg, String laeCodigo) {
        GridBagConstraints cons = new GridBagConstraints();
        this.labelExame.setText("Tempo de Jejum: " + this.carregarTempoJejum(reg));
        this.labelRequisicao.setText("Requisi\u00e7\u00e3o:" + requisicao + " /Exame: " + exame);
        this.panelExame.removeAll();
        this.panelExame.setLayout(new GridBagLayout());
        cons.anchor = 17;
        cons.gridx = 0;
        cons.gridy = 0;
        this.panelExame.add((Component)this.labelRequisicao, cons);
        ++cons.gridy;
        this.panelExame.add((Component)this.labelExame, cons);
        int i = 0;
        this.panelDados.removeAll();
        this.panelDados.setLayout(new GridBagLayout());
        cons = new GridBagConstraints();
        cons.anchor = 17;
        for (InfoComplementar dado : dados) {
            if (!dado.getNome().equals("Jejum")) continue;
            JLabel labelDado = new JLabel(dado.getNome());
            JLabel labelUnidade = new JLabel(dado.getUnidade());
            cons.gridx = 0;
            cons.weightx = 0.0;
            cons.fill = 0;
            JComboBox comboRespostas = ComponenteFactory.novoJComboBox(this.getJejumSoftlab(laeCodigo), this, true, new Dimension(200, 20));
            this.panelDados.add((Component)labelDado, cons);
            comboRespostas.setName(dado.getNome());
            cons.gridx = 1;
            cons.weightx = 1.0;
            cons.fill = 2;
            this.panelDados.add((Component)comboRespostas, cons);
            cons.gridx = 2;
            cons.weightx = 0.0;
            cons.fill = 0;
            this.panelDados.add((Component)labelUnidade, cons);
            cons.gridy = i + 1;
            ++i;
        }
        this.setLocationRelativeTo(this.getParent());
        this.pack();
    }

    public boolean carregaTempo(String codLabExterno, Registro requisicao) {
        ArrayList exames = (ArrayList)requisicao.getValor("listaexames");
        if (exames == null || exames.isEmpty()) {
            return true;
        }
        this.requisicao = requisicao;
        for (Registro r : exames) {
            if (this.carregaTempo(r.getString("exa_codigo"), codLabExterno, r, requisicao.getString("req_codigo"), requisicao.getString("pac_nome"), requisicao)) continue;
            return false;
        }
        requisicao.setValor("listaexames", exames);
        return true;
    }

    private boolean carregaTempo(String exame, String codLabExterno, Registro exa, String requisicao, String paciente, Registro req) {
        try {
            HashMap<String, String> dadosComValores = new HashMap<String, String>();
            String xml = this.service.getXMLExame(exa, codLabExterno);
            TipoDeExameDTO exameSoftLab = TipoDeExameDTO.fromJson(xml);
            List<InfoComplementar> infoComplementares = this.service.carregaJejumSoftLab(exameSoftLab, exa, this.requisicao);
            if (infoComplementares == null || infoComplementares.isEmpty()) {
                return true;
            }
            if ((!this.service.contemValores(infoComplementares) || this.isConfirmarDados && !infoComplementares.isEmpty()) && infoComplementares.stream().anyMatch(i -> i.getTag().equals("JejumSoftLab")) && !this.jejumInformado(req)) {
                this.reqConfiguradoJejum.add(req);
                this.configurarJejum(infoComplementares, requisicao, exame, exa, codLabExterno);
                this.setVisible(true);
                for (Component c : this.panelDados.getComponents()) {
                    if (!(c instanceof JComboBox)) continue;
                    JComboBox combo = (JComboBox)c;
                    ItemCombo id = (ItemCombo)combo.getSelectedItem();
                    if (Funcoes.textoVazio(id.getDescricao())) {
                        Funcoes.mensagem(this, "O exame " + exame + " exige jejum que n\u00e3o foram preenchidos!", 5);
                        return false;
                    }
                    this.atualizaValores(String.valueOf(id.getId()), "JejumSoftLab", exa, dadosComValores);
                    return true;
                }
            }
            return true;
        }
        catch (SQLException e) {
            return false;
        }
    }

    public boolean jejumInformado(Registro registro) {
        return this.reqConfiguradoJejum.stream().anyMatch(j -> j.getString("pac_codigo").equals(registro.getString("pac_codigo")) && (j.getString("req_codigo").equals(registro.getString("req_codigo")) || j.getString("req_codigomae").equals(registro.getString("req_codigomae"))));
    }

    private void atualizaValores(String valor, String nomeCampo, Registro exa, HashMap<String, String> dadosComValores) {
        if (nomeCampo.equals("JejumSoftLab")) {
            exa.setValor("jejumSoftLab", valor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private String carregarTempoJejum(Registro requisicao) {
        Statement st;
        block4: {
            String string;
            st = Conexao.getStatement();
            StringBuilder sql = new StringBuilder();
            sql.append(" select exr_intervalojejum from examerequisicao e where fil_codigo = ").append(requisicao.getString("fil_codigo"));
            sql.append(" and req_codigo = ").append(requisicao.getString("req_codigo"));
            sql.append(" and exa_codigo = '").append(requisicao.getString("exa_codigo")).append("'");
            sql.append(" and mco_codigo = ").append(requisicao.getString("mco_codigo"));
            sql.append(" and exr_intervalojejum is not null ");
            try {
                ResultSet rs = Conexao.executeQuery(st, sql.toString());
                if (!rs.next()) break block4;
                string = rs.getString("exr_intervalojejum");
            }
            catch (SQLException sQLException) {
                Conexao.fecharStatement(st);
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
            }
            Conexao.fecharStatement(st);
            return string;
        }
        Conexao.fecharStatement(st);
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - bad return control flow
     */
    private ItemCombo[] getJejumSoftlab(String laeCodigo) {
        ItemCombo[] itemComboArray;
        Statement st = Conexao.getStatement();
        StringBuilder sql = new StringBuilder();
        sql.append("select sfj_codjejum, sfj_descricaojejum from examessoftlabtipojejum where fil_codigo = ");
        sql.append(Variaveis.filialPadrao);
        sql.append(" and lae_codigo = ").append(laeCodigo);
        try {
            ResultSet rs = Conexao.executeQuery(st, sql.toString());
            ArrayList<ItemCombo> item = new ArrayList<ItemCombo>();
            while (rs.next()) {
                int id = rs.getInt("sfj_codjejum");
                String descricao = rs.getString("sfj_descricaojejum");
                ItemCombo itemCombo = new ItemCombo(id, descricao);
                item.add(itemCombo);
            }
            itemComboArray = item.toArray(new ItemCombo[0]);
        }
        catch (SQLException sQLException) {
            Conexao.fecharStatement(st);
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
        }
        Conexao.fecharStatement(st);
        return itemComboArray;
        return new ItemCombo[0];
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.botaoOk) {
            this.setVisible(false);
        } else if (e.getSource() == this.botaoCancelar) {
            for (Component c : this.panelDados.getComponents()) {
                if (!(c instanceof TTextField)) continue;
                ((TTextField)c).setText("");
            }
            this.setVisible(false);
        }
    }

    private static class ItemCombo {
        private final int id;
        private final String descricao;

        public ItemCombo(int id, String descricao) {
            this.id = id;
            this.descricao = descricao;
        }

        public int getId() {
            return this.id;
        }

        public String getDescricao() {
            return this.descricao;
        }

        public String toString() {
            return this.descricao;
        }
    }
}

