/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.externo.exportadores.softlab;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.triagem.externo.LaboratorioExterno;
import jalis.laboratorio.triagem.externo.exportadores.ProcessaErroRetornoWebServiceLabExterno;
import jalis.laboratorio.triagem.externo.exportadores.VisualizaErroRetornoWebService;
import jalis.laboratorio.triagem.externo.exportadores.softlab.RequisicaoSequencialSoftLab;
import jalis.laboratorio.triagem.externo.exportadores.softlab.SolicitarMotivoEstornoSoftLab;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.laboratorio.util.parsers.softlab.ComunicacaoSoftLab;
import jalis.laboratorio.util.parsers.softlab.dto.RespostaComFalhaDTO;
import jalis.laboratorio.util.parsers.softlab.dto.RespostaDTO;
import jalis.util.Funcoes;
import jalis.util.SplashMensagem;
import jalis.util.tabela.Registro;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;

public class ExclusaoLoteSoftLab {
    private static final String LEQ_SEQUENCIALREQUISICAO = "leq_sequencialrequisicao";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int estornarExame(String codigoLote, List<Registro> requisicoes, LaboratorioExterno labExterno, boolean agruparMultiguia, int agruparInterface, Callable<Boolean> arquivar, Callable<Boolean> anular, Statement st, String login, int digitosTuboFilial, int digitosTuboRequisicao, boolean isColetaWeb) {
        SplashMensagem splash = null;
        if (!isColetaWeb) {
            splash = SplashMensagem.getInstancia(Laboratorio.getInstancia());
        }
        ArrayList<Registro> requisicoesEstornadas = new ArrayList<Registro>();
        try {
            ComunicacaoSoftLab comunicacao = ComunicacaoSoftLab.getInstancia(labExterno.configuracao);
            SolicitarMotivoEstornoSoftLab motivoEstono = null;
            if (!isColetaWeb) {
                motivoEstono = SolicitarMotivoEstornoSoftLab.novaInstancia(Laboratorio.getInstancia());
            }
            if (!isColetaWeb && motivoEstono.getCancelado()) {
                int n = -2;
                return n;
            }
            String justificativa = isColetaWeb ? "teste" : motivoEstono.getDescricaoMotivo();
            ArrayList<Registro> examesEstornados = null;
            if (!isColetaWeb) {
                splash.mostrar("Aguarde enquanto comunicamos com o Laborat\u00f3rio SoftLab");
            }
            int i = 0;
            for (Registro req : requisicoes) {
                String codFilial = req.getString("fil_codigo");
                String codRequisicao = req.getString("req_codigo");
                Integer[] multiguias = this.verificarRequisicaoMultiguia(codFilial, codRequisicao, labExterno.agruparMultiguias, st, agruparMultiguia);
                examesEstornados = new ArrayList<Registro>();
                Map<Integer, List<RequisicaoSequencialSoftLab>> sequencial = this.pesquisaSequencial(codFilial, multiguias, Integer.valueOf(labExterno.codigoLab), req, st);
                this.processaEstorno(comunicacao, justificativa, examesEstornados, req, codFilial, codRequisicao, sequencial, digitosTuboFilial, digitosTuboRequisicao);
                if (!examesEstornados.isEmpty()) {
                    requisicoesEstornadas.add(requisicoes.get(i).clone());
                    ((Registro)requisicoesEstornadas.get(i)).substituirValor("listaexames", examesEstornados);
                }
                ++i;
            }
            if (!isColetaWeb) {
                splash.apagar();
            }
        }
        catch (SocketTimeoutException ste) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "Timeout de comunica\u00e7\u00e3o com Softlab. Tentando novamente...", 1);
        }
        catch (Exception e) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "Falha na comunica\u00e7\u00e3o com SoftLab", 1);
        }
        finally {
            splash.apagar();
        }
        return requisicoes.size() - requisicoesEstornadas.size();
    }

    private void processaEstorno(ComunicacaoSoftLab comunicacao, String justificativa, List<Registro> examesEstornados, Registro req, String codFilial, String codRequisicao, Map<Integer, List<RequisicaoSequencialSoftLab>> sequencial, int digitosTuboFilial, int digitosTuboRequisicao) throws IOException {
        if (!sequencial.isEmpty()) {
            for (Map.Entry<Integer, List<RequisicaoSequencialSoftLab>> seq : sequencial.entrySet()) {
                Integer sequencialCod = seq.getKey();
                List<RequisicaoSequencialSoftLab> requisicoesSequencial = seq.getValue();
                String codPedidoLis = Funcoes.preencheZero(codFilial, digitosTuboFilial) + Funcoes.preencheZero(codRequisicao, digitosTuboRequisicao);
                String codPedidoLisSequencial = sequencialCod != 0 ? codPedidoLis + "." + sequencialCod : codPedidoLis;
                String pathEstorno = "/api/Pedido/" + codPedidoLisSequencial;
                RespostaDTO resposta = comunicacao.excluirPedido(pathEstorno, justificativa);
                this.processaRetornoEstorno(examesEstornados, req, requisicoesSequencial);
                if (resposta.getStatusCode() == 204) continue;
                this.processaErroRetorno(req, resposta, codPedidoLis);
            }
        }
    }

    private void processaRetornoEstorno(List<Registro> examesEstornados, Registro req, List<RequisicaoSequencialSoftLab> requisicoesSequencial) {
        for (RequisicaoSequencialSoftLab reqSeq : requisicoesSequencial) {
            ArrayList exames = (ArrayList)req.getValor("listaexames");
            for (Registro exame : exames) {
                List desm = (List)exame.getValor("listaexames");
                if (desm != null && !desm.isEmpty()) {
                    this.processaRetornoEstornoDesmembrado(examesEstornados, reqSeq, exame, desm);
                    continue;
                }
                if (!reqSeq.getCodExame().equals(exame.getString("exa_codigo")) || !reqSeq.getCodMaterial().equals(exame.getString("mco_codigo"))) continue;
                examesEstornados.add(exame.clone());
            }
        }
    }

    private void processaRetornoEstornoDesmembrado(List<Registro> examesEstornados, RequisicaoSequencialSoftLab reqSeq, Registro exame, List<Registro> desm) {
        for (Registro exaDesm : desm) {
            if (!reqSeq.getCodExame().equals(exaDesm.getString("exa_kodigo")) || !reqSeq.getCodMaterial().equals(exaDesm.getString("mco_kodigo")) || !reqSeq.getCodExameDesm().equals(exaDesm.getString("exa_codigo")) || !reqSeq.getCodMaterialDesm().equals(exaDesm.getString("mco_codigo"))) continue;
            examesEstornados.add(exame.clone());
            break;
        }
    }

    private void processaErroRetorno(Registro requisicao, RespostaDTO retorno, String codPedidoLis) throws JsonProcessingException {
        String erro = "";
        RespostaComFalhaDTO[] respostasComFalha = null;
        try {
            respostasComFalha = (RespostaComFalhaDTO[])new ObjectMapper().readValue(retorno.getConteudo(), RespostaComFalhaDTO[].class);
        }
        catch (Exception e) {
            erro = retorno.getConteudo();
        }
        StringBuilder aviso = new StringBuilder();
        aviso.append("Pedido ").append(codPedidoLis).append(" de ").append(requisicao.getString("pac_nome")).append(" - N\u00e3o foi estornado pelo Apoio...");
        if (!Objects.isNull(respostasComFalha)) {
            aviso.append("\n").append(respostasComFalha[0].getKey()).append(" : ").append(respostasComFalha[0].getMessage());
        } else {
            aviso.append("\n").append(erro);
        }
        ProcessaErroRetornoWebServiceLabExterno erroRetornoWebServiceLabExterno = new ProcessaErroRetornoWebServiceLabExterno(aviso.toString(), this.formatarJson(retorno.getConteudo()));
        this.visualizaErroRetornoWebService(erroRetornoWebServiceLabExterno);
    }

    private VisualizaErroRetornoWebService visualizaErroRetornoWebService(ProcessaErroRetornoWebServiceLabExterno erroRetornoWebServiceLabExterno) {
        return VisualizaErroRetornoWebService.novaInstancia(Laboratorio.getInstancia(), "Mensagens ao enviar lotes", erroRetornoWebServiceLabExterno, true, "SoftLab");
    }

    private String formatarJson(String json) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            return objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)objectMapper.readTree(json));
        }
        catch (Exception e) {
            return json;
        }
    }

    private Integer[] verificarRequisicaoMultiguia(String codFilial, String codRequisicao, boolean labExternoAgrupaMultguias, Statement st, boolean agruparInterfaceGuias) {
        Integer[] multiguias = null;
        try {
            multiguias = agruparInterfaceGuias || labExternoAgrupaMultguias ? RecepcaoUtil.verificaMultiGuias(st, codFilial, codRequisicao, true) : new Integer[]{Integer.parseInt(codRequisicao)};
        }
        catch (Exception e) {
            return multiguias;
        }
        return multiguias;
    }

    public Map<Integer, List<RequisicaoSequencialSoftLab>> pesquisaSequencial(String codFilial, Integer[] multiguias, int codLabExterno, Registro requisicao, Statement st) throws SQLException {
        HashMap<Integer, List<RequisicaoSequencialSoftLab>> sequencialAgrupado = new HashMap<Integer, List<RequisicaoSequencialSoftLab>>();
        ArrayList<RequisicaoSequencialSoftLab> requisicaoSequencial = new ArrayList<RequisicaoSequencialSoftLab>();
        ArrayList exames = (ArrayList)requisicao.getValor("listaexames");
        try {
            ResultSet rs = st.executeQuery(this.getSqlPesquisarExameComLotePorRequisicao(codFilial, multiguias, codLabExterno));
            int sequencial = -1;
            while (rs.next()) {
                if (sequencial == -1) {
                    sequencial = rs.getInt(LEQ_SEQUENCIALREQUISICAO);
                }
                if (rs.getInt(LEQ_SEQUENCIALREQUISICAO) != sequencial) {
                    sequencial = rs.getInt(LEQ_SEQUENCIALREQUISICAO);
                    requisicaoSequencial = new ArrayList();
                }
                this.adicionaExamesEstornados(requisicaoSequencial, exames, rs, sequencial);
                if (requisicaoSequencial.isEmpty()) continue;
                sequencialAgrupado.put(sequencial, requisicaoSequencial);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return sequencialAgrupado;
    }

    private void adicionaExamesEstornados(List<RequisicaoSequencialSoftLab> requisicaoSequencial, List<Registro> exames, ResultSet rs, int sequencial) throws SQLException {
        if (rs.getInt(LEQ_SEQUENCIALREQUISICAO) == sequencial) {
            for (Registro exame : exames) {
                List desm = (List)exame.getValor("listaexames");
                if (desm != null && !desm.isEmpty()) {
                    this.adicionaExamesDesmembradosEstornados(requisicaoSequencial, rs, desm);
                    continue;
                }
                if (!exame.getString("exa_codigo").equals(rs.getString("exa_codigo")) || !exame.getString("mco_codigo").equals(rs.getString("mco_codigo"))) continue;
                requisicaoSequencial.add(RequisicaoSequencialSoftLab.getRequisicaoSequencialSoftLab(rs));
                break;
            }
        }
    }

    private void adicionaExamesDesmembradosEstornados(List<RequisicaoSequencialSoftLab> requisicaoSequencial, ResultSet rs, List<Registro> desm) throws SQLException {
        for (Registro exaDesm : desm) {
            if (!exaDesm.getString("exa_codigo").equals(rs.getString("exa_kodigo")) || !exaDesm.getString("mco_codigo").equals(rs.getString("mco_kodigo")) || !exaDesm.getString("exa_kodigo").equals(rs.getString("exa_codigo")) || !exaDesm.getString("mco_kodigo").equals(rs.getString("mco_codigo"))) continue;
            requisicaoSequencial.add(RequisicaoSequencialSoftLab.getRequisicaoSequencialSoftLab(rs));
        }
    }

    private String getSqlPesquisarExameComLotePorRequisicao(String codFilial, Integer[] multiguias, int codLabExterno) {
        StringBuilder sql = new StringBuilder();
        sql.append(" select ler.fil_codigo, ler.req_codigo, leer.exa_codigo, leer.mco_codigo, ldesm.exa_kodigo, ldesm.mco_kodigo, ler.leq_sequencialrequisicao ");
        sql.append(" from loteexterno l ");
        sql.append(" left join loteexternorequisicao ler on");
        sql.append(" l.fil_codigo = ler.fil_codigo and l.lex_codigo = ler.lex_codigo and l.lae_codigo = ler.lae_codigo ");
        sql.append(" left join loteexternoexamerequisicao leer on ");
        sql.append(" l.fil_codigo = leer.fil_codigo and l.lex_codigo = leer.lex_codigo and l.lae_codigo = leer.lae_codigo and ler.req_codigo = leer.req_codigo ");
        sql.append(" left join loteexternoexamerequisicaodesm ldesm on ");
        sql.append(" leer.fil_codigo = ldesm.fil_codigo and leer.fil_kodigo = ldesm.fil_kodigo and leer.lex_codigo = ldesm .lex_codigo and leer.lae_codigo = ldesm.lae_codigo and leer.exa_codigo = ldesm.exa_codigo and leer.mco_codigo = ldesm.mco_codigo ");
        sql.append(" where l.fil_codigo = ").append(codFilial);
        sql.append(" and l.lae_codigo = ").append(codLabExterno);
        sql.append(" and ler.req_codigo in (");
        for (Integer guia : multiguias) {
            sql.append(guia).append(",");
        }
        sql.replace(sql.length() - 1, sql.length(), ") ");
        sql.append(" and (l.lex_dataestorno is null and ler.leq_dataestorno is null) ");
        sql.append(" order by leq_sequencialrequisicao desc ");
        return sql.toString();
    }
}

