/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.externo.exportadores.softlab;

import com.fasterxml.jackson.annotation.JsonInclude;
import jalis.laboratorio.triagem.externo.exportadores.IntegracaoLabExterno;
import jalis.laboratorio.triagem.externo.exportadores.softlab.CamposDeColetaDTO;
import jalis.laboratorio.util.parsers.softlab.dto.TipoDeExameDTO;
import jalis.util.Funcoes;
import jalis.util.tabela.Registro;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class ExameDTO {
    private String codigoLis;
    private String codigoProcedimentoApoio;
    private String dataHoraColeta;
    private String codigoOpcaoDeColetaApoio;
    private String complemento;
    private List<CamposDeColetaDTO> camposDeColeta;

    public String getCodigoLis() {
        return this.codigoLis;
    }

    public void setCodigoLis(String codigoLis) {
        this.codigoLis = codigoLis;
    }

    public String getCodigoProcedimentoApoio() {
        return this.codigoProcedimentoApoio;
    }

    public void setCodigoProcedimentoApoio(String codigoProcedimentoApoio) {
        this.codigoProcedimentoApoio = codigoProcedimentoApoio;
    }

    public String getDataHoraColeta() {
        return this.dataHoraColeta;
    }

    public void setDataHoraColeta(String dataHoraColeta) {
        this.dataHoraColeta = dataHoraColeta;
    }

    public String getCodigoOpcaoDeColetaApoio() {
        return this.codigoOpcaoDeColetaApoio;
    }

    public void setCodigoOpcaoDeColetaApoio(String codigoOpcaoDeColetaApoio) {
        this.codigoOpcaoDeColetaApoio = codigoOpcaoDeColetaApoio;
    }

    public String getComplemento() {
        return this.complemento;
    }

    public void setComplemento(String complemento) {
        this.complemento = complemento;
    }

    public List<CamposDeColetaDTO> getCamposDeColeta() {
        return this.camposDeColeta;
    }

    public void setCamposDeColeta(List<CamposDeColetaDTO> camposDeColeta) {
        this.camposDeColeta = camposDeColeta;
    }

    public static ExameDTO fromRegistro(Registro registro) {
        String xmlLabExterno = registro.getString("ele_xmllabexterno");
        TipoDeExameDTO tipoExame = TipoDeExameDTO.fromJson(xmlLabExterno);
        ExameDTO exame = new ExameDTO();
        try {
            exame.setCodigoLis(registro.getString("exa_codigo") + "|" + registro.getString("mco_codigo"));
            exame.setCodigoProcedimentoApoio(tipoExame.getCodigo());
            exame.setDataHoraColeta(ExameDTO.getDataHoraColeta(registro));
            exame.setCodigoOpcaoDeColetaApoio(tipoExame.getOpcoesDeColeta().get(0).getCodigo());
            exame.setComplemento("");
            exame.setCamposDeColeta(ExameDTO.getCamposColeta(registro));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return exame;
    }

    private static List<CamposDeColetaDTO> getCamposColeta(Registro registro) {
        ArrayList<CamposDeColetaDTO> camposDeColeta = new ArrayList<CamposDeColetaDTO>();
        String dadosAdicionais = registro.getString("dadosAdicionais");
        if (!Funcoes.textoVazio(dadosAdicionais)) {
            String[] dadosColeta;
            for (String dados : dadosColeta = dadosAdicionais.replaceAll("[{}]", "").split(",")) {
                String[] valor = dados.split("=");
                CamposDeColetaDTO campos = new CamposDeColetaDTO();
                campos.setCodigo(valor[0].trim());
                campos.setValor(valor[1].trim());
                camposDeColeta.add(campos);
            }
        }
        return camposDeColeta;
    }

    private static String getDataHoraColeta(Registro registro) throws ParseException {
        return ExameDTO.formatar("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", registro.getDate("exr_datamaterial") != null ? registro.getDate("exr_datamaterial") : Funcoes.getHoraServidor());
    }

    private static String formatar(String masc, Date data) {
        if (masc != null && data != null) {
            return Funcoes.formataData(masc, data);
        }
        return "";
    }

    public static List<ExameDTO> getExames(Registro registro, String laeCodigo, Statement st) throws SQLException {
        List listaExames = (List)registro.getValor("listaexames");
        ArrayList<ExameDTO> examesSoftLab = new ArrayList<ExameDTO>();
        HashSet<String> chaves = new HashSet<String>();
        ArrayList<String> listaExamesAdicionados = new ArrayList<String>();
        for (Registro exa : listaExames) {
            String key = exa.getString("exa_codigo") + exa.getString("mco_codigo");
            if (listaExamesAdicionados.contains(key)) continue;
            List<Registro> listaExamesDesmembrados = IntegracaoLabExterno.getExamesDesmembrados(registro.getString("fil_codigo"), exa, laeCodigo, chaves, st);
            if (listaExamesDesmembrados != null && !listaExamesDesmembrados.isEmpty()) {
                for (Registro desm : listaExamesDesmembrados) {
                    key = desm.getString("exa_codigo") + desm.getString("mco_codigo");
                    if (listaExamesAdicionados.contains(key)) continue;
                    examesSoftLab.add(ExameDTO.fromRegistro(desm));
                    listaExamesAdicionados.add(key);
                }
                continue;
            }
            examesSoftLab.add(ExameDTO.fromRegistro(exa));
            listaExamesAdicionados.add(key);
        }
        return examesSoftLab;
    }
}

