/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.externo.exportadores.softlab;

import com.fasterxml.jackson.annotation.JsonInclude;
import jalis.util.Funcoes;
import jalis.util.tabela.Registro;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class DetalhePedidoDTO {
    private String febre;
    private String pesoEmGramas;
    private String gestante;
    private String semanasGestacao;
    private String observacao;
    private String urgente;
    private String jejum;

    public String getFebre() {
        return this.febre;
    }

    public void setFebre(String febre) {
        this.febre = febre;
    }

    public String getPesoEmGramas() {
        return this.pesoEmGramas;
    }

    public void setPesoEmGramas(String pesoEmGramas) {
        this.pesoEmGramas = pesoEmGramas;
    }

    public String getGestante() {
        return this.gestante;
    }

    public void setGestante(String gestante) {
        this.gestante = gestante;
    }

    public String getSemanasGestacao() {
        return this.semanasGestacao;
    }

    public void setSemanasGestacao(String semanasGestacao) {
        this.semanasGestacao = semanasGestacao;
    }

    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    public String getUrgente() {
        return this.urgente;
    }

    public void setUrgente(String urgente) {
        this.urgente = urgente;
    }

    public String getJejum() {
        return this.jejum;
    }

    public void setJejum(String jejum) {
        this.jejum = jejum;
    }

    public static DetalhePedidoDTO fromRegistro(Registro registro) {
        DetalhePedidoDTO detalhePedido = new DetalhePedidoDTO();
        detalhePedido.setPesoEmGramas(String.valueOf(registro.getInt("req_peso") * 1000));
        String observacao = !Funcoes.textoVazio(registro.getString("req_obs")) ? registro.getString("req_obs") : "\"\";";
        detalhePedido.setObservacao(observacao);
        detalhePedido.setUrgente(registro.getBoolean("req_urgente") ? "S" : "N");
        detalhePedido.setJejum(DetalhePedidoDTO.getCodigoJejum(registro));
        return detalhePedido;
    }

    private static String getCodigoJejum(Registro registro) {
        List listaExames = (List)registro.getValor("listaexames");
        for (Registro exa : listaExames) {
            if (!exa.possuiCampo("jejumSoftLab")) continue;
            return exa.getString("jejumSoftLab");
        }
        return "";
    }
}

