/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.externo.exportadores.softlab;

import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.triagem.externo.DadosAdicionais;
import jalis.laboratorio.triagem.externo.exportadores.InfoComplementar;
import jalis.laboratorio.triagem.externo.exportadores.softlab.ExigeJejumSoftLab;
import jalis.laboratorio.util.parsers.softlab.dto.CampoDeColetaDTO;
import jalis.laboratorio.util.parsers.softlab.dto.TipoDeExameDTO;
import jalis.service.exportadores.DadosAdicionaisService;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DadosAdicionaisSoftLab
extends JDialog
implements DadosAdicionais,
ActionListener {
    transient Registro requisicao;
    transient List<InfoComplementar> dados;
    protected JPanel panelExame = new JPanel(new GridBagLayout());
    protected JPanel panelDados = new JPanel(new GridBagLayout());
    private JPanel panelBotoes = new JPanel(new FlowLayout(2));
    private JButton botaoOk = ComponenteFactory.novoJButton("Ok", 'O', this);
    private JButton botaoCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this);
    private JLabel labelExame = new JLabel();
    private JLabel labelRequisicao = new JLabel();
    private transient DadosAdicionaisService service;
    private boolean isConfirmarDados = false;

    public DadosAdicionaisSoftLab() {
        super(Laboratorio.getInstancia());
        this.setModal(true);
        this.setLayout(new BorderLayout());
        this.add((Component)this.panelDados, "Center");
        this.panelBotoes.add(this.botaoOk);
        this.panelBotoes.add(this.botaoCancelar);
        this.add((Component)this.panelBotoes, "South");
        this.add((Component)this.panelExame, "North");
        this.setTitle("Dados Adicionais");
        Funcoes.montaEnter((JComponent)this.panelDados);
        Funcoes.montaEnter((JComponent)this.panelBotoes);
        this.service = new DadosAdicionaisService();
    }

    public void configurarDadosAdicionais(List<InfoComplementar> dados, String exame, String requisicao, String paciente) {
        GridBagConstraints cons = new GridBagConstraints();
        this.setTitle("Dados Adicionais");
        this.labelExame.setText("Exame: " + exame);
        this.labelRequisicao.setText("Requisi\u00e7\u00e3o:" + requisicao + " - " + paciente);
        this.panelExame.removeAll();
        this.panelExame.setLayout(new GridBagLayout());
        cons.anchor = 17;
        cons.gridx = 0;
        cons.gridy = 0;
        this.panelExame.add((Component)this.labelRequisicao, cons);
        ++cons.gridy;
        this.panelExame.add((Component)this.labelExame, cons);
        int i = 0;
        TTextField editDadoPrimeiro = null;
        this.panelDados.removeAll();
        this.panelDados.setLayout(new GridBagLayout());
        cons = new GridBagConstraints();
        cons.anchor = 17;
        for (InfoComplementar dado : dados) {
            if (!dado.getNome().equals("Jejum")) {
                JLabel labelDado = new JLabel(dado.getNome());
                JLabel labelUnidade = new JLabel(dado.getUnidade());
                cons.gridx = 0;
                cons.weightx = 0.0;
                cons.fill = 0;
                TTextField editDado = null;
                if (dado.getTag().equals("Volume")) {
                    editDado = new TTextField(4, 1);
                    editDado.setText(dado.getValor().toString());
                } else if (dado.getTag().equals("Altura")) {
                    editDado = new TTextField(3, 2);
                    editDado.setText(dado.getValor().toString());
                } else if (dado.getTag().equals("Peso")) {
                    editDado = new TTextField(5, 2);
                    editDado.setText(dado.getValor().toString());
                } else {
                    editDado = ComponenteFactory.novoTTextField(15, 3);
                }
                this.panelDados.add((Component)labelDado, cons);
                editDado.setPreferredSize(new Dimension(100, 20));
                editDado.setName(dado.getNome());
                cons.gridx = 1;
                cons.weightx = 1.0;
                cons.fill = 2;
                this.panelDados.add((Component)editDado, cons);
                cons.gridx = 2;
                cons.weightx = 0.0;
                cons.fill = 0;
                this.panelDados.add((Component)labelUnidade, cons);
                if (editDadoPrimeiro == null) {
                    editDadoPrimeiro = editDado;
                }
                cons.gridy = i + 1;
                ++i;
            }
            if (editDadoPrimeiro != null) {
                ScreenUtil.requisitarFoco(editDadoPrimeiro);
            }
            this.setLocationRelativeTo(this.getParent());
            this.pack();
        }
    }

    @Override
    public boolean carregaAdicionais(String codLabExterno, Registro requisicao) {
        ArrayList exames = (ArrayList)requisicao.getValor("listaexames");
        if (exames == null || exames.isEmpty()) {
            return true;
        }
        new ExigeJejumSoftLab(codLabExterno, requisicao);
        this.requisicao = requisicao;
        for (Registro r : exames) {
            if (this.carregaDadosAdicionais(r.getString("exa_codigo"), codLabExterno, r, requisicao.getString("req_codigo"), requisicao.getString("pac_nome"), requisicao)) continue;
            return false;
        }
        requisicao.setValor("listaexames", exames);
        return true;
    }

    private boolean carregaDadosAdicionais(String exame, String codLabExterno, Registro exa, String requisicao, String paciente, Registro req) {
        try {
            HashMap<String, String> dadosComValores = new HashMap<String, String>();
            String xml = this.service.getXMLExame(exa, codLabExterno);
            TipoDeExameDTO exameSoftLab = TipoDeExameDTO.fromJson(xml);
            List<InfoComplementar> infoComplementares = this.service.carregaInfoComplementarSoftLab(exameSoftLab, exa, this.requisicao);
            if (infoComplementares == null || infoComplementares.isEmpty()) {
                return true;
            }
            if (!this.service.contemValores(infoComplementares) || this.isConfirmarDados && !infoComplementares.isEmpty()) {
                this.configurarDadosAdicionais(infoComplementares, exame, requisicao, paciente);
                this.setVisible(true);
                Map<String, String> codigoDescricaoDadosAdicionais = this.getCodigoDescricaoDadosAdicionais(exameSoftLab);
                for (Component c : this.panelDados.getComponents()) {
                    if (!(c instanceof TTextField)) continue;
                    TTextField textField = (TTextField)c;
                    if (Funcoes.textoVazio(textField)) {
                        Funcoes.mensagem(this, "O exame " + exame + " possui dados adicionais que n\u00e3o foram preenchidos!", 5);
                        return false;
                    }
                    String valor = ((TTextField)c).getText();
                    String nomeCampo = ((TTextField)c).getName();
                    this.atualizaValores(valor, this.getCodigoDadosAdicionais(codigoDescricaoDadosAdicionais, nomeCampo), exa, dadosComValores);
                }
            } else {
                for (InfoComplementar info : infoComplementares) {
                    this.atualizaValores(info.getValor().toString(), info.getTag(), exa, dadosComValores);
                }
            }
            return true;
        }
        catch (SQLException e) {
            return false;
        }
    }

    private Map<String, String> getCodigoDescricaoDadosAdicionais(TipoDeExameDTO exameSoftLab) {
        HashMap<String, String> codigoDescricaoDadosAdicionais = new HashMap<String, String>();
        if (!exameSoftLab.getCamposDeColeta().isEmpty()) {
            for (CampoDeColetaDTO campo : exameSoftLab.getCamposDeColeta()) {
                String codigo = campo.getCodigo();
                String descricao = campo.getDescricao();
                String mascara = !Funcoes.textoVazio(campo.getMascara()) ? " ( " + campo.getMascara() + " )" : "";
                String nome = descricao + mascara;
                codigoDescricaoDadosAdicionais.put(codigo, nome);
            }
        }
        return codigoDescricaoDadosAdicionais;
    }

    private String getCodigoDadosAdicionais(Map<String, String> codigoDadosAdicionais, String descricao) {
        for (Map.Entry<String, String> entry : codigoDadosAdicionais.entrySet()) {
            if (!descricao.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return "";
    }

    private void atualizaValores(String valor, String nomeCampo, Registro exa, HashMap<String, String> dadosComValores) {
        valor = StringUtil.limpaString(valor, new String[]{",", ".", "/", "-"});
        dadosComValores.put(nomeCampo, valor);
        exa.setValor("dadosAdicionais", dadosComValores);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.botaoOk) {
            this.setVisible(false);
        } else if (e.getSource() == this.botaoCancelar) {
            for (Component c : this.panelDados.getComponents()) {
                if (!(c instanceof TTextField)) continue;
                ((TTextField)c).setText("");
            }
            this.setVisible(false);
        }
    }

    @Override
    public boolean carregaAdicionais(String codLabExterno, Registro requisicao, boolean isConfirmarDados) {
        this.isConfirmarDados = isConfirmarDados;
        return this.carregaAdicionais(codLabExterno, requisicao);
    }
}

