/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.externo.exportadores.softlab;

import com.fasterxml.jackson.annotation.JsonInclude;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.tabela.Registro;
import java.text.ParseException;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class ClienteDTO {
    private String codigoLis;
    private String nome;
    private String nomeSocial;
    private String sexo;
    private String dataDeNascimento;
    private String observacao;
    private String cpf;
    private String cns;
    private String rg;
    private String celularCliente;
    private String tipoLogradouro;
    private String logradouro;
    private String numeroLogradouro;
    private String complementoLogradouro;
    private String bairro;
    private String municipio;
    private String codigoMunicipioIbge;
    private String uf;

    public String getCodigoLis() {
        return this.codigoLis;
    }

    public void setCodigoLis(String codigoLis) {
        this.codigoLis = codigoLis;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public String getNomeSocial() {
        return this.nomeSocial;
    }

    public void setNomeSocial(String nomeSocial) {
        this.nomeSocial = nomeSocial;
    }

    public String getSexo() {
        return this.sexo;
    }

    public void setSexo(String sexo) {
        this.sexo = sexo;
    }

    public String getDataDeNascimento() {
        return this.dataDeNascimento;
    }

    public void setDataDeNascimento(String dataDeNascimento) {
        this.dataDeNascimento = dataDeNascimento;
    }

    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    public String getCpf() {
        return this.cpf;
    }

    public void setCpf(String cpf) {
        this.cpf = cpf;
    }

    public String getCns() {
        return this.cns;
    }

    public void setCns(String cns) {
        this.cns = cns;
    }

    public String getRg() {
        return this.rg;
    }

    public void setRg(String rg) {
        this.rg = rg;
    }

    public String getCelularCliente() {
        return this.celularCliente;
    }

    public void setCelularCliente(String celularCliente) {
        this.celularCliente = celularCliente;
    }

    public String getTipoLogradouro() {
        return this.tipoLogradouro;
    }

    public void setTipoLogradouro(String tipoLogradouro) {
        this.tipoLogradouro = tipoLogradouro;
    }

    public String getLogradouro() {
        return this.logradouro;
    }

    public void setLogradouro(String logradouro) {
        this.logradouro = logradouro;
    }

    public String getNumeroLogradouro() {
        return this.numeroLogradouro;
    }

    public void setNumeroLogradouro(String numeroLogradouro) {
        this.numeroLogradouro = numeroLogradouro;
    }

    public String getComplementoLogradouro() {
        return this.complementoLogradouro;
    }

    public void setComplementoLogradouro(String complementoLogradouro) {
        this.complementoLogradouro = complementoLogradouro;
    }

    public String getBairro() {
        return this.bairro;
    }

    public void setBairro(String bairro) {
        this.bairro = bairro;
    }

    public String getMunicipio() {
        return this.municipio;
    }

    public void setMunicipio(String municipio) {
        this.municipio = municipio;
    }

    public String getCodigoMunicipioIbge() {
        return this.codigoMunicipioIbge;
    }

    public void setCodigoMunicipioIbge(String codigoMunicipioIbge) {
        this.codigoMunicipioIbge = codigoMunicipioIbge;
    }

    public String getUf() {
        return this.uf;
    }

    public void setUf(String uf) {
        this.uf = uf;
    }

    public static ClienteDTO fromRegistro(Registro registro) {
        ClienteDTO cliente = new ClienteDTO();
        try {
            if (registro != null) {
                cliente.setCodigoLis(registro.getString("pac_codigo"));
                cliente.setNome(StringUtil.limpaXmlEnvioWebService(registro.getString("pac_nome")));
                cliente.setNomeSocial(registro.getString("pac_nomesocial"));
                cliente.setSexo(registro.getString("pac_sexo"));
                cliente.setDataDeNascimento(Funcoes.formataData("yyyy-MM-dd", registro.getDate("pac_datanasc")));
                String observacaoFinal = "";
                String obs = registro.getString("pac_observ");
                String dadoClinico = registro.getString("pac_dadoclinico");
                if (!Funcoes.textoVazio(obs)) {
                    observacaoFinal = observacaoFinal + obs;
                    observacaoFinal = observacaoFinal + " ";
                }
                if (!Funcoes.textoVazio(dadoClinico)) {
                    observacaoFinal = observacaoFinal + dadoClinico;
                }
                cliente.setObservacao(observacaoFinal);
                cliente.setCpf(StringUtil.limpaString(registro.getString("pac_cpf"), new String[]{".", "-"}));
                cliente.setRg(registro.getString("pac_rg"));
                cliente.setCelularCliente("");
                cliente.setTipoLogradouro(registro.getString("pac_tipologradouroendereco"));
                cliente.setLogradouro(registro.getString("pac_endereco"));
                cliente.setNumeroLogradouro(registro.getString("pac_numeroendereco"));
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return cliente;
    }
}

