/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.externo.exportadores.shift;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.exame.MedicamentoVO;
import jalis.model.vo.recepcao.ExameRequisicaoRecipienteVO;
import jalis.model.vo.triagem.LoteExternoRequisicaoVO;
import jalis.util.StringUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;

public class ExportacaoParaShiftDao {
    private static final String ASPA = "'";

    public int getMaiorCodigoLote(String codigoLabExterno, Statement st) {
        StringBuilder sql = new StringBuilder();
        sql.append(" select max(lex_codigo) + 1 as codigo from loteexterno ");
        sql.append(" where lae_codigo = ").append(codigoLabExterno);
        sql.append(" and fil_codigo = ").append(Variaveis.filialPadrao);
        try {
            ResultSet rs = st.executeQuery(sql.toString());
            if (rs.next()) {
                return rs.getInt("codigo");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return 0;
    }

    public String pesquisarCartaoSUS(String codFilial, String codRequisicao, Statement st) {
        StringBuilder sql = new StringBuilder();
        sql.append(" select req_cartaosus from requisicao where ");
        sql.append(" fil_codigo = ").append(codFilial);
        sql.append(" and req_codigo = ").append(codRequisicao);
        String cartaoSus = "";
        try {
            ResultSet rs = st.executeQuery(sql.toString());
            if (rs.next()) {
                cartaoSus = rs.getString("req_cartaosus");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cartaoSus;
    }

    public List<MedicamentoVO> pesquisarMedicamentosPorRequisicao(String codRequisicao, String codFilial, Statement st, Callable<Boolean> arquivar, Callable<Boolean> anular) {
        StringBuilder sql = new StringBuilder();
        sql.append(" select m.fil_codigo, m.mto_codigo, m.mto_descricao ");
        sql.append(" from requisicaomedicamento r ");
        sql.append(" left join medicamentos m on r.fil_codigo = m.fil_codigo and r.mto_codigo = m.mto_codigo ");
        sql.append(" where ");
        sql.append(" r.fil_codigo = ").append(codFilial);
        sql.append(" and r.req_codigo = ").append(codRequisicao);
        ArrayList<MedicamentoVO> medicamentos = new ArrayList<MedicamentoVO>();
        try {
            ResultSet rs = st.executeQuery(sql.toString());
            while (rs.next()) {
                FilialVO filial = new FilialVO();
                filial.setCodigo(rs.getInt("fil_codigo"));
                MedicamentoVO medicamento = new MedicamentoVO();
                medicamento.setFilial(filial);
                medicamento.setCodigo(rs.getInt("mto_codigo"));
                medicamento.setDescricao(rs.getString("mto_descricao"));
                medicamentos.add(medicamento);
            }
        }
        catch (Exception e) {
            try {
                anular.call();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        return medicamentos;
    }

    public void atualizarExameRequisicaoRecipiente(List<ExameRequisicaoRecipienteVO> recipientes, boolean isColetaWeb, Statement st, Callable<Boolean> arquivar, Callable<Boolean> anular) {
        for (ExameRequisicaoRecipienteVO vo : recipientes) {
            StringBuilder sql = new StringBuilder();
            String filial = vo.getFilial().getCodigo().toString();
            sql.append(" select fil_codigo, exa_codigo, mco_codigo, req_codigo, rec_codigo, ere_tipo, rec_kodigo, ere_codigoapoiado ");
            sql.append(" from examerequisicaorecipiente ");
            StringBuilder where = new StringBuilder();
            where.append(" where ");
            where.append(" fil_codigo = ").append(filial);
            where.append(" and req_codigo = ").append(vo.getRequisicao().getCodigo());
            where.append(" and exa_codigo = ").append(ASPA.concat(vo.getExame().getCodigo()).concat(ASPA));
            where.append(" and mco_codigo = ").append(vo.getMatColeta().getCodigo());
            sql.append((CharSequence)where);
            try {
                ResultSet rs = st.executeQuery(sql.toString());
                if (!rs.next()) continue;
                sql.delete(0, sql.length());
                sql.append("update examerequisicaorecipiente set ere_codigoapoiado = ").append(ASPA.concat(vo.getCodigoApoiado()).concat(ASPA));
                sql.append((CharSequence)where);
                if (isColetaWeb) {
                    st.executeUpdate(sql.toString());
                    continue;
                }
                Conexao.executeUpdate(filial, st, sql.toString(), true);
            }
            catch (Exception e) {
                try {
                    anular.call();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    public void atualizarRetornoWSLoteExternoRequiscao(LoteExternoRequisicaoVO vo, boolean agruparMultiguia, boolean isColetaWeb, Statement st) throws SQLException {
        StringBuilder multiguia = new StringBuilder();
        if (agruparMultiguia) {
            Integer[] guias;
            Integer[] codReqMae = vo.getRequisicaoVO().getRequisicoesMultiguia();
            for (Integer guia : guias = RecepcaoUtil.verificaMultiGuias(st, vo.getFilialVO().getCodigo().toString(), codReqMae[0].toString(), true)) {
                multiguia.append(guia).append(",");
            }
            multiguia.replace(multiguia.length() - 1, multiguia.length(), "");
        }
        StringBuilder sql = new StringBuilder();
        sql.append(" update loteexternorequisicao set leq_retornows = '").append(StringUtil.textoDB(vo.getRetornoWS())).append("', ");
        sql.append(" leq_codigoreqapoio = '").append(vo.getCodigoReqApoio()).append(ASPA);
        sql.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
        sql.append(" and lae_codigo = ").append(vo.getLabExternoVO().getCodigo());
        sql.append(" and req_codigo in ( ");
        sql.append(agruparMultiguia ? multiguia : vo.getRequisicaoVO().getCodigo());
        sql.append(" ) ");
        sql.append(" and lex_codigo = ").append(vo.getLoteExternoVO().getCodigo());
        sql.append(" and fil_kodigo = ").append(vo.getFilialVO().getCodigo()).append(";");
        if (isColetaWeb) {
            st.executeUpdate(sql.toString());
        } else {
            Conexao.executeUpdate(Variaveis.filialPadrao, st, sql.toString(), true);
        }
    }
}

