/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.externo.exportadores.shift;

import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.relatorios.apoio.RelatorioSituacaoLote;
import jalis.laboratorio.triagem.externo.Exportador;
import jalis.laboratorio.triagem.externo.LaboratorioExterno;
import jalis.laboratorio.triagem.externo.RetornoEstornarLote;
import jalis.laboratorio.triagem.externo.exportadores.IntegracaoLabExterno;
import jalis.laboratorio.triagem.externo.exportadores.ProcessaErroRetornoWebServiceLabExterno;
import jalis.laboratorio.triagem.externo.exportadores.UtilExportadores;
import jalis.laboratorio.triagem.externo.exportadores.VisualizaErroRetornoWebService;
import jalis.laboratorio.triagem.externo.exportadores.shift.ExportacaoParaShiftDao;
import jalis.laboratorio.util.impressao.Impressao;
import jalis.laboratorio.util.impressao.ImprimirEtiquetasColetaTriagem;
import jalis.laboratorio.util.impressao.RetornoImpressaoEtiquetas;
import jalis.laboratorio.util.impressao.labexterno.ImpressorasLabExterno;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.laboratorio.util.parsers.shift.ComunicacaoShift;
import jalis.laboratorio.util.parsers.shift.ShiftCampos;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.exame.ExameVO;
import jalis.model.vo.cadastro.exame.LabExternoVO;
import jalis.model.vo.cadastro.exame.MaterialColetaVO;
import jalis.model.vo.recepcao.ExameRequisicaoRecipienteVO;
import jalis.model.vo.recepcao.RequisicaoVO;
import jalis.model.vo.triagem.LoteExternoRequisicaoVO;
import jalis.model.vo.triagem.LoteExternoVO;
import jalis.relatorio.Gerador;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.impressao.termica.ImpressaoTermica;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.File;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.table.TableModel;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class ExportacaoParaShift
extends IntegracaoLabExterno
implements Exportador {
    boolean debug = Funcoes.arquivoExiste(System.getProperty("user.home") + System.getProperty("file.separator") + "debug.jalis");
    private final transient ExportacaoParaShiftDao dao;
    private transient XMLStringBuilder xml = new XMLStringBuilder(true);
    private String retornoShift = null;
    private static final String ID_LABORATORIO = "idLaboratorio";
    private static final String SENHA = "senha";
    private static final String WEB_SERVICE = "enderecoWebService";

    public ExportacaoParaShift() {
        this.dao = new ExportacaoParaShiftDao();
    }

    @Override
    public String getTagCodigo() {
        return ID_LABORATORIO;
    }

    @Override
    public RetornoImpressaoEtiquetas exportarExames(String codLabExterno, String numeroLote, String configuracaoLabExterno, boolean reenvio, List<Registro> requisicoes, int colunaOrdenacao, boolean isColetaWeb, int agruparInterface, Statement st, Statement st2, Statement st3, String variaveisLogin, boolean agruparGuiasInterface, String imprimirEtiquetaTriagemSemMaterial, boolean imprimirEtiquetaColetaSemMaterial, boolean imprimirEtiquetaColetaSelecionadaSemMaterial, boolean agruparEtqPorQtde, String tipoExportacaoInterface, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario, String tipoIntegracao, String tamanhoNomeImpressora, String[] impressorasLocais, ImpressorasLabExterno impressoras, String tipoEtiquetaSoroteca, Callable<Boolean> arquivar, Callable<Boolean> anular, LaboratorioExterno labExterno, boolean agruparMultiguia) {
        RetornoImpressaoEtiquetas retorno = new RetornoImpressaoEtiquetas();
        String enderecoWebService = StringUtil.getValor(configuracaoLabExterno, WEB_SERVICE);
        ComunicacaoShift comunicacao = new ComunicacaoShift(enderecoWebService);
        if (!comunicacao.conexaoValida(isColetaWeb)) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel conectar ao servidor. Verifique sua internet.", 2);
            try {
                ExportacaoParaShift.removerLote(codLabExterno, requisicoes, numeroLote, st, isColetaWeb, arquivar, agruparInterface);
                retorno.setImprimiu(false);
                return retorno;
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel desfazer o lote solicitado.\n" + e.getMessage(), e.getStackTrace());
            }
        }
        requisicoes = ExportacaoParaShift.agruparMutiguia(requisicoes, st, agruparGuiasInterface, digitosTuboFilial);
        String idLaboratorio = StringUtil.getValor(configuracaoLabExterno, ID_LABORATORIO);
        String senha = StringUtil.getValor(configuracaoLabExterno, SENHA);
        try {
            for (Registro requisicao : requisicoes) {
                HttpUriRequest request;
                CloseableHttpClient client;
                CloseableHttpResponse response;
                this.montaXml(idLaboratorio, senha, requisicao, st, digitosTuboFilial, digitosTuboRequisicao);
                if (this.debug) {
                    this.mensagemRetorno("ENVIO \n" + this.xml);
                }
                if (comunicacao.statusOK(response = (client = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)comunicacao.construirSSL()).build()).execute(request = comunicacao.request(this.xml.toString(), "http://www.shift.com.br/shift.bs.WSApoio.ImportaPedido")))) {
                    HttpEntity entity = response.getEntity();
                    this.retornoShift = EntityUtils.toString((HttpEntity)entity);
                }
                this.retornoShift = StringUtil.xmlToTexto(this.retornoShift);
                LoteExternoRequisicaoVO vo = this.constuirLoteExternoRequisicaoVO(requisicao, codLabExterno, numeroLote);
                this.processarRetorno(isColetaWeb, this.retornoShift, vo, requisicao, this.xml.toString(), reenvio, numeroLote, st, agruparGuiasInterface, arquivar, anular, st2, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, impressoras.getImpressoraShift(), tipoEtiquetaSoroteca, retorno, agruparInterface);
            }
            retorno.setImprimiu(true);
            return retorno;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel criar o lote solicitado.\n" + e.getMessage(), e.getStackTrace());
            retorno.setImprimiu(false);
            return retorno;
        }
    }

    private void processarRetorno(boolean isColetaWeb, String retorno, LoteExternoRequisicaoVO vo, Registro requisicao, String xmlEnviado, boolean reenvio, String numeroLote, Statement st, boolean agruparGuiasInterface, Callable<Boolean> arquivar, Callable<Boolean> anular, Statement st2, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, String impressoraShift, String tipoEtiquetaSoroteca, RetornoImpressaoEtiquetas retornoEtq, int agruparInterface) throws Exception {
        boolean importaPedidos = Boolean.parseBoolean(StringUtil.getValor(retorno, "ImportaPedidoResult"));
        boolean possuiRetorno = Boolean.parseBoolean(StringUtil.getValor(retorno, "retorno"));
        if (this.debug) {
            this.mensagemRetorno("RETORNO: " + retorno);
        }
        if (importaPedidos) {
            if (!possuiRetorno) {
                UtilExportadores.adicionarMensagemRetorno(StringUtil.getValor(retorno, "descErro"), Protocolo.Shift.getDescricao(), retornoEtq);
                this.processaErro(StringUtil.getValor(retorno, "descErro"), vo, requisicao, reenvio, numeroLote, st, isColetaWeb, arquivar, agruparInterface, retornoEtq);
            } else {
                Set<String> etiquetas = StringUtil.getSetValoresTagAberta(retorno, "etiqueta", true);
                vo.setRetornoWS(etiquetas.toString());
                List<String> examesShift = StringUtil.getListValoresTagAberta(retorno, "exame", false);
                List<String> examesOrigem = StringUtil.getListValoresTagAberta(xmlEnviado, "exame", false);
                String ordemServicoShift = StringUtil.getValor(retorno, "ordemServico");
                vo.setCodigoReqApoio(ordemServicoShift.replace("-", ""));
                ArrayList<ExameRequisicaoRecipienteVO> recipientes = new ArrayList<ExameRequisicaoRecipienteVO>();
                for (Registro exa : (List)requisicao.getValor("listaexames")) {
                    this.construirRecipientes(examesShift, examesOrigem, exa, recipientes, tipoEtiquetaSoroteca);
                    ImprimirEtiquetasColetaTriagem.criaRecipiente(isColetaWeb, String.valueOf(vo.getFilialVO().getCodigo()), exa.getValor("req_codigo").toString(), tipoEtiq, true, true, st, st2, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, agruparInterface, agruparGuiasInterface);
                }
                this.dao.atualizarExameRequisicaoRecipiente(recipientes, isColetaWeb, st, arquivar, anular);
                boolean agruparMultiguia = ExportacaoParaShift.agruparMultiguia(vo.getFilialVO().getCodigo().toString(), vo.getRequisicaoVO().getCodigo().toString(), st, agruparGuiasInterface);
                this.dao.atualizarRetornoWSLoteExternoRequiscao(vo, agruparMultiguia, isColetaWeb, st);
                this.imprimirEtiquetas(etiquetas, isColetaWeb, impressoraShift);
            }
        } else {
            UtilExportadores.adicionarMensagemRetorno(StringUtil.getValor(retorno, "pDescricaoErro"), Protocolo.Shift.getDescricao(), retornoEtq);
            this.processaErro(StringUtil.getValor(retorno, "pDescricaoErro"), vo, requisicao, reenvio, numeroLote, st, isColetaWeb, arquivar, agruparInterface, retornoEtq);
        }
    }

    private void imprimirEtiquetas(Set<String> etiquetas, boolean isColetaWeb, String impressoraShift) {
        ImpressaoTermica termica = new ImpressaoTermica(Impressao.comparaNomeImpressoraReduzido(impressoraShift), isColetaWeb);
        StringBuilder etiquetasImpressao = new StringBuilder();
        for (String etiqueta : etiquetas) {
            etiqueta = etiqueta.substring(10, etiqueta.length() - 11);
            etiquetasImpressao.append(etiqueta);
        }
        if (!Funcoes.textoVazio(etiquetasImpressao.toString())) {
            termica.imprimirDireto(etiquetasImpressao.toString());
        }
    }

    @Override
    public int getMaiorCodigoLote(String numeroLote, String codigoConvenio, LaboratorioExterno labExterno, Statement st) {
        return this.dao.getMaiorCodigoLote(labExterno.codigoLab, st);
    }

    @Override
    public byte[] imprimeRelatorio(boolean isColetaWeb, String codLabExterno, String numeroLote, List<Registro> requisicoesListaOriginal, int colunaOrdenacao, Statement st, int filialPadrao, int digitosTuboRequisicao, int digitosTuboFilial, String impressoraRelatorio) throws Exception {
        RelatorioSituacaoLote rel = new RelatorioSituacaoLote();
        ModeloGridTable modelo = rel.getModeloDados(st, new String[]{String.valueOf(numeroLote)}, new String[]{String.valueOf(codLabExterno)}, colunaOrdenacao, requisicoesListaOriginal, filialPadrao, digitosTuboRequisicao, digitosTuboFilial);
        if (modelo.getRowCount() > 0) {
            Gerador gerador = new Gerador(impressoraRelatorio);
            HashMap<String, Object> variaveis = new HashMap<String, Object>();
            variaveis.put("filtroLote", numeroLote);
            String xmlRelatorio = rel.getXMLRelatorio(st);
            if (!isColetaWeb) {
                JDialog dialogo = new JDialog((Frame)Laboratorio.getInstancia(), "Relat\u00f3rio de lote enviado");
                dialogo.setModal(true);
                dialogo.setSize(new Dimension(750, 600));
                dialogo.setLayout(new BorderLayout());
                gerador.setPai(dialogo.getContentPane());
                gerador.setPreVisualizar(true);
                gerador.setZoomPreVisualizar(0.5f);
                gerador.setAcaoFechar(dialogo::dispose);
                gerador.executar(xmlRelatorio, (TableModel)modelo, variaveis);
                ScreenUtil.centralizar(dialogo);
                dialogo.setVisible(true);
            } else {
                gerador.executar(xmlRelatorio, modelo, variaveis, false, true, isColetaWeb);
                return Impressao.gerarPdfRelatorio(gerador.getRelatorio(), xmlRelatorio);
            }
        }
        return new byte[0];
    }

    private void processaErro(String retorno, LoteExternoRequisicaoVO vo, Registro requisicao, boolean reenvio, String numeroLote, Statement st, boolean isColetaWeb, Callable<Boolean> arquivar, int agruparInterface, RetornoImpressaoEtiquetas retornoImpressao) throws Exception {
        String nomeArquivo = "remessa_" + numeroLote + ".xml";
        ProcessaErroRetornoWebServiceLabExterno erroRetornoWebServiceLabExterno = new ProcessaErroRetornoWebServiceLabExterno(retorno, "");
        if (!isColetaWeb) {
            VisualizaErroRetornoWebService telaVisualizacaoErro = VisualizaErroRetornoWebService.novaInstancia(Laboratorio.getInstancia(), "Erro ao enviar lotes", erroRetornoWebServiceLabExterno, true, "Shift");
            if (telaVisualizacaoErro != null && telaVisualizacaoErro.isGerarArquivo()) {
                this.gerarArquivo(this.xml.toString(), new File(nomeArquivo), reenvio, "Arquivo de exporta\u00e7\u00e3o Shift (*.xml)");
            }
        } else {
            retornoImpressao.setNomeArquivoLote(nomeArquivo);
            retornoImpressao.setXmlLote(this.xml.toString());
            retornoImpressao.setExtensaoArquivo("xml");
            UtilExportadores.adicionarMensagemRetorno(erroRetornoWebServiceLabExterno.getXmlErro(), "Alvaro", retornoImpressao);
        }
        List<Registro> requisicoes = Arrays.asList(requisicao);
        ExportacaoParaShift.removerLote(vo.getLabExternoVO().getCodigo().toString(), requisicoes, vo.getLoteExternoVO().getCodigo().toString(), st, isColetaWeb, arquivar, agruparInterface);
    }

    private LoteExternoRequisicaoVO constuirLoteExternoRequisicaoVO(Registro requisicao, String codLabExterno, String numeroLote) {
        LoteExternoRequisicaoVO vo = new LoteExternoRequisicaoVO();
        FilialVO filial = new FilialVO();
        filial.setCodigo(requisicao.getInt("fil_codigo"));
        LabExternoVO labExterno = new LabExternoVO();
        labExterno.setCodigo(Integer.valueOf(codLabExterno));
        RequisicaoVO reqVO = new RequisicaoVO();
        reqVO.setCodigo(requisicao.getInt("req_codigo"));
        Integer codigoMae = requisicao.getInt("req_codigomae");
        reqVO.setRequisicoesMultiguia(new Integer[]{codigoMae});
        LoteExternoVO loteExterno = new LoteExternoVO();
        loteExterno.setCodigo(Integer.valueOf(numeroLote));
        vo.setFilialVO(filial);
        vo.setLabExternoVO(labExterno);
        vo.setRequisicaoVO(reqVO);
        vo.setLoteExternoVO(loteExterno);
        return vo;
    }

    private List<ExameRequisicaoRecipienteVO> construirRecipientes(List<String> examesShift, List<String> examesOrigem, Registro requisicao, List<ExameRequisicaoRecipienteVO> recipientes, String tipoEtiquetaSoroteca) {
        FilialVO filial = new FilialVO();
        filial.setCodigo(requisicao.getInt("fil_codigo"));
        RequisicaoVO reqVO = new RequisicaoVO();
        reqVO.setCodigo(requisicao.getInt("req_codigo"));
        block0: for (String exaShift : examesShift) {
            String codExameShift = StringUtil.getValor(exaShift, "codigo");
            for (String exaOrigem : examesOrigem) {
                String codExameApoio = StringUtil.getValor(exaOrigem, "codigoApoio");
                if (!codExameShift.equalsIgnoreCase(codExameApoio)) continue;
                String codBarraShift = StringUtil.getValor(exaShift, "codigoBarra");
                String codOrigem = StringUtil.getValor(exaOrigem, "codigoLISOrigem");
                String[] exameMaterial = codOrigem.split("\\|");
                String exaCodigo = exameMaterial[0];
                String mcoCodigo = exameMaterial[1];
                if (!exaCodigo.equals(requisicao.getValor("exa_codigo")) || !mcoCodigo.equals(requisicao.getValor("mco_codigo").toString())) continue;
                ExameVO exame = new ExameVO();
                exame.setCodigo(exaCodigo);
                MaterialColetaVO material = new MaterialColetaVO();
                material.setCodigo(Integer.valueOf(mcoCodigo));
                ExameRequisicaoRecipienteVO vo = new ExameRequisicaoRecipienteVO();
                vo.setFilial(filial);
                vo.setRequisicao(reqVO);
                vo.setCodigoApoiado(codBarraShift);
                vo.setMatColeta(material);
                vo.setExame(exame);
                vo.setTipoEtiqueta(tipoEtiquetaSoroteca);
                recipientes.add(vo);
                continue block0;
            }
        }
        return recipientes;
    }

    private void montaXml(String idLaboratorio, String senha, Registro requisicao, Statement st, int digitosTuboFilial, int digitosTuboRequisicao) throws XMLStringBuilderException, ParseException {
        this.xml.limpar();
        this.xml.escrever("<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:shif=\"http://www.shift.com.br\">");
        this.xml.escrever("<soapenv:Header/>");
        this.xml.abrir("soapenv:Body");
        this.xml.escrever("<shif:ImportaPedido>");
        this.xml.escrever("shif:IdLaboratorio", idLaboratorio);
        this.xml.escrever("shif:Senha", senha);
        this.xml.escrever("<shif:ListaPedidoLab><![CDATA[");
        this.gerarXml(requisicao, st, digitosTuboFilial, digitosTuboRequisicao);
        this.xml.escrever("]]></shif:ListaPedidoLab>");
        this.xml.escrever("</shif:ImportaPedido>");
        this.xml.fechar("soapenv:Body");
        this.xml.escrever("</soapenv:Envelope>");
    }

    private String gerarXml(Registro requisicao, Statement st, int digitosTuboFilial, int digitosTuboRequisicao) throws XMLStringBuilderException, ParseException {
        this.xml.abrir(ShiftCampos.LISTA_PEDIDO_LAB.getTag());
        this.xml.abrir(ShiftCampos.PEDIDOLAB.getTag());
        this.xml.abrir(ShiftCampos.PEDIDO.getTag());
        String ordemServico = Funcoes.preencheZero(requisicao.getString("fil_codigo"), digitosTuboFilial) + Funcoes.preencheZero(requisicao.getString("req_codigo"), digitosTuboRequisicao);
        this.xml.escrever(ShiftCampos.ORDEM_SERVICO.getTag(), ordemServico);
        this.xml.fechar(ShiftCampos.PEDIDO.getTag());
        this.gerarDadosPacienteNoXml(this.xml, requisicao, st);
        this.gerarDadosExamesNoXml(this.xml, requisicao);
        this.xml.fechar(ShiftCampos.PEDIDOLAB.getTag());
        this.xml.fechar(ShiftCampos.LISTA_PEDIDO_LAB.getTag());
        return this.xml.toString();
    }

    private void gerarDadosPacienteNoXml(XMLStringBuilder xml, Registro requisicao, Statement st) throws XMLStringBuilderException, ParseException {
        xml.abrir(ShiftCampos.PACIENTE.getTag());
        xml.escrever(ShiftCampos.PAC_CODIGO.getTag(), ShiftCampos.PAC_CODIGO.getConteudoTagTamanhoMaximo(requisicao.getString("pac_codigo")));
        xml.escrever(ShiftCampos.PAC_NOME.getTag(), StringUtil.removerAcentos(ShiftCampos.PAC_NOME.getConteudoTagTamanhoMaximo(requisicao.getString("pac_nome"))));
        xml.escrever(ShiftCampos.PAC_SEXO.getTag(), requisicao.getString("pac_sexo"));
        Date dataNascimento = requisicao.getDate("pac_datanasc");
        xml.escrever(ShiftCampos.PAC_DATA_NASCIMENTO.getTag(), dataNascimento == null ? "" : Funcoes.formataData("yyyy-MM-dd", dataNascimento));
        String cartaoSUS = this.dao.pesquisarCartaoSUS(requisicao.getString("req_codigo"), requisicao.getString("fil_codigo"), st);
        xml.escrever(ShiftCampos.PAC_CNS.getTag(), Funcoes.textoVazio(cartaoSUS) ? "" : cartaoSUS);
        xml.fechar(ShiftCampos.PACIENTE.getTag());
    }

    private void gerarDadosExamesNoXml(XMLStringBuilder xml, Registro requisicao) throws XMLStringBuilderException {
        xml.abrir(ShiftCampos.EXAMES.getTag());
        List exames = (List)requisicao.getValor("listaexames");
        for (Registro exame : exames) {
            List listaExamesDesmembrados = (List)exame.getValor("listaexames");
            if (null != listaExamesDesmembrados && !listaExamesDesmembrados.isEmpty()) {
                for (Registro exameDesmembrado : listaExamesDesmembrados) {
                    this.gerarDadosExameNoXml(xml, requisicao, exameDesmembrado);
                }
                continue;
            }
            this.gerarDadosExameNoXml(xml, requisicao, exame);
        }
        xml.fechar(ShiftCampos.EXAMES.getTag());
    }

    private void gerarDadosExameNoXml(XMLStringBuilder xml, Registro requisicao, Registro exame) throws XMLStringBuilderException {
        String configuracaoExameShift = exame.getString("ele_xmllabexterno");
        String codigoExameShift = StringUtil.getValor(configuracaoExameShift, "codigo");
        String codigoOrigem = exame.getString("exa_codigo").concat("|").concat(exame.getString("mco_codigo"));
        xml.abrir(ShiftCampos.EXAME.getTag());
        xml.escrever(ShiftCampos.EXA_CODIGO_APOIO.getTag(), codigoExameShift);
        xml.escrever(ShiftCampos.EXA_CODIGO_LIS_ORIGEM.getTag(), codigoOrigem);
        this.gerarDadosMedicoNoXml(xml, requisicao);
        xml.fechar(ShiftCampos.EXAME.getTag());
    }

    private void gerarDadosMedicoNoXml(XMLStringBuilder xml, Registro requisicao) throws XMLStringBuilderException {
        xml.abrir(ShiftCampos.MEDICOS.getTag());
        xml.abrir(ShiftCampos.MEDICO.getTag());
        xml.escrever(ShiftCampos.MED_NOME.getTag(), StringUtil.removerAcentos(ShiftCampos.MED_NOME.getConteudoTagTamanhoMaximo(requisicao.getString("med_nome"))));
        xml.escrever(ShiftCampos.MED_CRM.getTag(), requisicao.getString("med_crm"));
        xml.escrever(ShiftCampos.MED_CONSELHO.getTag(), requisicao.getString("med_conselho"));
        xml.escrever(ShiftCampos.MED_UF.getTag(), requisicao.getString("med_uf"));
        xml.fechar(ShiftCampos.MEDICO.getTag());
        xml.fechar(ShiftCampos.MEDICOS.getTag());
    }

    private void mensagemRetorno(String mensagem) {
        Logger logger = Logger.getLogger(ExportacaoParaShift.class.getName());
        logger.log(Level.INFO, mensagem);
    }

    @Override
    public RetornoEstornarLote estornarExames(String codLabExterno, List<Registro> requisicoes, String numeroLote, boolean isColetaWeb, Statement st, Callable<Boolean> arquivar, Callable<Boolean> anular, int agruparInterface, LaboratorioExterno labSelecionado, boolean agruparMultiguia, String login, int digitosTuboFilial, int digitosTuboRequisicao) throws Exception {
        RetornoEstornarLote retorno = new RetornoEstornarLote();
        boolean isEstornar = false;
        if (!isColetaWeb) {
            String mensagem = "J\u00e1 solicitou o Cancelamento do Lote/Requisi\u00e7\u00e3o no Laborat\u00f3rio Shift? O lote s\u00f3 deve ser estornado, ap\u00f3s cancelamento no Shift, pois esse processo no sistema Jalis, n\u00e3o poder\u00e1 mais ser revertido. Confirma o estorno?";
            boolean bl = isEstornar = Funcoes.mensagem(Laboratorio.getInstancia(), mensagem, 4) == 0;
        }
        if (isEstornar || isColetaWeb) {
            retorno = super.estornarExames(labSelecionado.codigoLab, requisicoes, numeroLote, isColetaWeb, st, arquivar, anular, agruparInterface, labSelecionado, agruparMultiguia, login, digitosTuboFilial, digitosTuboRequisicao);
        }
        return retorno;
    }
}

