/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.externo.exportadores.sf;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.relatorios.apoio.RelatorioSituacaoLote;
import jalis.laboratorio.triagem.externo.Exportador;
import jalis.laboratorio.triagem.externo.LaboratorioExterno;
import jalis.laboratorio.triagem.externo.exportadores.IntegracaoLabExterno;
import jalis.laboratorio.triagem.externo.exportadores.sf.ArquivoSFranco;
import jalis.laboratorio.triagem.externo.exportadores.sf.EtiquetasExameSFranco;
import jalis.laboratorio.util.impressao.Impressao;
import jalis.laboratorio.util.impressao.RetornoImpressaoEtiquetas;
import jalis.laboratorio.util.impressao.labexterno.ImpressorasLabExterno;
import jalis.laboratorio.util.parsers.sf.ConfiguracaoProtocoloSFranco;
import jalis.laboratorio.util.parsers.sf.ExameSFranco;
import jalis.relatorio.Gerador;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.File;
import java.math.BigInteger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.table.TableModel;

public class ExportacaoParaSFranco
extends IntegracaoLabExterno
implements Exportador {
    static String SQL;

    @Override
    public String getTagCodigo() {
        return "codigo";
    }

    @Override
    public RetornoImpressaoEtiquetas exportarExames(String codLabExterno, String numeroLote, String confLabExterno, boolean reenvio, List<Registro> requisicoes, int colunaOrdenacao, boolean isColetaWeb, int agruparInterface, Statement st, Statement st2, Statement st3, String variaveisLogin, boolean agruparGuiasInterface, String imprimirEtiquetaTriagemSemMaterial, boolean imprimirEtiquetaColetaSemMaterial, boolean imprimirEtiquetaColetaSelecionadaSemMaterial, boolean agruparEtqPorQtde, String tipoExportacaoInterface, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario, String tipoIntegracao, String tamanhoNomeImpressora, String[] impressorasLocais, ImpressorasLabExterno impressoras, String tipoEtiquetaSoroteca, Callable<Boolean> arquivar, Callable<Boolean> anular, LaboratorioExterno labExterno, boolean agruparMultiguia) {
        ConfiguracaoProtocoloSFranco configLabExterno = new ConfiguracaoProtocoloSFranco(confLabExterno);
        BigInteger qtRequisicoes = BigInteger.valueOf(requisicoes.size());
        RetornoImpressaoEtiquetas retorno = new RetornoImpressaoEtiquetas();
        try {
            for (Registro reg : requisicoes) {
                this.recuperaInformacoes(st, reg);
            }
            if (qtRequisicoes.compareTo(configLabExterno.getQtCipRestante()) > 0) {
                String aviso = "Quantidade insuficiente de c\u00f3digos CIP na faixa configurada.\nEntre em contato com o laborat\u00f3rio S\u00e9rgio Franco solicitando uma nova faixa.\nEm seguida, configure essa faixa no sistema Jalis acessando 'Cadastros/Exames/Lab. Externo'.";
                Funcoes.mensagem(Laboratorio.getInstancia(), aviso, 1);
                retorno.setImprimiu(false);
                return retorno;
            }
            this.adicionaCIP(configLabExterno, requisicoes, codLabExterno);
            SQL = "select lex_datahora from loteexterno where fil_codigo = " + Variaveis.filialPadrao + " and lex_codigo = " + numeroLote + " and lae_codigo = " + codLabExterno;
            ResultSet res = st.executeQuery(SQL);
            res.next();
            Timestamp dataGeracaoLote = res.getTimestamp("lex_datahora");
            if (configLabExterno.isUsaEtiqueta() && !this.preencheEtiquetaExames(requisicoes, st, reenvio)) {
                retorno.setImprimiu(false);
                return retorno;
            }
            String nomeArquivo = configLabExterno.getCodigoNoSFranco() + Funcoes.formataData("yyyyMMddHHmmss", dataGeracaoLote) + ".txt";
            ArquivoSFranco arquivo = new ArquivoSFranco();
            int qtTotalReq = 0;
            int qtTotalExames = 0;
            this.preencheInfoLaboratorio(arquivo, configLabExterno.getCodigoNoSFranco(), dataGeracaoLote);
            for (Registro reg : requisicoes) {
                this.preencheInfoPaciente(arquivo, reg);
                this.preencheInfoMedicamento(arquivo, reg, st);
                for (Registro regExa : (List)reg.getValor("listaexames")) {
                    this.preencheExames(arquivo, regExa);
                    ++qtTotalExames;
                }
                ++qtTotalReq;
            }
            this.preencheFinalizador(arquivo, qtTotalReq, qtTotalExames);
            if (isColetaWeb) {
                retorno.setNomeArquivoLote(nomeArquivo);
                retorno.setXmlLote(arquivo.getConteudo());
                retorno.setExtensaoArquivo("txt");
                retorno.setImprimiu(true);
                return retorno;
            }
            JFileChooser chooser = ComponenteFactory.novoJFileChooser("Salvar");
            chooser.setApproveButtonText("Salvar");
            chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
            chooser.setSelectedFile(new File(nomeArquivo));
            chooser.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo de exporta\u00e7\u00e3o S. Franco (*.txt)", "txt"));
            if (chooser.showOpenDialog(null) != 0) {
                retorno.setImprimiu(false);
                return retorno;
            }
            arquivo.grava(chooser.getSelectedFile().getPath());
            retorno.setImprimiu(true);
            return retorno;
        }
        catch (ParseException e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ExportacaoParaSFranco: 160");
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "ExportacaoParaSFranco: 163");
        }
        retorno.setImprimiu(false);
        return retorno;
    }

    @Override
    public byte[] imprimeRelatorio(boolean isColetaWeb, String codLabExterno, String numeroLote, List<Registro> requisicoesListaOriginal, int colunaOrdenacao, Statement st, int filialPadrao, int digitosTuboRequisicao, int digitosTuboFilial, String impressoraRelatorio) throws Exception {
        RelatorioSituacaoLote rel = new RelatorioSituacaoLote();
        ModeloGridTable modelo = rel.getModeloDados(st, new String[]{String.valueOf(numeroLote)}, new String[]{String.valueOf(codLabExterno)}, colunaOrdenacao, requisicoesListaOriginal, filialPadrao, digitosTuboRequisicao, digitosTuboFilial);
        if (modelo.getRowCount() > 0) {
            Gerador gerador = new Gerador(impressoraRelatorio);
            HashMap<String, Object> variaveis = new HashMap<String, Object>();
            variaveis.put("filtroLote", numeroLote);
            String xmlRelatorio = rel.getXMLRelatorio(st);
            if (!isColetaWeb) {
                JDialog dialogo = new JDialog((Frame)Laboratorio.getInstancia(), "Relat\u00f3rio de lote enviado");
                dialogo.setModal(true);
                dialogo.setSize(new Dimension(750, 600));
                dialogo.setLayout(new BorderLayout());
                gerador.setPai(dialogo.getContentPane());
                gerador.setPreVisualizar(true);
                gerador.setZoomPreVisualizar(0.5f);
                gerador.setAcaoFechar(dialogo::dispose);
                gerador.executar(xmlRelatorio, (TableModel)modelo, variaveis);
                ScreenUtil.centralizar(dialogo);
                dialogo.setVisible(true);
            } else {
                gerador.executar(xmlRelatorio, modelo, variaveis, false, true, isColetaWeb);
                return Impressao.gerarPdfRelatorio(gerador.getRelatorio(), xmlRelatorio);
            }
        }
        return new byte[0];
    }

    private void adicionaCIP(ConfiguracaoProtocoloSFranco config, List<Registro> requisicoes, String codLabExterno) throws SQLException {
        Statement st = Conexao.getStatement();
        StringBuilder bui = new StringBuilder();
        for (Registro reg : requisicoes) {
            BigInteger cip = config.geraCip(st, reg.getInt("fil_codigo"), Integer.valueOf(codLabExterno));
            bui.setLength(0);
            bui.append("select fil_codigo, rle_codigo from requisicaolabexterno where fil_codigo = ").append(reg.getInt("fil_codigo"));
            bui.append(" and req_codigo = ").append(reg.getInt("req_codigo")).append(" and lae_codigo = ").append(codLabExterno);
            ResultSet rs = st.executeQuery(bui.toString());
            if (rs.next()) {
                bui.setLength(0);
                bui.append("update requisicaolabexterno set rle_codigo = '").append(cip);
                bui.append("' where fil_codigo = ").append(reg.getInt("fil_codigo"));
                bui.append(" and req_codigo = ").append(reg.getInt("req_codigo")).append(" and lae_codigo = ").append(codLabExterno);
                st.execute(bui.toString());
            } else {
                bui.setLength(0);
                bui.append("insert into requisicaolabexterno (fil_codigo, req_codigo, rle_codigo, lae_codigo) values (");
                bui.append(reg.getInt("fil_codigo")).append(", ");
                bui.append(reg.getInt("req_codigo")).append(", '");
                bui.append(cip).append("', ");
                bui.append(codLabExterno).append(")");
                st.execute(bui.toString());
            }
            reg.setValor("cip", cip);
        }
        st.close();
    }

    private void recuperaInformacoes(Statement st, Registro reg) throws SQLException {
        StringBuilder bui = new StringBuilder();
        bui.append("select a.req_urgente, a.med_crm, a.med_uf, a.med_conselho, b.med_nome ");
        bui.append("from requisicao a ");
        bui.append("left join medico b ");
        bui.append(" on a.med_crm = b.med_crm ");
        bui.append(" and a.fil_codigo = b.fil_codigo ");
        bui.append(" and a.med_uf = b.med_uf ");
        bui.append(" and a.med_conselho = b.med_conselho ");
        bui.append("left join paciente c ");
        bui.append(" on a.fil_codigo = c.fil_codigo ");
        bui.append(" and a.pac_codigo = c.pac_codigo ");
        bui.append("where a.fil_codigo = ").append(reg.getInt("fil_codigo"));
        bui.append(" and a.req_codigo = ").append(reg.getInt("req_codigo"));
        bui.append(" and a.req_excluida = false ");
        SQL = bui.toString();
        ResultSet res = Conexao.executeQuery(st, SQL);
        if (res.next()) {
            reg.setValor("req_urgente", res.getBoolean("req_urgente"));
            reg.setValor("med_crm", res.getString("med_crm"));
            reg.setValor("med_nome", res.getString("med_nome"));
            reg.setValor("med_uf", res.getString("med_uf"));
            reg.setValor("med_conselho", res.getString("med_conselho"));
        }
        for (Registro regEx : (List)reg.getValor("listaexames")) {
            bui.setLength(0);
            bui.append("select a.exr_codetiquetaoffline, b.exa_descricao, c.mco_descricao, coalesce(a.exr_urgente, false) as exr_urgente ");
            bui.append(" from examerequisicao a");
            bui.append(" left join exames b on a.fil_codigo = b.fil_codigo");
            bui.append(" and a.exa_codigo = b.exa_codigo");
            bui.append(" left join materialcoleta c on a.fil_codigo = c.fil_codigo");
            bui.append(" and a.mco_codigo = c.mco_codigo");
            bui.append(" where a.fil_codigo = ").append(reg.getInt("fil_codigo"));
            bui.append(" and a.exa_codigo = '").append(regEx.getString("exa_codigo")).append("'");
            bui.append(" and a.mco_codigo = ").append(regEx.getInt("mco_codigo"));
            bui.append(" and a.req_codigo = ").append(reg.getInt("req_codigo"));
            bui.append(" and a.exr_excluido = false ");
            SQL = bui.toString();
            res = Conexao.executeQuery(st, SQL);
            if (!res.next()) continue;
            regEx.setValor("exa_descricao", res.getString("exa_descricao"));
            regEx.setValor("exr_codetiquetaoffline", res.getString("exr_codetiquetaoffline"));
            regEx.setValor("mco_descricao", res.getString("mco_descricao"));
            if (!res.getBoolean("exr_urgente") || reg.getBoolean("req_urgente")) continue;
            reg.setValor("req_urgente", true);
        }
    }

    private boolean preencheEtiquetaExames(List<Registro> requisicoes, Statement st, boolean reenvio) throws SQLException {
        StringBuilder bui = new StringBuilder();
        for (Registro reg : requisicoes) {
            if (reenvio) {
                boolean etiquetasOk = true;
                for (Registro regEx : (List)reg.getValor("listaexames")) {
                    if (!Funcoes.textoVazio(regEx.getString("exr_codetiquetaoffline"))) continue;
                    etiquetasOk = false;
                    break;
                }
                if (etiquetasOk) continue;
            }
            EtiquetasExameSFranco etiquetas = new EtiquetasExameSFranco((Frame)Laboratorio.getInstancia(), reg);
            for (Registro regEx : (List)reg.getValor("listaexames")) {
                etiquetas.adicionarExames(regEx.getString("exa_codigo"), ExameUtil.getDadosMaterial(reg.getString("fil_codigo"), regEx.getInt("mco_codigo")), regEx.getString("exa_descricao"), regEx.getString("exr_codetiquetaoffline"));
            }
            etiquetas.setVisible(true);
            if (etiquetas.isOK()) {
                for (Registro regEx : (List)reg.getValor("listaexames")) {
                    int pos = etiquetas.localizaExame(regEx.getString("exa_codigo"), ExameUtil.getDadosMaterial(reg.getString("fil_codigo"), regEx.getInt("mco_codigo")));
                    String etiqueta = etiquetas.getEtiqueta(pos);
                    bui.setLength(0);
                    bui.append("update examerequisicao set exr_codetiquetaoffline = '").append(etiqueta).append("'");
                    bui.append(" where fil_codigo = ").append(reg.getInt("fil_codigo"));
                    bui.append(" and exa_codigo = '").append(regEx.getString("exa_codigo")).append("'");
                    bui.append(" and mco_codigo = ").append(regEx.getInt("mco_codigo"));
                    bui.append(" and req_codigo = ").append(reg.getInt("req_codigo"));
                    SQL = bui.toString();
                    Conexao.execute(reg.getString("fil_codigo"), st, SQL);
                    regEx.setValor("exr_codetiquetaoffline", etiqueta);
                }
                continue;
            }
            return false;
        }
        return true;
    }

    private void preencheInfoLaboratorio(ArquivoSFranco arquivo, int codigoLab, Date dataGeracao) {
        arquivo.add(2, "01");
        arquivo.add(4, String.valueOf(codigoLab), true);
        arquivo.add(40, Variaveis.descricaoFilialPadrao);
        arquivo.add(14, Funcoes.formataData("yyyyMMddHHmmss", dataGeracao), true);
        arquivo.addEspaco(389);
    }

    private void preencheInfoPaciente(ArquivoSFranco arquivo, Registro reg) throws ParseException {
        String peso = reg.nulo("req_peso") ? "" : Funcoes.formataDecimal("####0.00", reg.getDouble("req_peso")).replace(',', '.');
        String altura = reg.nulo("req_altura") ? "" : Funcoes.formataDecimal("########", reg.getDouble("req_altura") * 100.0);
        arquivo.novaLinha();
        arquivo.add(2, "02");
        arquivo.add(10, reg.getString("cip"), true);
        arquivo.add(12, reg.getString("pac_codigo"), true);
        arquivo.add(1, reg.getBoolean("req_urgente") ? "S" : "N");
        arquivo.add(8, Funcoes.formataData("yyyyMMdd", reg.getDate("req_data")));
        arquivo.add(12, reg.getString("med_crm"));
        arquivo.add(40, reg.getString("med_nome"));
        arquivo.add(150, this.removerEnter(StringUtil.removerAcentos(reg.getString("req_obs"))));
        arquivo.add(40, reg.getString("pac_nome"));
        arquivo.add(1, reg.getString("pac_sexo"));
        arquivo.add(8, Funcoes.formataData("yyyyMMdd", reg.getDate("pac_datanasc")));
        arquivo.add(8, peso);
        arquivo.add(8, altura);
        arquivo.add(8, Funcoes.formataData("yyyyMMdd", reg.getDate("req_dum")));
        arquivo.add(10, "");
        arquivo.add(2, "");
        arquivo.add(10, "");
        arquivo.add(8, "");
        arquivo.add(40, "");
        arquivo.add(10, "");
        arquivo.add(8, "");
        arquivo.add(8, "");
        arquivo.add(10, "");
        arquivo.add(10, "");
        arquivo.add(3, "");
        arquivo.add(10, "");
        arquivo.add(1, "1");
        arquivo.add(4, this.getIdadePaciente(reg), true);
        arquivo.add(3, "");
        arquivo.add(4, "");
    }

    private void preencheInfoMedicamento(ArquivoSFranco arquivo, Registro reg, Statement st) throws SQLException {
        StringBuilder bui = new StringBuilder();
        bui.append("select b.mto_descricao ");
        bui.append("from requisicaomedicamento a ");
        bui.append("left join medicamentos b ");
        bui.append(" on a.mto_codigo = b.mto_codigo ");
        bui.append(" and a.fil_codigo = b.fil_codigo ");
        bui.append("where a.fil_codigo = ").append(reg.getInt("fil_codigo"));
        bui.append(" and a.req_codigo = ").append(reg.getInt("req_codigo"));
        bui.append(" order by b.mto_descricao");
        SQL = bui.toString();
        ResultSet res = Conexao.executeQuery(st, SQL);
        while (res.next()) {
            arquivo.novaLinha();
            arquivo.add(2, "05");
            arquivo.add(20, res.getString("mto_descricao"));
            arquivo.addEspaco(427);
        }
    }

    private void preencheExames(ArquivoSFranco arquivo, Registro regEx) throws ParseException {
        String recipTemp;
        ExameSFranco exSFranco = new ExameSFranco(regEx.getString("ele_xmllabexterno"));
        String descricaoMat = Funcoes.textoVazio(regEx.getString("exr_descricaomaterial")) ? regEx.getString("mco_descricao") : regEx.getString("exr_descricaomaterial");
        String volume = "";
        if (regEx.getInt("exr_volumediurese") > 0) {
            volume = String.valueOf(regEx.getInt("exr_volumediurese"));
        }
        if ((recipTemp = regEx.getString("exr_codetiquetaoffline")).length() == 12) {
            recipTemp = recipTemp.substring(1, 11);
        } else if (recipTemp.length() == 11) {
            recipTemp = recipTemp.substring(1);
        }
        arquivo.novaLinha();
        arquivo.add(2, "03");
        arquivo.add(10, exSFranco.getCodigo(), true);
        arquivo.add(1, "");
        arquivo.add(6, "");
        arquivo.add(4, volume);
        arquivo.add(8, Funcoes.formataData("yyyyMMdd", regEx.getDate("exr_datamaterial")));
        arquivo.add(6, Funcoes.formataData("HHmmss", regEx.getDate("exr_datamaterial")));
        arquivo.add(40, descricaoMat);
        arquivo.add(1, "");
        arquivo.add(1, "");
        arquivo.add(1, "");
        arquivo.add(1, "");
        arquivo.add(1, "");
        arquivo.add(3, "");
        arquivo.add(10, recipTemp);
        arquivo.addEspaco(354);
    }

    private void preencheFinalizador(ArquivoSFranco arquivo, int qtTotalPedidos, int qtTotalExames) {
        arquivo.novaLinha();
        arquivo.add(2, "04");
        arquivo.add(6, Funcoes.formataDecimal("000000", qtTotalPedidos), true);
        arquivo.add(6, Funcoes.formataDecimal("000000", qtTotalExames), true);
        arquivo.addEspaco(435);
    }

    private String removerEnter(String txt) {
        return txt.replaceAll("\n", " ");
    }

    private String getIdadePaciente(Registro req) throws ParseException {
        String idade = "";
        if (req.nulo("pac_datanasc") && !req.nulo("req_idade")) {
            String tipo = "D";
            if (req.getString("req_anomes").equals("A")) {
                tipo = "A";
            } else if (req.getString("req_anomes").equals("M")) {
                tipo = "M";
            }
            idade = req.getString("req_idade") + tipo;
        } else if (!req.nulo("pac_datanasc")) {
            Date dataNascimento = req.getDate("pac_datanasc");
            Date dataBase = req.getDate("req_data");
            int difano = Funcoes.yearsBetween(dataNascimento, dataBase);
            int difmes = Funcoes.monthBetween(dataNascimento, dataBase);
            int difdia = Funcoes.daysBetween(dataNascimento, dataBase);
            idade = difano > 0 ? difano + "A" : (difmes > 0 ? difmes + "M" : difdia + "D");
        }
        return idade;
    }

    @Override
    public int getMaiorCodigoLote(String numeroLote, String codigoConvenio, LaboratorioExterno configuracaoLabExterno, Statement st) {
        try {
            ResultSet rs = st.executeQuery("select max(lex_codigo) + 1 as codigo from loteexterno where lae_codigo = " + configuracaoLabExterno.codigoLab + " and fil_codigo = " + Variaveis.filialPadrao);
            if (rs.next()) {
                return rs.getInt("codigo");
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return 0;
    }
}

