/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.externo.exportadores.sf;

import jalis.comum.dados.DadosMaterial;
import jalis.laboratorio.DisposeListener;
import jalis.laboratorio.Laboratorio;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;

public class EtiquetasExameSFranco
extends JDialog
implements DisposeListener {
    private JPanel panelTopo = new JPanel(new BorderLayout());
    private JPanel panelInfoRequisicao = new JPanel(null);
    private JPanel panelEditaEtiqueta = new JPanel(null);
    private JPanel panelBotoes = new JPanel(new FlowLayout(2));
    private JPanel panelCentro = new JPanel(new BorderLayout());
    private JButton buttonSalvar = new JButton("Salvar");
    private JButton buttonCancelar = new JButton("Cancelar");
    private JLabel labelFilial = new JLabel("Filial:");
    private JLabel labelRequisicao = new JLabel("Requisi\u00e7\u00e3o:");
    private JLabel labelPaciente = new JLabel("Paciente:");
    private JLabel labelDescFilial = new JLabel();
    private JLabel labelDescRequisicao = new JLabel();
    private JLabel labelDescPacienteCodigo = new JLabel();
    private JLabel labelDescPacienteNome = new JLabel();
    private JLabel labelEtiqueta = new JLabel("Etiqueta");
    private JLabel labelCodExame = new JLabel();
    private JLabel labelCodMaterial = new JLabel();
    private JLabel labelDescExame = new JLabel();
    private TTextField txtEtiqueta = new TTextField(30);
    private JButton buttonOKEtiqueta = new JButton("OK");
    private JTable tableExame = new JTable();
    private JScrollPane scrollExame = new JScrollPane(this.tableExame);
    private ModeloGridTable modeloExame = new ModeloGridTable(new String[]{"C\u00f3digo", "Mat.", "Descri\u00e7\u00e3o", "Etiqueta"});
    private Registro requisicao;
    private boolean isOK = false;
    private int linhaAlterada = -1;
    public static final int COLUNA_CODIGO = 0;
    public static final int COLUNA_MATERIAL = 1;
    public static final int COLUNA_DESCRICAO = 2;
    public static final int COLUNA_ETIQUETA = 3;

    public EtiquetasExameSFranco(Frame owner, Registro requisicao) {
        super(owner, "Etiquetas de exames");
        this.requisicao = requisicao;
        if (owner instanceof Laboratorio) {
            ((Laboratorio)owner).addDisposeListener(this);
        }
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
        }
    }

    public void jbInit() throws Exception {
        this.setSize(520, 400);
        this.setLocationRelativeTo(this.getParent());
        this.setModal(true);
        this.tableExame.setModel(this.modeloExame);
        this.modeloExame.setColumnSize(new int[]{60, 60, 0, 130}, this.tableExame);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.panelTopo, "North");
        this.getContentPane().add((Component)this.panelBotoes, "South");
        this.getContentPane().add((Component)this.panelCentro, "Center");
        this.panelTopo.add((Component)this.panelInfoRequisicao, "North");
        this.panelTopo.add((Component)this.panelEditaEtiqueta, "South");
        this.panelInfoRequisicao.setBorder(BorderFactory.createTitledBorder("Informa\u00e7\u00f5es da requisi\u00e7\u00e3o"));
        this.panelInfoRequisicao.add(this.labelFilial);
        this.panelInfoRequisicao.add(this.labelDescFilial);
        this.panelInfoRequisicao.add(this.labelRequisicao);
        this.panelInfoRequisicao.add(this.labelDescRequisicao);
        this.panelInfoRequisicao.add(this.labelPaciente);
        this.panelInfoRequisicao.add(this.labelDescPacienteCodigo);
        this.panelInfoRequisicao.add(this.labelDescPacienteNome);
        this.panelBotoes.add(this.buttonSalvar);
        this.panelBotoes.add(this.buttonCancelar);
        this.panelCentro.add((Component)this.scrollExame, "Center");
        this.panelEditaEtiqueta.setBorder(BorderFactory.createTitledBorder("Exame"));
        this.panelEditaEtiqueta.add(this.labelEtiqueta);
        this.panelEditaEtiqueta.add(this.labelCodExame);
        this.panelEditaEtiqueta.add(this.labelCodMaterial);
        this.panelEditaEtiqueta.add(this.labelDescExame);
        this.panelEditaEtiqueta.add(this.txtEtiqueta);
        this.panelEditaEtiqueta.add(this.buttonOKEtiqueta);
        this.buttonSalvar.setMnemonic('S');
        this.buttonCancelar.setMnemonic('C');
        this.tableExame.setToolTipText("Barra de espa\u00e7os / duplo clique para editar");
        this.panelInfoRequisicao.setPreferredSize(new Dimension(100, 65));
        this.labelFilial.setBounds(5, 19, 59, 20);
        this.labelDescFilial.setBounds(65, 19, 89, 20);
        this.labelRequisicao.setBounds(160, 19, 79, 20);
        this.labelDescRequisicao.setBounds(240, 19, 89, 20);
        this.labelPaciente.setBounds(5, 40, 59, 20);
        this.labelDescPacienteCodigo.setBounds(65, 40, 89, 20);
        this.labelDescPacienteNome.setBounds(155, 40, 349, 20);
        this.panelEditaEtiqueta.setPreferredSize(new Dimension(100, 45));
        this.labelCodExame.setBounds(5, 19, 69, 20);
        this.labelCodMaterial.setBounds(75, 19, 80, 20);
        this.labelDescExame.setBounds(156, 19, 150, 20);
        this.txtEtiqueta.setBounds(307, 19, 150, 20);
        this.buttonOKEtiqueta.setBounds(458, 19, 40, 20);
        this.buttonOKEtiqueta.setMargin(new Insets(2, 2, 2, 2));
        this.labelDescFilial.setText(this.requisicao.getString("fil_codigo"));
        this.labelDescRequisicao.setText(this.requisicao.getString("req_codigo"));
        this.labelDescPacienteCodigo.setText(this.requisicao.getString("pac_codigo"));
        this.labelDescPacienteNome.setText(this.requisicao.getString("pac_nome"));
        this.tableExame.grabFocus();
        Funcoes.montaEnter((JComponent)this.panelTopo);
        Funcoes.montaEnter((JComponent)this.panelBotoes);
        Funcoes.montaEnter((JComponent)this.panelCentro);
        ScreenUtil.setBorda(new Component[]{this.labelCodExame, this.labelCodMaterial, this.labelDescExame, this.labelDescFilial, this.labelDescRequisicao, this.labelDescPacienteCodigo, this.labelDescPacienteNome}, new TitledBorder(""));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                if (EtiquetasExameSFranco.this.modeloExame.getRowCount() > 0) {
                    EtiquetasExameSFranco.this.tableExame.setRowSelectionInterval(0, 0);
                    EtiquetasExameSFranco.this.tableExame.grabFocus();
                }
            }
        });
        this.buttonCancelar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EtiquetasExameSFranco.this.isOK = false;
                EtiquetasExameSFranco.this.setVisible(false);
            }
        });
        this.buttonSalvar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!EtiquetasExameSFranco.this.todosPreenchidos()) {
                    Funcoes.mensagem(EtiquetasExameSFranco.this, "Alguns exames est\u00e3o sem o n\u00famero da etiqueta, \n\u00e9 necess\u00e1rio informar para Salvar.", 1);
                } else {
                    EtiquetasExameSFranco.this.isOK = true;
                    EtiquetasExameSFranco.this.setVisible(false);
                }
            }
        });
        this.tableExame.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 32) {
                    EtiquetasExameSFranco.this.alteraLinha(EtiquetasExameSFranco.this.tableExame.getSelectedRow());
                }
            }
        });
        this.tableExame.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    EtiquetasExameSFranco.this.alteraLinha(EtiquetasExameSFranco.this.tableExame.getSelectedRow());
                }
            }
        });
        this.buttonOKEtiqueta.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EtiquetasExameSFranco.this.linhaAlterada > -1) {
                    EtiquetasExameSFranco.this.modeloExame.setValueAt(EtiquetasExameSFranco.this.txtEtiqueta.getText(), EtiquetasExameSFranco.this.linhaAlterada, 3);
                }
                if (EtiquetasExameSFranco.this.modeloExame.getRowCount() > 1 && Funcoes.mensagem(EtiquetasExameSFranco.this, "Deseja aplicar o n\u00famero da etiqueta para todos os exames?", 4) == 0) {
                    for (int i = 0; i < EtiquetasExameSFranco.this.modeloExame.getRowCount(); ++i) {
                        if (!Funcoes.textoVazio(EtiquetasExameSFranco.this.modeloExame.getValueAt(i, 3).toString())) continue;
                        EtiquetasExameSFranco.this.modeloExame.setValueAt(EtiquetasExameSFranco.this.txtEtiqueta.getText(), i, 3);
                    }
                }
                EtiquetasExameSFranco.this.linhaAlterada = -1;
                EtiquetasExameSFranco.this.labelCodExame.setText("");
                EtiquetasExameSFranco.this.labelCodMaterial.setText("");
                EtiquetasExameSFranco.this.labelDescExame.setText("");
                EtiquetasExameSFranco.this.txtEtiqueta.clear();
                EtiquetasExameSFranco.this.tableExame.grabFocus();
            }
        });
    }

    private void alteraLinha(int linha) {
        if (linha <= -1) {
            return;
        }
        this.linhaAlterada = linha;
        this.labelCodExame.setText(this.modeloExame.getValueAt(this.linhaAlterada, 0).toString());
        this.labelCodMaterial.setText(this.modeloExame.getValueAt(this.linhaAlterada, 1).toString());
        this.labelDescExame.setText(this.modeloExame.getValueAt(this.linhaAlterada, 2).toString());
        this.txtEtiqueta.setText(this.modeloExame.getValueAt(this.linhaAlterada, 3).toString());
        this.txtEtiqueta.grabFocus();
    }

    public boolean isOK() {
        return this.isOK;
    }

    public void adicionarExames(String codigo, DadosMaterial material, String descricao, String etiqueta) {
        if (!this.achaDuplicado(codigo, material)) {
            this.modeloExame.addLine(new Object[]{codigo, material, descricao, etiqueta});
        }
    }

    public void limpaExames() {
        this.modeloExame.clear();
    }

    public int getCountExames() {
        return this.modeloExame.getRowCount();
    }

    public String getCodigoExame(int linha) {
        if (linha < this.modeloExame.getRowCount()) {
            return this.modeloExame.getValueAt(linha, 0).toString();
        }
        return "";
    }

    public int localizaExame(String codigoExame, DadosMaterial material) {
        return ExameUtil.localizaExame(codigoExame, material, this.modeloExame, 0, 1);
    }

    public DadosMaterial getDadosMaterial(int linha) {
        if (linha < this.modeloExame.getRowCount()) {
            return (DadosMaterial)this.modeloExame.getValueAt(linha, 1);
        }
        return null;
    }

    public String getEtiqueta(int linha) {
        if (linha < this.modeloExame.getRowCount()) {
            return this.modeloExame.getValueAt(linha, 3).toString();
        }
        return null;
    }

    private boolean achaDuplicado(String codigo, DadosMaterial material) {
        boolean retorno = false;
        for (int i = 0; i < this.modeloExame.getRowCount(); ++i) {
            if (!this.modeloExame.getValueAt(i, 0).toString().equals(codigo) || !this.modeloExame.getValueAt(i, 1).equals(material)) continue;
            retorno = true;
            break;
        }
        return retorno;
    }

    private boolean todosPreenchidos() {
        boolean retorno = true;
        for (int i = 0; i < this.modeloExame.getRowCount(); ++i) {
            if (this.modeloExame.getValueAt(i, 3) != null && !Funcoes.textoVazio(this.modeloExame.getValueAt(i, 3).toString())) continue;
            return false;
        }
        return retorno;
    }
}

