/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.externo.exportadores.sf;

import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.io.IOException;

class ArquivoSFranco {
    private StringBuilder bui = new StringBuilder();

    public void add(int tamanho, String texto) {
        this.add(tamanho, texto, false);
    }

    public void add(int tamanho, String texto, boolean exeptionSeMaior) {
        try {
            if (texto.length() < tamanho) {
                this.bui.append(StringUtil.preencheString(texto, tamanho, ' ', 0));
            } else if (texto.length() > tamanho) {
                if (exeptionSeMaior) {
                    throw new Exception();
                }
                this.bui.append(texto.substring(0, tamanho));
            } else {
                this.bui.append(texto);
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "ArquivoSFranco");
        }
    }

    public void addEspaco(int tamanho) {
        this.add(tamanho, "", false);
    }

    public void limpa() {
        this.bui.delete(0, this.bui.length());
    }

    public void novaLinha() {
        this.bui.append("\n");
    }

    public void grava(String nomeArquivo) throws IOException, Exception {
        StringUtil.escreverArquivoTexto(nomeArquivo, this.bui.toString());
    }

    public String getConteudo() {
        return this.bui.toString();
    }
}

