/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.externo.exportadores.saoMarcos;

import jalis.laboratorio.triagem.externo.LaboratorioExterno;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.tabela.Registro;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class XMLEnvioSaoMarcos {
    private final String TIPO_IMPRESSAO = "tipoImpressao";
    private final String CHAVE = "chave";
    private final String CODIGO = "codigo";
    private final String PACIENTE = "paciente";
    private final String PACIENTES = "pacientes";
    private final String NOME = "nome";
    private final String DATANASC = "datanasc";
    private final String SEXO = "sexo";
    private final String CRM = "crm";
    private final String CODIGO_LIS = "codigo_lis";
    private final String CODIGO_PACIENTE = "codigo_paciente";
    private final String UNIDADE_SOLICITANTE = "unidade_solicitante";
    private final String DATA = "data";
    private final String DADOS_ADICIONAIS = "dados_adicionais";
    private final String DADO = "dado";
    private final String CONVENIO = "convenio";
    private final String SOLICITACAO = "solicitacao";
    private final String SOLICITACOES = "solicitacoes";
    private final String MEDICOS = "medicos";
    private final String MEDICO = "medico";
    private final String EXAME = "exame";
    private final String DATA_COLETA = "data_coleta";
    private final String DATA_RESULTADO = "data_resultado";
    private final String STATUS = "status";
    private final String IND_URGENCIA = "ind_urgencia";
    private final String IND_RESULT_PARCIAL = "ind_result_parcial";
    private final String NUM_ITEM = "num_item";
    private final String AMOSTRA = "amostra";
    private final String MATERIAL = "material";
    private final String VERSAO = "versao";
    private final String ORDEM_DE_SERVICO = "ordem_de_servico";
    private final String ENTIDADE = "entidade";
    private final String IDENTIFICACAO_APOIO = "identificacao_apoio";
    private List<Registro> listaPacientes = new ArrayList<Registro>();
    private List<Registro> listaMedicos = new ArrayList<Registro>();
    private List<Registro> listaSolicitacoes = new ArrayList<Registro>();
    private XMLStringBuilder xmlEnvio = new XMLStringBuilder();
    private String numeroLote;
    private List<Registro> novaListaReq;
    private String codigoLabExterno;

    public XMLEnvioSaoMarcos(String numeroLote, List<Registro> novaListaReq, String codigoLabExterno) {
        this.numeroLote = numeroLote;
        this.novaListaReq = novaListaReq;
        this.codigoLabExterno = codigoLabExterno;
    }

    public String getXML(Statement st) throws XMLStringBuilderException {
        this.xmlEnvio.escreveHeader("1.0", "UTF-8");
        this.xmlEnvio.abrir("solicitacoes");
        this.xmlEnvio.escrever("versao", "1");
        this.xmlEnvio.escrever("ordem_de_servico", this.getOrdemServico());
        this.xmlEnvio.escrever("entidade", this.escreveDados(st));
        this.xmlEnvio.fechar("solicitacoes");
        return this.xmlEnvio.getXML();
    }

    private String getOrdemServico() {
        for (Registro reg : this.novaListaReq) {
            if (Funcoes.textoVazio(reg.getString("ordem_de_servico"))) continue;
            this.numeroLote = reg.getString("ordem_de_servico");
        }
        return this.numeroLote;
    }

    private String escreveDados(Statement st) throws XMLStringBuilderException {
        XMLStringBuilder xml = new XMLStringBuilder();
        xml.escrever("codigo", this.numeroLote);
        xml.escrever("chave", this.getChave(this.codigoLabExterno, st));
        xml.escrever("pacientes", this.escreveDadosPaciente());
        xml.escrever("medicos", this.escreveDadosMedicos());
        xml.escrever(this.escreveDadosSolicitacao());
        return xml.getXML();
    }

    private String escreveDadosSolicitacao() throws XMLStringBuilderException {
        XMLStringBuilder xml = new XMLStringBuilder();
        for (Registro reg : this.listaSolicitacoes) {
            xml.abrir("solicitacao");
            xml.escrever("codigo_lis", reg.getString("codigo_lis"));
            xml.escrever("codigo_paciente", reg.getString("codigo_paciente"));
            xml.escrever("crm", reg.getString("crm"));
            xml.escrever("unidade_solicitante", reg.getString("unidade_solicitante"));
            xml.escrever("data", reg.getString("data"));
            xml.escrever("dados_adicionais", reg.getString("dados_adicionais"));
            xml.escrever("convenio", this.escreveDadosConvenio(reg));
            xml.escrever(this.escreveDadosAmostra(reg));
            xml.fechar("solicitacao");
        }
        return xml.getXML();
    }

    private String escreveDadosAmostra(Registro reg) throws XMLStringBuilderException {
        ArrayList listaAmostras = (ArrayList)reg.getValor("amostra");
        XMLStringBuilder amostra = new XMLStringBuilder();
        for (Registro am : listaAmostras) {
            amostra.abrir("amostra");
            amostra.escrever("material", am.getString("material"));
            amostra.abrir("exame");
            amostra.escrever("codigo", am.getString("codigo"));
            amostra.escrever("dados_adicionais", am.getString("dados_adicionais"));
            amostra.escrever("crm", am.getString("crm"));
            amostra.escrever("data_coleta", am.getString("data_coleta"));
            amostra.escrever("data_resultado", am.getString("data_resultado"));
            amostra.escrever("status", am.getString("status"));
            amostra.escrever("ind_urgencia", am.getString("ind_urgencia"));
            amostra.escrever("ind_result_parcial", am.getString("ind_result_parcial"));
            amostra.escrever("num_item", am.getString("num_item"));
            amostra.fechar("exame");
            amostra.fechar("amostra");
        }
        return amostra.getXML();
    }

    private String escreveDadosConvenio(Registro reg) {
        Registro convenio = (Registro)reg.getValor("convenio");
        XMLStringBuilder con = new XMLStringBuilder();
        con.escrever("codigo", convenio.getString("codigo"));
        con.escrever("nome", convenio.getString("nome"));
        return con.getXML();
    }

    private String escreveDadosMedicos() throws XMLStringBuilderException {
        XMLStringBuilder xmlMed = new XMLStringBuilder();
        for (Registro med : this.listaMedicos) {
            xmlMed.abrir("medico");
            xmlMed.escrever("crm", med.getString("crm"));
            xmlMed.escrever("nome", med.getString("nome"));
            xmlMed.fechar("medico");
        }
        return xmlMed.getXML();
    }

    private String escreveDadosPaciente() throws XMLStringBuilderException {
        XMLStringBuilder xmlPac = new XMLStringBuilder();
        for (Registro pac : this.listaPacientes) {
            xmlPac.abrir("paciente");
            xmlPac.escrever("codigo_lis", pac.getString("codigo_lis"));
            xmlPac.escrever("datanasc", pac.getString("datanasc"));
            xmlPac.escrever("nome", pac.getString("nome"));
            xmlPac.escrever("sexo", pac.getString("sexo"));
            xmlPac.fechar("paciente");
        }
        return xmlPac.getXML();
    }

    private String getChave(String codLabExterno, Statement st) {
        LaboratorioExterno lab = LaboratorioExterno.getLabExterno(codLabExterno, st, false);
        return StringUtil.getValor(lab.configuracao, "chave").replaceAll("\"", "");
    }

    public List<Registro> getListaPacientes() {
        return this.listaPacientes;
    }

    public void setListaPacientes(List<Registro> listaPacientes) {
        this.listaPacientes = listaPacientes;
    }

    public List<Registro> getListaMedicos() {
        return this.listaMedicos;
    }

    public void setListaMedicos(List<Registro> listaMedicos) {
        this.listaMedicos = listaMedicos;
    }

    public List<Registro> getListaSolicitacoes() {
        return this.listaSolicitacoes;
    }

    public void setListaSolicitacoes(List<Registro> listaSolicitacoes) {
        this.listaSolicitacoes = listaSolicitacoes;
    }
}

