/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.externo.exportadores.saoMarcos;

import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.relatorios.apoio.RelatorioSituacaoLote;
import jalis.laboratorio.triagem.externo.Exportador;
import jalis.laboratorio.triagem.externo.LaboratorioExterno;
import jalis.laboratorio.triagem.externo.exportadores.IntegracaoLabExterno;
import jalis.laboratorio.triagem.externo.exportadores.ProcessaErroRetornoWebServiceLabExterno;
import jalis.laboratorio.triagem.externo.exportadores.UtilExportadores;
import jalis.laboratorio.triagem.externo.exportadores.VisualizaErroRetornoWebService;
import jalis.laboratorio.triagem.externo.exportadores.saoMarcos.XMLEnvioSaoMarcos;
import jalis.laboratorio.util.impressao.Etiqueta;
import jalis.laboratorio.util.impressao.Impressao;
import jalis.laboratorio.util.impressao.ImprimirEtiquetasColetaTriagem;
import jalis.laboratorio.util.impressao.RetornoImpressaoEtiquetas;
import jalis.laboratorio.util.impressao.exame.externo.saoMarcos.ConexaoSaoMarcos;
import jalis.laboratorio.util.impressao.exame.externo.saoMarcos.ImpressaoSaoMarcosService;
import jalis.laboratorio.util.impressao.labexterno.ImpressorasLabExterno;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.relatorio.Gerador;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.impressao.TipoImpressao;
import jalis.util.impressao.termica.ImpressaoTermica;
import jalis.util.tabela.Registro;
import jalis.util.xml.XMLStringBuilder;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Frame;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.swing.JDialog;
import javax.swing.table.TableModel;

public class ExportacaoSaoMarcos
extends IntegracaoLabExterno
implements Exportador {
    private final String TIPO_IMPRESSAO = "tipoImpressao";
    private final String CHAVE = "chave";
    private final String CODIGO = "codigo";
    private final String PACIENTE = "paciente";
    private final String PACIENTES = "pacientes";
    private final String NOME = "nome";
    private final String DATANASC = "datanasc";
    private final String SEXO = "sexo";
    private final String CRM = "crm";
    private final String CODIGO_LIS = "codigo_lis";
    private final String CODIGO_PACIENTE = "codigo_paciente";
    private final String UNIDADE_SOLICITANTE = "unidade_solicitante";
    private final String DATA = "data";
    private final String DADOS_ADICIONAIS = "dados_adicionais";
    private final String CONVENIO = "convenio";
    private final String SOLICITACAO = "solicitacao";
    private final String SOLICITACOES = "solicitacoes";
    private final String MEDICOS = "medicos";
    private final String MEDICO = "medico";
    private final String EXAME = "exame";
    private final String DATA_COLETA = "data_coleta";
    private final String DATA_RESULTADO = "data_resultado";
    private final String STATUS = "status";
    private final String IND_URGENCIA = "ind_urgencia";
    private final String IND_RESULT_PARCIAL = "ind_result_parcial";
    private final String NUM_ITEM = "num_item";
    private final String AMOSTRA = "amostra";
    private final String MATERIAL = "material";
    private final String VERSAO = "versao";
    private final String ORDEM_DE_SERVICO = "ordem_de_servico";
    private final String ENTIDADE = "entidade";
    private final String IDENTIFICACAO_APOIO = "identificacao_apoio";
    private final String CODIGO_APOIO_SAO_MARCOS = "codigoApoioSaoMarcos";
    private final String ETIQUETA = "etiquetas";
    private final String RETORNO = "retorno";
    private static final String PENDENTE = "P";
    private static final String HTML = "HTML";
    private static final String ERRO = "erro";
    private ImpressaoSaoMarcosService service;
    private ConexaoSaoMarcos conexao = new ConexaoSaoMarcos();

    public ExportacaoSaoMarcos() {
        this.service = new ImpressaoSaoMarcosService();
    }

    @Override
    public String getTagCodigo() {
        return "codigo";
    }

    @Override
    public RetornoImpressaoEtiquetas exportarExames(String codLabExterno, String numeroLote, String configuracaoLabExterno, boolean reenvio, List<Registro> requisicoes, int colunaOrdenacao, boolean isColetaWeb, int agruparInterface, Statement st, Statement st2, Statement st3, String variaveisLogin, boolean agruparGuiasInterface, String imprimirEtiquetaTriagemSemMaterial, boolean imprimirEtiquetaColetaSemMaterial, boolean imprimirEtiquetaColetaSelecionadaSemMaterial, boolean agruparEtqPorQtde, String tipoExportacaoInterface, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario, String tipoIntegracao, String tamanhoNomeImpressora, String[] impressorasLocais, ImpressorasLabExterno impressoras, String tipoEtiquetaSoroteca, Callable<Boolean> arquivar, Callable<Boolean> anular, LaboratorioExterno labExterno, boolean agruparMultiguia) {
        RetornoImpressaoEtiquetas retorno = new RetornoImpressaoEtiquetas();
        ArrayList<Registro> listaRequisicoesSemAgrupamento = new ArrayList<Registro>();
        for (Registro registro : requisicoes) {
            listaRequisicoesSemAgrupamento.add(registro.clone());
        }
        try {
            this.criarEtiquetas(isColetaWeb, listaRequisicoesSemAgrupamento, agruparInterface, st, st2, st3, Variaveis.login, agruparGuiasInterface, imprimirEtiquetaTriagemSemMaterial, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, agruparEtqPorQtde, tipoExportacaoInterface, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, tuboPrimario, utilizarCapacidadeTuboPrimario, arquivar);
            List<Registro> novaLista = new ArrayList<Registro>();
            for (Registro reg : requisicoes) {
                if (this.possuiDataNasc(reg.getString("pac_datanasc"))) {
                    Registro requisicaoJaEnviada = this.service.requisicaoJaEnviada(reg, codLabExterno, st);
                    if (this.carregouRegistro(requisicaoJaEnviada)) {
                        reg.setValor("ordem_de_servico", requisicaoJaEnviada.getValor("lex_codigo"));
                        reg.setValor("num_item", requisicaoJaEnviada.getString("leq_retornows"));
                        reg.setValor("metodoEnvio", requisicaoJaEnviada.getString("metodoEnvio"));
                    }
                    novaLista.add(reg.clone());
                    continue;
                }
                ExportacaoSaoMarcos.removerLote(codLabExterno, requisicoes, numeroLote, true, false, st, isColetaWeb, arquivar, agruparInterface);
                retorno.setImprimiu(false);
                return retorno;
            }
            novaLista = ExportacaoSaoMarcos.agruparMutiguia(novaLista, st, agruparGuiasInterface, digitosTuboFilial);
            if (reenvio) {
                retorno.setImprimiu(this.reenviarExames(codLabExterno, numeroLote, configuracaoLabExterno, requisicoes, reenvio, novaLista, isColetaWeb, st, digitosTuboFilial, digitosTuboRequisicao, agruparInterface, impressoras.getImpressoraSaoMarcos(), tamanhoNomeImpressora, impressorasLocais, st2, st3, agruparGuiasInterface, imprimirEtiquetaTriagemSemMaterial, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, agruparEtqPorQtde, tipoExportacaoInterface, digitosTuboTubo, tuboPrimario, utilizarCapacidadeTuboPrimario, retorno, arquivar, anular).isImprimiu());
                return retorno;
            }
            retorno = this.exportaExames(codLabExterno, numeroLote, configuracaoLabExterno, reenvio, requisicoes, novaLista, isColetaWeb, st, digitosTuboFilial, digitosTuboRequisicao, impressoras.getImpressoraSaoMarcos(), tamanhoNomeImpressora, impressorasLocais, st2, st3, agruparGuiasInterface, imprimirEtiquetaTriagemSemMaterial, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, agruparEtqPorQtde, tipoExportacaoInterface, agruparInterface, digitosTuboTubo, tuboPrimario, utilizarCapacidadeTuboPrimario, retorno, arquivar, anular);
            return retorno;
        }
        catch (Exception e) {
            if (isColetaWeb) {
                UtilExportadores.adicionarMensagemRetorno("N\u00e3o foi poss\u00edvel gerar etiquetas.<br>" + e.getMessage(), Protocolo.SaoMarcos.getDescricao(), retorno);
            } else {
                ProcessaErroRetornoWebServiceLabExterno processaErroRetornoWebServiceLabExterno = new ProcessaErroRetornoWebServiceLabExterno("N\u00e3o foi poss\u00edvel gerar etiquetas.\n" + e.getMessage(), e.getStackTrace());
                VisualizaErroRetornoWebService.novaInstancia(Laboratorio.getInstancia(), "Mensagens ao atualizar dados.", processaErroRetornoWebServiceLabExterno, false, "S\u00e3o Marcos");
            }
            retorno.setImprimiu(false);
            return retorno;
        }
    }

    private RetornoImpressaoEtiquetas exportaExames(String codLabExterno, String numeroLote, String configuracaoLabExterno, boolean reenvio, List<Registro> requisicoes, List<Registro> novaLista, boolean isColetaWeb, Statement st, int digitosTuboFilial, int digitosTuboRequisicao, String impressora, String tamanhoNomeImpressora, String[] impressorasLocais, Statement st2, Statement st3, boolean agruparGuiasInterface, String imprimirEtiquetaTriagemSemMaterial, boolean imprimirEtiquetaColetaSemMaterial, boolean imprimirEtiquetaColetaSelecionadaSemMaterial, boolean agruparEtqPorQtde, String tipoExportacaoInterface, int agruparInterface, int digitosTuboTubo, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario, RetornoImpressaoEtiquetas retornoEtq, Callable<Boolean> arquivar, Callable<Boolean> anular) throws Exception {
        ArrayList<Registro> listaPacientes = new ArrayList<Registro>();
        ArrayList<Registro> listaMedicos = new ArrayList<Registro>();
        ArrayList<Registro> listaSolicitacoes = new ArrayList<Registro>();
        listaPacientes.addAll(this.getDadosPaciente(requisicoes));
        listaMedicos.addAll(this.getDadosMedicos(requisicoes));
        for (Registro reg : novaLista) {
            listaSolicitacoes.add(this.getSolicitacoes(reg, digitosTuboFilial, digitosTuboRequisicao));
        }
        XMLEnvioSaoMarcos xmlEnvio = new XMLEnvioSaoMarcos(numeroLote, novaLista, codLabExterno);
        xmlEnvio.setListaPacientes(listaPacientes);
        xmlEnvio.setListaMedicos(listaMedicos);
        xmlEnvio.setListaSolicitacoes(listaSolicitacoes);
        String retorno = this.conexao.enviaXML(configuracaoLabExterno, xmlEnvio.getXML(st));
        return this.processaRetornoWebService(codLabExterno, numeroLote, novaLista, requisicoes, retorno, reenvio, configuracaoLabExterno, isColetaWeb, st, digitosTuboFilial, digitosTuboRequisicao, impressora, tamanhoNomeImpressora, impressorasLocais, st2, st3, agruparGuiasInterface, imprimirEtiquetaTriagemSemMaterial, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, agruparEtqPorQtde, tipoExportacaoInterface, agruparInterface, digitosTuboTubo, tuboPrimario, utilizarCapacidadeTuboPrimario, retornoEtq, arquivar, anular);
    }

    private boolean carregouRegistro(Registro reg) {
        return reg != null;
    }

    private RetornoImpressaoEtiquetas reenviarExames(String codLabExterno, String numeroLote, String configuracaoLabExterno, List<Registro> requisicoes, boolean reenvio, List<Registro> novaLista, boolean isColetaWeb, Statement st, int digitosTuboFilial, int digitosTuboRequisicao, int agruparInterface, String impressora, String tamanhoNomeImpressora, String[] impressorasLocais, Statement st2, Statement st3, boolean agruparGuiasInterface, String imprimirEtiquetaTriagemSemMaterial, boolean imprimirEtiquetaColetaSemMaterial, boolean imprimirEtiquetaColetaSelecionadaSemMaterial, boolean agruparEtqPorQtde, String tipoExportacaoInterface, int digitosTuboTubo, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario, RetornoImpressaoEtiquetas retorno, Callable<Boolean> arquivar, Callable<Boolean> anular) throws Exception {
        tipoEtiq = this.getTipoEtqReenvio(agruparInterface);
        return this.exportaExames(codLabExterno, numeroLote, configuracaoLabExterno, reenvio, requisicoes, novaLista, isColetaWeb, st, digitosTuboFilial, digitosTuboRequisicao, impressora, tamanhoNomeImpressora, impressorasLocais, st2, st3, agruparGuiasInterface, imprimirEtiquetaTriagemSemMaterial, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, agruparEtqPorQtde, tipoExportacaoInterface, agruparInterface, digitosTuboTubo, tuboPrimario, utilizarCapacidadeTuboPrimario, retorno, arquivar, anular);
    }

    private int getTipoEtqReenvio(int agruparInterface) {
        if (agruparInterface == 0) {
            return 1;
        }
        return 2;
    }

    private RetornoImpressaoEtiquetas processaRetornoWebService(String codLabExterno, String numeroLote, List<Registro> reqAgrupada, List<Registro> requisicoes, String retorno, boolean reenvio, String configuracaoLabExterno, boolean isColetaWeb, Statement st, int digitosTuboFilial, int digitosTuboRequisicao, String impressora, String tamanhoNomeImpressora, String[] impressorasLocais, Statement st2, Statement st3, boolean agruparGuiasInterface, String imprimirEtiquetaTriagemSemMaterial, boolean imprimirEtiquetaColetaSemMaterial, boolean imprimirEtiquetaColetaSelecionadaSemMaterial, boolean agruparEtqPorQtde, String tipoExportacaoInterface, int agruparInterface, int digitosTuboTubo, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario, RetornoImpressaoEtiquetas retornoEtq, Callable<Boolean> arquivar, Callable<Boolean> anular) throws Exception {
        boolean isOk = false;
        String filial = "";
        String requisicao = "";
        if (!Funcoes.textoVazio(retorno) && this.retornoValido(retorno, codLabExterno, requisicoes, numeroLote, reenvio, st, isColetaWeb, arquivar, retornoEtq, agruparInterface)) {
            List<String> solicitacoes = StringUtil.getListValoresTagAberta(retorno, "solicitacao", false);
            XMLStringBuilder xml = new XMLStringBuilder();
            for (String solicitacao : solicitacoes) {
                String codigoLis = StringUtil.getValor(solicitacao, "codigo_lis");
                if (!Funcoes.textoVazio(codigoLis)) {
                    filial = StringUtil.removeZerosEsquerda(codigoLis.substring(0, digitosTuboFilial));
                    requisicao = StringUtil.removeZerosEsquerda(codigoLis.substring(digitosTuboFilial, digitosTuboRequisicao + digitosTuboFilial));
                }
                List<String> listExamesRetorno = StringUtil.getListValoresTagAberta(solicitacao, "exame", false);
                for (Registro reg : reqAgrupada) {
                    if (!this.isMesmaRequisicao(filial, requisicao, reg)) continue;
                    ArrayList listaExamesRequisicao = (ArrayList)reg.getValor("listaexames");
                    this.getRetornoAgrupado(listaExamesRequisicao, listExamesRetorno);
                    retornoEtq = this.geraDadosEtqRequisicao(requisicoes, configuracaoLabExterno, xml, listExamesRetorno, reg, listaExamesRequisicao, reenvio, isColetaWeb, impressora, tamanhoNomeImpressora, impressorasLocais, st, st2, st3, agruparGuiasInterface, imprimirEtiquetaTriagemSemMaterial, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, agruparEtqPorQtde, tipoExportacaoInterface, agruparInterface, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, tuboPrimario, utilizarCapacidadeTuboPrimario, arquivar, anular);
                    if (reenvio && !Funcoes.textoVazio(reg.getString("novoLote"))) {
                        numeroLote = reg.getString("novoLote");
                    }
                    xml.escrever("retorno", retorno);
                }
                this.service.atualizarLoteExterno(requisicoes, codLabExterno, Variaveis.filialPadrao, numeroLote, xml.getXML(), st);
                isOk = true;
            }
        }
        retornoEtq.setImprimiu(isOk);
        return retornoEtq;
    }

    private Map<String, ArrayList<String>> getRetornoAgrupado(ArrayList<Registro> listaExamesRequisicao, List<String> listExamesRetorno) {
        HashMap<String, ArrayList<String>> map = new HashMap<String, ArrayList<String>>();
        ArrayList<String> listEx = null;
        for (String exameRetorno : listExamesRetorno) {
            listEx = new ArrayList<String>();
            String codigo = StringUtil.getValor(exameRetorno, "identificacao_apoio");
            for (int i = 0; i < listExamesRetorno.size(); ++i) {
                if (!codigo.equalsIgnoreCase(StringUtil.getValor(listExamesRetorno.get(i), "identificacao_apoio"))) continue;
                listEx.add(listExamesRetorno.get(i));
                map.put(codigo, listEx);
            }
        }
        for (String key : map.keySet()) {
            ArrayList newArray = (ArrayList)map.get(key);
            for (String exameRetorno : newArray) {
                for (Registro regExa : listaExamesRequisicao) {
                    String exaSMJalis;
                    ArrayList listaExameDesm = (ArrayList)regExa.getValor("listaexames");
                    if (this.contemExames(listaExameDesm)) {
                        for (Registro regExaDesm : listaExameDesm) {
                            String exaSMJalisDesm = StringUtil.getValor(regExaDesm.getString("ele_xmllabexterno"), "codigo");
                            if (!exaSMJalisDesm.equalsIgnoreCase(StringUtil.getValor(exameRetorno, "codigo"))) continue;
                            regExaDesm.setValor("codigoApoioSaoMarcos", this.getIdentificaApoio(newArray, regExaDesm));
                            regExa.setValor("codigoApoioSaoMarcos", this.getIdentificaApoio(newArray, regExaDesm));
                        }
                    }
                    if (!(exaSMJalis = StringUtil.getValor(regExa.getString("ele_xmllabexterno"), "codigo")).equalsIgnoreCase(StringUtil.getValor(exameRetorno, "codigo"))) continue;
                    regExa.setValor("codigoApoioSaoMarcos", this.getIdentificaApoio(newArray, regExa));
                }
            }
        }
        return map;
    }

    private boolean retornoValido(String retorno, String codLabExterno, List<Registro> requisicoes, String numeroLote, boolean reenvio, Statement st, boolean isColetaWeb, Callable<Boolean> arquivar, RetornoImpressaoEtiquetas retornoImpressao, int agruparInterface) throws NumberFormatException, Exception {
        String erro = StringUtil.getValor(retorno, ERRO);
        if (this.contemErro(erro) || retorno.contains(HTML)) {
            if (!reenvio) {
                ExportacaoSaoMarcos.removerLote(codLabExterno, requisicoes, numeroLote, st, isColetaWeb, arquivar, agruparInterface);
            }
            this.exibiMensagemErro(retorno, isColetaWeb, retornoImpressao);
            return false;
        }
        return true;
    }

    private RetornoImpressaoEtiquetas geraDadosEtqRequisicao(List<Registro> requisicoes, String configuracaoLabExterno, XMLStringBuilder xml, List<String> listExamesRetorno, Registro reg, ArrayList<Registro> listaExamesRequisicao, boolean reenvio, boolean isColetaWeb, String impressora, String tamanhoNomeImpressora, String[] impressorasLocais, Statement st, Statement st2, Statement st3, boolean agruparGuiasInterface, String imprimirEtiquetaTriagemSemMaterial, boolean imprimirEtiquetaColetaSemMaterial, boolean imprimirEtiquetaColetaSelecionadaSemMaterial, boolean agruparEtqPorQtde, String tipoExportacaoInterface, int agruparInterface, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario, Callable<Boolean> arquivar, Callable<Boolean> anular) throws Exception {
        ArrayList<Registro> listaExamesRequisicaoAux = new ArrayList<Registro>();
        for (Registro regExa : listaExamesRequisicao) {
            ArrayList listaExameDesm = (ArrayList)regExa.getValor("listaexames");
            if (this.contemExames(listaExameDesm)) {
                for (Registro re : listaExameDesm) {
                    re.setValor("exa_codigopai", regExa.getString("exa_codigo"));
                    re.setValor("mco_codigopai", regExa.getString("mco_codigo"));
                    listaExamesRequisicaoAux.add(re);
                    this.service.atualizarCodigoApoiadoExameRequisicao(re, requisicoes, st, isColetaWeb, arquivar);
                    this.service.atualizarCodigoApoiadoExameRequisicao(regExa, requisicoes, st, isColetaWeb, arquivar);
                }
                continue;
            }
            listaExamesRequisicaoAux.add(regExa);
            this.service.atualizarCodigoApoiadoExameRequisicao(regExa, requisicoes, st, isColetaWeb, arquivar);
        }
        return this.geraDadosEtqExa(requisicoes, configuracaoLabExterno, xml, reg, reenvio, listaExamesRequisicaoAux, isColetaWeb, impressora, tamanhoNomeImpressora, impressorasLocais, st, st2, st3, agruparGuiasInterface, imprimirEtiquetaTriagemSemMaterial, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, agruparEtqPorQtde, tipoExportacaoInterface, agruparInterface, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, tuboPrimario, utilizarCapacidadeTuboPrimario, arquivar, anular);
    }

    private RetornoImpressaoEtiquetas geraDadosEtqExa(List<Registro> requisicoes, String configuracaoLabExterno, XMLStringBuilder xml, Registro reg, boolean reenvio, ArrayList<Registro> listaExamesRequisicao, boolean isColetaWeb, String impressora, String tamanhoNomeImpressora, String[] impressorasLocais, Statement st, Statement st2, Statement st3, boolean agruparGuiasInterface, String imprimirEtiquetaTriagemSemMaterial, boolean imprimirEtiquetaColetaSemMaterial, boolean imprimirEtiquetaColetaSelecionadaSemMaterial, boolean agruparEtqPorQtde, String tipoExportacaoInterface, int agruparInterface, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario, Callable<Boolean> arquivar, Callable<Boolean> anular) throws Exception {
        RetornoImpressaoEtiquetas retorno = new RetornoImpressaoEtiquetas();
        StringBuilder exa = new StringBuilder();
        StringBuilder mat = new StringBuilder();
        ArrayList listaExamesRequisicaoAux = new ArrayList();
        ArrayList<String> examesJaImpressos = new ArrayList<String>();
        listaExamesRequisicaoAux = (ArrayList)listaExamesRequisicao.clone();
        for (Registro regExa : listaExamesRequisicao) {
            if (this.isExameJaImpresso(examesJaImpressos, regExa.getString("exa_codigo"))) continue;
            exa.setLength(0);
            mat.setLength(0);
            String codigo = regExa.getString("codigoApoioSaoMarcos");
            for (int i = 0; i < listaExamesRequisicaoAux.size(); ++i) {
                String cod = ((Registro)listaExamesRequisicaoAux.get(i)).getString("codigoApoioSaoMarcos");
                if (!codigo.equalsIgnoreCase(cod)) continue;
                if (exa.length() > 0) {
                    exa.append(",");
                    mat.append(",");
                }
                exa.append(((Registro)listaExamesRequisicaoAux.get(i)).getString("exa_codigo"));
                mat.append(((Registro)listaExamesRequisicaoAux.get(i)).getString("mco_codigo"));
                String codExa = StringUtil.getValor(((Registro)listaExamesRequisicaoAux.get(i)).getString("ele_xmllabexterno"), "codigo");
                regExa.setValor("codigosExames", regExa.getString("codigosExames") + " " + codExa);
            }
            if (!Funcoes.textoVazio(exa.toString())) {
                if (!Funcoes.textoVazio(regExa.getString("exa_codigopai")) && !Funcoes.textoVazio(regExa.getString("mco_codigopai"))) {
                    retorno = this.imprimirEtq(configuracaoLabExterno, regExa, reg, null, reenvio, regExa.getString("exa_codigopai"), regExa.getString("mco_codigopai"), isColetaWeb, impressora, tamanhoNomeImpressora, impressorasLocais, st, st2, st3, agruparGuiasInterface, imprimirEtiquetaTriagemSemMaterial, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, agruparEtqPorQtde, tipoExportacaoInterface, agruparInterface, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, tuboPrimario, utilizarCapacidadeTuboPrimario, arquivar, anular);
                    xml.escrever("etiquetas", retorno.getTexto());
                } else {
                    retorno = this.imprimirEtq(configuracaoLabExterno, regExa, reg, null, reenvio, exa.toString(), mat.toString(), isColetaWeb, impressora, tamanhoNomeImpressora, impressorasLocais, st, st2, st3, agruparGuiasInterface, imprimirEtiquetaTriagemSemMaterial, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, agruparEtqPorQtde, tipoExportacaoInterface, agruparInterface, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, tuboPrimario, utilizarCapacidadeTuboPrimario, arquivar, anular);
                    xml.escrever("etiquetas", retorno.getTexto());
                }
            }
            examesJaImpressos.add(exa.toString());
        }
        return retorno;
    }

    private boolean isExameJaImpresso(ArrayList<String> examesJaImpressos, String exame) {
        for (String exaImpresso : examesJaImpressos) {
            String[] ex;
            for (String e : ex = exaImpresso.split(",")) {
                if (!e.trim().equalsIgnoreCase(exame)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isMesmaRequisicao(String filial, String requisicao, Registro reg) {
        return reg.getString("fil_codigo").equalsIgnoreCase(filial) && reg.getString("req_codigo").equalsIgnoreCase(requisicao);
    }

    private boolean contemExames(ArrayList<Registro> listaDesm) {
        return listaDesm != null && !listaDesm.isEmpty();
    }

    private Object getIdentificaApoio(List<String> exames, Registro exa) {
        for (String exame : exames) {
            String codExa = StringUtil.getValor(exame, "codigo");
            if (!codExa.equalsIgnoreCase(StringUtil.getValor(exa.getString("ele_xmllabexterno"), "codigo"))) continue;
            return StringUtil.getValor(exame, "identificacao_apoio");
        }
        return null;
    }

    private void exibiMensagemErro(String retorno, boolean isColetaWeb, RetornoImpressaoEtiquetas retornoImpressao) {
        StringBuilder error = new StringBuilder();
        String[] msg = StringUtil.getValor(retorno, "Descricao").split("\n");
        if (!Funcoes.textoVazio(msg[0])) {
            error.append(msg[0]).append("\n");
        } else {
            error.append(retorno);
        }
        ProcessaErroRetornoWebServiceLabExterno erroRetornoWebServiceLabExterno = new ProcessaErroRetornoWebServiceLabExterno(error.toString(), retorno);
        if (isColetaWeb) {
            UtilExportadores.adicionarMensagemRetorno(erroRetornoWebServiceLabExterno.getXmlErro() + "<br>" + erroRetornoWebServiceLabExterno.getXmlDetalhe(), Protocolo.SaoMarcos.getDescricao(), retornoImpressao);
        } else {
            VisualizaErroRetornoWebService.novaInstancia(Laboratorio.getInstancia(), "Mensagens ao enviar lotes", erroRetornoWebServiceLabExterno, false, "S\u00e3o Marcos");
        }
    }

    private boolean contemErro(String erro) {
        return !Funcoes.textoVazio(erro);
    }

    private RetornoImpressaoEtiquetas imprimirEtq(String configuracaoLabExterno, Registro regExa, Registro regReq, Registro exaDesm, boolean reenvio, String exa, String mat, boolean isColetaWeb, String impressora, String tamanhoNomeImpressora, String[] impressorasLocais, Statement st, Statement st2, Statement st3, boolean agruparGuiasInterface, String imprimirEtiquetaTriagemSemMaterial, boolean imprimirEtiquetaColetaSemMaterial, boolean imprimirEtiquetaColetaSelecionadaSemMaterial, boolean agruparEtqPorQtde, String tipoExportacaoInterface, int agruparInterface, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario, Callable<Boolean> arquivar, Callable<Boolean> anular) throws Exception {
        RetornoImpressaoEtiquetas retornoEtq = new RetornoImpressaoEtiquetas();
        ArrayList<Object> etqs = new ArrayList<Object>();
        String[] campos = Impressao.CAMPOS_ETIQUETA_SM;
        int ultimaPosicao = 0;
        int linha = 0;
        String retorno = "";
        String filCodigo = regExa.getString("fil_codigo");
        ModeloGridTable modeloDados = new ModeloGridTable(campos);
        String tipoImpressao = StringUtil.getValor(configuracaoLabExterno, "tipoImpressao");
        String modeloImp = this.getModeloImpressao(tipoImpressao);
        ImpressaoTermica termica = new ImpressaoTermica(Impressao.comparaNomeImpressoraReduzido(impressora, tamanhoNomeImpressora, impressorasLocais), isColetaWeb);
        String cabecalho = StringUtil.getValor(configuracaoLabExterno, modeloImp);
        if (reenvio) {
            filCodigo = regExa.getString("fil_kodigo");
        }
        String[] ex = exa.split(",");
        int[] m = this.getMat(mat);
        List<Etiqueta> listaEtiquetas = ImprimirEtiquetasColetaTriagem.criaEtiqueta(isColetaWeb, filCodigo, regExa.getString("req_codigo"), ex, m, true, "", st, st2, st3, Variaveis.login, tipoEtiq, true, null, null, true, true, regReq.getString("codigoLabExterno"), true, agruparGuiasInterface, imprimirEtiquetaTriagemSemMaterial, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, agruparEtqPorQtde, tipoExportacaoInterface, agruparInterface, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, tuboPrimario, utilizarCapacidadeTuboPrimario);
        if (listaEtiquetas != null && !listaEtiquetas.isEmpty()) {
            for (int i = 0; i < listaEtiquetas.size(); ++i) {
                ultimaPosicao = 0;
                Etiqueta c = listaEtiquetas.get(i);
                modeloDados.addLine(new Object[Impressao.CAMPOS_ETIQUETA_SM.length]);
                linha = modeloDados.getRowCount() - 1;
                for (int j = 0; j < campos.length; ++j) {
                    if (campos[j].equalsIgnoreCase("quantidadeEtiquetas")) {
                        modeloDados.setValueAt(listaEtiquetas.size(), linha, ultimaPosicao++);
                        continue;
                    }
                    if (campos[j].equalsIgnoreCase("tipoRecebimentoProdutoRequisicao")) {
                        modeloDados.setValueAt(Tipos.tipoRecebimentoProduto(c.tipoRecebimentoProdutoRequisicao), linha, ultimaPosicao++);
                        continue;
                    }
                    if (campos[j].equalsIgnoreCase("exameParaRecoleta")) {
                        modeloDados.setValueAt(ImprimirEtiquetasColetaTriagem.getExamesParaRecoleta(st, regExa.getString("fil_codigo"), regExa.getString("req_codigo"), c.exameParaRecoleta), linha, ultimaPosicao++);
                        continue;
                    }
                    if (campos[j].equalsIgnoreCase("dadosClinicosRequisicao")) {
                        String dadosClinicos = StringUtil.removeCaractere(c.dadosClinicosRequisicao, '\"');
                        modeloDados.setValueAt(dadosClinicos.trim(), linha, ultimaPosicao++);
                        continue;
                    }
                    if (campos[j].equalsIgnoreCase("guiaRequisicao")) {
                        String guiaRequisicao = c.guiaRequisicao == null ? "" : c.guiaRequisicao;
                        modeloDados.setValueAt(guiaRequisicao.trim(), linha, ultimaPosicao++);
                        continue;
                    }
                    if (campos[j].equalsIgnoreCase("codigoApoioSaoMarcos")) {
                        if (this.carregouRegistro(exaDesm)) {
                            modeloDados.setValueAt(exaDesm.getValor("codigoApoioSaoMarcos"), linha, ultimaPosicao++);
                            continue;
                        }
                        modeloDados.setValueAt(regExa.getValor("codigoApoioSaoMarcos"), linha, ultimaPosicao++);
                        continue;
                    }
                    if (campos[j].equalsIgnoreCase("codigosExames")) {
                        String codExa = regExa.getString("codigosExames");
                        modeloDados.setValueAt(codExa, linha, ultimaPosicao++);
                        continue;
                    }
                    modeloDados.setValueAt(c.getValue(campos[j]), linha, ultimaPosicao++);
                }
            }
        }
        if (modeloDados.getRowCount() > 0) {
            termica.setDados(modeloDados);
            if (Funcoes.textoVazio(StringUtil.getValor(cabecalho, "etiqueta"))) {
                String msg = "N\u00e3o h\u00e1 configura\u00e7\u00e3o de etiqueta para o Lab. S\u00e3o Marcos. Verificar as configura\u00e7\u00f5es no cadastro de Laborat\u00f3rios externos.";
                throw new Exception(msg);
            }
            retorno = termica.gerarEtiquetas(cabecalho);
            etqs.add(termica.imprimirDireto(retorno, true, st, isColetaWeb, arquivar, anular));
        }
        HashMap<String, List<byte[]>> etiquetasLab = new HashMap<String, List<byte[]>>();
        ArrayList etq = retornoEtq.getEtiquetasLabExterno() != null && !retornoEtq.getEtiquetasLabExterno().isEmpty() ? retornoEtq.getEtiquetasLabExterno().get("saomarcos") : new ArrayList();
        etqs.addAll(etq);
        etiquetasLab.put("saomarcos", etqs);
        retornoEtq.setEtiquetasLabExterno(etiquetasLab);
        retornoEtq.setTexto(retorno);
        return retornoEtq;
    }

    private int[] getMat(String mat) {
        int[] retorno = new int[mat.split(",").length];
        String[] material = mat.toString().split(",");
        for (int i = 0; i < material.length; ++i) {
            retorno[i] = Integer.parseInt(material[i]);
        }
        return retorno;
    }

    private String getModeloImpressao(String tipoImpressao) {
        if (tipoImpressao.equalsIgnoreCase(TipoImpressao.TERMICA.getCodigo())) {
            return "modeloTermico";
        }
        return "modeloGrafico";
    }

    private Registro getSolicitacoes(Registro reg, int digitosTuboFilial, int digitosTuboRequisicao) throws ParseException {
        Registro solicitacao = new Registro();
        solicitacao.setValor("codigo_lis", this.getCodigoLis(reg, digitosTuboFilial, digitosTuboRequisicao));
        solicitacao.setValor("codigo_paciente", reg.getValor("pac_codigo"));
        solicitacao.setValor("crm", reg.getValor("med_crm"));
        solicitacao.setValor("unidade_solicitante", Variaveis.descricaoFilialPadrao);
        solicitacao.setValor("data", Funcoes.formataData(reg.getDate("req_data")));
        solicitacao.setValor("dados_adicionais", "urgencia=" + this.isUrgente(reg.getBoolean("req_urgente")));
        solicitacao.setValor("convenio", this.getDadosConvenio(reg));
        solicitacao.setValor("amostra", this.getDadosExames(reg));
        return solicitacao;
    }

    private Object getCodigoLis(Registro reg, int digitosTuboFilial, int digitosTuboRequisicao) {
        String fil = Funcoes.preencheZero(reg.getString("fil_codigo"), digitosTuboFilial);
        String req = Funcoes.preencheZero(reg.getString("req_codigo"), digitosTuboRequisicao);
        return fil + req;
    }

    private Object isUrgente(boolean urgente) {
        if (urgente) {
            return "S";
        }
        return "N";
    }

    private Object getDadosExames(Registro reg) throws ParseException {
        int numItem = 1;
        Registro exame = null;
        ArrayList listaExames = (ArrayList)reg.getValor("listaexames");
        ArrayList<Registro> exames = new ArrayList<Registro>();
        for (int i = 0; i < listaExames.size(); ++i) {
            ArrayList listaExameDesm = (ArrayList)((Registro)listaExames.get(i)).getValor("listaexames");
            numItem = this.getNumItem(numItem, reg);
            if (this.contemExames(listaExameDesm)) {
                for (int j = 0; j < listaExameDesm.size(); ++j) {
                    exame = new Registro();
                    String codExame = StringUtil.getValor(((Registro)listaExameDesm.get(j)).getString("ele_xmllabexterno"), "codigo");
                    exame.setValor("material", ((Registro)listaExameDesm.get(j)).getValor("mco_abreviatura"));
                    exame.setValor("codigo", codExame);
                    exame.setValor("dados_adicionais", ((Registro)listaExameDesm.get(j)).getValor("dadosadicionais"));
                    exame.setValor("crm", reg.getValor("med_crm"));
                    exame.setValor("data_coleta", ExportacaoSaoMarcos.formataDataEHora(((Registro)listaExameDesm.get(j)).getString("exr_datamaterial")));
                    exame.setValor("data_resultado", ((Registro)listaExameDesm.get(j)).getValor("exr_dataentregaprev"));
                    exame.setValor("status", PENDENTE);
                    exame.setValor("ind_urgencia", this.isUrgente(((Registro)listaExameDesm.get(j)).getBoolean("exr_urgente")));
                    exame.setValor("ind_result_parcial", "");
                    exame.setValor("num_item", numItem);
                    exames.add(exame);
                    ++numItem;
                }
                continue;
            }
            exame = new Registro();
            String codExame = StringUtil.getValor(((Registro)listaExames.get(i)).getString("ele_xmllabexterno"), "codigo");
            exame.setValor("material", ((Registro)listaExames.get(i)).getValor("mco_abreviatura"));
            exame.setValor("codigo", codExame);
            exame.setValor("dados_adicionais", ((Registro)listaExames.get(i)).getValor("dadosadicionais"));
            exame.setValor("crm", reg.getValor("med_crm"));
            exame.setValor("data_coleta", ExportacaoSaoMarcos.formataDataEHora(((Registro)listaExames.get(i)).getString("exr_datamaterial")));
            exame.setValor("data_resultado", ((Registro)listaExames.get(i)).getValor("exr_dataentregaprev"));
            exame.setValor("status", PENDENTE);
            exame.setValor("ind_urgencia", this.isUrgente(((Registro)listaExames.get(i)).getBoolean("exr_urgente")));
            exame.setValor("ind_result_parcial", "");
            exame.setValor("num_item", numItem);
            exames.add(exame);
            ++numItem;
        }
        return exames;
    }

    private int getNumItem(int numItemAtual, Registro reg) {
        if (!Funcoes.textoVazio(reg.getString("num_item"))) {
            String retorno = StringUtil.getValor(reg.getString("num_item"), "retorno");
            List<String> exames = StringUtil.getListValores(retorno, "exame");
            for (String exa : exames) {
                int numItemLoteAnterior = Integer.parseInt(StringUtil.getValor(exa, "num_item"));
                if (!this.isSequencialAtualMenor(numItemAtual, numItemLoteAnterior)) continue;
                numItemAtual = numItemLoteAnterior + 1;
            }
        }
        return numItemAtual;
    }

    private boolean isSequencialAtualMenor(int numItemAtual, int numItemLoteAnterior) {
        return numItemAtual <= numItemLoteAnterior;
    }

    private Object getDadosConvenio(Registro reg) {
        Registro convenio = new Registro();
        convenio.setValor("codigo", reg.getValor("con_codigo"));
        convenio.setValor("nome", reg.getValor("con_razao"));
        return convenio;
    }

    private List<Registro> getDadosMedicos(List<Registro> requisicoes) {
        ArrayList<Registro> medicos = new ArrayList<Registro>();
        for (Registro reg : requisicoes) {
            Registro med = new Registro();
            med.setValor("crm", reg.getValor("med_crm"));
            med.setValor("nome", reg.getValor("med_nome"));
            if (medicos.contains(med)) continue;
            medicos.add(med);
        }
        return medicos;
    }

    private List<Registro> getDadosPaciente(List<Registro> requisicoes) throws ParseException {
        ArrayList<Registro> pacientes = new ArrayList<Registro>();
        String pacCodigoAnterior = "";
        Registro pac = null;
        for (Registro reg : requisicoes) {
            pac = new Registro();
            pac.setValor("codigo_lis", reg.getString("pac_codigo"));
            pac.setValor("datanasc", Funcoes.formataData("dd/MM/yyyy", reg.getDate("pac_datanasc")));
            pac.setValor("nome", StringUtil.trataCaracteresEspeciais(reg.getString("pac_nome")));
            pac.setValor("sexo", reg.getValor("pac_sexo"));
            if (this.isMesmoPaciente(pacCodigoAnterior, reg.getString("pac_codigo"))) continue;
            pacCodigoAnterior = reg.getString("pac_codigo");
            pacientes.add(pac);
        }
        return pacientes;
    }

    private boolean isMesmoPaciente(String pacCodigoAnterior, String pacCodigoAtual) {
        return pacCodigoAtual.equalsIgnoreCase(pacCodigoAnterior);
    }

    private boolean possuiDataNasc(String dataNasc) {
        if (Funcoes.textoVazio(dataNasc)) {
            Funcoes.mensagem(this, "Existem pacientes sem data de nascimento informada.\nO laborat\u00f3rio externo S\u00e3o Marcos exige esse item.", 1);
            return false;
        }
        return true;
    }

    @Override
    public int getMaiorCodigoLote(String numeroLote, String codigoConvenio, LaboratorioExterno labExterno, Statement st) {
        try {
            ResultSet rs = st.executeQuery("select max(lex_codigo) + 1 as codigo from loteexterno where lae_codigo = " + labExterno.codigoLab + " and fil_codigo = " + Variaveis.filialPadrao);
            if (rs.next()) {
                return rs.getInt("codigo");
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return 0;
    }

    @Override
    public byte[] imprimeRelatorio(boolean isColetaWeb, String codLabExterno, String numeroLote, List<Registro> requisicoesListaOriginal, int colunaOrdenacao, Statement st, int filialPadrao, int digitosTuboRequisicao, int digitosTuboFilial, String impressoraRelatorio) throws Exception {
        RelatorioSituacaoLote rel = new RelatorioSituacaoLote();
        ModeloGridTable modelo = rel.getModeloDados(st, new String[]{String.valueOf(numeroLote)}, new String[]{String.valueOf(codLabExterno)}, colunaOrdenacao, requisicoesListaOriginal, filialPadrao, digitosTuboRequisicao, digitosTuboFilial);
        if (modelo.getRowCount() > 0) {
            Gerador gerador = new Gerador(impressoraRelatorio);
            HashMap<String, Object> variaveis = new HashMap<String, Object>();
            variaveis.put("filtroLote", numeroLote);
            String xmlRelatorio = rel.getXMLRelatorio(st);
            if (!isColetaWeb) {
                JDialog dialogo = new JDialog((Frame)Laboratorio.getInstancia(), "Relat\u00f3rio de lote enviado");
                dialogo.setModal(true);
                dialogo.setSize(new Dimension(750, 600));
                dialogo.setLayout(new BorderLayout());
                gerador.setPai(dialogo.getContentPane());
                gerador.setPreVisualizar(true);
                gerador.setZoomPreVisualizar(0.5f);
                gerador.setAcaoFechar(dialogo::dispose);
                gerador.executar(xmlRelatorio, (TableModel)modelo, variaveis);
                ScreenUtil.centralizar(dialogo);
                dialogo.setVisible(true);
            } else {
                gerador.executar(xmlRelatorio, modelo, variaveis, false, true, isColetaWeb);
                return Impressao.gerarPdfRelatorio(gerador.getRelatorio(), xmlRelatorio);
            }
        }
        return new byte[0];
    }

    private static String formataDataEHora(String data) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm");
        SimpleDateFormat sdfAux = new SimpleDateFormat("yyyy/MM/dd HH:mm");
        String dataFormatada = "";
        if (!Funcoes.textoVazio(data) && !data.equalsIgnoreCase("null")) {
            dataFormatada = sdf.format(sdfAux.parse(data));
        }
        return dataFormatada;
    }
}

