/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.externo.exportadores.redews;

import br.com.shift.www.WSApoioSoapProxy;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.relatorios.apoio.RelatorioSituacaoLote;
import jalis.laboratorio.triagem.externo.Exportador;
import jalis.laboratorio.triagem.externo.LaboratorioExterno;
import jalis.laboratorio.triagem.externo.RetornoEstornarLote;
import jalis.laboratorio.triagem.externo.exportadores.IntegracaoLabExterno;
import jalis.laboratorio.triagem.externo.exportadores.ProcessaErroRetornoWebServiceLabExterno;
import jalis.laboratorio.triagem.externo.exportadores.UtilExportadores;
import jalis.laboratorio.triagem.externo.exportadores.VisualizaErroRetornoWebService;
import jalis.laboratorio.triagem.externo.exportadores.redews.RedeWSCampos;
import jalis.laboratorio.util.impressao.Impressao;
import jalis.laboratorio.util.impressao.ImprimirEtiquetasColetaTriagem;
import jalis.laboratorio.util.impressao.RetornoImpressaoEtiquetas;
import jalis.laboratorio.util.impressao.labexterno.ImpressorasLabExterno;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.model.dao.triagem.externo.exportadores.ExportacaoParaRedeWSDao;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.exame.ExameVO;
import jalis.model.vo.cadastro.exame.LabExternoVO;
import jalis.model.vo.cadastro.exame.MaterialColetaVO;
import jalis.model.vo.cadastro.exame.MedicamentoVO;
import jalis.model.vo.recepcao.ExameRequisicaoRecipienteVO;
import jalis.model.vo.recepcao.RequisicaoVO;
import jalis.model.vo.triagem.LoteExternoRequisicaoVO;
import jalis.model.vo.triagem.LoteExternoVO;
import jalis.relatorio.Gerador;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.impressao.termica.ImpressaoTermica;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Frame;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.swing.JDialog;
import javax.swing.table.TableModel;
import javax.xml.rpc.holders.BooleanHolder;
import javax.xml.rpc.holders.StringHolder;

public class ExportacaoParaRedeWS
extends IntegracaoLabExterno
implements Exportador {
    private final ExportacaoParaRedeWSDao dao;
    public static final String MENSAGEM_ESTORNO_LOTE = "J\u00e1 solicitou o Cancelamento do Lote/Requisi\u00e7\u00e3o no Laborat\u00f3rio Rede? O lote s\u00f3 deve ser estornado, ap\u00f3s cancelamento no Rede, pois esse processo no sistema Jalis, n\u00e3o poder\u00e1 mais ser revertido. Confirma o estorno ?";
    public static final String REQUISICAO_CANCELADA = "CANCELADA";
    boolean debug = Funcoes.arquivoExiste(System.getProperty("user.home") + System.getProperty("file.separator") + "debug.jalis");

    public ExportacaoParaRedeWS() {
        this.dao = new ExportacaoParaRedeWSDao();
    }

    @Override
    public String getTagCodigo() {
        return "idLaboratorio";
    }

    @Override
    public RetornoImpressaoEtiquetas exportarExames(String codLabExterno, String numeroLote, String configuracaoLabExterno, boolean reenvio, List<Registro> requisicoes, int colunaOrdenacao, boolean isColetaWeb, int agruparInterface, Statement st, Statement st2, Statement st3, String variaveisLogin, boolean agruparGuiasInterface, String imprimirEtiquetaTriagemSemMaterial, boolean imprimirEtiquetaColetaSemMaterial, boolean imprimirEtiquetaColetaSelecionadaSemMaterial, boolean agruparEtqPorQtde, String tipoExportacaoInterface, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario, String tipoIntegracao, String tamanhoNomeImpressora, String[] impressorasLocais, ImpressorasLabExterno impressoras, String tipoEtiquetaSoroteca, Callable<Boolean> arquivar, Callable<Boolean> anular, LaboratorioExterno labExterno, boolean agruparMultiguia) {
        RetornoImpressaoEtiquetas retorno = new RetornoImpressaoEtiquetas();
        if (!this.conexaoValida(isColetaWeb)) {
            if (isColetaWeb) {
                UtilExportadores.adicionarMensagemRetorno("N\u00e3o foi poss\u00edvel conectar ao servidor. Verifique sua internet.", Protocolo.RedeWS.getDescricao(), retorno);
            } else {
                Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel conectar ao servidor. Verifique sua internet.", 2);
            }
            try {
                ExportacaoParaRedeWS.removerLote(codLabExterno, requisicoes, numeroLote, st, isColetaWeb, arquivar, agruparInterface);
                retorno.setImprimiu(false);
                return retorno;
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel desfazer o lote solicitado.\n" + e.getMessage(), e.getStackTrace());
            }
        }
        requisicoes = ExportacaoParaRedeWS.agruparMutiguia(requisicoes, st, agruparGuiasInterface, digitosTuboFilial);
        String idLaboratorio = StringUtil.getValor(configuracaoLabExterno, "idLaboratorio");
        String senha = StringUtil.getValor(configuracaoLabExterno, "senha");
        WSApoioSoapProxy proxy = new WSApoioSoapProxy();
        ArrayList<Object> etqs = new ArrayList<Object>();
        try {
            for (Registro requisicao : requisicoes) {
                StringHolder pRetornoCliente = new StringHolder();
                StringHolder pDescricaoErro = new StringHolder();
                LoteExternoRequisicaoVO vo = this.constuirLoteExternoRequisicaoVO(requisicao, codLabExterno, numeroLote);
                String xml = this.gerarXml(requisicao, digitosTuboFilial, digitosTuboRequisicao, st);
                proxy.importaPedido(idLaboratorio, senha, xml, new BooleanHolder(), pRetornoCliente, pDescricaoErro);
                etqs.add(this.processarRetorno(pRetornoCliente, pDescricaoErro, vo, requisicao, xml, isColetaWeb, st, agruparGuiasInterface, tipoEtiquetaSoroteca, impressoras, agruparInterface, arquivar, anular, st2, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo));
            }
            retorno.setCodigoLote(Integer.valueOf(numeroLote));
            retorno.setImprimiu(true);
            HashMap<String, List<byte[]>> etiquetasLab = new HashMap<String, List<byte[]>>();
            ArrayList etq = retorno.getEtiquetasLabExterno() != null && !retorno.getEtiquetasLabExterno().isEmpty() ? retorno.getEtiquetasLabExterno().get("redews") : new ArrayList();
            etqs.addAll(etq);
            etiquetasLab.put("redews", etqs);
            retorno.setEtiquetasLabExterno(etiquetasLab);
            return retorno;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel criar o lote solicitado.\n" + e.getMessage(), e.getStackTrace());
            UtilExportadores.adicionarMensagemRetorno("N\u00e3o foi poss\u00edvel criar o lote solicitado.<br>" + e.getMessage(), Protocolo.RedeWS.getDescricao(), retorno);
            retorno.setImprimiu(false);
            return retorno;
        }
    }

    private LoteExternoRequisicaoVO constuirLoteExternoRequisicaoVO(Registro requisicao, String codLabExterno, String numeroLote) {
        LoteExternoRequisicaoVO vo = new LoteExternoRequisicaoVO();
        FilialVO filial = new FilialVO();
        filial.setCodigo(requisicao.getInt("fil_codigo"));
        LabExternoVO labExterno = new LabExternoVO();
        labExterno.setCodigo(Integer.valueOf(codLabExterno));
        RequisicaoVO reqVO = new RequisicaoVO();
        reqVO.setCodigo(requisicao.getInt("req_codigo"));
        Integer codigoMae = requisicao.getInt("req_codigomae");
        reqVO.setRequisicoesMultiguia(new Integer[]{codigoMae});
        LoteExternoVO loteExterno = new LoteExternoVO();
        loteExterno.setCodigo(Integer.valueOf(numeroLote));
        vo.setFilialVO(filial);
        vo.setLabExternoVO(labExterno);
        vo.setRequisicaoVO(reqVO);
        vo.setLoteExternoVO(loteExterno);
        return vo;
    }

    private byte[] processarRetorno(StringHolder pRetornoCliente, StringHolder pDescricaoErro, LoteExternoRequisicaoVO vo, Registro requisicao, String xmlEnviado, boolean isColetaWeb, Statement st, boolean isAgruparGuiasInterface, String tipoEtiquetaSoroteca, ImpressorasLabExterno impressoras, int agruparInterface, Callable<Boolean> arquivar, Callable<Boolean> anular, Statement st2, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo) throws Exception {
        if (!Funcoes.textoVazio(pRetornoCliente.value)) {
            if (this.debug) {
                System.out.println("RETORNO: " + pRetornoCliente.value);
            }
            if (!Funcoes.textoVazio(pDescricaoErro.value)) {
                if (!isColetaWeb) {
                    ProcessaErroRetornoWebServiceLabExterno erroRetornoWebServiceLabExterno = new ProcessaErroRetornoWebServiceLabExterno(pDescricaoErro.value, "");
                    VisualizaErroRetornoWebService.novaInstancia(Laboratorio.getInstancia(), "Erro ao enviar lotes", erroRetornoWebServiceLabExterno, true, "Rede");
                }
                List<Registro> requisicoes = Arrays.asList(requisicao);
                ExportacaoParaRedeWS.removerLote(vo.getLabExternoVO().getCodigo().toString(), requisicoes, vo.getLoteExternoVO().getCodigo().toString(), st, isColetaWeb, arquivar, agruparInterface);
                return null;
            }
            Set<String> etiquetas = StringUtil.getSetValoresTagAberta(pRetornoCliente.value, "etiqueta", true);
            vo.setRetornoWS(etiquetas.toString());
            List<String> examesRede = StringUtil.getListValoresTagAberta(pRetornoCliente.value, "exame", false);
            List<String> examesOrigem = StringUtil.getListValoresTagAberta(xmlEnviado, "exame", false);
            List<ExameRequisicaoRecipienteVO> recipientes = this.construirRecipientes(examesRede, examesOrigem, requisicao, tipoEtiquetaSoroteca);
            String ordemServicoRedeWS = StringUtil.getValor(pRetornoCliente.value, "ordemServico");
            vo.setCodigoReqApoio(ordemServicoRedeWS.replace("-", ""));
            ImprimirEtiquetasColetaTriagem.criaRecipiente(isColetaWeb, String.valueOf(vo.getFilialVO().getCodigo()), String.valueOf(vo.getRequisicaoVO().getCodigo()), tipoEtiq, true, true, st, st2, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, agruparInterface, isAgruparGuiasInterface);
            this.dao.atualizarExameRequisicaoRecipiente(recipientes, st);
            boolean agruparMultiguia = ExportacaoParaRedeWS.agruparMultiguia(vo.getFilialVO().getCodigo().toString(), vo.getRequisicaoVO().getCodigo().toString(), st, isAgruparGuiasInterface);
            this.dao.atualizarRetornoWSLoteExternoRequiscao(vo, agruparMultiguia, st);
            return this.imprimirEtiquetas(etiquetas, isColetaWeb, impressoras, agruparInterface, st, arquivar, anular);
        }
        return null;
    }

    private List<ExameRequisicaoRecipienteVO> construirRecipientes(List<String> examesRede, List<String> examesOrigem, Registro requisicao, String tipoEtiquetaSoroteca) {
        ArrayList<ExameRequisicaoRecipienteVO> recipientes = new ArrayList<ExameRequisicaoRecipienteVO>();
        FilialVO filial = new FilialVO();
        filial.setCodigo(requisicao.getInt("fil_codigo"));
        RequisicaoVO reqVO = new RequisicaoVO();
        reqVO.setCodigo(requisicao.getInt("req_codigo"));
        block0: for (String exaRede : examesRede) {
            String codExameRede = StringUtil.getValor(exaRede, "codigo");
            for (String exaOrigem : examesOrigem) {
                String codExameApoio = StringUtil.getValor(exaOrigem, "codigoApoio");
                if (!codExameRede.equalsIgnoreCase(codExameApoio)) continue;
                String codBarraRede = StringUtil.getValor(exaRede, "codigoBarra");
                String codOrigem = StringUtil.getValor(exaOrigem, "codigoLISOrigem");
                String[] exameMaterial = codOrigem.split("\\|");
                String exaCodigo = exameMaterial[0];
                String mcoCodigo = exameMaterial[1];
                ExameVO exame = new ExameVO();
                exame.setCodigo(exaCodigo);
                MaterialColetaVO material = new MaterialColetaVO();
                material.setCodigo(Integer.valueOf(mcoCodigo));
                ExameRequisicaoRecipienteVO vo = new ExameRequisicaoRecipienteVO();
                vo.setFilial(filial);
                vo.setRequisicao(reqVO);
                vo.setCodigoApoiado(codBarraRede);
                vo.setMatColeta(material);
                vo.setExame(exame);
                vo.setTipoEtiqueta(tipoEtiquetaSoroteca);
                recipientes.add(vo);
                continue block0;
            }
        }
        return recipientes;
    }

    private byte[] imprimirEtiquetas(Set<String> etiquetas, boolean isColetaWeb, ImpressorasLabExterno impressoras, int agruparInterface, Statement st, Callable<Boolean> arquivar, Callable<Boolean> anular) {
        byte[] retorno = new byte[]{};
        ImpressaoTermica termica = new ImpressaoTermica(Impressao.comparaNomeImpressoraReduzido(this.getImpressora(impressoras, agruparInterface)), isColetaWeb);
        StringBuilder etiquetasImpressao = new StringBuilder();
        for (String etiqueta : etiquetas) {
            etiqueta = etiqueta.substring(10, etiqueta.length() - 11);
            etiquetasImpressao.append(etiqueta);
        }
        if (!Funcoes.textoVazio(etiquetasImpressao.toString())) {
            retorno = termica.imprimirDireto(etiquetasImpressao.toString(), true, st, isColetaWeb, arquivar, anular);
        }
        return retorno;
    }

    public String getImpressora(ImpressorasLabExterno impressoras, int agruparInterface) {
        String impressora = impressoras.getImpressoraRedeWS();
        if (Funcoes.textoVazio(impressora)) {
            impressora = impressoras.getImpressoraEtqTriagem();
            if (agruparInterface == 0) {
                impressora = impressoras.getImpressoraEtqColeta();
            }
        }
        return impressora;
    }

    @Override
    public int getMaiorCodigoLote(String numeroLote, String codigoConvenio, LaboratorioExterno labExterno, Statement st) {
        return this.dao.getMaiorCodigoLote(labExterno.codigoLab, st);
    }

    @Override
    public byte[] imprimeRelatorio(boolean isColetaWeb, String codLabExterno, String numeroLote, List<Registro> requisicoesListaOriginal, int colunaOrdenacao, Statement st, int filialPadrao, int digitosTuboRequisicao, int digitosTuboFilial, String impressoraRelatorio) throws Exception {
        RelatorioSituacaoLote rel = new RelatorioSituacaoLote();
        ModeloGridTable modelo = rel.getModeloDados(st, new String[]{String.valueOf(numeroLote)}, new String[]{String.valueOf(codLabExterno)}, colunaOrdenacao, requisicoesListaOriginal, filialPadrao, digitosTuboRequisicao, digitosTuboFilial);
        if (modelo.getRowCount() > 0) {
            Gerador gerador = new Gerador(impressoraRelatorio);
            HashMap<String, Object> variaveis = new HashMap<String, Object>();
            variaveis.put("filtroLote", numeroLote);
            String xmlRelatorio = rel.getXMLRelatorio(st);
            if (!isColetaWeb) {
                JDialog dialogo = new JDialog((Frame)Laboratorio.getInstancia(), "Relat\u00f3rio de lote enviado");
                dialogo.setModal(true);
                dialogo.setSize(new Dimension(750, 600));
                dialogo.setLayout(new BorderLayout());
                gerador.setPai(dialogo.getContentPane());
                gerador.setPreVisualizar(true);
                gerador.setZoomPreVisualizar(0.5f);
                gerador.setAcaoFechar(dialogo::dispose);
                gerador.executar(xmlRelatorio, (TableModel)modelo, variaveis);
                ScreenUtil.centralizar(dialogo);
                dialogo.setVisible(true);
            } else {
                gerador.executar(xmlRelatorio, modelo, variaveis, false, true, isColetaWeb);
                return Impressao.gerarPdfRelatorio(gerador.getRelatorio(), xmlRelatorio);
            }
        }
        return new byte[0];
    }

    public boolean conexaoValida(boolean isColetaWeb) {
        boolean valida = false;
        try {
            WSApoioSoapProxy proxy = new WSApoioSoapProxy();
            valida = UtilExportadores.comunicacaoOk(proxy.getEndpoint(), isColetaWeb, Protocolo.RedeWS.getDescricao()).isImprimiu();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return valida;
    }

    private String gerarXml(Registro requisicao, int digitosTuboFilial, int digitosTuboRequisicao, Statement st) {
        XMLStringBuilder xml = new XMLStringBuilder();
        try {
            xml.abrir(RedeWSCampos.LISTA_PEDIDO_LAB.getTag());
            xml.abrir(RedeWSCampos.PEDIDOLAB.getTag());
            xml.abrir(RedeWSCampos.PEDIDO.getTag());
            String ordemServico = Funcoes.preencheZero(requisicao.getString("fil_codigo"), digitosTuboFilial) + Funcoes.preencheZero(requisicao.getString("req_codigo"), digitosTuboRequisicao);
            xml.escrever(RedeWSCampos.ORDEM_SERVICO.getTag(), ordemServico);
            xml.fechar(RedeWSCampos.PEDIDO.getTag());
            this.gerarDadosPacienteNoXml(xml, requisicao, st);
            this.gerarDadosExamesNoXml(xml, requisicao);
            xml.fechar(RedeWSCampos.PEDIDOLAB.getTag());
            xml.fechar(RedeWSCampos.LISTA_PEDIDO_LAB.getTag());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return xml.toString();
    }

    private void gerarDadosPacienteNoXml(XMLStringBuilder xml, Registro requisicao, Statement st) throws XMLStringBuilderException, ParseException {
        xml.abrir(RedeWSCampos.PACIENTE.getTag());
        xml.escrever(RedeWSCampos.PAC_CODIGO.getTag(), RedeWSCampos.PAC_CODIGO.getConteudoTagTamanhoMaximo(requisicao.getString("pac_codigo")));
        xml.escrever(RedeWSCampos.PAC_NOME.getTag(), RedeWSCampos.PAC_NOME.getConteudoTagTamanhoMaximo(requisicao.getString("pac_nome")));
        xml.escrever(RedeWSCampos.PAC_SEXO.getTag(), requisicao.getString("pac_sexo"));
        Date dataNascimento = requisicao.getDate("pac_datanasc");
        xml.escrever(RedeWSCampos.PAC_DATA_NASCIMENTO.getTag(), dataNascimento == null ? "" : Funcoes.formataData("yyyy-MM-dd", dataNascimento));
        xml.escrever(RedeWSCampos.PAC_ALTURA.getTag(), Funcoes.textoVazio(requisicao.getString("req_altura")) ? "" : requisicao.getString("req_altura"));
        xml.escrever(RedeWSCampos.PAC_PESO.getTag(), Funcoes.textoVazio(requisicao.getString("req_peso")) ? "" : requisicao.getString("req_peso"));
        xml.escrever(RedeWSCampos.PAC_DUM.getTag(), Funcoes.textoVazio(requisicao.getString("req_dum")) ? "" : requisicao.getString("req_dum"));
        String cartaoSUS = this.dao.pesquisarCartaoSUS(requisicao.getString("req_codigo"), requisicao.getString("fil_codigo"), st);
        xml.escrever(RedeWSCampos.PAC_CNS.getTag(), Funcoes.textoVazio(cartaoSUS) ? "" : cartaoSUS);
        List<MedicamentoVO> medicamentos = this.dao.pesquisarMedicamentosPorRequisicao(requisicao.getString("req_codigo"), requisicao.getString("fil_codigo"), st);
        if (!medicamentos.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            medicamentos.forEach(m -> sb.append(m).append(" ,"));
            xml.escrever(RedeWSCampos.PAC_MEDICAMENTO.getTag(), RedeWSCampos.PAC_MEDICAMENTO.getConteudoTagTamanhoMaximo(sb.toString().substring(0, sb.toString().length() - 2)));
        }
        xml.fechar(RedeWSCampos.PACIENTE.getTag());
    }

    private void gerarDadosExamesNoXml(XMLStringBuilder xml, Registro requisicao) throws XMLStringBuilderException {
        xml.abrir(RedeWSCampos.EXAMES.getTag());
        List exames = (List)requisicao.getValor("listaexames");
        for (Registro exame : exames) {
            List listaExamesDesmembrados = (List)exame.getValor("listaexames");
            if (null != listaExamesDesmembrados && !listaExamesDesmembrados.isEmpty()) {
                for (Registro exameDesmembrado : listaExamesDesmembrados) {
                    String configuracaoExameRede = exameDesmembrado.getString("ele_xmllabexterno");
                    String codigoExameRede = StringUtil.getValor(configuracaoExameRede, "codigo");
                    String descricaoExameRede = StringUtil.getValor(configuracaoExameRede, "descricao");
                    String codigoOrigem = exameDesmembrado.getString("exa_codigo").concat("|").concat(exameDesmembrado.getString("mco_codigo"));
                    xml.abrir(RedeWSCampos.EXAME.getTag());
                    xml.escrever(RedeWSCampos.EXA_CODIGO_APOIO.getTag(), codigoExameRede);
                    xml.escrever(RedeWSCampos.EXA_CODIGO_LIS_ORIGEM.getTag(), codigoOrigem);
                    xml.escrever(RedeWSCampos.EXA_DESCRICAO.getTag(), RedeWSCampos.EXA_DESCRICAO.getConteudoTagTamanhoMaximo(descricaoExameRede));
                    this.gerarDadosMedicoNoXml(xml, requisicao);
                    xml.escrever(RedeWSCampos.EXA_URGENTE.getTag(), requisicao.getString("exr_urgente").equalsIgnoreCase("true") ? "2" : "0");
                    xml.fechar(RedeWSCampos.EXAME.getTag());
                }
                continue;
            }
            String configuracaoExameRede = exame.getString("ele_xmllabexterno");
            String codigoExameRede = StringUtil.getValor(configuracaoExameRede, "codigo");
            String descricaoExameRede = StringUtil.getValor(configuracaoExameRede, "descricao");
            String codigoOrigem = exame.getString("exa_codigo").concat("|").concat(exame.getString("mco_codigo"));
            xml.abrir(RedeWSCampos.EXAME.getTag());
            xml.escrever(RedeWSCampos.EXA_CODIGO_APOIO.getTag(), codigoExameRede);
            xml.escrever(RedeWSCampos.EXA_CODIGO_LIS_ORIGEM.getTag(), codigoOrigem);
            xml.escrever(RedeWSCampos.EXA_DESCRICAO.getTag(), RedeWSCampos.EXA_DESCRICAO.getConteudoTagTamanhoMaximo(descricaoExameRede));
            this.gerarDadosMedicoNoXml(xml, requisicao);
            xml.escrever(RedeWSCampos.EXA_URGENTE.getTag(), requisicao.getString("exr_urgente").equalsIgnoreCase("true") ? "2" : "0");
            xml.fechar(RedeWSCampos.EXAME.getTag());
        }
        xml.fechar(RedeWSCampos.EXAMES.getTag());
    }

    private void gerarDadosMedicoNoXml(XMLStringBuilder xml, Registro requisicao) throws XMLStringBuilderException {
        xml.abrir(RedeWSCampos.MEDICOS.getTag());
        xml.abrir(RedeWSCampos.MEDICO.getTag());
        xml.escrever(RedeWSCampos.MED_NOME.getTag(), RedeWSCampos.MED_NOME.getConteudoTagTamanhoMaximo(requisicao.getString("med_nome")));
        xml.escrever(RedeWSCampos.MED_CRM.getTag(), requisicao.getString("med_crm"));
        xml.escrever(RedeWSCampos.MED_CONSELHO.getTag(), requisicao.getString("med_conselho"));
        xml.escrever(RedeWSCampos.MED_UF.getTag(), requisicao.getString("med_uf"));
        xml.fechar(RedeWSCampos.MEDICO.getTag());
        xml.fechar(RedeWSCampos.MEDICOS.getTag());
    }

    public Map<String, String> cancelarRequisicoesWebService(List<Registro> requisicoes, String configuracaoLabExterno, int digitosTuboFilial, int digitosTuboRequisicao) {
        String idLaboratorio = StringUtil.getValor(configuracaoLabExterno, "idLaboratorio");
        String senha = StringUtil.getValor(configuracaoLabExterno, "senha");
        HashMap<String, String> requisicoesCanceladas = new HashMap<String, String>();
        for (Registro req : requisicoes) {
            String codPedidoLab = Funcoes.preencheZero(req.getString("fil_codigo"), digitosTuboFilial) + Funcoes.preencheZero(req.getString("req_codigo"), digitosTuboRequisicao);
            List exames = (List)req.getValor("listaexames");
            String xmlCancelamento = this.gerarXmlCancelamento(codPedidoLab, exames);
            WSApoioSoapProxy proxy = new WSApoioSoapProxy();
            StringHolder pRetornoCliente = new StringHolder();
            StringHolder pDescricaoErro = new StringHolder();
            BooleanHolder bHolder = new BooleanHolder();
            String mensagem = "";
            try {
                proxy.cancelaExames(idLaboratorio, senha, xmlCancelamento, bHolder, pRetornoCliente, pDescricaoErro);
                mensagem = !bHolder.value ? pDescricaoErro.value : REQUISICAO_CANCELADA;
            }
            catch (Exception exception) {
                // empty catch block
            }
            requisicoesCanceladas.put(req.getString("req_codigo"), mensagem);
        }
        return requisicoesCanceladas;
    }

    private String gerarXmlCancelamento(String codPedidoLab, List<Registro> exames) {
        XMLStringBuilder xml = new XMLStringBuilder();
        try {
            xml.abrir(RedeWSCampos.REQUISICAO.getTag());
            xml.escrever(RedeWSCampos.REQ_CODIGO_OS.getTag(), "");
            xml.escrever(RedeWSCampos.REQ_PEDIDO_LAB.getTag(), codPedidoLab);
            xml.abrir(RedeWSCampos.REQ_PROCEDIMENTOS.getTag());
            for (Registro exame : exames) {
                xml.abrir(RedeWSCampos.REQ_PROCEDIMENTO.getTag());
                String codigoExameRede = StringUtil.getValor(exame.getString("ele_xmllabexterno"), "codigo");
                xml.escrever(RedeWSCampos.REQ_PROCEDIEMNTO_CODIGO.getTag(), codigoExameRede);
                xml.fechar(RedeWSCampos.REQ_PROCEDIMENTO.getTag());
            }
            xml.fechar(RedeWSCampos.REQ_PROCEDIMENTOS.getTag());
            xml.fechar(RedeWSCampos.REQUISICAO.getTag());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return xml.toString();
    }

    @Override
    public RetornoEstornarLote estornarExames(String codLabExterno, List<Registro> requisicoes, String numeroLote, boolean isColetaWeb, Statement st, Callable<Boolean> arquivar, Callable<Boolean> anular, int agruparInterface, LaboratorioExterno labSelecionado, boolean agruparMultiguia, String login, int digitosTuboFilial, int digitosTuboRequisicao) throws Exception {
        RetornoEstornarLote retorno = new RetornoEstornarLote();
        if (!this.conexaoValida(isColetaWeb)) {
            if (isColetaWeb) {
                retorno = super.estornarExames(codLabExterno, requisicoes, numeroLote, isColetaWeb, st, arquivar, anular, agruparInterface, labSelecionado, agruparMultiguia, login, digitosTuboFilial, digitosTuboRequisicao);
            } else {
                Integer resposta = Funcoes.mensagem(Laboratorio.getInstancia(), MENSAGEM_ESTORNO_LOTE, 4);
                if (resposta == 0) {
                    Funcoes.mensagem(Laboratorio.getInstancia(), "Lote estornado internamente, Entre em contato com o laborat\u00f3rio para concluir o estorno.", 5);
                    super.estornarExames(codLabExterno, requisicoes, numeroLote, isColetaWeb, st, arquivar, anular, agruparInterface, labSelecionado, agruparMultiguia, login, digitosTuboFilial, digitosTuboRequisicao);
                }
            }
        } else {
            Map<String, String> requisicoesCanceladasWebService = this.cancelarRequisicoesWebService(requisicoes, labSelecionado.configuracao, digitosTuboFilial, digitosTuboRequisicao);
            ArrayList requisicoesCanceladas = new ArrayList();
            StringBuilder mensagem = new StringBuilder("N\u00e3o foi poss\u00edvel estornar as Requisi\u00e7\u00f5es: ");
            StringBuilder motivo = new StringBuilder("Motivo: ");
            for (Map.Entry<String, String> req : requisicoesCanceladasWebService.entrySet()) {
                if (req.getValue().equals(REQUISICAO_CANCELADA)) {
                    requisicoes.forEach(r -> {
                        if (r.getString("req_codigo").equals(req.getKey())) {
                            requisicoesCanceladas.add(r);
                        }
                    });
                    continue;
                }
                mensagem.append(req.getKey()).append(", ");
                motivo.append(req.getValue()).append(", ");
            }
            if (!requisicoesCanceladas.isEmpty()) {
                retorno = super.estornarExames(codLabExterno, requisicoes, numeroLote, isColetaWeb, st, arquivar, anular, agruparInterface, labSelecionado, agruparMultiguia, login, digitosTuboFilial, digitosTuboRequisicao);
            }
            if (requisicoes.size() != requisicoesCanceladas.size()) {
                String msg = mensagem.toString().substring(0, mensagem.toString().length() - 2);
                String mtvo = motivo.toString().substring(0, motivo.toString().length() - 2);
                if (!isColetaWeb) {
                    Funcoes.mensagem(Laboratorio.getInstancia(), msg.concat("\n").concat(mtvo), 5);
                } else {
                    retorno.setMensagem(msg.concat("<br>").concat(mtvo));
                }
            }
        }
        return retorno;
    }
}

