/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.externo.exportadores.mercolab;

import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.triagem.externo.LaboratorioExterno;
import jalis.laboratorio.triagem.externo.RetornoEstornarLote;
import jalis.laboratorio.triagem.externo.exportadores.ProcessaErroRetornoWebServiceLabExterno;
import jalis.laboratorio.triagem.externo.exportadores.UtilExportadores;
import jalis.laboratorio.triagem.externo.exportadores.VisualizaErroRetornoWebService;
import jalis.laboratorio.triagem.externo.exportadores.mercolab.ExclusaoLoteMercolabWS;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.laboratorio.util.parsers.mercolabws.ExameMercolab;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;

public class MercolabService {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RetornoEstornarLote estornarExame(String codigoLote, List<Registro> requisicoes, LaboratorioExterno labExterno, boolean agruparMultiguias, Statement st, boolean isColetaWeb, Callable<Boolean> arquivar, Callable<Boolean> anular, int agruparInterface, String login, int digitosTuboFilial, int digitosTuboRequisicao) throws Exception {
        StringBuilder erros;
        String retornoWebService;
        RetornoEstornarLote retornoEstorno;
        block23: {
            retornoEstorno = new RetornoEstornarLote();
            HttpURLConnection urlConnection = null;
            retornoWebService = "";
            erros = new StringBuilder();
            try {
                if (StringUtil.getBoolean(StringUtil.getValor(labExterno.configuracao, "enviarLoteWebService"))) {
                    Registro req;
                    String enderecoWebService = StringUtil.getValor(labExterno.configuracao, "enderecoWebService");
                    if (!UtilExportadores.comunicacaoOk(enderecoWebService, false, Protocolo.MercolabWS.getDescricao()).isImprimiu()) break block23;
                    String idLaboratorio = StringUtil.getValor(labExterno.configuracao, "idLaboratorio");
                    String senha = StringUtil.getValor(labExterno.configuracao, "senha");
                    ExclusaoLoteMercolabWS xmlExclusao = new ExclusaoLoteMercolabWS(idLaboratorio, "Jalis", login, senha);
                    ArrayList<Registro> listaExamesExclusao = new ArrayList<Registro>();
                    String idMercolab = "";
                    for (int i = 0; i < requisicoes.size() && !Funcoes.textoVazio(idMercolab = this.obterCodigoMercolabRetornadoNovo(req = requisicoes.get(i), labExterno.codigoLab, codigoLote, st, digitosTuboFilial, digitosTuboRequisicao)); ++i) {
                        ArrayList exames = (ArrayList)req.getValor("listaexames");
                        req.setValor("idMercolab", idMercolab);
                        for (Registro exame : exames) {
                            exame.setValor("idMercolab", idMercolab);
                            List desm = (List)exame.getValor("listaexames");
                            if (desm != null && !desm.isEmpty()) {
                                for (Registro exaDesm : desm) {
                                    exaDesm.setValor("idMercolab", idMercolab);
                                    ExameMercolab exMercolab = ExameMercolab.novaInstancia(exaDesm.getString("ele_xmllabexterno"));
                                    exMercolab.setExameJalis(exaDesm.getString("exa_codigo"));
                                    exaDesm.setValor("exameMercolab", exMercolab.getCodigoExame());
                                }
                            } else {
                                ExameMercolab exMercolab = ExameMercolab.novaInstancia(exame.getString("ele_xmllabexterno"));
                                exMercolab.setExameJalis(exame.getString("exa_codigo"));
                                exame.setValor("exameMercolab", exMercolab.getCodigoExame());
                            }
                            listaExamesExclusao.add(exame.clone());
                        }
                        if (listaExamesExclusao.isEmpty()) continue;
                        requisicoes.get(i).substituirValor("listaexames", listaExamesExclusao);
                    }
                    for (Registro exameExclusao : listaExamesExclusao) {
                        List desm = (List)exameExclusao.getValor("listaexames");
                        if (desm != null && !desm.isEmpty()) {
                            for (Registro exaDesm : desm) {
                                if (Funcoes.textoVazio(retornoWebService = this.estornaExame(retornoWebService, erros, enderecoWebService, xmlExclusao, exaDesm))) continue;
                                retornoEstorno = this.processaRetornoWebServiceExclusao(st, retornoWebService, erros, requisicoes, codigoLote, labExterno, exameExclusao, isColetaWeb, arquivar, anular, agruparInterface, agruparMultiguias, login, digitosTuboFilial, digitosTuboRequisicao);
                            }
                            continue;
                        }
                        if (this.validaExamesDesmembrados(exameExclusao.getString("fil_codigo"), exameExclusao.getString("exa_codigo"), exameExclusao.getString("req_codigo"), labExterno.codigoLab, st)) {
                            retornoWebService = this.estornaExame(retornoWebService, erros, enderecoWebService, xmlExclusao, exameExclusao);
                        }
                        if (!Funcoes.textoVazio(retornoWebService)) {
                            retornoEstorno = this.processaRetornoWebServiceExclusao(st, retornoWebService, erros, requisicoes, codigoLote, labExterno, exameExclusao, isColetaWeb, arquivar, anular, agruparInterface, agruparMultiguias, login, digitosTuboFilial, digitosTuboRequisicao);
                            continue;
                        }
                        retornoEstorno.setSucesso(false);
                        RetornoEstornarLote retornoEstornarLote = retornoEstorno;
                        return retornoEstornarLote;
                    }
                    break block23;
                }
                retornoEstorno.setSucesso(true);
            }
            finally {
                if (urlConnection != null) {
                    urlConnection.disconnect();
                }
            }
        }
        if (!Funcoes.textoVazio(erros.toString())) {
            anular.call();
            String msg = "N\u00e3o foi poss\u00edvel remover os exame/solicita\u00e7\u00f5es do lote, pois o Mercolab retornou a seguinte mensagem: \n " + erros.toString();
            erros = new StringBuilder();
            erros.append(msg);
            retornoEstorno.setSucesso(false);
            if (isColetaWeb) {
                retornoEstorno.setMensagem(erros.toString());
            } else {
                ProcessaErroRetornoWebServiceLabExterno erroRetornoWebServiceLabExterno = new ProcessaErroRetornoWebServiceLabExterno(erros.toString(), retornoWebService);
                VisualizaErroRetornoWebService.novaInstancia(Laboratorio.getInstancia(), "Exames que n\u00e3o foram exclu\u00eddos: ", erroRetornoWebServiceLabExterno, false, "Mercolab");
            }
        } else if (retornoEstorno.isSucesso()) {
            String texto = "Solicita\u00e7\u00e3o de exclus\u00e3o atendida com sucesso pelo Apoio.";
            if (isColetaWeb) {
                retornoEstorno.setMensagem(texto);
            } else {
                Funcoes.mensagem(Laboratorio.getInstancia(), texto, 2);
            }
        }
        return retornoEstorno;
    }

    private boolean validaExamesDesmembrados(String codigoFilial, String codigoExame, String codigoRequisicao, String codigoLabExterno, Statement st) {
        boolean retorno = false;
        StringBuilder sql = new StringBuilder();
        sql.append("select * from loteexternoexamerequisicaodesm l where fil_codigo = ").append(codigoFilial);
        sql.append(" and lae_codigo = ").append(codigoLabExterno);
        sql.append(" and req_codigo = ").append(codigoRequisicao);
        sql.append(" and exa_kodigo = '").append(codigoExame).append("'");
        try {
            ResultSet rs = st.executeQuery(sql.toString());
            if (rs.next()) {
                String mensagem = "Exame " + codigoExame + " faz parte de um agrupamento. Para estorna-lo, estorne o exame pai: " + rs.getString("exa_codigo");
                Funcoes.mensagem(Laboratorio.getInstancia(), mensagem, 2);
                return false;
            }
            return true;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return retorno;
        }
    }

    private String estornaExame(String retornoWebService, StringBuilder erros, String enderecoWebService, ExclusaoLoteMercolabWS xmlExclusao, Registro exaDesm) throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException, IOException {
        String xml = xmlExclusao.xmlExclusao(exaDesm.getString("exa_codigo"), exaDesm.getString("idMercolab"));
        if (!xml.isEmpty()) {
            HttpUriRequest request;
            CloseableHttpClient client = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)this.construirSSL()).build();
            CloseableHttpResponse response = client.execute(request = RequestBuilder.post((String)enderecoWebService).addHeader("Content-Type", "application/soap+xml").setCharset(StandardCharsets.UTF_8).setEntity((HttpEntity)new StringEntity(xml, "UTF-8")).build());
            if (this.statusOK(response)) {
                HttpEntity entity = response.getEntity();
                retornoWebService = EntityUtils.toString((HttpEntity)entity);
            }
            if (!Funcoes.textoVazio(StringUtil.getValor(retornoWebService = StringUtil.xmlToTexto(retornoWebService), "RegistroRejeitado"))) {
                erros.append(StringUtil.getValor(retornoWebService, "RegistroRejeitado"));
            }
        }
        return retornoWebService;
    }

    private SSLConnectionSocketFactory construirSSL() throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        SSLContextBuilder builder = new SSLContextBuilder();
        builder.loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy());
        return new SSLConnectionSocketFactory(builder.build());
    }

    private boolean statusOK(CloseableHttpResponse response) {
        return null != response && response.getStatusLine().getStatusCode() == 200;
    }

    public String obterCodigoMercolabRetornadoNovo(Registro registro, String codLabExterno, String numeroLote, Statement st, int digitosTuboFilial, int digitosTuboRequisicao) {
        String retorno = "";
        try {
            String leqRetornoWs = UtilExportadores.retornoWs(registro, codLabExterno, Funcoes.textoVazio(numeroLote) ? null : numeroLote, st);
            if (Funcoes.textoVazio(leqRetornoWs)) {
                leqRetornoWs = UtilExportadores.retornoWs(registro, codLabExterno, null, st);
            }
            if (!Funcoes.textoVazio(leqRetornoWs)) {
                if (this.retornoValido(leqRetornoWs, "solicitacoes")) {
                    leqRetornoWs = "<solicitacoes>" + leqRetornoWs + "</solicitacoes>";
                }
                if (this.retornoValido(leqRetornoWs, "Pedido")) {
                    Funcoes.mensagem(Laboratorio.getInstancia(), "C\u00f3digo apoiado n\u00e3o localizado", 2);
                    return "";
                }
                List<String> pedidos = StringUtil.getListValoresTagAberta(leqRetornoWs, "Pedido", false);
                Collections.reverse(pedidos);
                retorno = this.getCodigoMercolab(registro, retorno, pedidos, digitosTuboFilial, digitosTuboRequisicao);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
        }
        return retorno;
    }

    private boolean retornoValido(String retorno, String tag) {
        return retorno != null && !retorno.contains("<" + tag + ">") && !retorno.contains("</" + tag + ">");
    }

    private String getCodigoMercolab(Registro registro, String retorno, List<String> pedidos, int digitosTuboFilial, int digitosTuboRequisicao) throws Exception {
        for (String pedido : pedidos) {
            String idMercolab = StringUtil.getValor(pedido, "CodPedLab");
            String idLis = StringUtil.getValor(pedido, "CodPedLab");
            if (Funcoes.textoVazio(idLis)) {
                String identificacao;
                List<String> amostras = StringUtil.getListValoresTagAberta(pedido, "Recipiente", false);
                idLis = identificacao = StringUtil.getValor(amostras.get(0), "identificacao");
            }
            if (idLis.length() != digitosTuboRequisicao + digitosTuboFilial) {
                Funcoes.mensagem(Laboratorio.getInstancia(), "Padr\u00e3o de etiqueta n\u00e3o identificado.", 2);
                return "";
            }
            String filial = StringUtil.removeZerosEsquerda(idLis.substring(0, digitosTuboFilial));
            String requisicao = StringUtil.removeZerosEsquerda(idLis.substring(digitosTuboFilial, digitosTuboRequisicao + digitosTuboFilial));
            if (!requisicao.equalsIgnoreCase(registro.getString("req_codigomae")) && !requisicao.equalsIgnoreCase(registro.getString("req_codigo")) || !filial.equalsIgnoreCase(registro.getString("fil_codigo"))) continue;
            retorno = idMercolab;
            break;
        }
        return retorno;
    }

    private RetornoEstornarLote processaRetornoWebServiceExclusao(Statement st, String retornoWebService, StringBuilder erros, List<Registro> requisicoes, String codigoLote, LaboratorioExterno labExterno, Registro exameExclusao, boolean isColetaWeb, Callable<Boolean> arquivar, Callable<Boolean> anular, int agruparInterface, boolean agruparMultiguias, String login, int digitosTuboFilial, int digitosTuboRequisicao) throws Exception {
        RetornoEstornarLote retorno = new RetornoEstornarLote();
        String cancelaExameResult = StringUtil.getValor(retornoWebService, "cancelaExameResult");
        if (cancelaExameResult.equals("1")) {
            ArrayList<Registro> listaRequisicoes = new ArrayList<Registro>();
            for (Registro req : requisicoes) {
                ArrayList exames = (ArrayList)req.getValor("listaexames");
                ArrayList<Registro> listaExames = new ArrayList<Registro>();
                this.processarExclusaoExames(exameExclusao, exames, listaExames);
                if (!listaExames.isEmpty()) {
                    req.setValor("listaexames", listaExames.clone());
                }
                listaExames.clear();
                listaRequisicoes.add(req.clone());
            }
            retorno.setSucesso(true);
            return retorno;
        }
        String texto = "N\u00e3o foi poss\u00edvel realizar o estorno. Entre em contato e verifique com o laborat\u00f3rio de apoio.";
        if (isColetaWeb) {
            retorno.setMensagem(texto);
        } else {
            Funcoes.mensagem(Laboratorio.getInstancia(), texto, 1);
        }
        anular.call();
        retorno.setSucesso(false);
        return retorno;
    }

    private void processarExclusaoExames(Registro exameExclusao, ArrayList<Registro> exames, ArrayList<Registro> listaExames) {
        for (Registro exa : exames) {
            ArrayList examesDesm = (ArrayList)exa.getValor("listaexames");
            if (examesDesm != null && !examesDesm.isEmpty()) {
                ArrayList<Registro> listaExamesDesm = new ArrayList<Registro>();
                this.getExamesDesmExcluidos(exameExclusao, exa, examesDesm, listaExamesDesm);
                if (!listaExamesDesm.isEmpty()) {
                    exa.setValor("listaexames", listaExamesDesm.clone());
                }
                listaExames.add(exa.clone());
                continue;
            }
            if (!exa.getString("codigoExame").equalsIgnoreCase(exameExclusao.getString("codigoExame"))) continue;
            listaExames.add(exa.clone());
        }
    }

    private void getExamesDesmExcluidos(Registro exameExclusao, Registro exa, ArrayList<Registro> examesDesm, ArrayList<Registro> listaExamesDesm) {
        for (Registro regDesm : examesDesm) {
            if (!regDesm.getString("CodExmApoio").equalsIgnoreCase((String)exameExclusao.getValor("codigoExame"))) continue;
            listaExamesDesm.add(exa.clone());
        }
    }
}

