/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.externo.exportadores.mercolab;

import jalis.util.Funcoes;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ExclusaoLoteMercolabWS {
    private String idMercolab = "";
    private String lis = "";
    private String operador = "";
    private String senha = "";
    private Map<String, Set<String>> exames = new HashMap<String, Set<String>>();

    public ExclusaoLoteMercolabWS(String idMercolab, String lis, String operador, String senha) {
        this.idMercolab = idMercolab;
        this.lis = lis;
        this.operador = operador;
        this.senha = senha;
    }

    public void addExame(String idAlvaro, String codigoExame) {
        if (this.exames.containsKey(idAlvaro)) {
            this.exames.get(idAlvaro).add(codigoExame);
        } else {
            HashSet<String> exame = new HashSet<String>();
            exame.add(codigoExame);
            this.exames.put(idAlvaro, exame);
        }
    }

    public Map<String, Set<String>> getExames() {
        return this.exames;
    }

    public String xmlExclusao(String exame, String codPedApoio) {
        StringBuilder xml = new StringBuilder();
        xml.append("<soap:Envelope xmlns:soap=\"http://www.w3.org/2003/05/soap-envelope\" xmlns:asc=\"https://ascherer.com.br/\">");
        xml.append("<soap:Header/>");
        xml.append("<soap:Body>");
        xml.append("<asc:cancelaExame>");
        xml.append("<asc:login>").append(this.idMercolab).append("</asc:login>");
        xml.append("<asc:passwd>").append(this.senha).append("</asc:passwd>");
        xml.append("<asc:codPedApoio>").append(codPedApoio).append("</asc:codPedApoio>");
        xml.append("<asc:codExmApoio>").append(exame).append("</asc:codExmApoio>");
        xml.append("</asc:cancelaExame>");
        xml.append("</soap:Body>");
        xml.append("</soap:Envelope>");
        return xml.toString();
    }

    private String geraDataHora() {
        Date dataAtual = Calendar.getInstance().getTime();
        String data = Funcoes.formataData("yyyy-MM-dd", dataAtual);
        String hora = Funcoes.formataData("HH:mm:ss", dataAtual);
        return data + "T" + hora;
    }
}

