/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.externo.exportadores.matrix;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.relatorios.apoio.RelatorioSituacaoLote;
import jalis.laboratorio.triagem.externo.Exportador;
import jalis.laboratorio.triagem.externo.LaboratorioExterno;
import jalis.laboratorio.triagem.externo.exportadores.IntegracaoLabExterno;
import jalis.laboratorio.util.impressao.Impressao;
import jalis.laboratorio.util.impressao.RetornoImpressaoEtiquetas;
import jalis.laboratorio.util.impressao.labexterno.ImpressorasLabExterno;
import jalis.laboratorio.util.parsers.matrix.ExameMatrix;
import jalis.laboratorio.util.parsers.matrix.ParserImportacaoMatrix;
import jalis.relatorio.Gerador;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.table.TableModel;

public class ExportacaoParaMatrix
extends IntegracaoLabExterno
implements Exportador {
    private static final String REGISTRO_AMOSTRA = "10";
    private static final String REGISTRO_PACIENTE = "11";
    private static final String REGISTRO_ATRIBUTO = "12";
    private static final String REGISTRO_DADOS_EXTENDIDOS = "13";
    private String protocolo;

    @Override
    public String getTagCodigo() {
        return null;
    }

    @Override
    public RetornoImpressaoEtiquetas exportarExames(String codLabExterno, String numeroLote, String configuracaoLabExterno, boolean reenvio, List<Registro> requisicoes, int colunaOrdenacao, boolean isColetaWeb, int agruparInterface, Statement st, Statement st2, Statement st3, String variaveisLogin, boolean agruparGuiasInterface, String imprimirEtiquetaTriagemSemMaterial, boolean imprimirEtiquetaColetaSemMaterial, boolean imprimirEtiquetaColetaSelecionadaSemMaterial, boolean agruparEtqPorQtde, String tipoExportacaoInterface, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario, String tipoIntegracao, String tamanhoNomeImpressora, String[] impressorasLocais, ImpressorasLabExterno impressoras, String tipoEtiquetaSoroteca, Callable<Boolean> arquivar, Callable<Boolean> anular, LaboratorioExterno labExterno, boolean agruparMultiguia) {
        RetornoImpressaoEtiquetas retorno = new RetornoImpressaoEtiquetas();
        String arquivo = "";
        String nomeArquivo = Funcoes.preencheVazio(numeroLote, "0", 8, 1) + ".RCB";
        try {
            arquivo = this.montaArquivo(numeroLote, requisicoes, st);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, "N\u00e3o foi poss\u00edvel gerar lote para lab. de apoio - " + e.getMessage(), e.getStackTrace());
        }
        if (isColetaWeb) {
            retorno.setXmlLote(arquivo);
            retorno.setNomeArquivoLote(nomeArquivo);
            retorno.setExtensaoArquivo("rcb");
            retorno.setImprimiu(true);
            return retorno;
        }
        JFileChooser chooser = ComponenteFactory.novoJFileChooser();
        chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
        chooser.setSelectedFile(new File(nomeArquivo));
        chooser.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo de exporta\u00e7\u00e3o " + this.protocolo + "(*.rcb)", "RCB"));
        if (chooser.showSaveDialog(null) == 0) {
            try {
                StringUtil.escreverArquivoTexto(chooser.getSelectedFile().getPath(), arquivo);
                retorno.setImprimiu(true);
                return retorno;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        retorno.setImprimiu(false);
        return retorno;
    }

    private String montaArquivo(String numeroLote, List<Registro> requisicoes, Statement st) throws ParseException {
        StringBuilder buf = new StringBuilder();
        for (Registro r : requisicoes) {
            buf.append(this.geraPaciente(r));
            List exames = (List)r.getValor("listaexames");
            for (Registro exame : exames) {
                buf.append(this.geraAmostra(exame, r, st, numeroLote));
            }
        }
        return buf.toString();
    }

    @Override
    public byte[] imprimeRelatorio(boolean isColetaWeb, String codLabExterno, String numeroLote, List<Registro> requisicoesListaOriginal, int colunaOrdenacao, Statement st, int filialPadrao, int digitosTuboRequisicao, int digitosTuboFilial, String impressoraRelatorio) throws Exception {
        RelatorioSituacaoLote rel = new RelatorioSituacaoLote();
        ModeloGridTable modelo = rel.getModeloDados(st, new String[]{String.valueOf(numeroLote)}, new String[]{String.valueOf(codLabExterno)}, colunaOrdenacao, requisicoesListaOriginal, filialPadrao, digitosTuboRequisicao, digitosTuboFilial);
        if (modelo.getRowCount() > 0) {
            Gerador gerador = new Gerador(impressoraRelatorio);
            HashMap<String, Object> variaveis = new HashMap<String, Object>();
            variaveis.put("filtroLote", numeroLote);
            String xmlRelatorio = rel.getXMLRelatorio(st);
            if (!isColetaWeb) {
                JDialog dialogo = new JDialog((Frame)Laboratorio.getInstancia(), "Relat\u00f3rio de lote enviado");
                dialogo.setModal(true);
                dialogo.setSize(new Dimension(750, 600));
                dialogo.setLayout(new BorderLayout());
                gerador.setPai(dialogo.getContentPane());
                gerador.setPreVisualizar(true);
                gerador.setZoomPreVisualizar(0.5f);
                gerador.setAcaoFechar(dialogo::dispose);
                gerador.executar(xmlRelatorio, (TableModel)modelo, variaveis);
                ScreenUtil.centralizar(dialogo);
                dialogo.setVisible(true);
            } else {
                gerador.executar(xmlRelatorio, modelo, variaveis, false, true, isColetaWeb);
                return Impressao.gerarPdfRelatorio(gerador.getRelatorio(), xmlRelatorio);
            }
        }
        return new byte[0];
    }

    @Override
    public int getMaiorCodigoLote(String numeroLote, String codigoConvenio, LaboratorioExterno configuracaoLabExterno, Statement st) {
        try {
            ResultSet rs = st.executeQuery("select max(lex_codigo) + 1 as codigo from loteexterno where lae_codigo = " + configuracaoLabExterno.codigoLab + " and fil_codigo = " + Variaveis.filialPadrao);
            if (rs.next()) {
                return rs.getInt("codigo");
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return 0;
    }

    public void setProtocolo(String protocolo) {
        this.protocolo = protocolo;
    }

    private String geraAmostra(Registro rs, Registro requisicao, Statement st, String numeroLote) throws ParseException {
        StringBuilder buf = new StringBuilder();
        ExameMatrix exame = new ExameMatrix(rs.getString("ele_xmllabexterno"));
        buf.append(REGISTRO_AMOSTRA);
        buf.append(this.amostra(requisicao, rs, st));
        buf.append(StringUtil.repeteCaractere(' ', 6));
        buf.append(" ");
        buf.append(StringUtil.repeteCaractere(' ', 7));
        buf.append("LOTE").append(Funcoes.preencheZero(numeroLote, 8));
        buf.append(' ');
        buf.append(Funcoes.formataData("HH:mm", rs.getDate("exr_datamaterial")).replace(":", ""));
        buf.append((char)(rs.getValor("exr_urgente") != null && !rs.getBoolean("exr_urgente") ? 82 : 85));
        buf.append(Funcoes.preencheVazio(exame.getMaterial(), 8, 2));
        buf.append(StringUtil.repeteCaractere(' ', 6));
        buf.append(Funcoes.preencheZero(requisicao.getString("pac_codigo"), 12));
        buf.append(Funcoes.preencheVazio(requisicao.getString("col_codigo"), 8, 2));
        buf.append(Funcoes.formataData("yyyy/MM/dd", rs.getDate("exr_datamaterial")).replace("/", ""));
        buf.append(Funcoes.preencheVazio(exame.getCodigoExame().toString(), 8, 2));
        buf.append(StringUtil.repeteCaractere(' ', 8));
        buf.append(StringUtil.repeteCaractere(' ', 8));
        buf.append(StringUtil.repeteCaractere(' ', 8));
        buf.append(StringUtil.repeteCaractere(' ', 8));
        buf.append(StringUtil.repeteCaractere(' ', 8));
        buf.append(StringUtil.repeteCaractere(' ', 8));
        buf.append(StringUtil.repeteCaractere(' ', 8));
        buf.append(StringUtil.repeteCaractere(' ', 8));
        buf.append(StringUtil.repeteCaractere(' ', 8));
        buf.append(StringUtil.repeteCaractere(' ', 8));
        buf.append(StringUtil.repeteCaractere(' ', 8));
        buf.append(StringUtil.repeteCaractere(' ', 8));
        buf.append(StringUtil.repeteCaractere(' ', 8));
        buf.append(StringUtil.repeteCaractere(' ', 8));
        buf.append(StringUtil.repeteCaractere(' ', 8));
        buf.append(StringUtil.repeteCaractere(' ', 8));
        buf.append(StringUtil.repeteCaractere(' ', 8));
        buf.append(StringUtil.repeteCaractere(' ', 8));
        buf.append(StringUtil.repeteCaractere(' ', 8));
        buf.append(ParserImportacaoMatrix.calculcaDv(buf.toString())).append("\n");
        return buf.toString();
    }

    private String campoReservado(int tam) {
        return StringUtil.repeteCaractere(' ', tam);
    }

    private String amostra(Registro requisicao, Registro exame, Statement st) {
        int codRecipiente = 0;
        try {
            StringBuilder sql = new StringBuilder();
            sql.append("select c.col_codigo, a.exa_codigo, a.mco_codigo, a.rec_codigo from examerequisicaorecipiente a ");
            sql.append("join recipcoleta b on a.fil_codigo = b.fil_codigo and a.rec_codigo = b.rec_codigo and a.exa_codigo = b.exa_codigo and a.mco_codigo = b.mco_codigo ");
            sql.append("left join requisicao c on a.fil_codigo = c.fil_codigo and a.req_codigo = c.req_codigo ");
            sql.append(" where a.fil_codigo =").append(requisicao.getInt("fil_codigo"));
            sql.append(" and a.exa_codigo ='").append(exame.getString("exa_codigo")).append("'");
            sql.append(" and a.mco_codigo =").append(exame.getString("mco_codigo"));
            sql.append(" and a.req_codigo =").append(requisicao.getInt("req_codigo"));
            sql.append(" and a.ere_tipo ='").append("C").append("'");
            ResultSet rs = Conexao.executeQuery(st, sql.toString());
            if (rs.next()) {
                codRecipiente = rs.getInt("rec_codigo");
                requisicao.setValor("col_codigo", rs.getString("col_codigo"));
            }
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ExportacaoParaMatrix");
        }
        return Funcoes.preencheZero(requisicao.getInt("fil_codigo"), ParametrosGerais.getDigitosTuboFilial()) + Funcoes.preencheZero(requisicao.getInt("req_codigo"), ParametrosGerais.getDigitosTuboRequisicao()) + Funcoes.preencheZero(codRecipiente, ParametrosGerais.getDigitosTuboTubo());
    }

    private String geraPaciente(Registro rs) throws ParseException {
        StringBuilder buf = new StringBuilder();
        buf.append(REGISTRO_PACIENTE);
        buf.append(Funcoes.preencheZero(rs.getString("pac_codigo"), 12));
        buf.append(Funcoes.preencheVazio(this.nomePaciente(rs.getString("pac_nome")), 50, 2));
        buf.append(StringUtil.repeteCaractere(' ', 7));
        buf.append(rs.getValor("pac_datanasc") != null ? Funcoes.formataData("yyyy/MM/dd", rs.getDate("pac_datanasc")).replace("/", "") : StringUtil.repeteCaractere(' ', 8));
        buf.append(rs.getString("pac_sexo"));
        buf.append(' ');
        buf.append(StringUtil.repeteCaractere(' ', 167));
        buf.append(ParserImportacaoMatrix.calculcaDv(buf.toString())).append("\n");
        return buf.toString();
    }

    private String nomePaciente(String nome) {
        int i = (nome = StringUtil.removerAcentos(nome).toUpperCase()).trim().lastIndexOf(" ");
        if (i > -1) {
            String sobreNome = nome.substring(i).trim();
            return sobreNome.concat(", ").concat(nome.substring(0, i));
        }
        return nome;
    }
}

