/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.externo.exportadores.maricondi;

import jalis.laboratorio.triagem.externo.exportadores.maricondi.LoteMaricondiWSDTO;
import jalis.laboratorio.triagem.externo.exportadores.maricondi.PedidoMaricondiWSDTO;
import jalis.laboratorio.triagem.externo.exportadores.maricondi.RecipienteMaricondiWSDTO;
import jalis.laboratorio.triagem.externo.exportadores.maricondi.TAGLoteRetornoMaricondiWS;
import jalis.util.StringUtil;
import java.util.ArrayList;
import java.util.List;

public class ProcessaRetornoMaricondiWSUtil {
    private ProcessaRetornoMaricondiWSUtil() {
    }

    public static LoteMaricondiWSDTO processaRetorno(String retorno) {
        LoteMaricondiWSDTO dto = new LoteMaricondiWSDTO();
        String lote = StringUtil.getValor(retorno, TAGLoteRetornoMaricondiWS.TAG_LOTE.toString());
        dto.setCodigoLab(StringUtil.getValor(lote, TAGLoteRetornoMaricondiWS.TAG_CODLAB.toString()));
        dto.setCodigoLoteLab(StringUtil.getValor(lote, TAGLoteRetornoMaricondiWS.TAG_CODIGOLOTEAPOIO.toString()));
        dto.setDataLote(StringUtil.getValor(lote, TAGLoteRetornoMaricondiWS.TAG_DATALOTEAPOIO.toString()));
        dto.setHoraLote(StringUtil.getValor(lote, TAGLoteRetornoMaricondiWS.TAG_HORALOTEAPOIO.toString()));
        dto.setPedidos(ProcessaRetornoMaricondiWSUtil.getPedidos(lote));
        return dto;
    }

    private static List<PedidoMaricondiWSDTO> getPedidos(String lote) {
        String[] pedidos;
        ArrayList<PedidoMaricondiWSDTO> pedidosDTO = new ArrayList<PedidoMaricondiWSDTO>();
        for (String pedido : pedidos = StringUtil.getValores(lote, TAGLoteRetornoMaricondiWS.TAG_PEDIDO.toString())) {
            PedidoMaricondiWSDTO dto = new PedidoMaricondiWSDTO();
            dto.setCodigoPedidoApoio(StringUtil.getValor(pedido, TAGLoteRetornoMaricondiWS.TAG_CODIGOPEDIDOAPOIO.toString()));
            dto.setRecipientes(ProcessaRetornoMaricondiWSUtil.getRecipientes(pedido));
            pedidosDTO.add(dto);
        }
        return pedidosDTO;
    }

    private static List<RecipienteMaricondiWSDTO> getRecipientes(String pedido) {
        String[] recipientes;
        ArrayList<RecipienteMaricondiWSDTO> dtos = new ArrayList<RecipienteMaricondiWSDTO>();
        for (String recipiente : recipientes = StringUtil.getValores(pedido, TAGLoteRetornoMaricondiWS.TAG_RECIPIENTE.toString())) {
            RecipienteMaricondiWSDTO dto = new RecipienteMaricondiWSDTO();
            dto.setCodigoBarrasApoio(StringUtil.getValor(recipiente, TAGLoteRetornoMaricondiWS.TAG_CODBARAPOIO.toString()));
            dto.setEtiqueta(StringUtil.getValor(recipiente, TAGLoteRetornoMaricondiWS.TAG_ETQCODBAR.toString()));
            dto.setCodigoExameApoio(StringUtil.getValor(recipiente, TAGLoteRetornoMaricondiWS.TAG_CODEXMAPOIO.toString()));
            dtos.add(dto);
        }
        return dtos;
    }
}

