/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.externo.exportadores.maricondi;

import jalis.laboratorio.triagem.externo.exportadores.maricondi.ExameMaterialMaricondi;
import jalis.laboratorio.triagem.externo.exportadores.maricondi.ExportacaoParaMaricondiDao;
import jalis.laboratorio.triagem.externo.exportadores.maricondi.TAGXmlLoteMaricondiWS;
import jalis.laboratorio.util.parsers.maricondi.ExameMaricondi;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.tabela.Registro;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GeradorXmlExportacaoMaricondi {
    private static final String FORMATO_HORA = "HH:mm:ss";
    private static final String FORMATO_DATA = "yyyy-MM-dd";
    public static final String EXR_DATAMATERIAL = "exr_datamaterial";
    public static final String FIL_CODIGO = "fil_codigo";
    public static final String REQ_HORA = "req_hora";
    public static final String REQ_DATA = "req_data";
    public static final String REQ_IDADE = "req_idade";
    public static final String REQ_CODIGO = "req_codigo";
    public static final String PAC_CODIGO = "pac_codigo";
    public static final String PAC_DATANASC = "pac_datanasc";
    public static final String PAC_SEXO = "pac_sexo";
    public static final String PAC_NOME = "pac_nome";
    public static final String MCO_CODIGO = "mco_codigo";
    public static final String EXA_CODIGO = "exa_codigo";
    public static final String CODIGO_EXAME = "codigoExame";
    public static final String CODIGO_MATERIAL = "codigoMaterial";
    public static final String TAG_UTILIZAR_MAT_REQUISICAO = "utilizar-mat-requisicao";
    public static final String TAG_MATERIAL_SELECIONADO = "material-selecionado";
    public static final String TAG_CONSERVANTE_SELECIONADO = "conservante-selecionado";
    public static final String ELE_XMLLABEXTERNO = "ele_xmllabexterno";
    private boolean enviarUsandoWS;
    private XMLStringBuilder xml;

    public GeradorXmlExportacaoMaricondi(boolean enviarUsandoWS, XMLStringBuilder xml) {
        this.enviarUsandoWS = enviarUsandoWS;
        this.xml = xml;
    }

    public void gerarXML(String numeroLote, String codigoConvenio, List<Registro> requisicoes, Statement st, int digitosTuboFilial, int digitosTuboRequisicao) throws XMLStringBuilderException, ParseException {
        if (this.enviarUsandoWS) {
            this.xml.escreveHeader("1.0", "ISO-8859-1");
        } else {
            this.xml.escreveHeader("1.0", "UTF-8");
        }
        this.xml.abrir(TAGXmlLoteMaricondiWS.TAG_REGISTRO.toString());
        this.xml.escrever(TAGXmlLoteMaricondiWS.TAG_PROTOCOLO.toString(), "2");
        this.xml.escrever(TAGXmlLoteMaricondiWS.TAG_ID.toString(), numeroLote);
        this.xml.abrir(TAGXmlLoteMaricondiWS.TAG_LOTE.toString());
        this.xml.escrever(TAGXmlLoteMaricondiWS.TAG_COD_LAB.toString(), codigoConvenio);
        this.xml.escrever(TAGXmlLoteMaricondiWS.TAG_COD_LOTE_LAB.toString(), numeroLote);
        this.xml.escrever(TAGXmlLoteMaricondiWS.TAG_DATA_LOTE.toString(), Funcoes.formataData(FORMATO_DATA, new Date()));
        this.xml.escrever(TAGXmlLoteMaricondiWS.TAG_HORA_LOTE.toString(), Funcoes.formataData(FORMATO_HORA, new Date()));
        for (Registro req : requisicoes) {
            this.criarPedido(req, st, digitosTuboFilial, digitosTuboRequisicao);
        }
        this.xml.fechar(TAGXmlLoteMaricondiWS.TAG_LOTE.toString());
        this.xml.fechar(TAGXmlLoteMaricondiWS.TAG_REGISTRO.toString());
    }

    private void criarPedido(Registro req, Statement st, int digitosTuboFilial, int digitosTuboRequisicao) throws XMLStringBuilderException, ParseException {
        this.xml.abrir(TAGXmlLoteMaricondiWS.TAG_PEDIDO.toString());
        this.xml.escrever(TAGXmlLoteMaricondiWS.TAG_COD_PED_LAB.toString(), Funcoes.preencheZero(req.getString(FIL_CODIGO), digitosTuboFilial) + Funcoes.preencheZero(req.getString(REQ_CODIGO), digitosTuboRequisicao));
        this.xml.escrever(TAGXmlLoteMaricondiWS.TAG_DATA_PED.toString(), this.formatar(FORMATO_DATA, req.getDate(REQ_DATA)));
        this.xml.escrever(TAGXmlLoteMaricondiWS.TAG_HORA_PED.toString(), this.formatar(FORMATO_HORA, req.getDate(REQ_HORA)));
        this.xml.abrir(TAGXmlLoteMaricondiWS.TAG_PACIENTE.toString());
        this.xml.escrever(TAGXmlLoteMaricondiWS.TAG_COD_PAC_LAB.toString(), req.getString(PAC_CODIGO));
        this.xml.escrever(TAGXmlLoteMaricondiWS.TAG_NOME.toString(), StringUtil.limpaXmlEnvioWebService(req.getString(PAC_NOME)));
        this.xml.escrever(TAGXmlLoteMaricondiWS.TAG_SEXO.toString(), this.getSexo(req.getString(PAC_SEXO)));
        if (req.nulo(PAC_DATANASC)) {
            this.xml.escrever(this.getTagIdadePaciente(req), req.getString(REQ_IDADE));
        } else {
            this.xml.escrever(TAGXmlLoteMaricondiWS.TAG_DATA_NASC.toString(), Funcoes.formataData(FORMATO_DATA, req.getDate(PAC_DATANASC)));
        }
        this.xml.fechar(TAGXmlLoteMaricondiWS.TAG_PACIENTE.toString());
        List listaExames = (List)req.getValor("listaexames");
        ArrayList<String> listaExamesAdicionados = new ArrayList<String>();
        this.criarExames(listaExames, listaExamesAdicionados, st);
        this.xml.fechar(TAGXmlLoteMaricondiWS.TAG_PEDIDO.toString());
    }

    protected String formatar(String masc, Date data) {
        if (masc != null && data != null) {
            return Funcoes.formataData(masc, data);
        }
        return "";
    }

    private void criarExames(List<Registro> listaExames, ArrayList<String> listaExamesAdicionados, Statement st) throws XMLStringBuilderException, ParseException {
        for (Registro exa : listaExames) {
            Map<ExameMaterialMaricondi, Integer> exaMaricondi;
            String key = exa.getString(EXA_CODIGO) + exa.getString(MCO_CODIGO);
            if (listaExamesAdicionados.contains(key)) continue;
            List listaExamesDesmembrados = (List)exa.getValor("listaexames");
            if (listaExamesDesmembrados != null && !listaExamesDesmembrados.isEmpty()) {
                for (Registro desm : listaExamesDesmembrados) {
                    exaMaricondi = this.carregarExamesMaricondi(listaExamesDesmembrados);
                    key = desm.getString(EXA_CODIGO) + desm.getString(MCO_CODIGO);
                    if (listaExamesAdicionados.contains(key)) continue;
                    this.gravarDadosExame(desm, exaMaricondi, st);
                    listaExamesAdicionados.add(key);
                }
                continue;
            }
            exaMaricondi = this.carregarExamesMaricondi(listaExames);
            this.gravarDadosExame(exa, exaMaricondi, st);
            listaExamesAdicionados.add(key);
        }
    }

    private void gravarDadosExame(Registro exa, Map<ExameMaterialMaricondi, Integer> exaMaricondi, Statement st) throws XMLStringBuilderException, ParseException {
        String codigoNumericoExame = ExportacaoParaMaricondiDao.getCodigoExameImportado(exa.getString(FIL_CODIGO), exa.getString(CODIGO_EXAME), st);
        if (!Funcoes.textoVazio(codigoNumericoExame)) {
            codigoNumericoExame = Funcoes.preencheZero(codigoNumericoExame, 4);
        }
        this.xml.abrir(TAGXmlLoteMaricondiWS.TAG_EXAME.toString());
        ExameMaterialMaricondi exaMat = new ExameMaterialMaricondi(exa.getString(CODIGO_EXAME), exa.getString(CODIGO_MATERIAL));
        if (codigoNumericoExame != null) {
            this.xml.escrever(TAGXmlLoteMaricondiWS.TAG_COD_EXM_APOIO.toString(), exaMat.material + "|" + codigoNumericoExame + "|" + (exaMaricondi.get(exaMat) + 1));
        } else {
            this.xml.escrever(TAGXmlLoteMaricondiWS.TAG_COD_EXM_APOIO.toString(), exa.getString(CODIGO_EXAME));
        }
        this.xml.escrever(TAGXmlLoteMaricondiWS.TAG_COD_EXM_LAB.toString(), exa.getString(EXA_CODIGO) + "|" + exa.getString(MCO_CODIGO));
        this.xml.escrever(TAGXmlLoteMaricondiWS.TAG_DESC_MAT.toString(), exa.getString(TAGXmlLoteMaricondiWS.TAG_DESC_MAT.toString()));
        exaMaricondi.put(exaMat, exaMaricondi.get(exaMat) + 1);
        if (exaMat.material.equalsIgnoreCase("DIV") && exa.getBoolean(TAG_UTILIZAR_MAT_REQUISICAO)) {
            this.xml.escrever(TAGXmlLoteMaricondiWS.TAG_DESC_MAT.toString(), Funcoes.textoVazio(exa.getString("exr_descricaomaterial")) ? StringUtil.limpaXmlEnvioWebService(exa.getString("mco_descricao")) : StringUtil.limpaXmlEnvioWebService(exa.getString("exr_descricaomaterial")));
        } else if (!Funcoes.textoVazio(exa.getString(TAG_MATERIAL_SELECIONADO))) {
            this.xml.escrever(TAGXmlLoteMaricondiWS.TAG_DESC_MAT.toString(), StringUtil.limpaXmlEnvioWebService(exa.getString(TAG_MATERIAL_SELECIONADO)));
            this.xml.escrever(TAGXmlLoteMaricondiWS.TAG_CONSERVANTE.toString(), exa.getString(TAG_CONSERVANTE_SELECIONADO));
        }
        this.xml.escrever(TAGXmlLoteMaricondiWS.TAG_DATA_COLETA.toString(), this.formatar(FORMATO_DATA, exa.getDate(EXR_DATAMATERIAL)));
        this.xml.escrever(TAGXmlLoteMaricondiWS.TAG_HORA_COLETA.toString(), this.formatar(FORMATO_HORA, exa.getDate(EXR_DATAMATERIAL)));
        this.xml.fechar(TAGXmlLoteMaricondiWS.TAG_EXAME.toString());
    }

    protected Map<ExameMaterialMaricondi, Integer> carregarExamesMaricondi(List<Registro> exames) {
        HashMap<ExameMaterialMaricondi, Integer> map = new HashMap<ExameMaterialMaricondi, Integer>();
        for (Registro exa : exames) {
            ExameMaricondi em = ExameMaricondi.novaInstancia(exa.getString(ELE_XMLLABEXTERNO));
            if (em == null) continue;
            String codigoExame = StringUtil.isEmpty(em.getMnemonicoExame()) ? em.getCodigoExame() : em.getMnemonicoExame();
            exa.setValor(CODIGO_EXAME, codigoExame);
            exa.setValor(CODIGO_MATERIAL, em.getMaterial());
            if (this.enviarUsandoWS) {
                exa.setValor(TAGXmlLoteMaricondiWS.TAG_DESC_MAT.toString(), em.getMaterial());
            } else {
                exa.setValor(TAGXmlLoteMaricondiWS.TAG_DESC_MAT.toString(), em.getTubo());
            }
            map.put(new ExameMaterialMaricondi(codigoExame, em.getMaterial()), 0);
        }
        return map;
    }

    protected String getTagIdadePaciente(Registro req) {
        if (req.getString("req_anomes").equalsIgnoreCase("A")) {
            return "IdadeAno";
        }
        if (req.getString("req_anomes").equalsIgnoreCase("M")) {
            return "IdadeMes";
        }
        return "IdadeDia";
    }

    protected String getSexo(String tipo) {
        if (tipo.equals("M")) {
            return "Masculino";
        }
        if (tipo.equals("F")) {
            return "Feminino";
        }
        return "Indefinido";
    }
}

