/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.externo.exportadores.maricondi;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.exportacao.integracao.IntegracaoUtil;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.concurrent.Callable;

public class ExportacaoParaMaricondiDao {
    public static String getCodigoExameImportado(String filial, String exame, Statement st) {
        String codigoExame = "";
        if (st != null) {
            try {
                StringBuilder bui = new StringBuilder();
                bui.append(" select mar_codexamenumerico \n");
                bui.append("   from examesmatrix \n");
                bui.append("  where fil_codigo = ").append(filial).append(" and \n");
                bui.append("  mar_codexame = '").append(exame).append("'");
                ResultSet res = st.executeQuery(bui.toString());
                if (res.next()) {
                    codigoExame = res.getString("mar_codexamenumerico");
                }
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            }
        }
        return codigoExame;
    }

    public void atualizarEtiquetasLoteExternoRequisicao(String etiquetaDB, String codigoTuboApoio, String codigoLabExterno, String codigoReq, String codFilial, String lote, Statement st, String tipoIntegracao) throws SQLException {
        StringBuilder sqlpdate = new StringBuilder();
        sqlpdate.append(" update  loteexternorequisicao set leq_retornows = coalesce(leq_retornows, ' ') || '<etiqueta>' || '").append(StringUtil.textoDB(etiquetaDB)).append("' || '</etiqueta>' ");
        sqlpdate.append(", leq_codigoreqapoio = ").append(codigoTuboApoio);
        sqlpdate.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
        sqlpdate.append(" and lae_codigo = ").append(codigoLabExterno);
        sqlpdate.append(" and req_codigo = ").append(codigoReq);
        sqlpdate.append(" and fil_kodigo = ").append(codFilial);
        sqlpdate.append(" and lex_codigo = ").append(lote);
        st.executeUpdate(sqlpdate.toString());
        if (!codFilial.equals(Variaveis.filialPadrao) || tipoIntegracao.equals("F") || tipoIntegracao.equals("W")) {
            IntegracaoUtil.insereComandoLog(st, Variaveis.filialPadrao, codFilial, sqlpdate.toString());
        }
    }

    public void atualizaCodigoApoiadoExameRequisicao(boolean isColetaWeb, List<Registro> requisicoes, String exame, String material, String codigoApoiado, Statement st, Callable<Boolean> arquivar, Callable<Boolean> anular) {
        StringBuilder sql = new StringBuilder();
        ResultSet rs = null;
        for (Registro req : requisicoes) {
            try {
                sql.setLength(0);
                sql.append(" select exr_codigoapoiado, exr_dataetqcoleta from examerequisicao  ");
                sql.append(" where fil_codigo = ").append(req.getString("fil_codigo"));
                sql.append(" and req_codigo =  ").append(req.getString("req_codigo"));
                sql.append(" and exa_codigo = '").append(exame).append("' ");
                sql.append(" and mco_codigo = ").append(material);
                rs = st.executeQuery(sql.toString());
                if (rs.next()) {
                    sql.setLength(0);
                    sql.append(" update  examerequisicao set exr_codigoapoiado = ").append(codigoApoiado);
                    sql.append(rs.getDate("exr_dataetqcoleta") == null ? ", exr_dataetqcoleta = current_timestamp" : "");
                    sql.append(" where fil_codigo = ").append(req.getString("fil_codigo"));
                    sql.append("   and req_codigo = ").append(req.getString("req_codigo"));
                    sql.append("   and exa_codigo = '").append(exame).append("' ");
                    sql.append(" and mco_codigo = ").append(material);
                    if (isColetaWeb) {
                        st.executeUpdate(sql.toString());
                    } else {
                        Conexao.executeUpdate(req.getString("fil_codigo"), st, sql);
                    }
                }
                sql.setLength(0);
                sql.append(" select ere_codigoapoiado from examerequisicaorecipiente ");
                sql.append(" where fil_codigo = ").append(req.getString("fil_codigo"));
                sql.append(" and req_codigo =  ").append(req.getString("req_codigo"));
                sql.append(" and exa_codigo = '").append(exame).append("' ");
                sql.append(" and mco_codigo = ").append(material);
                rs = st.executeQuery(sql.toString());
                sql.setLength(0);
                if (rs.next()) {
                    sql.append(" update  examerequisicaorecipiente set ere_codigoapoiado = ").append(codigoApoiado);
                    sql.append(" where fil_codigo = ").append(req.getString("fil_codigo"));
                    sql.append(" and req_codigo =  ").append(req.getString("req_codigo"));
                    sql.append(" and exa_codigo = '").append(exame).append("' ");
                    sql.append(" and mco_codigo = ").append(material);
                }
                if (sql.length() > 0) {
                    if (isColetaWeb) {
                        st.executeUpdate(sql.toString());
                    } else {
                        Conexao.executeUpdate(req.getString("fil_codigo"), st, sql);
                    }
                }
                arquivar.call();
            }
            catch (Exception e) {
                try {
                    anular.call();
                }
                catch (Exception e1) {
                    ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel anular o c\u00f3digo do apoio.\n" + e1.getMessage(), e1.getStackTrace());
                }
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel gravar o c\u00f3digo do apoio.\n" + e.getMessage(), e.getStackTrace());
            }
        }
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public String pesquisarEtiquetaPorRequisicao(String filial, Integer[] multiguias, String[] exames, int[] materiais, Statement st) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append("select distinct lot.lex_codigo, ");
        buf.append("       lot.leq_retornows as retornoWs");
        buf.append("  from loteexternorequisicao lot ");
        buf.append("  join loteexternoexamerequisicao lotex on lot.fil_codigo = lotex.fil_codigo and lot.req_codigo = lotex.req_codigo and lot.lex_codigo = lotex.lex_codigo ");
        buf.append(" where lot.fil_kodigo = ").append(filial);
        buf.append("   and lot.req_codigo in (").append(this.getCondicao(multiguias)).append(") ");
        buf.append("   and lot.leq_retornows is not null ");
        buf.append("   and lot.leq_dataestorno is null ");
        if (exames != null && exames.length > 0 && materiais != null && materiais.length > 0) {
            buf.append("  and (lotex.exa_codigo, lotex.mco_codigo) IN (");
            for (int i = 0; i < exames.length; ++i) {
                if (i > 0) {
                    buf.append(",");
                }
                buf.append("(").append(StringUtil.textoDBEscape(exames[i]));
                buf.append(",").append(materiais[i]).append(")");
            }
            buf.append(" ) ");
        }
        StringBuilder retorno = new StringBuilder();
        ResultSet rs = st.executeQuery(buf.toString());
        while (rs.next()) {
            retorno.append(rs.getString("retornoWs"));
        }
        rs.close();
        return retorno.toString();
    }

    private String getCondicao(Integer[] materiais) {
        StringBuilder condicao = new StringBuilder();
        Integer[] integerArray = materiais;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int material = integerArray[i];
            condicao.append(material).append(",");
        }
        condicao.deleteCharAt(condicao.length() - 1);
        return condicao.toString();
    }
}

