/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.externo.exportadores.maricondi;

import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.relatorios.apoio.RelatorioSituacaoLote;
import jalis.laboratorio.triagem.externo.Exportador;
import jalis.laboratorio.triagem.externo.LaboratorioExterno;
import jalis.laboratorio.triagem.externo.exportadores.IntegracaoLabExterno;
import jalis.laboratorio.triagem.externo.exportadores.UtilExportadores;
import jalis.laboratorio.triagem.externo.exportadores.maricondi.ExportacaoParaMaricondiDao;
import jalis.laboratorio.triagem.externo.exportadores.maricondi.GeradorXmlExportacaoMaricondi;
import jalis.laboratorio.triagem.externo.exportadores.maricondi.LoteMaricondiWSDTO;
import jalis.laboratorio.triagem.externo.exportadores.maricondi.PedidoMaricondiWSDTO;
import jalis.laboratorio.triagem.externo.exportadores.maricondi.ProcessaRetornoMaricondiWSUtil;
import jalis.laboratorio.triagem.externo.exportadores.maricondi.RecipienteMaricondiWSDTO;
import jalis.laboratorio.triagem.externo.exportadores.maricondi.TAGLoteRetornoMaricondiWS;
import jalis.laboratorio.triagem.externo.exportadores.maricondi.TAGXmlLoteMaricondiWS;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.laboratorio.util.impressao.Impressao;
import jalis.laboratorio.util.impressao.ImprimirEtiquetasColetaTriagem;
import jalis.laboratorio.util.impressao.RetornoImpressaoEtiquetas;
import jalis.laboratorio.util.impressao.labexterno.ImpressorasLabExterno;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.laboratorio.util.parsers.maricondi.TagsConfiguradorProtocoloMaricondi;
import jalis.relatorio.Gerador;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.impressao.termica.ImpressaoTermica;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import jalis.util.xml.XMLStringBuilder;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Scanner;
import java.util.concurrent.Callable;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.swing.JDialog;
import javax.swing.table.TableModel;
import org.json.JSONObject;

public class ExportacaoParaMaricondi
extends IntegracaoLabExterno
implements Exportador {
    public static final String MCO_CODIGO = "mco_codigo";
    public static final String EXA_CODIGO = "exa_codigo";
    public static final String REQ_HORA = "req_hora";
    public static final String REQ_DATA = "req_data";
    public static final String REQ_IDADE = "req_idade";
    public static final String REQ_CODIGO = "req_codigo";
    public static final String CODIGO_EXAME = "codigoExame";
    public static final String TAG_ENDERECO_WEBSERVICE = "enderecoWebService";
    private XMLStringBuilder xml = new XMLStringBuilder(true);
    protected String agente = "";
    protected String senha = "";
    private String enderecoWebService = "";
    protected String configuracaoLabExterno = "";
    boolean debug = true;
    private ExportacaoParaMaricondiDao dao = new ExportacaoParaMaricondiDao();
    private GeradorXmlExportacaoMaricondi gerador;
    private boolean isGerarArquivo = false;
    private int colunaOrdenacao = -1;
    private File arquivo;

    @Override
    public String getTagCodigo() {
        return TagsConfiguradorProtocoloMaricondi.TAG_CODIGO_PROTOCOLO.getTag();
    }

    @Override
    public RetornoImpressaoEtiquetas exportarExames(String codLabExterno, String numeroLote, String configuracaoLabExterno, boolean reenvio, List<Registro> requisicoes, int colunaOrdenacao, boolean isColetaWeb, int agruparInterface, Statement st, Statement st2, Statement st3, String variaveisLogin, boolean agruparGuiasInterface, String imprimirEtiquetaTriagemSemMaterial, boolean imprimirEtiquetaColetaSemMaterial, boolean imprimirEtiquetaColetaSelecionadaSemMaterial, boolean agruparEtqPorQtde, String tipoExportacaoInterface, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario, String tipoIntegracao, String tamanhoNomeImpressora, String[] impressorasLocais, ImpressorasLabExterno impressoras, String tipoEtiquetaSoroteca, Callable<Boolean> arquivar, Callable<Boolean> anular, LaboratorioExterno labExterno, boolean agruparMultiguia) {
        String codigoConvenio = StringUtil.getValor(configuracaoLabExterno, TagsConfiguradorProtocoloMaricondi.TAG_CODIGO_PROTOCOLO.getTag());
        RetornoImpressaoEtiquetas retorno = new RetornoImpressaoEtiquetas();
        this.colunaOrdenacao = colunaOrdenacao;
        this.configuracaoLabExterno = configuracaoLabExterno;
        this.gerador = new GeradorXmlExportacaoMaricondi(this.debug, this.xml);
        this.enviarUsandoWS = configuracaoLabExterno.indexOf("enviarLoteWebservice") >= 0 && StringUtil.getBoolean(configuracaoLabExterno, "enviarLoteWebservice");
        this.senha = StringUtil.getValor(configuracaoLabExterno, TagsConfiguradorProtocoloMaricondi.TAG_CHAVE.getTag());
        this.agente = StringUtil.getValor(configuracaoLabExterno, TagsConfiguradorProtocoloMaricondi.TAG_CODIGO_PROTOCOLO.getTag());
        if (!this.isGerarArquivo && StringUtil.getBoolean(StringUtil.getValor(configuracaoLabExterno, "enviarLoteWebservice"))) {
            String nomeXml = "remessa_" + numeroLote + ".xml";
            File file = new File(System.getProperty("user.home") + File.separatorChar + nomeXml);
            try {
                requisicoes = ExportacaoParaMaricondi.agruparMutiguia(requisicoes, st, agruparGuiasInterface, digitosTuboFilial);
                if (Funcoes.textoVazio(codigoConvenio)) {
                    codigoConvenio = this.agente;
                }
                this.gerador.gerarXML(numeroLote, codigoConvenio, requisicoes, st, digitosTuboFilial, digitosTuboRequisicao);
                StringUtil.escreverArquivoTexto(file.getPath(), this.xml.getXML());
                this.arquivo = file;
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
            }
            retorno = this.exportarExames(isColetaWeb, codLabExterno, numeroLote, requisicoes, reenvio, agruparInterface, st, st2, st3, variaveisLogin, agruparGuiasInterface, imprimirEtiquetaTriagemSemMaterial, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, agruparEtqPorQtde, tipoExportacaoInterface, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, tuboPrimario, utilizarCapacidadeTuboPrimario, arquivar, anular, tipoIntegracao, tamanhoNomeImpressora, impressorasLocais, impressoras, tipoEtiquetaSoroteca, variaveisLogin, labExterno);
            if (!retorno.isImprimiu() && !reenvio) {
                try {
                    ExportacaoParaMaricondi.removerLote(codLabExterno, requisicoes, numeroLote, true, false, st, isColetaWeb, arquivar, agruparInterface);
                    return retorno;
                }
                catch (Exception e) {
                    ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
                }
            }
            return retorno;
        }
        for (Registro registro : requisicoes) {
            ArrayList listaExames = (ArrayList)registro.getValor("listaexames");
            ArrayList<String> listExa = new ArrayList<String>();
            int[] arrayMat = new int[listaExames.size()];
            for (Registro exa : listaExames) {
                listExa.add(exa.getString(EXA_CODIGO));
                arrayMat[listExa.size() - 1] = Integer.parseInt(exa.getString(MCO_CODIGO));
            }
            if (tipoEtiq == 0) {
                tipoEtiq = agruparInterface == 1 ? 2 : 1;
            }
            String[] arrayExa = (String[])Arrays.copyOf(listExa.toArray(), listExa.toArray().length, String[].class);
            try {
                ImprimirEtiquetasColetaTriagem.criaEtiqueta(isColetaWeb, registro.getString("fil_codigo"), registro.getString(REQ_CODIGO), arrayExa, arrayMat, true, "R", st, st2, st3, Variaveis.login, tipoEtiq, false, null, null, false, true, codLabExterno, false, agruparGuiasInterface, imprimirEtiquetaTriagemSemMaterial, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, agruparEtqPorQtde, tipoExportacaoInterface, agruparInterface, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, tuboPrimario, utilizarCapacidadeTuboPrimario);
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
            }
        }
        ArrayList<Registro> listaBackup = new ArrayList<Registro>();
        if (!requisicoes.isEmpty()) {
            for (Registro registro : requisicoes) {
                listaBackup.add(registro.clone());
            }
        }
        try {
            requisicoes = ExportacaoParaMaricondi.agruparMutiguia(requisicoes, st, agruparGuiasInterface, digitosTuboFilial);
            this.gerador.gerarXML(numeroLote, codigoConvenio, requisicoes, st, digitosTuboFilial, digitosTuboRequisicao);
            String string = "remessa_" + numeroLote + Funcoes.formataData("_yyyyMMdd", new Date()) + ".xml";
            if (!this.enviarUsandoWS && !isColetaWeb) {
                this.gerarArquivo(this.xml.getXML(), new File(string), reenvio, "Arquivo de exporta\u00e7\u00e3o Maricondi (*.xml)");
            } else if (isColetaWeb) {
                retorno.setXmlLote(this.xml.getXML());
                retorno.setNomeArquivoLote(string);
                retorno.setExtensaoArquivo("xml");
            }
            retorno.setImprimiu(true);
            return retorno;
        }
        catch (Exception exception) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), exception.getMessage(), exception.getStackTrace());
            return retorno;
        }
    }

    private RetornoImpressaoEtiquetas exportarExames(boolean isColetaWeb, String codLabExterno, String numeroLote, List<Registro> requisicoes, boolean reenvio, int agruparInterface, Statement st, Statement st2, Statement st3, String variaveisLogin, boolean agruparGuiasInterface, String imprimirEtiquetaTriagemSemMaterial, boolean imprimirEtiquetaColetaSemMaterial, boolean imprimirEtiquetaColetaSelecionadaSemMaterial, boolean agruparEtqPorQtde, String tipoExportacaoInterface, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario, Callable<Boolean> arquivar, Callable<Boolean> anular, String tipoIntegracao, String tamanhoNomeImpressora, String[] impressorasLocais, ImpressorasLabExterno impressoras, String tipoEtiquetaSoroteca, String login, LaboratorioExterno labExterno) {
        RetornoImpressaoEtiquetas retorno = new RetornoImpressaoEtiquetas();
        ArrayList<Registro> listaRequisicoesSemAgrupamento = new ArrayList<Registro>();
        for (Registro req : requisicoes) {
            listaRequisicoesSemAgrupamento.add(req.clone());
        }
        try {
            this.criarEtiquetas(isColetaWeb, listaRequisicoesSemAgrupamento, agruparInterface, st, st2, st3, variaveisLogin, agruparGuiasInterface, imprimirEtiquetaTriagemSemMaterial, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, agruparEtqPorQtde, tipoExportacaoInterface, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, tuboPrimario, utilizarCapacidadeTuboPrimario, arquivar);
        }
        catch (Exception e1) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel gerar etiquetas.\n", e1.getStackTrace());
        }
        try {
            List<Registro> novaLista = new ArrayList<Registro>();
            for (Registro reg : requisicoes) {
                if (Funcoes.textoVazio(reg.getString("pac_datanasc"))) {
                    String msg = "Existem pacientes sem data de nascimento informada.\nO laborat\u00f3rio externo Diagn\u00f3sticos do Brasil exige esse item.";
                    if (!isColetaWeb) {
                        Funcoes.mensagem(this, msg, 1);
                    }
                    ExportacaoParaMaricondi.removerLote(codLabExterno, requisicoes, numeroLote, true, false, st, isColetaWeb, arquivar, agruparInterface);
                    retorno.getMensagensRetornoLabExterno().put(Protocolo.Maricondi.getDescricao(), msg);
                    retorno.setImprimiu(false);
                    return retorno;
                }
                novaLista.add(reg.clone());
            }
            novaLista = ExportacaoParaMaricondi.agruparMutiguia(novaLista, st, agruparGuiasInterface, digitosTuboFilial);
            this.enviarUsandoWS = this.configuracaoLabExterno.indexOf("enviarLoteWebservice") >= 0 ? StringUtil.getBoolean(this.configuracaoLabExterno, "enviarLoteWebservice") : false;
            this.enderecoWebService = this.configuracaoLabExterno.indexOf(TAG_ENDERECO_WEBSERVICE) >= 0 ? StringUtil.getValor(this.configuracaoLabExterno, TAG_ENDERECO_WEBSERVICE) : null;
            retorno = this.enviarLoteParaLabExterno(codLabExterno, numeroLote, requisicoes, reenvio, listaRequisicoesSemAgrupamento, novaLista, digitosTuboFilial, impressoras.getImpressoraMaricondi(), st, isColetaWeb, arquivar, anular, tipoIntegracao);
            if (!retorno.isImprimiu()) {
                return retorno;
            }
            if (this.isGerarArquivo) {
                this.exportarExames(codLabExterno, numeroLote, this.configuracaoLabExterno, reenvio, requisicoes, this.colunaOrdenacao, isColetaWeb, agruparInterface, st, st2, st3, variaveisLogin, agruparGuiasInterface, imprimirEtiquetaTriagemSemMaterial, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, agruparEtqPorQtde, tipoExportacaoInterface, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, tuboPrimario, utilizarCapacidadeTuboPrimario, tipoIntegracao, tamanhoNomeImpressora, impressorasLocais, impressoras, tipoEtiquetaSoroteca, arquivar, anular, labExterno, agruparGuiasInterface);
            }
            return retorno;
        }
        catch (Exception e) {
            if (e.getMessage().contains("500")) {
                Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o foi possivel obter conex\u00e3o com WebService do Maricondi.\nEntre em contato com o laborat\u00f3rio de apoio.", 1);
            } else {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel criar o lote solicitado.\n" + e.getMessage(), e.getStackTrace());
            }
            return retorno;
        }
    }

    public byte[] imprimirEtiqueta(boolean isColetaWeb, String filial, String requisicao, LaboratorioExterno labExterno, String[] exames, int[] materiais, String impressoraMaricondi, Statement st, Callable<Boolean> arquivar, Callable<Boolean> anular) {
        Integer[] multiguias = null;
        String etiqueta = "";
        ImpressaoTermica termica = new ImpressaoTermica(Impressao.comparaNomeImpressoraReduzido(impressoraMaricondi), isColetaWeb);
        try {
            multiguias = RecepcaoUtil.verificaMultiGuias(st, filial, requisicao, true);
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e2o foi recuperar as requisi\u00e7\u00f5es multiguia\n" + e.getMessage(), e.getStackTrace());
        }
        if (labExterno != null && !Funcoes.textoVazio(requisicao)) {
            try {
                String retorno = this.dao.pesquisarEtiquetaPorRequisicao(filial, multiguias, exames, materiais, st);
                String[] etiquetas = StringUtil.getValores(retorno, TAGLoteRetornoMaricondiWS.TAG_ETQCODBAR.toString());
                if (etiquetas.length < 1) {
                    etiquetas = StringUtil.getValores(retorno, "etiqueta");
                }
                etiqueta = StringUtil.implode(this.removeEtiquetaDuplicada(etiquetas), " ");
                return termica.imprimirDireto(etiqueta, true, st, isColetaWeb, arquivar, anular);
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e2o foi poss\u00edvel verificar lote externo.\n" + e.getMessage(), e.getStackTrace());
            }
        }
        return new byte[0];
    }

    private ArrayList<String> removeEtiquetaDuplicada(String[] etiquetas) {
        ArrayList<String> novaEtiqueta = new ArrayList<String>();
        for (String etq : etiquetas) {
            if (novaEtiqueta.contains(etq)) continue;
            novaEtiqueta.add(etq);
        }
        return novaEtiqueta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RetornoImpressaoEtiquetas enviarLoteParaLabExterno(String codLabExterno, String numeroLote, List<Registro> requisicoes, boolean reenvio, List<Registro> listaRequisicoesSemAgrupamento, List<Registro> novaLista, int digitosTuboFilial, String impressora, Statement st, boolean isColetaWeb, Callable<Boolean> arquivar, Callable<Boolean> anular, String tipoIntegracao) throws FileNotFoundException {
        RetornoImpressaoEtiquetas retorno = new RetornoImpressaoEtiquetas();
        if (this.enviarUsandoWS) {
            File xmlGerado = this.arquivo;
            Scanner scanner = new Scanner(xmlGerado);
            HttpURLConnection urlConnection = null;
            try {
                retorno = UtilExportadores.comunicacaoOk(this.enderecoWebService, isColetaWeb, Protocolo.Maricondi.getDescricao());
                if (retorno.isImprimiu()) {
                    String linha;
                    StringBuilder conteudoGerado = new StringBuilder();
                    while (scanner.hasNext()) {
                        conteudoGerado.append(scanner.nextLine());
                    }
                    if (!this.validaXml(conteudoGerado.toString())) {
                        retorno.getMensagensRetornoLabExterno().put(Protocolo.Maricondi.getDescricao(), "Xml de envio n\u00e3o possui nenhuma tag de Pedido e/ou Exame.");
                        retorno.setImprimiu(false);
                        RetornoImpressaoEtiquetas retornoImpressaoEtiquetas = retorno;
                        return retornoImpressaoEtiquetas;
                    }
                    TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                        @Override
                        public X509Certificate[] getAcceptedIssuers() {
                            return new X509Certificate[0];
                        }

                        @Override
                        public void checkClientTrusted(X509Certificate[] certs, String authType) {
                        }

                        @Override
                        public void checkServerTrusted(X509Certificate[] certs, String authType) {
                        }
                    }};
                    SSLContext sc = SSLContext.getInstance("SSL");
                    if (this.enderecoWebService.contains("https")) {
                        sc.init(null, trustAllCerts, new SecureRandom());
                        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
                    }
                    URL url = new URL(this.enderecoWebService + "/Cadastrapedido");
                    urlConnection = (HttpURLConnection)url.openConnection();
                    urlConnection.setDoOutput(true);
                    urlConnection.setDoInput(true);
                    urlConnection.setRequestMethod("POST");
                    urlConnection.setRequestProperty("Content-type", "application/xml; charset=ISO-8859-1");
                    urlConnection.setRequestProperty("idcliente", this.agente);
                    urlConnection.setRequestProperty("chaveseguranca", this.senha);
                    urlConnection.connect();
                    OutputStream os = urlConnection.getOutputStream();
                    os.write(conteudoGerado.toString().getBytes());
                    os.flush();
                    if (this.debug) {
                        System.out.println("=====XML ENVIO=====");
                        System.out.println(conteudoGerado);
                    }
                    BufferedReader leitura = new BufferedReader(new InputStreamReader(urlConnection.getInputStream(), StandardCharsets.ISO_8859_1));
                    StringBuilder retornoWebService = new StringBuilder();
                    while ((linha = leitura.readLine()) != null) {
                        retornoWebService.append("\n").append(linha);
                    }
                    leitura.close();
                    if (this.debug) {
                        System.out.println("=====XML RETORNO=====");
                        System.out.println(retornoWebService.toString());
                    }
                    if (!Funcoes.textoVazio(retornoWebService.toString())) {
                        if (retornoWebService.toString().contains("status")) {
                            JSONObject jsonObject = new JSONObject(retornoWebService.toString());
                            String erroDescricao = jsonObject.getString("detalhes");
                            if (!isColetaWeb) {
                                Funcoes.mensagem(Laboratorio.getInstancia(), erroDescricao, 2);
                            }
                            UtilExportadores.adicionarMensagemRetorno(erroDescricao, Protocolo.Maricondi.getDescricao(), retorno);
                            retorno.setImprimiu(false);
                            RetornoImpressaoEtiquetas retornoImpressaoEtiquetas = retorno;
                            return retornoImpressaoEtiquetas;
                        }
                        retorno = this.processaRetornoWebService(retornoWebService.toString(), requisicoes, codLabExterno, reenvio, numeroLote, digitosTuboFilial, impressora, st, isColetaWeb, arquivar, anular, tipoIntegracao, retorno);
                        retorno.setImprimiu(true);
                        RetornoImpressaoEtiquetas retornoImpressaoEtiquetas = retorno;
                        return retornoImpressaoEtiquetas;
                    }
                    retorno.setImprimiu(false);
                    RetornoImpressaoEtiquetas retornoImpressaoEtiquetas = retorno;
                    return retornoImpressaoEtiquetas;
                }
                retorno.setImprimiu(false);
                RetornoImpressaoEtiquetas conteudoGerado = retorno;
                return conteudoGerado;
            }
            catch (Exception e) {
                String mensagem = "N\u00e3o foi poss\u00edvel enviar xml do lote.\n" + e.getMessage();
                if (!isColetaWeb) {
                    ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), mensagem, e.getStackTrace());
                }
                retorno.getMensagensRetornoLabExterno().put(Protocolo.Maricondi.getDescricao(), mensagem);
                retorno.setImprimiu(false);
                RetornoImpressaoEtiquetas retornoImpressaoEtiquetas = retorno;
                return retornoImpressaoEtiquetas;
            }
            finally {
                scanner.close();
                xmlGerado.delete();
                if (urlConnection != null) {
                    urlConnection.disconnect();
                }
            }
        }
        retorno.setImprimiu(true);
        return retorno;
    }

    private RetornoImpressaoEtiquetas processaRetornoWebService(String retorno, List<Registro> requisicoes, String codLabExterno, boolean reenvio, String numeroLote, int digitosTuboFilial, String impressora, Statement st, boolean isColetaWeb, Callable<Boolean> arquivar, Callable<Boolean> anular, String tipoIntegracao, RetornoImpressaoEtiquetas retornoImpressao) throws SQLException {
        LoteMaricondiWSDTO processaRetorno = ProcessaRetornoMaricondiWSUtil.processaRetorno(retorno);
        StringBuilder impressao = new StringBuilder();
        for (PedidoMaricondiWSDTO pedido : processaRetorno.getPedidos()) {
            String filialRequisicao = pedido.getCodigoPedidoApoio();
            String filial = StringUtil.removeZerosEsquerda(filialRequisicao.substring(0, digitosTuboFilial));
            String requisicao = StringUtil.removeZerosEsquerda(filialRequisicao.substring(digitosTuboFilial, filialRequisicao.length()));
            for (RecipienteMaricondiWSDTO recip : pedido.getRecipientes()) {
                String numeroAmostra = recip.getCodigoBarrasApoio();
                String codigoExame = recip.getCodigoExameApoio();
                String etiqueta = recip.getEtiqueta();
                this.atualizandoRequisicoes(isColetaWeb, requisicoes, codLabExterno, reenvio, numeroLote, filial, requisicao, numeroAmostra, codigoExame, etiqueta, st, arquivar, anular, tipoIntegracao);
                impressao.append(etiqueta);
            }
        }
        byte[] imprimirEtiquetas = this.imprimirEtiquetas(impressao, impressora, st, isColetaWeb, arquivar, anular);
        ArrayList<byte[]> etiquetas = retornoImpressao.getEtiquetasLabExterno() != null && !retornoImpressao.getEtiquetasLabExterno().isEmpty() ? retornoImpressao.getEtiquetasLabExterno().get("maricondi") : new ArrayList<byte[]>();
        etiquetas.add(imprimirEtiquetas);
        retornoImpressao.getEtiquetasLabExterno().put("maricondi", etiquetas);
        return retornoImpressao;
    }

    private void atualizandoRequisicoes(boolean isColetaWeb, List<Registro> requisicoes, String codLabExterno, boolean reenvio, String numeroLote, String filial, String requisicao, String numeroAmostra, String codigoExame, String etiqueta, Statement st, Callable<Boolean> arquivar, Callable<Boolean> anular, String tipoIntegracao) throws SQLException {
        for (Registro req : requisicoes) {
            ArrayList exames = (ArrayList)req.getValor("listaexames");
            boolean atualizar = false;
            if (!(atualizar = this.atualizarExameApoio(isColetaWeb, requisicoes, numeroAmostra, codigoExame, exames, atualizar, st, arquivar, anular)) || !req.getString("fil_codigo").equalsIgnoreCase(filial) || !req.getString(REQ_CODIGO).equals(requisicao) && !req.getString("req_codigomae").equals(requisicao)) continue;
            String lote = !reenvio ? req.getString("novoLote") : numeroLote;
            this.dao.atualizarEtiquetasLoteExternoRequisicao(etiqueta, numeroAmostra, codLabExterno, req.getString(REQ_CODIGO), filial, lote, st, tipoIntegracao);
        }
    }

    private boolean atualizarExameApoio(boolean isColetaWeb, List<Registro> requisicoes, String numeroAmostra, String codigoExame, ArrayList<Registro> exames, boolean atualizar, Statement st, Callable<Boolean> arquivar, Callable<Boolean> anular) {
        block0: for (Registro exame : exames) {
            ArrayList examesDesm = (ArrayList)exame.getValor("listaexames");
            if (examesDesm != null && !examesDesm.isEmpty()) {
                for (Registro desm : examesDesm) {
                    String exameDBJalis = StringUtil.getValor(desm.getString("ele_xmllabexterno"), CODIGO_EXAME);
                    if (!exameDBJalis.equalsIgnoreCase(codigoExame)) continue;
                    atualizar = true;
                    this.dao.atualizaCodigoApoiadoExameRequisicao(isColetaWeb, requisicoes, exame.getString(EXA_CODIGO), exame.getString(MCO_CODIGO), numeroAmostra, st, arquivar, anular);
                    continue block0;
                }
                continue;
            }
            String exameDBJalis = StringUtil.getValor(exame.getString("ele_xmllabexterno"), CODIGO_EXAME);
            if (!this.existeCodigoExameNaEtiqueta(codigoExame, exameDBJalis)) continue;
            atualizar = true;
            this.dao.atualizaCodigoApoiadoExameRequisicao(isColetaWeb, requisicoes, exame.getString(EXA_CODIGO), exame.getString(MCO_CODIGO), numeroAmostra, st, arquivar, anular);
            break;
        }
        return atualizar;
    }

    private byte[] imprimirEtiquetas(StringBuilder impressao, String impressora, Statement st, boolean isColetaWeb, Callable<Boolean> arquivar, Callable<Boolean> anular) {
        if (!Funcoes.textoVazio(impressao.toString())) {
            ImpressaoTermica termica = new ImpressaoTermica(Impressao.comparaNomeImpressoraReduzido(impressora), isColetaWeb);
            return termica.imprimirDireto(impressao.toString(), true, st, isColetaWeb, arquivar, anular);
        }
        return new byte[0];
    }

    private boolean existeCodigoExameNaEtiqueta(String codigoExame, String exameDBJalis) {
        String[] codigos;
        for (String cod : codigos = codigoExame.split(";")) {
            if (!cod.equalsIgnoreCase(exameDBJalis)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void escreverArquivo(File arquivo, String xml) {
        BufferedWriter writer = null;
        try (FileWriter fileWriter = new FileWriter(arquivo);){
            writer = new BufferedWriter(fileWriter);
            writer.write("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n" + xml);
            writer.close();
        }
        catch (IOException e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
                }
            }
        }
    }

    public boolean validaXml(String conteudoGerado) {
        if (conteudoGerado.contains(TAGXmlLoteMaricondiWS.TAG_PEDIDO.toString()) && conteudoGerado.contains(TAGXmlLoteMaricondiWS.TAG_EXAME.toString())) {
            return true;
        }
        if (!conteudoGerado.contains(TAGXmlLoteMaricondiWS.TAG_PEDIDO.toString())) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "Xml de envio n\u00e3o possui nenhuma tag de Pedido.", 2);
        } else if (!conteudoGerado.contains(TAGXmlLoteMaricondiWS.TAG_EXAME.toString())) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "Xml de envio n\u00e3o possui nenhuma tag de Exame.", 2);
        }
        return false;
    }

    @Override
    public int getMaiorCodigoLote(String numeroLote, String codigoConvenio, LaboratorioExterno labExterno, Statement st) {
        try {
            ResultSet rs = st.executeQuery("select max(lex_codigo) + 1 as codigo from loteexterno where lae_codigo = " + labExterno.codigoLab + " and fil_codigo = " + Variaveis.filialPadrao);
            if (rs.next()) {
                return rs.getInt("codigo");
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return 0;
    }

    @Override
    public byte[] imprimeRelatorio(boolean isColetaWeb, String codLabExterno, String numeroLote, List<Registro> requisicoesListaOriginal, int colunaOrdenacao, Statement st, int filialPadrao, int digitosTuboRequisicao, int digitosTuboFilial, String impressoraRelatorio) throws Exception {
        RelatorioSituacaoLote rel = new RelatorioSituacaoLote();
        ModeloGridTable modelo = rel.getModeloDados(st, new String[]{String.valueOf(numeroLote)}, new String[]{String.valueOf(codLabExterno)}, colunaOrdenacao, requisicoesListaOriginal, filialPadrao, digitosTuboRequisicao, digitosTuboFilial);
        if (modelo.getRowCount() > 0) {
            Gerador gerador = new Gerador(impressoraRelatorio);
            HashMap<String, Object> variaveis = new HashMap<String, Object>();
            variaveis.put("filtroLote", numeroLote);
            String xmlRelatorio = rel.getXMLRelatorio(st);
            if (!isColetaWeb) {
                JDialog dialogo = new JDialog((Frame)Laboratorio.getInstancia(), "Relat\u00f3rio de lote enviado");
                dialogo.setModal(true);
                dialogo.setSize(new Dimension(750, 600));
                dialogo.setLayout(new BorderLayout());
                gerador.setPai(dialogo.getContentPane());
                gerador.setPreVisualizar(true);
                gerador.setZoomPreVisualizar(0.5f);
                gerador.setAcaoFechar(dialogo::dispose);
                gerador.executar(xmlRelatorio, (TableModel)modelo, variaveis);
                ScreenUtil.centralizar(dialogo);
                dialogo.setVisible(true);
            } else {
                gerador.executar(xmlRelatorio, modelo, variaveis, false, true, isColetaWeb);
                return Impressao.gerarPdfRelatorio(gerador.getRelatorio(), xmlRelatorio);
            }
        }
        return new byte[0];
    }
}

