/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.externo.exportadores.indlab;

import jalis.laboratorio.triagem.externo.exportadores.indlab.EnvioServidorDto;
import jalis.laboratorio.triagem.externo.exportadores.indlab.RespostaEnvioServidorDto;
import jalis.laboratorio.triagem.externo.exportadores.indlab.RespostaPesquisaServidorDto;
import jalis.laboratorio.triagem.externo.exportadores.indlab.RespostaResultadoServidorDto;
import jalis.util.StringUtil;
import java.io.File;
import java.nio.charset.StandardCharsets;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class IndLabComunicacao {
    private static final String PARAM_CAMINHO = "caminho";
    private static final String PARAM_DATA_INICIAL = "dataInicial";
    private static final String PARAM_DATA_FINAL = "dataFinal";
    private static final String ENDPOINT_ENVIO = "/indlab/enviar";
    private static final String ENDPOINT_PESQUISA_RESULTADOS = "/indlab/pesquisaresultados";
    private static final String ENDPOINT_RESULTADO = "/indlab/resultado";
    private final String host;
    private final String caminhoRetorno;

    public IndLabComunicacao(String xmlConfigLabExterno) {
        String caminhoRetornoConfigurado;
        String hostConfigurado = StringUtil.getValor(xmlConfigLabExterno, "linkServidor").trim();
        if (hostConfigurado.endsWith(File.separator)) {
            hostConfigurado = hostConfigurado.substring(0, hostConfigurado.length() - 1);
        }
        this.host = hostConfigurado;
        this.caminhoRetorno = caminhoRetornoConfigurado = StringUtil.getValor(xmlConfigLabExterno, "caminhoRetorno").trim();
    }

    public boolean hostValido() {
        boolean valida = false;
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpGet get = new HttpGet(this.host + "/servidor/versao");
        try {
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)get);
            valida = response.getStatusLine().getStatusCode() == 200;
        }
        catch (Exception e) {
            return valida;
        }
        return valida;
    }

    public EnvioServidorDto enviarLote(EnvioServidorDto envio) {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpPost post = new HttpPost(this.host + ENDPOINT_ENVIO);
        RespostaEnvioServidorDto respostaServidor = new RespostaEnvioServidorDto();
        try {
            StringEntity jsonEntity = new StringEntity(envio.toJson(), "UTF-8");
            post.setHeader("content-type", "application/json");
            post.setEntity((HttpEntity)jsonEntity);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)post);
            String respJson = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            respostaServidor = respostaServidor.fromJson(respJson);
            envio.setRespostaEnvio(respostaServidor);
        }
        catch (Exception e) {
            respostaServidor.setCodigo(0);
            respostaServidor.setSucesso(false);
            respostaServidor.setMensagem("Falha ao enviar lote - " + e.getMessage());
            envio.setRespostaEnvio(respostaServidor);
        }
        return envio;
    }

    public RespostaPesquisaServidorDto pesquisarResultadosPorData(String dataHoraInicial, String dataHoraFinal) {
        RespostaPesquisaServidorDto respostaServidor = new RespostaPesquisaServidorDto();
        try {
            URIBuilder uri = new URIBuilder(this.host.concat(ENDPOINT_PESQUISA_RESULTADOS), StandardCharsets.UTF_8);
            uri.addParameter(PARAM_CAMINHO, this.caminhoRetorno);
            uri.addParameter(PARAM_DATA_INICIAL, dataHoraInicial);
            uri.addParameter(PARAM_DATA_FINAL, dataHoraFinal);
            CloseableHttpClient httpClient = HttpClients.createDefault();
            HttpGet get = new HttpGet(uri.build());
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)get);
            String respJson = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            respostaServidor = respostaServidor.fromJson(respJson);
        }
        catch (Exception e) {
            respostaServidor.setCodigo(-1);
            respostaServidor.setMensagem("Falha ao pesquisar resultados - " + e.getMessage());
        }
        return respostaServidor;
    }

    public RespostaResultadoServidorDto importarResultado(EnvioServidorDto envio) {
        RespostaResultadoServidorDto resposta = new RespostaResultadoServidorDto();
        CloseableHttpClient httpClient = HttpClients.createDefault();
        try {
            String uri = this.host + ENDPOINT_RESULTADO;
            StringEntity jsonEntity = new StringEntity(envio.toJson(), "UTF-8");
            HttpUriRequest request = RequestBuilder.get((String)uri).setEntity((HttpEntity)jsonEntity).setHeader("Content-Type", "application/json").build();
            CloseableHttpResponse response = httpClient.execute(request);
            String respJson = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            resposta = resposta.fromJson(respJson);
        }
        catch (Exception e) {
            resposta.setCodigo(-1);
            resposta.setMensagem("Falha ao pesquisar resultados - " + e.getMessage());
        }
        return resposta;
    }
}

