/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.externo.exportadores.indlab;

import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.relatorios.apoio.RelatorioSituacaoLote;
import jalis.laboratorio.triagem.externo.Exportador;
import jalis.laboratorio.triagem.externo.LaboratorioExterno;
import jalis.laboratorio.triagem.externo.exportadores.IntegracaoLabExterno;
import jalis.laboratorio.triagem.externo.exportadores.UtilExportadores;
import jalis.laboratorio.triagem.externo.exportadores.indlab.EnvioServidorDto;
import jalis.laboratorio.triagem.externo.exportadores.indlab.IndLabCampos;
import jalis.laboratorio.triagem.externo.exportadores.indlab.IndLabComunicacao;
import jalis.laboratorio.triagem.externo.exportadores.indlab.IndLabDto;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.laboratorio.util.impressao.Impressao;
import jalis.laboratorio.util.impressao.RetornoImpressaoEtiquetas;
import jalis.laboratorio.util.impressao.labexterno.ImpressorasLabExterno;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.model.dao.triagem.externo.exportadores.indlab.ExportacaoParaIndLabDao;
import jalis.model.vo.cadastro.exame.LabExternoVO;
import jalis.relatorio.Gerador;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Frame;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import javax.swing.JDialog;
import javax.swing.table.TableModel;

public class ExportacaoParaIndLab
extends IntegracaoLabExterno
implements Exportador {
    private final ExportacaoParaIndLabDao dao = new ExportacaoParaIndLabDao();
    private static final String MENSAGEM_LOTE_NAO_GERADO = "O lote dos exames do INDLab n\u00e3o pode ser gerado! %s";

    @Override
    public String getTagCodigo() {
        return null;
    }

    @Override
    public RetornoImpressaoEtiquetas exportarExames(String codLabExterno, String numeroLote, String configuracaoLabExterno, boolean reenvio, List<Registro> requisicoes, int colunaOrdenacao, boolean isColetaWeb, int agruparInterface, Statement st, Statement st2, Statement st3, String variaveisLogin, boolean agruparGuiasInterface, String imprimirEtiquetaTriagemSemMaterial, boolean imprimirEtiquetaColetaSemMaterial, boolean imprimirEtiquetaColetaSelecionadaSemMaterial, boolean agruparEtqPorQtde, String tipoExportacaoInterface, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario, String tipoIntegracao, String tamanhoNomeImpressora, String[] impressorasLocais, ImpressorasLabExterno impressoras, String tipoEtiquetaSoroteca, Callable<Boolean> arquivar, Callable<Boolean> anular, LaboratorioExterno laboratorioExterno, boolean agruparMultiguia) {
        RetornoImpressaoEtiquetas retorno = new RetornoImpressaoEtiquetas();
        if (!this.configuracaoValida(configuracaoLabExterno)) {
            if (!isColetaWeb) {
                Funcoes.mensagem(Laboratorio.getInstancia(), " Configura\u00e7\u00e3o inv\u00e1lida  para o Lab. Externo " + codLabExterno + ".\n Lote n\u00e3o foi criado", 2);
            }
            this.removerLoteDoBanco(codLabExterno, requisicoes, numeroLote, st, isColetaWeb, arquivar, retorno, agruparInterface);
            UtilExportadores.adicionarMensagemRetorno(" Configura\u00e7\u00e3o inv\u00e1lida  para o Lab. Externo " + codLabExterno + ".<br> Lote n\u00e3o foi criado", Protocolo.INDLab.getDescricao(), retorno);
            retorno.setImprimiu(false);
            return retorno;
        }
        IndLabComunicacao comunicacao = new IndLabComunicacao(configuracaoLabExterno);
        if (!comunicacao.hostValido()) {
            if (!isColetaWeb) {
                Funcoes.mensagem(Laboratorio.getInstancia(), " Configura\u00e7\u00e3o inv\u00e1lida  para o Lab. Externo " + codLabExterno + ".\n Lote n\u00e3o foi criado", 2);
            }
            this.removerLoteDoBanco(codLabExterno, requisicoes, numeroLote, st, isColetaWeb, arquivar, retorno, agruparInterface);
            UtilExportadores.adicionarMensagemRetorno(" Configura\u00e7\u00e3o inv\u00e1lida  para o Lab. Externo " + codLabExterno + ".<br> Lote n\u00e3o foi criado", Protocolo.INDLab.getDescricao(), retorno);
            retorno.setImprimiu(false);
            return retorno;
        }
        requisicoes = ExportacaoParaIndLab.agruparMutiguia(requisicoes, st, agruparGuiasInterface, digitosTuboFilial);
        String caminhoEnvio = StringUtil.getValor(configuracaoLabExterno, "caminhoEnvio");
        ArrayList<EnvioServidorDto> enviados = new ArrayList<EnvioServidorDto>();
        for (Registro req : requisicoes) {
            LabExternoVO labExterno = this.dao.pesquisarLabExterno(req.getInt("fil_codigo"), req.getInt("lae_codigo"), st, arquivar, anular);
            boolean agruparMultiguias = agruparGuiasInterface || labExterno.getAgruparmultiguias() != false;
            Integer[] requisicoesAgrupadas = null;
            if (agruparMultiguias) {
                try {
                    requisicoesAgrupadas = RecepcaoUtil.verificaMultiGuias(st, req.getString("fil_codigo"), req.getString("req_codigo"), true, false);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            } else {
                requisicoesAgrupadas = new Integer[]{req.getInt("req_codigo")};
            }
            IndLabDto dto = this.dao.pesquisarDadosParaXml(req.getInt("fil_codigo"), Arrays.asList(requisicoesAgrupadas), req.getInt("pac_codigo"), st, arquivar, anular);
            String xml = this.gerarXml(req, dto, numeroLote, digitosTuboFilial, digitosTuboRequisicao, st);
            String nomeArquivo = this.getNomeArquivo();
            EnvioServidorDto envio = new EnvioServidorDto(labExterno, numeroLote, xml, nomeArquivo, caminhoEnvio);
            envio = comunicacao.enviarLote(envio);
            this.dao.gravaNomeArquivoLote(req.getString("fil_codigo"), req.getString("req_codigo"), req.getString("lae_codigo"), numeroLote, nomeArquivo, tipoIntegracao, st, isColetaWeb, arquivar, anular);
            enviados.add(envio);
        }
        boolean todosEnviados = true;
        for (EnvioServidorDto envio : enviados) {
            if (envio.getRespostaEnvio().isSucesso()) continue;
            todosEnviados = false;
            if (!isColetaWeb) {
                Funcoes.mensagem(Laboratorio.getInstancia(), String.format(MENSAGEM_LOTE_NAO_GERADO, envio.getRespostaEnvio().getMensagem()), 2);
            }
            UtilExportadores.adicionarMensagemRetorno(String.format(MENSAGEM_LOTE_NAO_GERADO, envio.getRespostaEnvio().getMensagem()), Protocolo.INDLab.getDescricao(), retorno);
            this.removerLoteDoBanco(codLabExterno, requisicoes, numeroLote, st, isColetaWeb, arquivar, retorno, agruparInterface);
            break;
        }
        if (todosEnviados) {
            this.criarEtiquetasEnviados(requisicoes, isColetaWeb, agruparInterface, st, st2, st3, variaveisLogin, agruparGuiasInterface, imprimirEtiquetaTriagemSemMaterial, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, agruparEtqPorQtde, tipoExportacaoInterface, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, tuboPrimario, utilizarCapacidadeTuboPrimario, arquivar, anular);
        }
        retorno.setImprimiu(todosEnviados);
        return retorno;
    }

    private void criarEtiquetasEnviados(List<Registro> requisicoes, boolean isColetaWeb, int agruparInterface, Statement st, Statement st2, Statement st3, String variaveisLogin, boolean agruparGuiasInterface, String imprimirEtiquetaTriagemSemMaterial, boolean imprimirEtiquetaColetaSemMaterial, boolean imprimirEtiquetaColetaSelecionadaSemMaterial, boolean agruparEtqPorQtde, String tipoExportacaoInterface, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario, Callable<Boolean> arquivar, Callable<Boolean> anular) {
        for (Registro req : requisicoes) {
            try {
                ExportacaoParaIndLab.criarEtiquetaRequisicao(isColetaWeb, req, agruparInterface, st, st2, st3, variaveisLogin, agruparGuiasInterface, imprimirEtiquetaTriagemSemMaterial, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, agruparEtqPorQtde, tipoExportacaoInterface, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, tuboPrimario, utilizarCapacidadeTuboPrimario, arquivar);
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "Falha ao criar etiquetas para a requisicao " + req.getString("req_codigo") + " - " + e.getMessage(), e.getStackTrace());
            }
        }
    }

    private void removerLoteDoBanco(String codLabExterno, List<Registro> requisicoes, String numeroLote, Statement st, boolean isColetaWeb, Callable<Boolean> arquivar, RetornoImpressaoEtiquetas retorno, int agruparInterface) {
        try {
            ExportacaoParaIndLab.removerLote(codLabExterno, requisicoes, numeroLote, st, isColetaWeb, arquivar, agruparInterface);
        }
        catch (Exception e) {
            if (!isColetaWeb) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel desfazer o lote " + numeroLote + " - " + e.getMessage(), e.getStackTrace());
            }
            UtilExportadores.adicionarMensagemRetorno("N\u00e3o foi poss\u00edvel desfazer o lote " + numeroLote + " - " + e.getMessage(), Protocolo.INDLab.getDescricao(), retorno);
        }
    }

    private String getNomeArquivo() {
        String agora = LocalDateTime.now().format(DateTimeFormatter.ofPattern("HHmmss.SSS"));
        String nomeArquivoSemExtensao = agora.replace(".", "");
        Integer hora = Integer.valueOf(nomeArquivoSemExtensao.substring(0, 2));
        String horaLetra = "";
        switch (hora) {
            case 1: {
                horaLetra = "A";
                break;
            }
            case 2: {
                horaLetra = "B";
                break;
            }
            case 3: {
                horaLetra = "C";
                break;
            }
            case 4: {
                horaLetra = "D";
                break;
            }
            case 5: {
                horaLetra = "E";
                break;
            }
            case 6: {
                horaLetra = "F";
                break;
            }
            case 7: {
                horaLetra = "G";
                break;
            }
            case 8: {
                horaLetra = "H";
                break;
            }
            case 9: {
                horaLetra = "I";
                break;
            }
            case 10: {
                horaLetra = "J";
                break;
            }
            case 11: {
                horaLetra = "K";
                break;
            }
            case 12: {
                horaLetra = "L";
                break;
            }
            case 13: {
                horaLetra = "M";
                break;
            }
            case 14: {
                horaLetra = "N";
                break;
            }
            case 15: {
                horaLetra = "O";
                break;
            }
            case 16: {
                horaLetra = "P";
                break;
            }
            case 17: {
                horaLetra = "Q";
                break;
            }
            case 18: {
                horaLetra = "R";
                break;
            }
            case 19: {
                horaLetra = "S";
                break;
            }
            case 20: {
                horaLetra = "T";
                break;
            }
            case 21: {
                horaLetra = "U";
                break;
            }
            case 22: {
                horaLetra = "V";
                break;
            }
            case 23: {
                horaLetra = "W";
                break;
            }
            default: {
                horaLetra = "X";
            }
        }
        nomeArquivoSemExtensao = horaLetra + nomeArquivoSemExtensao.substring(2);
        return nomeArquivoSemExtensao.concat(".xml");
    }

    @Override
    public int getMaiorCodigoLote(String numeroLote, String codigoConvenio, LaboratorioExterno labExterno, Statement st) {
        try {
            return this.dao.getMaiorCodigoLote(labExterno.codigoLab, st);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return -1;
        }
    }

    @Override
    public byte[] imprimeRelatorio(boolean isColetaWeb, String codLabExterno, String numeroLote, List<Registro> requisicoesListaOriginal, int colunaOrdenacao, Statement st, int filialPadrao, int digitosTuboRequisicao, int digitosTuboFilial, String impressoraRelatorio) throws Exception {
        RelatorioSituacaoLote rel = new RelatorioSituacaoLote();
        ModeloGridTable modelo = rel.getModeloDados(st, new String[]{String.valueOf(numeroLote)}, new String[]{String.valueOf(codLabExterno)}, colunaOrdenacao, requisicoesListaOriginal, filialPadrao, digitosTuboRequisicao, digitosTuboFilial);
        if (modelo.getRowCount() > 0) {
            Gerador gerador = new Gerador(impressoraRelatorio);
            HashMap<String, Object> variaveis = new HashMap<String, Object>();
            variaveis.put("filtroLote", numeroLote);
            String xmlRelatorio = rel.getXMLRelatorio(st);
            if (!isColetaWeb) {
                JDialog dialogo = new JDialog((Frame)Laboratorio.getInstancia(), "Relat\u00f3rio de lote enviado");
                dialogo.setModal(true);
                dialogo.setSize(new Dimension(750, 600));
                dialogo.setLayout(new BorderLayout());
                gerador.setPai(dialogo.getContentPane());
                gerador.setPreVisualizar(true);
                gerador.setZoomPreVisualizar(0.5f);
                gerador.setAcaoFechar(dialogo::dispose);
                gerador.executar(xmlRelatorio, (TableModel)modelo, variaveis);
                ScreenUtil.centralizar(dialogo);
                dialogo.setVisible(true);
            } else {
                gerador.executar(xmlRelatorio, modelo, variaveis, false, true, isColetaWeb);
                return Impressao.gerarPdfRelatorio(gerador.getRelatorio(), xmlRelatorio);
            }
        }
        return new byte[0];
    }

    private boolean configuracaoValida(String configuracaoLabExterno) {
        String linkServidor = StringUtil.getValor(configuracaoLabExterno, "linkServidor");
        String caminhoEnvio = StringUtil.getValor(configuracaoLabExterno, "caminhoEnvio");
        String caminhoRetorno = StringUtil.getValor(configuracaoLabExterno, "caminhoRetorno");
        return !Funcoes.textoVazio(linkServidor) && !Funcoes.textoVazio(caminhoEnvio) && !Funcoes.textoVazio(caminhoRetorno);
    }

    private String gerarXml(Registro req, IndLabDto dto, String numeroLote, int digitosTuboFilial, int digitosTuboRequisicao, Statement st) {
        XMLStringBuilder xml = new XMLStringBuilder();
        xml.escreveHeader("1.0", "UTF-8");
        try {
            HashMap<String, String> atributosTagContaMedica = new HashMap<String, String>();
            atributosTagContaMedica.put("xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
            atributosTagContaMedica.put("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            xml.abrir(IndLabCampos.CONTA_MEDICA_FIELD.getTag(), atributosTagContaMedica);
            String codFilial = Funcoes.preencheZero(req.getString("fil_codigo"), digitosTuboFilial);
            String codRequisicao = Funcoes.preencheZero(req.getString("req_codigo"), digitosTuboRequisicao);
            xml.escrever(IndLabCampos.CODIGO_EXTERNO_CONTA_MEDICA.getTag(), codFilial.concat(codRequisicao));
            xml.escrever(IndLabCampos.CODIGO_EXTERNO_PACIENTE.getTag(), req.getString("pac_codigo"));
            xml.escrever(IndLabCampos.ORIGEM_PACIENTE.getTag(), numeroLote);
            String tipoAtendimento = "";
            tipoAtendimento = dto.getTipoAtendimento() != null && dto.getTipoAtendimento().equalsIgnoreCase("ambulatorial") ? "Ambulatorial" : "";
            tipoAtendimento = dto.getTipoAtendimento() != null && dto.getTipoAtendimento().equalsIgnoreCase("interna\u00e7\u00e3o") ? "Interna\u00e7\u00e3o" : "";
            xml.escrever(IndLabCampos.TIPO_ATENDIMENTO.getTag(), tipoAtendimento);
            xml.escrever(IndLabCampos.LOCAL_LEITO.getTag(), "");
            xml.escrever(IndLabCampos.LEITO.getTag(), "");
            xml.escrever(IndLabCampos.NOME.getTag(), req.getString("pac_nome").trim());
            String cpf = dto.getCpf() == null ? "" : dto.getCpf().replace(".", "").replace("-", "");
            xml.escrever(IndLabCampos.CPF.getTag(), cpf.trim());
            Date dataNascimento = req.getDate("pac_datanasc");
            String dataNasc = dataNascimento == null ? "" : new SimpleDateFormat("yyyyMMdd").format(dataNascimento);
            xml.escrever(IndLabCampos.DATA_NASCIMENTO.getTag(), dataNasc);
            xml.escrever(IndLabCampos.RESPONSAVEL.getTag(), dto.getResponsavel() == null ? "" : dto.getResponsavel().trim());
            xml.escrever(IndLabCampos.SEXO.getTag(), req.getString("pac_sexo"));
            String tipoIdade = req.getString("req_anomes");
            Integer anos = req.getInt("req_idade");
            Integer idade = tipoIdade.equals("A") && anos != null && anos > 0 ? anos : 0;
            xml.escrever(IndLabCampos.IDADE.getTag(), idade.toString());
            xml.escrever(IndLabCampos.NOME_MEDICO.getTag(), req.getString("med_nome").trim());
            xml.escrever(IndLabCampos.CRM.getTag(), req.getString("med_crm").trim());
            xml.escrever(IndLabCampos.REGISTRO_ANS.getTag(), this.getCodigoANS(req.getString("fil_codigo").trim(), req.getString("con_codigo").trim(), st));
            xml.escrever(IndLabCampos.NOME_CONVENIO.getTag(), req.getString("con_razao") == null ? "" : req.getString("con_razao").trim());
            xml.escrever(IndLabCampos.NUMERO_CONVENIO.getTag(), req.getString("con_codigo").trim());
            xml.escrever(IndLabCampos.NUMERO_PLANO.getTag(), "0");
            xml.escrever(IndLabCampos.NOME_PLANO.getTag(), dto.getPlano() == null ? "" : dto.getPlano().trim());
            xml.escrever(IndLabCampos.GUIA.getTag(), dto.getGuia() == null ? "" : dto.getGuia().trim());
            xml.escrever(IndLabCampos.MATRICULA.getTag(), dto.getMatricula() == null ? "" : dto.getMatricula().trim());
            StringBuilder endereco = new StringBuilder();
            if (!Funcoes.textoVazio(dto.getLogradouro())) {
                String tipoLogradouro = dto.getTipoLogradouroEndereco() == null ? "RUA" : dto.getTipoLogradouroEndereco().trim();
                endereco.append(tipoLogradouro).append(" ");
                endereco.append(dto.getLogradouro().trim()).append(" ");
                String numLogradouro = dto.getNumeroLogradouro() == null ? "" : dto.getNumeroLogradouro().trim();
                endereco.append(numLogradouro);
            }
            xml.escrever(IndLabCampos.ENDERECO.getTag(), endereco.length() > 0 ? endereco.toString() : "");
            xml.escrever(IndLabCampos.BAIRRO.getTag(), dto.getBairro() == null ? "" : dto.getBairro().trim());
            xml.escrever(IndLabCampos.CIDADE.getTag(), dto.getCidade() == null ? "" : dto.getCidade().trim());
            xml.escrever(IndLabCampos.ESTADO.getTag(), dto.getUf() == null ? "" : dto.getUf().trim());
            xml.escrever(IndLabCampos.CEP.getTag(), dto.getCep() == null ? "" : dto.getCep().trim());
            String telefone = "";
            telefone = !Funcoes.textoVazio(dto.getFoneComercial()) ? dto.getFoneComercial() : "";
            telefone = !Funcoes.textoVazio(dto.getFone()) ? dto.getFone() : "";
            telefone = !Funcoes.textoVazio(dto.getCelular()) ? dto.getCelular() : "";
            telefone = telefone.replace("(", "").replace(")", "").replace("-", "");
            xml.escrever(IndLabCampos.TELEFONE.getTag(), telefone.trim());
            xml.escrever(IndLabCampos.EMAIL.getTag(), dto.getEmail() == null ? "" : dto.getEmail().trim());
            this.gerarExamesNoXml(xml, req, dto.getReqUrgente());
            this.gerarComplementoNoXml(xml, req, dto);
            xml.fechar(IndLabCampos.CONTA_MEDICA_FIELD.getTag());
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "Falha ao gerar XML para INDLab -" + e.getMessage(), e.getStackTrace());
        }
        return xml.getXML();
    }

    private String getCodigoANS(String codigoFilial, String codigoConvenio, Statement st) {
        String retorno = "";
        StringBuilder sql = new StringBuilder();
        sql.append("select con_codigoans from convenios c where fil_codigo = ");
        sql.append(codigoFilial);
        sql.append(" and con_codigo = ");
        sql.append(codigoConvenio);
        try {
            ResultSet rs = st.executeQuery(sql.toString());
            if (rs.next()) {
                retorno = rs.getString("con_codigoans");
            }
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel buscar c\u00f3digo ANS do conv\u00eanio " + e.getMessage(), e.getStackTrace());
        }
        return retorno;
    }

    private void gerarExamesNoXml(XMLStringBuilder xml, Registro req, boolean reqUrgente) throws XMLStringBuilderException {
        List exames = (List)req.getValor("listaexames");
        xml.abrir(IndLabCampos.EXAMES.getTag());
        for (Registro exame : exames) {
            List desmembrados = (List)exame.getValor("listaexames");
            if (desmembrados != null && !desmembrados.isEmpty()) {
                for (Registro filho : desmembrados) {
                    this.escreverExameNoXml(xml, filho, reqUrgente);
                }
                continue;
            }
            this.escreverExameNoXml(xml, exame, reqUrgente);
        }
        xml.fechar(IndLabCampos.EXAMES.getTag());
    }

    private void escreverExameNoXml(XMLStringBuilder xml, Registro exame, boolean urgente) throws XMLStringBuilderException {
        String xmlLabExterno = exame.getString("ele_xmllabexterno");
        xml.abrir(IndLabCampos.EXAME.getTag());
        xml.escrever(IndLabCampos.CODIGO_EXTERNO_MOVIMENTO.getTag(), "0");
        String codigoExameExterno = exame.getString("exa_codigo").concat("|").concat(exame.getString("mco_codigo"));
        xml.escrever(IndLabCampos.CODIGO_EXTERNO_EXAME.getTag(), codigoExameExterno);
        String codApoioExame = StringUtil.getValor(xmlLabExterno, "codigo");
        xml.escrever(IndLabCampos.CODIGO_APOIO_EXAME.getTag(), codApoioExame.trim());
        xml.escrever(IndLabCampos.EXAME_URGENTE.getTag(), urgente ? "S" : (exame.getBoolean("exr_urgente") ? "S" : "N"));
        String codTUSS = Funcoes.textoVazio(codigoExameExterno) ? "" : StringUtil.getValor(xmlLabExterno, "tuss");
        xml.escrever(IndLabCampos.CODIGO_TUSS.getTag(), codTUSS);
        xml.escrever(IndLabCampos.NOME_EXAME.getTag(), exame.getString("exa_descricao"));
        xml.fechar(IndLabCampos.EXAME.getTag());
    }

    private void gerarComplementoNoXml(XMLStringBuilder xml, Registro req, IndLabDto dto) throws XMLStringBuilderException, ParseException {
        StringBuilder medicamentos = new StringBuilder();
        StringBuilder dadosClinicos = new StringBuilder();
        for (String medicamento : dto.getMedicamentos()) {
            if (Funcoes.textoVazio(medicamento) || medicamentos.toString().contains(medicamento)) continue;
            medicamentos.append(medicamento.trim()).append(" e ");
        }
        if (medicamentos.length() > 1) {
            medicamentos.replace(medicamentos.length() - 2, medicamentos.length(), "");
        }
        for (String dadoClinico : dto.getDadosClinicos()) {
            if (dadosClinicos.toString().equalsIgnoreCase(dadoClinico) || dadosClinicos.toString().contains(dadoClinico)) continue;
            dadosClinicos.append(dadoClinico + " ");
        }
        xml.abrir(IndLabCampos.COMPLEMENTO.getTag());
        Date dum = req.getDate("req_dum");
        String dataDum = dum == null ? "" : new SimpleDateFormat("dd.MM.yyyy").format(dum);
        xml.escrever(IndLabCampos.ULTIMA_MENSTRUACAO.getTag(), dataDum);
        String medicamentosIndLab = medicamentos.length() > 50 ? medicamentos.substring(0, 50) : medicamentos.toString();
        xml.escrever(IndLabCampos.MEDICACAO.getTag(), medicamentosIndLab.length() > 0 ? medicamentosIndLab.toString() : "");
        Date tempoJejum = dto.getTempoJejum();
        String tj = tempoJejum == null ? "" : new SimpleDateFormat("HH").format(tempoJejum);
        xml.escrever(IndLabCampos.TEMPO_JEJUM.getTag(), tj);
        String dadosClinicosXml = dadosClinicos.length() > 50 ? dadosClinicos.substring(0, 50) : dadosClinicos.toString();
        xml.escrever(IndLabCampos.ESTADO_CLINICO.getTag(), dadosClinicosXml);
        xml.fechar(IndLabCampos.COMPLEMENTO.getTag());
    }
}

