/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.externo.exportadores.db2;

import jalis.laboratorio.triagem.externo.exportadores.db2.DBCamposRetorno;
import jalis.util.StringUtil;
import jalis.util.tabela.Registro;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ParseErroRetornoWebServiceDB {
    private String filial;
    private String requisicao;
    private String numeroPedidoDB;
    private String exame;
    private String exameDB;
    private String material;
    private int codigoErro;
    private String descricao;
    private Registro registroEstornado = null;
    private List<ParseErroRetornoWebServiceDB> listaErroRetornoDB = new ArrayList<ParseErroRetornoWebServiceDB>();
    private String campoListaExames = "";
    private boolean examesDesmRejeitado = false;
    public static final String REQUISICAO_REJEITADA = "req_rejeitada";
    public static final String EXAME_REJEITADO = "exa_rejeitado";
    public static final String EXAME_DESM_REJEITADO = "exa_desm_rejeitad0";

    private ParseErroRetornoWebServiceDB() {
    }

    public ParseErroRetornoWebServiceDB(String retorno, Registro registro, int digitosTuboFilial) {
        this.campoListaExames = registro.possuiCampo("backup_lista_exames") ? "backup_lista_exames" : "listaexames";
        this.registroEstornado = registro;
        if (this.loteParcialmenteAceito(retorno)) {
            this.processaPedidos(retorno, registro, digitosTuboFilial);
            ArrayList<Registro> examesEstornados = new ArrayList<Registro>();
            List exames = (List)registro.getValor("listaexames");
            registro.setValor(REQUISICAO_REJEITADA, true);
            for (Registro exa : exames) {
                this.marcaDesmRejeitado(exa);
                this.marcaExameRejeitado(registro, examesEstornados, exa);
            }
            if (registro.getBoolean(REQUISICAO_REJEITADA)) {
                this.alteraSituacaoExameRejeitado(registro, null, null, "", true);
            }
            if (!examesEstornados.isEmpty()) {
                this.registroEstornado.substituirValor("listaexames", examesEstornados);
            } else {
                this.registroEstornado.substituirValor("listaexames", new ArrayList());
            }
        }
    }

    private void marcaDesmRejeitado(Registro exa) {
        List examesDesmembrados = (List)exa.getValor("listaexames");
        if (examesDesmembrados != null && !examesDesmembrados.isEmpty()) {
            exa.setValor(EXAME_DESM_REJEITADO, true);
            exa.setValor(EXAME_REJEITADO, true);
            for (Registro exaDesm : examesDesmembrados) {
                if (!exaDesm.possuiCampo(EXAME_REJEITADO)) {
                    exaDesm.setValor(EXAME_REJEITADO, false);
                    exa.setValor(EXAME_REJEITADO, false);
                    exa.setValor(EXAME_DESM_REJEITADO, false);
                    continue;
                }
                if (!exaDesm.getBoolean(EXAME_REJEITADO)) continue;
                this.examesDesmRejeitado = true;
            }
        }
    }

    private void marcaExameRejeitado(Registro registro, List<Registro> examesEstornados, Registro exa) {
        if (!exa.getBoolean(EXAME_REJEITADO)) {
            exa.setValor("exa_exportado", true);
            this.marcaExameExportado(registro, exa.getString("exa_codigo"), exa.getString("mco_codigo"));
            registro.setValor(REQUISICAO_REJEITADA, false);
        } else if (exa.getBoolean(EXAME_REJEITADO)) {
            this.alteraSituacaoExameRejeitado(registro, exa.getString("exa_codigo"), exa.getString("mco_codigo"), "0", false);
            examesEstornados.add(exa);
        }
    }

    private void marcaExameExportado(Registro registro, String exaCodigo, String mcoCodigo) {
        List exames = (List)registro.getValor(this.campoListaExames);
        for (Registro exa : exames) {
            if (!exa.getString("exa_codigo").equals(exaCodigo) || !exa.getString("mco_codigo").equals(mcoCodigo)) continue;
            exa.setValor("exa_exportado", true);
            break;
        }
    }

    private void alteraSituacaoExameRejeitado(Registro registro, String exaCodigo, String mcoCodigo, String situacao, boolean marcarTodos) {
        List exames = (List)registro.getValor(this.campoListaExames);
        for (Registro exa : exames) {
            if (!marcarTodos && (!exa.getString("exa_codigo").equals(exaCodigo) || !exa.getString("mco_codigo").equals(mcoCodigo))) continue;
            exa.setValor("exr_situacao", situacao);
        }
    }

    private void processaPedidos(String retorno, Registro registro, int digitosTuboFilial) {
        String[] pedidos;
        for (String pedido : pedidos = StringUtil.getValores(retorno, DBCamposRetorno.TAG_PEDIDOS.getTag())) {
            this.processaMotivosErros(retorno, registro, pedido, digitosTuboFilial);
        }
    }

    private void processaMotivosErros(String retorno, Registro registro, String pedido, int digitosTuboFilial) {
        String[] examesErro = StringUtil.getValores(retorno, DBCamposRetorno.TAG_ERRO_CT_CONFIRMACAO_PROCEDIMENTO_V2.getTag());
        String filialRequisicao = StringUtil.getValor(pedido, DBCamposRetorno.TAG_NUMERO_ATENDIMENTO_APOIADO.getTag());
        String filialCodigo = StringUtil.removeZerosEsquerda(filialRequisicao.substring(0, digitosTuboFilial));
        String requisicaoCodigo = StringUtil.removeZerosEsquerda(filialRequisicao.substring(digitosTuboFilial, filialRequisicao.length()));
        String numeroPedido = StringUtil.getValor(pedido, DBCamposRetorno.TAG_NUMERO_ATENDIMENTO_DB.getTag());
        ParseErroRetornoWebServiceDB parse = null;
        for (String erro : examesErro) {
            parse = new ParseErroRetornoWebServiceDB();
            parse.setFilial(filialCodigo);
            parse.setRequisicao(requisicaoCodigo);
            parse.setNumeroPedidoDB(numeroPedido);
            parse.setExameDB(StringUtil.getValor(erro, DBCamposRetorno.TAG_ERRO_CODIGO_EXAME_DB.getTag()));
            this.processaExameJalis(parse, registro);
            parse.setCodigoErro(Integer.parseInt(StringUtil.getValor(erro, DBCamposRetorno.TAG_ERRO_INTEGRACAO_CODIGO.getTag())));
            this.trataDescricaoErro(parse, erro);
            this.listaErroRetornoDB.add(parse);
        }
    }

    private void processaExameJalis(ParseErroRetornoWebServiceDB parse, Registro registro) {
        if (registro.getString("fil_codigo").equalsIgnoreCase(parse.getFilial()) && (registro.getString("req_codigo").equals(parse.getRequisicao()) || registro.getString("req_codigomae").equals(parse.getRequisicao()))) {
            List exames = (List)registro.getValor("listaexames");
            this.processa(parse, exames);
        }
    }

    private void processa(ParseErroRetornoWebServiceDB parse, List<Registro> exames) {
        for (Registro exa : exames) {
            List examesDesmembrados = (List)exa.getValor("listaexames");
            if (examesDesmembrados != null && !examesDesmembrados.isEmpty()) {
                Registro exaDesm;
                Iterator iterator = examesDesmembrados.iterator();
                while (iterator.hasNext() && !this.marcaRejeitado(parse, exaDesm = (Registro)iterator.next())) {
                }
                continue;
            }
            if (!this.marcaRejeitado(parse, exa)) continue;
            break;
        }
    }

    private boolean marcaRejeitado(ParseErroRetornoWebServiceDB parse, Registro exa) {
        String xmlExame = exa.getString("ele_xmllabexterno");
        if (StringUtil.getValor(xmlExame, "cd_db").equals(parse.getExameDB())) {
            exa.setValor(EXAME_REJEITADO, true);
            parse.setExame(exa.getString("exa_codigo"));
            parse.setMaterial(exa.getString("mco_abreviatura"));
            return true;
        }
        return false;
    }

    private void trataDescricaoErro(ParseErroRetornoWebServiceDB parse, String erro) {
        parse.setDescricao(StringUtil.getValor(erro, DBCamposRetorno.TAG_ERRO_INTEGRACAO_DESCRICAO.getTag()));
        if (parse.getCodigoErro() == 7) {
            parse.setDescricao("N\u00e3o foi poss\u00edvel enviar lote para o Apoio. Entre em contato com o Laborat\u00f3rio Diagn\u00f3stico Brasil (Administrativo).");
        }
    }

    private boolean loteParcialmenteAceito(String retorno) {
        return ParseErroRetornoWebServiceDB.existeTag(retorno, DBCamposRetorno.TAG_PEDIDOS) && ParseErroRetornoWebServiceDB.existeTag(retorno, DBCamposRetorno.TAG_ERRO_STATUS_PEDIDO_V2) && ParseErroRetornoWebServiceDB.existeTag(retorno, DBCamposRetorno.TAG_ERROS_PROCEDIMENTOS) && ParseErroRetornoWebServiceDB.existeTag(retorno, DBCamposRetorno.TAG_ERRO_CT_CONFIRMACAO_PROCEDIMENTO_V2) && ParseErroRetornoWebServiceDB.existeTag(retorno, DBCamposRetorno.TAG_ERRO_INTEGRACAO) && ParseErroRetornoWebServiceDB.existeTag(retorno, DBCamposRetorno.TAG_ERRO_CT_ERRO_INTEGRACAO_V2);
    }

    public static boolean existeTag(String retornoDB, DBCamposRetorno tag) {
        return retornoDB.indexOf(tag.getTag()) > -1;
    }

    public String getFilial() {
        return this.filial;
    }

    public void setFilial(String filial) {
        this.filial = filial;
    }

    public String getRequisicao() {
        return this.requisicao;
    }

    public void setRequisicao(String requisicao) {
        this.requisicao = requisicao;
    }

    public String getNumeroPedidoDB() {
        return this.numeroPedidoDB;
    }

    public void setNumeroPedidoDB(String numeroPedidoDB) {
        this.numeroPedidoDB = numeroPedidoDB;
    }

    public String getExame() {
        return this.exame;
    }

    public void setExame(String exame) {
        this.exame = exame;
    }

    public String getExameDB() {
        return this.exameDB;
    }

    public void setExameDB(String exameDB) {
        this.exameDB = exameDB;
    }

    public String getMaterial() {
        return this.material;
    }

    public void setMaterial(String material) {
        this.material = material;
    }

    public int getCodigoErro() {
        return this.codigoErro;
    }

    public void setCodigoErro(int codigoErro) {
        this.codigoErro = codigoErro;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public Registro getRegistroEstornado() {
        return this.registroEstornado;
    }

    public List<ParseErroRetornoWebServiceDB> getListaErroRetornoDB() {
        return this.listaErroRetornoDB;
    }

    public boolean isExamesDesmRejeitado() {
        return this.examesDesmRejeitado;
    }
}

