/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.externo.exportadores.db2;

import jalis.laboratorio.triagem.externo.exportadores.db2.DBCamposEnvioLote;
import jalis.laboratorio.triagem.externo.exportadores.db2.EscreverXmlDB;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.text.ParseException;
import java.util.ArrayList;

public class GeradorXmlEnviarLoteParaDB {
    private static final String ELE_XMLLABEXTERNO = "ele_xmllabexterno";
    private static final String FIL_CODIGO = "fil_codigo";

    private GeradorXmlEnviarLoteParaDB() {
    }

    public static String geraXml(String configuracaoLabExterno, Registro registro, boolean isEstorno, int digitosTuboFilial, int digitosTuboRequisicao) {
        EscreverXmlDB xml = new EscreverXmlDB();
        try {
            xml.escrever("<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:diag=\"http://diagnosticosdobrasil.com.br\">");
            xml.escrever("<soapenv:Header/>");
            xml.escrever("<soapenv:Body>");
            xml.abrir(DBCamposEnvioLote.TAG_RECEBE_ATENDIMENTO.getTag());
            xml.abrir(DBCamposEnvioLote.TAG_ATENDIMENTO.getTag());
            xml.escrever(DBCamposEnvioLote.TAG_CODIGO_APOIADO.getTag(), StringUtil.getValor(configuracaoLabExterno, "codigo"));
            xml.escrever(DBCamposEnvioLote.TAG_CODIGO_SENHA_INTEGRACAO.getTag(), StringUtil.getValor(configuracaoLabExterno, "senha"));
            GeradorXmlEnviarLoteParaDB.escreverPedido(xml, registro, isEstorno, digitosTuboFilial, digitosTuboRequisicao);
            xml.fechar(DBCamposEnvioLote.TAG_ATENDIMENTO.getTag());
            xml.fechar(DBCamposEnvioLote.TAG_RECEBE_ATENDIMENTO.getTag());
            xml.escrever("</soapenv:Body>");
            xml.escrever("</soapenv:Envelope>");
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ExportacaoParaDB: 135");
        }
        return xml.getXML();
    }

    private static void escreverPedido(XMLStringBuilder xml, Registro registro, boolean isEstorno, int digitosTuboFilial, int digitosTuboRequisicao) throws XMLStringBuilderException {
        xml.abrir(DBCamposEnvioLote.TAG_PEDIDO.getTag());
        xml.escrever(DBCamposEnvioLote.TAG_NUMERO_ATENDIMENTO_APOIADO.getTag(), GeradorXmlEnviarLoteParaDB.getCodigo(registro.getString(FIL_CODIGO), registro.getString("req_codigo"), digitosTuboFilial, digitosTuboRequisicao));
        xml.abrir(DBCamposEnvioLote.TAG_LISTA_PACIENTE_APOIADO.getTag());
        GeradorXmlEnviarLoteParaDB.escreverPaciente(registro, xml);
        xml.fechar(DBCamposEnvioLote.TAG_LISTA_PACIENTE_APOIADO.getTag());
        xml.escrever(DBCamposEnvioLote.TAG_NUMERO_ATENDIMENTO_DB_RESERVA.getTag(), "");
        xml.escrever(DBCamposEnvioLote.TAG_CODIGO_PRIORIDADE.getTag(), registro.getBoolean("req_urgente") ? "U" : "R");
        xml.escrever(DBCamposEnvioLote.TAG_DESCRICAO_DADOS_CLINICOS.getTag(), GeradorXmlEnviarLoteParaDB.getCodigo(registro.getString(FIL_CODIGO), registro.getString("req_codigo"), digitosTuboFilial, digitosTuboRequisicao));
        xml.escrever(DBCamposEnvioLote.TAG_DESCRICAO_MEDICAMENTOS.getTag(), "");
        xml.escrever(DBCamposEnvioLote.TAG_ALTURA.getTag(), registro.getString("req_altura").replace(".", ""));
        xml.escrever(DBCamposEnvioLote.TAG_PESO.getTag(), registro.getString("req_peso"));
        xml.escrever(DBCamposEnvioLote.TAG_USO_APOIADO.getTag(), "");
        xml.escrever(DBCamposEnvioLote.TAG_POSTO_COLETA.getTag(), "");
        xml.abrir(DBCamposEnvioLote.TAG_LISTA_QUESTIONARIO.getTag());
        GeradorXmlEnviarLoteParaDB.escreverQuestionario(xml);
        xml.fechar(DBCamposEnvioLote.TAG_LISTA_QUESTIONARIO.getTag());
        xml.abrir(DBCamposEnvioLote.TAG_LISTA_SOLICITANTE.getTag());
        GeradorXmlEnviarLoteParaDB.escreverSolicitante(registro, xml);
        xml.fechar(DBCamposEnvioLote.TAG_LISTA_SOLICITANTE.getTag());
        xml.abrir(DBCamposEnvioLote.TAG_LISTA_PROCEDIMENTO.getTag());
        GeradorXmlEnviarLoteParaDB.escreverProcedimento(registro, xml, isEstorno);
        xml.fechar(DBCamposEnvioLote.TAG_LISTA_PROCEDIMENTO.getTag());
        xml.fechar(DBCamposEnvioLote.TAG_PEDIDO.getTag());
    }

    private static void escreverPaciente(Registro registro, XMLStringBuilder xml) {
        try {
            xml.escrever(DBCamposEnvioLote.TAG_RG_PACIENTE_APOIADO.getTag(), StringUtil.limpaString(registro.getString("pac_rg"), new String[]{",", ".", "/", "-"}));
            xml.escrever(DBCamposEnvioLote.TAG_NOME_PACIENTE.getTag(), registro.getString("pac_nome"));
            xml.escrever(DBCamposEnvioLote.TAG_SEXO_PACIENTE.getTag(), registro.getString("pac_sexo"));
            xml.escrever(DBCamposEnvioLote.TAG_DATA_HORA_PACIENTE.getTag(), Funcoes.formataData("yyyy-MM-dd", registro.getDate("pac_datanasc")));
            xml.escrever(DBCamposEnvioLote.TAG_NUMERO_CPF.getTag(), StringUtil.limpaString(registro.getString("pac_cpf"), new String[]{",", ".", "/", "-"}));
            xml.escrever(DBCamposEnvioLote.TAG_NUMERO_CARTAO_NACIONAL_SAUDE.getTag(), registro.getString("pac_cartaosus"));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    private static void escreverQuestionario(XMLStringBuilder xml) throws XMLStringBuilderException {
        xml.abrir(DBCamposEnvioLote.TAG_CT_QUESTIONARIO_V2.getTag());
        xml.escrever(DBCamposEnvioLote.TAG_CODIGO_PERGUNTA_QUESTIONARIO.getTag(), "");
        xml.escrever(DBCamposEnvioLote.TAG_RESPOSTA_QUESTIONARIO.getTag(), "");
        xml.fechar(DBCamposEnvioLote.TAG_CT_QUESTIONARIO_V2.getTag());
    }

    private static void escreverSolicitante(Registro registro, XMLStringBuilder xml) throws XMLStringBuilderException {
        xml.abrir(DBCamposEnvioLote.TAG_CT_SOLICITANTE_V2.getTag());
        xml.escrever(DBCamposEnvioLote.TAG_NOME_SOLICITANTE.getTag(), registro.getString("med_nome"));
        xml.escrever(DBCamposEnvioLote.TAG_CODIGO_CONSELHO.getTag(), registro.getString("med_conselho"));
        xml.escrever(DBCamposEnvioLote.TAG_CODIGO_UF_CONSELHO_SOLICITANTE.getTag(), registro.getString("med_uf"));
        xml.escrever(DBCamposEnvioLote.TAG_CODIGO_CONSELHO_SOLICITANTE.getTag(), registro.getString("med_crm"));
        xml.fechar(DBCamposEnvioLote.TAG_CT_SOLICITANTE_V2.getTag());
    }

    private static void escreverProcedimento(Registro registro, XMLStringBuilder xml, boolean isEstorno) {
        ArrayList listaExames = (ArrayList)registro.getValor("listaexames");
        for (Registro exame : listaExames) {
            ArrayList examesDesmembrados = (ArrayList)exame.getValor("listaexames");
            if (examesDesmembrados != null && !examesDesmembrados.isEmpty()) {
                for (Registro exameDesmembrado : examesDesmembrados) {
                    GeradorXmlEnviarLoteParaDB.gerarProcedimento(exameDesmembrado, xml, isEstorno);
                }
                continue;
            }
            GeradorXmlEnviarLoteParaDB.gerarProcedimento(exame, xml, isEstorno);
        }
    }

    private static void gerarProcedimento(Registro exame, XMLStringBuilder xml, boolean isEstorno) {
        try {
            xml.abrir(DBCamposEnvioLote.TAG_CT_PROCEDIMENTO_V2.getTag());
            xml.escrever(DBCamposEnvioLote.TAG_CODIGO_EXAME_DB.getTag(), StringUtil.getValor(exame.getString(ELE_XMLLABEXTERNO), "cd_db"));
            xml.escrever(DBCamposEnvioLote.TAG_DESCRICAO_REGIAO_COLETA.getTag(), exame.getString("exr_descricaomaterial"));
            String dadosAdicionais = StringUtil.getValor(exame.getString(ELE_XMLLABEXTERNO), "dadosAdicionais");
            if (!Funcoes.textoVazio(dadosAdicionais) && dadosAdicionais.indexOf("Volume") > -1) {
                xml.escrever(DBCamposEnvioLote.TAG_VOLUME_URINARIO.getTag(), exame.getString("exr_volumediurese"));
            }
            xml.escrever(DBCamposEnvioLote.TAG_IDENTIDICACAO_EXAME_APOIADO.getTag(), StringUtil.getValor(exame.getString(ELE_XMLLABEXTERNO), "cd_exame"));
            xml.escrever(DBCamposEnvioLote.TAG_MATERIAL_APOIADO.getTag(), StringUtil.getValor(exame.getString(ELE_XMLLABEXTERNO), "material"));
            String descricaoMaterial = StringUtil.isEmpty(exame.getString("exr_descricaomaterial")) ? exame.getString("mco_descricao") : exame.getString("exr_descricaomaterial");
            xml.escrever(DBCamposEnvioLote.TAG_DESCRICAO_MATERIAL_APOIADO.getTag(), descricaoMaterial);
            xml.escrever(DBCamposEnvioLote.TAG_DESCRICAO_EXAME_APOIADO.getTag(), StringUtil.getValor(exame.getString(ELE_XMLLABEXTERNO), "ds_exame"));
            if (!isEstorno) {
                xml.escrever(DBCamposEnvioLote.TAG_CODIGO_MPP.getTag(), "");
            } else {
                xml.escrever(DBCamposEnvioLote.TAG_CODIGO_MPP.getTag(), "CDP");
            }
            xml.abrir(DBCamposEnvioLote.TAG_AMOSTRAS.getTag());
            GeradorXmlEnviarLoteParaDB.escreverAmostra(xml);
            xml.fechar(DBCamposEnvioLote.TAG_AMOSTRAS.getTag());
            xml.fechar(DBCamposEnvioLote.TAG_CT_PROCEDIMENTO_V2.getTag());
        }
        catch (XMLStringBuilderException e) {
            e.printStackTrace();
        }
    }

    private static void escreverAmostra(XMLStringBuilder xml) throws XMLStringBuilderException {
        xml.abrir(DBCamposEnvioLote.TAG_AMOSTRAS_COLETA_V2.getTag());
        xml.escrever(DBCamposEnvioLote.TAG_NUMERO_AMOSTRAS.getTag(), "");
        xml.escrever(DBCamposEnvioLote.TAG_MEIO_COLETA.getTag(), "");
        xml.fechar(DBCamposEnvioLote.TAG_AMOSTRAS_COLETA_V2.getTag());
    }

    private static String getCodigo(String filial, String id, int digitosTuboFilial, int digitosTuboRequisicao) {
        return String.format("%s%s", Funcoes.preencheZero(filial, digitosTuboFilial), Funcoes.preencheZero(id, digitosTuboRequisicao));
    }
}

