/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.externo.exportadores.db2;

import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.relatorios.apoio.RelatorioSituacaoLote;
import jalis.laboratorio.triagem.externo.Exportador;
import jalis.laboratorio.triagem.externo.LaboratorioExterno;
import jalis.laboratorio.triagem.externo.RetornoEstornarLote;
import jalis.laboratorio.triagem.externo.exportadores.IntegracaoLabExterno;
import jalis.laboratorio.triagem.externo.exportadores.ProcessaErroRetornoWebServiceLabExterno;
import jalis.laboratorio.triagem.externo.exportadores.UtilExportadores;
import jalis.laboratorio.triagem.externo.exportadores.VisualizaErroRetornoWebService;
import jalis.laboratorio.triagem.externo.exportadores.db2.AlertaErroRetornoWebServiceDB;
import jalis.laboratorio.triagem.externo.exportadores.db2.DBCamposRetorno;
import jalis.laboratorio.triagem.externo.exportadores.db2.DBComunicacao;
import jalis.laboratorio.triagem.externo.exportadores.db2.DBService;
import jalis.laboratorio.triagem.externo.exportadores.db2.EscreverXmlDB;
import jalis.laboratorio.triagem.externo.exportadores.db2.GeradorXmlEnviaAmostraParaDB;
import jalis.laboratorio.triagem.externo.exportadores.db2.GeradorXmlEnviarLoteParaDB;
import jalis.laboratorio.triagem.externo.exportadores.db2.ParseErroRetornoWebServiceDB;
import jalis.laboratorio.triagem.externo.exportadores.db2.ProcessaErroRetornoWebServiceDB;
import jalis.laboratorio.triagem.externo.exportadores.ws.modelo.Medico;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.laboratorio.util.impressao.Impressao;
import jalis.laboratorio.util.impressao.RetornoImpressaoEtiquetas;
import jalis.laboratorio.util.impressao.labexterno.ImpressorasLabExterno;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.laboratorio.util.parsers.db2.TipoObservacao;
import jalis.model.dao.triagem.externo.exportadores.db2.ExportacaoParaDBDao;
import jalis.relatorio.Gerador;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.SplashMensagem;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.impressao.termica.ImpressaoTermica;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import jalis.util.xml.XMLStringBuilderException;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.print.PrintService;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.table.TableModel;

public class ExportacaoParaDB
extends IntegracaoLabExterno
implements Exportador {
    private static final String ALTURA = "Altura";
    private static final String EXR_DESCRICAOMATERIAL = "exr_descricaomaterial";
    private static final String MCO_CODIGO = "mco_codigo";
    private static final String EXA_CODIGO = "exa_codigo";
    private static final String REQ_CODIGO = "req_codigo";
    private static final String ELE_XMLLABEXTERNO = "ele_xmllabexterno";
    private static final String FIL_CODIGO = "fil_codigo";
    boolean debug = true;
    private static final String TAG_CODIGO_CONSELHO_SOLICITANTE = "CodigoConselhoSolicitante";
    private static final String TAG_CODIGO_UF_CONSELHO_SOLICITANTE = "CodigoUFConselhoSolicitante";
    private static final String TAG_CODIGO_CONSELHO = "CodigoConselho";
    private static final String TAG_NOME_SOLICITANTE = "NomeSolicitante";
    private static final String TAG_LISTA_SOLICITANTE = "ListaSolicitante";
    private static final String TAG_NUMERO_CARTAO_NACIONAL_SAUDE = "NumeroCartaoNacionalSaude";
    private static final String TAG_NUMERO_CPF = "NumeroCPF";
    private static final String TAG_DATA_HORA_PACIENTE = "DataHoraPaciente";
    private static final String TAG_SEXO_PACIENTE = "SexoPaciente";
    private static final String TAG_NOME_PACIENTE = "NomePaciente";
    private static final String TAG_RG_PACIENTE_APOIADO = "RGPacienteApoiado";
    private static final String TAG_LISTA_PACIENTE_APOIADO = "ListaPacienteApoiado";
    private static final String TAG_PESO = "Peso";
    private static final String TAG_ALTURA = "Altura";
    private static final String TAG_DATA_HORA_DUM = "DataHoraDUM";
    private static final String TAG_DESCRICAO_MEDICAMENTOS = "DescricaoMedicamentos";
    private static final String TAG_DESCRICAO_DADOS_CLINICOS = "DescricaoDadosClinicos";
    private static final String TAG_CODIGO_PRIORIDADE = "CodigoPrioridade";
    private static final String TAG_NUMERO_ATENDIMENTO_APOIADO = "NumeroAtendimentoApoiado";
    private static final String TAG_VOLUME_URINARIO = "VolumeUrinario";
    private static final String TAG_DESCRICAO_REGIAO_COLETA = "DescricaoRegiaoColeta";
    private static final String TAG_CODIGO_EXAME_DB = "CodigoExameDB";
    private static final String TAG_CT_PROCEDIMENTO_V1 = "ct_Procedimento_v1";
    private static final String TAG_LISTA_PROCEDIMENTO = "ListaProcedimento";
    private static final String TAG_NUMERO_ATENDIMENTO_DB_RESERVA = "NumeroAtendimentoDBReserva";
    private static final String TAG_CT_PEDIDOS_V1 = "ct_Pedidos_v1";
    private static final String TAG_LISTA_PEDIDOS = "ListaPedidos";
    private static final String TAG_CODIGO_SENHA_INTEGRACAO = "CodigoSenhaIntegracao";
    private static final String TAG_CODIGO_APOIADO = "CodigoApoiado";
    private static final String TAG_NUMERO_LOTE = "NumeroLote";
    private static final String TAG_CT_LOTE_PEDIDOS_V1 = "ct_LotePedidos_v1";
    public static final String TAG_PEDIDO = "pedidos";
    private static final String REQ_ALTURA2 = "req_altura";
    private boolean isGerarArquivo = false;
    private String codigoConvenio = null;
    private int colunaOrdenacao = -1;
    private transient EscreverXmlDB xml = new EscreverXmlDB();
    private final transient ExportacaoParaDBDao dao = new ExportacaoParaDBDao();
    private transient LaboratorioExterno labSelecionado;

    @Override
    public RetornoImpressaoEtiquetas exportarExames(String codLabExterno, String numeroLote, String configuracaoLabExterno, boolean reenvio, List<Registro> requisicoes, int colunaOrdenacao, boolean isColetaWeb, int agruparInterface, Statement st, Statement st2, Statement st3, String variaveisLogin, boolean agruparGuiasInterface, String imprimirEtiquetaTriagemSemMaterial, boolean imprimirEtiquetaColetaSemMaterial, boolean imprimirEtiquetaColetaSelecionadaSemMaterial, boolean agruparEtqPorQtde, String tipoExportacaoInterface, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario, String tipoIntegracao, String tamanhoNomeImpressora, String[] impressorasLocais, ImpressorasLabExterno impressoras, String tipoEtiquetaSoroteca, Callable<Boolean> arquivar, Callable<Boolean> anular, LaboratorioExterno labSelecionado, boolean agruparMultiguia) {
        RetornoImpressaoEtiquetas retorno = new RetornoImpressaoEtiquetas();
        this.codigoConvenio = StringUtil.getValor(configuracaoLabExterno, "codigo");
        this.colunaOrdenacao = colunaOrdenacao;
        this.labSelecionado = labSelecionado;
        boolean enviarMedicoRequisicao = StringUtil.getBoolean(configuracaoLabExterno, "enviarMedico");
        String xmlMedicoPadrao = StringUtil.getValor(configuracaoLabExterno, "medicoPadrao");
        Medico medicoPadrao = null;
        if (!enviarMedicoRequisicao && !Funcoes.textoVazio(xmlMedicoPadrao)) {
            medicoPadrao = new Medico(StringUtil.getValor(xmlMedicoPadrao, "medicoConselho"), StringUtil.getValor(xmlMedicoPadrao, "medicoCRM"), StringUtil.getValor(xmlMedicoPadrao, "medicoUF"), StringUtil.getValor(xmlMedicoPadrao, "medicoNome"));
        }
        if (!this.isGerarArquivo && StringUtil.getBoolean(StringUtil.getValor(configuracaoLabExterno, "enviarLoteWebservice"))) {
            retorno = this.exportarExames(isColetaWeb, codLabExterno, numeroLote, configuracaoLabExterno, requisicoes, reenvio, agruparInterface, st, st2, st3, agruparGuiasInterface, imprimirEtiquetaTriagemSemMaterial, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, agruparEtqPorQtde, tipoExportacaoInterface, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, tuboPrimario, utilizarCapacidadeTuboPrimario, tipoIntegracao, tamanhoNomeImpressora, impressorasLocais, impressoras, tipoEtiquetaSoroteca, arquivar, anular, labSelecionado, agruparMultiguia, variaveisLogin);
            return retorno;
        }
        requisicoes = ExportacaoParaDB.agruparMutiguia(requisicoes, st, agruparGuiasInterface, digitosTuboFilial);
        String nomeArquivo = String.format("%s_%s.xml", StringUtil.getValor(configuracaoLabExterno, "codigo"), numeroLote);
        String xmlGerado = this.gerarArquivoSemWebService(numeroLote, configuracaoLabExterno, requisicoes, enviarMedicoRequisicao, medicoPadrao, digitosTuboFilial, digitosTuboRequisicao);
        if (isColetaWeb) {
            retorno.setXmlLote("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n" + xmlGerado);
            retorno.setNomeArquivoLote(nomeArquivo);
            retorno.setExtensaoArquivo("xml");
            retorno.setImprimiu(true);
            return retorno;
        }
        JFileChooser chooser = ComponenteFactory.novoJFileChooser();
        chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
        chooser.setSelectedFile(new File(nomeArquivo));
        chooser.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo de exporta\u00e7\u00e3o DB (*.xml)", "xml"));
        if (chooser.showSaveDialog(null) == 0) {
            this.escreverArquivo(chooser.getSelectedFile(), xmlGerado);
            retorno.setImprimiu(true);
            return retorno;
        }
        retorno.setImprimiu(false);
        return retorno;
    }

    @Override
    public String getTagCodigo() {
        return "codigo";
    }

    public String gerarArquivoSemWebService(String numeroLote, String configuracaoLabExterno, List<Registro> requisicoes, boolean enviarMedicoRequisicao, Medico medicoPadrao, int digitosTuboFilial, int digitosTuboRequisicao) {
        try {
            this.xml = new EscreverXmlDB();
            this.xml.abrir(TAG_CT_LOTE_PEDIDOS_V1);
            this.xml.escrever(TAG_NUMERO_LOTE, numeroLote);
            this.xml.escrever(TAG_CODIGO_APOIADO, StringUtil.getValor(configuracaoLabExterno, this.getTagCodigo()));
            this.xml.escrever(TAG_CODIGO_SENHA_INTEGRACAO, StringUtil.getValor(configuracaoLabExterno, "senha"));
            this.xml.abrir(TAG_LISTA_PEDIDOS);
            for (Registro requisicao : requisicoes) {
                ArrayList exames = (ArrayList)requisicao.getValor("listaexames");
                this.xml.abrir(TAG_CT_PEDIDOS_V1);
                this.escreverPaciente(this.xml, requisicao, exames, digitosTuboFilial, digitosTuboRequisicao);
                this.escreverRequisicao(this.xml, requisicao, TipoObservacao.get(StringUtil.getValor(configuracaoLabExterno, "enviarObservacao")), digitosTuboFilial, digitosTuboRequisicao);
                this.escreverExames(this.xml, exames);
                this.escreverSolicitante(this.xml, requisicao, enviarMedicoRequisicao, medicoPadrao);
                this.xml.escrever(TAG_NUMERO_ATENDIMENTO_DB_RESERVA, "");
                this.xml.fechar(TAG_CT_PEDIDOS_V1);
            }
            this.xml.fechar(TAG_LISTA_PEDIDOS);
            this.xml.fechar(TAG_CT_LOTE_PEDIDOS_V1);
            return this.xml.getXML();
        }
        catch (XMLStringBuilderException e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ExportacaoParaDB: 129");
        }
        catch (ParseException e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ExportacaoParaDB: 132");
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ExportacaoParaDB: 135");
        }
        return "";
    }

    public RetornoImpressaoEtiquetas exportarExames(boolean isColetaWeb, String codLabExterno, String numeroLote, String configuracaoLabExterno, List<Registro> requisicoes, boolean reenvio, int agruparInterface, Statement st, Statement st2, Statement st3, boolean agruparGuiasInterface, String imprimirEtiquetaTriagemSemMaterial, boolean imprimirEtiquetaColetaSemMaterial, boolean imprimirEtiquetaColetaSelecionadaSemMaterial, boolean agruparEtqPorQtde, String tipoExportacaoInterface, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario, String tipoIntegracao, String tamanhoNomeImpressora, String[] impressorasLocais, ImpressorasLabExterno impressoras, String tipoEtiquetaSoroteca, Callable<Boolean> arquivar, Callable<Boolean> anular, LaboratorioExterno labSelecionado, boolean agruparMultiguia, String login) {
        RetornoImpressaoEtiquetas retorno = new RetornoImpressaoEtiquetas();
        if (reenvio) {
            return this.reenviarLote(isColetaWeb, codLabExterno, numeroLote, configuracaoLabExterno, requisicoes, reenvio, agruparInterface, st, st2, st3, agruparGuiasInterface, imprimirEtiquetaTriagemSemMaterial, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, agruparEtqPorQtde, tipoExportacaoInterface, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, tuboPrimario, utilizarCapacidadeTuboPrimario, tipoIntegracao, tamanhoNomeImpressora, impressorasLocais, impressoras, retorno, tipoEtiquetaSoroteca, arquivar, anular, labSelecionado, agruparMultiguia, login);
        }
        ArrayList<Registro> listaRequisicoesSemAgrupamento = new ArrayList<Registro>();
        for (Registro req : requisicoes) {
            listaRequisicoesSemAgrupamento.add(req.clone());
        }
        try {
            this.criarEtiquetas(isColetaWeb, listaRequisicoesSemAgrupamento, agruparInterface, st, st2, st3, Variaveis.login, agruparGuiasInterface, imprimirEtiquetaTriagemSemMaterial, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, agruparEtqPorQtde, tipoExportacaoInterface, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, tuboPrimario, utilizarCapacidadeTuboPrimario, arquivar);
        }
        catch (Exception e1) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel gerar etiquetas.\n", e1.getStackTrace());
        }
        try {
            List<Registro> novaLista = new ArrayList<Registro>();
            for (Registro reg : requisicoes) {
                if (Funcoes.textoVazio(reg.getString("pac_datanasc"))) {
                    String msg = "Existem pacientes sem data de nascimento informada.\nO laborat\u00f3rio externo Diagn\u00f3sticos do Brasil exige esse item.";
                    Funcoes.mensagem(this, msg, 1);
                    ExportacaoParaDB.removerLote(codLabExterno, requisicoes, numeroLote, true, false, st, isColetaWeb, arquivar, agruparInterface);
                    retorno.setImprimiu(false);
                    return retorno;
                }
                novaLista.add(reg.clone());
            }
            if (!this.enviarLoteParaLabExterno(codLabExterno, numeroLote, configuracaoLabExterno, requisicoes, reenvio, listaRequisicoesSemAgrupamento, novaLista = ExportacaoParaDB.agruparMutiguia(novaLista, st, agruparGuiasInterface, digitosTuboFilial), st, isColetaWeb, digitosTuboFilial, digitosTuboRequisicao, impressoras.getImpressoraDiagnosticosBrasil(), tamanhoNomeImpressora, impressorasLocais, retorno, arquivar, anular, agruparInterface, agruparMultiguia, agruparGuiasInterface).isImprimiu()) {
                retorno.setImprimiu(false);
                UtilExportadores.adicionarMensagemRetorno("N\u00e3o foi poss\u00edvel conectar ao servidor. Verifique sua internet.", Protocolo.DBV2.getDescricao(), retorno);
                return retorno;
            }
            if (this.isGerarArquivo) {
                this.exportarExames(codLabExterno, numeroLote, configuracaoLabExterno, reenvio, requisicoes, this.colunaOrdenacao, isColetaWeb, agruparInterface, st, st2, st3, login, agruparGuiasInterface, imprimirEtiquetaTriagemSemMaterial, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, agruparEtqPorQtde, tipoExportacaoInterface, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, tuboPrimario, utilizarCapacidadeTuboPrimario, tipoIntegracao, tamanhoNomeImpressora, impressorasLocais, impressoras, tipoEtiquetaSoroteca, arquivar, anular, labSelecionado, agruparMultiguia);
            }
            retorno.setImprimiu(true);
            return retorno;
        }
        catch (Exception e) {
            if (e.getMessage().contains("500")) {
                Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o foi possivel obter conex\u00e3o com WebService do Diagn\u00f3stico Brasil.\nEntre em contato com o laborat\u00f3rio de apoio.", 1);
            } else {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel criar o lote solicitado.\n" + e.getMessage(), e.getStackTrace());
            }
            retorno.setImprimiu(false);
            return retorno;
        }
    }

    private RetornoImpressaoEtiquetas reenviarLote(boolean isColetaWeb, String codLabExterno, String numeroLote, String configuracaoLabExterno, List<Registro> requisicoes, boolean reenvio, int agruparInterface, Statement st, Statement st2, Statement st3, boolean agruparGuiasInterface, String imprimirEtiquetaTriagemSemMaterial, boolean imprimirEtiquetaColetaSemMaterial, boolean imprimirEtiquetaColetaSelecionadaSemMaterial, boolean agruparEtqPorQtde, String tipoExportacaoInterface, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario, String tipoIntegracao, String tamanhoNomeImpressora, String[] impressorasLocais, ImpressorasLabExterno impressoras, RetornoImpressaoEtiquetas retorno, String tipoEtiquetaSoroteca, Callable<Boolean> arquivar, Callable<Boolean> anular, LaboratorioExterno labSelecionado, boolean agruparMultiguia, String login) {
        this.reimprimirEtiquetasDBWS(configuracaoLabExterno, requisicoes, codLabExterno, isColetaWeb, st, impressoras.getImpressoraDiagnosticosBrasil(), tamanhoNomeImpressora, impressorasLocais, digitosTuboFilial, digitosTuboRequisicao, agruparGuiasInterface, retorno, arquivar, anular, agruparInterface, labSelecionado, agruparMultiguia, login);
        if (!retorno.isImprimiu() && this.isGerarArquivo) {
            return this.exportarExames(codLabExterno, numeroLote, configuracaoLabExterno, reenvio, requisicoes, this.colunaOrdenacao, isColetaWeb, agruparInterface, st, st2, st3, login, agruparGuiasInterface, imprimirEtiquetaTriagemSemMaterial, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, agruparEtqPorQtde, tipoExportacaoInterface, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, tuboPrimario, utilizarCapacidadeTuboPrimario, tipoIntegracao, tamanhoNomeImpressora, impressorasLocais, impressoras, tipoEtiquetaSoroteca, arquivar, anular, labSelecionado, agruparMultiguia);
        }
        return retorno;
    }

    private RetornoImpressaoEtiquetas enviarLoteParaLabExterno(String codLabExterno, String numeroLote, String configuracaoLabExterno, List<Registro> requisicoes, boolean reenvio, List<Registro> listaRequisicoesSemAgrupamento, List<Registro> novaLista, Statement st, boolean isColetaWeb, int digitosTuboFilial, int digitosTuboRequisicao, String impressora, String tamanhoNomeImpressora, String[] impressorasLocais, RetornoImpressaoEtiquetas retorno, Callable<Boolean> arquivar, Callable<Boolean> anular, int agruparInterface, boolean agruparMultiguia, boolean agruparGuiasInterface) throws Exception {
        DBComunicacao comunicacao = new DBComunicacao(configuracaoLabExterno);
        if (!comunicacao.configuracaoValida() || !comunicacao.hostValido(isColetaWeb)) {
            try {
                ExportacaoParaDB.removerLote(codLabExterno, requisicoes, numeroLote, true, false, st, isColetaWeb, arquivar, agruparInterface);
                retorno.setImprimiu(false);
                return retorno;
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel desfazer o lote solicitado.\n" + e.getMessage(), e.getStackTrace());
            }
        }
        for (Registro registro : novaLista) {
            ProcessaErroRetornoWebServiceDB erroRetornoWebServiceLabExterno;
            String xmlGerado = GeradorXmlEnviarLoteParaDB.geraXml(configuracaoLabExterno, registro, false, digitosTuboFilial, digitosTuboRequisicao);
            SplashMensagem splash = null;
            if (!isColetaWeb) {
                splash = SplashMensagem.getInstancia(this);
                splash.mostrar("Aguarde... Enviando lote para o Diagn\u00f3stico Brasil ");
            }
            if (this.debug) {
                System.out.println("=============Envio====================");
                System.out.println(xmlGerado);
                System.out.println("======================================");
            }
            String retornoDB = comunicacao.enviarLoteParaWebService(xmlGerado);
            if (this.debug) {
                System.out.println("=============Retorno====================");
                System.out.println(retornoDB);
                System.out.println("======================================");
            }
            if (!isColetaWeb) {
                splash.apagar();
            }
            this.dao.gravaEnvioRetornoDB(registro.getString(FIL_CODIGO), registro.getString(REQ_CODIGO), codLabExterno, numeroLote, xmlGerado, retornoDB, st, isColetaWeb);
            if (this.loteRecusado(retornoDB) && ((erroRetornoWebServiceLabExterno = new ProcessaErroRetornoWebServiceDB(retornoDB)).getRegistroRejeitado() || StringUtil.isEmpty(retornoDB))) {
                this.processaLoteRecusado(codLabExterno, numeroLote, reenvio, listaRequisicoesSemAgrupamento, st, isColetaWeb, retorno, arquivar, agruparInterface, erroRetornoWebServiceLabExterno, xmlGerado, configuracaoLabExterno);
                return retorno;
            }
            this.processaLote(codLabExterno, numeroLote, requisicoes, reenvio, st, isColetaWeb, digitosTuboFilial, digitosTuboRequisicao, impressora, tamanhoNomeImpressora, impressorasLocais, retorno, arquivar, anular, agruparInterface, agruparMultiguia, agruparGuiasInterface, registro, retornoDB);
        }
        return retorno;
    }

    private void processaLoteRecusado(String codLabExterno, String numeroLote, boolean reenvio, List<Registro> listaRequisicoesSemAgrupamento, Statement st, boolean isColetaWeb, RetornoImpressaoEtiquetas retorno, Callable<Boolean> arquivar, int agruparInterface, ProcessaErroRetornoWebServiceDB erroRetornoWebServiceLabExterno, String xmlGerado, String configuracaoLabExterno) throws Exception {
        if (!reenvio) {
            ExportacaoParaDB.removerLote(codLabExterno, listaRequisicoesSemAgrupamento, numeroLote, st, isColetaWeb, arquivar, agruparInterface);
        }
        if (!isColetaWeb) {
            VisualizaErroRetornoWebService.novaInstancia(Laboratorio.getInstancia(), "Mensagens ao enviar lotes", erroRetornoWebServiceLabExterno, true, "DB");
        } else {
            retorno.setNomeArquivoLote(String.format("%s_%s.xml", StringUtil.getValor(configuracaoLabExterno, "codigo"), numeroLote));
            retorno.setXmlLote(xmlGerado);
            retorno.setExtensaoArquivo("xml");
            UtilExportadores.adicionarMensagemRetorno(erroRetornoWebServiceLabExterno.getXmlErro(), Protocolo.DBV2.getDescricao(), retorno);
            retorno.setImprimiu(false);
        }
        retorno.setImprimiu(false);
    }

    private void processaLote(String codLabExterno, String numeroLote, List<Registro> requisicoes, boolean reenvio, Statement st, boolean isColetaWeb, int digitosTuboFilial, int digitosTuboRequisicao, String impressora, String tamanhoNomeImpressora, String[] impressorasLocais, RetornoImpressaoEtiquetas retorno, Callable<Boolean> arquivar, Callable<Boolean> anular, int agruparInterface, boolean agruparMultiguia, boolean agruparGuiasInterface, Registro registro, String retornoDB) throws SQLException {
        ParseErroRetornoWebServiceDB parseErroRetornoDB = new ParseErroRetornoWebServiceDB(retornoDB, registro, digitosTuboFilial);
        this.trataSituacaoErro(numeroLote, requisicoes, reenvio, st, isColetaWeb, digitosTuboFilial, digitosTuboRequisicao, retorno, arquivar, anular, agruparInterface, agruparMultiguia, agruparGuiasInterface, retornoDB, parseErroRetornoDB);
        if (!registro.possuiCampo("req_rejeitada") || !registro.getBoolean("req_rejeitada")) {
            this.processaRetornoWebService(retornoDB, requisicoes, codLabExterno, reenvio, numeroLote, digitosTuboFilial, isColetaWeb, impressora, tamanhoNomeImpressora, impressorasLocais, st, retorno, arquivar, anular);
            retorno.setImprimiu(true);
        }
    }

    private boolean loteRecusado(String retorno) {
        return ParseErroRetornoWebServiceDB.existeTag(retorno, DBCamposRetorno.TAG_PEDIDOS) && ParseErroRetornoWebServiceDB.existeTag(retorno, DBCamposRetorno.TAG_ERRO_STATUS_PEDIDO_V2) && ParseErroRetornoWebServiceDB.existeTag(retorno, DBCamposRetorno.TAG_ERRO_PEDIDO) && ParseErroRetornoWebServiceDB.existeTag(retorno, DBCamposRetorno.TAG_CT_ERRO_INTEGRACAO_V2);
    }

    private RetornoImpressaoEtiquetas reimprimirEtiquetasDBWS(String configuracaoLabExterno, List<Registro> requisicoes, String codLabExterno, boolean isColetaWeb, Statement st, String impressora, String tamanhoNomeImpressora, String[] impressorasLocais, int digitosTuboFilial, int digitosTuboRequisicao, boolean agruparGuiasInterface, RetornoImpressaoEtiquetas retorno, Callable<Boolean> arquivar, Callable<Boolean> anular, int agruparInterface, LaboratorioExterno labSelecionado, boolean agruparMultiguia, String login) {
        StringBuilder impressao = new StringBuilder();
        StringBuilder erroIntegracao = new StringBuilder();
        ArrayList<Registro> requisicoesNaoEnviadas = new ArrayList<Registro>();
        try {
            this.reimprimirRequisicoes(configuracaoLabExterno, requisicoes, codLabExterno, erroIntegracao, requisicoesNaoEnviadas, digitosTuboFilial, digitosTuboRequisicao, st, isColetaWeb, agruparGuiasInterface, arquivar, anular);
            if (!requisicoesNaoEnviadas.isEmpty()) {
                StringBuilder mensagem = new StringBuilder();
                mensagem.append("As requisi\u00e7\u00f5es abaixo n\u00e3o foram encontradas no lote enviado ao laborat\u00f3rio de apoio " + this.getNomeProtocolo(codLabExterno, st) + ": \n");
                for (Registro req : requisicoesNaoEnviadas) {
                    mensagem.append(req.getString(REQ_CODIGO) + ", ");
                }
                mensagem.replace(mensagem.length() - 2, mensagem.length(), "");
                mensagem.append("\n As mesmas ser\u00e3o estornadas para que sej\u00e1 poss\u00edvel reenvia-las em um novo lote.");
                UtilExportadores.adicionarMensagemRetorno(mensagem.toString(), Protocolo.DBV2.getDescricao(), retorno);
                SplashMensagem splash = null;
                if (!isColetaWeb) {
                    Funcoes.mensagem(Laboratorio.getInstancia(), mensagem.toString(), 2);
                    splash = SplashMensagem.getInstancia(this);
                    splash.mostrar("Aguarde... Estornando requisi\u00e7\u00f5es ");
                }
                super.estornarExames(codLabExterno, requisicoesNaoEnviadas, codLabExterno, isColetaWeb, st, arquivar, anular, agruparInterface, labSelecionado, agruparMultiguia, login, digitosTuboFilial, digitosTuboRequisicao);
                if (!isColetaWeb) {
                    splash.apagar();
                }
            } else if (!Funcoes.textoVazio(erroIntegracao.toString())) {
                if (!isColetaWeb) {
                    ProcessaErroRetornoWebServiceLabExterno erroRetornoWebServiceLabExterno = new ProcessaErroRetornoWebServiceLabExterno(erroIntegracao.toString(), "");
                    VisualizaErroRetornoWebService telaVisualizacaoErro = VisualizaErroRetornoWebService.novaInstancia(Laboratorio.getInstancia(), "Mensagens ao reimprimir etiquetas", erroRetornoWebServiceLabExterno, true, "Diagn\u00f3sticos do Brasil");
                    this.isGerarArquivo = telaVisualizacaoErro.isGerarArquivo();
                }
                UtilExportadores.adicionarMensagemRetorno(erroIntegracao.toString(), Protocolo.DBV2.getDescricao(), retorno);
                retorno.setImprimiu(false);
                return retorno;
            }
            this.imprimirEtiquetas(impressao, isColetaWeb, impressora, tamanhoNomeImpressora, impressorasLocais, st, retorno, arquivar, anular);
            retorno.setImprimiu(true);
            return retorno;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
            retorno.setImprimiu(false);
            return retorno;
        }
    }

    private void reimprimirRequisicoes(String configuracaoLabExterno, List<Registro> requisicoes, String codLabExterno, StringBuilder erroIntegracao, List<Registro> requisicoesNaoEnviadas, int digitosTuboFilial, int digitosTuboRequisicao, Statement st, boolean isColetaWeb, boolean agruparGuiasInterface, Callable<Boolean> arquivar, Callable<Boolean> anular) throws XMLStringBuilderException, SQLException {
        for (Registro req : requisicoes) {
            String numeroAtendimentoApoiado = Funcoes.preencheZero(req.getString(FIL_CODIGO), digitosTuboFilial) + Funcoes.preencheZero(req.getString(REQ_CODIGO), digitosTuboRequisicao);
            String xmlEnvio = GeradorXmlEnviaAmostraParaDB.geraXML(configuracaoLabExterno, numeroAtendimentoApoiado);
            DBComunicacao comunicacao = new DBComunicacao(configuracaoLabExterno);
            String retornoDB = comunicacao.enviarAmostraParaWebService(xmlEnvio);
            this.verificarErrosIntegracao(erroIntegracao, retornoDB);
            this.atualizarReenvioLote(codLabExterno, requisicoesNaoEnviadas, req, retornoDB, digitosTuboFilial, st, isColetaWeb, agruparGuiasInterface, arquivar, anular);
        }
    }

    private void atualizarReenvioLote(String codLabExterno, List<Registro> requisicoesNaoEnviadas, Registro req, String retornoDB, int digitosTuboFilial, Statement st, boolean isColetaWeb, boolean agruparGuiasInterface, Callable<Boolean> arquivar, Callable<Boolean> anular) throws SQLException {
        String filialRequisicao;
        if (retornoDB.indexOf(DBCamposRetorno.TAG_CONFIRMACAO_PEDIDO.getTag()) > -1 && !Funcoes.textoVazio(filialRequisicao = StringUtil.getValor(retornoDB, DBCamposRetorno.TAG_NUMERO_ATENDIMENTO_APOIADO.getTag()))) {
            String[] amostras = StringUtil.getValores(retornoDB, DBCamposRetorno.TAG_AMOSTRA_ETIQUETA.getTag());
            if (amostras.length > 0) {
                for (String amostra : amostras) {
                    String etiqueta = StringUtil.getValor(amostra, DBCamposRetorno.TAG_ETIQUETA_AMOSTRA.getTag()).replace("&#xD;", "");
                    this.atualizarDadosReenvioDeLote(req, codLabExterno, retornoDB, etiqueta, digitosTuboFilial, st, isColetaWeb, agruparGuiasInterface, arquivar, anular);
                }
            } else {
                requisicoesNaoEnviadas.add(req);
            }
        }
    }

    private void verificarErrosIntegracao(StringBuilder erroIntegracao, String retornoDB) {
        String registroRejeitado;
        if (retornoDB.indexOf("ct_ErroIntegracao_v2") > -1 && retornoDB.indexOf("Erro") > -1 && (registroRejeitado = StringUtil.getValor(retornoDB, "ct_ErroIntegracao_v2")).indexOf("Descricao") > -1) {
            String codigo = StringUtil.getValor(registroRejeitado, "Codigo");
            String descricao = StringUtil.getValor(registroRejeitado, "Descricao");
            String[] descricaoSplit = descricao.split("\\:");
            erroIntegracao.append(descricaoSplit[descricaoSplit.length - 1].replace("\\]", "").replace("\\>", "").trim()).append(" C\u00f3digo da mensagem: ").append(codigo).append("\n");
        }
    }

    private void atualizarDadosReenvioDeLote(Registro req, String codLabExterno, String retornoDB, String etiquetaRetorno, int digitosTuboFilial, Statement st, boolean isColetaWeb, boolean agruparGuiasInterface, Callable<Boolean> arquivar, Callable<Boolean> anular) throws SQLException {
        String filialRequisicao = StringUtil.getValor(retornoDB, DBCamposRetorno.TAG_NUMERO_ATENDIMENTO_APOIADO.getTag());
        String filial = "";
        if (!Funcoes.textoVazio(filialRequisicao)) {
            filial = StringUtil.removeZerosEsquerda(filialRequisicao.substring(0, digitosTuboFilial));
        }
        List exames = (List)req.getValor("listaexames");
        this.interpretarRetornoAtualizarRequisicao(retornoDB, exames, st, isColetaWeb, arquivar, anular);
        String[] codExames = new String[exames.size()];
        int[] codMateriais = new int[exames.size()];
        for (int i = 0; i < exames.size(); ++i) {
            codExames[i] = ((Registro)exames.get(i)).getString(EXA_CODIGO);
            codMateriais[i] = ((Registro)exames.get(i)).getInt(MCO_CODIGO);
        }
        Integer[] multiguias = ExportacaoParaDB.validaMultiguia(req, codLabExterno, st, agruparGuiasInterface);
        String retornoWS = this.dao.pesquisarEtiquetaDBWSPorRequisicao(filial, multiguias, codExames, codMateriais, st);
        if (Funcoes.textoVazio(retornoWS)) {
            for (Integer guia : multiguias) {
                String codigoTuboApoio = StringUtil.getValor(retornoDB, DBCamposRetorno.TAG_NUMERO_ATENDIMENTO_DB.getTag());
                this.dao.atualizarEtiquetasLoteExternoRequisicao(etiquetaRetorno, codigoTuboApoio, codLabExterno, guia.toString(), filial, req.getString("lex_codigo"), st, isColetaWeb);
            }
        }
    }

    private void interpretarRetornoAtualizarRequisicao(String retornoDB, List<Registro> exames, Statement st, boolean isColetaWeb, Callable<Boolean> arquivar, Callable<Boolean> anular) throws SQLException {
        if (retornoDB.indexOf(DBCamposRetorno.TAG_CONFIRMACAO_PEDIDO.getTag()) > -1) {
            String[] amostras;
            for (String amostra : amostras = StringUtil.getValores(retornoDB, DBCamposRetorno.TAG_AMOSTRA_ETIQUETA.getTag())) {
                String[] examesDB = StringUtil.getValor(amostra, DBCamposRetorno.TAG_EXAMES.getTag()).split(";");
                String numeroAmostra = StringUtil.getValor(amostra, DBCamposRetorno.TAG_NUMERO_AMOSTRA.getTag());
                this.analisarExames(exames, examesDB, numeroAmostra, st, isColetaWeb, arquivar, anular);
            }
        }
    }

    private void analisarExames(List<Registro> exames, String[] examesDB, String numeroAmostra, Statement st, boolean isColetaWeb, Callable<Boolean> arquivar, Callable<Boolean> anular) throws SQLException {
        for (String exaRetornoDB : examesDB) {
            for (Registro exame : exames) {
                List examesDesm = (List)exame.getValor("listaexames");
                if (examesDesm != null && !examesDesm.isEmpty()) {
                    this.atualizarDesmembrado(numeroAmostra, exaRetornoDB, exame, examesDesm, st, isColetaWeb, arquivar, anular);
                    continue;
                }
                this.atualizarExameSimples(numeroAmostra, exaRetornoDB, exame, st, isColetaWeb, arquivar, anular);
            }
        }
    }

    private void atualizarExameSimples(String numeroAmostra, String exaRetornoDB, Registro exame, Statement st, boolean isColetaWeb, Callable<Boolean> arquivar, Callable<Boolean> anular) throws SQLException {
        String exameDBJalis = StringUtil.getValor(exame.getString(ELE_XMLLABEXTERNO), "cd_db");
        if (exameDBJalis.equalsIgnoreCase(exaRetornoDB)) {
            this.dao.atualizaCodigoApoiadoExameRequisicao(Arrays.asList(exame), exame.getString(EXA_CODIGO), exame.getString(MCO_CODIGO), numeroAmostra, st, isColetaWeb, arquivar, anular);
        }
    }

    private void atualizarDesmembrado(String numeroAmostra, String exaRetornoDB, Registro exame, List<Registro> examesDesm, Statement st, boolean isColetaWeb, Callable<Boolean> arquivar, Callable<Boolean> anular) throws SQLException {
        for (Registro desm : examesDesm) {
            String exameDBJalis = StringUtil.getValor(desm.getString(ELE_XMLLABEXTERNO), "cd_db");
            if (!exameDBJalis.equalsIgnoreCase(exaRetornoDB)) continue;
            this.dao.atualizaCodigoApoiadoExameRequisicao(Arrays.asList(desm), exame.getString(EXA_CODIGO), exame.getString(MCO_CODIGO), numeroAmostra, st, isColetaWeb, arquivar, anular);
            break;
        }
    }

    private RetornoImpressaoEtiquetas processaRetornoWebService(String retornoDB, List<Registro> requisicoes, String codigoLabExterno, boolean reenvio, String numeroLote, int digitosTuboFilial, boolean isColetaWeb, String impressora, String tamanhoNomeImpressora, String[] impressorasLocais, Statement st, RetornoImpressaoEtiquetas retorno, Callable<Boolean> arquivar, Callable<Boolean> anular) throws SQLException {
        String filialRequisicao;
        if (retornoDB.indexOf(DBCamposRetorno.TAG_CONFIRMACAO_PEDIDO.getTag()) > -1 && !Funcoes.textoVazio(filialRequisicao = StringUtil.getValor(retornoDB, DBCamposRetorno.TAG_NUMERO_ATENDIMENTO_APOIADO.getTag()))) {
            StringBuilder impressao = new StringBuilder();
            String codigoTuboApoio = StringUtil.getValor(retornoDB, DBCamposRetorno.TAG_NUMERO_ATENDIMENTO_DB.getTag());
            this.analisarAmostrasParaAtualizacao(requisicoes, codigoLabExterno, reenvio, numeroLote, impressao, retornoDB, codigoTuboApoio, digitosTuboFilial, st, isColetaWeb, arquivar, anular);
            this.imprimirEtiquetas(impressao, isColetaWeb, impressora, tamanhoNomeImpressora, impressorasLocais, st, retorno, arquivar, anular);
        }
        return retorno;
    }

    private void analisarAmostrasParaAtualizacao(List<Registro> requisicoes, String codigoLabExterno, boolean reenvio, String numeroLote, StringBuilder impressao, String retornoDB, String codigoTuboApoio, int digitosTuboFilial, Statement st, boolean isColetaWeb, Callable<Boolean> arquivar, Callable<Boolean> anular) throws SQLException {
        String filialRequisicao = StringUtil.getValor(retornoDB, DBCamposRetorno.TAG_NUMERO_ATENDIMENTO_APOIADO.getTag());
        String filial = StringUtil.removeZerosEsquerda(filialRequisicao.substring(0, digitosTuboFilial));
        String[] amostras = StringUtil.getValores(retornoDB, DBCamposRetorno.TAG_AMOSTRA_ETIQUETA.getTag());
        String requisicao = StringUtil.removeZerosEsquerda(filialRequisicao.substring(digitosTuboFilial, filialRequisicao.length()));
        for (String amostra : amostras) {
            String numeroAmostra = StringUtil.getValor(amostra, DBCamposRetorno.TAG_NUMERO_AMOSTRA.getTag());
            String codigoExame = StringUtil.getValor(amostra, DBCamposRetorno.TAG_EXAMES.getTag());
            String etiqueta = StringUtil.getValor(amostra, DBCamposRetorno.TAG_ETIQUETA_AMOSTRA.getTag()).replace("&#xD;", "");
            for (Registro req : requisicoes) {
                ArrayList exames = (ArrayList)req.getValor("listaexames");
                boolean atualizar = false;
                if (!(atualizar = this.atualizarExameApoio(requisicoes, numeroAmostra, codigoExame, exames, atualizar, st, isColetaWeb, arquivar, anular)) || !req.getString(FIL_CODIGO).equalsIgnoreCase(filial) || !req.getString(REQ_CODIGO).equals(requisicao) && !req.getString("req_codigomae").equals(requisicao)) continue;
                String lote = !reenvio ? req.getString("novoLote") : numeroLote;
                this.dao.atualizarEtiquetasLoteExternoRequisicao(etiqueta, codigoTuboApoio, codigoLabExterno, req.getString(REQ_CODIGO), filial, lote, st, isColetaWeb);
            }
            impressao.append(etiqueta);
        }
    }

    private boolean atualizarExameApoio(List<Registro> requisicoes, String numeroAmostra, String codigoExame, ArrayList<Registro> exames, boolean atualizar, Statement st, boolean isColetaWeb, Callable<Boolean> arquivar, Callable<Boolean> anular) throws SQLException {
        block0: for (Registro exame : exames) {
            ArrayList examesDesm = (ArrayList)exame.getValor("listaexames");
            if (examesDesm != null && !examesDesm.isEmpty()) {
                for (Registro desm : examesDesm) {
                    String exameDBJalis = StringUtil.getValor(desm.getString(ELE_XMLLABEXTERNO), "cd_db");
                    if (!this.existeCodigoExameNaEtiqueta(codigoExame, exameDBJalis)) continue;
                    atualizar = true;
                    this.dao.atualizaCodigoApoiadoExameRequisicao(requisicoes, exame.getString(EXA_CODIGO), exame.getString(MCO_CODIGO), numeroAmostra, st, isColetaWeb, arquivar, anular);
                    continue block0;
                }
                continue;
            }
            String exameDBJalis = StringUtil.getValor(exame.getString(ELE_XMLLABEXTERNO), "cd_db");
            if (!this.existeCodigoExameNaEtiqueta(codigoExame, exameDBJalis)) continue;
            atualizar = true;
            this.dao.atualizaCodigoApoiadoExameRequisicao(requisicoes, exame.getString(EXA_CODIGO), exame.getString(MCO_CODIGO), numeroAmostra, st, isColetaWeb, arquivar, anular);
            break;
        }
        return atualizar;
    }

    private boolean existeCodigoExameNaEtiqueta(String codigoExame, String exameDBJalis) {
        String[] codigos;
        for (String cod : codigos = codigoExame.split(";")) {
            if (!cod.equalsIgnoreCase(exameDBJalis)) continue;
            return true;
        }
        return false;
    }

    private RetornoImpressaoEtiquetas imprimirEtiquetas(StringBuilder impressao, boolean isColetaWeb, String impressora, String tamanhoNomeImpressora, String[] impressorasLocais, Statement st, RetornoImpressaoEtiquetas retorno, Callable<Boolean> arquivar, Callable<Boolean> anular) {
        ArrayList<byte[]> etqs;
        List<byte[]> list = etqs = retorno.getEtiquetasLabExterno() != null && !retorno.getEtiquetasLabExterno().isEmpty() ? retorno.getEtiquetasLabExterno().get("db") : new ArrayList<byte[]>();
        if (!Funcoes.textoVazio(impressao.toString())) {
            PrintService service = Funcoes.localizarImpressora(Impressao.comparaNomeImpressoraReduzido(impressora, tamanhoNomeImpressora, impressorasLocais));
            etqs.add(ImpressaoTermica.imprimirDireto(service, impressao.toString(), true, st, isColetaWeb, arquivar, anular));
        }
        HashMap<String, List<byte[]>> etiquetasLab = new HashMap<String, List<byte[]>>();
        etiquetasLab.put("db", etqs);
        retorno.setEtiquetasLabExterno(etiquetasLab);
        return retorno;
    }

    @Override
    public byte[] imprimeRelatorio(boolean isColetaWeb, String codLabExterno, String numeroLote, List<Registro> requisicoesListaOriginal, int colunaOrdenacao, Statement st, int filialPadrao, int digitosTuboRequisicao, int digitosTuboFilial, String impressoraRelatorio) throws Exception {
        RelatorioSituacaoLote rel = new RelatorioSituacaoLote();
        ModeloGridTable modelo = rel.getModeloDados(st, new String[]{String.valueOf(numeroLote)}, new String[]{String.valueOf(codLabExterno)}, colunaOrdenacao, requisicoesListaOriginal, filialPadrao, digitosTuboRequisicao, digitosTuboFilial);
        if (modelo.getRowCount() > 0) {
            Gerador gerador = new Gerador(impressoraRelatorio);
            HashMap<String, Object> variaveis = new HashMap<String, Object>();
            variaveis.put("filtroLote", numeroLote);
            String xmlRelatorio = rel.getXMLRelatorio(st);
            if (!isColetaWeb) {
                JDialog dialogo = new JDialog((Frame)Laboratorio.getInstancia(), "Relat\u00f3rio de lote enviado");
                dialogo.setModal(true);
                dialogo.setSize(new Dimension(750, 600));
                dialogo.setLayout(new BorderLayout());
                gerador.setPai(dialogo.getContentPane());
                gerador.setPreVisualizar(true);
                gerador.setZoomPreVisualizar(0.5f);
                gerador.setAcaoFechar(dialogo::dispose);
                gerador.executar(xmlRelatorio, (TableModel)modelo, variaveis);
                ScreenUtil.centralizar(dialogo);
                dialogo.setVisible(true);
            } else {
                gerador.executar(xmlRelatorio, modelo, variaveis, false, true, isColetaWeb);
                return Impressao.gerarPdfRelatorio(gerador.getRelatorio(), xmlRelatorio);
            }
        }
        return new byte[0];
    }

    private void escreverSolicitante(EscreverXmlDB xml, Registro requisicao, boolean enviarMedicoRequisicao, Medico medicoPadrao) throws XMLStringBuilderException {
        if (enviarMedicoRequisicao) {
            xml.abrir(TAG_LISTA_SOLICITANTE);
            xml.escrever(TAG_NOME_SOLICITANTE, requisicao.getString("med_nome"));
            xml.escrever(TAG_CODIGO_CONSELHO, requisicao.getString("med_conselho"));
            xml.escrever(TAG_CODIGO_UF_CONSELHO_SOLICITANTE, requisicao.getString("med_uf"));
            xml.escrever(TAG_CODIGO_CONSELHO_SOLICITANTE, requisicao.getString("med_crm"));
            xml.fechar(TAG_LISTA_SOLICITANTE);
        } else if (medicoPadrao != null) {
            xml.abrir(TAG_LISTA_SOLICITANTE);
            xml.escrever(TAG_NOME_SOLICITANTE, medicoPadrao.getNome());
            xml.escrever(TAG_CODIGO_CONSELHO, medicoPadrao.getConselho());
            xml.escrever(TAG_CODIGO_UF_CONSELHO_SOLICITANTE, medicoPadrao.getUf());
            xml.escrever(TAG_CODIGO_CONSELHO_SOLICITANTE, medicoPadrao.getCrm());
            xml.fechar(TAG_LISTA_SOLICITANTE);
        }
    }

    private void escreverExames(EscreverXmlDB xml, List<Registro> exames) throws XMLStringBuilderException {
        xml.abrir(TAG_LISTA_PROCEDIMENTO);
        for (Registro exame : exames) {
            Map dadosAdicionais;
            ArrayList examesDesmembrados = (ArrayList)exame.getValor("listaexames");
            if (examesDesmembrados != null && !examesDesmembrados.isEmpty()) {
                this.escreverExameDesmembrado(xml, exame, examesDesmembrados);
                continue;
            }
            xml.abrir(TAG_CT_PROCEDIMENTO_V1);
            xml.escrever(TAG_CODIGO_EXAME_DB, StringUtil.getValor(exame.getString(ELE_XMLLABEXTERNO), "cd_db"));
            if (!Funcoes.textoVazio(exame.getString(EXR_DESCRICAOMATERIAL))) {
                xml.escrever(TAG_DESCRICAO_REGIAO_COLETA, exame.getString(EXR_DESCRICAOMATERIAL));
            }
            if ((dadosAdicionais = exame.getValor("dadosAdicionais", Map.class)) != null && dadosAdicionais.containsKey("Volume")) {
                this.escreveValorUrinario(xml, dadosAdicionais);
            } else {
                xml.escrever(TAG_VOLUME_URINARIO, "0");
            }
            xml.fechar(TAG_CT_PROCEDIMENTO_V1);
        }
        xml.fechar(TAG_LISTA_PROCEDIMENTO);
    }

    private void escreverExameDesmembrado(EscreverXmlDB xml, Registro exame, ArrayList<Registro> examesDesmembrados) throws XMLStringBuilderException {
        for (Registro exameDesmembrado : examesDesmembrados) {
            Map dadosAdicionais;
            xml.abrir(TAG_CT_PROCEDIMENTO_V1);
            xml.escrever(TAG_CODIGO_EXAME_DB, StringUtil.getValor(exameDesmembrado.getString(ELE_XMLLABEXTERNO), "cd_db"));
            if (!Funcoes.textoVazio(exame.getString(EXR_DESCRICAOMATERIAL))) {
                xml.escrever(TAG_DESCRICAO_REGIAO_COLETA, exame.getString(EXR_DESCRICAOMATERIAL));
            }
            if ((dadosAdicionais = exameDesmembrado.getValor("dadosAdicionais", Map.class)) != null && dadosAdicionais.containsKey("Volume")) {
                this.escreveValorUrinario(xml, dadosAdicionais);
            } else {
                xml.escrever(TAG_VOLUME_URINARIO, "0");
            }
            xml.fechar(TAG_CT_PROCEDIMENTO_V1);
        }
    }

    private void escreveValorUrinario(EscreverXmlDB xml, Map<String, String> dadosAdicionais) {
        String valorUrinario = dadosAdicionais.get("Volume");
        valorUrinario = new BigDecimal(valorUrinario).toBigInteger().toString();
        xml.escrever(TAG_VOLUME_URINARIO, valorUrinario);
    }

    private void escreverRequisicao(EscreverXmlDB xml, Registro requisicao, TipoObservacao tipoObservacao, int digitosTuboFilial, int digitosTuboRequisicao) throws ParseException {
        String dado;
        String dado2;
        xml.escrever(TAG_NUMERO_ATENDIMENTO_APOIADO, this.getCodigo(requisicao.getString(FIL_CODIGO), requisicao.getString(REQ_CODIGO), digitosTuboFilial, digitosTuboRequisicao));
        xml.escrever(TAG_CODIGO_PRIORIDADE, requisicao.getBoolean("req_urgente") ? "U" : "R");
        xml.escrever(TAG_DESCRICAO_DADOS_CLINICOS, requisicao.getString(tipoObservacao.getCodigo()));
        xml.escrever(TAG_DESCRICAO_MEDICAMENTOS, "");
        xml.escrever(TAG_DATA_HORA_DUM, Funcoes.formataData("yyyy-MM-dd", requisicao.getDate("req_dum")));
        String altura = Funcoes.textoVazio(requisicao.getString(REQ_ALTURA2)) ? "" : Funcoes.formataDecimal(requisicao.getDouble(REQ_ALTURA2)).replace(',', '.');
        String confirmarDados = this.getDadosAdicionais("confirmar", (ArrayList)requisicao.getValor("listaexames"));
        if ((Funcoes.textoVazio(altura) || requisicao.getDouble(REQ_ALTURA2) == 0.0 || !Funcoes.textoVazio(confirmarDados) && "true".equalsIgnoreCase(confirmarDados)) && !Funcoes.textoVazio(dado2 = this.getDadosAdicionais("Altura", (ArrayList)requisicao.getValor("listaexames")))) {
            altura = dado2;
        }
        xml.escrever("Altura", altura);
        Double peso = Funcoes.textoVazio(requisicao.getString("req_peso")) ? 0.0 : requisicao.getDouble("req_peso");
        if ((peso <= 0.0 || !Funcoes.textoVazio(confirmarDados) && "true".equalsIgnoreCase(confirmarDados)) && !Funcoes.textoVazio(dado = this.getDadosAdicionais(TAG_PESO, (ArrayList)requisicao.getValor("listaexames")))) {
            peso = Double.valueOf(dado);
        }
        xml.escrever(TAG_PESO, peso != null ? Funcoes.formataDecimal(peso).replace(',', '.') : "");
    }

    private String getDadosAdicionais(String dadoAdicional, ArrayList<Registro> exames) {
        for (Registro registro : exames) {
            String dadosAdicionais = registro.getString("dadosAdicionais");
            if (Funcoes.textoVazio(registro.getString("dadosAdicionais")) || !dadosAdicionais.contains(dadoAdicional)) continue;
            String[] adicionais = dadosAdicionais.split(",");
            this.getAdicional(adicionais, dadoAdicional);
        }
        return null;
    }

    private String getAdicional(String[] adicionais, String dadoAdicional) {
        for (String adicional : adicionais) {
            String campo = adicional.trim().substring(adicional.trim().indexOf("{") + 1, adicional.trim().indexOf("="));
            if (!campo.equalsIgnoreCase(dadoAdicional)) continue;
            Integer posicaoF = adicional.length();
            if (adicional.contains("}")) {
                posicaoF = adicional.indexOf("}");
            }
            return adicional.substring(adicional.indexOf("=") + 1, posicaoF);
        }
        return null;
    }

    private String getCodigo(String filial, String id, int digitosTuboFilial, int digitosTuboRequisicao) {
        return String.format("%s%s", Funcoes.preencheZero(filial, digitosTuboFilial), Funcoes.preencheZero(id, digitosTuboRequisicao));
    }

    private void escreverPaciente(EscreverXmlDB xml, Registro requisicao, List<Registro> exames, int digitosTuboFilial, int digitosTuboRequisicao) throws ParseException, XMLStringBuilderException {
        xml.abrir(TAG_LISTA_PACIENTE_APOIADO);
        xml.escrever(TAG_RG_PACIENTE_APOIADO, this.getCodigo(requisicao.getString(FIL_CODIGO), requisicao.getString("pac_codigo"), digitosTuboFilial, digitosTuboRequisicao));
        xml.escrever(TAG_NOME_PACIENTE, this.ajustaEspacamentoPaciente(requisicao.getString("pac_nome")));
        xml.escrever(TAG_SEXO_PACIENTE, this.verificaSexoPaciente(requisicao));
        xml.escrever(TAG_DATA_HORA_PACIENTE, Funcoes.formataData("yyyy-MM-dd", requisicao.getDate("pac_datanasc")));
        String cpf = "";
        String cartaoSus = "";
        for (Registro registro : exames) {
            cpf = registro.getString("pac_cpf");
            cartaoSus = registro.getString("pac_cartaosus");
        }
        xml.escrever(TAG_NUMERO_CPF, !Funcoes.textoVazio(cpf) ? StringUtil.limpaString(cpf, new String[]{",", ".", "/", "-"}) : "");
        xml.escrever(TAG_NUMERO_CARTAO_NACIONAL_SAUDE, cartaoSus);
        xml.fechar(TAG_LISTA_PACIENTE_APOIADO);
    }

    private String verificaSexoPaciente(Registro requisicao) {
        if (requisicao.getString("pac_sexo").equals("M")) {
            return "M";
        }
        return requisicao.getString("pac_sexo").equals("F") ? "F" : "I";
    }

    @Override
    public int getMaiorCodigoLote(String numeroLote, String codigoConvenio, LaboratorioExterno configuracaoLabExterno, Statement st) {
        return this.dao.getMaiorCodigoLote(numeroLote, codigoConvenio, configuracaoLabExterno, st);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void escreverArquivo(File arquivo, String xml) {
        BufferedWriter writer = null;
        try (FileWriter fileWriter = new FileWriter(arquivo);){
            writer = new BufferedWriter(fileWriter);
            writer.write("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n" + xml);
            writer.close();
        }
        catch (IOException e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
                }
            }
        }
    }

    public boolean exportarExames() {
        return false;
    }

    public RetornoImpressaoEtiquetas imprimirEtiquetaDBWS(String filial, String requisicao, LaboratorioExterno labExterno, String[] exames, int[] materiais, boolean isColetaWeb, Statement st, String impressora, String tamanhoNomeImpressora, String[] impressorasLocais, RetornoImpressaoEtiquetas retornoEtiquetas, Callable<Boolean> arquivar, Callable<Boolean> anular) {
        ArrayList<Object> etqs = new ArrayList<Object>();
        Integer[] multiguias = null;
        String etiqueta = "";
        try {
            multiguias = RecepcaoUtil.verificaMultiGuias(st, filial, requisicao, true, false);
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e2o foi recuperar as requisi\u00e7\u00f5es multiguia\n" + e.getMessage(), e.getStackTrace());
        }
        if (labExterno != null && !Funcoes.textoVazio(requisicao)) {
            try {
                String retorno = this.dao.pesquisarEtiquetaDBWSPorRequisicao(filial, multiguias, exames, materiais, st);
                String[] etiquetas = StringUtil.getValores(retorno, "etiqueta");
                etiqueta = StringUtil.implode(this.removeEtiquetaDuplicada(etiquetas), " ");
                PrintService service = Funcoes.localizarImpressora(Impressao.comparaNomeImpressoraReduzido(impressora, tamanhoNomeImpressora, impressorasLocais));
                etqs.add(ImpressaoTermica.imprimirDireto(service, etiqueta, true, st, isColetaWeb, arquivar, anular));
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e2o foi poss\u00edvel verificar lote externo.\n" + e.getMessage(), e.getStackTrace());
            }
            HashMap<String, List<byte[]>> etiquetasLab = new HashMap<String, List<byte[]>>();
            ArrayList etq = retornoEtiquetas.getEtiquetasLabExterno() != null && !retornoEtiquetas.getEtiquetasLabExterno().isEmpty() ? retornoEtiquetas.getEtiquetasLabExterno().get("db") : new ArrayList();
            etqs.addAll(etq);
            etiquetasLab.put("db", etqs);
            retornoEtiquetas.setEtiquetasLabExterno(etiquetasLab);
        }
        return retornoEtiquetas;
    }

    private ArrayList<String> removeEtiquetaDuplicada(String[] etiquetas) {
        ArrayList<String> novaEtiqueta = new ArrayList<String>();
        for (String etq : etiquetas) {
            if (novaEtiqueta.contains(etq)) continue;
            novaEtiqueta.add(etq);
        }
        return novaEtiqueta;
    }

    private String ajustaEspacamentoPaciente(String nomePaciente) {
        String firstChar = nomePaciente.substring(0, 1);
        if (Funcoes.textoVazio(firstChar)) {
            nomePaciente = nomePaciente.substring(1, nomePaciente.length());
        }
        String lastChar = "";
        do {
            if (!Funcoes.textoVazio(lastChar = nomePaciente.substring(nomePaciente.length() - 1, nomePaciente.length()))) continue;
            nomePaciente = nomePaciente.substring(0, nomePaciente.length() - 1);
        } while (Funcoes.textoVazio(lastChar));
        return nomePaciente;
    }

    private String getNomeProtocolo(String codigoLaboratorioExterno, Statement st) {
        String nomeLaboratorioExternoString = "";
        StringBuilder buf = new StringBuilder("select lae_descricao from labexterno ");
        buf.append("where fil_codigo = ").append(Variaveis.filialPadrao);
        buf.append(" and lae_codigo = ").append(codigoLaboratorioExterno);
        try {
            ResultSet rs = st.executeQuery(buf.toString());
            if (rs.next()) {
                nomeLaboratorioExternoString = rs.getString("lae_descricao");
            }
            st.close();
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ExportacaoParaDB (1085)");
        }
        return nomeLaboratorioExternoString;
    }

    @Override
    public RetornoEstornarLote estornarExames(String codLabExterno, List<Registro> requisicoes, String numeroLote, boolean isColetaWeb, Statement st, Callable<Boolean> arquivar, Callable<Boolean> anular, int agruparInterface, LaboratorioExterno labSelecionado, boolean agruparMultiguia, String login, int digitosTuboFilial, int digitosTuboRequisicao) throws NumberFormatException, Exception {
        RetornoEstornarLote retornoEstorno = new RetornoEstornarLote();
        SplashMensagem splash = null;
        if (!isColetaWeb) {
            splash = SplashMensagem.getInstancia(this);
            splash.mostrar("Aguarde enquanto comunicamos com o Laborat\u00f3rio Diagn\u00f3stico Brasil");
        }
        DBService serviceDB = new DBService();
        serviceDB.estornarExame(isColetaWeb, numeroLote, requisicoes, labSelecionado, agruparMultiguia, digitosTuboFilial, digitosTuboRequisicao, arquivar, anular, agruparInterface, agruparMultiguia, st, retornoEstorno);
        String retorno = this.trataRetornoDB(serviceDB);
        if (!Funcoes.textoVazio(retorno)) {
            if (!isColetaWeb) {
                splash.apagar();
                ProcessaErroRetornoWebServiceLabExterno erroRetornoWebServiceLabExterno = new ProcessaErroRetornoWebServiceLabExterno(retorno, retorno);
                VisualizaErroRetornoWebService.novaInstancia(Laboratorio.getInstancia(), "Estorno Lab. Diagn\u00f3stico Brasil.", erroRetornoWebServiceLabExterno, false, "Diagn\u00f3stico Brasil");
            } else {
                retornoEstorno.setMensagem(retorno);
            }
        }
        if (!isColetaWeb) {
            splash.apagar();
        }
        arquivar.call();
        return retornoEstorno;
    }

    private String trataRetornoDB(DBService serviceDB) {
        Integer n;
        Integer n2;
        String mensagem = "";
        StringBuilder retorno = new StringBuilder();
        Integer contador = 0;
        if (serviceDB.getListaAndamento() != null && serviceDB.getListaAndamento().size() > 0) {
            for (String exames : serviceDB.getListaAndamento().values()) {
                mensagem = contador > 0 && contador < serviceDB.getListaAndamento().size() ? mensagem + ", " + exames : exames;
                n2 = contador;
                n = contador = Integer.valueOf(contador + 1);
            }
            retorno.append("O(s) exame(s) da requisi\u00e7\u00e3o n\u00e3o podem ser cancelados, porque j\u00e1 est\u00e3o em andamento no Laborat\u00f3rio Diagn\u00f3stico Brasil: \n");
            retorno.append(mensagem);
        }
        if (serviceDB.getListaNaoEstornados() != null && serviceDB.getListaNaoEstornados().size() > 0) {
            for (String exames : serviceDB.getListaNaoEstornados().values()) {
                mensagem = contador > 0 && contador < serviceDB.getListaNaoEstornados().size() ? mensagem + ", " + exames : exames;
                n2 = contador;
                n = contador = Integer.valueOf(contador + 1);
            }
            retorno.append("O(s) exame(s) da requisi\u00e7\u00e3o n\u00e3o podem ser cancelados.\n").append(mensagem).append("\n" + serviceDB.getMensagemRetorno());
            retorno.append(serviceDB.getMensagemErroIntegracao());
        }
        retorno.append(serviceDB.getMensagemRetorno()).append("\n").append(serviceDB.getMensagemErroIntegracao());
        return retorno.toString();
    }

    private void trataSituacaoErro(String numeroLote, List<Registro> requisicoes, boolean reenvio, Statement st, boolean isColetaWeb, int digitosTuboFilial, int digitosTuboRequisicao, RetornoImpressaoEtiquetas retorno, Callable<Boolean> arquivar, Callable<Boolean> anular, int agruparInterface, boolean agruparMultiguia, boolean agruparGuiasInterface, String retornoDB, ParseErroRetornoWebServiceDB parseErroRetornoDB) throws SQLException {
        if (!parseErroRetornoDB.getListaErroRetornoDB().isEmpty() || StringUtil.isEmpty(retornoDB)) {
            if (!reenvio) {
                if (!Funcoes.textoVazio(numeroLote)) {
                    parseErroRetornoDB.getRegistroEstornado().setValor("lex_codigo", numeroLote);
                }
                RetornoEstornarLote retornoEstorno = new RetornoEstornarLote();
                new DBService().estornarExame(isColetaWeb, numeroLote, requisicoes, this.labSelecionado, agruparMultiguia, digitosTuboFilial, digitosTuboRequisicao, arquivar, anular, agruparInterface, agruparGuiasInterface, st, retornoEstorno, true, parseErroRetornoDB.getRegistroEstornado());
            }
            if (!isColetaWeb) {
                if (parseErroRetornoDB.isExamesDesmRejeitado()) {
                    Funcoes.mensagem(Laboratorio.getInstancia(), "Houveram exames desmembrados recusados pelo Laborat\u00f3rio de Apoio DB, estorne o lote no laborat\u00f3rio externo para tentar envia-los novamente", 2);
                }
                AlertaErroRetornoWebServiceDB.novaInstancia(Laboratorio.getInstancia(), parseErroRetornoDB.getListaErroRetornoDB());
            } else {
                retorno.setListaErroRetornoDB(parseErroRetornoDB.getListaErroRetornoDB());
                retorno.setImprimiu(false);
            }
        }
    }
}

