/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.externo.exportadores.db2;

import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.triagem.externo.DadosAdicionais;
import jalis.laboratorio.triagem.externo.exportadores.InfoComplementar;
import jalis.laboratorio.util.parsers.db2.ParserImportacaoDB;
import jalis.service.exportadores.DadosAdicionaisService;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DadosAdicionaisDB
extends JDialog
implements DadosAdicionais,
ActionListener {
    transient List<InfoComplementar> dados;
    transient Registro requisicao;
    private static final String REQ_CODIGO = "req_codigo";
    private static final String EXA_CODIGO = "exa_codigo";
    private static final String MCO_CODIGO = "mco_codigo";
    private static final String EXR_VOLUMEDIURESE = "exr_volumediurese";
    private static final String PAC_CODIGO = "pac_codigo";
    JPanel panelExame = new JPanel(new GridBagLayout());
    JPanel panelDados = new JPanel(new GridBagLayout());
    JPanel panelBotoes = new JPanel(new FlowLayout(2));
    JButton botaoOk = ComponenteFactory.novoJButton("Ok", 'O', this);
    JButton botaoCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this);
    JLabel labelExame = new JLabel();
    JLabel labelRequisicao = new JLabel();
    private static boolean isConfirmarDados = false;
    private transient DadosAdicionaisService service;

    public DadosAdicionaisDB() {
        super(Laboratorio.getInstancia());
        this.setModal(true);
        this.setLayout(new BorderLayout());
        this.add((Component)this.panelDados, "Center");
        this.panelBotoes.add(this.botaoOk);
        this.panelBotoes.add(this.botaoCancelar);
        this.add((Component)this.panelBotoes, "South");
        this.add((Component)this.panelExame, "North");
        this.setTitle("Dados Adicionais");
        Funcoes.montaEnter((JComponent)this.panelDados);
        Funcoes.montaEnter((JComponent)this.panelBotoes);
        this.service = new DadosAdicionaisService();
    }

    public void configurarDadosAdicionais(List<InfoComplementar> dados, String exame, String requisicao, String paciente) {
        this.dados = dados;
        GridBagConstraints c = new GridBagConstraints();
        this.labelExame.setText("Exame: " + exame);
        this.labelRequisicao.setText("Requisi\u00e7\u00e3o:" + requisicao + " - " + paciente);
        this.panelExame.removeAll();
        this.panelExame.setLayout(new GridBagLayout());
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = 0;
        this.panelExame.add((Component)this.labelRequisicao, c);
        ++c.gridy;
        this.panelExame.add((Component)this.labelExame, c);
        int i = 0;
        TTextField editDadoPrimeiro = null;
        this.panelDados.removeAll();
        this.panelDados.setLayout(new GridBagLayout());
        c = new GridBagConstraints();
        c.anchor = 17;
        for (InfoComplementar dado : dados) {
            TTextField editDado;
            if (!Boolean.TRUE.equals(dado.getIsObrigatorio())) continue;
            JLabel labelDado = new JLabel(dado.getNome());
            JLabel labelUnidade = new JLabel(dado.getUnidade());
            c.gridx = 0;
            c.weightx = 0.0;
            c.fill = 0;
            if (dado.getTag().equals("Volume")) {
                editDado = new TTextField(4, 1);
                editDado.setText(dado.getValor().toString());
            } else if (dado.getTag().equals("Altura")) {
                editDado = new TTextField(3, 2);
                editDado.setText(dado.getValor().toString());
            } else if (dado.getTag().equals("Peso")) {
                editDado = new TTextField(5, 2);
                editDado.setText(dado.getValor().toString());
            } else {
                editDado = ComponenteFactory.novoTTextField(15, 3);
            }
            this.panelDados.add((Component)labelDado, c);
            editDado.setPreferredSize(new Dimension(100, 20));
            editDado.setName(dado.getTag());
            c.gridx = 1;
            c.weightx = 1.0;
            c.fill = 2;
            this.panelDados.add((Component)editDado, c);
            c.gridx = 2;
            c.weightx = 0.0;
            c.fill = 0;
            this.panelDados.add((Component)labelUnidade, c);
            if (editDadoPrimeiro == null) {
                editDadoPrimeiro = editDado;
            }
            c.gridy = i + 1;
            ++i;
        }
        if (editDadoPrimeiro != null) {
            ScreenUtil.requisitarFoco(editDadoPrimeiro);
        }
        this.setLocationRelativeTo(this.getParent());
        this.pack();
    }

    @Override
    public boolean carregaAdicionais(String codLabExterno, Registro requisicao) {
        ArrayList exames = (ArrayList)requisicao.getValor("listaexames");
        if (exames == null || exames.isEmpty()) {
            return true;
        }
        ArrayList examesDB = (ArrayList)exames.clone();
        this.requisicao = requisicao;
        for (Registro r : exames) {
            if (this.carregaDadosAdicionais(codLabExterno, r, requisicao)) continue;
            examesDB.remove(r);
        }
        if (examesDB.isEmpty()) {
            return false;
        }
        requisicao.setValor("listaexames", examesDB);
        return true;
    }

    private boolean carregaDadosAdicionais(String codLabExterno, Registro exa, Registro requisicao) {
        try {
            boolean temInfoComplementares;
            HashMap<String, String> dadosComValores = new HashMap<String, String>();
            String xml = this.service.getXMLExame(exa, codLabExterno);
            Registro exameDB = ParserImportacaoDB.getExame(xml, exa.getString(EXA_CODIGO), exa.getString(MCO_CODIGO));
            List<InfoComplementar> infoComplementares = this.service.carregaInfoComplementarDB(exameDB, exa, this.requisicao);
            boolean bl = temInfoComplementares = !this.service.contemValores(infoComplementares) || isConfirmarDados && !infoComplementares.isEmpty();
            if (infoComplementares == null || infoComplementares.isEmpty()) {
                return true;
            }
            if (temInfoComplementares) {
                this.configurarDadosAdicionais(infoComplementares, exa.getString(EXA_CODIGO), requisicao.getString(REQ_CODIGO), requisicao.getString(PAC_CODIGO));
                this.setVisible(true);
                return this.atualizaComponentes(exa, dadosComValores);
            }
            for (InfoComplementar info : infoComplementares) {
                DadosAdicionaisDB.atualizaValores(info.getValor().toString(), info.getTag(), exa, dadosComValores);
                this.atualizaValoresRequisicao(info.getValor().toString(), info.getTag(), requisicao);
            }
            return true;
        }
        catch (SQLException e) {
            return false;
        }
    }

    private boolean atualizaComponentes(Registro exa, HashMap<String, String> dadosComValores) {
        for (Component c : this.panelDados.getComponents()) {
            block4: {
                block3: {
                    if (!(c instanceof TTextField)) continue;
                    TTextField textField = (TTextField)c;
                    if (Funcoes.textoVazio(textField)) break block3;
                    String[] stringArray = new String[]{",", ".", "/", "-"};
                    if (!(Double.valueOf(StringUtil.limpaString(textField.getText(), stringArray)) <= 0.0)) break block4;
                }
                Funcoes.mensagem(this, "O exame " + exa.getString(EXA_CODIGO) + " possui dados adicionais que n\u00e3o foram preenchidos!", 5);
                return false;
            }
            String valor = ((TTextField)c).getText();
            String nomeCampo = ((TTextField)c).getName();
            DadosAdicionaisDB.atualizaValores(valor, nomeCampo, exa, dadosComValores);
            this.atualizaValoresRequisicao(valor, nomeCampo, this.requisicao);
        }
        return true;
    }

    private void atualizaValoresRequisicao(String valor, String nomeCampo, Registro requisicao) {
        float v;
        boolean isPeso = nomeCampo.contains("Peso");
        boolean isAltura = nomeCampo.contains("Altura");
        String nomeCampoRequisicao = null;
        float f = v = !Funcoes.textoVazio(valor = valor.replace(",", ".")) && Funcoes.isNumeric(valor) ? Float.valueOf(valor).floatValue() : 0.0f;
        if (isPeso) {
            int peso = Math.round(v);
            valor = String.valueOf(peso);
            nomeCampoRequisicao = "req_peso";
        }
        if (isAltura) {
            String altura;
            valor = altura = valor.replace(".", "");
            nomeCampoRequisicao = "req_altura";
        }
        valor = StringUtil.limpaString(valor, new String[]{",", ".", "/", "-"});
        if (!Funcoes.objectIsNull(nomeCampoRequisicao)) {
            requisicao.setValor(nomeCampoRequisicao, valor);
        }
    }

    public static void atualizaValores(String valor, String nomeCampo, Registro exa, HashMap<String, String> dadosComValores) {
        float v;
        boolean isVolume = nomeCampo.contains("Volume");
        boolean isPeso = nomeCampo.contains("Peso");
        boolean isAltura = nomeCampo.contains("Altura");
        float f = v = !Funcoes.textoVazio(valor = valor.replace(",", ".")) && Funcoes.isNumeric(valor) ? Float.valueOf(valor).floatValue() : 0.0f;
        if (isVolume) {
            valor = String.valueOf((int)v);
            exa.setValor(EXR_VOLUMEDIURESE, valor);
        }
        if (isPeso) {
            int peso = Math.round(v);
            valor = String.valueOf(peso);
        }
        if (isAltura) {
            String altura;
            valor = altura = valor.replace(".", "");
        }
        valor = StringUtil.limpaString(valor, new String[]{",", ".", "/", "-"});
        dadosComValores.put(nomeCampo, valor);
        dadosComValores.put("confirmar", String.valueOf(isConfirmarDados));
        exa.setValor("dadosAdicionais", dadosComValores);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.botaoOk) {
            this.setVisible(false);
        } else if (e.getSource() == this.botaoCancelar) {
            for (Component c : this.panelDados.getComponents()) {
                if (!(c instanceof TTextField)) continue;
                ((TTextField)c).setText("");
            }
            this.setVisible(false);
        }
    }

    @Override
    public boolean carregaAdicionais(String codLabExterno, Registro requisicao, boolean isConfirmarDados) {
        DadosAdicionaisDB.isConfirmarDados = isConfirmarDados;
        return this.carregaAdicionais(codLabExterno, requisicao);
    }
}

