/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.externo.exportadores.db2;

import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.cadastro.exame.externo.LaboratorioExternoException;
import jalis.laboratorio.triagem.externo.LaboratorioExterno;
import jalis.laboratorio.triagem.externo.RetornoEstornarLote;
import jalis.laboratorio.triagem.externo.exportadores.IntegracaoLabExterno;
import jalis.laboratorio.triagem.externo.exportadores.db2.DBCamposRetorno;
import jalis.laboratorio.triagem.externo.exportadores.db2.DBComunicacao;
import jalis.laboratorio.triagem.externo.exportadores.db2.GeradorXmlEnviarLoteParaDB;
import jalis.model.dao.triagem.LoteExternoRequisicaoDao;
import jalis.model.vo.triagem.LoteExternoRequisicaoVO;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DBService {
    private static final String REQ_CODIGO = "req_codigo";
    private static final String FIL_CODIGO = "fil_codigo";
    private static final String EXA_CODIGO = "exa_codigo";
    public static final String LISTA_EXAMES = "listaexames";
    public static final String STATUS_ESTORNO = "Aguardando";
    public static final String STATUS_ESTORNODIVULGADO = "Divulgado";
    public static final String STATUS_ESTORNOANDAMENTO = "Andamento";
    public static final String STATUS_ESTORNADO = "MPP";
    public static final String STATUS_PROCESSADO = "Processado";
    private HashMap<String, String> listaNaoEstornados;
    private HashMap<String, String> listaAndamento;
    private HashMap<String, String> listaEstornados;
    private String mensagemRetorno = "";
    private String mensagemErroIntegracao = "";

    public RetornoEstornarLote estornarExame(boolean isColetaWeb, String codigoLote, List<Registro> requisicoes, LaboratorioExterno labExterno, boolean agruparMultiguia, int digitosTuboFilial, int digitosTuboRequisicao, Callable<Boolean> arquivar, Callable<Boolean> anular, int agruparInterface, boolean agruparGuiasInterface, Statement st, RetornoEstornarLote retorno) throws SQLException {
        return this.estornarExame(isColetaWeb, codigoLote, requisicoes, labExterno, agruparMultiguia, digitosTuboFilial, digitosTuboRequisicao, arquivar, anular, agruparInterface, agruparGuiasInterface, st, retorno, false, null);
    }

    public RetornoEstornarLote estornarExame(boolean isColetaWeb, String codigoLote, List<Registro> requisicoes, LaboratorioExterno labExterno, boolean agruparMultiguia, int digitosTuboFilial, int digitosTuboRequisicao, Callable<Boolean> arquivar, Callable<Boolean> anular, int agruparInterface, boolean agruparGuiasInterface, Statement st, RetornoEstornarLote retorno, boolean isEstornoPorExame, Registro registro) throws SQLException {
        this.listaNaoEstornados = new HashMap();
        this.listaAndamento = new HashMap();
        this.listaEstornados = new HashMap();
        ArrayList<Registro> listaRequisicoesSemAgrupamento = new ArrayList<Registro>();
        String configuracaoLabExterno = labExterno.configuracao;
        try {
            boolean isProcessado = true;
            if (isEstornoPorExame) {
                isProcessado = this.estornoExamePorRegistro(isColetaWeb, codigoLote, labExterno, agruparMultiguia, digitosTuboFilial, digitosTuboRequisicao, arquivar, anular, agruparInterface, agruparGuiasInterface, st, listaRequisicoesSemAgrupamento, configuracaoLabExterno, registro, true);
            } else {
                for (Registro requisicao : requisicoes) {
                    isProcessado = this.estornoExamePorRegistro(isColetaWeb, codigoLote, labExterno, agruparMultiguia, digitosTuboFilial, digitosTuboRequisicao, arquivar, anular, agruparInterface, agruparGuiasInterface, st, listaRequisicoesSemAgrupamento, configuracaoLabExterno, requisicao, false);
                }
            }
            retorno.setSucesso(isProcessado);
            return retorno;
        }
        catch (LaboratorioExternoException e) {
            String message = e.getMessage();
            this.exibeMensagem(isColetaWeb, retorno, message);
        }
        catch (Exception e) {
            if (e.getMessage().contains("500")) {
                String message = "N\u00e3o foi possivel obter conex\u00e3o com WebService do Diagn\u00f3stico Brasil.\nEntre em contato com o laborat\u00f3rio de apoio.";
                this.exibeMensagem(isColetaWeb, retorno, message);
            }
            this.exibeErro(isColetaWeb, retorno, e);
        }
        retorno.setSucesso(false);
        return retorno;
    }

    protected boolean estornoExamePorRegistro(boolean isColetaWeb, String codigoLote, LaboratorioExterno labExterno, boolean agruparMultiguia, int digitosTuboFilial, int digitosTuboRequisicao, Callable<Boolean> arquivar, Callable<Boolean> anular, int agruparInterface, boolean agruparGuiasInterface, Statement st, List<Registro> listaRequisicoesSemAgrupamento, String configuracaoLabExterno, Registro registro, boolean isEstornoPorExame) throws SQLException, LaboratorioExternoException, Exception {
        boolean isProcessado = true;
        LoteExternoRequisicaoVO loteExternoRequisicaoVO = this.getLoteExternoRequisicao(codigoLote, registro, labExterno, agruparMultiguia, st);
        if (!this.possuiLoteExterno(loteExternoRequisicaoVO)) {
            throw new LaboratorioExternoException("Lote " + codigoLote + " n\u00e3o encontrado para o laborat\u00f3rio " + labExterno.descricao);
        }
        ArrayList<Registro> examesNovos = new ArrayList<Registro>();
        if (!isEstornoPorExame) {
            String xml = GeradorXmlEnviarLoteParaDB.geraXml(configuracaoLabExterno, registro, true, digitosTuboFilial, digitosTuboRequisicao);
            DBComunicacao comunicacao = new DBComunicacao(configuracaoLabExterno);
            String retornoDB = comunicacao.enviarLoteParaWebService(xml);
            isProcessado = this.processaRetornoEstorno(retornoDB);
        }
        if (isProcessado) {
            this.atualizaRequisicaoEstornada(isColetaWeb, codigoLote, labExterno, listaRequisicoesSemAgrupamento, registro, examesNovos, st, arquivar, anular, agruparInterface, agruparGuiasInterface);
        }
        return isProcessado;
    }

    private void exibeErro(boolean isColetaWeb, RetornoEstornarLote retorno, Exception e) {
        if (isColetaWeb && retorno != null) {
            retorno.setMensagem("N\u00e3o foi poss\u00edvel criar o lote solicitado.<br>" + e.getMessage());
        } else {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel criar o lote solicitado.\n" + e.getMessage(), e.getStackTrace());
        }
    }

    private void exibeMensagem(boolean isColetaWeb, RetornoEstornarLote retorno, String message) {
        if (isColetaWeb && retorno != null) {
            retorno.setMensagem("N\u00e3o foi poss\u00edvel estornar exames. <br>" + message);
        } else {
            Funcoes.mensagem(Laboratorio.getInstancia(), message, 1);
        }
    }

    private RetornoEstornarLote atualizaRequisicaoEstornada(boolean isColetaWeb, String codigoLote, LaboratorioExterno labExterno, List<Registro> listaRequisicoesSemAgrupamento, Registro registro, List<Registro> examesNovos, Statement st, Callable<Boolean> arquivar, Callable<Boolean> anular, int agruparInterface, boolean agruparGuiasInterface) throws Exception {
        RetornoEstornarLote retorno = new RetornoEstornarLote();
        IntegracaoLabExterno.setListaEstornados(this.listaEstornados);
        listaRequisicoesSemAgrupamento.add(registro.clone());
        try {
            IntegracaoLabExterno.excluirRequisicaoDB(labExterno.codigoLab, st, codigoLote, registro, false, true, false, (List)registro.getValor(LISTA_EXAMES), registro.getString(FIL_CODIGO), registro.getString(REQ_CODIGO), isColetaWeb, arquivar, agruparInterface, agruparGuiasInterface);
            retorno.setSucesso(true);
        }
        catch (Exception e) {
            anular.call();
            retorno.setSucesso(false);
            throw e;
        }
        return retorno;
    }

    private boolean possuiLoteExterno(LoteExternoRequisicaoVO loteExternoRequisicaoVO) {
        return loteExternoRequisicaoVO != null;
    }

    private boolean contemRegistro(Registro regExa) {
        return regExa != null;
    }

    private Registro getExameRequisicao(Registro exameRequisicao) {
        for (String exame : this.listaEstornados.values()) {
            if (!exameRequisicao.getString(EXA_CODIGO).equals(exame)) continue;
            return exameRequisicao;
        }
        return null;
    }

    private boolean processaRetornoEstorno(String retornoDB) {
        return this.processaConfirmacaoPedidoV2(retornoDB);
    }

    private boolean processaConfirmacaoPedidoV2(String retornoDB) {
        boolean isProcessado = true;
        try {
            if (retornoDB.indexOf(DBCamposRetorno.TAG_CONFIRMACAO_PEDIDO.getTag()) > -1) {
                String filialRequisicao = StringUtil.getValor(retornoDB, DBCamposRetorno.TAG_NUMERO_ATENDIMENTO_APOIADO.getTag());
                if (!Funcoes.textoVazio(filialRequisicao)) {
                    String[] confirmacoes;
                    for (String confirmacao : confirmacoes = StringUtil.getValores(retornoDB, DBCamposRetorno.TAG_CONFIRMACAO_PEDIDO_ETIQUETA_V2.getTag())) {
                        String[] errosIntegracao;
                        String mensagemRetornoLote = StringUtil.getValor(confirmacao, DBCamposRetorno.TAG_STATUS_CONFIRMACAO.getTag());
                        boolean bl = isProcessado = !mensagemRetornoLote.equalsIgnoreCase("NaoProcessado");
                        if (isProcessado) continue;
                        for (String erro : errosIntegracao = StringUtil.getValores(retornoDB, DBCamposRetorno.TAG_ERRO_INTEGRACAO.getTag())) {
                            this.mensagemRetorno = StringUtil.getValor(erro, DBCamposRetorno.TAG_ERRO_INTEGRACAO_DESCRICAO.getTag());
                        }
                    }
                }
            } else if (retornoDB.indexOf(DBCamposRetorno.TAG_EXCEPTION_DETAIL.getTag()) > -1) {
                ArrayList<String> mensagens = new ArrayList<String>();
                this.getTagRetornoDB(mensagens, this.getDocRetornoDB(retornoDB).getChildNodes(), DBCamposRetorno.TAG_MESSAGE.getTag());
                this.mensagemRetorno = String.join((CharSequence)"\n", mensagens);
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return isProcessado;
    }

    private Document getDocRetornoDB(String retornoDB) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        return docBuilder.parse(new ByteArrayInputStream(retornoDB.getBytes(StandardCharsets.UTF_8)));
    }

    private void getTagRetornoDB(List<String> tags, NodeList node, String tag) {
        for (int i = 0; i < node.getLength(); ++i) {
            if (node.item(i) == null) continue;
            if (node.item(i).getNodeName().equalsIgnoreCase(tag) && !Funcoes.textoVazio(node.item(i).getTextContent())) {
                tags.add(node.item(i).getTextContent());
                continue;
            }
            this.getTagRetornoDB(tags, node.item(i).getChildNodes(), tag);
        }
    }

    private LoteExternoRequisicaoVO getLoteExternoRequisicao(String codigoLote, Registro registro, LaboratorioExterno labExterno, boolean agruparMultiguia, Statement st) throws SQLException {
        LoteExternoRequisicaoDao loteExternoRequisicaoDao = new LoteExternoRequisicaoDao();
        LoteExternoRequisicaoVO loteExternoRequisicaoVO = null;
        String requisicao = registro.getString(REQ_CODIGO);
        if (agruparMultiguia) {
            requisicao = registro.getString("req_codigomae");
        }
        loteExternoRequisicaoVO = loteExternoRequisicaoDao.getLoteExternoRequisicao(registro.getString(FIL_CODIGO), requisicao, labExterno.codigoLab, codigoLote, st);
        return loteExternoRequisicaoVO;
    }

    public Map<String, String> getListaNaoEstornados() {
        return this.listaNaoEstornados;
    }

    public void setListaNaoEstornados(Map<String, String> listaNaoEstornados) {
        this.listaNaoEstornados = (HashMap)listaNaoEstornados;
    }

    public String getMensagemRetorno() {
        return this.mensagemRetorno;
    }

    public void setMensagemRetorno(String mensagemRetorno) {
        this.mensagemRetorno = mensagemRetorno;
    }

    public String getMensagemErroIntegracao() {
        return this.mensagemErroIntegracao;
    }

    public void setMensagemErroIntegracao(String mensagemErroIntegracao) {
        this.mensagemErroIntegracao = mensagemErroIntegracao;
    }

    public Map<String, String> getListaAndamento() {
        return this.listaAndamento;
    }

    public void setListaAndamento(Map<String, String> listaAndamento) {
        this.listaAndamento = (HashMap)listaAndamento;
    }

    public Map<String, String> getListaEstornados() {
        return this.listaEstornados;
    }

    public void setListaEstornados(Map<String, String> listaEstornados) {
        this.listaEstornados = (HashMap)listaEstornados;
    }
}

