/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.externo.exportadores.db2;

import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.triagem.externo.exportadores.UtilExportadores;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class DBComunicacao {
    private static final String SOAP_ACTION = "SOAPAction";
    private static final String TEXT_XML = "text/xml";
    private final String host;
    private final String configuracaoLabExterno;

    public DBComunicacao(String xmlConfigLabExterno) {
        String hostXML;
        this.host = hostXML = StringUtil.getValor(xmlConfigLabExterno, "enderecoWebService");
        this.configuracaoLabExterno = xmlConfigLabExterno;
    }

    public boolean hostValido(boolean isColetaWeb) {
        try {
            if (!UtilExportadores.comunicacaoOk(this.host, isColetaWeb, Protocolo.DBV2.getDescricao()).isImprimiu()) {
                return false;
            }
        }
        catch (Exception e) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel conectar ao servidor. Verifique sua internet.", 2);
        }
        return true;
    }

    public boolean configuracaoValida() {
        String senhaWebservice;
        boolean isEnviarWebService = this.configuracaoLabExterno.indexOf("enviarLoteWebservice") > -1 && StringUtil.getBoolean(this.configuracaoLabExterno, "enviarLoteWebservice");
        String codigoWebservice = this.configuracaoLabExterno.indexOf("codigo") > -1 ? StringUtil.getValor(this.configuracaoLabExterno, "codigo") : null;
        String string = senhaWebservice = this.configuracaoLabExterno.indexOf("senha") > -1 ? StringUtil.getValor(this.configuracaoLabExterno, "senha") : null;
        if (isEnviarWebService) {
            if (Funcoes.textoVazio(codigoWebservice)) {
                Funcoes.mensagem(Laboratorio.getInstancia(), "O c\u00f3digo do protocolo Diagn\u00f3sticos do Brasil n\u00e3o foi configurado.", 2);
                return false;
            }
            if (Funcoes.textoVazio(senhaWebservice)) {
                Funcoes.mensagem(Laboratorio.getInstancia(), "A senha do Diagn\u00f3sticos do Brasil n\u00e3o foi configurada.", 2);
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String enviarLoteParaWebService(String xml) {
        String retorno = "";
        CloseableHttpClient client = null;
        try {
            client = HttpClients.createDefault();
            HttpUriRequest request = RequestBuilder.post((String)this.host).addHeader("Content-Type", TEXT_XML).addHeader(SOAP_ACTION, "http://diagnosticosdobrasil.com.br/RecebeAtendimento").setCharset(StandardCharsets.UTF_8).setEntity((HttpEntity)new StringEntity(xml, "UTF-8")).build();
            CloseableHttpResponse response = client.execute(request);
            if (this.statusOK(response)) {
                HttpEntity entity = response.getEntity();
                retorno = EntityUtils.toString((HttpEntity)entity);
            }
            retorno = StringUtil.xmlToTexto(retorno);
        }
        catch (IOException ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "DBComunicacao (80)");
        }
        finally {
            try {
                if (client != null) {
                    client.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String enviarAmostraParaWebService(String xml) {
        String retorno = "";
        CloseableHttpClient client = null;
        try {
            client = HttpClients.createDefault();
            HttpUriRequest request = RequestBuilder.post((String)this.host).addHeader("Content-Type", TEXT_XML).addHeader(SOAP_ACTION, "http://diagnosticosdobrasil.com.br/EnviaAmostras").setCharset(StandardCharsets.UTF_8).setEntity((HttpEntity)new StringEntity(xml, "UTF-8")).build();
            CloseableHttpResponse response = client.execute(request);
            if (this.statusOK(response)) {
                HttpEntity entity = response.getEntity();
                retorno = EntityUtils.toString((HttpEntity)entity);
            }
            retorno = StringUtil.xmlToTexto(retorno);
        }
        catch (IOException ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "DBComunicacao (118)");
        }
        finally {
            try {
                if (client != null) {
                    client.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return retorno;
    }

    private boolean statusOK(CloseableHttpResponse response) {
        return null != response && response.getStatusLine().getStatusCode() == 200;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String enviaLaudoAtendimento(String xml) {
        String retorno = "";
        CloseableHttpClient client = null;
        try {
            client = HttpClients.createDefault();
            HttpUriRequest request = RequestBuilder.post((String)this.host).addHeader("Content-Type", TEXT_XML).addHeader(SOAP_ACTION, "http://diagnosticosdobrasil.com.br/EnviaLaudoAtendimento").setCharset(StandardCharsets.UTF_8).setEntity((HttpEntity)new StringEntity(xml, "UTF-8")).build();
            CloseableHttpResponse response = client.execute(request);
            if (this.statusOK(response)) {
                HttpEntity entity = response.getEntity();
                retorno = EntityUtils.toString((HttpEntity)entity);
            }
            retorno = StringUtil.xmlToTexto(retorno);
            retorno = retorno.replace("&#xD;", "");
        }
        catch (IOException ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "DBComunicacao (173)");
        }
        finally {
            try {
                if (client != null) {
                    client.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String enviaLaudoAtendimentoPorPeriodo(String xml) {
        String retorno = "";
        CloseableHttpClient client = null;
        try {
            client = HttpClients.createDefault();
            HttpUriRequest request = RequestBuilder.post((String)this.host).addHeader("Content-Type", TEXT_XML).addHeader(SOAP_ACTION, "http://diagnosticosdobrasil.com.br/BuscaResultadosPorPeriodo").setCharset(StandardCharsets.UTF_8).setEntity((HttpEntity)new StringEntity(xml, "UTF-8")).build();
            CloseableHttpResponse response = client.execute(request);
            if (this.statusOK(response)) {
                HttpEntity entity = response.getEntity();
                retorno = EntityUtils.toString((HttpEntity)entity);
            }
            retorno = StringUtil.xmlToTexto(retorno);
            retorno = retorno.replace("&#xD;", "");
        }
        catch (IOException ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "DBComunicacao (157)");
        }
        finally {
            try {
                if (client != null) {
                    client.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String enviaLoteResultados(String xml) {
        String retorno = "";
        CloseableHttpClient client = null;
        try {
            client = HttpClients.createDefault();
            HttpUriRequest request = RequestBuilder.post((String)this.host).addHeader("Content-Type", TEXT_XML).addHeader(SOAP_ACTION, "http://diagnosticosdobrasil.com.br/EnviaLoteResultados").setCharset(StandardCharsets.UTF_8).setEntity((HttpEntity)new StringEntity(xml, "UTF-8")).build();
            CloseableHttpResponse response = client.execute(request);
            if (this.statusOK(response)) {
                HttpEntity entity = response.getEntity();
                retorno = EntityUtils.toString((HttpEntity)entity);
            }
            retorno = StringUtil.xmlToTexto(retorno);
            retorno = retorno.replace("&#xD;", "");
        }
        catch (IOException ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "DBComunicacao (247)");
        }
        finally {
            try {
                if (client != null) {
                    client.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String listaProcedimentosPendentes(String xml) {
        String retorno = "";
        CloseableHttpClient client = null;
        try {
            client = HttpClients.createDefault();
            HttpUriRequest request = RequestBuilder.post((String)this.host).addHeader("Content-Type", TEXT_XML).addHeader(SOAP_ACTION, "http://diagnosticosdobrasil.com.br/ListaProcedimentosPendentes").setCharset(StandardCharsets.UTF_8).setEntity((HttpEntity)new StringEntity(xml, "UTF-8")).build();
            CloseableHttpResponse response = client.execute(request);
            if (this.statusOK(response)) {
                HttpEntity entity = response.getEntity();
                retorno = EntityUtils.toString((HttpEntity)entity);
            }
            retorno = StringUtil.xmlToTexto(retorno);
        }
        catch (IOException ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "DBComunicacao (266)");
        }
        finally {
            try {
                if (client != null) {
                    client.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String enviaResultadoBase64(String xml) {
        String retorno = "";
        CloseableHttpClient client = null;
        try {
            client = HttpClients.createDefault();
            HttpUriRequest request = RequestBuilder.post((String)this.host).addHeader("Content-Type", TEXT_XML).addHeader(SOAP_ACTION, "http://diagnosticosdobrasil.com.br/EnviaResultadoBase64").setCharset(StandardCharsets.UTF_8).setEntity((HttpEntity)new StringEntity(xml, "UTF-8")).build();
            CloseableHttpResponse response = client.execute(request);
            if (this.statusOK(response)) {
                HttpEntity entity = response.getEntity();
                retorno = EntityUtils.toString((HttpEntity)entity);
            }
        }
        catch (IOException ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "DBComunicacao (301)");
        }
        finally {
            try {
                if (client != null) {
                    client.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String enviaAmostraProcedimentosPendentes(String xml) {
        String retorno = "";
        CloseableHttpClient client = null;
        try {
            client = HttpClients.createDefault();
            HttpUriRequest request = RequestBuilder.post((String)this.host).addHeader("Content-Type", TEXT_XML).addHeader(SOAP_ACTION, "http://diagnosticosdobrasil.com.br/EnviaAmostrasProcedimentosPendentes").setCharset(StandardCharsets.UTF_8).setEntity((HttpEntity)new StringEntity(xml, "UTF-8")).build();
            CloseableHttpResponse response = client.execute(request);
            if (this.statusOK(response)) {
                HttpEntity entity = response.getEntity();
                retorno = EntityUtils.toString((HttpEntity)entity);
            }
            retorno = StringUtil.xmlToTexto(retorno);
        }
        catch (IOException ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "DBComunicacao (336)");
        }
        finally {
            try {
                if (client != null) {
                    client.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return retorno;
    }
}

