/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.externo.exportadores.db2;

import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.triagem.externo.exportadores.db2.ParseErroRetornoWebServiceDB;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class AlertaErroRetornoWebServiceDB
extends AbstractDialogoOKCancelar {
    private static final String TITULO = "Alerta";
    private JPanel panelAlerta = new JPanel(new GridBagLayout());
    private JLabel tituloLabel = new JLabel("Os exames a seguir foram rejeitados pelo DB.");
    private ModeloGridTable modeloTaxa = new ModeloGridTable(new String[]{"Filial", "Requisi\u00e7\u00e3o", "Exame", "Material", "Motivo"});
    private JTable tableTaxa = new JTable(this.modeloTaxa);
    private JScrollPane scroll = new JScrollPane(this.tableTaxa);
    private transient List<ParseErroRetornoWebServiceDB> parseErroRetorno = new ArrayList<ParseErroRetornoWebServiceDB>();

    private AlertaErroRetornoWebServiceDB(Dialog pai, List<ParseErroRetornoWebServiceDB> parseErroRetorno) {
        super(pai, TITULO);
        this.parseErroRetorno = parseErroRetorno;
        this.montaTela();
    }

    private AlertaErroRetornoWebServiceDB(Frame pai, List<ParseErroRetornoWebServiceDB> parseErroRetorno) {
        super(pai, TITULO);
        this.parseErroRetorno = parseErroRetorno;
        this.montaTela();
    }

    public static AlertaErroRetornoWebServiceDB novaInstancia(Object pai, List<ParseErroRetornoWebServiceDB> parseErroRetorno) {
        return pai instanceof Dialog ? new AlertaErroRetornoWebServiceDB((Dialog)pai, parseErroRetorno) : new AlertaErroRetornoWebServiceDB((Frame)pai, parseErroRetorno);
    }

    private void montaTela() {
        this.setSize(700, 350);
        this.getPanelCentral().setLayout(new BorderLayout());
        this.getPanelCentral().add((Component)this.panelAlerta, "Center");
        this.getBotaoCancelar().setText("Copiar para a \u00c1rea de Tranfer\u00eancia");
        this.setUsuarioPodeCancelar(false);
        GridBagConstraints c = this.iniciaGridBag();
        this.panelAlerta.add((Component)this.tituloLabel, c);
        this.montaTabela(c);
        this.panelAlerta.add((Component)this.scroll, c);
        this.adicionarLinhasErro();
        ScreenUtil.centralizar(this);
        this.setVisible(true);
    }

    private GridBagConstraints iniciaGridBag() {
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 13;
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(1, 0, 0, 1);
        return c;
    }

    private void montaTabela(GridBagConstraints c) {
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridy = 2;
        c.gridx = 0;
        c.gridwidth = 5;
        c.fill = 1;
        int columnTooltipsIndex = 4;
        TableColumnModel columnModel = this.tableTaxa.getColumnModel();
        TableColumn column = columnModel.getColumn(columnTooltipsIndex);
        column.setCellRenderer(new TooltipCellRenderer());
        this.modeloTaxa.setColumnSize(new int[]{60, 100, 90, 90, 0}, this.tableTaxa);
    }

    public void adicionarLinhasErro() {
        for (ParseErroRetornoWebServiceDB parseErro : this.parseErroRetorno) {
            this.modeloTaxa.addLine(new Object[]{parseErro.getFilial(), parseErro.getRequisicao(), parseErro.getExame(), parseErro.getMaterial(), parseErro.getDescricao()});
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.buttonOK) {
            this.ok = o == this.buttonOK;
            this.dispose();
        } else if (o == this.buttonCancelar) {
            this.copiaTabelaParaClipboard();
        }
    }

    private void copiaTabelaParaClipboard() {
        StringBuilder sb = new StringBuilder();
        TableModel model = this.tableTaxa.getModel();
        for (int i = 0; i < model.getRowCount(); ++i) {
            for (int j = 0; j < model.getColumnCount(); ++j) {
                sb.append(model.getValueAt(i, j));
                sb.append("\t");
            }
            sb.append(System.lineSeparator());
        }
        StringSelection selection = new StringSelection(sb.toString());
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(selection, selection);
    }

    private class TooltipCellRenderer
    extends DefaultTableCellRenderer {
        private TooltipCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component cellComponent = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            int targetColumnIndex = 4;
            if (column == targetColumnIndex) {
                if (value != null) {
                    this.setToolTipText(value.toString());
                } else {
                    this.setToolTipText(null);
                }
            } else {
                this.setToolTipText(null);
            }
            return cellComponent;
        }
    }
}

