/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.externo.exportadores.cerba;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.relatorios.apoio.RelatorioSituacaoLote;
import jalis.laboratorio.triagem.externo.Exportador;
import jalis.laboratorio.triagem.externo.LaboratorioExterno;
import jalis.laboratorio.triagem.externo.exportadores.IntegracaoLabExterno;
import jalis.laboratorio.triagem.externo.exportadores.UtilExportadores;
import jalis.laboratorio.triagem.externo.exportadores.cerba.EscreverXml;
import jalis.laboratorio.util.impressao.Impressao;
import jalis.laboratorio.util.impressao.RetornoImpressaoEtiquetas;
import jalis.laboratorio.util.impressao.labexterno.ImpressorasLabExterno;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.relatorio.Gerador;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.impressao.termica.ImpressaoTermica;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import jalis.util.xml.XMLStringBuilderException;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.table.TableModel;

public class ExportacaoParaCerba
extends IntegracaoLabExterno
implements Exportador {
    private static final String TAG_CODIGO_CONSELHO_SOLICITANTE = "CodigoConselhoSolicitante";
    private static final String TAG_CODIGO_UF_CONSELHO_SOLICITANTE = "CodigoUFConselhoSolicitante";
    private static final String TAG_CODIGO_CONSELHO = "CodigoConselho";
    private static final String TAG_NOME_SOLICITANTE = "NomeSolicitante";
    private static final String TAG_LISTA_SOLICITANTE = "ListaSolicitante";
    private static final String TAG_NUMERO_CARTAO_NACIONAL_SAUDE = "NumeroCartaoNacionalSaude";
    private static final String TAG_NUMERO_CPF = "NumeroCPF";
    private static final String TAG_DATA_HORA_PACIENTE = "DataHoraPaciente";
    private static final String TAG_SEXO_PACIENTE = "SexoPaciente";
    private static final String TAG_NOME_PACIENTE = "NomePaciente";
    private static final String TAG_RG_PACIENTE_APOIADO = "RGPacienteApoiado";
    private static final String TAG_LISTA_PACIENTE_APOIADO = "ListaPacienteApoiado";
    private static final String TAG_PESO = "Peso";
    private static final String TAG_ALTURA = "Altura";
    private static final String TAG_DATA_HORA_DUM = "DataHoraDUM";
    private static final String TAG_DESCRICAO_MEDICAMENTOS = "DescricaoMedicamentos";
    private static final String TAG_DESCRICAO_DADOS_CLINICOS = "DescricaoDadosClinicos";
    private static final String TAG_CODIGO_PRIORIDADE = "CodigoPrioridade";
    private static final String TAG_NUMERO_ATENDIMENTO_APOIADO = "NumeroAtendimentoApoiado";
    private static final String TAG_VOLUME_URINARIO = "VolumeUrinario";
    private static final String TAG_DESCRICAO_REGIAO_COLETA = "DescricaoRegiaoColeta";
    private static final String TAG_CODIGO_EXAME_DB = "CodigoExameDB";
    private static final String TAG_CT_PROCEDIMENTO_V1 = "ct_Procedimento_v1";
    private static final String TAG_LISTA_PROCEDIMENTO = "ListaProcedimento";
    private static final String TAG_NUMERO_ATENDIMENTO_DB_RESERVA = "NumeroAtendimentoDBReserva";
    private static final String TAG_CT_PEDIDOS_V1 = "ct_Pedidos_v1";
    private static final String TAG_LISTA_PEDIDOS = "ListaPedidos";
    private static final String TAG_CODIGO_SENHA_INTEGRACAO = "CodigoSenhaIntegracao";
    private static final String TAG_CODIGO_APOIADO = "CodigoApoiado";
    private static final String TAG_NUMERO_LOTE = "NumeroLote";
    private static final String TAG_CT_LOTE_PEDIDOS_V1 = "ct_LotePedidos_v1";
    public static final String TAG_PEDIDO = "pedidos";

    @Override
    public String getTagCodigo() {
        return "codigo";
    }

    @Override
    public RetornoImpressaoEtiquetas exportarExames(String codLabExterno, String numeroLote, String configuracaoLabExterno, boolean reenvio, List<Registro> requisicoes, int colunaOrdenacao, boolean isColetaWeb, int agruparInterface, Statement st, Statement st2, Statement st3, String variaveisLogin, boolean agruparGuiasInterface, String imprimirEtiquetaTriagemSemMaterial, boolean imprimirEtiquetaColetaSemMaterial, boolean imprimirEtiquetaColetaSelecionadaSemMaterial, boolean agruparEtqPorQtde, String tipoExportacaoInterface, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario, String tipoIntegracao, String tamanhoNomeImpressora, String[] impressorasLocais, ImpressorasLabExterno impressoras, String tipoEtiquetaSoroteca, Callable<Boolean> arquivar, Callable<Boolean> anular, LaboratorioExterno labExterno, boolean agruparMultiguia) {
        RetornoImpressaoEtiquetas retorno = new RetornoImpressaoEtiquetas();
        String nomeArquivo = String.format("%s_%s.xml", StringUtil.getValor(configuracaoLabExterno, "codigo"), numeroLote);
        requisicoes = ExportacaoParaCerba.agruparMutiguia(requisicoes, st, agruparGuiasInterface, digitosTuboFilial);
        EscreverXml xml = new EscreverXml();
        try {
            xml = this.montaXml(numeroLote, configuracaoLabExterno, requisicoes, digitosTuboFilial, digitosTuboRequisicao);
        }
        catch (XMLStringBuilderException | ParseException e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ExportacaoParaCerba: 106 - 132");
        }
        if (isColetaWeb) {
            retorno.setXmlLote(xml.getXML());
            retorno.setNomeArquivoLote(nomeArquivo);
            retorno.setExtensaoArquivo("xml");
            retorno.setImprimiu(true);
            return retorno;
        }
        JFileChooser chooser = ComponenteFactory.novoJFileChooser();
        chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
        chooser.setSelectedFile(new File(nomeArquivo));
        chooser.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo de exporta\u00e7\u00e3o DB (*.xml)", "xml"));
        if (chooser.showSaveDialog(null) == 0) {
            this.escreverArquivo(chooser.getSelectedFile(), xml.getXML());
            retorno.setImprimiu(true);
            return retorno;
        }
        retorno.setImprimiu(false);
        return retorno;
    }

    private EscreverXml montaXml(String numeroLote, String configuracaoLabExterno, List<Registro> requisicoes, int digitosTuboFilial, int digitosTuboRequisicao) throws ParseException, XMLStringBuilderException {
        EscreverXml xml = new EscreverXml();
        xml.abrir(TAG_CT_LOTE_PEDIDOS_V1);
        xml.escrever(TAG_NUMERO_LOTE, numeroLote);
        xml.escrever(TAG_CODIGO_APOIADO, StringUtil.getValor(configuracaoLabExterno, "codigo"));
        xml.escrever(TAG_CODIGO_SENHA_INTEGRACAO, StringUtil.getValor(configuracaoLabExterno, "senha"));
        xml.abrir(TAG_LISTA_PEDIDOS);
        for (Registro requisicao : requisicoes) {
            ArrayList exames = (ArrayList)requisicao.getValor("listaexames");
            xml.abrir(TAG_CT_PEDIDOS_V1);
            this.escreverPaciente(xml, requisicao, exames, digitosTuboFilial, digitosTuboRequisicao);
            this.escreverRequisicao(xml, requisicao, digitosTuboFilial, digitosTuboRequisicao);
            this.escreverExames(xml, exames);
            this.escreverSolicitante(xml, requisicao);
            xml.escrever(TAG_NUMERO_ATENDIMENTO_DB_RESERVA, "");
            xml.fechar(TAG_CT_PEDIDOS_V1);
        }
        xml.fechar(TAG_LISTA_PEDIDOS);
        xml.fechar(TAG_CT_LOTE_PEDIDOS_V1);
        return xml;
    }

    private boolean validarConfiguracao(String configuracaoLabExterno, boolean validaConexao) {
        String senhaWebservice;
        boolean isEnviarWebService = configuracaoLabExterno.indexOf("enviarLoteWebservice") > 0 ? StringUtil.getBoolean(configuracaoLabExterno, "enviarLoteWebservice") : false;
        String codigoWebservice = configuracaoLabExterno.indexOf("codigo") > 0 ? StringUtil.getValor(configuracaoLabExterno, "codigo") : null;
        String string = senhaWebservice = configuracaoLabExterno.indexOf("senha") > 0 ? StringUtil.getValor(configuracaoLabExterno, "senha") : null;
        if (isEnviarWebService) {
            if (Funcoes.textoVazio(codigoWebservice)) {
                Funcoes.mensagem(Laboratorio.getInstancia(), "O c\u00f3digo do protocolo Diagn\u00f3sticos do Brasil n\u00e3o foi configurado.", 2);
                return false;
            }
            if (Funcoes.textoVazio(senhaWebservice)) {
                Funcoes.mensagem(Laboratorio.getInstancia(), "A senha do Diagn\u00f3sticos do Brasil n\u00e3o foi configurada.", 2);
                return false;
            }
            if (validaConexao) {
                try {
                    if (!UtilExportadores.comunicacaoOk(StringUtil.getValor(configuracaoLabExterno, "enderecoWebService"), false, Protocolo.Cerba.getDescricao()).isImprimiu()) {
                        return false;
                    }
                }
                catch (Exception e) {
                    Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel conectar ao servidor. Verifique sua internet.", 2);
                    return false;
                }
            }
        }
        return true;
    }

    private String getRecipiente(String exaJalis, String matJalis, String requisicao, String filial) {
        StringBuilder buf = new StringBuilder();
        Statement st = Conexao.getStatement();
        buf.append("select rec_kodigo from examerequisicaorecipiente ");
        buf.append(" where fil_codigo = ").append(filial);
        buf.append("   and req_codigo = ").append(requisicao);
        buf.append("   and mco_codigo = ").append(matJalis);
        buf.append("   and exa_codigo = '").append(exaJalis).append("' ");
        buf.append("   and ere_codigoapoiado is null ");
        buf.append(" limit 1 ");
        ResultSet rs = null;
        try {
            rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                return rs.getString("rec_kodigo");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public byte[] imprimeRelatorio(boolean isColetaWeb, String codLabExterno, String numeroLote, List<Registro> requisicoesListaOriginal, int colunaOrdenacao, Statement st, int filialPadrao, int digitosTuboRequisicao, int digitosTuboFilial, String impressoraRelatorio) throws Exception {
        RelatorioSituacaoLote rel = new RelatorioSituacaoLote();
        ModeloGridTable modelo = rel.getModeloDados(st, new String[]{String.valueOf(numeroLote)}, new String[]{String.valueOf(codLabExterno)}, colunaOrdenacao, requisicoesListaOriginal, filialPadrao, digitosTuboRequisicao, digitosTuboFilial);
        if (modelo.getRowCount() > 0) {
            Gerador gerador = new Gerador(impressoraRelatorio);
            HashMap<String, Object> variaveis = new HashMap<String, Object>();
            variaveis.put("filtroLote", numeroLote);
            String xmlRelatorio = rel.getXMLRelatorio(st);
            if (!isColetaWeb) {
                JDialog dialogo = new JDialog((Frame)Laboratorio.getInstancia(), "Relat\u00f3rio de lote enviado");
                dialogo.setModal(true);
                dialogo.setSize(new Dimension(750, 600));
                dialogo.setLayout(new BorderLayout());
                gerador.setPai(dialogo.getContentPane());
                gerador.setPreVisualizar(true);
                gerador.setZoomPreVisualizar(0.5f);
                gerador.setAcaoFechar(dialogo::dispose);
                gerador.executar(xmlRelatorio, (TableModel)modelo, variaveis);
                ScreenUtil.centralizar(dialogo);
                dialogo.setVisible(true);
            } else {
                gerador.executar(xmlRelatorio, modelo, variaveis, false, true, isColetaWeb);
                return Impressao.gerarPdfRelatorio(gerador.getRelatorio(), xmlRelatorio);
            }
        }
        return new byte[0];
    }

    private void escreverSolicitante(EscreverXml xml, Registro requisicao) throws XMLStringBuilderException {
        xml.abrir(TAG_LISTA_SOLICITANTE);
        xml.escrever(TAG_NOME_SOLICITANTE, requisicao.getString("med_nome"));
        xml.escrever(TAG_CODIGO_CONSELHO, requisicao.getString("med_conselho"));
        xml.escrever(TAG_CODIGO_UF_CONSELHO_SOLICITANTE, requisicao.getString("med_uf"));
        xml.escrever(TAG_CODIGO_CONSELHO_SOLICITANTE, requisicao.getString("med_crm"));
        xml.fechar(TAG_LISTA_SOLICITANTE);
    }

    private void escreverExames(EscreverXml xml, List<Registro> exames) throws XMLStringBuilderException {
        xml.abrir(TAG_LISTA_PROCEDIMENTO);
        for (Registro exame : exames) {
            Map dadosAdicionais;
            ArrayList examesDesmembrados = (ArrayList)exame.getValor("listaexames");
            if (examesDesmembrados != null && !examesDesmembrados.isEmpty()) {
                for (Registro exameDesmembrado : examesDesmembrados) {
                    Map dadosAdicionais2;
                    xml.abrir(TAG_CT_PROCEDIMENTO_V1);
                    xml.escrever(TAG_CODIGO_EXAME_DB, StringUtil.getValor(exameDesmembrado.getString("ele_xmllabexterno"), "cd_db"));
                    if (!Funcoes.textoVazio(exame.getString("exr_descricaomaterial"))) {
                        xml.escrever(TAG_DESCRICAO_REGIAO_COLETA, exame.getString("exr_descricaomaterial"));
                    }
                    if ((dadosAdicionais2 = exameDesmembrado.getValor("dadosAdicionais", Map.class)) != null && dadosAdicionais2.containsKey("Volume")) {
                        xml.escrever(TAG_VOLUME_URINARIO, (String)dadosAdicionais2.get("Volume"));
                    } else {
                        xml.escrever(TAG_VOLUME_URINARIO, "0");
                    }
                    xml.fechar(TAG_CT_PROCEDIMENTO_V1);
                }
                continue;
            }
            xml.abrir(TAG_CT_PROCEDIMENTO_V1);
            xml.escrever(TAG_CODIGO_EXAME_DB, StringUtil.getValor(exame.getString("ele_xmllabexterno"), "cd_db"));
            if (!Funcoes.textoVazio(exame.getString("exr_descricaomaterial"))) {
                xml.escrever(TAG_DESCRICAO_REGIAO_COLETA, exame.getString("exr_descricaomaterial"));
            }
            if ((dadosAdicionais = exame.getValor("dadosAdicionais", Map.class)) != null && dadosAdicionais.containsKey("Volume")) {
                xml.escrever(TAG_VOLUME_URINARIO, (String)dadosAdicionais.get("Volume"));
            } else {
                xml.escrever(TAG_VOLUME_URINARIO, "0");
            }
            xml.fechar(TAG_CT_PROCEDIMENTO_V1);
        }
        xml.fechar(TAG_LISTA_PROCEDIMENTO);
    }

    private void escreverRequisicao(EscreverXml xml, Registro requisicao, int digitosTuboFilial, int digitosTuboRequisicao) throws ParseException {
        xml.escrever(TAG_NUMERO_ATENDIMENTO_APOIADO, this.getCodigo(requisicao.getString("fil_codigo"), requisicao.getString("req_codigo"), digitosTuboFilial, digitosTuboRequisicao));
        xml.escrever(TAG_CODIGO_PRIORIDADE, requisicao.getBoolean("req_urgente") ? "U" : "R");
        xml.escrever(TAG_DESCRICAO_DADOS_CLINICOS, requisicao.getString("req_obs"));
        xml.escrever(TAG_DESCRICAO_MEDICAMENTOS, "");
        xml.escrever(TAG_DATA_HORA_DUM, Funcoes.formataData("yyyy-MM-dd'T'HH:mm:ss", requisicao.getDate("req_dum")));
        xml.escrever(TAG_ALTURA, Funcoes.formataDecimal(requisicao.getDouble("req_altura"), 2).replace(',', '.'));
        xml.escrever(TAG_PESO, String.valueOf(requisicao.getInt("req_peso")));
    }

    private String getCodigo(String filial, String id, int digitosTuboFilial, int digitosTuboRequisicao) {
        return String.format("%s%s", Funcoes.preencheZero(filial, digitosTuboFilial), Funcoes.preencheZero(id, digitosTuboRequisicao));
    }

    private void escreverPaciente(EscreverXml xml, Registro requisicao, List<Registro> exames, int digitosTuboFilial, int digitosTuboRequisicao) throws ParseException, XMLStringBuilderException {
        xml.abrir(TAG_LISTA_PACIENTE_APOIADO);
        xml.escrever(TAG_RG_PACIENTE_APOIADO, this.getCodigo(requisicao.getString("fil_codigo"), requisicao.getString("pac_codigo"), digitosTuboFilial, digitosTuboRequisicao));
        xml.escrever(TAG_NOME_PACIENTE, requisicao.getString("pac_nome"));
        xml.escrever(TAG_SEXO_PACIENTE, requisicao.getString("pac_sexo").equals("M") ? "M" : (requisicao.getString("pac_sexo").equals("F") ? "F" : "I"));
        xml.escrever(TAG_DATA_HORA_PACIENTE, Funcoes.formataData("yyyy-MM-dd'T'HH:mm:ss", requisicao.getDate("pac_datanasc")));
        String cpf = "";
        String cartaoSus = "";
        for (Registro registro : exames) {
            cpf = registro.getString("pac_cpf");
            cartaoSus = registro.getString("pac_cartaosus");
        }
        xml.escrever(TAG_NUMERO_CPF, !Funcoes.textoVazio(cpf) ? StringUtil.limpaString(cpf, new String[]{",", ".", "/", "-"}) : "");
        xml.escrever(TAG_NUMERO_CARTAO_NACIONAL_SAUDE, cartaoSus);
        xml.fechar(TAG_LISTA_PACIENTE_APOIADO);
    }

    @Override
    public int getMaiorCodigoLote(String numeroLote, String codigoConvenio, LaboratorioExterno configuracaoLabExterno, Statement st) {
        try {
            ResultSet rs = Conexao.executeQuery(st, "select max(lex_codigo) + 1 as codigo from loteexterno where lae_codigo = " + configuracaoLabExterno.codigoLab + " and fil_codigo = " + Variaveis.filialPadrao);
            if (rs.next()) {
                return rs.getInt("codigo");
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void escreverArquivo(File arquivo, String xml) {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(arquivo));
            writer.write("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n" + xml);
        }
        catch (IOException e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
                }
            }
        }
    }

    public String getEtiquetaWebService() {
        return null;
    }

    public boolean exportarExames(String codLabExterno, String numeroLote, String configuracaoLabExterno, List<Registro> requisicoes) {
        return false;
    }

    public void imprimirEtiquetaDBWS(String filial, String requisicao, LaboratorioExterno labExterno, String impressora, boolean isColetaWeb) {
        String cabecalhoEtiqueta = StringUtil.getValor(labExterno.configuracao, "cabecalho");
        String retorno = null;
        if (labExterno != null) {
            StringBuilder sql = new StringBuilder();
            sql.append("select leq_retornows from loteexternorequisicao where fil_codigo = ").append(filial);
            sql.append(" and req_codigo in( ").append(requisicao).append(")");
            sql.append(" and fil_kodigo=").append(filial);
            sql.append(" and lae_codigo = ").append(labExterno.codigoLab);
            sql.append(" and leq_dataestorno is null ");
            sql.append(" and leq_retornows is not null ");
            sql.append(" and usr_codestorno is null order by lex_codigo desc ");
            try {
                ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), sql);
                if (rs.next()) {
                    retorno = rs.getString("leq_retornows");
                    String[] etiquetas = StringUtil.getValores(retorno, "etiqueta");
                    ImpressaoTermica termica = new ImpressaoTermica(Impressao.comparaNomeImpressoraReduzido(impressora), isColetaWeb);
                    for (String etiqueta : etiquetas) {
                        if (!Funcoes.textoVazio(cabecalhoEtiqueta)) {
                            termica.imprimirDireto(cabecalhoEtiqueta + etiqueta);
                            continue;
                        }
                        termica.imprimirDireto(etiqueta);
                    }
                }
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
                e.printStackTrace();
            }
        }
    }
}

