/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.externo.exportadores.cerba;

import jalis.comum.Conexao;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.triagem.externo.DadosAdicionais;
import jalis.laboratorio.triagem.externo.exportadores.InfoComplementar;
import jalis.laboratorio.util.parsers.cerba.ParserImportacaoCerba;
import jalis.service.exportadores.DadosAdicionaisService;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DadosAdicionaisCerba
extends JDialog
implements DadosAdicionais,
ActionListener {
    List<InfoComplementar> dados;
    Registro requisicao;
    JPanel panelExame = new JPanel(new GridBagLayout());
    JPanel panelDados = new JPanel(new GridBagLayout());
    JPanel panelBotoes = new JPanel(new FlowLayout(2));
    JButton botaoOk = ComponenteFactory.novoJButton("Ok", 'O', this);
    JButton botaoCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this);
    JLabel labelExame = new JLabel();
    JLabel labelRequisicao = new JLabel();
    private boolean isConfirmarDados = false;
    private DadosAdicionaisService service;

    public DadosAdicionaisCerba() {
        super(Laboratorio.getInstancia());
        this.setModal(true);
        this.setLayout(new BorderLayout());
        this.add((Component)this.panelDados, "Center");
        this.panelBotoes.add(this.botaoOk);
        this.panelBotoes.add(this.botaoCancelar);
        this.add((Component)this.panelBotoes, "South");
        this.add((Component)this.panelExame, "North");
        this.setTitle("Dados Adicionais");
        Funcoes.montaEnter((JComponent)this.panelDados);
        Funcoes.montaEnter((JComponent)this.panelBotoes);
        this.service = new DadosAdicionaisService();
    }

    public void configurarDadosAdicionais(List<InfoComplementar> dados, String exame, String requisicao, String paciente) {
        this.dados = dados;
        GridBagConstraints c = new GridBagConstraints();
        this.labelExame.setText("Exame: " + exame);
        this.labelRequisicao.setText("Requisi\u00e7\u00e3o:" + requisicao + " - " + paciente);
        this.panelExame.removeAll();
        this.panelExame.setLayout(new GridBagLayout());
        c = new GridBagConstraints();
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = 0;
        this.panelExame.add((Component)this.labelRequisicao, c);
        ++c.gridy;
        this.panelExame.add((Component)this.labelExame, c);
        int i = 0;
        this.panelDados.removeAll();
        this.panelDados.setLayout(new GridBagLayout());
        TTextField editDadoPrimeiro = null;
        c = new GridBagConstraints();
        c.anchor = 17;
        for (InfoComplementar dado : dados) {
            TTextField editDado;
            JLabel labelDado = new JLabel(dado.getNome());
            JLabel labelUnidade = new JLabel(dado.getUnidade());
            c.gridx = 0;
            c.weightx = 0.0;
            c.fill = 0;
            if (labelDado.getText().equals("Volume")) {
                labelDado.setText(labelDado.getText() + "(ml)");
                editDado = new TTextField(4, 1);
                editDado.setText(dado.getValor().toString());
            } else if (labelDado.getText().equals("Altura")) {
                editDado = ComponenteFactory.novoTTextField(3, 2);
                editDado.setText(dado.getValor().toString());
            } else if (labelDado.getText().equals("Peso")) {
                editDado = ComponenteFactory.novoTTextField(5, 2);
                editDado.setText(dado.getValor().toString());
            } else {
                editDado = ComponenteFactory.novoTTextField(15, 3);
            }
            editDado.setPreferredSize(new Dimension(100, 20));
            editDado.setName(dado.getTag());
            c.gridx = 1;
            c.weightx = 1.0;
            c.fill = 2;
            this.panelDados.add((Component)editDado, c);
            c.gridx = 2;
            c.weightx = 0.0;
            c.fill = 0;
            this.panelDados.add((Component)labelUnidade, c);
            if (editDadoPrimeiro == null) {
                editDadoPrimeiro = editDado;
            }
            c.gridy = i + 1;
            ++i;
        }
        if (editDadoPrimeiro != null) {
            ScreenUtil.requisitarFoco(editDadoPrimeiro);
        }
        this.setLocationRelativeTo(this.getParent());
        this.pack();
    }

    @Override
    public boolean carregaAdicionais(String codLabExterno, Registro requisicao) {
        ArrayList exames = (ArrayList)requisicao.getValor("listaexames");
        if (exames == null || exames.size() == 0) {
            return true;
        }
        Statement st = Conexao.getStatement();
        this.requisicao = requisicao;
        for (Registro r : exames) {
            if (this.carregaDadosAdicionais(r.getString("exa_codigo"), r.getString("mco_codigo"), codLabExterno, st, r, requisicao.getString("req_codigo"), requisicao.getString("pac_nome"))) continue;
            return false;
        }
        return true;
    }

    private boolean carregaDadosAdicionais(String exame, String material, String codLabExterno, Statement st, Registro exa, String requisicao, String paciente) {
        try {
            HashMap<String, String> dadosComValores = new HashMap<String, String>();
            String xml = this.service.getXMLExame(exa, codLabExterno);
            Registro exameCerba = ParserImportacaoCerba.getExame(xml, exame, material);
            if (Funcoes.textoVazio(xml)) {
                return true;
            }
            List<InfoComplementar> infoComplementares = this.service.carregaInfoComplementarCerba(exameCerba, exa, this.requisicao);
            if (!this.service.contemValores(infoComplementares) || this.isConfirmarDados && !infoComplementares.isEmpty()) {
                this.configurarDadosAdicionais(infoComplementares, exame, requisicao, paciente);
                this.setVisible(true);
                for (Component c : this.panelDados.getComponents()) {
                    if (!(c instanceof TTextField)) continue;
                    TTextField textField = (TTextField)c;
                    if (Funcoes.textoVazio(textField)) {
                        Funcoes.mensagem(this, "O exame " + exame + " possui dados adicionais que n\u00e3o foram preenchidos!", 5);
                        return false;
                    }
                    String valor = ((TTextField)c).getText();
                    String nomeCampo = ((TTextField)c).getName();
                    DadosAdicionaisCerba.atualizaValores(exa, nomeCampo, valor, dadosComValores);
                }
            } else {
                for (InfoComplementar info : infoComplementares) {
                    DadosAdicionaisCerba.atualizaValores(exa, info.getTag(), info.getValor().toString(), dadosComValores);
                }
            }
            return true;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void atualizaValores(Registro exa, String nomeCampo, String valor, HashMap<String, String> dadosComValores) {
        float v;
        boolean isVolume = nomeCampo.contains("Volume");
        boolean isPeso = nomeCampo.contains("Peso");
        boolean isAltura = nomeCampo.contains("Altura");
        float f = v = !Funcoes.textoVazio(valor = valor.replace(",", ".")) && Funcoes.isNumeric(valor) ? Float.valueOf(valor).floatValue() : 0.0f;
        if (isVolume) {
            valor = String.valueOf((int)v);
            exa.setValor("exr_volumediurese", valor);
        }
        if (isPeso) {
            int peso = Math.round(v);
            valor = String.valueOf(peso);
        }
        if (isAltura) {
            String altura;
            valor = altura = valor.replace(".", "");
        }
        valor = StringUtil.limpaString(valor, new String[]{",", ".", "/", "-"});
        dadosComValores.put(nomeCampo, valor);
        exa.setValor("dadosAdicionais", dadosComValores);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.botaoOk) {
            this.setVisible(false);
        } else if (e.getSource() == this.botaoCancelar) {
            for (Component c : this.panelDados.getComponents()) {
                if (!(c instanceof TTextField)) continue;
                ((TTextField)c).setText("");
            }
            this.setVisible(false);
        }
    }

    @Override
    public boolean carregaAdicionais(String codLabExterno, Registro requisicao, boolean isConfirmarDados) {
        this.isConfirmarDados = isConfirmarDados;
        return this.carregaAdicionais(codLabExterno, requisicao);
    }
}

