/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.externo.exportadores;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.recepcao.util.ExameExcluido;
import jalis.laboratorio.triagem.externo.DadosAdicionais;
import jalis.laboratorio.triagem.externo.Exportador;
import jalis.laboratorio.triagem.externo.FabricaExportador;
import jalis.laboratorio.triagem.externo.LaboratorioExterno;
import jalis.laboratorio.triagem.externo.exportadores.ExportacaoParaAlvaro;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.laboratorio.util.impressao.RetornoImpressaoEtiquetas;
import jalis.laboratorio.util.parsers.AbstractConfiguradorProtocolo;
import jalis.laboratorio.util.parsers.FabricaConfigurador;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.laboratorio.util.parsers.alvaro.ExameAlvaro;
import jalis.model.bean.recepcao.RequisicaoBean;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.service.recepcao.RequisicaoService;
import jalis.service.triagem.LoteExternoExameRequisicaoService;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.sql.ConstrutorInsert;
import jalis.util.tabela.Registro;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class UtilExportadores {
    public static final String GERAR_LOTE = "gerarLote";
    public static final String LEQ_RETORNO_WS = "LEQ_RETORNO_WS";
    public static final String MCO_CODIGO = "mco_codigo";
    public static final String EXA_CODIGO = "exa_codigo";
    protected static final String[] campos = new String[]{"fil_codigo", "req_codigo", "pac_nome", "req_data", "listaexames", "backup_lista_exames", "listaexamesrequisicao", "med_nome", "pac_datanasc", "req_idade", "req_peso", "req_totpago", "req_obs", "chave", "pac_codigo", "req_anomes", "med_conselho", "pac_sexo", "req_total", "req_dum", "med_uf", "req_hora", "req_deveguia", "med_crm", "req_altura", "req_dclinicos", "req_codigomae"};

    public static boolean haExamesEnviarLabAlvaro(String codigoFilial, String codigoRequisicao, Statement st) throws SQLException {
        Object[] multiguia = null;
        try {
            multiguia = RecepcaoUtil.verificaMultiGuias(st, codigoFilial, codigoRequisicao, true, false);
        }
        catch (SQLException e1) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e2o foi poss\u00edvel verificiar multiguia no carregamento de lote.\n" + e1.getMessage(), e1.getStackTrace());
        }
        Arrays.sort(multiguia);
        String guias = StringUtil.implode(Arrays.asList(multiguia), ",");
        StringBuilder buf = new StringBuilder();
        buf.append(" select lab.lae_configuracao, (lote.lex_codigo is null or lr.leq_retornows is null) as haExame ");
        buf.append("   from examerequisicao exr ");
        buf.append("   join requisicao req on exr.fil_codigo = req.fil_codigo and exr.req_codigo = req.req_codigo ");
        buf.append("   join examematcoletalabexterno ele on exr.fil_codigo = ele.fil_codigo and exr.exa_codigo = ele.exa_codigo and exr.mco_codigo = ele.mco_codigo ");
        buf.append(" left join loteexternorequisicao lr on lr.fil_codigo = req.fil_codigo and lr.req_codigo = req.req_codigo ");
        buf.append(" left join labexterno lab on ele.fil_codigo = lab.fil_codigo and ele.lae_codigo = lab.lae_codigo ");
        buf.append(" left join loteexternoexamerequisicao lote on exr.fil_codigo = lote.fil_codigo and exr.exa_codigo = lote.exa_codigo and exr.mco_codigo = lote.mco_codigo and exr.req_codigo = lote.req_codigo and exr.fil_Codigo = lote.fil_codigo ");
        buf.append("  where exr.fil_codigo = ").append(codigoFilial);
        buf.append("    and req.req_codigo IN (").append(guias).append(") ");
        buf.append("    and ele.ele_padrao ");
        buf.append("    and lr.leq_dataestorno is null ");
        buf.append("    and not req.req_excluida ");
        buf.append("    and not exr.exr_excluido ");
        buf.append("    and lab.lae_protocolo = '").append((Object)Protocolo.Alvaro).append("' ");
        buf.append("    and (lote.lex_codigo is null or lr.leq_retornows is null) ");
        ResultSet rs = st.executeQuery(buf.toString());
        if (rs.next()) {
            String configuracaoLabExterno = rs.getString("lae_configuracao");
            boolean enviarUsandoWS = !Funcoes.textoVazio(StringUtil.getValor(configuracaoLabExterno, "enviarLoteWebService")) ? Boolean.valueOf(StringUtil.getValor(configuracaoLabExterno, "enviarLoteWebService")) : Boolean.FALSE;
            boolean isEnvioAutomatico = !Funcoes.textoVazio(StringUtil.getValor(configuracaoLabExterno, "envioAutomatico")) ? Boolean.valueOf(StringUtil.getValor(configuracaoLabExterno, "envioAutomatico")) : Boolean.FALSE;
            if (!enviarUsandoWS || !isEnvioAutomatico) {
                return false;
            }
            return rs.getBoolean("haExame");
        }
        return false;
    }

    public static boolean haExamesEnviarDB(String codigoFilial, String codigoRequisicao, String[] exames, Statement st) throws SQLException {
        ResultSet rs;
        Object[] multiguia = null;
        try {
            multiguia = RecepcaoUtil.verificaMultiGuias(st, codigoFilial, codigoRequisicao, true, false);
        }
        catch (SQLException e1) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e2o foi poss\u00edvel verificiar multiguia no carregamento de lote.\n" + e1.getMessage(), e1.getStackTrace());
        }
        Arrays.sort(multiguia);
        String guias = StringUtil.implode(Arrays.asList(multiguia), ",");
        StringBuilder buf = new StringBuilder();
        buf.append(" select lab.lae_configuracao, (lote.lex_codigo is null or lr.leq_retornows is null) as haExame ");
        buf.append("   from examerequisicao exr ");
        buf.append("   join requisicao req on exr.fil_codigo = req.fil_codigo and exr.req_codigo = req.req_codigo ");
        buf.append("   join examematcoletalabexterno ele on exr.fil_codigo = ele.fil_codigo and exr.exa_codigo = ele.exa_codigo and exr.mco_codigo = ele.mco_codigo ");
        buf.append(" left join loteexternorequisicao lr on lr.fil_codigo = req.fil_codigo and lr.req_codigo = req.req_codigo ");
        buf.append(" left join labexterno lab on ele.fil_codigo = lab.fil_codigo and ele.lae_codigo = lab.lae_codigo ");
        buf.append(" left join loteexternoexamerequisicao lote on exr.fil_codigo = lote.fil_codigo and exr.exa_codigo = lote.exa_codigo and exr.mco_codigo = lote.mco_codigo and exr.req_codigo = lote.req_codigo and exr.fil_Codigo = lote.fil_codigo ");
        buf.append("  where exr.fil_codigo = ").append(codigoFilial);
        buf.append("    and req.req_codigo IN (").append(guias).append(") ");
        buf.append("    and ele.ele_padrao ");
        buf.append("    and lr.leq_dataestorno is null ");
        buf.append("    and not req.req_excluida ");
        buf.append("    and not exr.exr_excluido ");
        buf.append("    and (lote.lex_codigo is null or lr.leq_retornows is null) ");
        buf.append("    and lab.lae_protocolo = '").append((Object)Protocolo.DBV2).append("' ");
        buf.append("    and (lab.lae_inativo is null or not lab.lae_inativo) ");
        if (null != exames && exames.length > -1) {
            buf.append("    and exr.exa_codigo in ('").append(exames[0]).append("')");
        }
        if ((rs = st.executeQuery(buf.toString())).next()) {
            String configuracaoLabExterno = rs.getString("lae_configuracao");
            if (Funcoes.textoVazio(configuracaoLabExterno)) {
                return false;
            }
            boolean enviarUsandoWS = !Funcoes.textoVazio(StringUtil.getValor(configuracaoLabExterno, "enviarLoteWebservice")) ? Boolean.valueOf(StringUtil.getValor(configuracaoLabExterno, "enviarLoteWebservice")) : Boolean.FALSE;
            boolean isEnvioAutomatico = !Funcoes.textoVazio(StringUtil.getValor(configuracaoLabExterno, "enviarLotePelaRequisicao")) ? Boolean.valueOf(StringUtil.getValor(configuracaoLabExterno, "enviarLotePelaRequisicao")) : Boolean.FALSE;
            if (!enviarUsandoWS || !isEnvioAutomatico) {
                return false;
            }
            return rs.getBoolean("haExame");
        }
        return false;
    }

    public static String getXMLConfiguracaoProtocolo(Statement st, int codigoLaboratorioExterno) throws Exception {
        StringBuilder buf = new StringBuilder("select lae_configuracao from labexterno ");
        buf.append("where fil_codigo = ").append(Variaveis.filialPadrao);
        buf.append(" and lae_codigo = ").append(codigoLaboratorioExterno);
        ResultSet rs = st.executeQuery(buf.toString());
        if (rs.next()) {
            return rs.getString("lae_configuracao");
        }
        return "";
    }

    public static Registro geraRegistroLote(String filial, String requisicao, LaboratorioExterno labExterno, Statement st, boolean agruparGuiasInterface, int digitosTuboFilial, int digitosTuboRequisicao) throws Exception {
        Registro reg = null;
        StringBuilder bui = new StringBuilder("select \n");
        bui.append("  a.fil_codigo, a.req_codigo, a.req_data, a.req_hora, a.req_dum, a.req_obs, \n");
        bui.append("  a.req_peso, a.req_altura, a.req_anomes, a.req_idade, \n");
        bui.append("  b.pac_codigo, b.pac_nome, b.pac_sexo, b.pac_datanasc, a.req_totpago, a.req_total, a.req_deveguia, \n");
        bui.append("  a.med_conselho, a.med_crm, a.med_uf, c.med_nome, a.req_dclinicos, d.req_codigo as req_codigomae, \n");
        bui.append("  a.con_codigo \n");
        bui.append("from requisicao a \n");
        bui.append("left join paciente b \n");
        bui.append("  on a.fil_codigo = b.fil_codigo and a.pac_codigo = b.pac_codigo \n");
        bui.append("left join medico c \n");
        bui.append("  on a.fil_codigo = c.fil_codigo and a.med_conselho = c.med_conselho and a.med_crm = c.med_crm and a.med_uf = c.med_uf \n");
        bui.append("left join requisicaorequisicao d on a.fil_codigo = d.fil_codigo and a.req_codigo = d.req_kodigo \n");
        bui.append("where \n");
        bui.append("  a.fil_codigo = ").append(filial).append(" and \n");
        bui.append("  a.req_codigo = ").append(requisicao);
        bui.append(" and a.req_excluida = false ");
        ResultSet res = st.executeQuery(bui.toString());
        if (res.next()) {
            reg = new Registro(res);
            reg.setValor("req_data", Funcoes.formataData("dd/MM/yyyy", res.getDate("req_data")));
            UtilExportadores.adicionarExames(st, reg, labExterno, agruparGuiasInterface, digitosTuboFilial, digitosTuboRequisicao);
        }
        return reg;
    }

    private static void adicionarExames(Statement st, Registro reg, LaboratorioExterno labExterno, boolean agruparGuiasInterface, int digitosTuboFilial, int digitosTuboRequisicao) throws Exception {
        if (Variaveis.integrarDadosEntreFiliais) {
            HashMap<String, Object> chaves = new HashMap<String, Object>();
            try {
                chaves.put("req_codigo", reg.getString("req_codigo"));
                chaves.put("fil_codigo", reg.getString("fil_codigo"));
                RequisicaoBean requisicaoBean = (RequisicaoBean)new RequisicaoService().getBean(chaves);
                if (requisicaoBean != null && requisicaoBean.getFilial() != null) {
                    Integer filialLogada = Integer.parseInt(Variaveis.filialPadrao);
                    if (!requisicaoBean.getFilial().getCodigo().equals(filialLogada)) {
                        return;
                    }
                }
            }
            catch (Exception e) {
                throw new ThreadDaoException("N\u00e3o foi poss\u00edvel consultar requisi\u00e7\u00e3o para exporta\u00e7\u00e3o para apoio.\nMensagem: " + e.getMessage());
            }
        }
        if (labExterno.protocolo.getExigeDataNascimento() && Funcoes.textoVazio(reg.getString("pac_datanasc"))) {
            String msg = "O paciente da requisi\u00e7\u00e3o \"" + reg.getString("req_codigo") + "\" n\u00e3o tem data de nascimento.\nO laborat\u00f3rio externo selecionado exige esse item.";
            Funcoes.mensagem(null, msg, 1);
            return;
        }
        String msgaColetarFaltaMat = null;
        if (st != null) {
            try {
                DadosAdicionais dadosAdicionais;
                boolean agruparMultiguias;
                StringBuilder bui = new StringBuilder("select a.fil_codigo, a.req_codigo, \n");
                bui.append("  (CASE WHEN (trim(f.ere_codigoapoiado) != '') THEN cast(trim(f.ere_codigoapoiado) AS varchar) ELSE cast(trim(a.exr_codigoapoiado) AS varchar) END) AS exr_codigoapoiado, ");
                bui.append("  a.exr_descricaomaterial, a.exr_datamaterial, a.exr_volumediurese, cast(a.exr_tempodiurese as varchar) as ext_tempodiurese, ");
                bui.append("  a.exr_situacao, (a.exr_dataloteexterno is not null) as ").append("exa_exportado").append(", ");
                bui.append("  b.exa_codigo, b.exa_descricao, a.exr_urgente, a.exr_situacao,");
                bui.append("  c.mco_codigo, c.mco_abreviatura, c.mco_solicitarmat, c.mco_descricao, ");
                bui.append("  g.ele_xmllabexterno, a.exr_datamaterial, ");
                bui.append("  g.ele_diasprazo, g.ele_valorexame, h.req_codigo as req_codigomae, ");
                bui.append("  coalesce(g.lae_codigo = ").append(labExterno.codigoLab).append(", false) as ").append("exa_externo");
                bui.append(" ,'' as recipapresentacao ");
                bui.append(" ,array_agg(distinct cast(f.rec_kodigo as varchar))::varchar[] as rec_kodigo ");
                bui.append(" , '' as etiquetaDigitada ");
                bui.append(" , case  when CHAR_LENGTH(rec.rec_descricao) >= 20 then SUBSTR(rec.rec_descricao, 0,20) else  (case when CHAR_LENGTH(rec.rec_descricao) == 0 then 'N\u00e3o Informado' ele rec.rec_descricao end) end ");
                bui.append(" from examerequisicao a ");
                bui.append(" left join exames b on a.fil_codigo = b.fil_codigo and a.exa_codigo = b.exa_codigo ");
                bui.append(" left join materialcoleta c   on a.fil_codigo = c.fil_codigo and a.mco_codigo = c.mco_codigo ");
                bui.append(" left join examematcoleta d on a.fil_codigo = d.fil_codigo and a.exa_codigo = d.exa_codigo and a.mco_codigo = d.mco_codigo ");
                bui.append(" left join requisicao e on a.fil_codigo = e.fil_codigo and a.req_codigo = e.req_codigo ");
                bui.append(" left join examerequisicaorecipiente f on a.fil_codigo = f.fil_codigo and a.exa_codigo = f.exa_codigo and a.req_codigo = f.req_codigo and a.mco_codigo = f.mco_codigo and f.ere_tipo = '").append("C").append("' ");
                bui.append(" left join examematcoletalabexterno g on a.fil_codigo = g.fil_codigo and a.exa_codigo = g.exa_codigo and a.mco_codigo = g.mco_codigo  and g.lae_codigo = ").append(labExterno.codigoLab);
                bui.append(" left join requisicaorequisicao h on a.fil_codigo = h.fil_codigo and a.req_codigo = h.req_kodigo ");
                bui.append(" left join recipientes rec on rec.fil_codigo = a.fil_codigo and rec.rec_codigo = f.rec_kodigo  ");
                bui.append(" where ");
                bui.append(" a.fil_codigo = ").append(reg.getString("fil_codigo")).append(" and ");
                bui.append(" a.req_codigo = ").append(reg.getString("req_codigo"));
                bui.append(" and a.exr_excluido = false ");
                bui.append(" and coalesce(g.ele_bloqueado, false) = false ");
                bui.append("  group by (CASE WHEN (trim(f.ere_codigoapoiado) != '') THEN cast(trim(f.ere_codigoapoiado) AS varchar) ELSE cast(trim(a.exr_codigoapoiado) AS varchar) END) ");
                bui.append(" ,a.exr_descricaomaterial ");
                bui.append(" ,a.exr_datamaterial ");
                bui.append(" ,a.exr_volumediurese ");
                bui.append(" ,a.exr_situacao ");
                bui.append(" ,b.exa_codigo ");
                bui.append(" ,b.exa_descricao ");
                bui.append(" ,a.exr_urgente ");
                bui.append(" ,a.exr_situacao ");
                bui.append(" ,c.mco_codigo ");
                bui.append(" ,c.mco_abreviatura ");
                bui.append(" ,c.mco_solicitarmat ");
                bui.append(" ,c.mco_descricao ");
                bui.append(" ,g.ele_xmllabexterno ");
                bui.append(" ,a.exr_datamaterial ");
                bui.append(" ,g.ele_diasprazo ");
                bui.append(" ,g.ele_valorexame ");
                bui.append("  ,h.req_codigo ");
                bui.append(" ,a.exr_tempodiurese ");
                bui.append(" ,a.exr_dataloteexterno ");
                bui.append(" ,g.lae_codigo ");
                bui.append(" ,rec.rec_descricao, a.fil_codigo, a.req_codigo ");
                ResultSet res = st.executeQuery(bui.toString());
                ArrayList<Registro> exames = new ArrayList<Registro>();
                ArrayList<String> examesInserido = new ArrayList<String>();
                ArrayList<Registro> examesNaoExp = new ArrayList<Registro>();
                boolean contemExameExportado = false;
                while (res.next()) {
                    String[] valores;
                    Registro exa = new Registro(res);
                    if (exa.getValor("rec_kodigo") != null && exa.getValor("rec_kodigo") instanceof Array && (valores = (String[])((Array)exa.getValor("rec_kodigo")).getArray()).length > 0 && (valores.length != 1 || !Funcoes.textoVazio(valores[0]))) {
                        exa.setValor("recipapresentacao", exa.getString("rec_kodigo").replace("{", "").replace("}", ""));
                    }
                    int qtd = UtilExportadores.quantidadeTuboRecipiente(exa, st);
                    if (res.getBoolean("exa_exportado") && res.getBoolean("etiquetaDigitada") && qtd <= 1) {
                        contemExameExportado = true;
                    }
                    if (exa.getValor("exr_situacao") == null) {
                        exa.setValor("exr_situacao", "");
                    }
                    if (examesInserido.contains(exa.getString(EXA_CODIGO).concat(exa.getString(MCO_CODIGO)).concat(exa.getString("rec_codigo")))) continue;
                    if (!exa.getBoolean("exa_exportado") && exa.getBoolean("exa_externo") && !Funcoes.textoVazio(exa.getString("ele_xmllabexterno")) && (Funcoes.textoVazio(res.getString("exr_situacao")) || res.getString("exr_situacao").equals("O"))) {
                        exames.add(exa);
                    } else {
                        examesNaoExp.add(exa);
                    }
                    if ((exa.getValor("exa_exportado") == null || !exa.getBoolean("exa_exportado")) && exa.getValor("exa_externo") != null && exa.getBoolean("exa_externo") && (res.getString("exr_situacao") != null && res.getString("exr_situacao").equals("T") || res.getString("exr_situacao").equals("F"))) {
                        msgaColetarFaltaMat = "a coletar ou falta material!";
                    }
                    if (Funcoes.textoVazio(exa.getString("ele_xmllabexterno")) && exa.getValor("exa_externo") != null && exa.getBoolean("exa_externo")) {
                        Funcoes.mensagem(null, String.format("O exame %s|%s n\u00e3o possui o exame relacionado na sua configura\u00e7\u00e3o para o laborat\u00f3rio externo, verifique!", exa.getString(EXA_CODIGO), exa.getString(MCO_CODIGO)), 2);
                    }
                    examesInserido.add(exa.getString(EXA_CODIGO).concat(exa.getString(MCO_CODIGO)).concat(exa.getString("rec_codigo")));
                }
                reg.setValor("listaexames", exames);
                UtilExportadores.processaDesm(reg, exames, labExterno, st);
                reg.setValor(campos[6], examesNaoExp);
                reg.setValor("chave", UtilExportadores.getChave(reg, digitosTuboFilial, digitosTuboRequisicao));
                boolean bl = agruparMultiguias = agruparGuiasInterface || DBUtil.requisicaoAgrupaMultiguiasLabExterno(st, reg.getString("fil_codigo"), reg.getString("req_codigo"));
                if (agruparMultiguias) {
                    ArrayList<Registro> examesDiferentes = new ArrayList<Registro>();
                    HashSet exameMultiguias = new HashSet();
                    HashSet requisicaoAdicionada = new HashSet();
                    Integer[] multiguias = RecepcaoUtil.verificaMultiGuias(st, reg.getString("fil_codigo"), reg.getString("req_codigo"), false, false);
                    if (multiguias != null && multiguias.length > 0) {
                        if (!((Collection)reg.getValor("listaexames")).isEmpty()) {
                            requisicaoAdicionada.addAll((Collection)reg.getValor("listaexames"));
                        }
                        if (!exameMultiguias.isEmpty()) {
                            HashSet<String> chaves = new HashSet<String>();
                            int examesIguais = 0;
                            for (Registro exameRequisicao : requisicaoAdicionada) {
                                String chaveAdd = exameRequisicao.getString(EXA_CODIGO) + exameRequisicao.getString(MCO_CODIGO);
                                examesIguais = 0;
                                for (Registro exameMultiguas : exameMultiguias) {
                                    String chaveMult = exameMultiguas.getString(EXA_CODIGO) + exameMultiguas.getString(MCO_CODIGO);
                                    if (!chaveMult.equals(chaveAdd)) continue;
                                    if (!chaves.contains(chaveMult)) {
                                        ++examesIguais;
                                    }
                                    chaves.add(chaveAdd);
                                }
                                if (examesIguais != 0) continue;
                                examesDiferentes.add(exameRequisicao);
                            }
                            if (examesDiferentes.isEmpty()) {
                                reg.setValor("listaexames", examesDiferentes);
                            }
                        }
                    }
                    if (!examesDiferentes.isEmpty()) {
                        reg.setValor("listaexames", examesDiferentes);
                    }
                }
                if ((dadosAdicionais = FabricaExportador.novoDadosAdicionais(labExterno.protocolo)) != null && !dadosAdicionais.carregaAdicionais(labExterno.codigoLab, reg)) {
                    return;
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "CriaLoteExportacao: 131");
            }
        }
    }

    public static int quantidadeTuboRecipiente(Registro exa, Statement st) throws Exception {
        ResultSet rs = null;
        try {
            StringBuilder sql = new StringBuilder();
            sql.append(" select count(1) as qtd from examerequisicaorecipiente  ");
            sql.append(" where fil_codigo = ").append(exa.getString("fil_codigo"));
            sql.append(" and req_codigo = ").append(exa.getInt("req_codigo"));
            sql.append(" and exa_codigo = '").append(exa.getString(EXA_CODIGO)).append("' ");
            sql.append(" and mco_codigo = ").append(exa.getInt(MCO_CODIGO));
            rs = st.executeQuery(sql.toString());
            if (rs.next()) {
                int n = rs.getInt("qtd");
                return n;
            }
        }
        catch (Exception e) {
            throw new ThreadDaoException("N\u00e3o foi poss\u00edvel verificar os tubos." + e.getMessage());
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
        }
        return 0;
    }

    public static String getChave(Registro reg, int digitosFilial, int digitosReq) {
        return Funcoes.preencheZero(reg.getInt("fil_codigo"), digitosFilial).concat(Funcoes.preencheZero(reg.getInt("req_codigo"), digitosReq));
    }

    public static List<Registro> getExamesDesmembrados(String filial, Registro pai, String labexterno, Set<String> chaves, Statement st) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append("select a.exa_codigo, a.exa_kodigo, a.mco_kodigo, '' as dadosadicionais, 0 as exr_volumediurese, b.ele_xmllabexterno as ele_xmllabexterno ");
        sql.append("  from examematcoletalabextdesm a ");
        sql.append("  left join examematcoletalabexterno b on a.fil_codigo = b.fil_codigo and a.exa_kodigo = b.exa_codigo and a.mco_codigo = b.mco_codigo and a.lae_codigo = b.lae_codigo ");
        sql.append(" where a.fil_codigo = ").append(filial);
        sql.append("   and a.exa_codigo = '").append(pai.getString(EXA_CODIGO)).append("'");
        sql.append("   and a.mco_codigo = ").append(pai.getString(MCO_CODIGO));
        sql.append("   and a.lae_codigo = ").append(labexterno);
        ArrayList<Registro> desmembrados = new ArrayList<Registro>();
        ResultSet rs = st.executeQuery(sql.toString());
        boolean i = false;
        while (rs.next()) {
            Registro registro = pai.clone();
            registro.setValor(EXA_CODIGO, rs.getString("exa_kodigo"));
            registro.setValor("exa_kodigo", rs.getString(EXA_CODIGO));
            registro.setValor("mco_kodigo", rs.getString("mco_kodigo"));
            registro.setValor("ele_xmllabexterno", rs.getString("ele_xmllabexterno"));
            String chave = rs.getString("exa_kodigo") + rs.getString("mco_kodigo");
            if (!chaves.contains(chave)) {
                desmembrados.add(registro);
            }
            chaves.add(chave);
        }
        return desmembrados;
    }

    public static void processaDesm(Registro requisicao, List<Registro> exames, LaboratorioExterno labSelecionado, Statement st) throws Exception {
        try {
            HashSet<String> chaves = new HashSet<String>();
            ArrayList<Registro> desmembrados = new ArrayList<Registro>();
            for (Registro exa : exames) {
                List<Registro> desm = UtilExportadores.getExamesDesmembrados(Variaveis.filialPadrao, exa, labSelecionado.codigoLab, chaves, st);
                exa.setValor("listaexames", desm);
                if (desm != null && !desm.isEmpty()) {
                    desmembrados.addAll(desm);
                    continue;
                }
                String chave = exa.getString(EXA_CODIGO) + exa.getString(MCO_CODIGO);
                if (!chaves.contains(chave)) {
                    desmembrados.add(exa);
                }
                chaves.add(chave);
            }
        }
        catch (Exception e) {
            throw new ThreadDaoException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<Registro> gravarLote(int novoLote, LaboratorioExterno labSelecionado, Map<String, Registro> lista, Statement st, boolean isColetaWeb) throws Exception {
        ArrayList<Registro> retorno;
        block32: {
            retorno = new ArrayList<Registro>();
            try {
                if (st == null) break block32;
                for (String key : lista.keySet()) {
                    Registro req = lista.get(key);
                    List exames = (List)req.getValor("listaexames");
                    if (exames == null || exames.size() == 0) continue;
                    int novoLoteTemp = UtilExportadores.descobriMetodoEnvioWebService(req, labSelecionado, st);
                    StringBuilder sql = new StringBuilder();
                    boolean temRequisicaoLote = UtilExportadores.verificaRequisicaoLoteRetorno(req, labSelecionado, req.getString("req_codigo"), st);
                    ConstrutorInsert insert = new ConstrutorInsert("loteexterno");
                    if (!temRequisicaoLote) {
                        boolean temLote = UtilExportadores.verificaExistenciaLote(req.getString("fil_codigo"), novoLote, labSelecionado, st);
                        if (!temLote) {
                            insert.addCampoValor("fil_codigo", req.getString("fil_codigo"));
                            insert.addCampoValor("lex_codigo", novoLote);
                            insert.addCampoValor("lae_codigo", labSelecionado.codigoLab);
                            insert.addCampoValor("lex_datahora", "current_timestamp");
                            insert.addCampoValor("usr_codcriacao", Variaveis.login, true);
                            if (isColetaWeb) {
                                st.executeUpdate(insert.getSQL());
                            } else {
                                Conexao.execute(req.getString("fil_codigo"), st, insert.getSQL());
                            }
                        }
                        insert.limpar("loteexternorequisicao");
                        insert.addCampoValor("fil_codigo", req.getString("fil_codigo"));
                        insert.addCampoValor("fil_kodigo", req.getString("fil_codigo"));
                        insert.addCampoValor("lex_codigo", novoLote);
                        insert.addCampoValor("req_codigo", req.getString("req_codigo"));
                        insert.addCampoValor("lae_codigo", labSelecionado.codigoLab);
                        if (isColetaWeb) {
                            st.executeUpdate(insert.getSQL());
                        } else {
                            Conexao.execute(req.getString("fil_codigo"), st, insert.getSQL());
                        }
                        req.setValor("lex_codigo", novoLote);
                        req.setValor("novoLote", novoLote);
                        req.setValor("metodoEnvio", "PUT");
                    } else if (req.getBoolean("temretornows")) {
                        req.setValor("metodoEnvio", "POST");
                    } else {
                        req.setValor("metodoEnvio", "PUT");
                    }
                    UtilExportadores.processaDesm(req, exames, labSelecionado, st);
                    retorno.add(req);
                    HashSet<String> chaves = new HashSet<String>();
                    for (Registro exa : exames) {
                        List desmembrados;
                        String[] valores;
                        String chave = exa.getString(EXA_CODIGO) + exa.getString(MCO_CODIGO);
                        int qtd = UtilExportadores.quantidadeTuboRecipiente(exa, st);
                        if ((!exa.getBoolean("exa_externo") || exa.getBoolean("exa_exportado") || chaves.contains(chave)) && (!exa.getBoolean("exa_exportado") || qtd <= 1 || chaves.contains(chave))) continue;
                        if (temRequisicaoLote) {
                            sql = new StringBuilder();
                            sql.append("select 1 from loteexternoexamerequisicao ");
                            sql.append(" where fil_codigo = ").append(req.getString("fil_codigo"));
                            sql.append("   and lex_codigo = ").append(req.getString("lex_codigo"));
                            sql.append("   and lae_codigo = ").append(labSelecionado.codigoLab);
                            sql.append("   and req_codigo = ").append(req.getString("req_codigo"));
                            sql.append("   and mco_codigo = ").append(exa.getString(MCO_CODIGO));
                            sql.append("   and exa_codigo = '").append(exa.getString(EXA_CODIGO)).append("' ");
                            ResultSet existe = st.executeQuery(sql.toString());
                            if (!existe.next()) {
                                insert.limpar("loteexternoexamerequisicao");
                                insert.addCampoValor("fil_codigo", req.getString("fil_codigo"));
                                insert.addCampoValor("fil_kodigo", req.getString("fil_codigo"));
                                insert.addCampoValor("lex_codigo", req.getString("lex_codigo"));
                                insert.addCampoValor("lae_codigo", labSelecionado.codigoLab);
                                insert.addCampoValor("req_codigo", req.getString("req_codigo"));
                                insert.addCampoValor(EXA_CODIGO, exa.getString(EXA_CODIGO), true);
                                insert.addCampoValor(MCO_CODIGO, exa.getString(MCO_CODIGO));
                                insert.addCampoValor("ler_prazo", exa.getString("ele_diasprazo") != null ? exa.getInt("ele_diasprazo") : 0);
                                insert.addCampoValor("ler_custo", exa.getString("ele_valorexame") != null ? exa.getDouble("ele_valorexame") : 0.0);
                                if (isColetaWeb) {
                                    st.executeUpdate(insert.getSQL());
                                } else {
                                    Conexao.execute(req.getString("fil_codigo"), st, insert.getSQL());
                                }
                            }
                            boolean isLoteEstornado = UtilExportadores.verificaEstornoLote(req, st);
                            boolean isLoteRequisicaoEstornado = UtilExportadores.verificaEstornoLoteRequisicao(req, labSelecionado, st);
                            if (isLoteEstornado) {
                                sql = new StringBuilder();
                                sql.append(" update  loteexterno set lex_dataestorno = null, usr_codestorno = null ");
                                sql.append(" where fil_codigo = ").append(req.getString("fil_codigo"));
                                sql.append("   and lex_codigo = ").append(req.getString("lex_codigo"));
                                sql.append("   and lae_codigo = ").append(labSelecionado.codigoLab);
                                st.execute(sql.toString());
                            }
                            if (isLoteRequisicaoEstornado) {
                                sql = new StringBuilder();
                                sql.append(" update  loteexternorequisicao set leq_dataestorno = null, usr_codestorno = null ");
                                sql.append(" where fil_codigo = ").append(req.getString("fil_codigo"));
                                sql.append("   and lex_codigo = ").append(req.getString("lex_codigo"));
                                sql.append("   and lae_codigo = ").append(labSelecionado.codigoLab);
                                sql.append("   and req_codigo = ").append(req.getString("req_codigo"));
                                st.execute(sql.toString());
                            }
                        } else {
                            insert.limpar("loteexternoexamerequisicao");
                            insert.addCampoValor("fil_codigo", req.getString("fil_codigo"));
                            insert.addCampoValor("fil_kodigo", req.getString("fil_codigo"));
                            insert.addCampoValor("lex_codigo", novoLote);
                            insert.addCampoValor("lae_codigo", labSelecionado.codigoLab);
                            insert.addCampoValor("req_codigo", req.getString("req_codigo"));
                            insert.addCampoValor(EXA_CODIGO, exa.getString(EXA_CODIGO), true);
                            insert.addCampoValor(MCO_CODIGO, exa.getString(MCO_CODIGO));
                            insert.addCampoValor("ler_prazo", exa.getString("ele_diasprazo") != null ? exa.getInt("ele_diasprazo") : 0);
                            insert.addCampoValor("ler_custo", exa.getString("ele_valorexame") != null ? exa.getDouble("ele_valorexame") : 0.0);
                            if (isColetaWeb) {
                                st.executeUpdate(insert.getSQL());
                            } else {
                                Conexao.execute(req.getString("fil_codigo"), st, insert.getSQL());
                            }
                        }
                        if (exa.getValor("rec_kodigo") != null && exa.getValor("rec_kodigo") instanceof Array && (valores = (String[])((Array)exa.getValor("rec_kodigo")).getArray()).length > 0 && (valores.length != 1 || !Funcoes.textoVazio(valores[0]))) {
                            boolean existe = false;
                            if (temRequisicaoLote) {
                                sql = new StringBuilder();
                                sql.append("select * from loteexternoexamerequisicaorecip lexr ");
                                sql.append(" where lexr.fil_codigo = ").append(req.getString("fil_codigo"));
                                sql.append(" \t and lexr.lex_codigo = ").append(req.getString("lex_codigo"));
                                sql.append("   and lexr.lae_codigo = ").append(labSelecionado.codigoLab);
                                sql.append("   and lexr.req_codigo = ").append(req.getString("req_codigo"));
                                sql.append("   and lexr.mco_codigo = ").append(exa.getString(MCO_CODIGO));
                                sql.append("   and lexr.exa_codigo = '").append(exa.getString(EXA_CODIGO)).append("' ");
                                ResultSet rsExiste = st.executeQuery(sql.toString());
                                existe = rsExiste.next();
                            }
                            if (!existe && Funcoes.textoVazioNotNullIsNumberTubo(StringUtil.limpaString(exa.getString("rec_kodigo"), new String[]{"{", "}"}))) {
                                insert.limpar("loteexternoexamerequisicaorecip");
                                insert.addCampoValor("fil_codigo", req.getString("fil_codigo"));
                                insert.addCampoValor("fil_kodigo", req.getString("fil_codigo"));
                                insert.addCampoValor("lex_codigo", temRequisicaoLote ? req.getString("lex_codigo") : Integer.valueOf(novoLote));
                                insert.addCampoValor("lae_codigo", labSelecionado.codigoLab);
                                insert.addCampoValor("req_codigo", req.getString("req_codigo"));
                                insert.addCampoValor(EXA_CODIGO, exa.getString(EXA_CODIGO), true);
                                insert.addCampoValor(MCO_CODIGO, exa.getString(MCO_CODIGO));
                                insert.addCampoValor("rec_codigo", StringUtil.limpaString(exa.getString("rec_kodigo"), new String[]{"{", "}"}));
                                if (isColetaWeb) {
                                    st.executeUpdate(insert.getSQL());
                                } else {
                                    Conexao.execute(req.getString("fil_codigo"), st, insert.getSQL());
                                }
                            }
                        }
                        if (exa.getValor("listaexames") != null && (desmembrados = (List)exa.getValor("listaexames")).size() > 0) {
                            for (int k = 0; k < desmembrados.size(); ++k) {
                                Registro desm = (Registro)desmembrados.get(k);
                                sql = new StringBuilder();
                                sql.append("select * from loteexternoexamerequisicaodesm ");
                                sql.append(" where fil_codigo = ").append(req.getString("fil_codigo"));
                                sql.append("   and req_codigo = ").append(req.getString("req_codigo"));
                                sql.append("   and lae_codigo = ").append(labSelecionado.codigoLab);
                                sql.append("   and lex_codigo = ").append(temRequisicaoLote ? req.getString("lex_codigo") : Integer.valueOf(novoLote));
                                sql.append("   and mco_kodigo = ").append(desm.getString(MCO_CODIGO));
                                sql.append("   and exa_kodigo = '").append(desm.getString(EXA_CODIGO)).append("' ");
                                ResultSet existe = st.executeQuery(sql.toString());
                                if (existe.next()) continue;
                                insert.limpar("loteexternoexamerequisicaodesm");
                                insert.addCampoValor("fil_codigo", req.getString("fil_codigo"));
                                insert.addCampoValor("fil_kodigo", req.getString("fil_codigo"));
                                insert.addCampoValor("lex_codigo", temRequisicaoLote ? req.getString("lex_codigo") : Integer.valueOf(novoLote));
                                insert.addCampoValor("lae_codigo", labSelecionado.codigoLab);
                                insert.addCampoValor("req_codigo", req.getString("req_codigo"));
                                insert.addCampoValor(EXA_CODIGO, exa.getString(EXA_CODIGO), true);
                                insert.addCampoValor(MCO_CODIGO, exa.getString(MCO_CODIGO));
                                insert.addCampoValor("exa_kodigo", desm.getValor(EXA_CODIGO), true);
                                insert.addCampoValor("mco_kodigo", desm.getValor("mco_kodigo"));
                                if (isColetaWeb) {
                                    st.executeUpdate(insert.getSQL());
                                    continue;
                                }
                                Conexao.execute(req.getString("fil_codigo"), st, insert.getSQL());
                            }
                        }
                        chaves.add(chave);
                        UtilExportadores.gravarExamesExportados(req, exa, st, isColetaWeb);
                    }
                }
            }
            catch (Exception e) {
                try {
                    ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel gravar o lote para o laborat\u00f3rio apoio.\n" + e.getMessage(), e.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
        return retorno;
    }

    public static boolean verificaRequisicaoLoteRetorno(Registro req, LaboratorioExterno labSelecionado, String requisicao, Statement st) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append("select lex_codigo as lote,  coalesce(length(leq_retornows),0) > 0 as retorno from loteexternorequisicao ");
        sql.append(" where fil_codigo = ").append(req.getString("fil_codigo"));
        sql.append(" and lae_codigo = ").append(labSelecionado.codigoLab);
        sql.append(" and req_codigo in (").append(requisicao).append(")");
        ResultSet resultSetExisteLoteRequisicao = st.executeQuery(sql.toString());
        if (resultSetExisteLoteRequisicao.next()) {
            req.setValor("temretornows", resultSetExisteLoteRequisicao.getBoolean("retorno"));
            req.setValor("lex_codigo", resultSetExisteLoteRequisicao.getInt("lote"));
            return true;
        }
        return false;
    }

    public static boolean verificaExistenciaLote(String filial, Integer lote, LaboratorioExterno labSelecionado, Statement st) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append("select count(1) > 0 as temLote from loteexterno ");
        sql.append(" where lae_codigo = ").append(labSelecionado.codigoLab);
        sql.append("   and lex_codigo = ").append(lote);
        sql.append("   and fil_codigo = ").append(filial);
        ResultSet resultSetExisteLote = st.executeQuery(sql.toString());
        if (resultSetExisteLote.next()) {
            return resultSetExisteLote.getBoolean("temLote");
        }
        return false;
    }

    public static boolean verificaEstornoLoteRequisicao(Registro req, LaboratorioExterno labSelecionado, Statement st) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append("select 1 from loteexternorequisicao ");
        sql.append(" where fil_codigo = ").append(req.getString("fil_codigo"));
        sql.append(" and lae_codigo = ").append(labSelecionado.codigoLab);
        sql.append(" and lex_codigo = ").append(req.getString("lex_codigo"));
        sql.append(" and req_codigo in (").append(req.getString("req_codigo")).append(")");
        sql.append(" and leq_dataestorno is not null ");
        ResultSet resultSetLote = st.executeQuery(sql.toString());
        return resultSetLote.next();
    }

    public static boolean verificaEstornoLote(Registro req, Statement st) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append("select 1 as retorno from loteexterno ");
        sql.append(" where fil_codigo = ").append(req.getString("fil_codigo"));
        sql.append("  and lex_codigo = ").append(req.getString("lex_codigo"));
        sql.append("  and lex_dataestorno is not null ");
        ResultSet resultSetLote = st.executeQuery(sql.toString());
        return resultSetLote.next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void gravarExamesExportados(Registro req, Registro exa, Statement st, boolean isColetaWeb) throws Exception {
        try {
            StringBuilder bui = new StringBuilder();
            bui.append("update examerequisicao \n");
            bui.append("set exr_dataloteexterno = current_timestamp, \n");
            bui.append("    usr_codloteexterno = '").append(Variaveis.login).append("' \n");
            bui.append("where \n");
            bui.append("  fil_codigo = ").append(req.getValor("fil_codigo")).append(" and \n");
            bui.append("  req_codigo = ").append(req.getValor("req_codigo")).append(" and \n");
            bui.append("  exa_codigo = '").append(exa.getString(EXA_CODIGO)).append("' and \n");
            bui.append("  mco_codigo = ").append(exa.getString(MCO_CODIGO));
            if (isColetaWeb) {
                st.executeUpdate(bui.toString());
            } else {
                Conexao.executeUpdate(req.getValor("fil_codigo").toString(), st, bui.toString());
            }
            if (isColetaWeb) return;
        }
        catch (Throwable throwable) {
            if (isColetaWeb) throw throwable;
            Conexao.fecharStatement(st);
            throw throwable;
        }
        Conexao.fecharStatement(st);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int descobriMetodoEnvioWebService(Registro registro, LaboratorioExterno labSelecionado, Statement st) throws Exception {
        StringBuilder sql = new StringBuilder();
        try (ResultSet resultSet = null;){
            sql.append("select (case when (count(1) > 0) then 'POST' else 'PUT' end) as metodoEnvio from loteexternorequisicao  ");
            sql.append("where fil_codigo = ").append(registro.getString("fil_codigo"));
            sql.append("  and req_codigo = ").append(registro.getString("req_codigo"));
            sql.append("  and lae_codigo = ").append(labSelecionado.codigoLab);
            sql.append("  and leq_dataestorno is null ");
            resultSet = st.executeQuery(sql.toString());
            if (resultSet.next()) {
                registro.setValor("metodoEnvio", resultSet.getString("metodoEnvio"));
            }
            sql = new StringBuilder();
            sql.append("select lex.lex_codigo from loteexternorequisicao lex ");
            sql.append(" left join requisicaorequisicao rr on rr.fil_codigo = lex.fil_codigo and (rr.req_codigo = lex.req_codigo or rr.req_kodigo = lex.req_codigo)");
            sql.append(" where lex.fil_codigo = ").append(registro.getString("fil_codigo"));
            sql.append(" and (rr.req_codigo = ").append(registro.getString("req_codigo")).append(" or rr.req_kodigo = ").append(registro.getString("req_codigo")).append(") ");
            sql.append(" and lex.lae_codigo = ").append(labSelecionado.codigoLab);
            sql.append(" and lex.leq_dataestorno is null ");
            ResultSet resultSetRequisicao = st.executeQuery(sql.toString());
            if (resultSetRequisicao.next()) {
                registro.setValor("lex_codigo", resultSetRequisicao.getInt("lex_codigo"));
            } else {
                sql = new StringBuilder();
                sql.append("select lex.lex_codigo from loteexternorequisicao lex ");
                sql.append(" where lex.fil_codigo = ").append(registro.getString("fil_codigo"));
                sql.append("   and lex.req_codigo = ").append(registro.getString("req_codigo"));
                sql.append("   and lex.lae_codigo = ").append(labSelecionado.codigoLab);
                sql.append("   and lex.leq_dataestorno is null");
                resultSetRequisicao = st.executeQuery(sql.toString());
                if (resultSetRequisicao.next()) {
                    registro.setValor("lex_codigo", resultSetRequisicao.getInt("lex_codigo"));
                }
            }
            ArrayList exames = (ArrayList)registro.getValor("listaexames");
            if (exames != null && !exames.isEmpty()) {
                for (Registro exame : exames) {
                    sql = new StringBuilder();
                    resultSet = null;
                    sql.append(" select (case when (count(1) > 0) then 'false' else 'true' end) as exameNovo ");
                    sql.append(" from loteexternoexamerequisicao  lex ");
                    sql.append(" join loteexternorequisicao lote ");
                    sql.append("   on lex.lae_codigo = lex.lae_codigo and lex.fil_codigo = lote.fil_codigo and lex.lex_codigo = lote.lex_codigo and lex.req_codigo = lote.req_codigo ");
                    sql.append(" where lex.fil_codigo = ").append(registro.getString("fil_codigo"));
                    sql.append("   and lex.req_codigo = ").append(registro.getString("req_codigo"));
                    sql.append("   and lex.exa_codigo = '").append(exame.getString(EXA_CODIGO)).append("'");
                    sql.append("   and lex.mco_codigo = ").append(exame.getString(MCO_CODIGO));
                    sql.append("   and lex.lae_codigo = ").append(labSelecionado.codigoLab).append(";");
                    resultSet = st.executeQuery(sql.toString());
                    if (!resultSet.next()) continue;
                    exame.setValor("exameNovo", resultSet.getBoolean("exameNovo"));
                }
            }
        }
        return registro.getInt("lex_codigo");
    }

    public static Registro addRequisicao(Registro reg, String codRecipiente, Map<String, Registro> requisicoes, LaboratorioExterno labexterno, Statement st, int digitosTuboFilial, int digitosTuboRequisicao, boolean agruparGuiasInterface) throws Exception {
        if (Variaveis.integrarDadosEntreFiliais) {
            HashMap<String, Object> chaves = new HashMap<String, Object>();
            try {
                chaves.put("req_codigo", reg.getString("req_codigo"));
                chaves.put("fil_codigo", reg.getString("fil_codigo"));
                RequisicaoBean requisicaoBean = (RequisicaoBean)new RequisicaoService().getBean(chaves);
                if (requisicaoBean != null && requisicaoBean.getFilial() != null) {
                    Integer filialLogada = Integer.parseInt(Variaveis.filialPadrao);
                    if (!requisicaoBean.getFilial().getCodigo().equals(filialLogada)) {
                        return null;
                    }
                }
            }
            catch (Exception e) {
                throw new ThreadDaoException("N\u00e3o foi poss\u00edvel consultar requisi\u00e7\u00e3o para exporta\u00e7\u00e3o Ws Alvaro.\nMensagem: " + e.getMessage());
            }
        }
        boolean existReq = requisicoes.containsKey(UtilExportadores.getChave(reg, digitosTuboFilial, digitosTuboRequisicao));
        if (labexterno.protocolo.getExigeDataNascimento() && Funcoes.textoVazio(reg.getString("pac_datanasc"))) {
            String msg = "O paciente da requisi\u00e7\u00e3o \"" + reg.getString("req_codigo") + "\" n\u00e3o tem data de nascimento.\nO laborat\u00f3rio externo selecionado exige esse item.";
            Funcoes.mensagem(null, msg, 1);
            return null;
        }
        if (st != null) {
            try {
                Registro requisicaoInserida;
                ResultSet res = UtilExportadores.selecionaExames(reg.getString("fil_codigo"), reg.getString("req_codigo"), codRecipiente, st, labexterno, true);
                ArrayList exames = new ArrayList();
                ArrayList<String> examesInserido = new ArrayList<String>();
                ArrayList examesNaoExp = new ArrayList();
                if (existReq && (requisicaoInserida = requisicoes.get(UtilExportadores.getChave(reg, digitosTuboFilial, digitosTuboRequisicao))) != null) {
                    exames = (ArrayList)requisicaoInserida.getValor("listaexames");
                    examesNaoExp = (ArrayList)requisicaoInserida.getValor(campos[6]);
                    for (Registro r : exames) {
                        examesInserido.add(r.getString(EXA_CODIGO).concat(r.getString(MCO_CODIGO)).concat(r.getString("rec_codigo")));
                    }
                    for (Registro r : examesNaoExp) {
                        examesInserido.add(r.getString(EXA_CODIGO).concat(r.getString(MCO_CODIGO)).concat(r.getString("rec_codigo")));
                    }
                }
                boolean contemExameExportado = false;
                while (res.next()) {
                    String[] valores;
                    Registro exa = new Registro(res);
                    if (exa.getValor("rec_kodigo") != null && exa.getValor("rec_kodigo") instanceof Array && (valores = (String[])((Array)exa.getValor("rec_kodigo")).getArray()).length > 0 && (valores.length != 1 || !Funcoes.textoVazio(valores[0]))) {
                        exa.setValor("recipapresentacao", exa.getString("rec_kodigo").replace("{", "").replace("}", ""));
                    }
                    int qtd = UtilExportadores.quantidadeTuboRecipiente(exa, st);
                    if (exa.getValor("exr_situacao") == null) {
                        exa.setValor("exr_situacao", "");
                    }
                    if (!Funcoes.textoVazio(codRecipiente)) {
                        exa.setValor("etiquetaDigitada", res.getBoolean("etiquetaDigitada"));
                    }
                    if (!examesInserido.contains(exa.getString(EXA_CODIGO).concat(exa.getString(MCO_CODIGO)).concat(exa.getString("rec_codigo")))) {
                        if (!exa.getBoolean("exa_exportado") && exa.getBoolean("exa_externo") && !Funcoes.textoVazio(exa.getString("ele_xmllabexterno")) && (Funcoes.textoVazio(res.getString("exr_situacao")) || res.getString("exr_situacao").equals("O")) && (Funcoes.textoVazio(codRecipiente) || !Funcoes.textoVazio(codRecipiente) && res.getBoolean("etiquetaDigitada")) || res.getBoolean("etiquetaDigitada") && qtd >= 1) {
                            exames.add(exa);
                        } else {
                            examesNaoExp.add(exa);
                        }
                        examesInserido.add(exa.getString(EXA_CODIGO).concat(exa.getString(MCO_CODIGO)).concat(exa.getString("rec_codigo")));
                        continue;
                    }
                    if (Funcoes.textoVazio(codRecipiente) || !Funcoes.isNumeric(codRecipiente)) continue;
                    String exm = exa.getString(EXA_CODIGO);
                    String mco = exa.getString(MCO_CODIGO);
                    if (!exa.getBoolean("exa_externo")) continue;
                    ArrayList<Integer> remover = new ArrayList<Integer>();
                    for (int i = 0; i < examesNaoExp.size(); ++i) {
                        Registro r = (Registro)examesNaoExp.get(i);
                        Array aux = (Array)r.getValor("rec_kodigo");
                        Object[] auxInt = (Object[])aux.getArray();
                        if (auxInt.length <= 0 || auxInt.length == 1 && (auxInt[0] == null || Funcoes.textoVazio(auxInt[0].toString()))) continue;
                        ArrayList<Integer> lista = new ArrayList<Integer>();
                        for (int j = 0; j < auxInt.length; ++j) {
                            if (!Funcoes.isNumeric(auxInt[j].toString())) continue;
                            lista.add(new Integer(auxInt[j].toString()));
                        }
                        if (!r.getString(EXA_CODIGO).equals(exm) || r.getInt(MCO_CODIGO) != Integer.parseInt(mco) || !lista.contains(Integer.parseInt(codRecipiente))) continue;
                        Registro rr = r.clone();
                        exames.add(rr);
                        remover.add(i);
                    }
                    if (remover.size() <= 0) continue;
                    for (Integer linha : remover) {
                        examesNaoExp.remove(linha);
                    }
                }
                UtilExportadores.processaDesm(reg, exames, labexterno, st);
                reg.setValor("listaexames", exames);
                reg.setValor(campos[6], examesNaoExp);
                reg.setValor("chave", UtilExportadores.getChave(reg, digitosTuboFilial, digitosTuboRequisicao));
                UtilExportadores.trataExamesMultiGuia(reg, requisicoes, agruparGuiasInterface, st);
                DadosAdicionais dadosAdicionais = FabricaExportador.novoDadosAdicionais(labexterno.protocolo);
                if (dadosAdicionais != null && !dadosAdicionais.carregaAdicionais(labexterno.codigoLab, reg)) {
                    return null;
                }
                if (exames.size() > 0 && !existReq) {
                    return reg;
                }
            }
            catch (Exception e) {
                throw new ThreadDaoException(e.getMessage());
            }
        }
        return null;
    }

    public static List<Registro> processaMultiguia(List<Registro> listaRequisicoes, int agruparInterface) {
        if (agruparInterface != 0 && agruparInterface != 1) {
            return listaRequisicoes;
        }
        ArrayList<Registro> requisicoesPais = new ArrayList<Registro>();
        if (listaRequisicoes != null) {
            HashMap listaRequisicoesPais = new HashMap();
            for (Registro req : listaRequisicoes) {
                if (listaRequisicoesPais.containsKey(req.getString("req_codigomae"))) {
                    ((ArrayList)listaRequisicoesPais.get(req.getString("req_codigomae"))).add(req);
                    continue;
                }
                ArrayList<Registro> nova = new ArrayList<Registro>();
                nova.add(req);
                listaRequisicoesPais.put(req.getString("req_codigomae"), nova);
            }
            for (String key : listaRequisicoesPais.keySet()) {
                ArrayList examesPai = new ArrayList();
                ArrayList reqFilhas = (ArrayList)listaRequisicoesPais.get(key);
                Registro pai = null;
                for (Registro filha : reqFilhas) {
                    if (!filha.contemValor("req_codigo", key) || !filha.contemValor("req_codigomae", key)) continue;
                    pai = filha;
                }
                ArrayList<Registro> novaLista = new ArrayList<Registro>();
                ArrayList<String> chaves = new ArrayList<String>();
                for (Registro filha : reqFilhas) {
                    if (pai == null) {
                        pai = filha;
                    }
                    List exames = (List)filha.getValor("listaexames");
                    for (Registro exaFilha : exames) {
                        String chave = exaFilha.getString(EXA_CODIGO) + exaFilha.getString(MCO_CODIGO);
                        if (chaves.contains(chave)) continue;
                        novaLista.add(exaFilha.clone());
                        chaves.add(chave);
                    }
                }
                pai.substituirValor("listaexames", novaLista);
                requisicoesPais.add(pai);
            }
        }
        return requisicoesPais;
    }

    public static void trataExamesMultiGuia(Registro reg, Map<String, Registro> requisicoes, boolean agruparGuiasInterface, Statement st) throws SQLException {
        boolean agruparMultiguias;
        boolean bl = agruparMultiguias = agruparGuiasInterface || DBUtil.requisicaoAgrupaMultiguiasLabExterno(st, reg.getString("fil_codigo"), reg.getString("req_codigo"));
        if (agruparMultiguias) {
            ArrayList<Registro> examesDiferentes = new ArrayList<Registro>();
            HashSet exameMultiguias = new HashSet();
            HashSet requisicaoAdicionada = new HashSet();
            Integer[] multiguias = RecepcaoUtil.verificaMultiGuias(st, reg.getString("fil_codigo"), reg.getString("req_codigo"), false, false);
            if (multiguias != null && multiguias.length > 0) {
                for (Integer guia : multiguias) {
                    for (String key : requisicoes.keySet()) {
                        Registro req = requisicoes.get(key);
                        if (!req.getString("req_codigo").equals(guia.toString()) || ((Collection)req.getValor("listaexames")).isEmpty()) continue;
                        exameMultiguias.addAll((Collection)req.getValor("listaexames"));
                    }
                }
                if (!((Collection)reg.getValor("listaexames")).isEmpty()) {
                    requisicaoAdicionada.addAll((Collection)reg.getValor("listaexames"));
                }
                if (!exameMultiguias.isEmpty()) {
                    HashSet<String> chaves = new HashSet<String>();
                    int examesIguais = 0;
                    for (Registro exameRequisicao : requisicaoAdicionada) {
                        String chaveAdd = exameRequisicao.getString(EXA_CODIGO) + exameRequisicao.getString(MCO_CODIGO);
                        examesIguais = 0;
                        for (Registro exameMultiguas : exameMultiguias) {
                            String chaveMult = exameMultiguas.getString(EXA_CODIGO) + exameMultiguas.getString(MCO_CODIGO);
                            if (!chaveMult.equals(chaveAdd)) continue;
                            if (!chaves.contains(chaveMult)) {
                                ++examesIguais;
                            }
                            chaves.add(chaveAdd);
                        }
                        if (examesIguais != 0) continue;
                        examesDiferentes.add(exameRequisicao);
                    }
                    if (examesDiferentes.isEmpty()) {
                        reg.setValor("listaexames", examesDiferentes);
                    }
                }
            }
            if (!examesDiferentes.isEmpty()) {
                reg.setValor("listaexames", examesDiferentes);
            }
        }
    }

    public static void removerLoteForcarExcluir(String codLabExterno, List<Registro> requisicoes, String numeroLote, boolean isForcarExcluir, Statement st, boolean isColetaWeb, Callable<Boolean> arquivar, Callable<Boolean> anular) throws NumberFormatException, Exception {
        for (Registro registro : requisicoes) {
            UtilExportadores.excluirRequisicao(codLabExterno, st, numeroLote, registro, isForcarExcluir, isColetaWeb, arquivar, anular);
        }
        arquivar.call();
    }

    public static void removerLote(String codLabExterno, List<Registro> requisicoes, String numeroLote, Statement st, boolean isColetaWeb, Callable<Boolean> arquivar, Callable<Boolean> anular) throws NumberFormatException, Exception {
        for (Registro registro : requisicoes) {
            UtilExportadores.excluirRequisicao(codLabExterno, st, numeroLote, registro, isColetaWeb, arquivar, anular);
        }
        arquivar.call();
    }

    private static void excluirRequisicao(String codLabExterno, Statement st, String numeroLote, Registro requisicao, boolean isColetaWeb, Callable<Boolean> arquivar, Callable<Boolean> anular) throws NumberFormatException, Exception {
        UtilExportadores.excluirRequisicao(codLabExterno, st, numeroLote, requisicao, false, isColetaWeb, arquivar, anular);
    }

    private static void excluirRequisicao(String codLabExterno, Statement st, String numeroLote, Registro requisicao, boolean isForcarExcluir, boolean isColetaWeb, Callable<Boolean> arquivar, Callable<Boolean> anular) throws NumberFormatException, Exception {
        List exames = (List)requisicao.getValor("listaexames");
        String filial = requisicao.getString("fil_codigo");
        Integer[] multiguias = RecepcaoUtil.verificaMultiGuias(filial, requisicao.getString("req_codigo"), true);
        String req = StringUtil.implode(Arrays.asList(multiguias), ",");
        StringBuilder buf = new StringBuilder();
        buf.append("select * from loteexternorequisicao ");
        buf.append(" where fil_codigo = ").append(filial);
        buf.append(" and lae_codigo = ").append(codLabExterno);
        buf.append(" and lex_codigo = ").append(numeroLote);
        buf.append(" and req_codigo in (").append(req).append(") ");
        buf.append(" and leq_dataestorno is null ");
        ResultSet resultSetExisteLote = st.executeQuery(buf.toString());
        boolean temLoteRequisicao = resultSetExisteLote.next();
        for (Registro exame : exames) {
            String[] valores;
            List desmembrados;
            buf.setLength(0);
            buf.append("update examerequisicao set exr_dataloteexterno = null, usr_codloteexterno = null ");
            buf.append("where fil_codigo = ").append(filial);
            buf.append(" and req_codigo in( ").append(StringUtil.implode(Arrays.asList(multiguias), ",")).append(") ");
            buf.append(" and exa_codigo = '").append(exame.getString(EXA_CODIGO)).append("' ");
            if (isColetaWeb) {
                st.executeUpdate(buf.toString());
            } else {
                Conexao.execute(filial, st, buf);
            }
            if (temLoteRequisicao) {
                buf.setLength(0);
                buf.append("delete from loteexternoexamerequisicao where ");
                buf.append("     fil_codigo = ").append(filial);
                buf.append(" and lae_codigo = ").append(codLabExterno);
                buf.append(" and lex_codigo = ").append(numeroLote);
                buf.append(" and req_codigo in( ").append(req).append(") ");
                buf.append(" and exa_codigo = '").append(exame.getString(EXA_CODIGO)).append("' ");
                if (isColetaWeb) {
                    st.executeUpdate(buf.toString());
                } else {
                    Conexao.execute(filial, st, buf);
                }
                arquivar.call();
                buf.setLength(0);
                buf.append("select 1 from loteexternoexamerequisicao where ");
                buf.append("     fil_codigo = ").append(filial);
                buf.append(" and lae_codigo = ").append(codLabExterno);
                buf.append(" and lex_codigo = ").append(numeroLote);
                buf.append(" and req_codigo in( ").append(req).append(") ");
                ResultSet resultSetExisteExameLote = st.executeQuery(buf.toString());
                if (!resultSetExisteExameLote.next()) {
                    buf.setLength(0);
                    buf.append("delete from requisicaolabexterno");
                    buf.append(" where fil_codigo = ").append(filial);
                    buf.append(" and req_codigo in( ").append(req).append(") ");
                    buf.append(" and lae_codigo = ").append(codLabExterno);
                    if (isColetaWeb) {
                        st.executeUpdate(buf.toString());
                    } else {
                        Conexao.execute(filial, st, buf);
                    }
                    buf.setLength(0);
                    buf.append("delete from loteexternorequisicao ");
                    buf.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
                    buf.append("   and lex_codigo = ").append(numeroLote);
                    buf.append("   and lae_codigo = ").append(codLabExterno);
                    buf.append("   and req_codigo in( ").append(req).append(") ");
                    if (isColetaWeb) {
                        st.executeUpdate(buf.toString());
                    } else {
                        Conexao.executeUpdate(Variaveis.filialPadrao, st, buf);
                    }
                    if (isForcarExcluir) {
                        buf.setLength(0);
                        buf.append("delete from loteexterno where ");
                        buf.append("     fil_codigo = ").append(filial);
                        buf.append(" and lae_codigo = ").append(codLabExterno);
                        buf.append(" and lex_codigo = ").append(numeroLote);
                        if (isColetaWeb) {
                            st.executeUpdate(buf.toString());
                        } else {
                            Conexao.execute(filial, st, buf);
                        }
                    } else {
                        buf.setLength(0);
                        buf.append("update loteexterno set lex_dataestorno = current_timestamp, usr_codestorno = '").append(Variaveis.login).append("'");
                        buf.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
                        buf.append("   and lex_codigo = ").append(numeroLote);
                        buf.append("   and lae_codigo = ").append(codLabExterno);
                        if (isColetaWeb) {
                            st.executeUpdate(buf.toString());
                        } else {
                            Conexao.executeUpdate(Variaveis.filialPadrao, st, buf);
                        }
                    }
                }
            }
            if (exame.getValor("listaexames") != null && (desmembrados = (List)exame.getValor("listaexames")).size() > 0) {
                for (int k = 0; k < desmembrados.size(); ++k) {
                    Registro desm = (Registro)desmembrados.get(k);
                    buf.setLength(0);
                    buf.append("select * from loteexternoexamerequisicaodesm ");
                    buf.append(" where fil_codigo = ").append(requisicao.getString("fil_codigo"));
                    buf.append("   and req_codigo = ").append(requisicao.getString("req_codigo"));
                    buf.append("   and lae_codigo = ").append(codLabExterno);
                    buf.append("   and lex_codigo = ").append(numeroLote);
                    buf.append("   and mco_kodigo = ").append(desm.getString(MCO_CODIGO));
                    buf.append("   and exa_kodigo = '").append(desm.getString(EXA_CODIGO)).append("' ");
                    ResultSet existe = st.executeQuery(buf.toString());
                    if (!existe.next()) continue;
                    buf.setLength(0);
                    buf.append("delete from loteexternoexamerequisicaodesm ");
                    buf.append(" where fil_codigo = ").append(requisicao.getString("fil_codigo"));
                    buf.append("   and req_codigo = ").append(requisicao.getString("req_codigo"));
                    buf.append("   and lae_codigo = ").append(codLabExterno);
                    buf.append("   and lex_codigo = ").append(numeroLote);
                    buf.append("   and mco_kodigo = ").append(desm.getString(MCO_CODIGO));
                    buf.append("   and exa_kodigo = '").append(desm.getString(EXA_CODIGO)).append("' ");
                    if (isColetaWeb) {
                        st.executeUpdate(buf.toString());
                        continue;
                    }
                    Conexao.execute(filial, st, buf);
                }
            }
            if (exame.getValor("rec_kodigo") == null || !(exame.getValor("rec_kodigo") instanceof Array) || (valores = (String[])((Array)exame.getValor("rec_kodigo")).getArray()).length <= 0 || valores.length == 1 && Funcoes.textoVazio(valores[0])) continue;
            boolean existe = false;
            buf.setLength(0);
            buf.append("select * from loteexternoexamerequisicaorecip lexr ");
            buf.append(" where lexr.fil_codigo = ").append(requisicao.getString("fil_codigo"));
            buf.append(" \t and lexr.lex_codigo = ").append(requisicao.getString("lex_codigo"));
            buf.append("   and lexr.lae_codigo = ").append(codLabExterno);
            buf.append("   and lexr.req_codigo = ").append(requisicao.getString("req_codigo"));
            buf.append("   and lexr.mco_codigo = ").append(exame.getString(MCO_CODIGO));
            buf.append("   and lexr.exa_codigo = '").append(exame.getString(EXA_CODIGO)).append("' ");
            ResultSet rsExiste = st.executeQuery(buf.toString());
            existe = rsExiste.next();
            if (!existe || !Funcoes.textoVazioNotNullIsNumberTubo(StringUtil.limpaString(exame.getString("rec_kodigo"), new String[]{"{", "}"}))) continue;
            buf.setLength(0);
            buf.append("delete from loteexternoexamerequisicaorecip ");
            buf.append(" where fil_codigo = ").append(filial);
            buf.append("   and lae_codigo = ").append(codLabExterno);
            buf.append("   and lex_codigo = ").append(numeroLote);
            buf.append("   and req_codigo in( ").append(StringUtil.implode(Arrays.asList(multiguias), ",")).append(") ");
            buf.append("   and exa_codigo = '").append(exame.getString(EXA_CODIGO)).append("' ");
            if (!Funcoes.textoVazio(exame.getString("rec_kodigo"))) {
                buf.append(" and rec_codigo = ").append(exame.getString("rec_kodigo"));
            }
            if (isColetaWeb) {
                st.executeUpdate(buf.toString());
                continue;
            }
            Conexao.execute(filial, st, buf);
        }
        arquivar.call();
    }

    public static ResultSet selecionaExames(String filial, String requisicao, String codRecipiente, Statement st, LaboratorioExterno labExterno, boolean somenteConfigurados) throws SQLException {
        StringBuilder bui = new StringBuilder("select a.fil_codigo, a.req_codigo, \n");
        bui.append("  (CASE WHEN (trim(f.ere_codigoapoiado) != '') THEN cast(trim(f.ere_codigoapoiado) AS varchar) ELSE cast(trim(a.exr_codigoapoiado) AS varchar) END) AS exr_codigoapoiado, ");
        bui.append("  a.exr_descricaomaterial, a.exr_datamaterial, a.exr_volumediurese, cast(a.exr_tempodiurese as varchar) as ext_tempodiurese, ");
        bui.append("  a.exr_situacao, (a.exr_dataloteexterno is not null) as ").append("exa_exportado").append(", ");
        bui.append("  b.exa_codigo, b.exa_descricao, a.exr_urgente, a.exr_situacao,");
        bui.append("  c.mco_codigo, c.mco_abreviatura, c.mco_solicitarmat, c.mco_descricao, ");
        bui.append("  g.ele_xmllabexterno, a.exr_datamaterial, ");
        bui.append("  g.ele_diasprazo, g.ele_valorexame, h.req_codigo as req_codigomae, ");
        bui.append("  coalesce(g.lae_codigo = ").append(labExterno.codigoLab).append(", false) as ").append("exa_externo");
        bui.append(" ,'' as recipapresentacao ");
        bui.append(" ,(CASE WHEN (f.rec_kodigo is not null) then array_agg(distinct cast(f.rec_kodigo AS varchar))::varchar[] else null END) as rec_kodigo  ");
        if (!Funcoes.textoVazio(codRecipiente)) {
            bui.append(" ,array_agg(distinct f.rec_kodigo) @> ARRAY[").append(Integer.parseInt(codRecipiente)).append("] as etiquetaDigitada ");
        } else {
            bui.append(" , '' as etiquetaDigitada ");
        }
        bui.append(" , case  when CHAR_LENGTH(rec.rec_descricao) >= 20 then SUBSTR(rec.rec_descricao, 0,20) else rec.rec_descricao end ");
        bui.append(" from examerequisicao a ");
        bui.append(" left join exames b on a.fil_codigo = b.fil_codigo and a.exa_codigo = b.exa_codigo ");
        bui.append(" left join materialcoleta c   on a.fil_codigo = c.fil_codigo and a.mco_codigo = c.mco_codigo ");
        bui.append(" left join examematcoleta d on a.fil_codigo = d.fil_codigo and a.exa_codigo = d.exa_codigo and a.mco_codigo = d.mco_codigo ");
        bui.append(" left join requisicao e on a.fil_codigo = e.fil_codigo and a.req_codigo = e.req_codigo ");
        bui.append(" left join examerequisicaorecipiente f on a.fil_codigo = f.fil_codigo and a.exa_codigo = f.exa_codigo and a.req_codigo = f.req_codigo and a.mco_codigo = f.mco_codigo and f.ere_tipo = '").append("C").append("' ");
        bui.append(" left join examematcoletalabexterno g on a.fil_codigo = g.fil_codigo and a.exa_codigo = g.exa_codigo and a.mco_codigo = g.mco_codigo  and g.lae_codigo = ").append(labExterno.codigoLab);
        bui.append(" left join requisicaorequisicao h on a.fil_codigo = h.fil_codigo and a.req_codigo = h.req_kodigo ");
        bui.append(" left join recipientes rec on rec.fil_codigo = a.fil_codigo and rec.rec_codigo = f.rec_kodigo  ");
        bui.append(" left join loteexternorequisicao lotereq on a.fil_codigo = lotereq.fil_codigo   and a.req_codigo = lotereq.req_codigo ");
        bui.append(" left join loteexternoexamerequisicao lote on a.fil_codigo = lote.fil_codigo and a.exa_codigo = lote.exa_codigo and a.mco_codigo = lote.mco_codigo and a.req_codigo = lote.req_codigo and a.fil_Codigo = lote.fil_codigo ");
        bui.append(" where ");
        bui.append(" a.fil_codigo = ").append(filial).append(" and ");
        bui.append(" a.req_codigo = ").append(requisicao);
        bui.append(" and a.exr_excluido = false ");
        bui.append(" and g.ele_padrao ");
        bui.append(" and lotereq.leq_dataestorno is null ");
        bui.append(" and (lote.lex_codigo is null or lotereq.leq_retornows is null) ");
        if (somenteConfigurados) {
            bui.append(" and length(coalesce(g.ele_xmllabexterno, '')) > 0");
        }
        bui.append(" and coalesce(g.ele_bloqueado, false) = false ");
        bui.append("  group by (CASE WHEN (trim(f.ere_codigoapoiado) != '') THEN cast(trim(f.ere_codigoapoiado) AS varchar) ELSE cast(trim(a.exr_codigoapoiado) AS varchar) END) ");
        bui.append(" ,a.exr_descricaomaterial ");
        bui.append(" ,a.exr_datamaterial ");
        bui.append(" ,a.exr_volumediurese ");
        bui.append(" ,a.exr_situacao ");
        bui.append(" ,b.exa_codigo ");
        bui.append(" ,b.exa_descricao ");
        bui.append(" ,a.exr_urgente ");
        bui.append(" ,a.exr_situacao ");
        bui.append(" ,c.mco_codigo ");
        bui.append(" ,c.mco_abreviatura ");
        bui.append(" ,c.mco_solicitarmat ");
        bui.append(" ,c.mco_descricao ");
        bui.append(" ,g.ele_xmllabexterno ");
        bui.append(" ,a.exr_datamaterial ");
        bui.append(" ,g.ele_diasprazo ");
        bui.append(" ,g.ele_valorexame ");
        bui.append("  ,h.req_codigo ");
        bui.append(" ,a.exr_tempodiurese ");
        bui.append(" ,a.exr_dataloteexterno ");
        bui.append(" ,g.lae_codigo ");
        bui.append(" ,rec.rec_descricao ");
        bui.append(" ,a.fil_codigo ");
        bui.append(" ,a.req_codigo ");
        bui.append(" ,lote.lex_codigo ");
        bui.append(" ,f.rec_kodigo ");
        return st.executeQuery(bui.toString());
    }

    public static List<Registro> localizaRequisicao(String filial, String codigoReq, Statement st) throws SQLException {
        ArrayList<Registro> requisicao = new ArrayList<Registro>();
        String multiguiaPrincipal = codigoReq;
        Object[] multiguia = null;
        try {
            multiguia = RecepcaoUtil.verificaMultiGuias(st, filial, codigoReq, true, false);
        }
        catch (SQLException e1) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e2o foi poss\u00edvel verificiar multiguia no carregamento de lote.\n" + e1.getMessage(), e1.getStackTrace());
        }
        Arrays.sort(multiguia);
        String guias = StringUtil.implode(Arrays.asList(multiguia), ",");
        StringBuilder bui = new StringBuilder("select \n");
        bui.append("  a.fil_codigo, a.req_codigo, a.req_data, a.req_hora, a.req_dum, a.req_obs, a.con_codigo, \n");
        bui.append("  a.req_peso, a.req_altura, a.req_anomes, a.req_idade, \n");
        bui.append("  b.pac_codigo, b.pac_nome, b.pac_sexo, b.pac_datanasc, a.req_totpago, a.req_total, a.req_deveguia, \n");
        bui.append("  a.med_conselho, a.med_crm, a.med_uf, c.med_nome, a.req_dclinicos \n");
        bui.append("from requisicao a \n");
        bui.append("left join paciente b  on a.fil_codigo = b.fil_codigo and a.pac_codigo = b.pac_codigo \n");
        bui.append("left join medico c on a.fil_codigo = c.fil_codigo and a.med_conselho = c.med_conselho and a.med_crm = c.med_crm and a.med_uf = c.med_uf \n");
        bui.append("where a.fil_codigo = ").append(filial);
        bui.append("  and a.req_codigo in (").append(guias).append(") ");
        bui.append("  and a.req_excluida = false ");
        ResultSet res = st.executeQuery(bui.toString());
        while (res.next()) {
            Registro reg = new Registro(res);
            reg.setValor("req_data", Funcoes.formataData("dd/MM/yyyy", res.getDate("req_data")));
            reg.setValor("req_codigomae", multiguia[0]);
            requisicao.add(reg);
        }
        return requisicao;
    }

    public static LaboratorioExterno localizaLabExternoDB(String filialPadrao, Statement st) throws SQLException, ThreadDaoException {
        LaboratorioExterno labExterno = null;
        StringBuilder buf = new StringBuilder();
        buf.append("select lae_codigo, lae_configuracao from labexterno where fil_codigo = ");
        buf.append(filialPadrao);
        buf.append(" and lae_protocolo = '").append((Object)Protocolo.DBV2).append("' ").append(" and (lae_inativo is null or not lae_inativo) ");
        LaboratorioExterno[] listas = LaboratorioExterno.getDescricoes(st, false);
        st.setPoolable(true);
        ResultSet rs = st.executeQuery(buf.toString());
        while (rs.next()) {
            Boolean enviarPorWebService = false;
            if (!Funcoes.textoVazio(rs.getString("lae_configuracao")) && !Funcoes.textoVazio(StringUtil.getValor(rs.getString("lae_configuracao"), "enviarLoteWebservice"))) {
                enviarPorWebService = StringUtil.getBoolean(rs.getString("lae_configuracao"), "enviarLoteWebservice");
            }
            if (!enviarPorWebService.booleanValue()) continue;
            for (LaboratorioExterno laboratorioExterno : listas) {
                if (!laboratorioExterno.codigoLab.equals(rs.getString("lae_codigo"))) continue;
                labExterno = laboratorioExterno;
            }
        }
        if (labExterno != null) {
            return labExterno;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LaboratorioExterno localizaLabExterno(String filialPadrao, Statement st) throws SQLException {
        LaboratorioExterno labExterno = null;
        StringBuilder buf = new StringBuilder();
        LaboratorioExterno[] listas = LaboratorioExterno.getDescricoes(st, false);
        try (ResultSet rs = null;){
            buf.append("select lae_codigo, lae_configuracao from labexterno where fil_codigo = ");
            buf.append(filialPadrao);
            buf.append(" and lae_protocolo = '").append((Object)Protocolo.Alvaro).append("' ");
            st.setPoolable(true);
            rs = st.executeQuery(buf.toString());
            while (rs.next()) {
                boolean enviarPorWebService = !Funcoes.textoVazio(rs.getString("lae_configuracao")) && !Funcoes.textoVazio(StringUtil.getValor(rs.getString("lae_configuracao"), "enviarLoteWebService")) ? Boolean.valueOf(StringUtil.getValor(rs.getString("lae_configuracao"), "enviarLoteWebService")) : Boolean.FALSE;
                if (!enviarPorWebService) continue;
                for (LaboratorioExterno laboratorioExterno : listas) {
                    if (!laboratorioExterno.codigoLab.equals(rs.getString("lae_codigo"))) continue;
                    labExterno = laboratorioExterno;
                }
            }
        }
        if (labExterno != null) {
            return labExterno;
        }
        return null;
    }

    public static LaboratorioExterno localizaLabExternoJalisWS(String filialPadrao, Statement st) throws SQLException {
        LaboratorioExterno labExterno = null;
        StringBuilder buf = new StringBuilder();
        buf.append("select lae_codigo, lae_configuracao from labexterno where fil_codigo = ");
        buf.append(filialPadrao);
        buf.append(" and lae_protocolo = '").append((Object)Protocolo.JalisWS).append("' ");
        LaboratorioExterno[] listas = LaboratorioExterno.getDescricoes(st, false);
        st.setPoolable(true);
        ResultSet rs = st.executeQuery(buf.toString());
        while (rs.next()) {
            Boolean enviarPorWebService = !Funcoes.textoVazio(rs.getString("lae_configuracao")) && !Funcoes.textoVazio(StringUtil.getValor(rs.getString("lae_configuracao"), "enviarLoteWebService")) ? Boolean.valueOf(StringUtil.getValor(rs.getString("lae_configuracao"), "enviarLoteWebService")) : Boolean.FALSE;
            if (!enviarPorWebService.booleanValue()) continue;
            for (LaboratorioExterno laboratorioExterno : listas) {
                if (!laboratorioExterno.codigoLab.equals(rs.getString("lae_codigo"))) continue;
                labExterno = laboratorioExterno;
            }
        }
        if (labExterno != null) {
            return labExterno;
        }
        return null;
    }

    public static LaboratorioExterno localizaLabExternoPardini(String filialPadrao, Statement st) throws SQLException {
        LaboratorioExterno labExterno = null;
        StringBuilder buf = new StringBuilder();
        buf.append("select lae_codigo, lae_configuracao from labexterno where fil_codigo = ");
        buf.append(filialPadrao);
        buf.append(" and lae_protocolo = '").append((Object)Protocolo.HPardini).append("' ");
        LaboratorioExterno[] listas = LaboratorioExterno.getDescricoes(st, false);
        ResultSet rs = st.executeQuery(buf.toString());
        while (rs.next()) {
            Boolean enviarHpDirect = !Funcoes.textoVazio(rs.getString("lae_configuracao")) && !Funcoes.textoVazio(StringUtil.getValor(rs.getString("lae_configuracao"), "enviarEtiquetaHpDirect")) ? Boolean.valueOf(StringUtil.getValor(rs.getString("lae_configuracao"), "enviarEtiquetaHpDirect")) : Boolean.FALSE;
            if (!enviarHpDirect.booleanValue()) continue;
            for (LaboratorioExterno laboratorioExterno : listas) {
                if (!laboratorioExterno.codigoLab.equals(rs.getString("lae_codigo"))) continue;
                labExterno = laboratorioExterno;
            }
        }
        if (labExterno != null) {
            return labExterno;
        }
        return null;
    }

    public static LaboratorioExterno localizaLabExternoPardiniEnvioRequisicao(String filialPadrao, Statement st) throws SQLException, ThreadDaoException {
        LaboratorioExterno labExterno = null;
        StringBuilder buf = new StringBuilder();
        buf.append("select lae_codigo, lae_configuracao from labexterno where fil_codigo = ");
        buf.append(filialPadrao);
        buf.append(" and lae_protocolo = '").append((Object)Protocolo.HPardini).append("' ");
        LaboratorioExterno[] listas = LaboratorioExterno.getDescricoes(st, false);
        st.setPoolable(true);
        ResultSet rs = st.executeQuery(buf.toString());
        while (rs.next()) {
            Boolean enviarRequisicao = !Funcoes.textoVazio(rs.getString("lae_configuracao")) && !Funcoes.textoVazio(StringUtil.getValor(rs.getString("lae_configuracao"), "envioAutomatico")) ? Boolean.valueOf(StringUtil.getValor(rs.getString("lae_configuracao"), "envioAutomatico")) : Boolean.FALSE;
            if (!enviarRequisicao.booleanValue()) continue;
            for (LaboratorioExterno laboratorioExterno : listas) {
                if (!laboratorioExterno.codigoLab.equals(rs.getString("lae_codigo"))) continue;
                labExterno = laboratorioExterno;
            }
        }
        if (labExterno != null) {
            return labExterno;
        }
        return null;
    }

    public static LaboratorioExterno localizaLabExternoMercolabEnvioRequisicao(String filialPadrao, Statement st) throws SQLException, ThreadDaoException {
        LaboratorioExterno labExterno = null;
        StringBuilder buf = new StringBuilder();
        buf.append("select lae_codigo, lae_configuracao from labexterno where fil_codigo = ");
        buf.append(filialPadrao);
        buf.append(" and lae_protocolo = '").append((Object)Protocolo.MercolabWS).append("' ");
        LaboratorioExterno[] listas = LaboratorioExterno.getDescricoes(st, false);
        st.setPoolable(true);
        ResultSet rs = st.executeQuery(buf.toString());
        while (rs.next()) {
            Boolean enviarRequisicao = !Funcoes.textoVazio(rs.getString("lae_configuracao")) && !Funcoes.textoVazio(StringUtil.getValor(rs.getString("lae_configuracao"), "envioAutomatico")) ? Boolean.valueOf(StringUtil.getValor(rs.getString("lae_configuracao"), "envioAutomatico")) : Boolean.FALSE;
            if (!enviarRequisicao.booleanValue()) continue;
            for (LaboratorioExterno laboratorioExterno : listas) {
                if (!laboratorioExterno.codigoLab.equals(rs.getString("lae_codigo"))) continue;
                labExterno = laboratorioExterno;
            }
        }
        if (labExterno != null) {
            return labExterno;
        }
        return null;
    }

    @Deprecated
    public static void removerRequisicaoAlvaroWs(String codigo, Statement statement, Statement st2, String filial, boolean executarWebService, boolean agruparGuiasInterface, boolean isColetaWeb) throws ThreadDaoException, Exception {
        LaboratorioExterno labExterno = UtilExportadores.localizaLabExterno(Variaveis.filialPadrao, st2);
        if (labExterno != null && labExterno.protocolo != null && labExterno.protocolo == Protocolo.Alvaro) {
            StringBuilder buf = new StringBuilder();
            buf.append("select a.fil_codigo, a.req_codigo, a.fil_kodigo, a.exa_codigo, a.mco_codigo ");
            buf.append("  from loteexternoexamerequisicao a ");
            buf.append(" inner join loteexternorequisicao lex on lex.fil_codigo = a.fil_codigo and lex.req_codigo = a.req_codigo and lex.lae_codigo = a.lae_codigo and lex.lex_codigo = a.lex_codigo ");
            buf.append(" where a.fil_codigo = ").append(Variaveis.filialPadrao);
            buf.append("   and a.fil_kodigo = ").append(filial);
            buf.append("   and a.req_codigo in( ").append(StringUtil.implode(Arrays.asList(codigo), ",")).append(") ");
            buf.append("   and a.lae_codigo = ").append(labExterno.codigoLab);
            buf.append("   and lex.leq_dataestorno is null and lex.usr_codestorno  is null ");
            ResultSet rs = statement.executeQuery(buf.toString());
            if (rs.next()) {
                HashSet<ExameExcluido> examesExcluido = new HashSet<ExameExcluido>();
                do {
                    ExameExcluido ex = new ExameExcluido(rs.getString(EXA_CODIGO), rs.getString(MCO_CODIGO), rs.getString("req_codigo"));
                    examesExcluido.add(ex);
                } while (rs.next());
                UtilExportadores.removerExameAlvaroWs(codigo, statement, st2, examesExcluido, filial, executarWebService, agruparGuiasInterface, isColetaWeb);
            }
        }
    }

    @Deprecated
    public static void removerExameAlvaroWs(String codigo, Statement statement, Statement st2, Set<ExameExcluido> examesExcluido, String filial, boolean executarWebService, boolean agruparGuiasInterface, boolean isColetaWeb) throws SQLException, ThreadDaoException, Exception {
        LaboratorioExterno labExterno = UtilExportadores.localizaLabExterno(Variaveis.filialPadrao, st2);
        if (labExterno != null && labExterno.protocolo != null && labExterno.protocolo == Protocolo.Alvaro) {
            AbstractConfiguradorProtocolo conf = FabricaConfigurador.novoConfiguradorProtocolo(Laboratorio.getInstancia(), Protocolo.Alvaro, labExterno.codigoLab);
            ArrayList<Registro> exameRequisicoes = new ArrayList<Registro>();
            ArrayList<ArrayList<Registro>> exameRequisicoesTmp = new ArrayList<ArrayList<Registro>>();
            List<Registro> listaRegistro = new LoteExternoExameRequisicaoService().requisicaoEnviadaParaAlvaro(codigo, filial, false, statement, st2, agruparGuiasInterface);
            for (Registro registroRequisicao : listaRegistro) {
                Registro registro = new Registro();
                conf.setXML(labExterno.configuracao, false);
                if (registroRequisicao == null) continue;
                ConcurrentLinkedQueue<ExameExcluido> examesExcluidos = new ConcurrentLinkedQueue<ExameExcluido>(examesExcluido);
                Iterator<ExameExcluido> iExamesExcluidos = examesExcluidos.iterator();
                HashSet<String> controleExameWs = new HashSet<String>();
                for (Registro amostra : (List)registroRequisicao.getValor("amostras")) {
                    if (amostra.getValor("examesRequisicaoAlvaro") == null) continue;
                    Set exameAlvaros = (Set)amostra.getValor("examesRequisicaoAlvaro");
                    for (ExameAlvaro exameAlvaro : exameAlvaros) {
                        examesExcluidos = new ConcurrentLinkedQueue<ExameExcluido>(examesExcluido);
                        iExamesExcluidos = examesExcluidos.iterator();
                        while (iExamesExcluidos.hasNext()) {
                            boolean agruparMultiguias;
                            ExameExcluido exameExcluido = iExamesExcluidos.next();
                            if (!exameExcluido.getExame().equalsIgnoreCase(exameAlvaro.getExameJalis())) continue;
                            registro.setValor("ele_xmllabexterno", exameAlvaro.getXmlJalis());
                            registro.setValor("lex_codigo", registroRequisicao.getString("lex_codigo"));
                            registro.setValor("req_codigo", exameExcluido.getRequisicao());
                            registro.setValor("lae_codigo", labExterno.codigoLab);
                            registro.setValor("fil_kodigo", filial);
                            registro.setValor("fil_codigo", filial);
                            registro.setValor(EXA_CODIGO, exameExcluido.getExame());
                            registro.setValor(MCO_CODIGO, exameExcluido.getMaterial());
                            exameRequisicoes = new ArrayList();
                            exameRequisicoesTmp = new ArrayList();
                            exameRequisicoes.add(registro);
                            exameRequisicoesTmp.add(exameRequisicoes);
                            if (controleExameWs.contains(exameExcluido.getExame())) continue;
                            if (executarWebService) {
                                // empty if block
                            }
                            controleExameWs.add(exameExcluido.getExame());
                            Integer[] multiguias = null;
                            boolean bl = agruparMultiguias = agruparGuiasInterface || DBUtil.requisicaoAgrupaMultiguiasLabExterno(statement, filial, String.valueOf(registro.getValor("req_codigo")));
                            if (agruparMultiguias) {
                                multiguias = RecepcaoUtil.verificaMultiGuias(filial, exameExcluido.getRequisicao(), true);
                                HashSet<Integer> guiaMulti = new HashSet<Integer>();
                                Integer[] integerArray = multiguias;
                                int n = integerArray.length;
                                for (int i = 0; i < n; ++i) {
                                    Integer integer = integerArray[i];
                                    guiaMulti.add(integer);
                                }
                                guiaMulti.add(Integer.parseInt(codigo));
                                multiguias = guiaMulti.toArray(new Integer[guiaMulti.size()]);
                            } else {
                                multiguias = new Integer[]{Integer.parseInt(codigo)};
                            }
                            if (multiguias != null) {
                                for (Integer guia : multiguias) {
                                    boolean possuiOutrosExames;
                                    ResultSet rs;
                                    StringBuilder sql = new StringBuilder();
                                    sql.append("delete from loteexternoexamerequisicao where fil_codigo = ").append(filial);
                                    sql.append(" and lex_codigo = ").append(registroRequisicao.getString("lex_codigo"));
                                    sql.append(" and lae_codigo = ").append(labExterno.codigoLab);
                                    sql.append(" and req_codigo = ").append(guia);
                                    sql.append(" and mco_codigo = ").append(exameExcluido.getMaterial());
                                    sql.append(" and fil_kodigo = ").append(filial);
                                    sql.append(" and exa_codigo = '").append(exameExcluido.getExame()).append("'");
                                    statement.execute(sql.toString());
                                    if (agruparMultiguias) {
                                        sql = new StringBuilder();
                                        sql.append("delete from loteexternoexamerequisicaorecip where fil_codigo = ").append(filial);
                                        sql.append(" and lex_codigo = ").append(registroRequisicao.getString("lex_codigo"));
                                        sql.append(" and lae_codigo = ").append(labExterno.codigoLab);
                                        sql.append(" and req_codigo = ").append(guia);
                                        sql.append(" and mco_codigo = ").append(exameExcluido.getMaterial());
                                        sql.append(" and fil_kodigo = ").append(filial);
                                        sql.append(" and exa_codigo = '").append(exameExcluido.getExame()).append("'");
                                        statement.execute(sql.toString());
                                    } else {
                                        ArrayList<Registro> exames = UtilExportadores.pegaExamesRequisicaoRecipiente(statement, Integer.parseInt(labExterno.codigoLab), guia.toString(), filial, registroRequisicao.getString("lex_codigo"));
                                        for (Registro exa : exames) {
                                            if (exa == null || Funcoes.textoVazio(exa.getString("rec_kodigo"))) continue;
                                            sql = new StringBuilder();
                                            sql.append("delete from loteexternoexamerequisicaorecip where fil_codigo = ").append(filial);
                                            sql.append(" and lex_codigo = ").append(registroRequisicao.getString("lex_codigo"));
                                            sql.append(" and lae_codigo = ").append(labExterno.codigoLab);
                                            sql.append(" and req_codigo = ").append(guia);
                                            sql.append(" and mco_codigo = ").append(exameExcluido.getMaterial());
                                            sql.append(" and fil_kodigo = ").append(filial);
                                            sql.append(" and exa_codigo = '").append(exameExcluido.getExame()).append("'");
                                            if (!Funcoes.textoVazio(exa.getString("rec_kodigo"))) {
                                                sql.append(" and rec_codigo = ").append(exa.getString("rec_kodigo"));
                                            }
                                            statement.execute(sql.toString());
                                        }
                                    }
                                    sql = new StringBuilder();
                                    sql.append("update examerequisicao set exr_dataloteexterno = null, usr_codloteexterno = null ");
                                    sql.append("where fil_codigo = ").append(filial);
                                    sql.append(" and req_codigo = ").append(guia);
                                    sql.append(" and exa_codigo = '").append(exameExcluido.getExame()).append("' ");
                                    sql.append(" and mco_codigo = ").append(exameExcluido.getMaterial());
                                    statement.execute(sql.toString());
                                    sql = new StringBuilder();
                                    sql.append("select lex.lex_codigo from loteexternorequisicao lex ");
                                    sql.append(" where lex.fil_codigo = ");
                                    sql.append(filial);
                                    sql.append(" and lex.lae_codigo = ").append(labExterno.codigoLab);
                                    sql.append(" and lex.lex_codigo = ").append(registroRequisicao.getString("lex_codigo"));
                                    sql.append(" and lex.leq_dataestorno is null and usr_codestorno is null ");
                                    sql.append(" and lex.req_codigo not in (").append(StringUtil.implode(Arrays.asList(guia), ",")).append(");");
                                    ResultSet resultSetExisteLote = statement.executeQuery(sql.toString());
                                    if (!resultSetExisteLote.next()) {
                                        sql = new StringBuilder();
                                        sql.append("select count(1) as qtd from loteexternoexamerequisicao where fil_codigo = ").append(filial);
                                        sql.append(" and lex_codigo = ").append(registroRequisicao.getString("lex_codigo"));
                                        sql.append(" and lae_codigo = ").append(labExterno.codigoLab);
                                        sql.append(" and req_codigo = ").append(guia);
                                        sql.append(" and fil_kodigo = ").append(filial);
                                        sql.append(" and exa_codigo not in('").append(exameExcluido.getExame()).append("')");
                                        rs = statement.executeQuery(sql.toString());
                                        possuiOutrosExames = true;
                                        if (rs.next()) {
                                            boolean bl2 = possuiOutrosExames = rs.getInt("qtd") > 0;
                                        }
                                        if (possuiOutrosExames) continue;
                                        sql = new StringBuilder();
                                        sql.append(" update  loteexternorequisicao set leq_dataestorno = current_timestamp, usr_codestorno = '").append(Variaveis.login).append("'");
                                        sql.append(" where fil_codigo = ").append(filial);
                                        sql.append(" and lex_codigo = ").append(registroRequisicao.getString("lex_codigo"));
                                        sql.append(" and lae_codigo = ").append(labExterno.codigoLab);
                                        sql.append(" and req_codigo = ").append(guia);
                                        statement.execute(sql.toString());
                                        if (!isColetaWeb) {
                                            Conexao.arquivaSQL();
                                        }
                                        sql = new StringBuilder();
                                        sql.append("select * from loteexternorequisicao where fil_codigo = ").append(filial);
                                        sql.append(" and lex_codigo = ").append(registroRequisicao.getString("lex_codigo"));
                                        sql.append(" and lae_codigo = ").append(labExterno.codigoLab);
                                        sql.append(" and leq_dataestorno is null and usr_codestorno is null ");
                                        rs = statement.executeQuery(sql.toString());
                                        if (rs.next()) continue;
                                        sql = new StringBuilder();
                                        sql.append("update loteexterno set lex_dataestorno = current_timestamp, usr_codestorno = '").append(Variaveis.login).append("'");
                                        sql.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
                                        sql.append("  and lex_codigo = ").append(registroRequisicao.getString("lex_codigo"));
                                        sql.append(" and lae_codigo = ").append(labExterno.codigoLab);
                                        if (isColetaWeb) {
                                            statement.executeUpdate(sql.toString());
                                            continue;
                                        }
                                        Conexao.executeUpdate(Variaveis.filialPadrao, statement, sql);
                                        continue;
                                    }
                                    sql = new StringBuilder();
                                    sql.append("select count(1) as qtd from loteexternoexamerequisicao where fil_codigo = ").append(filial);
                                    sql.append(" and lex_codigo = ").append(registroRequisicao.getString("lex_codigo"));
                                    sql.append(" and lae_codigo = ").append(labExterno.codigoLab);
                                    sql.append(" and req_codigo = ").append(guia);
                                    sql.append(" and fil_kodigo = ").append(filial);
                                    sql.append(" and exa_codigo not in('").append(exameExcluido.getExame()).append("')");
                                    rs = statement.executeQuery(sql.toString());
                                    possuiOutrosExames = true;
                                    if (rs.next()) {
                                        boolean bl3 = possuiOutrosExames = rs.getInt("qtd") > 0;
                                    }
                                    if (possuiOutrosExames) continue;
                                    sql = new StringBuilder();
                                    sql.append(" update  loteexternorequisicao set leq_dataestorno = current_timestamp, usr_codestorno = '").append(Variaveis.login).append("'");
                                    sql.append(" where fil_codigo = ").append(filial);
                                    sql.append(" and lex_codigo = ").append(registroRequisicao.getString("lex_codigo"));
                                    sql.append(" and lae_codigo = ").append(labExterno.codigoLab);
                                    sql.append(" and req_codigo = ").append(guia);
                                    statement.execute(sql.toString());
                                    if (!isColetaWeb) {
                                        Conexao.arquivaSQL();
                                    }
                                    sql = new StringBuilder();
                                    sql.append("select * from loteexternorequisicao where fil_codigo = ").append(filial);
                                    sql.append(" and lex_codigo = ").append(registroRequisicao.getString("lex_codigo"));
                                    sql.append(" and lae_codigo = ").append(labExterno.codigoLab);
                                    sql.append(" and leq_dataestorno is null and usr_codestorno is null ");
                                    rs = statement.executeQuery(sql.toString());
                                    if (rs.next()) continue;
                                    sql = new StringBuilder();
                                    sql.append("update loteexterno set lex_dataestorno = current_timestamp, usr_codestorno = '").append(Variaveis.login).append("'");
                                    sql.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
                                    sql.append("  and lex_codigo = ").append(registroRequisicao.getString("lex_codigo"));
                                    sql.append(" and lae_codigo = ").append(labExterno.codigoLab);
                                    if (isColetaWeb) {
                                        statement.executeUpdate(sql.toString());
                                        continue;
                                    }
                                    Conexao.executeUpdate(Variaveis.filialPadrao, statement, sql);
                                }
                            }
                            iExamesExcluidos.remove();
                        }
                    }
                }
            }
        }
    }

    public static RetornoImpressaoEtiquetas comunicacaoOk(String enderecoWebService, boolean isColetaWeb, String nomeProtocolo) throws IOException, NoSuchAlgorithmException, KeyManagementException {
        RetornoImpressaoEtiquetas retorno = new RetornoImpressaoEtiquetas();
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        SSLContext sc = SSLContext.getInstance("SSL");
        if (enderecoWebService.contains("https")) {
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        }
        try {
            URL url = new URL(enderecoWebService);
            HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
            urlConnection.setDoOutput(true);
            urlConnection.setDoInput(true);
            urlConnection.setRequestMethod("GET");
            urlConnection.setRequestProperty("Content-type", "text/xml; charset=UTF-8");
            urlConnection.connect();
            int codigoResposta = urlConnection.getResponseCode();
            String msg = urlConnection.getResponseMessage();
            String mensagemRetorno = "";
            if (codigoResposta != 200 && codigoResposta != 204) {
                if (codigoResposta == 404) {
                    if (!isColetaWeb) {
                        Funcoes.mensagem(Laboratorio.getInstancia(), "Endere\u00e7o do WebService inv\u00e1lido.", 2);
                    }
                    mensagemRetorno = "Endere\u00e7o do WebService inv\u00e1lido.";
                    UtilExportadores.adicionarMensagemRetorno(mensagemRetorno, nomeProtocolo, retorno);
                    retorno.setImprimiu(false);
                    return retorno;
                }
                if (codigoResposta == 401) {
                    if (!isColetaWeb) {
                        Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o autorizado.", 2);
                    }
                    UtilExportadores.adicionarMensagemRetorno("N\u00e3o autorizado.", nomeProtocolo, retorno);
                    retorno.setImprimiu(false);
                    return retorno;
                }
                if (codigoResposta == 503) {
                    if (!isColetaWeb) {
                        Funcoes.mensagem(Laboratorio.getInstancia(), "Servi\u00e7o indispon\u00edvel.", 2);
                    }
                    UtilExportadores.adicionarMensagemRetorno("Servi\u00e7o indispon\u00edvel.", nomeProtocolo, retorno);
                    retorno.setImprimiu(false);
                    return retorno;
                }
                if (codigoResposta == 500) {
                    if (!isColetaWeb) {
                        Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel obter conex\u00e3o com o servidor.", 2);
                    }
                    UtilExportadores.adicionarMensagemRetorno("N\u00e3o foi poss\u00edvel obter conex\u00e3o com o servidor.", nomeProtocolo, retorno);
                    retorno.setImprimiu(false);
                    return retorno;
                }
                if (!isColetaWeb) {
                    Funcoes.mensagem(Laboratorio.getInstancia(), msg + "\nN\u00e3o foi poss\u00edvel obter conex\u00e3o com o servidor.\nC\u00f3digo: " + codigoResposta, 2);
                }
                UtilExportadores.adicionarMensagemRetorno("N\u00e3o foi poss\u00edvel obter conex\u00e3o com o servidor. \nC\u00f3digo: " + codigoResposta, nomeProtocolo, retorno);
                retorno.setImprimiu(false);
                return retorno;
            }
        }
        catch (Exception e) {
            String mensagem = "";
            if (e != null && e.toString().contains("java.net.MalformedURLException")) {
                if (!isColetaWeb) {
                    Funcoes.mensagem(Laboratorio.getInstancia(), "Endere\u00e7o de WebService inv\u00e1lido.\nVerifique as configura\u00e7\u00f5es do Laborat\u00f3rio externo e tente novamente.", 2);
                }
                mensagem = "Endere\u00e7o de WebService inv\u00e1lido.\nVerifique as configura\u00e7\u00f5es do Laborat\u00f3rio externo e tente novamente.";
            } else {
                if (!isColetaWeb) {
                    Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel conectar ao servidor. Verifique sua internet.", 2);
                }
                mensagem = "N\u00e3o foi poss\u00edvel conectar ao servidor. Verifique sua internet.";
            }
            UtilExportadores.adicionarMensagemRetorno(mensagem, nomeProtocolo, retorno);
            retorno.setImprimiu(false);
            return retorno;
        }
        retorno.setImprimiu(true);
        return retorno;
    }

    @Deprecated
    public static boolean enviarRequisicaoLabExterno(int requisiscaoPai, String codigofilial, boolean imprimirEtiqueta, Statement st, int digitosTuboFilial, int digitosTuboRequisicao, boolean isColetaWeb, int agruparInterface, boolean agruparGuiasInterface) throws Exception {
        LaboratorioExterno labExterno = UtilExportadores.localizaLabExterno(Variaveis.filialPadrao, st);
        List<Registro> list = UtilExportadores.localizaRequisicao(codigofilial, String.valueOf(requisiscaoPai), st);
        if (labExterno != null) {
            AbstractConfiguradorProtocolo conf = FabricaConfigurador.novoConfiguradorProtocolo(Laboratorio.getInstancia(), Protocolo.Alvaro, labExterno.codigoLab);
            Exportador exp = FabricaExportador.novoExportador(Protocolo.Alvaro);
            HashMap<String, Registro> requisicoes = new HashMap<String, Registro>();
            conf.setXML(labExterno.configuracao, false);
            String enderecoWebService = StringUtil.getValor(conf.getXML(), "enderecoWebService");
            if (UtilExportadores.comunicacaoOk(enderecoWebService, isColetaWeb, Protocolo.Alvaro.getDescricao()).isImprimiu()) {
                for (Registro reg : list) {
                    Registro r = UtilExportadores.addRequisicao(reg, null, requisicoes, labExterno, st, digitosTuboFilial, digitosTuboRequisicao, agruparGuiasInterface);
                    if (r == null) continue;
                    requisicoes.put(UtilExportadores.getChave(r, digitosTuboFilial, digitosTuboRequisicao), r);
                }
                int numeroLote = exp.getMaiorCodigoLote(String.valueOf(conf.getNumeroLote()), null, labExterno, st);
                if (st != null) {
                    st.close();
                }
                List<Registro> lote = UtilExportadores.gravarLote(numeroLote, labExterno, requisicoes, st, isColetaWeb);
                lote = UtilExportadores.processaMultiguia(lote, agruparInterface);
                if (numeroLote > conf.getNumeroLote()) {
                    conf.setNumeroLote(numeroLote);
                }
                if (lote != null && !lote.isEmpty()) {
                    numeroLote = lote.get(0).getInt("lex_codigo");
                    boolean enviouWs = false;
                    if (exp instanceof ExportacaoParaAlvaro && enviouWs) {
                        for (Registro registro : lote) {
                            String codigoApoiado = ((ExportacaoParaAlvaro)exp).obterCodigoAlvaroRetornado(registro, labExterno.codigoLab, String.valueOf(numeroLote), st, digitosTuboFilial, digitosTuboRequisicao);
                            if (Funcoes.textoVazio(codigoApoiado)) continue;
                            UtilExportadores.atualizaCodigoApoiadoRequisicao(registro.getString("fil_codigo"), registro.getString("req_codigo"), codigoApoiado, agruparGuiasInterface, st, isColetaWeb);
                        }
                    } else {
                        return false;
                    }
                }
                labExterno.configuracao = conf.getXML();
                labExterno.salvarConfiguracao(st, false);
                if (!isColetaWeb) {
                    Conexao.arquivaSQL();
                }
            }
        } else {
            return false;
        }
        return true;
    }

    public static ArrayList<Registro> verificaExamesComLote(String filial, String requisicao, String[] exames, int[] materiais, int agruparInterface, Statement st) {
        ArrayList<Registro> lista = new ArrayList<Registro>();
        String guias = requisicao;
        if (agruparInterface == 0 || agruparInterface == 1) {
            Integer[] multiguia = null;
            try {
                multiguia = RecepcaoUtil.verificaMultiGuias(st, filial, requisicao, true, false);
            }
            catch (SQLException e1) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e2o foi poss\u00edvel verificiar multiguia no carregamento de lote.\n" + e1.getMessage(), e1.getStackTrace());
            }
            guias = StringUtil.implode(Arrays.asList(multiguia), ",");
        }
        StringBuilder buf = new StringBuilder();
        buf.append("select lot.lex_codigo, lotex.exa_codigo as codigoExame, ");
        buf.append("       lotex.mco_codigo as codigoMaterial, ");
        buf.append("       lot.leq_retornows as retornoWs");
        buf.append("  from loteexternorequisicao lot ");
        buf.append("  join loteexternoexamerequisicao lotex on lot.fil_codigo = lotex.fil_codigo and lot.req_codigo = lotex.req_codigo and lot.lex_codigo = lotex.lex_codigo ");
        buf.append(" where lot.fil_kodigo = ").append(filial);
        buf.append("   and lot.req_codigo in (").append(guias).append(") ");
        buf.append("   and lot.leq_retornows is not null ");
        buf.append("   and lot.leq_dataestorno is null ");
        if (exames != null && exames.length > 0 && materiais != null && materiais.length > 0) {
            buf.append("  and (lotex.exa_codigo, lotex.mco_codigo) IN (");
            for (int i = 0; i < exames.length; ++i) {
                if (i > 0) {
                    buf.append(",");
                }
                buf.append("(").append(StringUtil.textoDBEscape(exames[i]));
                buf.append(",").append(materiais[i]).append(")");
            }
            buf.append(" )  ");
        }
        try {
            ResultSet rs = st.executeQuery(buf.toString());
            Registro reg = null;
            while (rs.next()) {
                reg = new Registro(rs);
                lista.add(reg);
            }
            rs.close();
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e2o foi poss\u00edvel verificar lote externo.\n" + e.getMessage(), e.getStackTrace());
        }
        return lista;
    }

    private static void atualizaCodigoApoiadoRequisicao(String filial, String requisicao, String codigoApoiado, boolean agruparGuiasInterface, Statement st, boolean isColetaWeb) throws Exception {
        Integer[] multiguias = null;
        boolean agruparMultiguias = agruparGuiasInterface || DBUtil.requisicaoAgrupaMultiguiasLabExterno(st, filial, requisicao);
        multiguias = agruparMultiguias ? RecepcaoUtil.verificaMultiGuias(st, filial, requisicao, true, false) : new Integer[]{Integer.parseInt(requisicao)};
        if (multiguias != null) {
            for (Integer guia : multiguias) {
                RequisicaoBean bean = new RequisicaoBean();
                FilialVO fil = new FilialVO();
                fil.setCodigo(Integer.parseInt(filial));
                bean.setFilial(fil);
                bean.setCodigo(guia);
                bean.setCodigoApoiado(codigoApoiado);
                RequisicaoService service = new RequisicaoService();
                service.update(bean, requisicao, filial, null);
            }
            if (!isColetaWeb) {
                Conexao.arquivaSQL();
            }
        }
    }

    public static String[] verificaLoteExternoExameRequisicao(String codigoRequisicao, String codigoFilial, String codigoExame, String material) {
        Statement st = Conexao.getStatement();
        String[] retorno = UtilExportadores.verificaLoteExternoExameRequisicao(codigoRequisicao, codigoFilial, codigoExame, material, st);
        Conexao.fecharStatement(st);
        return retorno;
    }

    public static String[] verificaLoteExternoExameRequisicao(String codigoRequisicao, String codigoFilial, String codigoExame, String material, Statement st) {
        if (Funcoes.textoVazio(codigoRequisicao) || Funcoes.textoVazio(codigoFilial) || Funcoes.textoVazio(codigoExame)) {
            return null;
        }
        String[] dados = null;
        StringBuilder buf = new StringBuilder();
        buf.append(" select lae.lae_descricao as labexterno, lote.lex_codigo as lote, mco.mco_descricao, lote.fil_codigo as filialLoteOrigem ");
        buf.append("   from examerequisicao exr ");
        buf.append("   join requisicao req on exr.fil_codigo = req.fil_codigo and exr.req_codigo = req.req_codigo ");
        buf.append("   left join loteexternoexamerequisicao lote on exr.fil_codigo = lote.fil_kodigo and exr.exa_codigo = lote.exa_codigo and exr.mco_codigo = lote.mco_codigo and exr.req_codigo = lote.req_codigo ");
        buf.append("   left join labexterno lae on lote.lae_codigo = lae.lae_codigo and lote.fil_codigo = lae.fil_codigo ");
        buf.append("   left join loteexternorequisicao leq on leq.fil_kodigo =  exr.fil_codigo and leq.req_codigo = exr.req_codigo and leq.lae_codigo = lae.lae_codigo ");
        buf.append("   left join materialcoleta mco on mco.fil_codigo =  exr.fil_codigo and mco.mco_codigo = exr.mco_codigo ");
        buf.append("  where req.fil_codigo = ").append(codigoFilial);
        buf.append("    and req.req_codigo = ").append(codigoRequisicao);
        buf.append("    and exr.exa_codigo = '").append(codigoExame).append("' ");
        buf.append("    and exr.mco_codigo = '").append(material).append("' ");
        buf.append("    and not req.req_excluida ");
        buf.append("    and not exr.exr_excluido ");
        buf.append("    and exr_dataloteexterno is not null");
        buf.append("    and leq.leq_dataestorno is null ");
        try {
            ResultSet rs = st.executeQuery(buf.toString());
            if (rs.next()) {
                dados = new String[]{rs.getString("labexterno"), rs.getString("lote"), rs.getString("mco_descricao"), rs.getString("filialLoteOrigem")};
            }
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return dados;
    }

    public static boolean isEnvioAutomatico(Statement st, boolean isColetaWeb) {
        LaboratorioExterno labExterno = null;
        try {
            labExterno = UtilExportadores.localizaLabExterno(Variaveis.filialPadrao, st);
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel localizar laborat\u00f3rio externo configurado.\n" + e.getMessage(), e.getStackTrace());
        }
        if (labExterno == null) {
            return false;
        }
        String envioAutomatico = StringUtil.getValor(labExterno.configuracao, "envioAutomatico");
        String enderecoWebService = StringUtil.getValor(labExterno.configuracao, "enderecoWebService");
        boolean isEnvio = !Funcoes.textoVazio(envioAutomatico) && Boolean.valueOf(envioAutomatico) != false;
        try {
            if (isEnvio && !UtilExportadores.comunicacaoOk(enderecoWebService, isColetaWeb, "").isImprimiu()) {
                return false;
            }
        }
        catch (KeyManagementException e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel localizar laborat\u00f3rio externo configurado.\n" + e.getMessage(), e.getStackTrace());
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return isEnvio;
    }

    public static boolean isEnvioAutomaticoDB(Statement st, boolean isColetaWeb) {
        LaboratorioExterno labExterno = null;
        try {
            labExterno = UtilExportadores.localizaLabExternoDB(Variaveis.filialPadrao, st);
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel localizar laborat\u00f3rio externo configurado.\n" + e.getMessage(), e.getStackTrace());
        }
        catch (ThreadDaoException e) {
            e.printStackTrace();
        }
        if (labExterno == null) {
            return false;
        }
        String envioAutomatico = StringUtil.getValor(labExterno.configuracao, "enviarLotePelaRequisicao");
        String enderecoWebService = StringUtil.getValor(labExterno.configuracao, "enderecoWebService");
        boolean isEnvio = !Funcoes.textoVazio(envioAutomatico) && Boolean.valueOf(envioAutomatico) != false;
        try {
            if (isEnvio && !UtilExportadores.comunicacaoOk(enderecoWebService, isColetaWeb, labExterno.protocolo.getDescricao()).isImprimiu()) {
                return false;
            }
        }
        catch (KeyManagementException e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel localizar laborat\u00f3rio externo configurado.\n" + e.getMessage(), e.getStackTrace());
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return isEnvio;
    }

    public static boolean isEnvioHpDirect(Statement st) {
        LaboratorioExterno labExterno = null;
        try {
            labExterno = UtilExportadores.localizaLabExternoPardini(Variaveis.filialPadrao, st);
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel localizar laborat\u00f3rio externo configurado.\n" + e.getMessage(), e.getStackTrace());
        }
        if (labExterno == null) {
            return false;
        }
        String enviarEtiquetaHpDirect = StringUtil.getValor(labExterno.configuracao, "enviarEtiquetaHpDirect");
        boolean isEnvio = !Funcoes.textoVazio(enviarEtiquetaHpDirect) && Boolean.valueOf(enviarEtiquetaHpDirect) != false;
        return isEnvio;
    }

    public static boolean isEnvioRequisicaoHP(Statement st) {
        LaboratorioExterno labExterno = null;
        try {
            labExterno = UtilExportadores.localizaLabExternoPardiniEnvioRequisicao(Variaveis.filialPadrao, st);
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel localizar laborat\u00f3rio externo configurado.\n" + e.getMessage(), e.getStackTrace());
        }
        catch (ThreadDaoException e) {
            e.printStackTrace();
        }
        if (labExterno == null) {
            return false;
        }
        String enviarLoteRequisicao = StringUtil.getValor(labExterno.configuracao, "envioAutomatico");
        String enviarLoteWebService = StringUtil.getValor(labExterno.configuracao, "enviarLoteWebservice");
        return !Funcoes.textoVazio(enviarLoteWebService) && Boolean.valueOf(enviarLoteWebService) != false && !Funcoes.textoVazio(enviarLoteRequisicao) && Boolean.valueOf(enviarLoteRequisicao) != false;
    }

    public static boolean podeExcluirExameLoteExternoAlvaro(String req, List<ExameExcluido> examesExcluidos, String filial, Statement st, Statement st2, boolean isAgruparGuiasInterface) {
        try {
            LaboratorioExterno labExterno = UtilExportadores.localizaLabExterno(Variaveis.filialPadrao, st);
            if (labExterno != null && labExterno.protocolo != null) {
                List<Registro> listaRegistro = new LoteExternoExameRequisicaoService().requisicaoEnviadaParaAlvaro(req, filial, false, st, st2, isAgruparGuiasInterface);
                for (Registro registroRequisicao : listaRegistro) {
                    if (registroRequisicao == null) continue;
                    for (Registro amostra : (List)registroRequisicao.getValor("amostras")) {
                        if (amostra.getValor("examesRequisicaoAlvaro") == null) continue;
                        Set exameAlvaros = (Set)amostra.getValor("examesRequisicaoAlvaro");
                        for (ExameAlvaro exameAlvaro : exameAlvaros) {
                            for (ExameExcluido exameExcluido : examesExcluidos) {
                                if (!exameExcluido.getExame().equalsIgnoreCase(exameAlvaro.getExameJalis())) continue;
                                return true;
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
        }
        return false;
    }

    public static boolean podeExcluirRequisicaoLoteExternoAlvaro(String req, String filial, Statement st, Statement st2, boolean isAgruparGuiasInterface) {
        try {
            LaboratorioExterno labExterno = UtilExportadores.localizaLabExterno(Variaveis.filialPadrao, st);
            if (labExterno != null && labExterno.protocolo != null) {
                AbstractConfiguradorProtocolo conf = FabricaConfigurador.novoConfiguradorProtocolo(Laboratorio.getInstancia(), Protocolo.Alvaro, labExterno.codigoLab);
                conf.setXML(labExterno.configuracao, false);
                LoteExternoExameRequisicaoService loteExternoExameRequisicaoService = new LoteExternoExameRequisicaoService();
                List<Registro> listaRegistro = loteExternoExameRequisicaoService.requisicaoEnviadaParaAlvaro(req, filial, false, st, st2, isAgruparGuiasInterface);
                for (Registro registroRequisicao : listaRegistro) {
                    if (registroRequisicao == null) continue;
                    for (Registro amostra : (List)registroRequisicao.getValor("amostras")) {
                        Set exameAlvaros;
                        if (amostra.getValor("examesRequisicaoAlvaro") == null || (exameAlvaros = (Set)amostra.getValor("examesRequisicaoAlvaro")).isEmpty()) continue;
                        return true;
                    }
                    if (!registroRequisicao.getString("req_codigo").equals(req)) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
        }
        return false;
    }

    public static String retornoWs(Registro requisicao, String codLabExterno, String numeroLote, Statement st) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append("select leq_retornows from loteexternorequisicao where fil_codigo = ").append(Variaveis.filialPadrao);
        sql.append(" and fil_kodigo = ").append(requisicao.getString("fil_codigo"));
        sql.append(" and req_codigo in (").append(requisicao.getString("req_codigo")).append(") ");
        sql.append(" and lae_codigo=").append(codLabExterno);
        sql.append(" and leq_retornows is not null ");
        sql.append(" and leq_retornows <> '' ");
        sql.append(" order by lex_codigo desc ");
        ResultSet rs = st.executeQuery(sql.toString());
        if (rs.next()) {
            return rs.getString("leq_retornows");
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean exameConfiguradoParaLabExterno(String filial, String codigoLab, String exame, int material, Statement st) throws SQLException {
        try {
            StringBuilder buf = new StringBuilder();
            buf.append(" SELECT DISTINCT a.exa_codigo, ele_xmllabexterno FROM examematcoletalabexterno a ");
            buf.append(" LEFT JOIN examematcoleta emc ON emc.fil_codigo = a.fil_codigo ");
            buf.append(" AND emc.mco_codigo = a.mco_codigo ");
            buf.append(" AND emc.met_codigo = a.met_codigo ");
            buf.append(" AND emc.exa_codigo = a.exa_codigo ");
            buf.append(" LEFT JOIN examelayout b ON a.fil_codigo = b.fil_codigo ");
            buf.append(" AND a.exa_codigo = b.exa_codigo ");
            buf.append(" AND a.mco_codigo = b.mco_codigo ");
            buf.append(" LEFT JOIN examelayoutmetodo c ON b.fil_codigo = c.fil_codigo ");
            buf.append(" AND b.exa_codigo = c.exa_codigo ");
            buf.append(" AND b.mco_codigo = c.mco_codigo ");
            buf.append(" AND b.ela_idadeini = c.ela_idadeini ");
            buf.append(" AND b.ela_idadefim = c.ela_idadefim ");
            buf.append(" AND b.ela_idadeinitipo = c.ela_idadeinitipo ");
            buf.append(" AND b.ela_idadefimtipo = c.ela_idadefimtipo ");
            buf.append(" AND b.lay_codigo = c.lay_codigo ");
            buf.append(" WHERE a.fil_codigo = ").append(filial);
            buf.append("   AND a.lae_codigo = ").append(codigoLab);
            buf.append("   AND b.ela_padrao = TRUE ");
            buf.append("   AND a.exa_codigo = '").append(exame).append("' ");
            buf.append("   AND a.mco_codigo = ").append(material);
            buf.append("   AND ele_xmllabexterno <> '' AND ele_xmllabexterno is not null ");
            ResultSet rs = st.executeQuery(buf.toString());
            boolean bl = rs.next();
            return bl;
        }
        finally {
            st.close();
        }
    }

    public static ArrayList<Registro> pegaExamesRequisicaoRecipiente(Statement st, int laboratorioExterno, String requisicao, String filialDaRequisicao, String lote) throws Exception {
        ArrayList<Registro> retorno = new ArrayList<Registro>();
        StringBuilder buf = new StringBuilder("select a.fil_codigo, a.lex_codigo, a.req_codigo, a.lae_codigo ,a.fil_kodigo, a.exa_codigo, a.mco_codigo, b.mco_abreviatura, c.exa_descricao ");
        buf.append(", e.exr_descricaomaterial, e.exr_datamaterial, e.exr_volumediurese, e.exr_tempodiurese, f.ele_xmllabexterno, g.rec_kodigo, e.exr_codigoapoiado, lex.leq_dataestorno, lex.usr_codestorno ");
        buf.append(" from loteexternoexamerequisicao a ");
        buf.append(" left join loteexternorequisicao lex on a.fil_codigo = lex.fil_codigo and a.req_codigo = lex.req_codigo and a.lex_codigo = lex.lex_codigo and a.lae_codigo = lex.lae_codigo ");
        buf.append(" left join examematcoleta d on a.fil_codigo = d.fil_codigo and a.exa_codigo = d.exa_codigo and a.mco_codigo = d.mco_codigo ");
        buf.append(" left join exames c on a.fil_codigo = c.fil_codigo and a.exa_codigo = c.exa_codigo ");
        buf.append(" left join materialcoleta b on a.fil_codigo = b.fil_codigo and a.mco_codigo = b.mco_codigo ");
        buf.append(" left join examerequisicao e on a.fil_codigo = e.fil_codigo and a.req_codigo = e.req_codigo and a.exa_codigo = e.exa_codigo and a.mco_codigo = e.mco_codigo ");
        buf.append(" left join examematcoletalabexterno f on d.fil_codigo = f.fil_codigo and d.exa_codigo = f.exa_codigo and d.mco_codigo = f.mco_codigo and d.lae_codigo = f.lae_codigo ");
        buf.append(" left join examerequisicaorecipiente g on f.fil_codigo = g.fil_codigo and f.exa_codigo = g.exa_codigo and a.req_codigo = g.req_codigo and f.mco_codigo = g.mco_codigo and g.ere_tipo = '").append("C").append("' ");
        buf.append(" where a.fil_codigo = ").append(Variaveis.filialPadrao);
        buf.append(" and a.fil_kodigo = ").append(filialDaRequisicao);
        buf.append(" and a.req_codigo in(").append(requisicao).append(") ");
        buf.append(" and a.lex_codigo = ").append(lote);
        buf.append(" and a.lae_codigo = ").append(laboratorioExterno);
        ResultSet rs = st.executeQuery(buf.toString());
        while (rs.next()) {
            retorno.add(new Registro(rs));
        }
        return retorno;
    }

    public static void adicionarMensagemRetorno(String mensagem, String apoio, RetornoImpressaoEtiquetas retorno) {
        if (retorno.getMensagensRetornoLabExterno() == null) {
            HashMap<String, String> newMap = new HashMap<String, String>();
            retorno.setMensagensRetornoLabExterno(newMap);
            retorno.getMensagensRetornoLabExterno().put(apoio, mensagem);
            return;
        }
        if (!retorno.getMensagensRetornoLabExterno().isEmpty() && !Funcoes.textoVazio(retorno.getMensagensRetornoLabExterno().get(apoio))) {
            String msgAtual = retorno.getMensagensRetornoLabExterno().get(apoio);
            if (!Funcoes.textoVazio(msgAtual)) {
                msgAtual = msgAtual + "<br>" + mensagem;
                retorno.getMensagensRetornoLabExterno().put(apoio, msgAtual);
            } else {
                retorno.getMensagensRetornoLabExterno().put(apoio, mensagem);
            }
        } else {
            retorno.getMensagensRetornoLabExterno().put(apoio, mensagem);
        }
    }

    public static String getXMLParaColetaWeb(File arquivo) {
        if (arquivo != null) {
            try {
                Scanner scanner = new Scanner(arquivo);
                StringBuilder conteudoGerado = new StringBuilder();
                while (scanner.hasNext()) {
                    conteudoGerado.append(scanner.nextLine());
                }
                return conteudoGerado.toString();
            }
            catch (FileNotFoundException e) {
                return "";
            }
        }
        return "";
    }
}

