/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.externo.exportadores;

import jalis.apoio.servidor.IServidor;
import jalis.comum.Conexao;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.triagem.externo.ReimpressaoRelatorioEtiqueta;
import jalis.laboratorio.triagem.externo.exportadores.UtilExportadores;
import jalis.laboratorio.triagem.externo.exportadores.UtilJalis;
import jalis.laboratorio.util.impressao.RetornoImpressaoEtiquetas;
import jalis.laboratorio.util.impressao.labexterno.ImpressorasLabExterno;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.laboratorio.util.parsers.jalis.ConfiguradorProtocoloJalis;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.impressao.termica.ImpressaoTermica;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.math.RoundingMode;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;

public class ReimprimirRelatorioEtiquetaJalis
implements ReimpressaoRelatorioEtiqueta {
    @Override
    public RetornoImpressaoEtiquetas reimprimirEtiquetas(String codLabExterno, String numeroLote, String codigoConvenio, String configuracaoLabExterno, Statement st, int digitosTuboFilial, int digitosTuboRequisicao, boolean isColetaWeb, Callable<Boolean> arquivar, Callable<Boolean> anular, String impressoraEtqColeta) {
        RetornoImpressaoEtiquetas retorno = new RetornoImpressaoEtiquetas();
        try {
            IServidor servidor = UtilJalis.pegaServidor(st, Integer.parseInt(codLabExterno), isColetaWeb, retorno);
            if (!Funcoes.textoVazio(configuracaoLabExterno) && servidor != null) {
                Registro registro = ConfiguradorProtocoloJalis.xmlToRegistro(configuracaoLabExterno);
                String etiquetas = servidor.getEtiquetas(registro.getString("filialSelecionada"), registro.getString("codigoConvenio"), numeroLote);
                String etq = StringUtil.xmlToTexto(StringUtil.getValor(etiquetas, "etiquetas"));
                if (!Funcoes.textoVazio(etq)) {
                    ImpressaoTermica termica = new ImpressaoTermica(impressoraEtqColeta, isColetaWeb);
                    ArrayList<byte[]> etqs = new ArrayList<byte[]>();
                    etqs.add(termica.imprimirDireto(etq, true, st, isColetaWeb, arquivar, anular));
                    HashMap<String, List<byte[]>> mapEtq = new HashMap<String, List<byte[]>>();
                    mapEtq.put("Jalis", etqs);
                    retorno.setEtiquetasLabExterno(mapEtq);
                } else {
                    String texto = "N\u00e3o h\u00e1 etiquetas para impress\u00e3o";
                    if (isColetaWeb) {
                        UtilExportadores.adicionarMensagemRetorno(texto, "Jalis", retorno);
                    } else {
                        Funcoes.mensagem(Laboratorio.getInstancia(), texto, 2);
                    }
                }
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), ex.getMessage(), ex.getStackTrace(), "ReimprimirRelatorioEtiquetaJalis (40)");
        }
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reimprimirRelatorio(String codLabExterno, String numeroLote, String codigoConvenio, String configuracaoLabExterno) {
        Statement st;
        block4: {
            st = Conexao.getStatement();
            try {
                IServidor servidor = UtilJalis.pegaServidor(st, Integer.parseInt(codLabExterno), false, null);
                String xml = UtilExportadores.getXMLConfiguracaoProtocolo(st, Integer.parseInt(codLabExterno));
                if (Funcoes.textoVazio(xml) || servidor == null) break block4;
                Registro registro = ConfiguradorProtocoloJalis.xmlToRegistro(xml);
                String modelo = servidor.getModeloRelatorio();
                UtilJalis.imprimirRelatorio(st, StringUtil.xmlToTexto(modelo), numeroLote, registro.getString("filialSelecionada"), registro.getString("codigoConvenio"), codLabExterno);
            }
            catch (Exception ex) {
                try {
                    ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), ex.getMessage(), ex.getStackTrace(), "ReimprimirRelatorioEtiquetaJalis (61)");
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
    }

    @Override
    public RetornoImpressaoEtiquetas reimprimirEtiquetas(String codLabExterno, String numeroLote, String codigoConvenio, String configuracaoLabExterno, String exames, String materiais, Statement st, int digitosTuboFilial, int digitosTuboRequisicao, boolean isColetaWeb, Callable<Boolean> arquivar, Callable<Boolean> anular, String impressoraEtqColeta) {
        return null;
    }

    @Override
    public RetornoImpressaoEtiquetas reimprimirEtiquetas(String codigoRequisicao, String codigoFilial, List<Registro> exames, Statement st, Statement st2, Statement st3, Statement st4, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, boolean isColetaWeb, Callable<Boolean> arquivar, Callable<Boolean> anular, String impressoraEtqColeta, int agruparInterface, boolean agruparGuiasInterface, String login, ImpressorasLabExterno impressoras, String imprimirEtqTriagemSemMaterial, boolean imprimirEtqColetaSemMaterial, boolean imprimirEtqColetaSelecionadaSemMaterial, boolean agruparEtqPorQtde, String tipoExportacaoInterface, int codigoLayout, String tamanhoNomeImpressoras, String[] impressorasLocais, String cabecalhoEtq, int exportacaoInterface, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario, String tipoIntegracao, String tipoEtqSoroteca, int casasPrecoExame, RoundingMode arredondamentoPrecoExame, Protocolo protocolo, String respostaColetaWeb) {
        return null;
    }
}

