/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.externo.exportadores;

import jalis.util.StringUtil;

public class ProcessaErroRetornoWebServiceLabExterno {
    private static final String RegistroRejeitado = "RegistroRejeitado";
    private static final String Erro = "Erro";
    private static final String Descricao = "Descricao";
    protected String xmlErro;
    protected String xmlDetalhe;
    protected String xmlRetorno;
    protected boolean registroRejeitado = false;

    public ProcessaErroRetornoWebServiceLabExterno(String erro, String detalhe) {
        this.xmlErro = erro;
        this.xmlRetorno = detalhe;
        this.xmlDetalhe = detalhe;
    }

    public ProcessaErroRetornoWebServiceLabExterno(String erro, StackTraceElement[] error) {
        this.xmlErro = erro;
        this.getStackTrace(error);
    }

    public ProcessaErroRetornoWebServiceLabExterno(String xmlRetorno) {
        this.xmlRetorno = xmlRetorno;
        this.xmlDetalhe = xmlRetorno;
        this.processa();
    }

    private void processa() {
        if (this.xmlRetorno.indexOf(RegistroRejeitado) > -1) {
            String registroRejeitado;
            String erro;
            this.registroRejeitado = true;
            if (this.xmlRetorno.indexOf(Erro) > -1 && (erro = StringUtil.getValor((registroRejeitado = StringUtil.getValor(this.xmlRetorno.toString(), RegistroRejeitado)).toString(), Erro)).indexOf(Descricao) > -1) {
                String descricao = StringUtil.getValor(erro.toString(), Descricao);
                String[] descricaoSplit = descricao.split("\\:");
                this.xmlErro = descricaoSplit[descricaoSplit.length - 1].replaceAll("\\]", "").replaceAll("\\>", "").trim();
            }
        }
    }

    private void getStackTrace(StackTraceElement[] error) {
        if (error != null) {
            for (StackTraceElement e : error) {
                this.xmlDetalhe = this.xmlDetalhe + e.getClassName();
                this.xmlDetalhe = this.xmlDetalhe + "(";
                this.xmlDetalhe = this.xmlDetalhe + e.getLineNumber();
                this.xmlDetalhe = this.xmlDetalhe + ")\n";
            }
        }
    }

    public String getXmlDetalhe() {
        return this.xmlDetalhe;
    }

    public String getXmlErro() {
        return this.xmlErro;
    }

    public boolean getRegistroRejeitado() {
        return this.registroRejeitado;
    }
}

