/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.externo.exportadores;

import br.com.shift.www.WSApoioSoapProxy;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.cadastro.InterfaceDesmembrar;
import jalis.laboratorio.triagem.externo.CriaLoteExportacao;
import jalis.laboratorio.triagem.externo.DadosAdicionais;
import jalis.laboratorio.triagem.externo.DadosAdicionaisWeb;
import jalis.laboratorio.triagem.externo.Exportador;
import jalis.laboratorio.triagem.externo.FabricaExportador;
import jalis.laboratorio.triagem.externo.LaboratorioExterno;
import jalis.laboratorio.triagem.externo.RetornoCriarLote;
import jalis.laboratorio.triagem.externo.RetornoEstornarLote;
import jalis.laboratorio.triagem.externo.exportadores.InfoComplementar;
import jalis.laboratorio.triagem.externo.exportadores.UtilExportadores;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.laboratorio.util.impressao.ImprimirEtiquetasColetaTriagem;
import jalis.laboratorio.util.impressao.RetornoImpressaoEtiquetas;
import jalis.laboratorio.util.impressao.exame.externo.saoMarcos.ConexaoSaoMarcos;
import jalis.laboratorio.util.impressao.labexterno.ImpressorasLabExterno;
import jalis.laboratorio.util.impressao.sql.ValorIn;
import jalis.laboratorio.util.parsers.IntegracaoLabExternoUtil;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.laboratorio.util.parsers.maricondi.TagsConfiguradorProtocoloMaricondi;
import jalis.model.utils.ThreadDaoException;
import jalis.service.triagem.LoteExternoExameRequisicaoService;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.sql.ConstrutorInsert;
import jalis.util.tabela.Registro;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.swing.JFileChooser;
import javax.swing.JPanel;

public abstract class IntegracaoLabExterno
extends JPanel {
    public static final String TABELA_LOTEEXTERNO = "loteexterno";
    public static final String TABELA_LOTEEXTERNOEXAMEREQUISICAODESM = "loteexternoexamerequisicaodesm";
    public static final String TABELA_LOTEEXTERNOEXAMEREQUISICAORECIP = "loteexternoexamerequisicaorecip";
    public static final String TABELA_LOTEEXTERNOEXAMEREQUISICAO = "loteexternoexamerequisicao";
    public static final String TABELA_LOTEEXTERNOREQUISICAO = "loteexternorequisicao";
    public static final String MCO_KODIGO = "mco_kodigo";
    public static final String EXA_KODIGO = "exa_kodigo";
    public static final String REC_CODIGO = "rec_codigo";
    public static final String FIL_KODIGO = "fil_kodigo";
    public static final String USR_CODCRIACAO = "usr_codcriacao";
    public static final String LEX_DATAHORA = "lex_datahora";
    public static final String LEX_CODIGO = "lex_codigo";
    public static final String REQ_ALTURA = "req_altura";
    public static final String REQ_PESO = "req_peso";
    public static final String REQ_OBS = "req_obs";
    public static final String REQ_DUM = "req_dum";
    public static final String REQ_HORA = "req_hora";
    public static final String REQ_DATA = "req_data";
    public static final String REQ_IDADE = "req_idade";
    public static final String REQ_CODIGO = "req_codigo";
    public static final String REQ_DATANASC = "req_datanasc";
    public static final String EXR_VOLUMEDIURESE = "exr_volumediurese";
    public static final String EXR_TEMPODIURESE = "exr_tempodiurese";
    public static final String EXR_CODIGOAPOIADO = "exr_codigoapoiado";
    public static final String EXR_DATAMATERIAL = "exr_datamaterial";
    public static final String EXR_DESCRICAOMATERIAL = "exr_descricaomaterial";
    public static final String MCO_CODIGO = "mco_codigo";
    public static final String EXA_CODIGO = "exa_codigo";
    public static final String PAC_DATANASC = "pac_datanasc";
    public static final String PAC_SEXO = "pac_sexo";
    public static final String PAC_NOME = "pac_nome";
    public static final String PAC_CODIGO = "pac_codigo";
    public static final String FIL_CODIGO = "fil_codigo";
    public static final String CODIGO_MATERIAL = "codigoMaterial";
    public static final String CODIGO_EXAME = "codigoExame";
    public static final String PAC_DUM = "pac_dum";
    public static final String CON_CODIGO = "con_codigo";
    public static final String LAE_CODIGO = "lae_codigo";
    public static final String ELE_XML_LAB_EXTERNO = "ele_xmllabexterno";
    public static final String EXA_DESCRICAO = "exa_descricao";
    public static final String MCO_DESCRICAO = "mco_descricao";
    public static final String REC_KODIGO = "rec_kodigo";
    public static final int TIPO_COLETA = 1;
    public static final int TIPO_TRIAGEM = 2;
    public static final int TIPO_COLETA_SELECIONADA = 3;
    public static final int TIPO_TRIAGEM_SELECIONADA = 4;
    public static int tipoEtiq = 0;
    public boolean enviarUsandoWS = false;
    public boolean isEnviarRequisicaoWebService = false;
    public static HashMap<String, String> listaEstornados;
    private static ArrayList<InterfaceDesmembrar> examesDesm;

    public void setTipoEtiqueta(int tipoEtiqueta) {
        tipoEtiq = tipoEtiqueta;
    }

    public void setCondicaoExamesDesm(ArrayList<InterfaceDesmembrar> examesDesm) {
        IntegracaoLabExterno.examesDesm.clear();
        IntegracaoLabExterno.examesDesm.addAll(examesDesm);
    }

    public ArrayList<InterfaceDesmembrar> getCondicaoExamesDesm() {
        return examesDesm;
    }

    public static List<Registro> agruparMutiguia(List<Registro> listaRequisicoes, Statement st, boolean isAgruparGuiasInterface, int digitosTuboFilial) {
        ArrayList<Registro> requisicoesAgrupadas = new ArrayList<Registro>();
        if (listaRequisicoes != null) {
            LinkedHashMap listaRequisicoesPais = new LinkedHashMap();
            for (Registro req : listaRequisicoes) {
                ArrayList listaExames;
                Registro exa;
                boolean agruparMultiguia = IntegracaoLabExterno.possuiAgrupamentoMultiguia(req, exa = (Registro)(listaExames = (ArrayList)req.getValor("listaexames")).get(0), st, isAgruparGuiasInterface);
                if (!agruparMultiguia) {
                    req.setValor("req_codigomae", req.getValor(REQ_CODIGO));
                }
                Object filial = req.getString(FIL_CODIGO);
                if (listaRequisicoesPais.containsKey((String)(filial = Funcoes.preencheZero((String)filial, digitosTuboFilial)) + req.getString("req_codigomae"))) {
                    ((ArrayList)listaRequisicoesPais.get((String)filial + req.getString("req_codigomae"))).add(req);
                    continue;
                }
                ArrayList<Registro> nova = new ArrayList<Registro>();
                nova.add(req);
                listaRequisicoesPais.put((String)filial + req.getString("req_codigomae"), nova);
            }
            for (String key : listaRequisicoesPais.keySet()) {
                ArrayList reqFilhas = (ArrayList)listaRequisicoesPais.get(key);
                Registro pai = null;
                int digtosFilial = digitosTuboFilial;
                key = key.substring(digtosFilial);
                for (Registro filha : reqFilhas) {
                    if (!filha.contemValor(REQ_CODIGO, key) || !filha.contemValor("req_codigomae", key)) continue;
                    pai = filha;
                }
                ArrayList<Registro> novaLista = new ArrayList<Registro>();
                ArrayList<String> chaves = new ArrayList<String>();
                for (Registro filha : reqFilhas) {
                    if (pai == null) {
                        pai = filha;
                        pai.setValor(REQ_CODIGO, IntegracaoLabExterno.getReqCodigoPai(filha.getString(FIL_CODIGO), filha.getString(REQ_CODIGO), st));
                    }
                    if (!pai.getString(REQ_CODIGO).equalsIgnoreCase(filha.getString("req_codigomae"))) {
                        filha.setValor("req_codigomae", pai.getString(REQ_CODIGO));
                    }
                    List exames = (List)filha.getValor("listaexames");
                    for (Registro exaFilha : exames) {
                        String chave = exaFilha.getString(EXA_CODIGO) + exaFilha.getString(MCO_CODIGO);
                        ArrayList<Registro> novaListaDesm = new ArrayList<Registro>();
                        List desm = (List)exaFilha.getValor("listaexames");
                        if (desm != null && !desm.isEmpty()) {
                            for (Registro exaDesm : desm) {
                                chave = exaDesm.getString(EXA_CODIGO) + exaDesm.getString(MCO_CODIGO);
                                if (!chaves.contains(chave)) {
                                    novaListaDesm.add(exaDesm.clone());
                                    chaves.add(chave);
                                }
                                IntegracaoLabExterno.agrupaDadosSolicitante(novaLista, exaDesm);
                            }
                            if (!novaListaDesm.isEmpty()) {
                                exaFilha.substituirValor("listaexames", novaListaDesm);
                            }
                            if (chaves.contains(chave = exaFilha.getString(EXA_CODIGO) + exaFilha.getString(MCO_CODIGO)) || novaListaDesm.isEmpty()) continue;
                            novaLista.add(exaFilha.clone());
                            chaves.add(chave);
                            continue;
                        }
                        if (!chaves.contains(chave)) {
                            novaLista.add(exaFilha.clone());
                            chaves.add(chave);
                        }
                        IntegracaoLabExterno.agrupaDadosSolicitante(novaLista, exaFilha);
                    }
                }
                pai.substituirValor("listaexames", novaLista);
                requisicoesAgrupadas.add(pai);
            }
        }
        return requisicoesAgrupadas;
    }

    public static void gravaSolicitanteExame(List<Registro> requisicoes) {
        for (Registro req : requisicoes) {
            ArrayList<Registro> medicos = new ArrayList<Registro>();
            List listaExames = (List)req.getValor("listaexames");
            Registro medico = new Registro();
            medico.setValor(FIL_CODIGO, req.getString(FIL_CODIGO));
            medico.setValor("requisicao", req.getString(REQ_CODIGO));
            medico.setValor("medicoCRM", req.getString("med_crm"));
            medico.setValor("ufMedico", req.getString("med_uf"));
            medico.setValor("conselhoMedico", req.getString("med_conselho"));
            medico.setValor("nomeMedico", req.getString("med_nome"));
            medicos.add(medico);
            for (Registro exa : listaExames) {
                exa.setValor("solicitantes", medicos);
                List listaExamesDesmembrados = (List)exa.getValor("listaexames");
                if (Funcoes.objectIsNull(listaExamesDesmembrados) || listaExamesDesmembrados.size() <= 0) continue;
                for (Registro desm : listaExamesDesmembrados) {
                    desm.setValor("solicitantes", medicos);
                }
            }
        }
    }

    public static void agrupaDadosSolicitante(List<Registro> novaListaExames, Registro exame) {
        ArrayList<Registro> listSolicitantesFinal = new ArrayList<Registro>();
        for (Registro exa : novaListaExames) {
            String filCodigo = exa.getString(FIL_CODIGO);
            String exaCodigo = exa.getString(EXA_CODIGO);
            String mcoCodigo = exa.getString(MCO_CODIGO);
            ArrayList listaExames = (ArrayList)exa.getValor("listaexames");
            if (null == listaExames || listaExames.isEmpty()) continue;
            for (Registro registro : listaExames) {
                if (!exame.getString(FIL_CODIGO).equalsIgnoreCase(registro.getString(FIL_CODIGO)) || !exame.getString(EXA_CODIGO).equalsIgnoreCase(registro.getString(EXA_CODIGO)) || !exame.getString(MCO_CODIGO).equalsIgnoreCase(registro.getString(MCO_CODIGO))) continue;
                ArrayList listSolicitantesExames = (ArrayList)registro.getValor("solicitantes");
                ArrayList solicitantes = (ArrayList)exame.getValor("solicitantes");
                if (!Funcoes.objectIsNull(listSolicitantesExames) && !Funcoes.objectIsNull(solicitantes)) {
                    for (Registro solicitante : listSolicitantesExames) {
                        listSolicitantesFinal.add(solicitante);
                        Registro solicitanteAux = (Registro)solicitantes.get(0);
                        if (solicitante.getString("medicoCRM").equalsIgnoreCase(solicitanteAux.getString("medicoCRM")) && solicitante.getString("ufMedico").equalsIgnoreCase(solicitanteAux.getString("ufMedico")) && solicitante.getString("conselhoMedico").equalsIgnoreCase(solicitanteAux.getString("conselhoMedico")) || IntegracaoLabExterno.medicoJaAdicionado(listSolicitantesFinal, solicitanteAux)) continue;
                        listSolicitantesFinal.add((Registro)solicitantes.get(0));
                    }
                }
                registro.setValor("solicitantes", listSolicitantesFinal);
                break;
            }
            if (!filCodigo.equalsIgnoreCase(exame.getString(FIL_CODIGO)) || !exaCodigo.equalsIgnoreCase(exame.getString(EXA_CODIGO)) || !mcoCodigo.equalsIgnoreCase(exame.getString(MCO_CODIGO))) continue;
            ArrayList listSolicitantesExames = (ArrayList)exa.getValor("solicitantes");
            ArrayList solicitantes = (ArrayList)exame.getValor("solicitantes");
            if (!Funcoes.objectIsNull(listSolicitantesExames) && !Funcoes.objectIsNull(solicitantes)) {
                for (Registro solicitante : listSolicitantesExames) {
                    listSolicitantesFinal.add(solicitante);
                    Registro solicitanteAux = (Registro)solicitantes.get(0);
                    if (solicitante.getString("medicoCRM").equalsIgnoreCase(solicitanteAux.getString("medicoCRM")) && solicitante.getString("ufMedico").equalsIgnoreCase(solicitanteAux.getString("ufMedico")) && solicitante.getString("conselhoMedico").equalsIgnoreCase(solicitanteAux.getString("conselhoMedico")) || IntegracaoLabExterno.medicoJaAdicionado(listSolicitantesFinal, solicitanteAux)) continue;
                    listSolicitantesFinal.add((Registro)solicitantes.get(0));
                }
            }
            exa.setValor("solicitantes", listSolicitantesFinal);
        }
    }

    private static boolean medicoJaAdicionado(List<Registro> listSolicitantesFinal, Registro solicitanteAux) {
        for (Registro medico : listSolicitantesFinal) {
            if (!medico.getString("medicoCRM").equalsIgnoreCase(solicitanteAux.getString("medicoCRM")) || !medico.getString("ufMedico").equalsIgnoreCase(solicitanteAux.getString("ufMedico")) || !medico.getString("conselhoMedico").equalsIgnoreCase(solicitanteAux.getString("conselhoMedico"))) continue;
            return true;
        }
        return false;
    }

    private static int getReqCodigoPai(String filial, String requisicao, Statement st) {
        String multiguiaPrincipal = requisicao;
        Integer[] multiguia = null;
        try {
            multiguia = RecepcaoUtil.verificaMultiGuias(st, filial, requisicao, true, false);
            StringBuilder multiguias = new StringBuilder("");
            for (Integer i : multiguia) {
                if (i < Integer.parseInt(multiguiaPrincipal)) {
                    multiguiaPrincipal = String.valueOf(i);
                }
                if (multiguias.length() > 0) {
                    multiguias.append(", ");
                }
                multiguias.append(String.valueOf(i));
            }
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
        }
        return Integer.valueOf(multiguiaPrincipal);
    }

    public static boolean possuiAgrupamentoMultiguia(Registro req, Registro exa, Statement st, boolean agruparGuiasInterface) {
        boolean multiguia = false;
        try {
            multiguia = agruparGuiasInterface || DBUtil.requisicaoAgrupaMultiguiasLabExterno(st, req.getString(FIL_CODIGO), req.getString(REQ_CODIGO), ValorIn.criar(new String[]{exa.getString(EXA_CODIGO)}).toString(), exa.getString(MCO_CODIGO), req.getString(LAE_CODIGO));
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
        }
        return multiguia;
    }

    protected void criarEtiquetas(boolean isColetaWeb, List<Registro> requisicoes, int agruparInterface, Statement st, Statement st2, Statement st3, String variaveisLogin, boolean agruparGuiasInterface, String imprimirEtiquetaTriagemSemMaterial, boolean imprimirEtiquetaColetaSemMaterial, boolean imprimirEtiquetaColetaSelecionadaSemMaterial, boolean agruparEtqPorQtde, String tipoExportacaoInterface, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario, Callable<Boolean> arquivar) throws Exception {
        for (Registro registro : requisicoes) {
            IntegracaoLabExterno.criarEtiquetaRequisicao(isColetaWeb, registro, agruparInterface, st, st2, st3, variaveisLogin, agruparGuiasInterface, imprimirEtiquetaTriagemSemMaterial, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, agruparEtqPorQtde, tipoExportacaoInterface, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, tuboPrimario, utilizarCapacidadeTuboPrimario, arquivar);
        }
    }

    public static List<Registro> carregaExamesEtiquetas(Registro requisicao, Statement st) {
        StringBuilder buf = new StringBuilder();
        buf.append("select exa_codigo, mco_codigo from examerequisicao ");
        buf.append(" where fil_codigo = ").append(requisicao.getString(FIL_CODIGO));
        buf.append("   and req_codigo = ").append(requisicao.getString(REQ_CODIGO));
        buf.append("   and not exr_excluido ");
        buf.append("   and exr_situacao  <> '").append("F").append("'");
        buf.append("   and exr_situacao  <> '").append("A").append("'");
        buf.append("   and exr_situacao  <> '").append("C").append("'");
        buf.append("   and exr_situacao  <> '").append("I").append("'");
        buf.append("   and exr_situacao  <> '").append("L").append("'");
        buf.append("   and exr_situacao  <> '").append("E").append("'");
        ResultSet rs = null;
        try {
            rs = st.executeQuery(buf.toString());
            ArrayList<Registro> lista = new ArrayList<Registro>();
            while (rs.next()) {
                lista.add(new Registro(rs));
            }
            rs.close();
            return lista;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected static void criarEtiquetaRequisicao(boolean isColetaWeb, Registro requisicao, int agruparInterface, Statement st, Statement st2, Statement st3, String variaveisLogin, boolean agruparGuiasInterface, String imprimirEtiquetaTriagemSemMaterial, boolean imprimirEtiquetaColetaSemMaterial, boolean imprimirEtiquetaColetaSelecionadaSemMaterial, boolean agruparEtqPorQtde, String tipoExportacaoInterface, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario, Callable<Boolean> arquivar) throws Exception {
        ArrayList listaExames = (ArrayList)requisicao.getValor("listaexames");
        ArrayList<String> listExa = new ArrayList<String>();
        int[] arrayMat = new int[listaExames.size()];
        for (Registro exa : listaExames) {
            listExa.add(exa.getString(EXA_CODIGO));
            arrayMat[listExa.size() - 1] = exa.getInt(MCO_CODIGO);
        }
        if (tipoEtiq == 0) {
            tipoEtiq = agruparInterface == 1 ? 2 : 1;
        }
        String[] arrayExa = (String[])Arrays.copyOf(listExa.toArray(), listExa.toArray().length, String[].class);
        ImprimirEtiquetasColetaTriagem.criaEtiqueta(isColetaWeb, requisicao.getString(FIL_CODIGO), requisicao.getString(REQ_CODIGO), arrayExa, arrayMat, true, "R", st, st2, st3, variaveisLogin, tipoEtiq, true, null, null, true, true, requisicao.getString("codigoLabExterno"), false, agruparGuiasInterface, imprimirEtiquetaTriagemSemMaterial, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, agruparEtqPorQtde, tipoExportacaoInterface, agruparInterface, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, tuboPrimario, utilizarCapacidadeTuboPrimario);
        arquivar.call();
    }

    protected static void criarRecipienteRequisicao(Registro requisicao, boolean isColetaWeb, Statement st, Statement st2, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, Callable<Boolean> arquivar, int agruparInterface, boolean agruparGuiasInterface) throws Exception {
        if (tipoEtiq == 0) {
            tipoEtiq = agruparInterface == 1 ? 2 : 1;
        }
        ImprimirEtiquetasColetaTriagem.criaRecipiente(isColetaWeb, requisicao.getString(FIL_CODIGO), requisicao.getString(REQ_CODIGO), tipoEtiq, true, true, st, st2, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, agruparInterface, agruparGuiasInterface);
        arquivar.call();
    }

    public static void carregarExamesDesmembrados(Registro requisicao, LaboratorioExterno labSelecionado, Statement st) throws Exception {
        try {
            HashSet<String> chaves = new HashSet<String>();
            ArrayList<Registro> desmembrados = new ArrayList<Registro>();
            List exames = (List)requisicao.getValor("listaexames");
            for (Registro exa : exames) {
                List<Registro> desm = IntegracaoLabExterno.getExamesDesmembrados(requisicao.getString(FIL_CODIGO), exa, labSelecionado.codigoLab, chaves, st);
                exa.setValor("listaexames", desm);
                if (desm != null && !desm.isEmpty()) {
                    desmembrados.addAll(desm);
                    continue;
                }
                if (labSelecionado.protocolo == Protocolo.SaoMarcos) continue;
                String chave = exa.getString(EXA_CODIGO) + exa.getString(MCO_CODIGO);
                if (!chaves.contains(chave)) {
                    desmembrados.add(exa);
                }
                chaves.add(chave);
            }
        }
        catch (Exception e) {
            throw new ThreadDaoException(e.getMessage());
        }
    }

    public static void carregarDesmembrados(Registro requisicao, LaboratorioExterno labSelecionado, Statement st) throws Exception {
        try {
            HashSet<String> chaves = new HashSet<String>();
            ArrayList<Registro> desmembrados = new ArrayList<Registro>();
            List exames = (List)requisicao.getValor("listaexames");
            ArrayList<Integer> listaKey = new ArrayList<Integer>();
            for (int i = 0; i < exames.size(); ++i) {
                List<Registro> desm = IntegracaoLabExterno.getExamesDesmembrados(requisicao.getString(FIL_CODIGO), (Registro)exames.get(i), labSelecionado.codigoLab, chaves, st);
                if (desm == null || desm.isEmpty()) continue;
                desmembrados.addAll(desm);
                listaKey.add(i);
            }
            Iterator iterator = listaKey.iterator();
            while (iterator.hasNext()) {
                int key = (Integer)iterator.next();
                exames.remove(key);
            }
            exames.addAll(desmembrados);
        }
        catch (Exception e) {
            throw new ThreadDaoException(e.getMessage());
        }
    }

    public static List<Registro> getExamesDesmembrados(String filial, Registro pai, String labexterno, Set<String> chaves, Statement st) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append("select e.exa_descricao, a.exa_codigo, a.mco_codigo, a.exa_kodigo, a.mco_kodigo, '' as dadosadicionais, 0 as exr_volumediurese, b.ele_xmllabexterno as ele_xmllabexterno ");
        sql.append("  from examematcoletalabextdesm a ");
        sql.append("  left join examematcoletalabexterno b on a.fil_codigo = b.fil_codigo and b.exa_codigo = a.exa_kodigo and b.mco_codigo = a.mco_kodigo and a.lae_codigo = b.lae_codigo ");
        sql.append(" left join exames e on a.fil_codigo = e.fil_codigo and a.exa_kodigo = e.exa_codigo ");
        sql.append(" where a.fil_codigo = ").append(filial);
        sql.append("   and a.exa_codigo = '").append(pai.getString(EXA_CODIGO)).append("'");
        sql.append("   and a.mco_codigo = ").append(pai.getString(MCO_CODIGO));
        sql.append("   and a.lae_codigo = ").append(labexterno);
        ArrayList<Registro> desmembrados = new ArrayList<Registro>();
        ResultSet rs = st.executeQuery(sql.toString());
        while (rs.next()) {
            Registro registro = pai.clone();
            registro.setValor(EXA_DESCRICAO, rs.getString(EXA_DESCRICAO));
            registro.setValor(EXA_CODIGO, rs.getString(EXA_KODIGO));
            registro.setValor(MCO_CODIGO, rs.getString(MCO_KODIGO));
            registro.setValor(EXA_KODIGO, rs.getString(EXA_CODIGO));
            registro.setValor(MCO_KODIGO, rs.getString(MCO_CODIGO));
            registro.setValor(ELE_XML_LAB_EXTERNO, rs.getString(ELE_XML_LAB_EXTERNO));
            String chave = rs.getString(EXA_KODIGO) + rs.getString(MCO_KODIGO);
            desmembrados.add(registro);
            chaves.add(chave);
        }
        return desmembrados;
    }

    public RetornoImpressaoEtiquetas criarLote(List<Registro> listaRequisicoes, boolean isColetaWeb, int agruparInterface, Statement st, Statement st2, Statement st3, String variaveisLogin, boolean agruparGuiasInterface, String imprimirEtiquetaTriagemSemMaterial, boolean imprimirEtiquetaColetaSemMaterial, boolean imprimirEtiquetaColetaSelecionadaSemMaterial, boolean agruparEtqPorQtde, String tipoExportacaoInterface, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario, String tipoIntegracao, String tamanhoNomeImpressora, String[] impressorasLocais, ImpressorasLabExterno impressoras, RetornoImpressaoEtiquetas retorno, String tipoEtiquetaSoroteca, Callable<Boolean> arquivar, Callable<Boolean> anular, Map<String, List<InfoComplementar>> mapInfoComplementar) {
        return this.criarLote(listaRequisicoes, false, isColetaWeb, agruparInterface, st, st2, st3, variaveisLogin, agruparGuiasInterface, imprimirEtiquetaTriagemSemMaterial, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, agruparEtqPorQtde, tipoExportacaoInterface, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, tuboPrimario, utilizarCapacidadeTuboPrimario, tipoIntegracao, tamanhoNomeImpressora, impressorasLocais, impressoras, retorno, tipoEtiquetaSoroteca, arquivar, anular, mapInfoComplementar);
    }

    public RetornoImpressaoEtiquetas criarLote(List<Registro> listaRequisicoes, boolean etiquetaSelecionada, boolean isColetaWeb, int agruparInterface, Statement st, Statement st2, Statement st3, String variaveisLogin, boolean agruparGuiasInterface, String imprimirEtiquetaTriagemSemMaterial, boolean imprimirEtiquetaColetaSemMaterial, boolean imprimirEtiquetaColetaSelecionadaSemMaterial, boolean agruparEtqPorQtde, String tipoExportacaoInterface, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario, String tipoIntegracao, String tamanhoNomeImpressora, String[] impressorasLocais, ImpressorasLabExterno impressoras, RetornoImpressaoEtiquetas retorno, String tipoEtiquetaSoroteca, Callable<Boolean> arquivar, Callable<Boolean> anular, Map<String, List<InfoComplementar>> mapInfoComplementar) {
        if (listaRequisicoes == null || listaRequisicoes.isEmpty()) {
            retorno.setCodigoLote(-1);
            return retorno;
        }
        boolean pararProcesso = false;
        ArrayList<Object> novaLista = new ArrayList<Object>();
        ArrayList<Registro> novaListaExame = new ArrayList<Registro>();
        Registro exame = new Registro();
        ArrayList listaExames = new ArrayList();
        for (Registro regRequisicoes : listaRequisicoes) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            if (etiquetaSelecionada) {
                List listaExame = (List)regRequisicoes.getValor("listaexames");
                if (listaExame != null) {
                    for (int i = 0; i < listaExame.size(); ++i) {
                        exame = (Registro)listaExame.get(i);
                        String labExterno = exame.getString(LAE_CODIGO);
                        if (Funcoes.textoVazio(labExterno)) continue;
                        if (!hashMap.containsKey(labExterno)) {
                            ListaRegistro lista = new ListaRegistro();
                            ((ArrayList)lista).add(exame);
                            hashMap.put(labExterno, lista);
                        } else {
                            ((ArrayList)hashMap.get(labExterno)).add(exame);
                        }
                        for (String key : hashMap.keySet()) {
                            Registro req = (Registro)listaExame.get(i);
                            req.setValor(LAE_CODIGO, key);
                            req.substituirValor("listaexames", hashMap.get(key));
                            novaListaExame.add(req);
                        }
                    }
                }
                Registro requisicao = regRequisicoes.clone();
                requisicao.setValor("listaexames", novaListaExame);
                novaLista.add(requisicao);
                continue;
            }
            listaExames = (ArrayList)regRequisicoes.getValor("listaexames");
            for (int i = 0; i < listaExames.size(); ++i) {
                String labExterno = ((Registro)listaExames.get(i)).getString(LAE_CODIGO);
                if (Funcoes.textoVazio(labExterno)) continue;
                if (!hashMap.containsKey(labExterno)) {
                    ListaRegistro lista = new ListaRegistro();
                    ((ArrayList)lista).add(listaExames.get(i));
                    hashMap.put(labExterno, lista);
                    continue;
                }
                ((ArrayList)hashMap.get(labExterno)).add(listaExames.get(i));
            }
            for (String key : hashMap.keySet()) {
                Registro req = regRequisicoes.clone();
                req.setValor(LAE_CODIGO, key);
                req.substituirValor("listaexames", hashMap.get(key));
                novaLista.add(req);
            }
        }
        HashMap mapReq = new HashMap();
        for (Registro registro : novaLista) {
            String codigoLabExterno = registro.getString(LAE_CODIGO);
            if (mapReq.containsKey(codigoLabExterno)) {
                ((ArrayList)mapReq.get(codigoLabExterno)).add(registro);
                continue;
            }
            ArrayList<Registro> lista = new ArrayList<Registro>();
            lista.add(registro);
            mapReq.put(codigoLabExterno, lista);
        }
        for (String string : mapReq.keySet()) {
            LaboratorioExterno labExterno = LaboratorioExterno.getLabExterno(string, st, false);
            if (!this.validarConfiguracao(labExterno.configuracao, true, labExterno, isColetaWeb)) {
                pararProcesso = true;
                break;
            }
            List listaReq = (List)mapReq.get(string);
            for (Registro registro : listaReq) {
                try {
                    IntegracaoLabExterno.carregarExamesDesmembrados(registro, labExterno, st);
                }
                catch (Exception e) {
                    ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel carregar exames desmembrados.\n" + e.getMessage(), e.getStackTrace());
                    break;
                }
                if (isColetaWeb) {
                    DadosAdicionaisWeb dadosAdicionaisWeb = FabricaExportador.novoDadosAdicionaisWeb(labExterno.protocolo);
                    if (dadosAdicionaisWeb == null || dadosAdicionaisWeb.carregaAdicionaisWeb(labExterno.codigoLab, registro, mapInfoComplementar, st2)) continue;
                    pararProcesso = true;
                    break;
                }
                DadosAdicionais dadosAdicionais = FabricaExportador.novoDadosAdicionais(labExterno.protocolo);
                if (dadosAdicionais == null || dadosAdicionais.carregaAdicionais(labExterno.codigoLab, registro)) continue;
                pararProcesso = true;
                break;
            }
            if (pararProcesso) {
                retorno.setFaltaDadosAdicionais(pararProcesso);
                retorno.setCodigoLote(-1);
                return retorno;
            }
            String configuracaoOriginal = labExterno.configuracao;
            labExterno.configuracao = CriaLoteExportacao.atualizaConfiguracao(labExterno.codigoLab, st);
            Exportador exp = FabricaExportador.novoExportador(labExterno.protocolo);
            try {
                ArrayList<Registro> requisicoes;
                int novoLote = Integer.valueOf(this.retornaCodigoLote(labExterno.codigoLab, st));
                String codigoConvenio = StringUtil.getValor(labExterno.configuracao, "codigoConvenio");
                String adicionalLote = StringUtil.getValor(labExterno.configuracao, "adicionalLote");
                boolean naoEnviarObsRequisicao = StringUtil.getValor(labExterno.configuracao, "naoEnviarObsRequisicao").equalsIgnoreCase("true");
                int maiorLote = exp.getMaiorCodigoLote(String.valueOf(novoLote), codigoConvenio, labExterno, st);
                if (novoLote < maiorLote) {
                    novoLote = maiorLote;
                }
                String tagParamRelacionamento = "paramrelacionamento";
                String paramRelacionamento = StringUtil.getValor(configuracaoOriginal, tagParamRelacionamento);
                String xmlConfiguracao = IntegracaoLabExternoUtil.atualizaNumeroLote(labExterno.configuracao, novoLote);
                if (!Funcoes.textoVazio(paramRelacionamento) && Funcoes.textoVazio(StringUtil.getValor(xmlConfiguracao, tagParamRelacionamento))) {
                    xmlConfiguracao = xmlConfiguracao + "\n<" + tagParamRelacionamento + ">";
                    xmlConfiguracao = xmlConfiguracao + paramRelacionamento;
                    xmlConfiguracao = xmlConfiguracao + "</" + tagParamRelacionamento + ">";
                }
                if ((requisicoes = this.gravarLote(novoLote, labExterno, (List)mapReq.get(string), st, isColetaWeb, agruparGuiasInterface)) == null) {
                    anular.call();
                    retorno.setCodigoLote(-1);
                    return retorno;
                }
                int pos = 0;
                for (Registro registro : requisicoes) {
                    registro.setValor(registro.getString(REQ_CODIGO), pos);
                    registro.setValor("codigoLabExterno", labExterno.codigoLab);
                    ++pos;
                }
                retorno = exp.exportarExames(labExterno.codigoLab, String.valueOf(novoLote), labExterno.configuracao, false, requisicoes, 0, isColetaWeb, agruparInterface, st, st2, st3, variaveisLogin, agruparGuiasInterface, imprimirEtiquetaTriagemSemMaterial, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, agruparEtqPorQtde, tipoExportacaoInterface, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, tuboPrimario, utilizarCapacidadeTuboPrimario, tipoIntegracao, tamanhoNomeImpressora, impressorasLocais, impressoras, tipoEtiquetaSoroteca, arquivar, anular, labExterno, labExterno.agruparMultiguias);
                if (retorno.isImprimiu()) {
                    arquivar.call();
                    labExterno.salvarConfiguracao(st, isColetaWeb);
                    arquivar.call();
                    retorno.setCodigoLote(novoLote);
                    return retorno;
                }
                labExterno.configuracao = configuracaoOriginal;
                anular.call();
            }
            catch (Exception e) {
                labExterno.configuracao = configuracaoOriginal;
                try {
                    anular.call();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        }
        retorno.setCodigoLote(-1);
        return retorno;
    }

    public Registro getExameSelecionado(String requisicao, String[] exameSelecionado, List<Registro> listaRequisicoesDB) {
        Registro exame = null;
        Registro registro = new Registro();
        for (Registro reg : listaRequisicoesDB) {
            ArrayList listaExames = new ArrayList();
            listaExames = (ArrayList)reg.getValor("listaexames");
            registro = reg.clone();
            ArrayList<Registro> listaExame = new ArrayList<Registro>();
            for (int i = 0; i < listaExames.size(); ++i) {
                String exaCodigo = ((Registro)listaExames.get(i)).getString(EXA_CODIGO);
                String reqCodigo = reg.getString(REQ_CODIGO);
                for (int j = 0; j < exameSelecionado.length; ++j) {
                    if (!exaCodigo.equalsIgnoreCase(exameSelecionado[j]) || !reqCodigo.equalsIgnoreCase(requisicao)) continue;
                    exame = (Registro)listaExames.get(i);
                    listaExame.add(exame);
                }
            }
            registro.setValor("listaexames", listaExame);
        }
        return registro;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int descobriMetodoEnvioWebService(Registro registro, LaboratorioExterno labExterno, Statement st, boolean isAgruparGuiasInterface) throws Exception {
        boolean agruparMultiguia = IntegracaoLabExterno.agruparMultiguia(registro.getString(FIL_CODIGO), registro.getString(REQ_CODIGO), st, isAgruparGuiasInterface);
        StringBuilder sql = new StringBuilder();
        try (ResultSet resultSet = null;){
            ArrayList exames;
            sql.append(" select (case when (count(1) > 0) then 'POST' else 'PUT' end) as metodoEnvio from loteexternorequisicao ");
            sql.append("  where fil_kodigo = ").append(registro.getString(FIL_CODIGO));
            if (agruparMultiguia && !Funcoes.textoVazio(registro.getString("req_codigomae"))) {
                sql.append(" and req_codigo in (").append(registro.getString(REQ_CODIGO)).append(",").append(registro.getString("req_codigomae")).append(")");
            } else {
                sql.append(" and req_codigo in (").append(registro.getString(REQ_CODIGO)).append(")");
            }
            sql.append("    and lae_codigo = ").append(labExterno.codigoLab);
            sql.append("    and leq_retornows is not null ");
            resultSet = st.executeQuery(sql.toString());
            if (resultSet.next()) {
                registro.setValor("metodoEnvio", resultSet.getString("metodoEnvio"));
            }
            sql.setLength(0);
            resultSet.close();
            resultSet = null;
            sql.append("select lex_codigo as lote,  coalesce(length(leq_retornows),0) > 0 as retorno from loteexternorequisicao ");
            sql.append(" where fil_kodigo = ").append(registro.getString(FIL_CODIGO));
            sql.append(" and lae_codigo = ").append(labExterno.codigoLab);
            if (agruparMultiguia && !Funcoes.textoVazio(registro.getString("req_codigomae"))) {
                sql.append(" and req_codigo in (").append(registro.getString(REQ_CODIGO)).append(",").append(registro.getString("req_codigomae")).append(")");
            } else {
                sql.append(" and req_codigo in (").append(registro.getString(REQ_CODIGO)).append(")");
            }
            resultSet = st.executeQuery(sql.toString());
            if (resultSet.next()) {
                registro.setValor("temretornows", resultSet.getBoolean("retorno"));
                registro.setValor(LEX_CODIGO, resultSet.getInt("lote"));
            }
            if ((exames = (ArrayList)registro.getValor("listaexames")) != null && !exames.isEmpty()) {
                for (Registro exame : exames) {
                    sql = new StringBuilder();
                    resultSet = null;
                    sql.append(" select (case when (count(1) > 0) then 'false' else 'true' end) as exameNovo ");
                    sql.append(" from loteexternoexamerequisicao  where fil_kodigo = ").append(registro.getString(FIL_CODIGO));
                    sql.append(" and req_codigo = ").append(registro.getString(REQ_CODIGO));
                    sql.append(" and exa_codigo = '").append(exame.getString(EXA_CODIGO)).append("'");
                    sql.append(" and mco_codigo = ").append(exame.getString(MCO_CODIGO));
                    sql.append(" and lae_codigo = ").append(labExterno.codigoLab).append(";");
                    resultSet = st.executeQuery(sql.toString());
                    if (!resultSet.next()) continue;
                    exame.setValor("exameNovo", resultSet.getBoolean("exameNovo"));
                }
            }
        }
        return registro.getInt(LEX_CODIGO);
    }

    public ArrayList<Registro> gravarLote(int novoLote, LaboratorioExterno labExterno, List<Registro> listaRequisicoes, Statement st, boolean isColetaWeb, boolean isAgruparGuiasInterface) throws Exception {
        ArrayList<Registro> retorno = new ArrayList<Registro>();
        if (st != null) {
            ConstrutorInsert insert = new ConstrutorInsert(TABELA_LOTEEXTERNO);
            insert.addCampoValor(FIL_CODIGO, Variaveis.filialPadrao);
            insert.addCampoValor(LEX_CODIGO, novoLote);
            insert.addCampoValor(LAE_CODIGO, labExterno.codigoLab);
            insert.addCampoValor(LEX_DATAHORA, "current_timestamp");
            insert.addCampoValor(USR_CODCRIACAO, Variaveis.login, true);
            if (isColetaWeb) {
                st.executeUpdate(insert.getSQL());
            } else {
                Conexao.execute(Variaveis.filialPadrao, st, insert.getSQL());
            }
            for (Registro req : listaRequisicoes) {
                ArrayList listaExames = (ArrayList)req.getValor("listaexames");
                if (listaExames == null || listaExames.isEmpty()) continue;
                this.descobriMetodoEnvioWebService(req, labExterno, st, isAgruparGuiasInterface);
                retorno.add(req);
                insert.limpar(TABELA_LOTEEXTERNOREQUISICAO);
                insert.addCampoValor(FIL_CODIGO, Variaveis.filialPadrao);
                insert.addCampoValor(FIL_KODIGO, req.getString(FIL_CODIGO));
                insert.addCampoValor(LEX_CODIGO, novoLote);
                insert.addCampoValor(REQ_CODIGO, req.getString(REQ_CODIGO));
                insert.addCampoValor(LAE_CODIGO, req.getString(LAE_CODIGO));
                req.setValor("novoLote", novoLote);
                if (req.nulo(LEX_CODIGO)) {
                    req.setValor(LEX_CODIGO, novoLote);
                }
                if (isColetaWeb) {
                    st.executeUpdate(insert.getSQL());
                } else {
                    Conexao.execute(Variaveis.filialPadrao, st, insert.getSQL());
                }
                HashSet<String> chaves = new HashSet<String>();
                for (Registro exa : listaExames) {
                    List desmembrados;
                    String[] valores;
                    String externo = exa.getString(LAE_CODIGO);
                    String chave = exa.getString(EXA_CODIGO) + exa.getString(MCO_CODIGO);
                    exa.setValor(FIL_CODIGO, req.getString(FIL_CODIGO));
                    exa.setValor(REQ_CODIGO, req.getInt(REQ_CODIGO));
                    int qtd = CriaLoteExportacao.quantidadeTuboRecipiente(exa, st);
                    if (chaves.contains(chave)) continue;
                    insert.limpar(TABELA_LOTEEXTERNOEXAMEREQUISICAO);
                    insert.addCampoValor(FIL_CODIGO, Variaveis.filialPadrao);
                    insert.addCampoValor(FIL_KODIGO, req.getString(FIL_CODIGO));
                    insert.addCampoValor(LEX_CODIGO, novoLote);
                    insert.addCampoValor(LAE_CODIGO, externo);
                    insert.addCampoValor(REQ_CODIGO, req.getString(REQ_CODIGO));
                    insert.addCampoValor(EXA_CODIGO, exa.getString(EXA_CODIGO), true);
                    insert.addCampoValor(MCO_CODIGO, exa.getString(MCO_CODIGO));
                    if (isColetaWeb) {
                        st.executeUpdate(insert.getSQL());
                    } else {
                        Conexao.execute(Variaveis.filialPadrao, st, insert.getSQL());
                    }
                    if (exa.getValor(REC_KODIGO) != null && exa.getValor(REC_KODIGO) instanceof Array && (valores = (String[])((Array)exa.getValor(REC_KODIGO)).getArray()).length > 0 && (valores.length != 1 || !Funcoes.textoVazio(valores[0]))) {
                        String[] recipientes;
                        for (String tubo : recipientes = StringUtil.limpaString(exa.getString(REC_KODIGO), new String[]{"{", "}"}).split(",")) {
                            insert.limpar(TABELA_LOTEEXTERNOEXAMEREQUISICAORECIP);
                            insert.addCampoValor(FIL_CODIGO, Variaveis.filialPadrao);
                            insert.addCampoValor(FIL_KODIGO, req.getString(FIL_CODIGO));
                            insert.addCampoValor(LEX_CODIGO, novoLote);
                            insert.addCampoValor(LAE_CODIGO, exa.getString(LAE_CODIGO));
                            insert.addCampoValor(REQ_CODIGO, req.getString(REQ_CODIGO));
                            insert.addCampoValor(EXA_CODIGO, exa.getString(EXA_CODIGO), true);
                            insert.addCampoValor(MCO_CODIGO, exa.getString(MCO_CODIGO));
                            insert.addCampoValor(REC_CODIGO, tubo);
                            if (isColetaWeb) {
                                st.executeUpdate(insert.getSQL());
                                continue;
                            }
                            Conexao.execute(Variaveis.filialPadrao, st, insert.getSQL());
                        }
                    }
                    if ((desmembrados = (List)exa.getValor("listaexames")) != null && !desmembrados.isEmpty() && !this.gravarDesmembrados(novoLote, exa, labExterno, st, isColetaWeb)) {
                        return null;
                    }
                    insert.addCampoValor(MCO_DESCRICAO, exa.getString(MCO_DESCRICAO));
                    chaves.add(chave);
                    CriaLoteExportacao.gravarExamesExportados(req, exa, st, isColetaWeb);
                }
            }
        }
        return retorno;
    }

    public boolean gravarDesmembrados(int novoLote, Registro exa, LaboratorioExterno labExterno, Statement st, boolean isColetaWeb) throws Exception {
        ArrayList listaExames = (ArrayList)exa.getValor("listaexames");
        for (Registro desm : listaExames) {
            ConstrutorInsert insert = new ConstrutorInsert(TABELA_LOTEEXTERNOEXAMEREQUISICAODESM);
            insert.addCampoValor(FIL_CODIGO, Variaveis.filialPadrao);
            insert.addCampoValor(FIL_KODIGO, exa.getString(FIL_CODIGO));
            insert.addCampoValor(LEX_CODIGO, novoLote);
            insert.addCampoValor(LAE_CODIGO, labExterno.codigoLab);
            insert.addCampoValor(REQ_CODIGO, exa.getString(REQ_CODIGO));
            insert.addCampoValor(EXA_CODIGO, exa.getString(EXA_CODIGO), true);
            insert.addCampoValor(MCO_CODIGO, exa.getString(MCO_CODIGO));
            insert.addCampoValor(EXA_KODIGO, desm.getValor(EXA_CODIGO), true);
            insert.addCampoValor(MCO_KODIGO, desm.getValor(MCO_CODIGO));
            if (isColetaWeb) {
                st.executeUpdate(insert.getSQL());
                continue;
            }
            Conexao.execute(Variaveis.filialPadrao, st, insert.getSQL());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void gravarExamesExportados(Registro req, Registro exa, Statement st) throws Exception {
        try {
            StringBuilder bui = new StringBuilder();
            bui.append("update examerequisicao \n");
            bui.append("set exr_dataloteexterno = current_timestamp, \n");
            bui.append("    usr_codloteexterno = '").append(Variaveis.login).append("' \n");
            bui.append("where \n");
            bui.append("  fil_codigo = ").append(req.getValor(FIL_CODIGO)).append(" and \n");
            bui.append("  req_codigo = ").append(req.getValor(REQ_CODIGO)).append(" and \n");
            bui.append("  exa_codigo = '").append(exa.getString(EXA_CODIGO)).append("' and \n");
            bui.append("  mco_codigo = ").append(exa.getString(MCO_CODIGO));
            Conexao.executeUpdate(req.getValor(FIL_CODIGO).toString(), st, bui.toString());
        }
        catch (Throwable throwable) {
            Conexao.fecharStatement(st);
            throw throwable;
        }
        Conexao.fecharStatement(st);
    }

    protected boolean validarConfiguracao(String configuracaoLabExterno, boolean validaConexao, LaboratorioExterno labExterno, boolean isColetaWeb) {
        boolean isEnviarWebService = configuracaoLabExterno.indexOf("enviarLoteWebservice") > 0 ? StringUtil.getBoolean(configuracaoLabExterno, "enviarLoteWebservice") : false;
        String codigoWebservice = configuracaoLabExterno.indexOf("codigoProtocolo") > 0 ? StringUtil.getValor(configuracaoLabExterno, "codigoProtocolo") : null;
        String senhaWebservice = configuracaoLabExterno.indexOf("senhaWeb") > 0 ? StringUtil.getValor(configuracaoLabExterno, "senhaWeb") : null;
        String endereco = "https://www.hermespardini.com.br/b2b/HPWS.XMLServer.cls";
        if (labExterno.protocolo == Protocolo.DBV2) {
            isEnviarWebService = configuracaoLabExterno.indexOf("enviarLoteWebservice") > 0 ? StringUtil.getBoolean(configuracaoLabExterno, "enviarLoteWebservice") : false;
            codigoWebservice = configuracaoLabExterno.indexOf("codigo") > 0 ? StringUtil.getValor(configuracaoLabExterno, "codigo") : null;
            senhaWebservice = configuracaoLabExterno.indexOf("senha") > 0 ? StringUtil.getValor(configuracaoLabExterno, "senha") : null;
            String string = endereco = configuracaoLabExterno.indexOf("enderecoWebService") > 0 ? StringUtil.getValor(configuracaoLabExterno, "enderecoWebService") : null;
        }
        if (labExterno.protocolo == Protocolo.RedeWS) {
            codigoWebservice = configuracaoLabExterno.indexOf("idLaboratorio") > 0 ? StringUtil.getValor(configuracaoLabExterno, "idLaboratorio") : null;
            senhaWebservice = configuracaoLabExterno.indexOf("senha") > 0 ? StringUtil.getValor(configuracaoLabExterno, "senha") : null;
            WSApoioSoapProxy proxy = new WSApoioSoapProxy();
            endereco = proxy.getEndpoint();
        }
        if (labExterno.protocolo == Protocolo.Shift) {
            isEnviarWebService = configuracaoLabExterno.indexOf("enviarLoteWebservice") >= 0 ? StringUtil.getBoolean(configuracaoLabExterno, "enviarLoteWebservice") : false;
            codigoWebservice = configuracaoLabExterno.indexOf("idLaboratorio") >= 0 ? StringUtil.getValor(configuracaoLabExterno, "idLaboratorio") : null;
            senhaWebservice = configuracaoLabExterno.indexOf("senha") >= 0 ? StringUtil.getValor(configuracaoLabExterno, "senha") : null;
            String string = endereco = configuracaoLabExterno.indexOf("enderecoWebService") >= 0 ? StringUtil.getValor(configuracaoLabExterno, "enderecoWebService") : null;
        }
        if (labExterno.protocolo == Protocolo.Maricondi) {
            isEnviarWebService = configuracaoLabExterno.indexOf(TagsConfiguradorProtocoloMaricondi.TAG_ENVIAR_UTILIZANDO_WEBSERVICE.getTag()) >= 0 ? StringUtil.getBoolean(configuracaoLabExterno, TagsConfiguradorProtocoloMaricondi.TAG_ENVIAR_UTILIZANDO_WEBSERVICE.getTag()) : false;
            codigoWebservice = configuracaoLabExterno.indexOf(TagsConfiguradorProtocoloMaricondi.TAG_CODIGO_PROTOCOLO.getTag()) >= 0 ? StringUtil.getValor(configuracaoLabExterno, TagsConfiguradorProtocoloMaricondi.TAG_CODIGO_PROTOCOLO.getTag()) : null;
            senhaWebservice = configuracaoLabExterno.indexOf(TagsConfiguradorProtocoloMaricondi.TAG_CHAVE.getTag()) >= 0 ? StringUtil.getValor(configuracaoLabExterno, TagsConfiguradorProtocoloMaricondi.TAG_CHAVE.getTag()) : null;
            String string = endereco = configuracaoLabExterno.indexOf(TagsConfiguradorProtocoloMaricondi.TAG_ENDERECO_WEBSERVICE.getTag()) >= 0 ? StringUtil.getValor(configuracaoLabExterno, TagsConfiguradorProtocoloMaricondi.TAG_ENDERECO_WEBSERVICE.getTag()) : null;
        }
        if (isEnviarWebService) {
            if (Funcoes.textoVazio(codigoWebservice)) {
                Funcoes.mensagem(Laboratorio.getInstancia(), "O c\u00f3digo do protocolo do " + labExterno.descricao + " n\u00e3o foi configurado.", 2);
                return false;
            }
            if (Funcoes.textoVazio(senhaWebservice)) {
                Funcoes.mensagem(Laboratorio.getInstancia(), "A senha do " + labExterno.descricao + " n\u00e3o foi configurada.", 2);
                return false;
            }
            if (validaConexao) {
                try {
                    if (!IntegracaoLabExterno.comunicacaoOk(endereco, isColetaWeb)) {
                        return false;
                    }
                }
                catch (Exception e) {
                    Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel conectar ao servidor. Verifique sua internet.", 2);
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean comunicacaoOk(String enderecoWebService, boolean isColetaWeb) throws IOException, NoSuchAlgorithmException, KeyManagementException {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        SSLContext sc = SSLContext.getInstance("SSL");
        if (enderecoWebService.contains("https")) {
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        }
        URL url = new URL(enderecoWebService);
        HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
        urlConnection.setDoOutput(true);
        urlConnection.setDoInput(true);
        urlConnection.setRequestMethod("GET");
        urlConnection.setRequestProperty("Content-type", "text/xml; charset=UTF-8");
        urlConnection.connect();
        int codigoResposta = urlConnection.getResponseCode();
        String msg = urlConnection.getResponseMessage();
        if (codigoResposta != 200) {
            if (!isColetaWeb && codigoResposta == 404) {
                Funcoes.mensagem(Laboratorio.getInstancia(), "Endere\u00e7o do WebService inv\u00e1lido.", 2);
                return false;
            }
            if (!isColetaWeb && codigoResposta == 401) {
                Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o autorizado.", 2);
                return false;
            }
            if (!isColetaWeb && codigoResposta == 503) {
                Funcoes.mensagem(Laboratorio.getInstancia(), "Servi\u00e7o indispon\u00edvel.", 2);
                return false;
            }
            if (!isColetaWeb) {
                Funcoes.mensagem(Laboratorio.getInstancia(), msg, 2);
            }
            return false;
        }
        return true;
    }

    public static void removerLote(String codLabExterno, List<Registro> requisicoes, String numeroLote, Statement st, boolean isColetaWeb, Callable<Boolean> arquivar, int agruparInterface) throws NumberFormatException, Exception {
        IntegracaoLabExterno.removerLote(codLabExterno, requisicoes, numeroLote, true, st, isColetaWeb, arquivar, agruparInterface);
    }

    public static void removerLote(String codLabExterno, List<Registro> requisicoes, String numeroLote, boolean isForcarExclusao, Statement st, boolean isColetaWeb, Callable<Boolean> arquivar, int agruparInterface) throws NumberFormatException, Exception {
        IntegracaoLabExterno.removerLote(codLabExterno, requisicoes, numeroLote, isForcarExclusao, false, st, isColetaWeb, arquivar, agruparInterface);
    }

    public static void removerLote(String codLabExterno, List<Registro> requisicoes, String numeroLote, boolean isForcarExclusao, boolean removerDataEtiqueta, Statement st, boolean isColetaWeb, Callable<Boolean> arquivar, int agruparInterface) throws NumberFormatException, Exception {
        for (Registro registro : requisicoes) {
            IntegracaoLabExterno.excluirRequisicao(codLabExterno, st, numeroLote, registro, isForcarExclusao, false, removerDataEtiqueta, isColetaWeb, arquivar, agruparInterface);
        }
        arquivar.call();
    }

    public RetornoEstornarLote estornarExames(String codLabExterno, List<Registro> requisicoes, String numeroLote, boolean isColetaWeb, Statement st, Callable<Boolean> arquivar, Callable<Boolean> anular, int agruparInterface, LaboratorioExterno labSelecionado, boolean agruparMultiguia, String login, int digitosTuboFilial, int digitosTuboRequisicao) throws Exception {
        RetornoEstornarLote retorno = new RetornoEstornarLote();
        for (Registro registro : requisicoes) {
            try {
                IntegracaoLabExterno.excluirRequisicao(codLabExterno, st, numeroLote, registro, false, true, false, isColetaWeb, arquivar, agruparInterface);
                retorno.setSucesso(true);
                arquivar.call();
            }
            catch (Exception e) {
                retorno.setSucesso(false);
                anular.call();
            }
        }
        return retorno;
    }

    private static void excluirRequisicao(String codLabExterno, Statement st, String numeroLote, Registro requisicao, boolean isForcarExcluir, boolean isEstorno, boolean removerDataEtiqueta, boolean isColetaWeb, Callable<Boolean> arquivar, int agruparInterface) throws NumberFormatException, Exception {
        String filial = requisicao.getString(FIL_CODIGO);
        String req = requisicao.getString(REQ_CODIGO);
        List exames = (List)requisicao.getValor("listaexames");
        IntegracaoLabExterno.excluirRequisicao(codLabExterno, st, numeroLote, requisicao, isForcarExcluir, isEstorno, removerDataEtiqueta, exames, filial, req, isColetaWeb, arquivar, agruparInterface);
    }

    public static void excluirRequisicaoDB(String codLabExterno, Statement st, String numeroLote, Registro requisicao, boolean isForcarExcluir, boolean isEstorno, boolean removerDataEtiqueta, List<Registro> exames, String filial, String req, boolean isColetaWeb, Callable<Boolean> arquivar, int agruparInterface, boolean agruparGuiasInterface) throws Exception {
        IntegracaoLabExterno.excluirRequisicao(codLabExterno, st, numeroLote, requisicao, isForcarExcluir, isEstorno, removerDataEtiqueta, exames, filial, req, isColetaWeb, arquivar, agruparInterface);
    }

    public static void excluirRequisicaoJalis(String codLabExterno, Statement st, String numeroLote, Registro requisicao, boolean isForcarExcluir, boolean isEstorno, boolean removerDataEtiqueta, List<Registro> exames, String filial, String req, boolean isColetaWeb, Callable<Boolean> arquivar, int agruparInterface) throws Exception {
        IntegracaoLabExterno.excluirRequisicao(codLabExterno, st, numeroLote, requisicao, isForcarExcluir, isEstorno, removerDataEtiqueta, exames, filial, req, isColetaWeb, arquivar, agruparInterface);
    }

    protected static boolean agruparMultiguia(String filial, String req, Statement st, boolean agruparGuiasInterface) throws SQLException {
        return agruparGuiasInterface || DBUtil.requisicaoAgrupaMultiguiasLabExterno(st, filial, req);
    }

    private static void excluirRequisicao(String codLabExterno, Statement st, String numeroLote, Registro requisicao, boolean isForcarExcluir, boolean isEstorno, boolean removerDataEtiqueta, List<Registro> exames, String filial, String req, boolean isColetaWeb, Callable<Boolean> arquivar, int agruparInterface) throws Exception {
        if (isEstorno) {
            numeroLote = !requisicao.nulo(LEX_CODIGO) && !Funcoes.textoVazio(requisicao.getString(LEX_CODIGO)) ? requisicao.getString(LEX_CODIGO) : numeroLote;
        }
        StringBuilder buf = new StringBuilder();
        boolean temLoteRequisicao = false;
        boolean temRetorno = false;
        buf.append("select coalesce(length(leq_retornows),0) > 0 as temRetorno from loteexternorequisicao ");
        buf.append(" where fil_kodigo = ").append(filial);
        buf.append("   and fil_codigo = ").append(Variaveis.filialPadrao);
        buf.append("   and lae_codigo = ").append(codLabExterno);
        buf.append("   and req_codigo in (").append(req).append(") ");
        buf.append("   and leq_dataestorno is null ");
        ResultSet resultSetExisteLote = st.executeQuery(buf.toString());
        temLoteRequisicao = resultSetExisteLote.next();
        if (temLoteRequisicao) {
            temRetorno = resultSetExisteLote.getBoolean("temRetorno");
        }
        for (Registro exame : exames) {
            String[] valores;
            List desmembrados;
            if (!Funcoes.textoVazio(exame.getString(REQ_CODIGO))) {
                req = exame.getString(REQ_CODIGO);
            }
            buf.setLength(0);
            buf.append("update examerequisicao set exr_dataloteexterno = null, usr_codloteexterno = null ");
            if (removerDataEtiqueta) {
                buf.append(agruparInterface == 1 ? " ,exr_dataetqtriagem = null " : " ,exr_dataetqcoleta = null ");
            }
            buf.append("where fil_codigo = ").append(filial);
            buf.append(" and req_codigo in (").append(req).append(") ");
            buf.append(" and exa_codigo = '").append(exame.getString(EXA_CODIGO)).append("' ");
            buf.append(" and mco_codigo = '").append(exame.getString(MCO_CODIGO)).append("' ");
            if (isColetaWeb) {
                st.executeUpdate(buf.toString());
            } else {
                Conexao.execute(filial, st, buf);
            }
            if (temLoteRequisicao) {
                buf.setLength(0);
                buf.append(" update loteexternoexamerequisicao set ler_datahoraestorno = current_timestamp, usr_codestorno = ").append(StringUtil.textoDBEscape(Variaveis.login));
                buf.append(" where fil_kodigo = ").append(filial);
                buf.append(" and fil_codigo = ").append(Variaveis.filialPadrao);
                buf.append(" and lae_codigo = ").append(codLabExterno);
                buf.append(" and lex_codigo = ").append(numeroLote);
                buf.append(" and req_codigo in( ").append(req).append(") ");
                buf.append(" and exa_codigo = '").append(exame.getString(EXA_CODIGO)).append("' ");
                buf.append(" and mco_codigo = '").append(exame.getString(MCO_CODIGO)).append("' ");
                if (isColetaWeb) {
                    st.executeUpdate(buf.toString());
                } else {
                    Conexao.execute(filial, st, buf);
                }
                arquivar.call();
                if (IntegracaoLabExterno.isForcarExcluirEstorno(isForcarExcluir, isEstorno)) {
                    buf.setLength(0);
                    buf.append("delete from requisicaolabexterno");
                    buf.append(" where fil_codigo = ").append(filial);
                    buf.append(" and req_codigo in( ").append(req).append(") ");
                    buf.append(" and lae_codigo = ").append(codLabExterno);
                    if (isColetaWeb) {
                        st.executeUpdate(buf.toString());
                    } else {
                        Conexao.execute(filial, st, buf);
                    }
                    buf.setLength(0);
                    buf.append(" delete from loteexternoexamerequisicao ");
                    buf.append(" where fil_kodigo = ").append(filial);
                    buf.append(" and fil_codigo = ").append(Variaveis.filialPadrao);
                    buf.append(" and lae_codigo = ").append(codLabExterno);
                    buf.append(" and lex_codigo = ").append(numeroLote);
                    buf.append(" and req_codigo in( ").append(req).append(") ");
                    buf.append(" and exa_codigo = '").append(exame.getString(EXA_CODIGO)).append("' ");
                    buf.append(" and mco_codigo = '").append(exame.getString(MCO_CODIGO)).append("' ");
                    if (isColetaWeb) {
                        st.executeUpdate(buf.toString());
                    } else {
                        Conexao.executeUpdate(filial, st, buf);
                    }
                    buf.setLength(0);
                    buf.append("delete from loteexternorequisicao ");
                    buf.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
                    buf.append("   and fil_kodigo = ").append(filial);
                    buf.append("   and lex_codigo = ").append(numeroLote);
                    buf.append("   and lae_codigo = ").append(codLabExterno);
                    buf.append("   and req_codigo in( ").append(req).append(") ");
                    if (isColetaWeb) {
                        st.executeUpdate(buf.toString());
                    } else {
                        Conexao.executeUpdate(Variaveis.filialPadrao, st, buf);
                    }
                    buf.setLength(0);
                    buf.append("select 1 from loteexternorequisicao where ");
                    buf.append("     fil_kodigo = ").append(filial);
                    buf.append(" and fil_codigo = ").append(Variaveis.filialPadrao);
                    buf.append(" and lae_codigo = ").append(codLabExterno);
                    buf.append(" and lex_codigo = ").append(numeroLote);
                    ResultSet resultSetExisteReqLote = st.executeQuery(buf.toString());
                    if (!resultSetExisteReqLote.next()) {
                        buf.setLength(0);
                        buf.append("delete from loteexterno where ");
                        buf.append("      fil_codigo = ").append(filial);
                        buf.append(" and lae_codigo = ").append(codLabExterno);
                        buf.append(" and lex_codigo = ").append(numeroLote);
                        if (isColetaWeb) {
                            st.executeUpdate(buf.toString());
                        } else {
                            Conexao.execute(filial, st, buf);
                        }
                    }
                } else {
                    buf.delete(0, buf.length());
                    buf.append(" select 1 from loteexternoexamerequisicao ");
                    buf.append(" where fil_kodigo = ").append(filial);
                    buf.append(" and fil_codigo = ").append(Variaveis.filialPadrao);
                    buf.append(" and lae_codigo = ").append(codLabExterno);
                    buf.append(" and lex_codigo = ").append(numeroLote);
                    buf.append(" and req_codigo in (").append(req).append(") ");
                    buf.append(" and (ler_datahoraestorno is null and usr_codestorno is null) ");
                    ResultSet rsExameSemEstorno = st.executeQuery(buf.toString());
                    if (!rsExameSemEstorno.next()) {
                        buf.delete(0, buf.length());
                        buf.append("update loteexternorequisicao set leq_dataestorno = current_timestamp, usr_codestorno = '").append(Variaveis.login).append("' ");
                        buf.append("where fil_codigo = ").append(Variaveis.filialPadrao);
                        buf.append(" and fil_kodigo = ").append(filial);
                        buf.append(" and lex_codigo = ").append(numeroLote);
                        buf.append(" and req_codigo in(").append(req).append(") ");
                        if (isColetaWeb) {
                            st.executeUpdate(buf.toString());
                        } else {
                            Conexao.executeUpdate(filial, st, buf);
                        }
                    }
                    buf.setLength(0);
                    buf.append("select 1 from loteexternorequisicao where ");
                    buf.append("     fil_kodigo = ").append(filial);
                    buf.append(" and fil_codigo = ").append(Variaveis.filialPadrao);
                    buf.append(" and lae_codigo = ").append(codLabExterno);
                    buf.append(" and lex_codigo = ").append(numeroLote);
                    buf.append(" and leq_dataestorno is null ");
                    ResultSet rsRequisicaoSemEstorno = st.executeQuery(buf.toString());
                    if (!rsRequisicaoSemEstorno.next()) {
                        buf.setLength(0);
                        buf.append("update loteexterno set lex_dataestorno = current_timestamp, usr_codestorno = '").append(Variaveis.login).append("'");
                        buf.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
                        buf.append("   and lex_codigo = ").append(numeroLote);
                        buf.append("   and lae_codigo = ").append(codLabExterno);
                        if (isColetaWeb) {
                            st.executeUpdate(buf.toString());
                        } else {
                            Conexao.executeUpdate(Variaveis.filialPadrao, st, buf);
                        }
                    }
                }
            }
            if (exame.getValor("listaexames") != null && !(desmembrados = (List)exame.getValor("listaexames")).isEmpty()) {
                for (int k = 0; k < desmembrados.size(); ++k) {
                    Registro desm = (Registro)desmembrados.get(k);
                    buf.setLength(0);
                    buf.append("select * from loteexternoexamerequisicaodesm ");
                    buf.append(" where fil_kodigo = ").append(requisicao.getString(FIL_CODIGO));
                    buf.append("   and fil_codigo = ").append(Variaveis.filialPadrao);
                    buf.append("   and req_codigo = ").append(requisicao.getString(REQ_CODIGO));
                    buf.append("   and lae_codigo = ").append(codLabExterno);
                    buf.append("   and lex_codigo = ").append(numeroLote);
                    buf.append("   and mco_kodigo = ").append(desm.getString(MCO_CODIGO));
                    buf.append("   and exa_kodigo = '").append(desm.getString(EXA_CODIGO)).append("' ");
                    ResultSet existe = st.executeQuery(buf.toString());
                    if (!existe.next()) continue;
                    buf.setLength(0);
                    buf.append("delete from loteexternoexamerequisicaodesm ");
                    buf.append(" where fil_kodigo = ").append(requisicao.getString(FIL_CODIGO));
                    buf.append("   and fil_codigo = ").append(Variaveis.filialPadrao);
                    buf.append("   and req_codigo = ").append(requisicao.getString(REQ_CODIGO));
                    buf.append("   and lae_codigo = ").append(codLabExterno);
                    buf.append("   and lex_codigo = ").append(numeroLote);
                    buf.append("   and mco_kodigo = ").append(desm.getString(MCO_CODIGO));
                    buf.append("   and exa_kodigo = '").append(desm.getString(EXA_CODIGO)).append("' ");
                    if (isColetaWeb) {
                        st.executeUpdate(buf.toString());
                    } else {
                        Conexao.execute(filial, st, buf);
                    }
                    buf.setLength(0);
                    buf.append(" update loteexternoexamerequisicao set ler_datahoraestorno = current_timestamp, usr_codestorno = ").append(StringUtil.textoDBEscape(Variaveis.login));
                    buf.append(" where fil_kodigo = ").append(filial);
                    buf.append(" and fil_codigo = ").append(Variaveis.filialPadrao);
                    buf.append(" and lae_codigo = ").append(codLabExterno);
                    buf.append(" and lex_codigo = ").append(numeroLote);
                    buf.append(" and req_codigo in( ").append(req).append(") ");
                    buf.append(" and exa_codigo = '").append(desm.getString(EXA_CODIGO)).append("' ");
                    buf.append(" and mco_codigo = '").append(desm.getString(MCO_CODIGO)).append("' ");
                    if (isColetaWeb) {
                        st.executeUpdate(buf.toString());
                    } else {
                        Conexao.execute(filial, st, buf);
                    }
                    arquivar.call();
                }
                buf.delete(0, buf.length());
                buf.append(" select 1 from loteexternoexamerequisicao ");
                buf.append(" where fil_kodigo = ").append(filial);
                buf.append(" and fil_codigo = ").append(Variaveis.filialPadrao);
                buf.append(" and lae_codigo = ").append(codLabExterno);
                buf.append(" and lex_codigo = ").append(numeroLote);
                buf.append(" and req_codigo in (").append(req).append(") ");
                buf.append(" and (ler_datahoraestorno is null and usr_codestorno is null) ");
                ResultSet rsExameSemEstorno = st.executeQuery(buf.toString());
                if (!rsExameSemEstorno.next()) {
                    buf.delete(0, buf.length());
                    buf.append("update loteexternorequisicao set leq_dataestorno = current_timestamp, usr_codestorno = '").append(Variaveis.login).append("' ");
                    buf.append("where fil_codigo = ").append(Variaveis.filialPadrao);
                    buf.append(" and fil_kodigo = ").append(filial);
                    buf.append(" and lex_codigo = ").append(numeroLote);
                    buf.append(" and req_codigo in(").append(req).append(") ");
                    if (isColetaWeb) {
                        st.executeUpdate(buf.toString());
                    } else {
                        Conexao.executeUpdate(filial, st, buf);
                    }
                }
                buf.setLength(0);
                buf.append("select 1 from loteexternorequisicao where ");
                buf.append("     fil_kodigo = ").append(filial);
                buf.append(" and fil_codigo = ").append(Variaveis.filialPadrao);
                buf.append(" and lae_codigo = ").append(codLabExterno);
                buf.append(" and lex_codigo = ").append(numeroLote);
                buf.append(" and leq_dataestorno is null ");
                ResultSet rsRequisicaoSemEstorno = st.executeQuery(buf.toString());
                if (!rsRequisicaoSemEstorno.next()) {
                    buf.setLength(0);
                    buf.append("update loteexterno set lex_dataestorno = current_timestamp, usr_codestorno = '").append(Variaveis.login).append("'");
                    buf.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
                    buf.append("   and lex_codigo = ").append(numeroLote);
                    buf.append("   and lae_codigo = ").append(codLabExterno);
                    if (isColetaWeb) {
                        st.executeUpdate(buf.toString());
                    } else {
                        Conexao.executeUpdate(Variaveis.filialPadrao, st, buf);
                    }
                }
            }
            if (exame.getValor(REC_KODIGO) == null || !(exame.getValor(REC_KODIGO) instanceof Array) || (valores = (String[])((Array)exame.getValor(REC_KODIGO)).getArray()).length <= 0 || valores.length == 1 && Funcoes.textoVazio(valores[0])) continue;
            boolean existe = false;
            buf.setLength(0);
            buf.append("select * from loteexternoexamerequisicaorecip lexr ");
            buf.append(" where lexr.fil_codigo = ").append(requisicao.getString(FIL_CODIGO));
            buf.append(" \t and lexr.lex_codigo = ").append(numeroLote);
            buf.append("   and lexr.lae_codigo = ").append(codLabExterno);
            buf.append("   and lexr.req_codigo = ").append(requisicao.getString(REQ_CODIGO));
            buf.append("   and lexr.mco_codigo = ").append(exame.getString(MCO_CODIGO));
            buf.append("   and lexr.exa_codigo = '").append(exame.getString(EXA_CODIGO)).append("' ");
            ResultSet rsExiste = st.executeQuery(buf.toString());
            existe = rsExiste.next();
            if (!existe || !Funcoes.textoVazioNotNullIsNumberTubo(StringUtil.limpaString(exame.getString(REC_KODIGO), new String[]{"{", "}"}))) continue;
            buf.setLength(0);
            buf.append("delete from loteexternoexamerequisicaorecip ");
            buf.append(" where fil_codigo = ").append(filial);
            buf.append("   and lae_codigo = ").append(codLabExterno);
            buf.append("   and lex_codigo = ").append(numeroLote);
            buf.append("   and req_codigo in( ").append(req).append(") ");
            buf.append("   and exa_codigo = '").append(exame.getString(EXA_CODIGO)).append("' ");
            if (!Funcoes.textoVazio(exame.getString(REC_KODIGO))) {
                buf.append(" and rec_codigo = ").append(StringUtil.limpaString(exame.getString(REC_KODIGO), new String[]{"{", "}"}));
            }
            if (isColetaWeb) {
                st.executeUpdate(buf.toString());
                continue;
            }
            Conexao.execute(filial, st, buf);
        }
        arquivar.call();
    }

    private static boolean isForcarExcluirEstorno(boolean isForcarExcluir, boolean isEstorno) {
        return isForcarExcluir && !isEstorno;
    }

    protected static Integer[] validaMultiguia(Registro requisicao, String codigoLab, Statement st, boolean agruparGuiasInterface) throws SQLException {
        ArrayList<String> listaExames = new ArrayList<String>();
        ArrayList<Integer> listaMateriais = new ArrayList<Integer>();
        Integer filial = null;
        Integer req = null;
        filial = Integer.valueOf(requisicao.getString(FIL_CODIGO));
        req = Integer.valueOf(requisicao.getString(REQ_CODIGO));
        List listaExame = (List)requisicao.getValor("listaexames");
        for (Registro er : listaExame) {
            listaExames.add(er.getString(EXA_CODIGO));
            listaMateriais.add(Integer.valueOf(er.getString(MCO_CODIGO)));
        }
        boolean agrupaMultiguias = IntegracaoLabExterno.isAgrupaMultiguias(codigoLab, listaExames, listaMateriais, filial, req, agruparGuiasInterface, st);
        Integer[] multiguias = null;
        if (agrupaMultiguias) {
            multiguias = RecepcaoUtil.verificaMultiGuias(st, filial.toString(), req.toString(), true, false);
            if (IntegracaoLabExterno.existeMultiguia(multiguias)) {
                return multiguias;
            }
            return new Integer[]{Integer.parseInt(requisicao.getString(REQ_CODIGO))};
        }
        return new Integer[]{Integer.parseInt(requisicao.getString(REQ_CODIGO))};
    }

    private static boolean isAgrupaMultiguias(String codigoLab, ArrayList<String> listaExames, ArrayList<Integer> listaMateriais, Integer filial, Integer req, boolean agruparGuiasInterface, Statement st) throws SQLException {
        return agruparGuiasInterface || DBUtil.requisicaoAgrupaMultiguiasLabExterno(st, filial, req, listaExames, listaMateriais, Integer.valueOf(codigoLab));
    }

    private static boolean existeMultiguia(Integer[] multiguias) {
        return multiguias != null && multiguias.length > 0;
    }

    private static List<Registro> verificaExamesMultiguia(Registro requisicao, String reqCodigo, String codLabExterno, Statement st) throws SQLException {
        LoteExternoExameRequisicaoService loteExternoExameRequisicaoService = new LoteExternoExameRequisicaoService();
        return loteExternoExameRequisicaoService.verificaExamesMultiguia(requisicao, reqCodigo, codLabExterno, requisicao.getString(FIL_CODIGO), requisicao.getString(LEX_CODIGO), st);
    }

    public static ArrayList<Registro> carregarLote(long codigoLote, LaboratorioExterno labExterno, String filial, Statement st, boolean isEstorno, int agruparInterface) {
        return IntegracaoLabExterno.carregarLote(false, codigoLote, labExterno, filial, st, Conexao.getStatement(), isEstorno, agruparInterface);
    }

    public static ArrayList<Registro> carregarLote(boolean isColetaWeb, long codigoLote, LaboratorioExterno labExterno, String filial, Statement st, Statement st2, boolean isEstorno, int agruparInterface) {
        ArrayList<Registro> listaRequisicoes;
        block6: {
            listaRequisicoes = new ArrayList<Registro>();
            try {
                StringBuilder buf = new StringBuilder("select c.fil_kodigo, a.fil_codigo, a.req_codigo, b.pac_nome, b.pac_cpf, b.pac_rg, b.pac_datanasc, b.pac_cartaosus, c.lae_codigo, (d.rle_codigo is not null) as enviado, ");
                buf.append("a.req_data, a.req_hora, a.req_dum, a.req_obs, a.req_peso, a.req_altura, a.req_anomes, c.leq_dataestorno, c.lex_codigo, ");
                buf.append("a.req_idade, a.pac_codigo, con.con_codigo, con.con_razao, b.pac_sexo, b.pac_datanasc, a.med_conselho, a.med_crm, a.med_uf, e.med_nome, coalesce(m.req_codigo, a.req_codigo) as req_codigomae ");
                buf.append("from loteexternorequisicao c ");
                buf.append("left join requisicao a on c.fil_kodigo = a.fil_codigo and c.req_codigo = a.req_codigo ");
                buf.append("left join convenios  con on a.fil_codigo = con.fil_codigo and a.con_codigo = con.con_codigo ");
                buf.append("left join paciente b on a.fil_codigo = b.fil_codigo and a.pac_codigo = b.pac_codigo ");
                buf.append("left join requisicaolabexterno d on c.fil_kodigo = d.fil_codigo and c.req_codigo = d.req_codigo and c.lae_codigo = d.lae_codigo ");
                buf.append("left join medico e on a.fil_codigo = e.fil_codigo and a.med_conselho = e.med_conselho and a.med_crm = e.med_crm and a.med_uf = e.med_uf ");
                buf.append("left join requisicaorequisicao m on a.fil_codigo = m.fil_codigo and a.req_codigo = m.req_kodigo \n");
                buf.append("where c.fil_codigo = ").append(filial);
                buf.append(" and c.lex_codigo = ").append(codigoLote);
                buf.append(" and c.lae_codigo = ").append(labExterno.codigoLab);
                buf.append(" and c.leq_dataestorno is null ");
                buf.append(" and a.req_excluida = false ");
                buf.append(" order by a.req_codigo ");
                ResultSet rs = st.executeQuery(buf.toString());
                if (rs.next()) {
                    do {
                        Registro req = new Registro(rs);
                        if (rs.getTimestamp("leq_dataestorno") == null) {
                            listaRequisicoes.add(req);
                        }
                        ArrayList<Registro> exames = IntegracaoLabExterno.pegaExamesRequisicao(st2, labExterno, rs.getString(REQ_CODIGO), rs.getString(FIL_KODIGO), String.valueOf(codigoLote), agruparInterface);
                        req.setValor("listaexames", exames);
                        if (labExterno.protocolo == Protocolo.HPardini || labExterno.protocolo == Protocolo.Alvaro || labExterno.protocolo == Protocolo.SolucaoV2 || labExterno.protocolo == Protocolo.DBV2 || labExterno.protocolo == Protocolo.Maricondi || labExterno.protocolo == Protocolo.Concent || labExterno.protocolo == Protocolo.Unilab || labExterno.protocolo == Protocolo.Cerba || labExterno.protocolo == Protocolo.Syslab || labExterno.protocolo == Protocolo.SaoMarcos || labExterno.protocolo == Protocolo.RedeWS || labExterno.protocolo == Protocolo.Shift || isEstorno) {
                            IntegracaoLabExterno.carregarExamesDesmembrados(req, labExterno, st2);
                            continue;
                        }
                        IntegracaoLabExterno.carregarDesmembrados(req, labExterno, st2);
                    } while (rs.next());
                }
            }
            catch (Exception ex) {
                if (isColetaWeb) break block6;
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel obter informa\u00e7\u00f5es do lote.\n" + ex.getMessage(), ex.getStackTrace());
            }
        }
        return listaRequisicoes;
    }

    public static List<Registro> carregarRequisicao(String requisiscaoPai, String codigofilial, LaboratorioExterno labExterno, int tipoEtiqueta, Callable<Boolean> arquivar, Callable<Boolean> anular) throws Exception {
        return IntegracaoLabExterno.carregarRequisicao(false, requisiscaoPai, codigofilial, labExterno, tipoEtiqueta, ParametrosGerais.isAgruparGuiasInterface(), Conexao.getStatement(), Variaveis.filialPadrao, ParametrosGerais.getAgruparInterface(), Conexao.getStatement(), Conexao.getStatement(), Conexao.getStatement(), Variaveis.login, ParametrosLocais.getParametro("imprimirEtiquetaTriagemSemMaterial"), ParametrosLocais.isTrue("imprimirEtiquetaColetaSemMaterial"), ParametrosLocais.isTrue("imprimirEtiquetaColetaSelecionadaSemMaterial"), ParametrosGerais.isAgruparEtiquetaPorQtde(), ParametrosGerais.getTipoExportacaoInterface(), ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao(), ParametrosGerais.getDigitosTuboTubo(), ParametrosGerais.getTuboPrimario(), ParametrosGerais.isUtilizarCapacidadeTuboPrimario(), arquivar, anular);
    }

    public static List<Registro> carregarRequisicao(boolean isColetaWeb, String requisiscaoPai, String codigofilial, LaboratorioExterno labExterno, int tipoEtiqueta, boolean agruparGuiasInterface, Statement st, String filialPadrao, int agruparInterface, Statement stEtq, Statement stEtq2, Statement stEtq3, String variaveisLogin, String imprimirEtiquetaTriagemSemMaterial, boolean imprimirEtiquetaColetaSemMaterial, boolean imprimirEtiquetaColetaSelecionadaSemMaterial, boolean agruparEtqPorQtde, String tipoExportacaoInterface, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario, Callable<Boolean> arquivar, Callable<Boolean> anular) throws Exception {
        List<Registro> requisicaoList = IntegracaoLabExterno.localizaRequisicao(codigofilial, requisiscaoPai, labExterno, st, agruparGuiasInterface, filialPadrao);
        HashMap<String, Registro> reqAux = new HashMap<String, Registro>();
        ArrayList<Registro> requisicoes = new ArrayList<Registro>();
        for (Registro requisicao : requisicaoList) {
            Registro r;
            if (tipoEtiqueta > -1 && labExterno.protocolo == Protocolo.Alvaro) {
                requisicao.setValor("listaexames", IntegracaoLabExterno.carregaExamesEtiquetas(requisicao, st));
                tipoEtiq = tipoEtiqueta;
                IntegracaoLabExterno.criarEtiquetaRequisicao(isColetaWeb, requisicao, agruparInterface, stEtq, stEtq2, stEtq3, variaveisLogin, agruparGuiasInterface, imprimirEtiquetaTriagemSemMaterial, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, agruparEtqPorQtde, tipoExportacaoInterface, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, tuboPrimario, utilizarCapacidadeTuboPrimario, arquivar);
                arquivar.call();
            }
            if ((r = IntegracaoLabExterno.carregarDadosRequisicao(requisicao, null, reqAux, labExterno, st, isColetaWeb)) == null) continue;
            reqAux.put(UtilExportadores.getChave(r, digitosTuboFilial, digitosTuboRequisicao), r);
            requisicoes.add(r);
        }
        return requisicoes;
    }

    public static List<Registro> carregarRequisicaoPelaFilial(String requisiscaoPai, String codigofilial, LaboratorioExterno labExterno, int tipoEtiqueta, Callable<Boolean> arquivar, Callable<Boolean> anular) throws Exception {
        return IntegracaoLabExterno.carregarRequisicaoPelaFilial(false, requisiscaoPai, codigofilial, labExterno, -1, ParametrosGerais.isAgruparGuiasInterface(), Variaveis.filialPadrao, Conexao.getStatement(), Conexao.getStatement(), Conexao.getStatement(), Variaveis.login, ParametrosGerais.getAgruparInterface(), ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao(), ParametrosLocais.getParametro("imprimirEtiquetaTriagemSemMaterial"), ParametrosLocais.isTrue("imprimirEtiquetaColetaSemMaterial"), ParametrosLocais.isTrue("imprimirEtiquetaColetaSelecionadaSemMaterial"), ParametrosGerais.isAgruparEtiquetaPorQtde(), ParametrosGerais.getTipoExportacaoInterface(), ParametrosGerais.getDigitosTuboTubo(), ParametrosGerais.getTuboPrimario(), ParametrosGerais.isUtilizarCapacidadeTuboPrimario(), arquivar, anular);
    }

    public static List<Registro> carregarRequisicaoPelaFilial(boolean isColetaWeb, String requisiscaoPai, String codigofilial, LaboratorioExterno labExterno, int tipoEtiqueta, boolean agruparGuiasInterface, String filialPadrao, Statement st, Statement st2, Statement st3, String variaveisLogin, int agruparInterface, int digitosFilial, int digitosRequisicao, String imprimirEtiquetaTriagemSemMaterial, boolean imprimirEtiquetaColetaSemMaterial, boolean imprimirEtiquetaColetaSelecionadaSemMaterial, boolean agruparEtqPorQtde, String tipoExportacaoInterface, int digitosTubo, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario, Callable<Boolean> arquivar, Callable<Boolean> anular) throws Exception {
        List<Registro> list = IntegracaoLabExterno.localizaRequisicao(codigofilial, requisiscaoPai, labExterno, st, agruparGuiasInterface, filialPadrao);
        HashMap<String, Registro> reqAux = new HashMap<String, Registro>();
        ArrayList<Registro> requisicoes = new ArrayList<Registro>();
        for (Registro reg : list) {
            Registro r;
            if (tipoEtiqueta > -1 && labExterno.protocolo == Protocolo.Alvaro) {
                reg.setValor("listaexames", IntegracaoLabExterno.carregaExamesEtiquetas(reg, st));
                tipoEtiq = tipoEtiqueta;
                IntegracaoLabExterno.criarEtiquetaRequisicao(isColetaWeb, reg, agruparInterface, st, st2, st3, variaveisLogin, agruparGuiasInterface, imprimirEtiquetaTriagemSemMaterial, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, agruparEtqPorQtde, tipoExportacaoInterface, digitosFilial, digitosRequisicao, digitosTubo, tuboPrimario, utilizarCapacidadeTuboPrimario, arquivar);
                arquivar.call();
            }
            if ((r = IntegracaoLabExterno.carregarDadosRequisicaoPelaFilial(reg, null, reqAux, labExterno, st, isColetaWeb)) == null) continue;
            reqAux.put(UtilExportadores.getChave(r, digitosFilial, digitosRequisicao), r);
            requisicoes.add(r);
        }
        return requisicoes;
    }

    public static List<Registro> localizaRequisicao(String filial, String codigoReq, LaboratorioExterno labExterno, Statement st, boolean agruparGuiasInterface, String filialPadrao) throws SQLException {
        ArrayList<Registro> requisicao = new ArrayList<Registro>();
        Object[] multiguia = null;
        try {
            multiguia = RecepcaoUtil.verificaMultiGuias(st, filial, codigoReq, true, false);
        }
        catch (SQLException e1) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e2o foi poss\u00edvel verificiar multiguia no carregamento de lote.\n" + e1.getMessage(), e1.getStackTrace());
        }
        Arrays.sort(multiguia);
        String guias = StringUtil.implode(Arrays.asList(multiguia), ",");
        StringBuilder bui = new StringBuilder("select \n");
        bui.append("  a.fil_codigo, a.req_codigo, a.req_data, a.req_hora, a.req_dum, a.req_obs, a.con_codigo, d.con_razao, \n");
        bui.append("  a.req_peso, a.req_altura, a.req_anomes, a.req_idade, a.req_urgente, \n");
        bui.append("  b.pac_codigo, b.pac_nome, b.pac_sexo, b.pac_datanasc, a.req_totpago, a.req_total, a.req_deveguia, b.pac_cpf, b.pac_rg,  \n");
        bui.append("  b.pac_dadoclinico,\tb.pac_celular, b.pac_endereco, b.pac_numeroendereco, b.pac_complemento,  \n");
        bui.append("  a.med_conselho, a.med_crm, a.med_uf, c.med_nome, a.req_dclinicos \n");
        bui.append("from requisicao a \n");
        bui.append("left join paciente b  on a.fil_codigo = b.fil_codigo and a.pac_codigo = b.pac_codigo \n");
        bui.append("left join medico c on a.fil_codigo = c.fil_codigo and a.med_conselho = c.med_conselho and a.med_crm = c.med_crm and a.med_uf = c.med_uf \n");
        bui.append("left join convenios d on a.fil_codigo = d.fil_codigo and a.con_codigo = d.con_codigo ");
        bui.append("where a.fil_codigo = ").append(filial);
        if (labExterno.agruparMultiguias(st, filialPadrao) || agruparGuiasInterface) {
            bui.append("  and a.req_codigo in (").append(guias).append(") ");
        } else {
            bui.append("  and a.req_codigo = ").append(codigoReq);
        }
        bui.append(" and (a.req_excluida = false or a.req_origemagendamento) ");
        ResultSet res = st.executeQuery(bui.toString());
        while (res.next()) {
            Registro reg = new Registro(res);
            reg.setValor(REQ_DATA, Funcoes.formataData("dd/MM/yyyy", res.getDate(REQ_DATA)));
            reg.setValor("req_codigomae", multiguia[0]);
            requisicao.add(reg);
        }
        return requisicao;
    }

    public static ResultSet carregarDadosExames(String filial, String requisicao, String codRecipiente, Statement st, LaboratorioExterno labExterno, boolean somenteConfigurados) throws SQLException {
        return IntegracaoLabExterno.carregarDadosExames(filial, requisicao, codRecipiente, st, labExterno, somenteConfigurados, null);
    }

    public static ResultSet carregarDadosExames(String filial, String requisicao, String codRecipiente, Statement st, LaboratorioExterno labExterno, boolean somenteConfigurados, String lote) throws SQLException {
        StringBuilder bui = new StringBuilder("select a.fil_codigo, a.req_codigo, lote.lex_codigo, g.lae_codigo, \n");
        bui.append("  (CASE WHEN (trim(f.ere_codigoapoiado) != '') THEN cast(trim(f.ere_codigoapoiado) AS varchar) ELSE cast(trim(a.exr_codigoapoiado) AS varchar) END) AS exr_codigoapoiado, ");
        bui.append("  a.exr_descricaomaterial, a.exr_datamaterial, a.exr_volumediurese, cast(a.exr_tempodiurese as varchar) as ext_tempodiurese, ");
        bui.append("  a.exr_situacao, (a.exr_dataloteexterno is not null) as ").append("exa_exportado").append(", ");
        bui.append("  b.exa_codigo, b.exa_descricao, a.exr_urgente, a.exr_situacao,");
        bui.append("  c.mco_codigo, c.mco_abreviatura, c.mco_solicitarmat, c.mco_descricao, ");
        bui.append("  g.ele_xmllabexterno, a.exr_datamaterial, a.exr_dataentregaprev, ");
        bui.append("  g.ele_diasprazo, g.ele_valorexame, h.req_codigo as req_codigomae, ");
        bui.append("  coalesce(g.lae_codigo = ").append(labExterno.codigoLab).append(", false) as ").append("exa_externo");
        bui.append(" ,'' as recipapresentacao ");
        bui.append(" ,(CASE WHEN (t.rec_codigo is not null) then array_agg(distinct cast(t.rec_codigo AS varchar))::varchar[] else null END) as rec_kodigo  ");
        if (!Funcoes.textoVazio(codRecipiente)) {
            bui.append(" ,array_agg(distinct f.rec_kodigo) @> ARRAY[").append(Integer.parseInt(codRecipiente)).append("] as etiquetaDigitada ");
        } else {
            bui.append(" , '' as etiquetaDigitada ");
        }
        bui.append(" , case  when CHAR_LENGTH(rec.rec_descricao) >= 20 then SUBSTR(rec.rec_descricao, 0,20) else rec.rec_descricao end ");
        bui.append(" from examerequisicao a ");
        bui.append(" left join exames b on a.fil_codigo = b.fil_codigo and a.exa_codigo = b.exa_codigo ");
        bui.append(" left join materialcoleta c   on a.fil_codigo = c.fil_codigo and a.mco_codigo = c.mco_codigo ");
        bui.append(" left join examematcoleta d on a.fil_codigo = d.fil_codigo and a.exa_codigo = d.exa_codigo and a.mco_codigo = d.mco_codigo ");
        bui.append(" left join requisicao e on a.fil_codigo = e.fil_codigo and a.req_codigo = e.req_codigo ");
        bui.append(" left join recipcoleta t on \ta.fil_codigo = t.fil_codigo and a.exa_codigo = t.exa_codigo and a.mco_codigo = t.mco_codigo");
        bui.append(" left join examerequisicaorecipiente f on a.fil_codigo = f.fil_codigo and a.exa_codigo = f.exa_codigo and a.req_codigo = f.req_codigo and a.mco_codigo = f.mco_codigo and f.ere_tipo = '").append("C").append("' ");
        bui.append(" left join examematcoletalabexterno g on a.fil_codigo = g.fil_codigo and a.exa_codigo = g.exa_codigo and a.mco_codigo = g.mco_codigo  and g.lae_codigo = ").append(labExterno.codigoLab);
        bui.append(" left join requisicaorequisicao h on a.fil_codigo = h.fil_codigo and a.req_codigo = h.req_kodigo ");
        bui.append(" left join recipientes rec on rec.fil_codigo = a.fil_codigo and rec.rec_codigo = f.rec_kodigo  ");
        bui.append(" left join loteexternorequisicao lotereq on a.fil_codigo = lotereq.fil_codigo   and a.req_codigo = lotereq.req_codigo and  lotereq.lae_codigo = g.lae_codigo ");
        bui.append(" left join loteexternoexamerequisicao lote on a.fil_codigo = lote.fil_codigo and a.exa_codigo = lote.exa_codigo and a.mco_codigo = lote.mco_codigo and a.req_codigo = lote.req_codigo and a.fil_Codigo = lote.fil_codigo ");
        bui.append(" where ");
        bui.append(" a.fil_codigo = ").append(filial).append(" and ");
        bui.append(" a.req_codigo = ").append(requisicao);
        bui.append(" and a.exr_excluido = false ");
        bui.append(" and a.exr_situacao  <> '").append("F").append("'");
        bui.append(" and a.exr_situacao  <> '").append("A").append("'");
        bui.append(" and a.exr_situacao  <> '").append("C").append("'");
        bui.append(" and a.exr_situacao  <> '").append("I").append("'");
        bui.append(" and a.exr_situacao  <> '").append("L").append("'");
        bui.append(" and a.exr_situacao  <> '").append("E").append("'");
        bui.append(" and g.ele_padrao ");
        if (Funcoes.textoVazio(lote)) {
            bui.append(" and (lote.lex_codigo is null or lotereq.leq_retornows is null or lotereq.leq_dataestorno is not null) ");
        } else {
            bui.append(" and (lote.lex_codigo = ").append(lote).append(" )");
        }
        if (somenteConfigurados) {
            bui.append(" and length(coalesce(g.ele_xmllabexterno, '')) > 0 ");
        }
        bui.append(" and coalesce(g.ele_bloqueado, false) = false ");
        bui.append("  group by (CASE WHEN (trim(f.ere_codigoapoiado) != '') THEN cast(trim(f.ere_codigoapoiado) AS varchar) ELSE cast(trim(a.exr_codigoapoiado) AS varchar) END) ");
        bui.append(" ,a.exr_descricaomaterial ");
        bui.append(" ,a.exr_datamaterial ");
        bui.append(" ,a.exr_volumediurese ");
        bui.append(" ,a.exr_situacao ");
        bui.append(" ,b.exa_codigo ");
        bui.append(" ,b.exa_descricao ");
        bui.append(" ,a.exr_urgente ");
        bui.append(" ,a.exr_situacao ");
        bui.append(" ,c.mco_codigo ");
        bui.append(" ,c.mco_abreviatura ");
        bui.append(" ,c.mco_solicitarmat ");
        bui.append(" ,c.mco_descricao ");
        bui.append(" ,g.ele_xmllabexterno ");
        bui.append(" ,a.exr_datamaterial ");
        bui.append(" ,g.ele_diasprazo ");
        bui.append(" ,g.ele_valorexame ");
        bui.append("  ,h.req_codigo ");
        bui.append(" ,a.exr_tempodiurese ");
        bui.append(" ,a.exr_dataloteexterno ");
        bui.append(" ,g.lae_codigo ");
        bui.append(" ,rec.rec_descricao ");
        bui.append(" ,a.fil_codigo ");
        bui.append(" ,a.req_codigo ");
        bui.append(" ,lote.lex_codigo ");
        bui.append(" ,t.rec_codigo ");
        bui.append(" ,g.lae_codigo  ");
        bui.append(" ,a.exr_dataentregaprev ");
        return st.executeQuery(bui.toString());
    }

    public static ResultSet carregarDadosExamesPelaFilial(String filial, String requisicao, String codRecipiente, Statement st, LaboratorioExterno labExterno, boolean somenteConfigurados, String lote) throws SQLException {
        StringBuilder bui = new StringBuilder("select a.fil_codigo, a.req_codigo, lote.lex_codigo, g.lae_codigo, \n");
        bui.append("  (CASE WHEN (trim(f.ere_codigoapoiado) != '') THEN cast(trim(f.ere_codigoapoiado) AS varchar) ELSE cast(trim(a.exr_codigoapoiado) AS varchar) END) AS exr_codigoapoiado, ");
        bui.append("  a.exr_descricaomaterial, a.exr_datamaterial, a.exr_volumediurese, cast(a.exr_tempodiurese as varchar) as ext_tempodiurese, ");
        bui.append("  a.exr_situacao, (a.exr_dataloteexterno is not null) as ").append("exa_exportado").append(", ");
        bui.append("  b.exa_codigo, b.exa_descricao, a.exr_urgente, a.exr_situacao,");
        bui.append("  c.mco_codigo, c.mco_abreviatura, c.mco_solicitarmat, c.mco_descricao, ");
        bui.append("  g.ele_xmllabexterno, a.exr_datamaterial, ");
        bui.append("  g.ele_diasprazo, g.ele_valorexame, h.req_codigo as req_codigomae, ");
        bui.append("  coalesce(g.lae_codigo = ").append(labExterno.codigoLab).append(", false) as ").append("exa_externo");
        bui.append(" ,'' as recipapresentacao ");
        bui.append(" ,(CASE WHEN (t.rec_codigo is not null) then array_agg(distinct cast(t.rec_codigo AS varchar))::varchar[] else null END) as rec_kodigo  ");
        if (!Funcoes.textoVazio(codRecipiente)) {
            bui.append(" ,array_agg(distinct f.rec_kodigo) @> ARRAY[").append(Integer.parseInt(codRecipiente)).append("] as etiquetaDigitada ");
        } else {
            bui.append(" , '' as etiquetaDigitada ");
        }
        bui.append(" , case  when CHAR_LENGTH(rec.rec_descricao) >= 20 then SUBSTR(rec.rec_descricao, 0,20) else rec.rec_descricao end ");
        bui.append(" from examerequisicao a ");
        bui.append(" left join exames b on a.fil_codigo = b.fil_codigo and a.exa_codigo = b.exa_codigo ");
        bui.append(" left join materialcoleta c   on a.fil_codigo = c.fil_codigo and a.mco_codigo = c.mco_codigo ");
        bui.append(" left join examematcoleta d on a.fil_codigo = d.fil_codigo and a.exa_codigo = d.exa_codigo and a.mco_codigo = d.mco_codigo ");
        bui.append(" left join requisicao e on a.fil_codigo = e.fil_codigo and a.req_codigo = e.req_codigo ");
        bui.append(" left join recipcoleta t on\ta.fil_codigo = t.fil_codigo and a.exa_codigo = t.exa_codigo and a.mco_codigo = t.mco_codigo");
        bui.append(" left join examerequisicaorecipiente f on a.fil_codigo = f.fil_codigo and a.exa_codigo = f.exa_codigo and a.req_codigo = f.req_codigo and a.mco_codigo = f.mco_codigo and f.ere_tipo = '").append("C").append("' ");
        bui.append(" left join examematcoletalabexterno g on a.fil_codigo = g.fil_codigo and a.exa_codigo = g.exa_codigo and a.mco_codigo = g.mco_codigo  and g.lae_codigo = ").append(labExterno.codigoLab);
        bui.append(" left join requisicaorequisicao h on a.fil_codigo = h.fil_codigo and a.req_codigo = h.req_kodigo ");
        bui.append(" left join recipientes rec on rec.fil_codigo = a.fil_codigo and rec.rec_codigo = f.rec_kodigo  ");
        bui.append(" left join loteexternorequisicao lotereq on a.fil_codigo = lotereq.fil_codigo   and a.req_codigo = lotereq.req_codigo ");
        bui.append(" left join loteexternoexamerequisicao lote on a.fil_codigo = lote.fil_codigo and a.exa_codigo = lote.exa_codigo and a.mco_codigo = lote.mco_codigo and a.req_codigo = lote.req_codigo and a.fil_Codigo = lote.fil_codigo ");
        bui.append(" where ");
        bui.append(" a.fil_codigo = ").append(filial).append(" and ");
        bui.append(" a.req_codigo = ").append(requisicao);
        bui.append(" and a.exr_excluido = false ");
        bui.append(" and a.exr_situacao  <> '").append("F").append("'");
        bui.append(" and a.exr_situacao  <> '").append("A").append("'");
        bui.append(" and a.exr_situacao  <> '").append("C").append("'");
        bui.append(" and a.exr_situacao  <> '").append("I").append("'");
        bui.append(" and a.exr_situacao  <> '").append("L").append("'");
        bui.append(" and a.exr_situacao  <> '").append("E").append("'");
        bui.append(" and lotereq.leq_dataestorno is null ");
        if (Funcoes.textoVazio(lote)) {
            bui.append(" and (lote.lex_codigo is null or lotereq.leq_retornows is null) ");
        } else {
            bui.append(" and (lote.lex_codigo = ").append(lote).append(" )");
        }
        if (somenteConfigurados) {
            bui.append(" and length(coalesce(g.ele_xmllabexterno, '')) > 0 ");
        }
        bui.append(" and coalesce(g.ele_bloqueado, false) = false ");
        bui.append("  group by (CASE WHEN (trim(f.ere_codigoapoiado) != '') THEN cast(trim(f.ere_codigoapoiado) AS varchar) ELSE cast(trim(a.exr_codigoapoiado) AS varchar) END) ");
        bui.append(" ,a.exr_descricaomaterial ");
        bui.append(" ,a.exr_datamaterial ");
        bui.append(" ,a.exr_volumediurese ");
        bui.append(" ,a.exr_situacao ");
        bui.append(" ,b.exa_codigo ");
        bui.append(" ,b.exa_descricao ");
        bui.append(" ,a.exr_urgente ");
        bui.append(" ,a.exr_situacao ");
        bui.append(" ,c.mco_codigo ");
        bui.append(" ,c.mco_abreviatura ");
        bui.append(" ,c.mco_solicitarmat ");
        bui.append(" ,c.mco_descricao ");
        bui.append(" ,g.ele_xmllabexterno ");
        bui.append(" ,a.exr_datamaterial ");
        bui.append(" ,g.ele_diasprazo ");
        bui.append(" ,g.ele_valorexame ");
        bui.append("  ,h.req_codigo ");
        bui.append(" ,a.exr_tempodiurese ");
        bui.append(" ,a.exr_dataloteexterno ");
        bui.append(" ,g.lae_codigo ");
        bui.append(" ,rec.rec_descricao ");
        bui.append(" ,a.fil_codigo ");
        bui.append(" ,a.req_codigo ");
        bui.append(" ,lote.lex_codigo ");
        bui.append(" ,t.rec_codigo ");
        bui.append(" ,g.lae_codigo  ");
        return st.executeQuery(bui.toString());
    }

    public static Registro carregarDadosRequisicao(Registro reg, String codRecipiente, Map<String, Registro> requisicoes, LaboratorioExterno labExterno, Statement st, boolean isColetaWeb) throws Exception {
        if (labExterno != null && labExterno.protocolo.getExigeDataNascimento() && Funcoes.textoVazio(reg.getString(PAC_DATANASC))) {
            String msg = "O paciente da requisi\u00e7\u00e3o \"" + reg.getString(REQ_CODIGO) + "\" n\u00e3o tem data de nascimento.\nO laborat\u00f3rio externo selecionado exige esse item.";
            Funcoes.mensagem(null, msg, 1);
            return null;
        }
        String lote = reg.getString(LEX_CODIGO);
        if (st != null) {
            try {
                DadosAdicionais dadosAdicionais;
                reg.setValor(LAE_CODIGO, labExterno.codigoLab);
                ResultSet res = IntegracaoLabExterno.carregarDadosExames(reg.getString(FIL_CODIGO), reg.getString(REQ_CODIGO), codRecipiente, st, labExterno, true, lote);
                ArrayList<Registro> exames = new ArrayList<Registro>();
                while (res.next()) {
                    exames.add(new Registro(res));
                }
                if (exames.isEmpty()) {
                    return null;
                }
                if (labExterno.protocolo == Protocolo.DBV2) {
                    reg.setValor("listaexames", exames);
                } else {
                    reg.setValor("listaexames", exames);
                }
                IntegracaoLabExterno.carregarExamesDesmembrados(reg, labExterno, st);
                if (!isColetaWeb && (dadosAdicionais = FabricaExportador.novoDadosAdicionais(labExterno.protocolo)) != null && labExterno.protocolo != Protocolo.DBV2 && labExterno.protocolo != Protocolo.Alvaro && labExterno.protocolo != Protocolo.SoftLab && !dadosAdicionais.carregaAdicionais(labExterno.codigoLab, reg)) {
                    return null;
                }
                return reg;
            }
            catch (Exception e) {
                throw new ThreadDaoException(e.getMessage());
            }
        }
        return null;
    }

    public static Registro carregarDadosRequisicaoPelaFilial(Registro reg, String codRecipiente, Map<String, Registro> requisicoes, LaboratorioExterno labExterno, Statement st, boolean isColetaWeb) throws Exception {
        if (labExterno != null && labExterno.protocolo.getExigeDataNascimento() && Funcoes.textoVazio(reg.getString(PAC_DATANASC))) {
            String msg = "O paciente da requisi\u00e7\u00e3o \"" + reg.getString(REQ_CODIGO) + "\" n\u00e3o tem data de nascimento.\nO laborat\u00f3rio externo selecionado exige esse item.";
            Funcoes.mensagem(null, msg, 1);
            return null;
        }
        String lote = reg.getString(LEX_CODIGO);
        if (st != null) {
            try {
                DadosAdicionais dadosAdicionais;
                reg.setValor(LAE_CODIGO, labExterno.codigoLab);
                ResultSet res = IntegracaoLabExterno.carregarDadosExamesPelaFilial(reg.getString(FIL_CODIGO), reg.getString(REQ_CODIGO), codRecipiente, st, labExterno, true, lote);
                ArrayList<Registro> exames = new ArrayList<Registro>();
                while (res.next()) {
                    exames.add(new Registro(res));
                }
                if (exames.isEmpty()) {
                    return null;
                }
                if (labExterno.protocolo == Protocolo.DBV2) {
                    reg.setValor("listaexames", exames);
                } else {
                    reg.setValor("listaexames", exames);
                }
                IntegracaoLabExterno.carregarExamesDesmembrados(reg, labExterno, st);
                if (!isColetaWeb && (dadosAdicionais = FabricaExportador.novoDadosAdicionais(labExterno.protocolo)) != null && labExterno.protocolo != Protocolo.DBV2 && labExterno.protocolo != Protocolo.JalisWS && !dadosAdicionais.carregaAdicionais(labExterno.codigoLab, reg)) {
                    return null;
                }
                return reg;
            }
            catch (Exception e) {
                throw new ThreadDaoException(e.getMessage());
            }
        }
        return null;
    }

    public static String getChave(Registro reg) {
        return Funcoes.preencheZero(reg.getInt(FIL_CODIGO), ParametrosGerais.getDigitosTuboFilial()).concat(Funcoes.preencheZero(reg.getInt(REQ_CODIGO), ParametrosGerais.getDigitosTuboRequisicao()));
    }

    public static ArrayList<Registro> pegaExamesRequisicao(Statement st, LaboratorioExterno laboratorioExterno, String requisicao, String filialDaRequisicao, String lote, int agruparInterface) throws Exception {
        ArrayList<Registro> retorno = new ArrayList<Registro>();
        String tipoReciepente = "C";
        if (agruparInterface == 1) {
            tipoReciepente = "T";
        }
        StringBuilder buf = new StringBuilder("select a.fil_codigo, a.fil_kodigo, pac.pac_cpf, pac.pac_rg, pac.pac_datanasc, pac.pac_cartaosus, pac.pac_dum, a.exa_codigo, a.mco_codigo, b.mco_abreviatura, c.exa_descricao, a.req_codigo ");
        buf.append(" , e.exr_descricaomaterial, e.exr_datamaterial, e.exr_volumediurese, cast(e.exr_tempodiurese as varchar) as exr_tempodiurese, f.ele_xmllabexterno as ele_xmllabexterno ");
        buf.append(" , (CASE WHEN (trim(err.ere_codigoapoiado) != '') THEN cast(trim(err.ere_codigoapoiado) AS varchar) ELSE cast(trim(e.exr_codigoapoiado) AS varchar) END) AS exr_codigoapoiado ");
        buf.append(" , (CASE WHEN (err.rec_kodigo is not null) then array_agg(distinct cast(err.rec_kodigo AS varchar))::varchar[] else null END) as rec_kodigo ");
        buf.append(" , case  when CHAR_LENGTH(rec.rec_descricao) >= 20 then SUBSTR(rec.rec_descricao, 0,20) else rec.rec_descricao end ");
        buf.append(" , med.med_nome, med.med_crm, med.med_conselho, med.med_uf  ");
        buf.append("from loteexternoexamerequisicao a ");
        buf.append(" LEFT join examerequisicaorecipiente err on a.fil_kodigo = err.fil_codigo and a.exa_codigo = err.exa_codigo and a.req_codigo = err.req_codigo and a.mco_codigo = err.mco_codigo and err.ere_tipo = '").append(tipoReciepente).append("' ");
        buf.append(" LEFT join examematcoleta d on a.fil_kodigo = d.fil_codigo and a.exa_codigo = d.exa_codigo and a.mco_codigo = d.mco_codigo ");
        buf.append(" LEFT join exames c on a.fil_codigo = c.fil_codigo and a.exa_codigo = c.exa_codigo ");
        buf.append(" LEFT join materialcoleta b on a.fil_codigo = b.fil_codigo and a.mco_codigo = b.mco_codigo ");
        buf.append(" JOIN examerequisicao e on a.fil_kodigo = e.fil_codigo and a.req_codigo = e.req_codigo and a.exa_codigo = e.exa_codigo and a.mco_codigo = e.mco_codigo ");
        buf.append(" LEFT join examematcoletalabexterno f on d.fil_codigo = f.fil_codigo and d.exa_codigo = f.exa_codigo and d.mco_codigo = f.mco_codigo ");
        buf.append(" LEFT join recipientes rec on rec.fil_codigo = a.fil_codigo and rec.rec_codigo = err.rec_kodigo  ");
        buf.append(" LEFT JOIN requisicao req ON e.fil_codigo = req.fil_codigo AND e.req_codigo = req.req_codigo ");
        buf.append(" LEFT JOIN paciente pac ON req.fil_codigo = pac.fil_codigo AND req.pac_codigo = pac.pac_codigo ");
        buf.append(" LEFT JOIN medico   med ON med.fil_codigo = req.fil_codigo AND med.med_conselho = req.med_conselho AND med.med_crm = req.med_crm and med.med_uf = req.med_uf  ");
        buf.append("where a.fil_codigo = ").append(Variaveis.filialPadrao);
        buf.append(" and a.fil_kodigo = ").append(filialDaRequisicao);
        buf.append(" and a.req_codigo = ").append(requisicao);
        buf.append(" and a.lex_codigo = ").append(lote);
        buf.append(" and f.lae_codigo = ").append(laboratorioExterno.codigoLab);
        buf.append(" and (a.ler_datahoraestorno is null and a.usr_codestorno is null) ");
        buf.append(" group by a.fil_codigo,");
        buf.append("  a.fil_kodigo, ");
        buf.append("  a.exa_codigo, ");
        buf.append("  a.mco_codigo, ");
        buf.append("  b.mco_abreviatura, ");
        buf.append("  c.exa_descricao , ");
        buf.append("  e.exr_descricaomaterial, ");
        buf.append("  e.exr_datamaterial, ");
        buf.append("  e.exr_volumediurese, ");
        buf.append("  f.ele_xmllabexterno , ");
        buf.append("  e.exr_descricaomaterial, ");
        buf.append("  e.exr_datamaterial, ");
        buf.append("  e.exr_volumediurese, ");
        buf.append("  e.exr_tempodiurese, ");
        buf.append("  err.ere_codigoapoiado, ");
        buf.append("  e.exr_codigoapoiado, ");
        buf.append("  err.rec_kodigo, ");
        buf.append("  a.req_codigo, ");
        buf.append("  rec.rec_descricao, pac.pac_cpf, pac.pac_rg, pac.pac_datanasc, pac.pac_cartaosus, pac.pac_dum, ");
        buf.append("  med.med_nome, med.med_conselho, med.med_crm, med.med_uf ");
        if (laboratorioExterno.protocolo == Protocolo.DBV2) {
            buf.append(" ,e.exr_ordem order by e.exr_ordem asc ");
        }
        ResultSet rs = st.executeQuery(buf.toString());
        while (rs.next()) {
            ArrayList<Registro> solicitantes = new ArrayList<Registro>();
            Registro exame = new Registro(rs);
            Registro med = new Registro();
            med.setValor("medicoCRM", rs.getString("med_crm"));
            med.setValor("ufMedico", rs.getString("med_uf"));
            med.setValor("conselhoMedico", rs.getString("med_conselho"));
            solicitantes.add(med);
            exame.setValor("solicitantes", solicitantes);
            retorno.add(exame);
        }
        return retorno;
    }

    public RetornoCriarLote reenviarLote(String lote, LaboratorioExterno labExterno, String filial, List<Registro> dadosLote, int ordenacao, boolean isColetaWeb, int agruparInterface, Statement st, Statement st2, Statement st3, String variaveisLogin, boolean agruparGuiasInterface, String imprimirEtiquetaTriagemSemMaterial, boolean imprimirEtiquetaColetaSemMaterial, boolean imprimirEtiquetaColetaSelecionadaSemMaterial, boolean agruparEtqPorQtde, String tipoExportacaoInterface, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario, String tipoIntegracao, String tamanhoNomeImpressora, String[] impressorasLocais, ImpressorasLabExterno impressoras, String tipoEtiquetaSoroteca, Callable<Boolean> arquivar, Callable<Boolean> anular, String login) {
        RetornoCriarLote retornoLote = new RetornoCriarLote();
        ArrayList<Registro> requisicao = new ArrayList<Registro>();
        try {
            Exportador exp = FabricaExportador.novoExportador(labExterno.protocolo);
            if (exp != null) {
                String xmlConfiguracao = labExterno.configuracao;
                if (this.isLabSaoMarcos(labExterno)) {
                    if (!this.validarConexao(filial, labExterno, st, isColetaWeb)) {
                        retornoLote.setSucesso(false);
                        return retornoLote;
                    }
                    xmlConfiguracao = IntegracaoLabExterno.atualizaConfiguracao(labExterno.codigoLab, st);
                }
                if (labExterno.protocolo == Protocolo.HPardini) {
                    retornoLote = this.exportaExamesHPardini(dadosLote, labExterno, lote, ordenacao, exp, isColetaWeb, agruparInterface, st, st2, st3, variaveisLogin, agruparGuiasInterface, imprimirEtiquetaTriagemSemMaterial, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, agruparEtqPorQtde, tipoExportacaoInterface, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, tuboPrimario, utilizarCapacidadeTuboPrimario, tipoIntegracao, tamanhoNomeImpressora, impressorasLocais, impressoras, tipoEtiquetaSoroteca, arquivar, anular, filial, login);
                    return retornoLote;
                }
                List<Registro> requisicoes = IntegracaoLabExterno.agruparMutiguia(dadosLote, st, agruparGuiasInterface, digitosTuboFilial);
                boolean exportou = false;
                if (labExterno.protocolo == Protocolo.Alvaro) {
                    for (Registro req : requisicoes) {
                        requisicao.add(req);
                        RetornoImpressaoEtiquetas retorno = exp.exportarExames(labExterno.codigoLab, lote, xmlConfiguracao, true, requisicao, ordenacao, isColetaWeb, agruparInterface, st, st2, st3, variaveisLogin, agruparGuiasInterface, imprimirEtiquetaTriagemSemMaterial, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, agruparEtqPorQtde, tipoExportacaoInterface, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, tuboPrimario, utilizarCapacidadeTuboPrimario, tipoIntegracao, tamanhoNomeImpressora, impressorasLocais, impressoras, tipoEtiquetaSoroteca, arquivar, anular, labExterno, labExterno.agruparMultiguias);
                        exportou = retorno.isImprimiu();
                        retornoLote.setRetornoEtiquetas(retorno);
                    }
                } else {
                    for (Registro req : requisicoes) {
                        requisicao.add(req);
                    }
                    RetornoImpressaoEtiquetas retorno = exp.exportarExames(labExterno.codigoLab, lote, xmlConfiguracao, true, requisicao, ordenacao, isColetaWeb, agruparInterface, st, st2, st3, variaveisLogin, agruparGuiasInterface, imprimirEtiquetaTriagemSemMaterial, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, agruparEtqPorQtde, tipoExportacaoInterface, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, tuboPrimario, utilizarCapacidadeTuboPrimario, tipoIntegracao, tamanhoNomeImpressora, impressorasLocais, impressoras, tipoEtiquetaSoroteca, arquivar, anular, labExterno, labExterno.agruparMultiguias);
                    exportou = retorno.isImprimiu();
                    retornoLote.setSucesso(exportou);
                    retornoLote.setRetornoEtiquetas(retorno);
                }
                if (exportou) {
                    requisicoes = IntegracaoLabExterno.carregarLote(isColetaWeb, Integer.parseInt(lote), labExterno, filial, st, st2, false, agruparInterface);
                    int colunaOrdenacao = -1;
                    if (labExterno.protocolo == Protocolo.DBV2) {
                        colunaOrdenacao = -10;
                    }
                    byte[] relatorio = exp.imprimeRelatorio(isColetaWeb, labExterno.codigoLab, String.valueOf(lote), requisicoes, colunaOrdenacao, st, Integer.parseInt(filial), digitosTuboRequisicao, digitosTuboFilial, impressoras.getImpressoraRelatorio());
                    retornoLote.setSucesso(exportou);
                    retornoLote.setRelatorioLote(relatorio);
                }
                retornoLote.setSucesso(exportou);
                return retornoLote;
            }
            String texto = "O protocolo do lote n\u00e3o permite o reenvio das requisi\u00e7\u00f5es";
            if (isColetaWeb) {
                retornoLote.setMensagem(texto);
            } else {
                Funcoes.mensagem(Laboratorio.getInstancia(), texto, 1);
            }
        }
        catch (Exception ex) {
            String mensagem = "N\u00e3o foi poss\u00edvel reenviar o lote.\n" + ex.getMessage();
            if (isColetaWeb) {
                retornoLote.setMensagem(mensagem);
            }
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), mensagem, ex.getStackTrace());
        }
        retornoLote.setSucesso(false);
        return retornoLote;
    }

    private RetornoCriarLote exportaExamesHPardini(List<Registro> dadosLote, LaboratorioExterno labExterno, String lote, int ordenacao, Exportador exp, boolean isColetaWeb, int agruparInterface, Statement st, Statement st2, Statement st3, String variaveisLogin, boolean agruparGuiasInterface, String imprimirEtiquetaTriagemSemMaterial, boolean imprimirEtiquetaColetaSemMaterial, boolean imprimirEtiquetaColetaSelecionadaSemMaterial, boolean agruparEtqPorQtde, String tipoExportacaoInterface, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario, String tipoIntegracao, String tamanhoNomeImpressora, String[] impressorasLocais, ImpressorasLabExterno impressoras, String tipoEtiquetaSoroteca, Callable<Boolean> arquivar, Callable<Boolean> anular, String filial, String login) throws Exception {
        String xmlConfiguracao = labExterno.configuracao;
        RetornoCriarLote retornoLote = new RetornoCriarLote();
        RetornoImpressaoEtiquetas retorno = exp.exportarExames(labExterno.codigoLab, lote, xmlConfiguracao, true, dadosLote, ordenacao, isColetaWeb, agruparInterface, st, st2, st3, variaveisLogin, agruparGuiasInterface, imprimirEtiquetaTriagemSemMaterial, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, agruparEtqPorQtde, tipoExportacaoInterface, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, tuboPrimario, utilizarCapacidadeTuboPrimario, tipoIntegracao, tamanhoNomeImpressora, impressorasLocais, impressoras, tipoEtiquetaSoroteca, arquivar, anular, labExterno, labExterno.agruparMultiguias);
        boolean exportou = retorno.isImprimiu();
        retornoLote.setSucesso(exportou);
        retornoLote.setRetornoEtiquetas(retorno);
        if (exportou) {
            dadosLote = IntegracaoLabExterno.carregarLote(isColetaWeb, Integer.parseInt(lote), labExterno, Variaveis.filialPadrao, st, st2, false, agruparInterface);
            int colunaOrdenacao = -1;
            if (labExterno.protocolo == Protocolo.DBV2) {
                colunaOrdenacao = -10;
            }
            byte[] relatorio = exp.imprimeRelatorio(isColetaWeb, labExterno.codigoLab, String.valueOf(lote), dadosLote, colunaOrdenacao, st, Integer.parseInt(filial), digitosTuboRequisicao, digitosTuboFilial, impressoras.getImpressoraRelatorio());
            retornoLote.setRelatorioLote(relatorio);
        }
        retornoLote.setSucesso(exportou);
        return retornoLote;
    }

    protected boolean validarConexao(String filial, LaboratorioExterno labExterno, Statement st, boolean isColetaWeb) {
        ConexaoSaoMarcos conexao = new ConexaoSaoMarcos();
        return conexao.validaToken(filial, labExterno, st, isColetaWeb);
    }

    protected boolean isLabSaoMarcos(LaboratorioExterno labExterno) {
        return labExterno.protocolo == Protocolo.SaoMarcos;
    }

    public static String atualizaConfiguracao(String codigoLab, Statement st) {
        String sql = "";
        if (st != null) {
            try {
                StringBuilder bui = new StringBuilder("select lae_configuracao ");
                bui.append("from labexterno \n");
                bui.append("where fil_codigo = ").append(Variaveis.filialPadrao);
                bui.append(" and lae_codigo =  ").append(codigoLab);
                sql = bui.toString();
                ResultSet res = st.executeQuery(sql);
                if (res.next()) {
                    return res.getString("lae_configuracao");
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(null, e.getMessage() + "\nSQL: " + sql, e.getStackTrace(), "CriaLoteExportacao:");
            }
        }
        return "";
    }

    public JFileChooser gerarArquivo(String xml, File file, boolean reenvio, String descricaoFilter) {
        JFileChooser chooser = ComponenteFactory.novoJFileChooser(null, Variaveis.ultimoDiretorioDialogo != null ? Variaveis.ultimoDiretorioDialogo.getAbsolutePath() : null, reenvio ? null : "Lote j\u00e1 foi criado se necessitar gerar o arquivo utilize a op\u00e7\u00e3o de reenvio de lote!");
        chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
        chooser.setSelectedFile(file);
        chooser.setFileFilter(ComponenteFactory.novoFileFilter(descricaoFilter, "xml"));
        if (!Funcoes.textoVazio(xml)) {
            boolean continuar;
            int option = -1;
            option = chooser.showOpenDialog(null);
            boolean bl = continuar = option == 0;
            if (continuar) {
                try {
                    StringUtil.escreverArquivoTexto(chooser.getSelectedFile().getPath(), xml);
                }
                catch (Exception e) {
                    ErrorLogger.mostraMensagem(null, "N\u00e3o foi poss\u00edvel exportar o arquivo.\nMensagem: " + e.getMessage(), e.getStackTrace());
                }
            }
        }
        return chooser;
    }

    public String retornaCodigoLote(String codigoLab, Statement st) {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("select nextval('codigolote_");
            sb.append(Variaveis.filialPadrao).append("_");
            sb.append(codigoLab);
            sb.append("_sequence') as codigo");
            ResultSet rs = st.executeQuery(sb.toString());
            rs.next();
            return Variaveis.filialPadrao + Funcoes.preencheZero(rs.getString("codigo"), 7);
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(null, e.getMessage() + "\nSQL: ", e.getStackTrace(), "CriaLoteExportacao:");
            return "0";
        }
    }

    public static void setListaEstornados(HashMap<String, String> listaEstornados) {
        IntegracaoLabExterno.listaEstornados = listaEstornados;
    }

    static {
        examesDesm = new ArrayList();
    }

    class ListaRegistro
    extends ArrayList<Registro> {
        ListaRegistro() {
        }

        @Override
        public boolean add(Registro a) {
            boolean isExiste = false;
            for (Registro b : this) {
                if (!b.getString(IntegracaoLabExterno.EXA_CODIGO).equalsIgnoreCase(a.getString(IntegracaoLabExterno.EXA_CODIGO)) || !b.getString(IntegracaoLabExterno.MCO_CODIGO).equalsIgnoreCase(a.getString(IntegracaoLabExterno.MCO_CODIGO))) continue;
                isExiste = true;
                break;
            }
            if (isExiste) {
                return false;
            }
            return super.add(a);
        }
    }
}

