/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.externo.exportadores;

import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.relatorios.apoio.RelatorioSituacaoLote;
import jalis.laboratorio.triagem.externo.Exportador;
import jalis.laboratorio.triagem.externo.LaboratorioExterno;
import jalis.laboratorio.triagem.externo.exportadores.ExameMaterialUnilab;
import jalis.laboratorio.triagem.externo.exportadores.IntegracaoLabExterno;
import jalis.laboratorio.util.impressao.Impressao;
import jalis.laboratorio.util.impressao.RetornoImpressaoEtiquetas;
import jalis.laboratorio.util.impressao.labexterno.ImpressorasLabExterno;
import jalis.laboratorio.util.parsers.unilab.ExameUnilab;
import jalis.laboratorio.util.parsers.unilab.ServiceImportacaoUnilab;
import jalis.relatorio.Gerador;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.File;
import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.table.TableModel;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.PeriodType;
import org.joda.time.ReadableInstant;

public class ExportacaoParaUnilab
extends IntegracaoLabExterno
implements Exportador {
    private XMLStringBuilder xml = new XMLStringBuilder(false);
    private ServiceImportacaoUnilab siu = new ServiceImportacaoUnilab();

    @Override
    public String getTagCodigo() {
        return "convenio";
    }

    @Override
    public RetornoImpressaoEtiquetas exportarExames(String codLabExterno, String numeroLote, String configuracaoLabExterno, boolean reenvio, List<Registro> requisicoes, int colunaOrdenacao, boolean isColetaWeb, int agruparInterface, Statement st, Statement st2, Statement st3, String variaveisLogin, boolean agruparGuiasInterface, String imprimirEtiquetaTriagemSemMaterial, boolean imprimirEtiquetaColetaSemMaterial, boolean imprimirEtiquetaColetaSelecionadaSemMaterial, boolean agruparEtqPorQtde, String tipoExportacaoInterface, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario, String tipoIntegracao, String tamanhoNomeImpressora, String[] impressorasLocais, ImpressorasLabExterno impressoras, String tipoEtiquetaSoroteca, Callable<Boolean> arquivar, Callable<Boolean> anular, LaboratorioExterno labExterno, boolean agruparMultiguia) {
        RetornoImpressaoEtiquetas retorno = new RetornoImpressaoEtiquetas();
        ArrayList<Registro> lista = new ArrayList<Registro>();
        for (Registro requisicao : requisicoes) {
            lista.add(requisicao.clone());
        }
        try {
            this.criarEtiquetas(isColetaWeb, lista, agruparInterface, st, st2, st3, Variaveis.login, agruparGuiasInterface, imprimirEtiquetaTriagemSemMaterial, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, agruparEtqPorQtde, tipoExportacaoInterface, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, tuboPrimario, utilizarCapacidadeTuboPrimario, arquivar);
        }
        catch (Exception e1) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel gerar etiquetas.\n", e1.getStackTrace());
        }
        try {
            for (Registro registro : requisicoes) {
                ArrayList listaExames = (ArrayList)registro.getValor("listaexames");
                ArrayList<String> listExa = new ArrayList<String>();
                int[] arrayMat = new int[listaExames.size()];
                for (Registro exa : listaExames) {
                    listExa.add(exa.getString("exa_codigo"));
                    arrayMat[listExa.size() - 1] = exa.getInt("mco_codigo");
                }
                Arrays.copyOf(listExa.toArray(), listExa.toArray().length, String[].class);
            }
            String convenio = StringUtil.getValor(configuracaoLabExterno, "convenio");
            String arquivoNome = this.geraNomeArquivoLote(numeroLote, convenio);
            this.gerarXML(numeroLote, configuracaoLabExterno, requisicoes, arquivoNome, st, agruparGuiasInterface, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo);
            if (!isColetaWeb) {
                this.gerarArquivo(this.xml.getXML(), new File(arquivoNome + ".u2u"), reenvio, "Arquivo de exporta\u00e7\u00e3o Unilab (*.u2u)");
            } else {
                retorno.setNomeArquivoLote(arquivoNome);
                retorno.setXmlLote(this.xml.getXML());
                retorno.setExtensaoArquivo("u2u");
            }
            retorno.setImprimiu(true);
            return retorno;
        }
        catch (Exception ex) {
            try {
                if (!reenvio) {
                    ExportacaoParaUnilab.removerLote(codLabExterno, lista, numeroLote, st, isColetaWeb, arquivar, agruparInterface);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (ex.getMessage() != null) {
                Funcoes.mensagem(Laboratorio.getInstancia(), ex.getMessage(), 2);
            }
            retorno.setImprimiu(false);
            return retorno;
        }
    }

    @Override
    public JFileChooser gerarArquivo(String xml, File file, boolean reenvio, String descricaoFilter) {
        JFileChooser chooser = ComponenteFactory.novoJFileChooser(null, Variaveis.ultimoDiretorioDialogo != null ? Variaveis.ultimoDiretorioDialogo.getAbsolutePath() : null, reenvio ? null : "Lote j\u00e1 foi criado se necessitar gerar o arquivo utilize a op\u00e7\u00e3o de reenvio de lote!");
        chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
        chooser.setSelectedFile(file);
        chooser.setFileFilter(ComponenteFactory.novoFileFilter(descricaoFilter, "u2u"));
        if (!Funcoes.textoVazio(xml)) {
            boolean continuar;
            int option = -1;
            option = chooser.showOpenDialog(null);
            boolean bl = continuar = option == 0;
            if (continuar) {
                try {
                    StringUtil.compactarParaZip(chooser.getSelectedFile().getPath(), StringUtil.criarArquivo(this.tirarExtensao(file), xml), this.tirarExtensao(file) + ".xml");
                }
                catch (Exception e) {
                    ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
                }
            }
        }
        return chooser;
    }

    private String tirarExtensao(File file) {
        return file.toString().substring(0, file.toString().indexOf("."));
    }

    private String geraNomeArquivoLote(String numeroLote, String convenio) {
        Date data = new Date();
        String dataArq = Funcoes.formataData("yyyyMMdd_HHmm", data);
        StringBuilder nomeArq = new StringBuilder();
        String arquivoNome = "E" + convenio + numeroLote + dataArq;
        nomeArq.append("E");
        nomeArq.append(Funcoes.preencheZero(convenio, 4));
        nomeArq.append(Funcoes.preencheZero(numeroLote, 9));
        nomeArq.append("_");
        nomeArq.append(dataArq);
        return nomeArq.toString();
    }

    private void gerarXML(String numeroLote, String configuracaoLabExterno, List<Registro> requisicoes, String nomeArquivo, Statement st, boolean agruparGuiasInterface, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo) throws XMLStringBuilderException, ParseException, SQLException {
        String convenio = StringUtil.getValor(configuracaoLabExterno, "convenio");
        int postoColeta = StringUtil.getInt(configuracaoLabExterno, "postoColeta");
        this.xml.escreveHeader("1.0", "ISO-8859-1");
        this.xml.abrir("loteenvio");
        this.xml.escrever("versao", "1");
        String codigoConvenio = StringUtil.getValor(configuracaoLabExterno, "convenio");
        this.xml.escrever("convenio", !Funcoes.textoVazio(convenio) ? convenio : codigoConvenio);
        this.xml.escrever("datageracaolote", Funcoes.formataData("dd/MM/yyyy HH:mm:kk", new Date()));
        this.xml.escrever("datageracaoarquivo", Funcoes.formataData("dd/MM/yyyy HH:mm:kk", new Date()));
        this.xml.escrever("nomearquivo", nomeArquivo);
        this.xml.abrir("pedidos");
        List<Registro> requisicoesPais = ExportacaoParaUnilab.agruparMutiguia(requisicoes, st, agruparGuiasInterface, digitosTuboFilial);
        for (Registro req : requisicoesPais) {
            this.criarPedido(req, convenio, numeroLote, postoColeta, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo);
        }
        this.xml.fechar("pedidos");
        this.xml.fechar("loteenvio");
    }

    private void criarPedido(Registro req, String codigoConvenio, String numeroLote, int postoColeta, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo) throws XMLStringBuilderException, ParseException, SQLException {
        this.xml.abrir("pedido");
        this.xml.escrever("codigo", Funcoes.preencheZero(req.getString(this.siu.FIL_CODIGO), digitosTuboFilial) + Funcoes.preencheZero(req.getString("req_codigo"), digitosTuboRequisicao));
        this.xml.abrir("paciente");
        this.xml.escrever("codigo", req.getString(this.siu.PAC_CODIGO));
        this.xml.escrever("nome", StringUtil.preencheCData(req.getString(this.siu.PAC_NOME).trim(), true));
        this.xml.escrever("sexo", req.getString(this.siu.PAC_SEXO));
        this.xml.escrever("lactante", "N");
        this.xml.escrever("histerectomizada", "N");
        if (req.nulo(this.siu.PAC_DATANASC)) {
            this.xml.escrever(this.getTagIdadePaciente(req), req.getString(this.siu.REQ_IDADE));
        } else {
            this.xml.escrever("idade", ExportacaoParaUnilab.getIdadePorExtenso(Funcoes.formataData("dd/MM/yyyy", req.getDate(this.siu.PAC_DATANASC)), Funcoes.formataData("dd/MM/yyyy", new Date())));
        }
        if (req.possuiCampo(this.siu.REQ_PESO) && req.getDouble(this.siu.REQ_PESO) > 0.0) {
            this.xml.escrever("peso", Funcoes.formataDecimal(req.getDouble(this.siu.REQ_PESO), 1));
        }
        if (req.possuiCampo(this.siu.REQ_ALTURA) && req.getDouble(this.siu.REQ_ALTURA) > 0.0) {
            this.xml.escrever("altura", Funcoes.formataDecimal(req.getDouble(this.siu.REQ_ALTURA), 2));
        }
        if (req.getString(this.siu.PAC_SEXO).equalsIgnoreCase("F") && req.getDate(this.siu.REQ_DUM) != null) {
            this.xml.escrever("dum", Funcoes.formataData(req.getDate(this.siu.REQ_DUM)));
        }
        this.xml.fechar("paciente");
        this.xml.abrir("medico");
        this.xml.escrever("codigo", req.getString(this.siu.MED_CRM));
        this.xml.escrever("conselho", req.getString(this.siu.MED_CONSELHO));
        this.xml.escrever("nome", req.getString(this.siu.MED_NOME));
        this.xml.escrever("numeronoconselho", req.getString(this.siu.MED_CRM));
        this.xml.escrever("sexo", this.siu.pegaSexoMedico(req.getString(this.siu.FIL_CODIGO), req.getString(this.siu.MED_CRM), req.getString(this.siu.MED_UF), req.getString(this.siu.MED_CONSELHO)));
        this.xml.fechar("medico");
        if (!Funcoes.textoVazio(req.getString(this.siu.REQ_OBSERVACAO))) {
            this.xml.escrever("observacao", req.getString(this.siu.REQ_OBSERVACAO));
        }
        List listaExames = (List)req.getValor("listaexames");
        Map<ExameMaterialUnilab, Integer> exaUnilab = null;
        ArrayList<String> listaExamesAdicionados = new ArrayList<String>();
        this.xml.abrir("exames");
        int sequencia = 1;
        for (Registro exa : listaExames) {
            String key = exa.getString("exa_codigo") + exa.getString("mco_codigo");
            if (listaExamesAdicionados.contains(key)) continue;
            List listaExamesDesmembrados = (List)exa.getValor("listaexames");
            if (listaExamesDesmembrados != null && listaExamesDesmembrados.size() > 0) {
                exaUnilab = this.carregarExamesUnilab(listaExamesDesmembrados);
                for (Registro desm : listaExamesDesmembrados) {
                    key = desm.getString("exa_codigo") + "|" + desm.getString("mco_codigo");
                    if (listaExamesAdicionados.contains(key)) continue;
                    this.gravarDadosExame(desm, exaUnilab, req, codigoConvenio, numeroLote, postoColeta, sequencia, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo);
                    listaExamesAdicionados.add(key);
                }
            } else {
                exaUnilab = this.carregarExamesUnilab(listaExames);
                this.gravarDadosExame(exa, exaUnilab, req, codigoConvenio, numeroLote, postoColeta, sequencia, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo);
                listaExamesAdicionados.add(key);
            }
            ++sequencia;
        }
        this.xml.fechar("exames");
        this.xml.fechar("pedido");
    }

    private void gravarDadosExame(Registro exa, Map<ExameMaterialUnilab, Integer> exaMaricondi, Registro req, String convenio, String numeroLote, int postoColeta, int sequencia, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo) throws XMLStringBuilderException, ParseException, SQLException {
        this.xml.abrir("exame");
        ExameMaterialUnilab exaMat = new ExameMaterialUnilab(exa.getString(this.siu.CODIGO_EXAME), exa.getString(this.siu.CODIGO_MATERIAL));
        this.xml.escrever("idapoiado", exa.getString(this.siu.EXA_CODIGO) + "|" + exa.getString(this.siu.MCO_CODIGO));
        this.xml.escrever("numeroamostra", this.geraNumeroAmostraJalis(req.getString(this.siu.FIL_CODIGO), req.getString(this.siu.REQ_CODIGO), (Array)exa.getValor(this.siu.REC_KODIGO), digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo));
        this.xml.escrever("mnemonico", exaMat.exame);
        this.xml.escrever("nomematerialbiologico", exa.getString("nomematerialbiologico"));
        this.xml.escrever("datahoracoleta", Funcoes.formataData("dd/MM/yyyy HH:mm", exa.getDate(this.siu.EXR_DATAMATERIAL)));
        this.xml.escrever("urgente", exa.getBoolean("exr_urgente") ? "S" : "N");
        this.xml.fechar("exame");
    }

    private String geraNumeroAmostraJalis(String filial, String requisicao, Array recipientes, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo) throws SQLException {
        String[] valores;
        StringBuilder numeroAmostra = new StringBuilder();
        numeroAmostra.append(Funcoes.preencheZero(filial, digitosTuboFilial));
        numeroAmostra.append(Funcoes.preencheZero(requisicao, digitosTuboRequisicao));
        if (recipientes != null && (valores = (String[])recipientes.getArray()) != null && valores.length > 0) {
            numeroAmostra.append(Funcoes.preencheZero(valores[0], digitosTuboTubo));
        }
        return numeroAmostra.toString();
    }

    private String geraNumeroAmostra(String convenio, int postoColeta, int sequencia) {
        StringBuilder numeroAmostra = new StringBuilder();
        numeroAmostra.append(Funcoes.preencheZero(convenio, 4));
        numeroAmostra.append(Funcoes.preencheZero(postoColeta, 2));
        numeroAmostra.append(Funcoes.preencheZero(sequencia, 4));
        return numeroAmostra.toString();
    }

    protected String getTagIdadePaciente(Registro req) {
        if (req.getString("req_anomes").equalsIgnoreCase("A")) {
            return "IdadeAno";
        }
        if (req.getString("req_anomes").equalsIgnoreCase("M")) {
            return "IdadeMes";
        }
        return "IdadeDia";
    }

    protected Map<ExameMaterialUnilab, Integer> carregarExamesUnilab(List<Registro> exames) {
        HashMap<ExameMaterialUnilab, Integer> map = new HashMap<ExameMaterialUnilab, Integer>();
        for (Registro exa : exames) {
            ExameUnilab exameUnilab = ExameUnilab.novaInstancia(exa.getString("ele_xmllabexterno"));
            if (exameUnilab != null) {
                exa.setValor(this.siu.CODIGO_EXAME, exameUnilab.getMnemonico());
                exa.setValor(this.siu.CODIGO_MATERIAL, exameUnilab.getCodigoMtbi());
                exa.setValor("nomematerialbiologico", exameUnilab.getNomemtbi());
            }
            map.put(new ExameMaterialUnilab(exameUnilab.getCodigo(), exameUnilab.getMaterialJalis()), 0);
        }
        return map;
    }

    @Override
    public int getMaiorCodigoLote(String numeroLote, String codigoConvenio, LaboratorioExterno labExterno, Statement st) {
        try {
            ResultSet rs = st.executeQuery("select max(lex_codigo) + 1 as codigo from loteexterno where lae_codigo = " + labExterno.codigoLab + " and fil_codigo = " + Variaveis.filialPadrao);
            if (rs.next()) {
                return rs.getInt("codigo");
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return 0;
    }

    public static String getIdadePorExtenso(String dataNascimento, String dataAtual) {
        if (!Funcoes.textoVazio(dataNascimento)) {
            DateTime dateTime = new DateTime((Object)Funcoes.stringToDate(dataNascimento));
            DateTime dateTimeFinal = new DateTime((Object)(!Funcoes.textoVazio(dataAtual) ? Funcoes.stringToDate(dataAtual) : Calendar.getInstance().getTime()));
            Period period = new Period((ReadableInstant)dateTime, (ReadableInstant)dateTimeFinal, PeriodType.yearMonthDay());
            StringBuilder buf = new StringBuilder();
            if (period.getYears() > 0) {
                buf.append(period.getYears() + "A");
            }
            if (period.getMonths() > 0) {
                buf.append(buf.length() > 0 ? " " : "").append(period.getMonths() + "M");
            }
            if (period.getDays() > 0) {
                buf.append(buf.length() > 0 ? " " : "").append(period.getDays() + "D");
            }
            return buf.toString();
        }
        return "";
    }

    @Override
    public byte[] imprimeRelatorio(boolean isColetaWeb, String codLabExterno, String numeroLote, List<Registro> requisicoesListaOriginal, int colunaOrdenacao, Statement st, int filialPadrao, int digitosTuboRequisicao, int digitosTuboFilial, String impressoraRelatorio) throws Exception {
        RelatorioSituacaoLote rel = new RelatorioSituacaoLote();
        ModeloGridTable modelo = rel.getModeloDados(st, new String[]{String.valueOf(numeroLote)}, new String[]{String.valueOf(codLabExterno)}, colunaOrdenacao, requisicoesListaOriginal, filialPadrao, digitosTuboRequisicao, digitosTuboFilial);
        if (modelo.getRowCount() > 0) {
            Gerador gerador = new Gerador(impressoraRelatorio);
            HashMap<String, Object> variaveis = new HashMap<String, Object>();
            variaveis.put("filtroLote", numeroLote);
            String xmlRelatorio = rel.getXMLRelatorio(st);
            if (!isColetaWeb) {
                JDialog dialogo = new JDialog((Frame)Laboratorio.getInstancia(), "Relat\u00f3rio de lote enviado");
                dialogo.setModal(true);
                dialogo.setSize(new Dimension(750, 600));
                dialogo.setLayout(new BorderLayout());
                gerador.setPai(dialogo.getContentPane());
                gerador.setPreVisualizar(true);
                gerador.setZoomPreVisualizar(0.5f);
                gerador.setAcaoFechar(dialogo::dispose);
                gerador.executar(xmlRelatorio, (TableModel)modelo, variaveis);
                ScreenUtil.centralizar(dialogo);
                dialogo.setVisible(true);
            } else {
                gerador.executar(xmlRelatorio, modelo, variaveis, false, true, isColetaWeb);
                return Impressao.gerarPdfRelatorio(gerador.getRelatorio(), xmlRelatorio);
            }
        }
        return new byte[0];
    }
}

