/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.externo.exportadores;

import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.relatorios.apoio.RelatorioSituacaoLote;
import jalis.laboratorio.triagem.externo.Exportador;
import jalis.laboratorio.triagem.externo.LaboratorioExterno;
import jalis.laboratorio.triagem.externo.exportadores.ExameMaterialPardini;
import jalis.laboratorio.triagem.externo.exportadores.IntegracaoLabExterno;
import jalis.laboratorio.triagem.externo.exportadores.UtilExportadores;
import jalis.laboratorio.util.impressao.Impressao;
import jalis.laboratorio.util.impressao.RetornoImpressaoEtiquetas;
import jalis.laboratorio.util.impressao.labexterno.ImpressorasLabExterno;
import jalis.laboratorio.util.parsers.pardini.ExameHPardini;
import jalis.relatorio.Gerador;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import jalis.util.xml.EscreveArquivoXML;
import jalis.util.xml.EscreveArquivoXMLException;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.table.TableModel;

public class ExportacaoParaSolucao
extends IntegracaoLabExterno
implements Exportador {
    private static final String CODIGO_MATERIAL = "codigoMaterial";
    private static final String CODIGO_EXAME = "codigoExame";
    private EscreveArquivoXML xml = new EscreveArquivoXML("1.0", "UTF-8", true);

    @Override
    public String getTagCodigo() {
        return "codigoProtocolo";
    }

    @Override
    public RetornoImpressaoEtiquetas exportarExames(String codLabExterno, String numeroLote, String configuracaoLabExterno, boolean reenvio, List<Registro> requisicoes, int colunaOrdenacao, boolean isColetaWeb, int agruparInterface, Statement st, Statement st2, Statement st3, String variaveisLogin, boolean agruparGuiasInterface, String imprimirEtiquetaTriagemSemMaterial, boolean imprimirEtiquetaColetaSemMaterial, boolean imprimirEtiquetaColetaSelecionadaSemMaterial, boolean agruparEtqPorQtde, String tipoExportacaoInterface, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario, String tipoIntegracao, String tamanhoNomeImpressora, String[] impressorasLocais, ImpressorasLabExterno impressoras, String tipoEtiquetaSoroteca, Callable<Boolean> arquivar, Callable<Boolean> anular, LaboratorioExterno labExterno, boolean agruparMultiguia) {
        RetornoImpressaoEtiquetas retorno = new RetornoImpressaoEtiquetas();
        try {
            arquivar.call();
            String codigoConvenio = StringUtil.getValor(configuracaoLabExterno, "codigoProtocolo");
            String nomeArquivo = "E" + Funcoes.preencheZero(codigoConvenio, 6) + Funcoes.formataData("DDMM", Calendar.getInstance().getTime()) + Funcoes.preencheZero(numeroLote, 10) + ".xml";
            if (isColetaWeb) {
                this.montaXML(numeroLote, codigoConvenio, requisicoes, nomeArquivo);
                retorno.setNomeArquivoLote(nomeArquivo);
                retorno.setXmlLote(UtilExportadores.getXMLParaColetaWeb(this.xml.getArquivo()));
                retorno.setExtensaoArquivo("xml");
                retorno.setImprimiu(true);
                this.xml.fecharArquivo();
                return retorno;
            }
            JFileChooser chooser = ComponenteFactory.novoJFileChooser(null, Variaveis.ultimoDiretorioDialogo != null ? Variaveis.ultimoDiretorioDialogo.getAbsolutePath() : null, reenvio ? null : "Lote j\u00e1 foi criado se necessitar gerar o arquivo utilize a op\u00e7\u00e3o de reenvio de lote!");
            chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
            chooser.setSelectedFile(new File(nomeArquivo));
            chooser.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo de exporta\u00e7\u00e3o Solu\u00e7\u00e3o (*.xml)", "xml"));
            int option = chooser.showOpenDialog(null);
            if (option == 0) {
                this.montaXML(numeroLote, codigoConvenio, requisicoes, chooser.getSelectedFile().getPath());
                this.xml.fecharArquivo();
                retorno.setImprimiu(true);
                return retorno;
            }
            if (option == 1) {
                retorno.setImprimiu(true);
                return retorno;
            }
        }
        catch (EscreveArquivoXMLException e) {
            this.xml.cancelar();
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ExportacaoParaHPardini: 46");
        }
        catch (ParseException e) {
            this.xml.cancelar();
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ExportacaoParaHPardini: 62");
        }
        catch (Exception ex) {
            this.xml.cancelar();
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "ExportacaoParaHPardini: 113");
        }
        retorno.setImprimiu(false);
        return retorno;
    }

    private void montaXML(String numeroLote, String codigoConvenio, List<Registro> requisicoes, String path) throws EscreveArquivoXMLException, ParseException {
        this.xml.abrirArquivo(path);
        this.xml.abrir("Registro");
        this.xml.abrir("Lote");
        this.xml.escreverItem("CodLab", codigoConvenio);
        this.xml.escreverItem("CodLoteLab", numeroLote);
        this.xml.escreverItem("DataLote", Funcoes.formataData("yyyy-MM-dd", new Date()));
        this.xml.escreverItem("HoraLote", Funcoes.formataData("HH:mm:ss", new Date()));
        for (Registro req : requisicoes) {
            this.criarPedido(req);
        }
        this.xml.fechar("Lote");
        this.xml.fechar("Registro");
    }

    @Override
    public byte[] imprimeRelatorio(boolean isColetaWeb, String codLabExterno, String numeroLote, List<Registro> requisicoesListaOriginal, int colunaOrdenacao, Statement st, int filialPadrao, int digitosTuboRequisicao, int digitosTuboFilial, String impressoraRelatorio) throws Exception {
        RelatorioSituacaoLote rel = new RelatorioSituacaoLote();
        ModeloGridTable modelo = rel.getModeloDados(st, new String[]{String.valueOf(numeroLote)}, new String[]{String.valueOf(codLabExterno)}, colunaOrdenacao, requisicoesListaOriginal, filialPadrao, digitosTuboRequisicao, digitosTuboFilial);
        if (modelo.getRowCount() > 0) {
            Gerador gerador = new Gerador(impressoraRelatorio);
            HashMap<String, Object> variaveis = new HashMap<String, Object>();
            variaveis.put("filtroLote", numeroLote);
            String xmlRelatorio = rel.getXMLRelatorio(st);
            if (!isColetaWeb) {
                JDialog dialogo = new JDialog((Frame)Laboratorio.getInstancia(), "Relat\u00f3rio de lote enviado");
                dialogo.setModal(true);
                dialogo.setSize(new Dimension(750, 600));
                dialogo.setLayout(new BorderLayout());
                gerador.setPai(dialogo.getContentPane());
                gerador.setPreVisualizar(true);
                gerador.setZoomPreVisualizar(0.5f);
                gerador.setAcaoFechar(dialogo::dispose);
                gerador.executar(xmlRelatorio, (TableModel)modelo, variaveis);
                ScreenUtil.centralizar(dialogo);
                dialogo.setVisible(true);
            } else {
                gerador.executar(xmlRelatorio, modelo, variaveis, false, true, isColetaWeb);
                return Impressao.gerarPdfRelatorio(gerador.getRelatorio(), xmlRelatorio);
            }
        }
        return new byte[0];
    }

    private void criarPedido(Registro req) throws EscreveArquivoXMLException, ParseException {
        List listaExame;
        this.xml.abrir("Pedido");
        this.xml.escreverItem("CodPedLab", Funcoes.preencheZero(req.getString("fil_codigo"), ParametrosGerais.getDigitosTuboFilial()) + Funcoes.preencheZero(req.getString("req_codigo"), ParametrosGerais.getDigitosTuboRequisicao()));
        String obs = req.getString("req_obs");
        this.xml.abrir("Paciente");
        this.xml.escreverItem("CodPacLab", req.getString("pac_codigo"));
        this.xml.escreverItem("Nome", StringUtil.removerAcentos(req.getString("pac_nome")));
        this.xml.escreverItem("DataNasc", Funcoes.formataData("yyyy-MM-dd", req.getDate("pac_datanasc")));
        this.xml.escreverItem("Sexo", this.getSexo(req.getString("pac_sexo")));
        if (!req.nulo("req_dum")) {
            this.xml.escreverItem("DataUltMens", this.formatar("yyyy-MM-dd", req.getDate("req_dum")));
        }
        boolean peso = false;
        boolean altura = false;
        if (!Funcoes.textoVazio(req.getString("req_peso"))) {
            this.xml.escreverItem("Peso", req.getString("req_peso").substring(0, req.getString("req_peso").contains(".") ? req.getString("req_peso").indexOf(".") : req.getString("req_peso").length()));
            peso = true;
        }
        if (!Funcoes.textoVazio(req.getString("req_altura"))) {
            this.xml.escreverItem("Altura", req.getString("req_altura"));
            altura = true;
        }
        if ((listaExame = (List)req.getValor("listaexames")) != null && listaExame.size() > 0) {
            for (Registro exa : listaExame) {
                Map infoComp = (Map)exa.getValor("infoComp");
                for (String key : infoComp.keySet()) {
                    if (!peso && key.equals("Peso")) {
                        this.xml.escreverItem("Peso", ((String)infoComp.get(key)).contains(".") ? ((String)infoComp.get(key)).substring(0, ((String)infoComp.get(key)).indexOf(".")) : (String)infoComp.get(key));
                        peso = true;
                    }
                    if (!altura && key.equals("Altura")) {
                        this.xml.escreverItem("Altura", (String)infoComp.get(key));
                        altura = true;
                    }
                    if (!peso || !altura) continue;
                    break;
                }
                if (!peso || !altura) continue;
                break;
            }
        }
        this.xml.fechar("Paciente");
        Map<ExameMaterialPardini, Integer> exaPardini = this.carregarExamesPardini((List)req.getValor("listaexames"));
        for (Registro exa : (List)req.getValor("listaexames")) {
            this.gravarDadosExame(exa, exaPardini, obs, req);
        }
        this.xml.fechar("Pedido");
    }

    private String removerEnter(String txt) {
        return txt.replaceAll("\n", " ");
    }

    private void gravarDadosExame(Registro exa, Map<ExameMaterialPardini, Integer> exaPardini, String obsRequisicao, Registro req) throws EscreveArquivoXMLException, ParseException {
        this.xml.abrir("Exame");
        ExameMaterialPardini exaMat = new ExameMaterialPardini(exa.getString(CODIGO_EXAME), exa.getString(CODIGO_MATERIAL));
        this.xml.escreverItem("CodExame", exaMat.exame);
        this.xml.escreverItem("CodMaterial", exaMat.material);
        exaPardini.put(exaMat, exaPardini.get(exaMat) + 1);
        this.xml.escreverItem("DataColeta", this.formatar("yyyy-MM-dd", exa.getDate("exr_datamaterial")));
        this.xml.escreverItem("HoraColeta", this.formatar("HH:mm:ss", exa.getDate("exr_datamaterial")));
        if (!Funcoes.textoVazio(exa.getString("exr_volumediurese")) && Float.valueOf(exa.getString("exr_volumediurese")).floatValue() > 0.0f) {
            this.xml.abrir("DadosAdicionais");
            this.gravaInformacaoComplementar("VOL", "VOLUME", String.valueOf(Math.round(Float.valueOf(exa.getString("exr_volumediurese")).floatValue())), "mL");
            this.xml.fechar("DadosAdicionais");
        }
        this.xml.fechar("Exame");
    }

    private void gravaInformacaoComplementar(String codDadoAdicional, String descricao, String valor, String complemento) throws NumberFormatException, EscreveArquivoXMLException {
        this.xml.abrir("DadoAdicional");
        this.xml.escreverItem("CodDadoAdicionalLIS", codDadoAdicional);
        this.xml.escreverItem("CodDadoAdicionalApoio", codDadoAdicional);
        this.xml.escreverItem("DESCRICAO", descricao);
        this.xml.escreverItem("VALOR", valor);
        this.xml.escreverItem("Complemento", complemento);
        this.xml.fechar("DadoAdicional");
    }

    private Map<ExameMaterialPardini, Integer> carregarExamesPardini(List<Registro> exames) {
        HashMap<ExameMaterialPardini, Integer> map = new HashMap<ExameMaterialPardini, Integer>();
        for (Registro exa : exames) {
            ExameHPardini ehp = ExameHPardini.novaInstancia(exa.getString("ele_xmllabexterno"));
            if (ehp != null) {
                exa.setValor(CODIGO_EXAME, ehp.getMnemonicoExame());
                exa.setValor(CODIGO_MATERIAL, ehp.getMnemonicoMaterial());
                exa.setValor("utilizar-mat-requisicao", ehp.utilizarMatRequisicao());
                exa.setValor("material-selecionado", ehp.getMaterialSelecinado());
                exa.setValor("conservante-selecionado", ehp.getConservanteSelecionado());
            }
            map.put(new ExameMaterialPardini(ehp.getMnemonicoExame(), ehp.getMnemonicoMaterial()), 0);
        }
        return map;
    }

    private String formatar(String masc, Date data) {
        if (masc != null && data != null) {
            return Funcoes.formataData(masc, data);
        }
        return "";
    }

    private String getSexo(String tipo) {
        if (tipo.equals("M")) {
            return "Masculino";
        }
        if (tipo.equals("F")) {
            return "Feminino";
        }
        return "Indefinido";
    }

    @Override
    public int getMaiorCodigoLote(String numeroLote, String codigoConvenio, LaboratorioExterno configuracaoLabExterno, Statement st) {
        try {
            ResultSet rs = st.executeQuery("select max(lex_codigo) + 1 as codigo from loteexterno where lae_codigo = " + configuracaoLabExterno.codigoLab + " and fil_codigo = " + Variaveis.filialPadrao);
            if (rs.next()) {
                return rs.getInt("codigo");
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return 0;
    }
}

