/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.externo.exportadores;

import jalis.comum.Conexao;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.exportacao.integracao.IntegracaoUtil;
import jalis.laboratorio.triagem.externo.LaboratorioExterno;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

public class ExportacaoParaSoftLabDao {
    public static final String TAG_COD_BAR_APOIO = "CodBarApoio";

    public Integer buscaSequencialInclusaoSoftLab(Registro registro, String laeCodigo, Statement st, boolean agruparGuiasInterface, Callable<Boolean> anular) throws SQLException {
        String filCodigo = registro.getString("fil_codigo");
        String reqCodigo = registro.getString("req_codigo");
        if (agruparGuiasInterface || DBUtil.requisicaoAgrupaMultiguiasLabExterno(st, filCodigo, reqCodigo)) {
            ArrayList<String> requisicoes = DBUtil.getReqMultiGuias(filCodigo, reqCodigo, st);
            reqCodigo = StringUtil.limpaString(((Object)requisicoes).toString(), new String[]{"[", "]"});
        }
        try {
            StringBuilder sql = new StringBuilder();
            sql.append(" select max(leq_sequencialrequisicao) + 1 as sequencial");
            sql.append(" from loteexternorequisicao ");
            sql.append(" where fil_kodigo = ").append(filCodigo);
            sql.append(" and req_codigo in ( ").append(reqCodigo);
            sql.append(" ) and lae_codigo = ").append(laeCodigo);
            ResultSet rs = st.executeQuery(sql.toString());
            if (rs.next()) {
                return rs.getInt("sequencial");
            }
        }
        catch (Exception e) {
            ExportacaoParaSoftLabDao.anularSQL(e, anular);
        }
        return 0;
    }

    protected void atualizaLoteExternoRequisicao(String codigoLabExterno, String numeroLote, boolean reenvio, Registro requisicao, StringBuilder etiquetaFormatada, Integer sequencial, String codigoPedidoApoiado, Statement st, String filialPadrao, String tipoIntegracao) throws SQLException {
        List listaExames = (List)requisicao.getValor("listaexames");
        HashMap<String, String> requisicaoFilial = new HashMap<String, String>();
        for (Registro registro : listaExames) {
            requisicaoFilial.put(registro.getString("req_codigo"), registro.getString("fil_codigo"));
        }
        for (Map.Entry entry : requisicaoFilial.entrySet()) {
            String filial = (String)entry.getValue();
            String reqCodigo = (String)entry.getKey();
            String lote = !reenvio ? requisicao.getString("novoLote") : numeroLote;
            String sqlpdate = this.getSqlAtualizaLoteExternoRequisicao(codigoLabExterno, etiquetaFormatada, sequencial, filial, reqCodigo, lote, codigoPedidoApoiado, filialPadrao);
            st.executeUpdate(sqlpdate);
            if (filial.equals(filialPadrao) && !tipoIntegracao.equals("F") && !tipoIntegracao.equals("W")) continue;
            IntegracaoUtil.insereComandoLog(st, filialPadrao, filial, sqlpdate);
        }
    }

    private String getSqlAtualizaLoteExternoRequisicao(String codigoLabExterno, StringBuilder etiquetaFormatada, Integer sequencial, String filial, String reqCodigo, String lote, String codigoPedidoApoioado, String filialPadrao) {
        StringBuilder sqlpdate = new StringBuilder();
        sqlpdate.append(" update loteexternorequisicao set ");
        if (!Funcoes.textoVazio(codigoPedidoApoioado)) {
            sqlpdate.append(" leq_codigoreqapoio = '").append(codigoPedidoApoioado).append("', ");
        }
        if (sequencial == null) {
            sqlpdate.append(" leq_retornows = '").append(StringUtil.textoDB(etiquetaFormatada.toString())).append("' ");
        } else {
            sqlpdate.append(" leq_sequencialrequisicao = ").append(sequencial);
        }
        sqlpdate.append(" where fil_codigo = ").append(filialPadrao);
        sqlpdate.append(" and lae_codigo = ").append(codigoLabExterno);
        sqlpdate.append(" and req_codigo = ").append(reqCodigo);
        sqlpdate.append(" and fil_kodigo = ").append(filial);
        sqlpdate.append(" and lex_codigo = ").append(lote);
        return sqlpdate.toString();
    }

    protected void atualizaCodigoApoiadoExameRequisicao(boolean isColetaWeb, Statement st, Registro requisicao, String codigoPedidoApoiado, String numeroLote, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, Callable<Boolean> arquivar, Callable<Boolean> anular) {
        StringBuilder sql = new StringBuilder();
        ArrayList exames = (ArrayList)requisicao.getValor("listaexames");
        String codigoPedidoApoiadoNumero = codigoPedidoApoiado.replace("-", "");
        int casasCodigoApoiado = digitosTuboFilial + digitosTuboRequisicao + digitosTuboTubo;
        try {
            sql.append("select req_codigo from requisicaolabexterno where ");
            sql.append("fil_codigo = ").append(requisicao.getString("fil_codigo"));
            sql.append(" and req_codigo = ").append(requisicao.getString("req_codigo"));
            sql.append(" and lae_codigo = ").append(requisicao.getString("lae_codigo"));
            ResultSet rs = st.executeQuery(sql.toString());
            if (!rs.next()) {
                sql.setLength(0);
                sql.append("insert into requisicaolabexterno (fil_codigo, req_codigo, lae_codigo, rle_codigo) values (");
                sql.append(requisicao.getString("fil_codigo")).append(", ").append(requisicao.getString("req_codigo"));
                sql.append(", ").append(requisicao.getString("lae_codigo")).append(", ");
                sql.append(!Funcoes.textoVazio(codigoPedidoApoiado) ? Funcoes.preencheZero(codigoPedidoApoiadoNumero, casasCodigoApoiado) : "").append(")");
                st.execute(sql.toString());
            }
            for (Registro exa : exames) {
                sql.setLength(0);
                sql.append(" select exr_codigoapoiado from examerequisicao  ");
                sql.append(" where fil_codigo = ").append(requisicao.getString("fil_codigo"));
                sql.append(" and req_codigo =  ").append(requisicao.getString("req_codigo"));
                sql.append(" and exa_codigo = '").append(exa.getString("exa_codigo")).append("' ");
                sql.append(" and exr_codigoapoiado is null ");
                rs = st.executeQuery(sql.toString());
                if (rs.next()) {
                    sql.setLength(0);
                    sql.append(" update examerequisicao set exr_codigoapoiado = '").append(!Funcoes.textoVazio(codigoPedidoApoiado) ? codigoPedidoApoiado : "").append("'");
                    sql.append(" where fil_codigo = ").append(requisicao.getString("fil_codigo"));
                    sql.append("   and req_codigo = ").append(requisicao.getString("req_codigo"));
                    sql.append("   and exa_codigo = '").append(exa.getString("exa_codigo")).append("' ");
                    if (isColetaWeb) {
                        st.executeUpdate(sql.toString());
                    } else {
                        Conexao.executeUpdate(requisicao.getString("fil_codigo"), st, sql);
                    }
                }
                sql.setLength(0);
                sql.append(" select ere_codigoapoiado from examerequisicaorecipiente ");
                sql.append(" where fil_codigo = ").append(requisicao.getString("fil_codigo"));
                sql.append(" and req_codigo =  ").append(requisicao.getString("req_codigo"));
                sql.append(" and exa_codigo = '").append(exa.getString("exa_codigo")).append("' ");
                rs = st.executeQuery(sql.toString());
                if (rs.next()) {
                    sql.setLength(0);
                    sql.append(" update examerequisicaorecipiente set ere_codigoapoiado = '").append(!Funcoes.textoVazio(codigoPedidoApoiado) ? Funcoes.preencheZero(codigoPedidoApoiadoNumero, casasCodigoApoiado) : "").append("'");
                    sql.append(" where fil_codigo = ").append(requisicao.getString("fil_codigo"));
                    sql.append(" and req_codigo =  ").append(requisicao.getString("req_codigo"));
                    sql.append(" and exa_codigo = '").append(exa.getString("exa_codigo")).append("' ");
                    sql.append(" and mco_codigo = ").append(exa.getString("mco_codigo"));
                    if (isColetaWeb) {
                        st.executeUpdate(sql.toString());
                    } else {
                        Conexao.executeUpdate(requisicao.getString("fil_codigo"), st, sql);
                    }
                }
                arquivar.call();
            }
        }
        catch (Exception e) {
            ExportacaoParaSoftLabDao.anularSQL(e, anular);
        }
    }

    protected int getMaiorCodigoLote(LaboratorioExterno labExterno, Statement st, String filialPadrao) throws SQLException {
        ResultSet rs = st.executeQuery(this.getSqlMaiorCodigoLote(labExterno.codigoLab, filialPadrao));
        if (rs.next()) {
            return rs.getInt("codigo");
        }
        return 0;
    }

    private String getSqlMaiorCodigoLote(String codigoLab, String filialPadrao) {
        StringBuilder sql = new StringBuilder();
        sql.append("select max(lex_codigo) + 1 as codigo from loteexterno where lae_codigo = ");
        sql.append(codigoLab);
        sql.append(" and fil_codigo = ");
        sql.append(filialPadrao);
        return sql.toString();
    }

    private static void anularSQL(Exception e, Callable<Boolean> anular) {
        try {
            anular.call();
        }
        catch (Exception e1) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel anular o c\u00f3digo do apoio.\n" + e1.getMessage(), e1.getStackTrace());
        }
        ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel gravar o c\u00f3digo do apoio.\n" + e.getMessage(), e.getStackTrace());
    }
}

