/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.externo.exportadores;

import com.fasterxml.jackson.databind.ObjectMapper;
import jalis.apoio.servidorws.parametroset.ParametroSet;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.relatorios.apoio.RelatorioSituacaoLote;
import jalis.laboratorio.triagem.externo.Exportador;
import jalis.laboratorio.triagem.externo.LaboratorioExterno;
import jalis.laboratorio.triagem.externo.RetornoEstornarLote;
import jalis.laboratorio.triagem.externo.exportadores.ExportacaoParaSoftLabDao;
import jalis.laboratorio.triagem.externo.exportadores.IntegracaoLabExterno;
import jalis.laboratorio.triagem.externo.exportadores.ProcessaErroRetornoWebServiceLabExterno;
import jalis.laboratorio.triagem.externo.exportadores.UtilExportadores;
import jalis.laboratorio.triagem.externo.exportadores.VisualizaErroRetornoWebService;
import jalis.laboratorio.triagem.externo.exportadores.softlab.AvisosDTO;
import jalis.laboratorio.triagem.externo.exportadores.softlab.ExameDTO;
import jalis.laboratorio.triagem.externo.exportadores.softlab.ExclusaoLoteSoftLab;
import jalis.laboratorio.triagem.externo.exportadores.softlab.PedidoSoftLabDTO;
import jalis.laboratorio.triagem.externo.exportadores.softlab.RetornoDTO;
import jalis.laboratorio.triagem.externo.exportadores.softlab.RetornoEtiquetaDTO;
import jalis.laboratorio.util.impressao.Impressao;
import jalis.laboratorio.util.impressao.ImprimirEtiquetasColetaTriagem;
import jalis.laboratorio.util.impressao.RetornoImpressaoEtiquetas;
import jalis.laboratorio.util.impressao.exame.ExameMaterial;
import jalis.laboratorio.util.impressao.exame.ListaExameMaterial;
import jalis.laboratorio.util.impressao.exame.externo.softlab.ImpressaoSoftLab;
import jalis.laboratorio.util.impressao.labexterno.ImpressorasLabExterno;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.laboratorio.util.parsers.softlab.ComunicacaoSoftLab;
import jalis.laboratorio.util.parsers.softlab.dto.RespostaDTO;
import jalis.relatorio.Gerador;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.impressao.termica.ImpressaoTermica;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import javax.print.PrintService;
import javax.swing.JDialog;
import javax.swing.table.TableModel;
import org.json.JSONObject;
import org.json.XML;

public class ExportacaoParaSoftLab
extends IntegracaoLabExterno
implements Exportador {
    private static final boolean DEBUG = Funcoes.arquivoExiste(System.getProperty("user.home") + System.getProperty("file.separator") + "debug.jalis");
    private transient ExportacaoParaSoftLabDao dao = new ExportacaoParaSoftLabDao();
    String laeCodigo = "";

    @Override
    public RetornoImpressaoEtiquetas exportarExames(String codLabExterno, String numeroLote, String configuracaoLabExterno, boolean reenvio, List<Registro> requisicoes, int colunaOrdenacao, boolean isColetaWeb, int agruparInterface, Statement st, Statement st2, Statement st3, String variaveisLogin, boolean agruparGuiasInterface, String imprimirEtiquetaTriagemSemMaterial, boolean imprimirEtiquetaColetaSemMaterial, boolean imprimirEtiquetaColetaSelecionadaSemMaterial, boolean agruparEtqPorQtde, String tipoExportacaoInterface, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario, String tipoIntegracao, String tamanhoNomeImpressora, String[] impressorasLocais, ImpressorasLabExterno impressoras, String tipoEtiquetaSoroteca, Callable<Boolean> arquivar, Callable<Boolean> anular, LaboratorioExterno labExterno, boolean agruparMultiguia) {
        this.enviarUsandoWS = configuracaoLabExterno.indexOf("enviarLoteWebService") >= 0 && StringUtil.getBoolean(configuracaoLabExterno, "enviarLoteWebService");
        this.laeCodigo = codLabExterno;
        RetornoImpressaoEtiquetas retorno = this.validarConfiguracao(configuracaoLabExterno, isColetaWeb);
        if (!retorno.isConfigValida()) {
            try {
                ExportacaoParaSoftLab.removerLote(codLabExterno, requisicoes, numeroLote, st, isColetaWeb, arquivar, agruparInterface);
                return retorno;
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel desfazer o lote solicitado.\n" + e.getMessage(), e.getStackTrace());
            }
        }
        return this.processa(isColetaWeb, codLabExterno, numeroLote, configuracaoLabExterno, reenvio, requisicoes, st, agruparGuiasInterface, digitosTuboFilial, digitosTuboRequisicao, arquivar, anular, Variaveis.filialPadrao, tipoIntegracao, st2, st3, variaveisLogin, this.getTipoEtiqueta(agruparInterface), digitosTuboTubo, tuboPrimario, utilizarCapacidadeTuboPrimario, agruparInterface, imprimirEtiquetaTriagemSemMaterial, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, agruparEtqPorQtde, tipoExportacaoInterface, impressoras.getImpressoraSoftLab());
    }

    private RetornoImpressaoEtiquetas processa(boolean isColetaWeb, String codigoLabExterno, String numeroLote, String configuracaoLabExterno, boolean reenvio, List<Registro> requisicoes, Statement st, boolean isAgruparGuiasInterface, int digitosTuboFilial, int digitosTuboRequisicao, Callable<Boolean> arquivar, Callable<Boolean> anular, String filialPadrao, String tipoIntegracao, Statement st2, Statement st3, String usuario, int tipoEtiqueta, int digitosTuboTubo, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario, int agruparInterface, String imprimirEtiquetaTriagemSemMaterial, boolean imprimirEtiquetaColetaSemMaterial, boolean imprimirEtiquetaColetaSelecionadaSemMaterial, boolean agruparEtqPorQtde, String tipoExportacaoInterface, String impressoraSoftlab) {
        RetornoImpressaoEtiquetas retornoImpressao = new RetornoImpressaoEtiquetas();
        ArrayList lista = new ArrayList();
        boolean reqCriada = false;
        try {
            this.insereExameRequisicaoRecipiente(isColetaWeb, codigoLabExterno, requisicoes, st, st2, st3, usuario, tipoEtiqueta, false, null, null, false, isAgruparGuiasInterface, imprimirEtiquetaTriagemSemMaterial, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, agruparEtqPorQtde, tipoExportacaoInterface, agruparInterface, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, tuboPrimario, utilizarCapacidadeTuboPrimario);
            List<Registro> requisicoesPais = ExportacaoParaSoftLab.agruparMutiguia(requisicoes, st, isAgruparGuiasInterface, digitosTuboFilial);
            for (int i = 0; i < requisicoesPais.size(); ++i) {
                Registro req = requisicoesPais.get(i);
                ComunicacaoSoftLab comunicacao = ComunicacaoSoftLab.getInstancia(configuracaoLabExterno);
                Integer sequencial = this.dao.buscaSequencialInclusaoSoftLab(req, codigoLabExterno, st, isAgruparGuiasInterface, anular);
                PedidoSoftLabDTO pedidoSoftLab = PedidoSoftLabDTO.fromRegistro(req, sequencial, digitosTuboFilial, digitosTuboRequisicao);
                pedidoSoftLab.setExames(ExameDTO.getExames(req, this.laeCodigo, st));
                String json = pedidoSoftLab.toJson();
                this.debug("ENVIO =======================");
                this.debug(this.formatarJson(json));
                RespostaDTO resposta = comunicacao.solicitaPedido("/api/Pedido", json);
                this.debug("RETORNO  =======================");
                this.debug(this.formatarJson(resposta.getConteudo()));
                RetornoDTO retorno = new RetornoDTO();
                if (!Funcoes.textoVazio(resposta.getConteudo())) {
                    retorno = RetornoDTO.fromJson(resposta.getConteudo());
                }
                if (resposta.getStatusCode() != 201 || retorno == null || !retorno.getAvisos().isEmpty()) {
                    while (i < requisicoesPais.size()) {
                        ExportacaoParaSoftLab.removerLote(codigoLabExterno, Arrays.asList(requisicoesPais.get(i)), numeroLote, st, isColetaWeb, arquivar, agruparInterface);
                        ++i;
                    }
                    ExportacaoParaSoftLab.removerLote(codigoLabExterno, Arrays.asList(req), numeroLote, st, isColetaWeb, arquivar, agruparInterface);
                    this.removeLoteSoftLab(req, comunicacao, sequencial, digitosTuboFilial, digitosTuboRequisicao);
                    VisualizaErroRetornoWebService telaVisualizacaoErro = null;
                    String nomeArquivo = "remessa_" + numeroLote + ".json";
                    if (isColetaWeb) {
                        retornoImpressao.setNomeArquivoLote(nomeArquivo);
                        retornoImpressao.setXmlLote(json);
                        retornoImpressao.setExtensaoArquivo("json");
                    } else {
                        telaVisualizacaoErro = this.trataMensagemErro(req, resposta, retorno, isColetaWeb, retornoImpressao);
                    }
                    if (telaVisualizacaoErro != null && telaVisualizacaoErro.isGerarArquivo()) {
                        this.gerarArquivo(json, new File(nomeArquivo), reenvio, "Arquivo de exporta\u00e7\u00e3o SoftLab (*.Json)");
                        break;
                    }
                    this.alteraSituacaoReqExameNaoExportado(req);
                    retornoImpressao.setImprimiu(reqCriada);
                    return retornoImpressao;
                }
                this.dao.atualizaLoteExternoRequisicao(codigoLabExterno, numeroLote, reenvio, req, null, sequencial, null, st, filialPadrao, tipoIntegracao);
                retornoImpressao = this.processaRetornoWebService(isColetaWeb, codigoLabExterno, numeroLote, reenvio, req, resposta.getConteudo(), configuracaoLabExterno, st, st2, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, agruparInterface, isAgruparGuiasInterface, filialPadrao, tipoIntegracao, arquivar, anular, impressoraSoftlab, retornoImpressao);
                reqCriada = true;
                this.marcarReqExameExportado(requisicoes, req, isAgruparGuiasInterface, st);
            }
            retornoImpressao.setImprimiu(reqCriada);
            return retornoImpressao;
        }
        catch (SocketTimeoutException ste) {
            this.exibirErroConsulta("Timeout de comunica\u00e7\u00e3o com Softlab.", ste.getStackTrace());
        }
        catch (Exception e) {
            this.exibirErroConsulta(e.getMessage(), e.getStackTrace());
        }
        retornoImpressao.setImprimiu(reqCriada);
        return retornoImpressao;
    }

    private RetornoImpressaoEtiquetas processaRetornoWebService(boolean isColetaWeb, String codigoLabExterno, String numeroLote, boolean reenvio, Registro requisicao, String retornoJson, String configuracaoLabExterno, Statement st, Statement st2, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, int agruparInterface, boolean agruparGuiasInterface, String filialPadrao, String tipoIntegracao, Callable<Boolean> arquivar, Callable<Boolean> anular, String impressoraSoftlab, RetornoImpressaoEtiquetas retornoImpressao) throws SQLException, IOException {
        RetornoDTO retorno;
        if (!Funcoes.textoVazio(retornoJson) && !Funcoes.textoVazio((retorno = RetornoDTO.fromJson(retornoJson)).getCodigoLis())) {
            ArrayList<byte[]> listEtq;
            this.debug("ETIQUETA  =======================");
            this.debug("Solicitando Etiqueta do Pedido " + retorno.getCodigoLis());
            ComunicacaoSoftLab comunicacao = ComunicacaoSoftLab.getInstancia(configuracaoLabExterno);
            RespostaDTO retornoEtiqueta = comunicacao.enviarSolicitacao("/api/Amostra/" + retorno.getCodigoLis());
            if (retornoEtiqueta.getStatusCode() != 200) {
                this.processarErro(retornoEtiqueta, true, isColetaWeb, retornoImpressao);
                return retornoImpressao;
            }
            StringBuilder etiquetaCompleta = new StringBuilder();
            HashSet<String> codigoPedidoApoio = new HashSet<String>();
            List<RetornoEtiquetaDTO> etiquetas = RetornoEtiquetaDTO.fromJson(retornoEtiqueta.getConteudo());
            if (etiquetas == null) {
                return retornoImpressao;
            }
            for (RetornoEtiquetaDTO r : etiquetas) {
                codigoPedidoApoio.add(r.getPedido());
                etiquetaCompleta.append(r.getEtiquetaEpl());
            }
            String codPedido = (String)new ArrayList(codigoPedidoApoio).get(0);
            StringBuilder etiquetaFormatada = ImpressaoSoftLab.formataEtiquetaSoftLab(etiquetaCompleta.toString());
            this.debug("RETORNO =======================");
            this.debug(etiquetaFormatada.toString());
            ImprimirEtiquetasColetaTriagem.criaRecipiente(isColetaWeb, requisicao.getString("fil_codigo"), requisicao.getString("req_codigo"), this.getTipoEtiqueta(agruparInterface), true, true, st, st2, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, agruparInterface, agruparGuiasInterface);
            this.dao.atualizaLoteExternoRequisicao(codigoLabExterno, numeroLote, reenvio, requisicao, etiquetaFormatada, null, codPedido, st, filialPadrao, tipoIntegracao);
            this.dao.atualizaCodigoApoiadoExameRequisicao(isColetaWeb, st, requisicao, codPedido, numeroLote, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, arquivar, anular);
            PrintService service = null;
            List<byte[]> list = listEtq = retornoImpressao.getEtiquetasLabExterno() != null && !retornoImpressao.getEtiquetasLabExterno().isEmpty() ? retornoImpressao.getEtiquetasLabExterno().get("softlab") : new ArrayList<byte[]>();
            if (!isColetaWeb) {
                service = Funcoes.localizarImpressora(Impressao.comparaNomeImpressoraReduzido(impressoraSoftlab));
            }
            listEtq.add(ImpressaoTermica.imprimirDireto(service, etiquetaFormatada.toString(), true, st, isColetaWeb, arquivar, anular));
            HashMap<String, List<byte[]>> etiquetasLab = new HashMap<String, List<byte[]>>();
            etiquetasLab.put("softlab", listEtq);
            retornoImpressao.setEtiquetasLabExterno(etiquetasLab);
        }
        return retornoImpressao;
    }

    private void insereExameRequisicaoRecipiente(boolean isColetaWeb, String codigoLabExterno, List<Registro> requisicoes, Statement st, Statement st2, Statement st3, String usuario, int tipoEtiqueta, boolean atualizarCodigoApoiado, ListaExameMaterial<ExameMaterial> listaExamesHPDirectNaoImprimir, List<ParametroSet> listExames, boolean isEnviarEtiquetaComoApoio, boolean agruparGuiasInterface, String parametroImprimirEtqTriagemSemMaterial, boolean parametroImprimirEtqColetaSemMaterial, boolean parametroImprimirEtqColetaSelecionadaSemMaterial, boolean agruparEtiquetaPorQtde, String tipoExportacaoInterface, int agruparInterface, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario) throws SQLException {
        for (Registro registro : requisicoes) {
            ArrayList listaExames = (ArrayList)registro.getValor("listaexames");
            ArrayList<String> listExa = new ArrayList<String>();
            int[] arrayMat = new int[listaExames.size()];
            for (Registro exa : listaExames) {
                listExa.add(exa.getString("exa_codigo"));
                arrayMat[listExa.size() - 1] = exa.getInt("mco_codigo");
            }
            String[] arrayExa = (String[])Arrays.copyOf(listExa.toArray(), listExa.toArray().length, String[].class);
            ImprimirEtiquetasColetaTriagem.criaEtiqueta(isColetaWeb, registro.getString("fil_codigo"), registro.getString("req_codigo"), arrayExa, arrayMat, true, "R", st, st2, st3, usuario, tipoEtiqueta, atualizarCodigoApoiado, listaExamesHPDirectNaoImprimir, listExames, isEnviarEtiquetaComoApoio, "", agruparGuiasInterface, parametroImprimirEtqTriagemSemMaterial, parametroImprimirEtqColetaSemMaterial, parametroImprimirEtqColetaSelecionadaSemMaterial, agruparEtiquetaPorQtde, tipoExportacaoInterface, agruparInterface, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, tuboPrimario, utilizarCapacidadeTuboPrimario);
        }
    }

    private String formatarJson(String json) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            return objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)objectMapper.readTree(json));
        }
        catch (Exception e) {
            return json;
        }
    }

    private int getTipoEtiqueta(int agruparInterface) {
        if (tipoEtiq == 0) {
            if (agruparInterface == 1) {
                return 2;
            }
            return 1;
        }
        return tipoEtiq;
    }

    @Override
    public byte[] imprimeRelatorio(boolean isColetaWeb, String codLabExterno, String numeroLote, List<Registro> requisicoesListaOriginal, int colunaOrdenacao, Statement st, int filialPadrao, int digitosTuboRequisicao, int digitosTuboFilial, String impressoraRelatorio) throws Exception {
        RelatorioSituacaoLote rel = new RelatorioSituacaoLote();
        ModeloGridTable modelo = rel.getModeloDados(st, new String[]{String.valueOf(numeroLote)}, new String[]{String.valueOf(codLabExterno)}, colunaOrdenacao, requisicoesListaOriginal, filialPadrao, digitosTuboRequisicao, digitosTuboFilial);
        if (modelo.getRowCount() > 0) {
            Gerador gerador = new Gerador(impressoraRelatorio);
            HashMap<String, Object> variaveis = new HashMap<String, Object>();
            variaveis.put("filtroLote", numeroLote);
            String xmlRelatorio = rel.getXMLRelatorio(st);
            if (!isColetaWeb) {
                JDialog dialogo = new JDialog((Frame)Laboratorio.getInstancia(), "Relat\u00f3rio de lote enviado");
                dialogo.setModal(true);
                dialogo.setSize(new Dimension(750, 600));
                dialogo.setLayout(new BorderLayout());
                gerador.setPai(dialogo.getContentPane());
                gerador.setPreVisualizar(true);
                gerador.setZoomPreVisualizar(0.5f);
                gerador.setAcaoFechar(dialogo::dispose);
                gerador.executar(xmlRelatorio, (TableModel)modelo, variaveis);
                ScreenUtil.centralizar(dialogo);
                dialogo.setVisible(true);
            } else {
                gerador.executar(xmlRelatorio, modelo, variaveis, false, true, isColetaWeb);
                return Impressao.gerarPdfRelatorio(gerador.getRelatorio(), xmlRelatorio);
            }
        }
        return new byte[0];
    }

    @Override
    public String getTagCodigo() {
        return "login";
    }

    private RetornoImpressaoEtiquetas validarConfiguracao(String configuracaoLabExterno, boolean isColetaWeb) {
        HashMap<String, String> mensagensLabExterno = new HashMap<String, String>();
        RetornoImpressaoEtiquetas retorno = new RetornoImpressaoEtiquetas();
        String enderecoAPI = configuracaoLabExterno.indexOf("enderecoAPI") >= 0 ? StringUtil.getValor(configuracaoLabExterno, "enderecoAPI") : null;
        String login = configuracaoLabExterno.indexOf("login") >= 0 ? StringUtil.getValor(configuracaoLabExterno, "login") : null;
        String senha = configuracaoLabExterno.indexOf("senha") >= 0 ? StringUtil.getValor(configuracaoLabExterno, "senha") : null;
        String mensagem = "";
        if (Funcoes.textoVazio(login)) {
            mensagem = "O Login do laborat\u00f3rio SoftLab n\u00e3o foi configurada.";
            mensagensLabExterno.put(Protocolo.SoftLab.getDescricao(), mensagem);
            if (!isColetaWeb) {
                Funcoes.mensagem(Laboratorio.getInstancia(), mensagem, 2);
            }
            retorno.setMensagensRetornoLabExterno(mensagensLabExterno);
            retorno.setConfigValida(false);
            return retorno;
        }
        if (Funcoes.textoVazio(senha)) {
            mensagem = "A senha para o laborat\u00f3rio SoftLab n\u00e3o foi configurada.";
            mensagensLabExterno.put(Protocolo.SoftLab.getDescricao(), mensagem);
            if (!isColetaWeb) {
                Funcoes.mensagem(Laboratorio.getInstancia(), mensagem, 2);
            }
            retorno.setMensagensRetornoLabExterno(mensagensLabExterno);
            retorno.setConfigValida(false);
            return retorno;
        }
        if (Funcoes.textoVazio(enderecoAPI)) {
            mensagem = "O Caminho da API para o laborat\u00f3rio SoftLab n\u00e3o foi configurada.";
            mensagensLabExterno.put(Protocolo.SoftLab.getDescricao(), mensagem);
            retorno.setMensagensRetornoLabExterno(mensagensLabExterno);
            if (!isColetaWeb) {
                Funcoes.mensagem(Laboratorio.getInstancia(), mensagem, 2);
            }
            retorno.setConfigValida(false);
            return retorno;
        }
        retorno.setConfigValida(ComunicacaoSoftLab.getInstancia(configuracaoLabExterno).comunicacaoOk());
        return retorno;
    }

    private VisualizaErroRetornoWebService processarErro(RespostaDTO resposta, boolean isColetaWeb, RetornoImpressaoEtiquetas retornoImpressao) {
        return this.processarErro(resposta, false, isColetaWeb, retornoImpressao);
    }

    private VisualizaErroRetornoWebService processarErro(RespostaDTO resposta, boolean mensagemEtiqueta, boolean isColetaWeb, RetornoImpressaoEtiquetas retornoImpressao) {
        String json = resposta.getConteudo();
        String xmlErro = "";
        if (resposta.getStatusCode() == 401) {
            xmlErro = "N\u00e3o foi possivel efetuar o login de autoriza\u00e7\u00e3o no apoio.";
        } else {
            if (resposta.getConteudo().contains("[") && resposta.getConteudo().contains("]")) {
                json = json.replace("[", "").replace("]", "");
            }
            try {
                JSONObject jsonObject = new JSONObject(json);
                xmlErro = StringUtil.getValor(XML.toString((Object)jsonObject), "message");
            }
            catch (Exception e) {
                xmlErro = json;
            }
            if (mensagemEtiqueta) {
                xmlErro = xmlErro + "\n***Para imprimir as etiquetas desse Pedido, posteriormente utilize a Tela da REQUISI\u00c7\u00c3O ou a Tela de REIMPRIMIR ETIQUETA DE LOTE***";
            }
        }
        if (!isColetaWeb) {
            ProcessaErroRetornoWebServiceLabExterno erroRetornoWebServiceLabExterno = new ProcessaErroRetornoWebServiceLabExterno(xmlErro, this.formatarJson(json));
            return this.visualizaErroRetornoWebService(erroRetornoWebServiceLabExterno, false);
        }
        UtilExportadores.adicionarMensagemRetorno(xmlErro, Protocolo.SoftLab.getDescricao(), retornoImpressao);
        return null;
    }

    private VisualizaErroRetornoWebService processaErroRetorno(Registro requisicao, RetornoDTO retorno, boolean isColetaWeb, RetornoImpressaoEtiquetas retornoImpressao, boolean habilitaArquivo) {
        StringBuilder aviso = new StringBuilder();
        StringBuilder avisoJson = new StringBuilder();
        aviso.append("Pedido ").append(retorno.getCodigoLis()).append(" de ").append(requisicao.getString("pac_nome")).append(" n\u00e3o recebido.");
        for (AvisosDTO avisos : retorno.getAvisos()) {
            aviso.append("\nRetorno: ").append(avisos.getMessage());
            avisoJson.append(this.formatarJson(avisos.toJson()) + "\n");
        }
        if (!isColetaWeb) {
            ProcessaErroRetornoWebServiceLabExterno erroRetornoWebServiceLabExterno = new ProcessaErroRetornoWebServiceLabExterno(aviso.toString(), avisoJson.toString());
            return this.visualizaErroRetornoWebService(erroRetornoWebServiceLabExterno, habilitaArquivo);
        }
        UtilExportadores.adicionarMensagemRetorno(aviso.toString(), Protocolo.SoftLab.getDescricao(), retornoImpressao);
        return null;
    }

    private void exibirErroConsulta(String erro, StackTraceElement[] stackTraceElements) {
        ProcessaErroRetornoWebServiceLabExterno erroRetornoWebServiceLabExterno = new ProcessaErroRetornoWebServiceLabExterno(erro, stackTraceElements);
        this.visualizaErroRetornoWebService(erroRetornoWebServiceLabExterno, false);
    }

    private VisualizaErroRetornoWebService visualizaErroRetornoWebService(ProcessaErroRetornoWebServiceLabExterno erroRetornoWebServiceLabExterno, boolean habilitaArquivo) {
        return VisualizaErroRetornoWebService.novaInstancia(Laboratorio.getInstancia(), "Mensagens ao enviar lotes", erroRetornoWebServiceLabExterno, habilitaArquivo, "SoftLab");
    }

    private void removeLoteSoftLab(Registro req, ComunicacaoSoftLab comunicacao, Integer sequencial, int digitosTuboFilial, int digitosTuboRequisicao) {
        String codigoLis = Funcoes.preencheZero(req.getString("fil_codigo"), digitosTuboFilial) + Funcoes.preencheZero(req.getString("req_codigo"), digitosTuboRequisicao);
        String seq = sequencial > 0 ? "." + sequencial : "";
        String pathEstorno = "/api/Pedido/" + codigoLis + seq;
        try {
            comunicacao.excluirPedido(pathEstorno, "ESTORNO");
        }
        catch (Exception e) {
            e.getStackTrace();
        }
    }

    private void debug(String mensagem) {
        if (DEBUG) {
            System.out.println("\n" + mensagem);
        }
    }

    @Override
    public int getMaiorCodigoLote(String numeroLote, String codigoConvenio, LaboratorioExterno labExterno, Statement st) {
        try {
            return this.dao.getMaiorCodigoLote(labExterno, st, Variaveis.filialPadrao);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RetornoEstornarLote estornarExames(String codLabExterno, List<Registro> requisicoes, String numeroLote, boolean isColetaWeb, Statement st, Callable<Boolean> arquivar, Callable<Boolean> anular, int agruparInterface, LaboratorioExterno labSelecionado, boolean agruparMultiguia, String login, int digitosTuboFilial, int digitosTuboRequisicao) throws Exception {
        RetornoEstornarLote retorno = new RetornoEstornarLote();
        int linha = -1;
        try {
            ExclusaoLoteSoftLab exclusaoLote;
            boolean isEstornar = false;
            if (!isColetaWeb) {
                String mensagem = "O estorno ocorrer\u00e1 via integra\u00e7\u00e3o no APOIO e tamb\u00e9m no Jalis, n\u00e3o podendo mais ser revertido.\n Confirma o estorno?";
                boolean bl = isEstornar = Funcoes.mensagem(Laboratorio.getInstancia(), mensagem, 4) == 0;
            }
            if ((isEstornar || isColetaWeb) && (linha = (exclusaoLote = new ExclusaoLoteSoftLab()).estornarExame(numeroLote, requisicoes, labSelecionado, agruparMultiguia, agruparInterface, arquivar, anular, st, login, digitosTuboFilial, digitosTuboRequisicao, isColetaWeb)) == 0) {
                super.estornarExames(codLabExterno, requisicoes, numeroLote, isColetaWeb, st, arquivar, anular, agruparInterface, labSelecionado, agruparMultiguia, login, digitosTuboFilial, digitosTuboRequisicao);
            }
        }
        catch (Exception e) {
            e.getMessage();
        }
        finally {
            arquivar.call();
        }
        if (linha == 0) {
            String texto = "Estorno conclu\u00eddo com sucesso!";
            retorno.setSucesso(true);
            if (isColetaWeb) {
                retorno.setMensagem(texto);
            } else {
                Funcoes.mensagem(Laboratorio.getInstancia(), texto, 3);
            }
        } else if (linha != -2) {
            if (isColetaWeb) {
                retorno.setMensagem("O Estorno foi conclu\u00eddo, mas as requisi\u00e7\u00f5es que permaneceram em tela, tiveram o pedido de estorno rejeitado pelo Apoio.");
            } else {
                Funcoes.mensagem(Laboratorio.getInstancia(), "O Estorno foi conclu\u00eddo, mas as requisi\u00e7\u00f5es que permaneceram\nem tela, tiveram o pedido de estorno rejeitado pelo Apoio", 3);
            }
        }
        return retorno;
    }

    private void alteraSituacaoReqExameNaoExportado(Registro requisicao) {
        ArrayList listaExames;
        if (!requisicao.getBoolean("req_exportado") && (listaExames = (ArrayList)requisicao.getValor("backup_lista_exames")) != null) {
            for (Registro exa : listaExames) {
                exa.setValor("exr_situacao", 0);
            }
        }
    }

    private void marcarReqExameExportado(List<Registro> requisicoes, Registro req, boolean agruparInterfaceGuias, Statement st) throws SQLException {
        for (Registro requisicao : requisicoes) {
            String filialCodigo = req.getString("fil_codigo");
            String requisicaoCodigo = req.getString("req_codigo");
            String campoReq = "req_codigo";
            if (agruparInterfaceGuias || DBUtil.requisicaoAgrupaMultiguiasLabExterno(st, filialCodigo, requisicaoCodigo)) {
                requisicaoCodigo = req.getString("req_codigomae");
                campoReq = "req_codigomae";
            }
            if (!filialCodigo.equals(requisicao.getString("fil_codigo")) || !requisicaoCodigo.equals(requisicao.getString(campoReq))) continue;
            requisicao.setValor("req_exportado", true);
            ArrayList listaExames = (ArrayList)requisicao.getValor("backup_lista_exames");
            if (listaExames == null) continue;
            for (Registro exa : listaExames) {
                exa.setValor("exa_exportado", true);
            }
        }
    }

    private VisualizaErroRetornoWebService trataMensagemErro(Registro req, RespostaDTO resposta, RetornoDTO retorno, boolean isColetaWeb, RetornoImpressaoEtiquetas retornoEtq) {
        VisualizaErroRetornoWebService telaVisualizacaoErro = null;
        telaVisualizacaoErro = retorno != null && retorno.getAvisos() != null && !retorno.getAvisos().isEmpty() ? this.processaErroRetorno(req, retorno, isColetaWeb, retornoEtq, false) : this.processarErro(resposta, isColetaWeb, retornoEtq);
        return telaVisualizacaoErro;
    }
}

