/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.triagem.externo.exportadores;

import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.relatorios.apoio.RelatorioSituacaoLote;
import jalis.laboratorio.triagem.externo.Exportador;
import jalis.laboratorio.triagem.externo.LaboratorioExterno;
import jalis.laboratorio.triagem.externo.exportadores.EtiquetasExameRede;
import jalis.laboratorio.triagem.externo.exportadores.EtiquetasGeradas;
import jalis.laboratorio.triagem.externo.exportadores.IntegracaoLabExterno;
import jalis.laboratorio.util.impressao.Impressao;
import jalis.laboratorio.util.impressao.RetornoImpressaoEtiquetas;
import jalis.laboratorio.util.impressao.labexterno.ImpressorasLabExterno;
import jalis.relatorio.Gerador;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.impressao.termica.ImpressaoTermica;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.table.TableModel;

public class ExportacaoParaRede
extends IntegracaoLabExterno
implements Exportador,
ActionListener {
    private static final int CONST_PACIENTE = 1;
    private static final int CONST_EXAME = 2;
    private int ultimaFaixa;
    public static ModeloGridTable etiquetas = new ModeloGridTable(new String[]{"requisicao", "nomePaciente", "material", "examesRede", "codEtiquetaRede"});

    private String substring(String str, int endIndex) {
        return str.substring(0, str.length() > endIndex ? endIndex : str.length());
    }

    @Override
    public String getTagCodigo() {
        return "empresa";
    }

    @Override
    public RetornoImpressaoEtiquetas exportarExames(String codLabExterno, String numeroLote, String configuracaoLabExterno, boolean reenvio, List<Registro> requisicoes, int colunaOrdenacao, boolean isColetaWeb, int agruparInterface, Statement st, Statement st2, Statement st3, String variaveisLogin, boolean agruparGuiasInterface, String imprimirEtiquetaTriagemSemMaterial, boolean imprimirEtiquetaColetaSemMaterial, boolean imprimirEtiquetaColetaSelecionadaSemMaterial, boolean agruparEtqPorQtde, String tipoExportacaoInterface, int digitosTuboFilial, int digitosTuboRequisicao, int digitosTuboTubo, boolean tuboPrimario, boolean utilizarCapacidadeTuboPrimario, String tipoIntegracao, String tamanhoNomeImpressora, String[] impressorasLocais, ImpressorasLabExterno impressoras, String tipoEtiquetaSoroteca, Callable<Boolean> arquivar, Callable<Boolean> anular, LaboratorioExterno labExterno, boolean agruparMultiguia) {
        RetornoImpressaoEtiquetas retorno = new RetornoImpressaoEtiquetas();
        try {
            String msg;
            if (agruparGuiasInterface) {
                requisicoes = ExportacaoParaRede.agruparMutiguia(requisicoes, st, agruparGuiasInterface, digitosTuboFilial);
            }
            this.criarEtiquetas(isColetaWeb, requisicoes, agruparInterface, st, st2, st3, Variaveis.login, agruparGuiasInterface, imprimirEtiquetaTriagemSemMaterial, imprimirEtiquetaColetaSemMaterial, imprimirEtiquetaColetaSelecionadaSemMaterial, agruparEtqPorQtde, tipoExportacaoInterface, digitosTuboFilial, digitosTuboRequisicao, digitosTuboTubo, tuboPrimario, utilizarCapacidadeTuboPrimario, arquivar);
            for (Registro reg : requisicoes) {
                this.recuperaInformacoes(st, reg);
            }
            if (!this.preencheEtiquetaExames(requisicoes, st, reenvio, configuracaoLabExterno)) {
                retorno.setImprimiu(false);
                return retorno;
            }
            if (StringUtil.getValor(configuracaoLabExterno, "utilizaFaixa").equals("true") && !Funcoes.textoVazio(msg = this.validaExames(st, requisicoes))) {
                Funcoes.mensagem(null, "Os seguintes exames n\u00e3o possuem etiqueta de coleta:\n" + msg, 2);
                retorno.setImprimiu(false);
                return retorno;
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ExportacaoParaRede - exportaExames");
        }
        try {
            arquivar.call();
            String arquivo = this.montaArquivo(configuracaoLabExterno, requisicoes);
            String nomeArquivo = StringUtil.getValor(configuracaoLabExterno, "empresa") + Funcoes.preencheVazio(numeroLote, "0", 5, 1) + ".txt";
            if (isColetaWeb) {
                retorno.setNomeArquivoLote(nomeArquivo);
                retorno.setXmlLote(arquivo);
                retorno.setExtensaoArquivo("txt");
                this.emiteEtiquetas(codLabExterno, numeroLote, configuracaoLabExterno, reenvio, isColetaWeb, st, arquivar, anular, retorno, digitosTuboFilial, digitosTuboRequisicao);
                retorno.setImprimiu(true);
                return retorno;
            }
            JFileChooser chooser = ComponenteFactory.novoJFileChooser(null, Variaveis.ultimoDiretorioDialogo != null ? Variaveis.ultimoDiretorioDialogo.getAbsolutePath() : null, reenvio ? null : "Lote j\u00e1 foi criado se necessitar gerar o arquivo utilize a op\u00e7\u00e3o de reenvio de lote!");
            chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
            chooser.setSelectedFile(new File(nomeArquivo));
            chooser.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo de exporta\u00e7\u00e3o Rede (*.txt)", "txt"));
            int option = chooser.showOpenDialog(null);
            if (option == 0) {
                FileWriter writer = new FileWriter(chooser.getSelectedFile());
                writer.write(arquivo);
                writer.close();
                this.emiteEtiquetas(codLabExterno, numeroLote, configuracaoLabExterno, reenvio, isColetaWeb, st, arquivar, anular, retorno, digitosTuboFilial, digitosTuboRequisicao);
                retorno.setImprimiu(true);
                return retorno;
            }
            if (option == 1) {
                retorno.setImprimiu(true);
                return retorno;
            }
        }
        catch (SQLException | ParseException e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ExportacaoParaRede - exportaExames");
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "ExportacaoParaRede - exportarExames");
        }
        retorno.setImprimiu(false);
        return retorno;
    }

    private void emiteEtiquetas(String codLabExterno, String numeroLote, String configuracaoLabExterno, boolean reenvio, boolean isColetaWeb, Statement st, Callable<Boolean> arquivar, Callable<Boolean> anular, RetornoImpressaoEtiquetas retorno, int digitosTuboFilial, int digitosTuboRequisicao) throws Exception {
        if (!reenvio) {
            Integer aux = Integer.parseInt(numeroLote);
            StringBuilder conf = new StringBuilder(configuracaoLabExterno);
            StringUtil.setValor(conf, "lote", String.valueOf(aux));
            if (this.validaAtualizacaoFaixa(this.ultimaFaixa, configuracaoLabExterno)) {
                StringUtil.setValor(conf, "ultimaFaixa", String.valueOf(this.ultimaFaixa));
            }
            StringBuilder buf = new StringBuilder();
            buf.append(" update labexterno ");
            buf.append("    set lae_configuracao = '").append(conf.toString()).append("' ");
            buf.append("  where fil_codigo = ").append(Variaveis.filialPadrao);
            buf.append("    and lae_codigo = ").append(codLabExterno);
            if (isColetaWeb) {
                st.executeUpdate(buf.toString());
            } else {
                Conexao.executeUpdate(Variaveis.filialPadrao, Conexao.getStatement(), buf.toString());
            }
            arquivar.call();
        }
        ExportacaoParaRede.emitirEtiquetasRede(codLabExterno, numeroLote, configuracaoLabExterno, st, digitosTuboFilial, digitosTuboRequisicao);
        if (etiquetas.getRowCount() > 0) {
            ArrayList<Object> etiquetaslist;
            ImpressaoTermica termica = new ImpressaoTermica(Impressao.comparaNomeImpressoraReduzido(ParametrosLocais.getParametro("impressoraEtqColeta")), isColetaWeb);
            termica.setDados(etiquetas);
            List<Object> list = etiquetaslist = retorno.getEtiquetasLabExterno() != null && !retorno.getEtiquetasLabExterno().isEmpty() ? retorno.getEtiquetasLabExterno().get("rede") : new ArrayList<Object>();
            if (isColetaWeb) {
                etiquetaslist.add(termica.imprimir(StringUtil.getValor(configuracaoLabExterno, "modeloEtiqueta"), st, isColetaWeb, arquivar, anular));
                HashMap<String, List<byte[]>> etiquetasLab = new HashMap<String, List<byte[]>>();
                ArrayList etq = retorno.getEtiquetasLabExterno() != null && !retorno.getEtiquetasLabExterno().isEmpty() ? retorno.getEtiquetasLabExterno().get("mercolab") : new ArrayList();
                etiquetaslist.addAll(etq);
                etiquetasLab.put("rede", etiquetaslist);
                retorno.setEtiquetasLabExterno(etiquetasLab);
            } else {
                termica.imprimir(StringUtil.getValor(configuracaoLabExterno, "modeloEtiqueta"));
            }
            etiquetas.clear();
        }
    }

    private String montaArquivo(String configuracaoLabExterno, List<Registro> requisicoes) throws SQLException, ParseException {
        StringBuilder buf = new StringBuilder();
        for (Registro r : requisicoes) {
            buf.append(1).append("|");
            buf.append(StringUtil.getValor(configuracaoLabExterno, "empresa")).append("|");
            buf.append(r.getInt("pac_codigo")).append("|");
            buf.append(this.contaRequisicoes(r.getInt("fil_codigo"), r.getInt("pac_codigo"))).append("|");
            buf.append(StringUtil.removerAcentos(r.getString("pac_nome"))).append("|");
            buf.append(Funcoes.formataData("dd/MM/yyyy", r.getDate("pac_datanasc"))).append("|");
            buf.append(this.substring(r.getString("pac_sexo"), 1)).append("|");
            buf.append(r.getInt("pac_peso")).append("|");
            buf.append(r.getDouble("pac_altura") * 100.0).append("|");
            buf.append(this.getMedicamentos(r.getInt("fil_codigo"), r.getInt("req_codigo"))).append("|");
            buf.append(Funcoes.formataData("dd/MM/yyyy", r.getDate("req_dum"))).append("|");
            buf.append(this.substring(StringUtil.removerAcentos(r.getString("req_obs")), 400));
            buf.append(this.getExames(r, configuracaoLabExterno));
            buf.append("\n");
        }
        return buf.toString();
    }

    private boolean validaAtualizacaoFaixa(int ultimaFaixa, String configuracaoLabExterno) {
        if (!Funcoes.textoVazio(configuracaoLabExterno) && ultimaFaixa > 0) {
            String ultimaFaixaLab = StringUtil.getValor(configuracaoLabExterno, "ultimaFaixa");
            return !Funcoes.textoVazio(ultimaFaixaLab) && ultimaFaixa > Integer.valueOf(ultimaFaixaLab);
        }
        return false;
    }

    @Override
    public byte[] imprimeRelatorio(boolean isColetaWeb, String codLabExterno, String numeroLote, List<Registro> requisicoesListaOriginal, int colunaOrdenacao, Statement st, int filialPadrao, int digitosTuboRequisicao, int digitosTuboFilial, String impressoraRelatorio) throws Exception {
        RelatorioSituacaoLote rel = new RelatorioSituacaoLote();
        ModeloGridTable modelo = rel.getModeloDados(st, new String[]{String.valueOf(numeroLote)}, new String[]{String.valueOf(codLabExterno)}, colunaOrdenacao, requisicoesListaOriginal, filialPadrao, digitosTuboRequisicao, digitosTuboFilial);
        if (modelo.getRowCount() > 0) {
            Gerador gerador = new Gerador(impressoraRelatorio);
            HashMap<String, Object> variaveis = new HashMap<String, Object>();
            variaveis.put("filtroLote", numeroLote);
            String xmlRelatorio = rel.getXMLRelatorio(st);
            if (!isColetaWeb) {
                JDialog dialogo = new JDialog((Frame)Laboratorio.getInstancia(), "Relat\u00f3rio de lote enviado");
                dialogo.setModal(true);
                dialogo.setSize(new Dimension(750, 600));
                dialogo.setLayout(new BorderLayout());
                gerador.setPai(dialogo.getContentPane());
                gerador.setPreVisualizar(true);
                gerador.setZoomPreVisualizar(0.5f);
                gerador.setAcaoFechar(dialogo::dispose);
                gerador.executar(xmlRelatorio, (TableModel)modelo, variaveis);
                ScreenUtil.centralizar(dialogo);
                dialogo.setVisible(true);
            } else {
                gerador.executar(xmlRelatorio, modelo, variaveis, false, true, isColetaWeb);
                return Impressao.gerarPdfRelatorio(gerador.getRelatorio(), xmlRelatorio);
            }
        }
        return new byte[0];
    }

    public static void emitirEtiquetasRede(String codLabExterno, String numeroLote, String configuracaoLabExterno, Statement st, int digitosTuboFilial, int digitosTuboRequisicao) throws SQLException {
        if (StringUtil.getValor(configuracaoLabExterno, "utilizaFaixa").equals("true")) {
            StringBuilder buf = new StringBuilder("Select ");
            buf.append("a.fil_codigo, f.mco_descricao as descricaoMaterial, a.req_codigo, a.exa_codigo, a.mco_codigo, g.ele_xmllabexterno, e.pac_codigo as pacienteCodigo, e.pac_nome as pacienteNome, a.exr_codetiquetaoffline as etiquetaRede ");
            buf.append("from examerequisicao a ");
            buf.append("left join requisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo ");
            buf.append("left join loteexternoexamerequisicao c on a.fil_codigo = c.fil_kodigo and a.req_codigo = c.req_codigo and a.exa_codigo = c.exa_codigo and a.mco_codigo = c.mco_codigo ");
            buf.append("left join examematcoleta d on a.fil_codigo = d.fil_codigo  and a.exa_codigo = d.exa_codigo and a.mco_codigo = d.mco_codigo ");
            buf.append("left join paciente e on b.fil_codigo = e.fil_codigo and b.pac_codigo = e.pac_codigo ");
            buf.append("left join materialcoleta f on a.fil_codigo = f.fil_codigo and a.mco_codigo = f.mco_codigo ");
            buf.append("left join examematcoletalabexterno g on a.fil_codigo = g.fil_codigo and a.exa_codigo = g.exa_codigo and a.mco_codigo = g.mco_codigo and c.lae_codigo = g.lae_codigo ");
            buf.append("where c.fil_codigo = ").append(Variaveis.filialPadrao);
            buf.append(" and c.lex_codigo = ").append(numeroLote);
            buf.append(" and c.lae_codigo = ").append(codLabExterno);
            buf.append(" and g.ele_xmllabexterno is not null ");
            buf.append(" and a.exr_excluido = false ");
            buf.append(" and g.ele_xmllabexterno is not null and g.ele_xmllabexterno <> '' ");
            buf.append(" order by a.fil_codigo, a.req_codigo, a.exr_codetiquetaoffline ");
            ResultSet rs = st.executeQuery(buf.toString());
            String etiqueta = "";
            StringBuilder examesRede = new StringBuilder("");
            int line = 0;
            while (rs.next()) {
                if (null != rs.getString("etiquetaRede") && !etiqueta.equalsIgnoreCase(rs.getString("etiquetaRede"))) {
                    etiqueta = rs.getString("etiquetaRede");
                    line = ExportacaoParaRede.addEtiqueta(rs, examesRede, digitosTuboFilial, digitosTuboRequisicao);
                    examesRede = new StringBuilder("");
                }
                examesRede.append(Funcoes.preencheVazio(StringUtil.getValor(rs.getString("ele_xmllabexterno"), "codigo"), 8, 2)).append(" ");
                etiquetas.setValueAt(examesRede.toString(), line, 3);
            }
        }
    }

    private static int addEtiqueta(ResultSet rs, StringBuilder exames, int digitosTuboFilial, int digitosTuboRequisicao) throws SQLException {
        etiquetas.addLine(new String[]{Funcoes.preencheZero(rs.getString("fil_codigo"), digitosTuboFilial).concat(Funcoes.preencheZero(rs.getString("req_codigo"), digitosTuboRequisicao)), rs.getString("pacienteNome"), rs.getString("descricaoMaterial"), exames.toString(), rs.getString("etiquetaRede")});
        return etiquetas.getRowCount() - 1;
    }

    private int contaRequisicoes(Integer codigoFilial, Integer codigoPaciente) throws SQLException {
        Statement st = Conexao.getStatement();
        StringBuilder buf = new StringBuilder();
        buf.append(" select count(1) as qtde ");
        buf.append("   from requisicao ");
        buf.append("  where fil_codigo = ").append(codigoFilial);
        buf.append("    and pac_codigo = ").append(codigoPaciente);
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        if (rs.next()) {
            return rs.getInt("qtde");
        }
        return 0;
    }

    private String getMedicamentos(Integer codigoFilial, Integer codigoRequisicao) throws SQLException {
        Statement st = Conexao.getStatement();
        StringBuilder buf = new StringBuilder();
        buf.append(" select mto_descricao ");
        buf.append("   from requisicaomedicamento rem ");
        buf.append("   join medicamentos mto on rem.fil_codigo = mto.fil_codigo and rem.mto_codigo = mto.mto_codigo ");
        buf.append("  where rem.fil_codigo = ").append(codigoFilial);
        buf.append("    and rem.req_codigo = ").append(codigoRequisicao);
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        if (rs.next()) {
            StringBuilder bufMed = new StringBuilder();
            do {
                if (bufMed.length() > 0) {
                    buf.append(", ");
                }
                buf.append(rs.getString("mto_descricao"));
            } while (rs.next());
            return bufMed.toString();
        }
        return "";
    }

    private String getExames(Registro r, String configuracaoLabExterno) throws SQLException {
        List exames = (List)r.getValor("listaexames");
        StringBuilder buf = new StringBuilder();
        for (Registro exa : exames) {
            buf.append("\n");
            buf.append(2).append("|");
            buf.append(this.substring(exa.getString("exa_codigo") + Funcoes.preencheZero(exa.getInt("mco_codigo"), 2), 15)).append("|");
            buf.append(this.substring(StringUtil.removerAcentos(exa.getString("mco_descricao")), 15)).append("|");
            buf.append(this.substring(exa.getBoolean("mco_solicitarmat") ? StringUtil.removerAcentos(exa.getString("exr_descricaomaterial")) : "", 15)).append("|");
            buf.append("|");
            buf.append(this.substring(exa.getString("exr_codetiquetaoffline"), 12)).append("|");
            buf.append(this.substring(exa.getString("exr_obs"), 40)).append("|");
            buf.append("|");
            buf.append("|");
            buf.append(exa.getBoolean("exr_urgente") ? 1 : 0).append("|");
            buf.append("|");
        }
        return buf.toString();
    }

    private boolean preencheEtiquetaExames(List<Registro> requisicoes, Statement st, boolean reenvio, String configuracaoLabExterno) throws SQLException {
        StringBuilder bui = new StringBuilder();
        boolean utilizaFaixa = StringUtil.getValor(configuracaoLabExterno, "utilizaFaixa").equals("true");
        int ultimaFaixa = 0;
        int faixaInicial = 0;
        int faixaFinal = 0;
        if (utilizaFaixa) {
            ultimaFaixa = StringUtil.getInt(configuracaoLabExterno, "ultimaFaixa");
            faixaInicial = StringUtil.getInt(configuracaoLabExterno, "faixaInicial");
            faixaFinal = StringUtil.getInt(configuracaoLabExterno, "faixaFinal");
        }
        ArrayList<String[]> etiquetasGeradas = new ArrayList<String[]>();
        for (Registro reg : requisicoes) {
            if (reenvio) {
                boolean etiquetasOk = true;
                for (Registro regEx : (List)reg.getValor("listaexames")) {
                    if (!Funcoes.textoVazio(regEx.getString("exr_codetiquetaoffline"))) continue;
                    etiquetasOk = false;
                    break;
                }
                if (etiquetasOk) continue;
            }
            EtiquetasExameRede etiquetas = new EtiquetasExameRede((Frame)Laboratorio.getInstancia(), reg, configuracaoLabExterno);
            for (Registro regEx : (List)reg.getValor("listaexames")) {
                etiquetas.adicionarExames(regEx.getString("exa_codigo"), ExameUtil.getDadosMaterial(reg.getString("fil_codigo"), regEx.getInt("mco_codigo")), regEx.getString("exa_descricao"), regEx.getString("exr_codetiquetaoffline"), regEx.getValor("etiquetaDigitada") != null ? regEx.getBoolean("etiquetaDigitada") : false);
            }
            if (utilizaFaixa) {
                ultimaFaixa = etiquetas.preencheFaixa(ultimaFaixa, faixaInicial, faixaFinal);
            } else {
                etiquetas.setVisible(true);
            }
            if (etiquetas.isOK() || utilizaFaixa) {
                if (utilizaFaixa) {
                    ultimaFaixa = etiquetas.getUltimaFaixaUltilizada();
                }
                for (Registro regEx : (List)reg.getValor("listaexames")) {
                    int pos = etiquetas.localizaExame(regEx.getString("exa_codigo"), ExameUtil.getDadosMaterial(reg.getString("fil_codigo"), regEx.getInt("mco_codigo")));
                    String etiqueta = etiquetas.getEtiqueta(pos);
                    bui.setLength(0);
                    bui.append("update examerequisicao set exr_codetiquetaoffline = '").append(etiqueta).append("'");
                    bui.append(" where fil_codigo = ").append(reg.getInt("fil_codigo"));
                    bui.append(" and exa_codigo = '").append(regEx.getString("exa_codigo")).append("'");
                    bui.append(" and mco_codigo = ").append(regEx.getInt("mco_codigo"));
                    bui.append(" and req_codigo = ").append(reg.getInt("req_codigo"));
                    Conexao.execute(reg.getString("fil_codigo"), st, bui.toString());
                    regEx.setValor("exr_codetiquetaoffline", etiqueta);
                    etiquetasGeradas.add(new String[]{reg.getString("fil_codigo"), reg.getString("req_codigo"), regEx.getString("exa_codigo"), regEx.getString("mco_descricao"), regEx.getString("exr_codetiquetaoffline")});
                }
                this.ultimaFaixa = ultimaFaixa;
                continue;
            }
            return false;
        }
        if (utilizaFaixa && etiquetasGeradas.size() > 0) {
            new EtiquetasGeradas((Frame)Laboratorio.getInstancia(), etiquetasGeradas).setVisible(true);
        }
        return true;
    }

    private void recuperaInformacoes(Statement st, Registro reg) throws SQLException {
        StringBuilder bui = new StringBuilder();
        bui.append("select a.req_urgente, a.med_crm, a.med_uf, a.med_conselho, b.med_nome ");
        bui.append("from requisicao a ");
        bui.append("left join medico b ");
        bui.append(" on a.med_crm = b.med_crm ");
        bui.append(" and a.fil_codigo = b.fil_codigo ");
        bui.append(" and a.med_uf = b.med_uf ");
        bui.append(" and a.med_conselho = b.med_conselho ");
        bui.append("left join paciente c ");
        bui.append(" on a.fil_codigo = c.fil_codigo ");
        bui.append(" and a.pac_codigo = c.pac_codigo ");
        bui.append("where a.fil_codigo = ").append(reg.getInt("fil_codigo"));
        bui.append(" and a.req_codigo = ").append(reg.getInt("req_codigo"));
        bui.append(" and a.req_excluida = false ");
        ResultSet res = st.executeQuery(bui.toString());
        if (res.next()) {
            reg.setValor("req_urgente", res.getBoolean("req_urgente"));
            reg.setValor("med_crm", res.getString("med_crm"));
            reg.setValor("med_nome", res.getString("med_nome"));
            reg.setValor("med_uf", res.getString("med_uf"));
            reg.setValor("med_conselho", res.getString("med_conselho"));
        }
        for (Registro regEx : (List)reg.getValor("listaexames")) {
            bui.setLength(0);
            bui.append("select a.exr_codetiquetaoffline, b.exa_descricao, c.mco_descricao, coalesce(a.exr_urgente, false) as exr_urgente ");
            bui.append(" from examerequisicao a");
            bui.append(" left join exames b on a.fil_codigo = b.fil_codigo");
            bui.append(" and a.exa_codigo = b.exa_codigo");
            bui.append(" left join materialcoleta c on a.fil_codigo = c.fil_codigo");
            bui.append(" and a.mco_codigo = c.mco_codigo");
            bui.append(" where a.fil_codigo = ").append(reg.getInt("fil_codigo"));
            bui.append(" and a.exa_codigo = '").append(regEx.getString("exa_codigo")).append("'");
            bui.append(" and a.mco_codigo = ").append(regEx.getInt("mco_codigo"));
            bui.append(" and a.req_codigo = ").append(reg.getInt("req_codigo"));
            bui.append(" and a.exr_excluido = false ");
            res = st.executeQuery(bui.toString());
            if (!res.next()) continue;
            regEx.setValor("exa_descricao", res.getString("exa_descricao"));
            regEx.setValor("exr_codetiquetaoffline", res.getString("exr_codetiquetaoffline"));
            regEx.setValor("mco_descricao", res.getString("mco_descricao"));
            if (!res.getBoolean("exr_urgente") || reg.getBoolean("req_urgente")) continue;
            reg.setValor("req_urgente", true);
        }
    }

    private String validaExames(Statement st, List<Registro> requisicoes) throws SQLException {
        StringBuilder ret = new StringBuilder();
        StringBuilder buf = new StringBuilder("select distinct a.fil_codigo, a.req_codigo, a.exa_codigo, b.ere_tipo from examerequisicao a ");
        buf.append("left join examerequisicaorecipiente b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo and a.exa_codigo = b.exa_codigo and a.mco_codigo = b.mco_codigo ");
        buf.append("where ( ");
        for (Registro reg : requisicoes) {
            buf.append(" \n(a.fil_codigo = ").append(reg.getString("fil_codigo"));
            buf.append("  and  a.req_codigo =").append(reg.getString("req_codigo")).append(" and (");
            List exames = (List)reg.getValor("listaexames");
            for (Registro exa : exames) {
                buf.append("(a.exa_codigo = '").append(exa.getString("exa_codigo")).append("'");
                buf.append(" and  a.mco_codigo = ").append(exa.getInt("mco_codigo")).append(")");
                if ((exa.getString("exa_codigo") + exa.getString("mco_codigo")).equals(((Registro)exames.get(exames.size() - 1)).getString("exa_codigo") + ((Registro)exames.get(exames.size() - 1)).getString("mco_codigo"))) continue;
                buf.append(" or ");
            }
            buf.append("))");
            if (reg.getString("req_codigo").equals(requisicoes.get(requisicoes.size() - 1).getString("req_codigo"))) continue;
            buf.append(" or ");
        }
        buf.append(") ");
        buf.append(" and  (b.ere_tipo <> '").append("T").append("' and  b.ere_tipo <> '").append("C").append("' or b.ere_tipo is null ) order by a.fil_codigo, a.req_codigo ");
        ResultSet rs = Conexao.executeQuery(st, buf);
        String codigoReq = "";
        while (rs.next()) {
            if (!rs.getString("req_codigo").equals(codigoReq)) {
                codigoReq = rs.getString("req_codigo");
                ret.append("\n Req.: ").append(rs.getString("req_codigo")).append(" Exames: ").append(rs.getString("exa_codigo"));
                continue;
            }
            ret.append(", ").append(rs.getString("exa_codigo"));
        }
        return ret.toString();
    }

    @Override
    public int getMaiorCodigoLote(String numeroLote, String codigoConvenio, LaboratorioExterno configuracaoLabExterno, Statement st) {
        try {
            ResultSet rs = st.executeQuery("select max(lex_codigo) + 1 as codigo from loteexterno where lae_codigo = " + configuracaoLabExterno.codigoLab + " and fil_codigo = " + Variaveis.filialPadrao);
            if (rs.next()) {
                return rs.getInt("codigo");
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return 0;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }
}

